<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

function greenshift_plugin_register_my_pattern_categories()
{
    register_block_pattern_category(
        'greenshiftwireframes',
        array('label' => __('Greenshift Wireframes', 'greenshift-animation-and-page-builder-blocks'))
    );

    register_block_pattern_category(
        'greenshiftelements',
        array('label' => __('Greenshift Elements', 'greenshift-animation-and-page-builder-blocks'))
    );


    register_block_pattern(
        'greenshift/buttonone',
        array(
            'title'       => __('Button Style', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftelements'),
            'keywords' => array('button', 'cta'),
            'description' => _x('button with secondary label and icon', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/button {"id":"gsbp-1deff068-ceea","spacing":{"margin":{"values":{"bottom":[20]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":30,"topRight":30,"bottomRight":30,"bottomLeft":30},"unit":"px","locked":true}},"typography":{"textShadow":{"hShadow":"0","vShadow":"0","blur":"1","color":"#0000001a"},"size":[19],"customweight":"bold"},"csstransform":{"time":0.3,"scaleHover":[1.2]},"buttonLink":"#","enableIcon":true,"iconBox_icon":{"icon":{"font":"rhicon rhi-shield-check","svg":"","image":""},"fill":"#ffffff","fillhover":"","type":"font","iconSize":[22]},"enableLabel":true,"label":"Just one day","typographyLabel":{"textShadow":{},"size":[15]}} -->
        <div id="gspb_button-id-gsbp-1deff068-ceea" class="gspb_button_wrapper gspb_button-id-gsbp-1deff068-ceea wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" href="#" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-icon"><svg class="" style="display:inline-block;vertical-align:middle" width="15" height="15" viewbox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M933 167.4l-384-160c-10.902-4.648-23.586-7.35-36.9-7.35s-25.998 2.702-37.531 7.588l0.631-0.238-384 160c-35.8 14.8-59.2 49.8-59.2 88.6 0 397 229 671.4 443 760.6 23.6 9.8 50.2 9.8 73.8 0 171.4-71.4 443.2-318 443.2-760.6 0-38.8-23.4-73.8-59-88.6zM838.6 395.8l-368 368c-12.4 12.4-32.8 12.4-45.2 0l-208-208c-12.4-12.4-12.4-32.8 0-45.2l45.2-45.2c12.4-12.4 32.8-12.4 45.2 0l140.2 140.2 300.2-300.2c12.4-12.4 32.8-12.4 45.2 0l45.2 45.2c12.6 12.6 12.6 32.8 0 45.2z"></path></svg></span><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Buy This Now!</span><span class="gspb-buttonbox-label">Just one day</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button -->',
        )
    );

    register_block_pattern(
        'greenshift/circlelist',
        array(
            'title'       => __('List with checkmarks', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftelements'),
            'blockTypes'    => array('greenshift-blocks/iconlist'),
            'keywords' => array('icons', 'list'),
            'description' => _x('List with check marks', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/iconlist {"id":"gsbp-275aa13f-3a28","iconsList":[{"icon":{"icon":{"font":"rhicon rhi-check","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Product, Review, Listing, How To, Event, FAQ, Video schemas"},{"icon":{"icon":{"font":"rhicon rhi-check","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Comparison Table builder"},{"icon":{"icon":{"font":"rhicon rhi-check","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Link parser, Link Hidder for Offer blocks and listings"},{"icon":{"icon":{"font":"rhicon rhi-check","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Special mobile layouts for all blocks and statistic extension"}],"textTag":"","colorGlobal":"#635cff","iconBox":true,"iconBoxBg":"#f1f0ff","iconBoxPadding":7,"currentItem":"0","spacing":{"margin":{"values":{"bottom":[40]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"overflow":[null,null,null,null]},"spacingList":{"margin":{"values":{"bottom":[12]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"overflow":[null,null,null,null]},"animation":{"duration":700,"easing":"ease","usegsap":false,"y":"","o":"","stagger":"","x":"","z":"","s":"","r":"","rx":"","ry":"","text":"","texttype":"","textdelay":"","textrandom":"","staggerdelay":"","staggerrandom":"","origin":"","anchor":""}} -->
        <div id="gspb_iconsList-id-gsbp-275aa13f-3a28" class="gspb_iconsList gspb_iconsList-id-gsbp-275aa13f-3a28 wp-block-greenshift-blocks-iconlist"><div class="gspb_iconsList__item" data-id="0"><span class="gspb_iconsList__iconbox"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M871.696 166.932l-526.088 526.088-193.304-193.304c-9.372-9.372-24.568-9.372-33.942 0l-56.568 56.568c-9.372 9.372-9.372 24.568 0 33.942l266.842 266.842c9.372 9.372 24.568 9.372 33.942 0l599.626-599.626c9.372-9.372 9.372-24.568 0-33.942l-56.568-56.568c-9.372-9.372-24.568-9.372-33.94 0z"></path></svg></span><span class="gspb_iconsList__item__text">Product, Review, Listing, How To, Event, FAQ, Video schemas</span></div><div class="gspb_iconsList__item" data-id="1"><span class="gspb_iconsList__iconbox"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M871.696 166.932l-526.088 526.088-193.304-193.304c-9.372-9.372-24.568-9.372-33.942 0l-56.568 56.568c-9.372 9.372-9.372 24.568 0 33.942l266.842 266.842c9.372 9.372 24.568 9.372 33.942 0l599.626-599.626c9.372-9.372 9.372-24.568 0-33.942l-56.568-56.568c-9.372-9.372-24.568-9.372-33.94 0z"></path></svg></span><span class="gspb_iconsList__item__text">Comparison Table builder</span></div><div class="gspb_iconsList__item" data-id="2"><span class="gspb_iconsList__iconbox"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M871.696 166.932l-526.088 526.088-193.304-193.304c-9.372-9.372-24.568-9.372-33.942 0l-56.568 56.568c-9.372 9.372-9.372 24.568 0 33.942l266.842 266.842c9.372 9.372 24.568 9.372 33.942 0l599.626-599.626c9.372-9.372 9.372-24.568 0-33.942l-56.568-56.568c-9.372-9.372-24.568-9.372-33.94 0z"></path></svg></span><span class="gspb_iconsList__item__text">Link parser, Link Hidder for Offer blocks and listings</span></div><div class="gspb_iconsList__item" data-id="3"><span class="gspb_iconsList__iconbox"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M871.696 166.932l-526.088 526.088-193.304-193.304c-9.372-9.372-24.568-9.372-33.942 0l-56.568 56.568c-9.372 9.372-9.372 24.568 0 33.942l266.842 266.842c9.372 9.372 24.568 9.372 33.942 0l599.626-599.626c9.372-9.372 9.372-24.568 0-33.942l-56.568-56.568c-9.372-9.372-24.568-9.372-33.94 0z"></path></svg></span><span class="gspb_iconsList__item__text">Special mobile layouts for all blocks and statistic extension</span></div></div>
        <!-- /wp:greenshift-blocks/iconlist -->',
        )
    );

    register_block_pattern(
        'greenshift/gridfour',
        array(
            'title'       => __('Container grid 4 items', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftelements'),
            'blockTypes'    => array('greenshift-blocks/container'),
            'keywords' => array('container', 'grid'),
            'description' => _x('CSS grid with 4 items', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/container {"id":"gsbp-4c17b724-ca9b","flexbox":{"type":"grid","gridcolumns":[4,2,2,1],"columngap":[30],"rowgap":[30]},"align":"wide"} -->
        <div id="gspb_container-id-gsbp-4c17b724-ca9b" class="gspb_container gspb_container-gsbp-4c17b724-ca9b wp-block-greenshift-blocks-container alignwide"><!-- wp:greenshift-blocks/container {"id":"gsbp-267a2853-2ce1"} -->
        <div id="gspb_container-id-gsbp-267a2853-2ce1" class="gspb_container gspb_container-gsbp-267a2853-2ce1 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-6e4da931-488f","background":{"color":"#f7f8fa"},"border":{"borderRadius":{"values":{"topLeft":8,"topRight":8,"bottomRight":8,"bottomLeft":8},"unit":"px","locked":true},"style":{},"size":{},"color":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"left":[25],"top":[25],"right":[25],"bottom":[25]},"unit":["px","px","px","px"],"locked":true}},"shadow":{"hoffsetHover":0,"voffsetHover":15,"blurHover":30,"spreadHover":0,"colorHover":"rgba(119, 123, 146, 0.1)"},"csstransform":{"time":0.4,"easing":"cubic","translateYHover":[-5,null,null,null]},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":["100%"],"unit":["px","px","px","px"]},"heightType":"custom"}} -->
        <div id="gspb_container-id-gsbp-6e4da931-488f" class="gspb_container gspb_container-gsbp-6e4da931-488f wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-a4c72a50-9ab6","type":"boxed","spacing":{"margin":{"values":{"bottom":[20]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"left":[14],"top":[14],"right":[14],"bottom":[14]},"unit":["px","px","px","px"],"locked":true}},"shapeJustify":"flex-start","iconBox_icon":{"icon":{"font":"rhicon rhi-paper-plane","svg":"","image":""},"fill":"#2184f9","fillhover":"#2184f9","iconSize":[26,null,null,null],"type":"font"}} -->
        <div id="gspb_iconBox-id-gsbp-a4c72a50-9ab6" class="gspb_iconBox gspb_iconBox-id-gsbp-a4c72a50-9ab6 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M928 8.6l-896 516.8c-46 26.6-41.4 94.4 7.6 114.6l280.4 116v204c0 60.4 75.6 86.6 113.4 40.6l121.4-147.6 252.8 104.4c38.2 15.8 81.4-8.4 87.6-49.4l128-834.2c8.2-53.4-49.2-91.8-95.2-65.2zM384 960v-177.6l109 45-109 132.6zM832 898.2l-412.4-170.4 399-471.6c9.6-11.2-5.8-26.4-17-16.8l-510.6 435.2-227-93.6 896-517-128 834.2z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-63ba9485-f926","headingTag":"div","headingContent":"First Column","typography":{"customweight":"bold"},"numberCircle":"1","enablesubTitle":true,"subTitle":"Build complex layouts easily with Greenshift plugin","spacingsubTitle":{"margin":{"values":{"top":[15]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typographysubTitle":{"customweight":"normal","color":"#6d6f76"}} -->
        <div id="gspb_heading-id-gsbp-63ba9485-f926" class="gspb_heading gspb_heading-id-gsbp-63ba9485-f926 ">First Column<span class="gspb_heading_subtitle">Build complex layouts easily with Greenshift plugin</span></div>
        <!-- /wp:greenshift-blocks/heading --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-87f3f79d-8326"} -->
        <div id="gspb_container-id-gsbp-87f3f79d-8326" class="gspb_container gspb_container-gsbp-87f3f79d-8326 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-9a738644-5f42","background":{"color":"#f7f8fa"},"border":{"borderRadius":{"values":{"topLeft":8,"topRight":8,"bottomRight":8,"bottomLeft":8},"unit":"px","locked":true},"style":{},"size":{},"color":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"left":[25],"top":[25],"right":[25],"bottom":[25]},"unit":["px","px","px","px"],"locked":true}},"shadow":{"hoffsetHover":0,"voffsetHover":15,"blurHover":30,"spreadHover":0,"colorHover":"rgba(119, 123, 146, 0.1)"},"csstransform":{"time":0.4,"easing":"cubic","translateYHover":[-5,null,null,null]},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":["100%"],"unit":["px","px","px","px"]},"heightType":"custom"}} -->
        <div id="gspb_container-id-gsbp-9a738644-5f42" class="gspb_container gspb_container-gsbp-9a738644-5f42 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-89c80de2-6f5c","type":"boxed","spacing":{"margin":{"values":{"bottom":[20]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"left":[14],"top":[14],"right":[14],"bottom":[14]},"unit":["px","px","px","px"],"locked":true}},"shapeJustify":"flex-start","iconBox_icon":{"icon":{"font":"rhicon rhi-bolt-regular","svg":"","image":""},"fill":"#2184f9","fillhover":"#2184f9","iconSize":[26,null,null,null],"type":"font"}} -->
        <div id="gspb_iconBox-id-gsbp-89c80de2-6f5c" class="gspb_iconBox gspb_iconBox-id-gsbp-89c80de2-6f5c wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 768 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M755.6 335.8c-16.4-28.6-46.2-45.8-79.2-45.8h-188.8l57.4-175c7.4-27.6 1.6-56.6-15.8-79.4-17.6-22.6-44.2-35.6-72.8-35.6h-261c-45.6 0-84.6 34.2-89.6 74.2l-104.8 424.4c-3.8 27.6 4.4 55.4 22.6 76.4s44.6 33 72.4 33h196.2l-69.8 303.4c-6.4 27.4-0.2 55.8 17.2 77.8 17.4 22.2 43.6 34.8 71.8 34.8 32.6 0 63-17.6 77.6-43.2l366.4-553.4c16.8-28.6 16.8-63 0.2-91.6zM320.2 914.8l92.6-402.8h-317.8l100.4-416 255.2-1.8-95.6 291.8h313l-347.8 528.8z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-a15a38f9-8644","headingTag":"div","headingContent":"Second Column","typography":{"customweight":"bold"},"numberCircle":"1","enablesubTitle":true,"subTitle":"Build complex layouts easily with Greenshift plugin","spacingsubTitle":{"margin":{"values":{"top":[15]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typographysubTitle":{"customweight":"normal","color":"#6d6f76"}} -->
        <div id="gspb_heading-id-gsbp-a15a38f9-8644" class="gspb_heading gspb_heading-id-gsbp-a15a38f9-8644 ">Second Column<span class="gspb_heading_subtitle">Build complex layouts easily with Greenshift plugin</span></div>
        <!-- /wp:greenshift-blocks/heading --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-89604589-b3fb"} -->
        <div id="gspb_container-id-gsbp-89604589-b3fb" class="gspb_container gspb_container-gsbp-89604589-b3fb wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-97deaf6f-dc35","background":{"color":"#f7f8fa"},"border":{"borderRadius":{"values":{"topLeft":8,"topRight":8,"bottomRight":8,"bottomLeft":8},"unit":"px","locked":true},"style":{},"size":{},"color":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"left":[25],"top":[25],"right":[25],"bottom":[25]},"unit":["px","px","px","px"],"locked":true}},"shadow":{"hoffsetHover":0,"voffsetHover":15,"blurHover":30,"spreadHover":0,"colorHover":"rgba(119, 123, 146, 0.1)"},"csstransform":{"time":0.4,"easing":"cubic","translateYHover":[-5,null,null,null]},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":["100%"],"unit":["px","px","px","px"]},"heightType":"custom"}} -->
        <div id="gspb_container-id-gsbp-97deaf6f-dc35" class="gspb_container gspb_container-gsbp-97deaf6f-dc35 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-d74a4258-4297","type":"boxed","spacing":{"margin":{"values":{"bottom":[20]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"left":[14],"top":[14],"right":[14],"bottom":[14]},"unit":["px","px","px","px"],"locked":true}},"shapeJustify":"flex-start","iconBox_icon":{"icon":{"font":"rhicon rhi-gem","svg":"","image":""},"fill":"#2184f9","fillhover":"#2184f9","iconSize":[26,null,null,null],"type":"font"}} -->
        <div id="gspb_iconBox-id-gsbp-d74a4258-4297" class="gspb_iconBox gspb_iconBox-id-gsbp-d74a4258-4297 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1152 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M927.4 0h-702.8c-8.4 0-16.2 4.4-20.6 11.6l-200.6 325.6c-5.4 8.8-4.4 20.2 2.4 28l552 650.4c9.6 11.2 26.8 11.2 36.4 0l552-650.4c6.8-7.8 7.6-19.2 2.4-28l-200.6-325.6c-4.4-7.2-12.2-11.6-20.6-11.6zM900.2 72l148.6 248h-166l-113.6-248h131zM690 72l113.6 248h-455.4l113.8-248h228zM251.8 72h131l-113.6 248h-166l148.6-248zM122.4 384h146l163.6 384-309.6-384zM346.4 384h459l-229.4 527.6-229.6-527.6zM720 768l163.6-384h146l-309.6 384z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-709a2ba9-93ae","headingTag":"div","headingContent":"Third Column","typography":{"customweight":"bold"},"numberCircle":"1","enablesubTitle":true,"subTitle":"Build complex layouts easily with Greenshift plugin","spacingsubTitle":{"margin":{"values":{"top":[15]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typographysubTitle":{"customweight":"normal","color":"#6d6f76"}} -->
        <div id="gspb_heading-id-gsbp-709a2ba9-93ae" class="gspb_heading gspb_heading-id-gsbp-709a2ba9-93ae ">Third Column<span class="gspb_heading_subtitle">Build complex layouts easily with Greenshift plugin</span></div>
        <!-- /wp:greenshift-blocks/heading --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-6a1f41bd-a59f"} -->
        <div id="gspb_container-id-gsbp-6a1f41bd-a59f" class="gspb_container gspb_container-gsbp-6a1f41bd-a59f wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-ba79b8ab-ff55","background":{"color":"#f7f8fa"},"border":{"borderRadius":{"values":{"topLeft":8,"topRight":8,"bottomRight":8,"bottomLeft":8},"unit":"px","locked":true},"style":{},"size":{},"color":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"left":[25],"top":[25],"right":[25],"bottom":[25]},"unit":["px","px","px","px"],"locked":true}},"shadow":{"hoffsetHover":0,"voffsetHover":15,"blurHover":30,"spreadHover":0,"colorHover":"rgba(119, 123, 146, 0.1)"},"csstransform":{"time":0.4,"easing":"cubic","translateYHover":[-5,null,null,null]},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":["100%"],"unit":["px","px","px","px"]},"heightType":"custom"}} -->
        <div id="gspb_container-id-gsbp-ba79b8ab-ff55" class="gspb_container gspb_container-gsbp-ba79b8ab-ff55 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-71ea620c-6e9a","type":"boxed","spacing":{"margin":{"values":{"bottom":[20]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"left":[14],"top":[14],"right":[14],"bottom":[14]},"unit":["px","px","px","px"],"locked":true}},"shapeJustify":"flex-start","iconBox_icon":{"icon":{"font":"rhicon rhi-analytics","svg":"","image":""},"fill":"#2184f9","fillhover":"#2184f9","iconSize":[26,null,null,null],"type":"font"}} -->
        <div id="gspb_iconBox-id-gsbp-71ea620c-6e9a" class="gspb_iconBox gspb_iconBox-id-gsbp-71ea620c-6e9a wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1152 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M160 704h-128c-17.68 0-32 14.32-32 32v256c0 17.68 14.32 32 32 32h128c17.68 0 32-14.32 32-32v-256c0-17.68-14.32-32-32-32zM128 960h-64v-192h64v192zM1120 384h-128c-17.68 0-32 14.32-32 32v576c0 17.68 14.32 32 32 32h128c17.68 0 32-14.32 32-32v-576c0-17.68-14.32-32-32-32zM1088 960h-64v-512h64v512zM1005.54 177.36c14.7 9.12 31.88 14.64 50.46 14.64 53.020 0 96-42.98 96-96s-42.98-96-96-96-96 42.98-96 96c0 11.020 2.24 21.42 5.66 31.28l-179.2 143.36c-14.7-9.14-31.88-14.66-50.46-14.66s-35.76 5.52-50.46 14.66l-179.2-143.36c3.42-9.84 5.66-20.26 5.66-31.28 0-53.020-42.98-96-96-96s-96 42.98-96 96c0 14.8 3.62 28.64 9.6 41.16l-192.44 192.44c-12.52-5.98-26.36-9.6-41.16-9.6-53.020 0-96 42.98-96 96s42.98 96 96 96 96-42.98 96-96c0-14.8-3.62-28.64-9.6-41.16l192.44-192.44c12.52 5.98 26.36 9.6 41.16 9.6 18.58 0 35.76-5.52 50.46-14.66l179.2 143.36c-3.42 9.86-5.66 20.28-5.66 31.3 0 53.020 42.98 96 96 96s96-42.98 96-96c0-11.020-2.24-21.44-5.66-31.3l179.2-143.34zM1056 64c17.64 0 32 14.36 32 32s-14.36 32-32 32-32-14.36-32-32 14.36-32 32-32zM96 448c-17.64 0-32-14.36-32-32s14.36-32 32-32 32 14.36 32 32-14.36 32-32 32zM416 128c-17.64 0-32-14.36-32-32s14.36-32 32-32 32 14.36 32 32-14.36 32-32 32zM736 384c-17.64 0-32-14.36-32-32s14.36-32 32-32 32 14.36 32 32-14.36 32-32 32zM480 384h-128c-17.68 0-32 14.32-32 32v576c0 17.68 14.32 32 32 32h128c17.68 0 32-14.32 32-32v-576c0-17.68-14.32-32-32-32zM448 960h-64v-512h64v512zM800 640h-128c-17.68 0-32 14.32-32 32v320c0 17.68 14.32 32 32 32h128c17.68 0 32-14.32 32-32v-320c0-17.68-14.32-32-32-32zM768 960h-64v-256h64v256z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-fd6284d5-a6c1","headingTag":"div","headingContent":"Fourth Column","typography":{"customweight":"bold"},"numberCircle":"1","enablesubTitle":true,"subTitle":"Build complex layouts easily with Greenshift plugin","spacingsubTitle":{"margin":{"values":{"top":[15]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typographysubTitle":{"customweight":"normal","color":"#6d6f76"}} -->
        <div id="gspb_heading-id-gsbp-fd6284d5-a6c1" class="gspb_heading gspb_heading-id-gsbp-fd6284d5-a6c1 ">Fourth Column<span class="gspb_heading_subtitle">Build complex layouts easily with Greenshift plugin</span></div>
        <!-- /wp:greenshift-blocks/heading --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->',
        )
    );

    register_block_pattern(
        'greenshift/ctablock',
        array(
            'title'       => __('CTA simple banner', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftelements'),
            'blockTypes'    => array('greenshift-blocks/container'),
            'keywords' => array('container', 'grid'),
            'description' => _x('CTA banner block', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/container {"id":"gsbp-7371d10e-a24a","flexbox":{"type":"flexbox","justifyContent":["space-between"],"flexDirection":["row",null,"column","column"],"alignItems":["center"],"marginBottom":[20,null,20,20],"marginRight":[20,null,20,20],"marginLeft":[20,null,20,20],"marginTop":[0,null,20,20],"marginUnit":["px","px","px","px"],"marginLock":false},"background":{"backgroundState":"Gradient","gradient":"linear-gradient(135deg,rgb(1,1,152) 0%,rgb(31,109,246) 100%)"},"border":{"borderRadius":{"values":{"topLeft":5,"topRight":5,"bottomRight":5,"bottomLeft":5},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[20],"right":[10],"bottom":[10],"left":[10]},"unit":["px","px","px","px"],"locked":false}},"className":"gs-banner"} -->
        <div id="gspb_container-id-gsbp-7371d10e-a24a" class="gspb_container gspb_container-gsbp-7371d10e-a24a wp-block-greenshift-blocks-container gs-banner"><!-- wp:greenshift-blocks/heading {"id":"gsbp-c72d30f7-f0cd","headingTag":"div","headingContent":"Get the latest features","typography":{"textShadow":{},"size":[30],"customweight":"bold","color":"#ffffff","alignment":[null,null,"center","center"]},"enablesubTitle":true,"typographysubTitle":{"textShadow":{},"customweight":"normal","color":"#d6d6d6"}} -->
        <div id="gspb_heading-id-gsbp-c72d30f7-f0cd" class="gspb_heading gspb_heading-id-gsbp-c72d30f7-f0cd ">Get the latest features<span class="gspb_heading_subtitle">Build complex layouts easily</span></div>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-a1d11779-ad14","buttonContent":"Check prices!","background":{"color":"","backgroundState":"Classic","overlayOpacity":""},"spacing":{"margin":{"values":{"bottom":[null,null,10,10]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[15],"bottom":[15],"right":[25],"left":[25]},"unit":["px","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":5,"topRight":5,"bottomRight":5,"bottomLeft":5},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"typography":{"textShadow":{},"size":[19]},"csstransform":{"hoverClass":"gs-banner","scaleHover":[1.1],"time":0.5}} -->
        <div id="gspb_button-id-gsbp-a1d11779-ad14" class="gspb_button_wrapper gspb_button-id-gsbp-a1d11779-ad14 wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Check prices!</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button --></div>
        <!-- /wp:greenshift-blocks/container -->',
        )
    );

    //Wireframes

    register_block_pattern(
        'greenshift/ctathreeicons',
        array(
            'title'       => __('Block with CTA', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/button'),
            'keywords' => array('cta', 'features'),
            'description' => _x('Full width Row with CTA', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-b79a3843-d34b","inlineCssStyles":null,"align":"full","width":[1280,null,null,1280],"displayStyles":false,"spacing":{"margin":{"values":{},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":["5","4",null,"3"],"bottom":["5","4",null,"3"]},"unit":["rem","rem","px","px"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-b79a3843-d34b" class="gspb_row gspb_row-id-gsbp-b79a3843-d34b wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-b79a3843-d34b"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-2d8afb59-da3e","inlineCssStyles":null,"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":["2","1.5",null,"1"],"bottom":[0],"left":["2","1.5",null,"1"]},"unit":["rem","rem","px","px"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-2d8afb59-da3e" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-2d8afb59-da3e"><!-- wp:greenshift-blocks/container {"id":"gsbp-7bf3c05c-f052","inlineCssStyles":null,"flexbox":{"type":"flexbox","alignItems":["center"],"enable":false},"background":{"color":"#fafafa"},"border":{"borderRadius":{"values":{"topLeft":"24","topRight":"24","bottomRight":"24","bottomLeft":"24"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"right":["6","2"],"left":["6","2"],"top":["5","5",null,"3"],"bottom":["5","5",null,"3"]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-7bf3c05c-f052" class="gspb_container gspb_container-gsbp-7bf3c05c-f052 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-7889a6b0-ddbd","inlineCssStyles":null,"headingContent":"Create any landing page with Greenshift","spacing":{"margin":{"values":{"top":[null,0],"right":[null,0],"bottom":[null,0],"left":[null,0]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":[null,null],"right":[null,null],"bottom":[null,null],"left":[null,null]},"unit":["px","rem","px","px"],"locked":false}},"typography":{"alignment":["center"],"textShadow":{},"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[3,2.3,null,2],"line_height":[3.5,2.8,null,2.3],"customweight":"custom","customweightnumber":700},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom","maxWidth":["500px"]}} -->
        <h2 id="gspb_heading-id-gsbp-7889a6b0-ddbd" class="gspb_heading gspb_heading-id-gsbp-7889a6b0-ddbd ">Create any landing page with Greenshift</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-5809d985-e53f","inlineCssStyles":null,"flexbox":{"type":"flexbox","flexDirection":["row",null,null,"column"],"enable":false,"columngapUnit":["rem"],"columngap":[2.5],"rowgapUnit":[null,null,null,"rem"],"rowgap":[null,null,null,1]},"spacing":{"margin":{"values":{"top":["3.5","3",null,"2"]},"unit":["rem","rem","px","rem"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"responsive":{"customcss":".gspb_iconsList [data-id=\'0\'] svg{\nmargin: 0 !important;\n}\n.gspb_iconsList__item__text {\n   margin-left: .75rem !important;\n}"}} -->
        <div id="gspb_container-id-gsbp-5809d985-e53f" class="gspb_container gspb_container-gsbp-5809d985-e53f wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconlist {"id":"gsbp-e5fbcd37-7bdf","inlineCssStyles":null,"iconsList":[{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[24,null,null,null],"rotateY":false,"rotateX":false,"type":"font","strokeColor":"","strokeColorHover":"","strokeWidth":""},"content":"150+ UI Blocks"}],"currentItem":"0","typography":{"textShadow":{},"customweight":"custom","customweightnumber":700,"sizeUnit":"rem","size":[1.1],"line_height":[1.8],"lineHeightUnit":["rem"],"color":"#000000"},"responsive":{"customcss":""}} -->
        <div id="gspb_iconsList-id-gsbp-e5fbcd37-7bdf" class="gspb_iconsList gspb_iconsList-id-gsbp-e5fbcd37-7bdf wp-block-greenshift-blocks-iconlist"><div class="gspb_iconsList__item" data-id="0"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">150+ UI Blocks</span></div></div>
        <!-- /wp:greenshift-blocks/iconlist -->
        
        <!-- wp:greenshift-blocks/iconlist {"id":"gsbp-06500dea-42ba","inlineCssStyles":null,"iconsList":[{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[24,null,null,null],"rotateY":false,"rotateX":false,"type":"font","strokeColor":"","strokeColorHover":"","strokeWidth":""},"content":"Fully Responsive"}],"currentItem":"0","typography":{"textShadow":{},"customweight":"custom","customweightnumber":700,"sizeUnit":"rem","size":[1.1],"line_height":[1.8],"lineHeightUnit":["rem"],"color":"#000000"},"responsive":{"customcss":""}} -->
        <div id="gspb_iconsList-id-gsbp-06500dea-42ba" class="gspb_iconsList gspb_iconsList-id-gsbp-06500dea-42ba wp-block-greenshift-blocks-iconlist"><div class="gspb_iconsList__item" data-id="0"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">Fully Responsive</span></div></div>
        <!-- /wp:greenshift-blocks/iconlist -->
        
        <!-- wp:greenshift-blocks/iconlist {"id":"gsbp-8149c387-b7cc","inlineCssStyles":null,"iconsList":[{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[24,null,null,null],"rotateY":false,"rotateX":false,"type":"font","strokeColor":"","strokeColorHover":"","strokeWidth":""},"content":"Just Copy \u0026amp; Paste"}],"currentItem":"0","typography":{"textShadow":{},"customweight":"custom","customweightnumber":700,"sizeUnit":"rem","size":[1.1],"line_height":[1.8],"lineHeightUnit":["rem"],"color":"#000000"},"responsive":{"customcss":""}} -->
        <div id="gspb_iconsList-id-gsbp-8149c387-b7cc" class="gspb_iconsList gspb_iconsList-id-gsbp-8149c387-b7cc wp-block-greenshift-blocks-iconlist"><div class="gspb_iconsList__item" data-id="0"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">Just Copy &amp; Paste</span></div></div>
        <!-- /wp:greenshift-blocks/iconlist --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-f7436eaf-85e2","inlineCssStyles":null,"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"spacing":{"margin":{"values":{"top":["3",null,null,"2"]},"unit":["rem","px","px","rem"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-f7436eaf-85e2" class="gspb_container gspb_container-gsbp-f7436eaf-85e2 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/button {"id":"gsbp-18fa81b1-be09","inlineCssStyles":null,"buttonContent":"Get Greenshift","align":"center","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[".9"],"right":["2.3"],"bottom":[".9"],"left":["2.3"]},"unit":["rem","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":"12","topRight":"12","bottomRight":"12","bottomLeft":"12"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"typography":{"textShadow":{},"customweight":"custom","customweightnumber":700,"sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.5]}} -->
        <div id="gspb_button-id-gsbp-18fa81b1-be09" class="gspb_button_wrapper gspb_button-id-gsbp-18fa81b1-be09 wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Get Greenshift</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-94aa9d1d-9fcf","inlineCssStyles":null,"textContent":"No credit card required","spacing":{"margin":{"values":{"top":[10,"1.3"]},"unit":["px","rem","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[0.9],"line_height":[1.3],"alignment":["center"],"color":"#71717a","colorState":"Gradient"}} -->
        <div id="gspb_text-id-gsbp-94aa9d1d-9fcf" class="gspb_text gspb_text-id-gsbp-94aa9d1d-9fcf ">No credit card required</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/centralfeatures',
        array(
            'title'       => __('Central Features', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('info', 'features'),
            'description' => _x('Central Features', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-b38031b8-9cd6","align":"full","width":[1290,null,null,null],"displayStyles":false,"background":{"color":"#18181b"},"spacing":{"margin":{"values":{"top":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["5","4",null,"3"],"bottom":["5","4",null,"3"],"right":[0],"left":[0]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-b38031b8-9cd6" class="gspb_row gspb_row-id-gsbp-b38031b8-9cd6 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-b38031b8-9cd6"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-2c331885-61a0","flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"alignItems":["center"],"type":"flexbox"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":["2","2","1.5","1"],"bottom":[0],"left":["2","2","1.5","1"]},"unit":["rem","rem","rem","rem"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-2c331885-61a0" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-2c331885-61a0"><!-- wp:greenshift-blocks/container {"id":"gsbp-1f27486b-7d04","flexbox":{"type":"grid","enable":false,"gridcolumns":[3,2,null,1],"columngap":[4,3,null,3],"rowgap":[3,null,null,2],"columngapUnit":["rem","rem"],"rowgapUnit":["rem",null,null,"rem"]}} -->
        <div id="gspb_container-id-gsbp-1f27486b-7d04" class="gspb_container gspb_container-gsbp-1f27486b-7d04 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-202d3d1d-fe44","order":[null,2],"flexbox":{"type":"flexbox","rowgapUnit":["rem","rem",null,"rem"],"rowgap":[4,3,null,2],"enable":false}} -->
        <div id="gspb_container-id-gsbp-202d3d1d-fe44" class="gspb_container gspb_container-gsbp-202d3d1d-fe44 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-3b2b0428-7d1e","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row"],"columngapUnit":["rem"],"columngap":[0.8]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-3b2b0428-7d1e" class="gspb_container gspb_container-gsbp-3b2b0428-7d1e wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-0fc6a547-b786","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-0fc6a547-b786" class="gspb_container gspb_container-gsbp-0fc6a547-b786 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-6fbd2267-e6b8","type":"regular","shadow":{},"background":{},"iconBox_icon":{"icon":{"font":"rhicon rhi-bolt-regular","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[24],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""}} -->
        <div id="gspb_iconBox-id-gsbp-6fbd2267-e6b8" class="gspb_iconBox gspb_iconBox-id-gsbp-6fbd2267-e6b8 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 768 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M755.6 335.8c-16.4-28.6-46.2-45.8-79.2-45.8h-188.8l57.4-175c7.4-27.6 1.6-56.6-15.8-79.4-17.6-22.6-44.2-35.6-72.8-35.6h-261c-45.6 0-84.6 34.2-89.6 74.2l-104.8 424.4c-3.8 27.6 4.4 55.4 22.6 76.4s44.6 33 72.4 33h196.2l-69.8 303.4c-6.4 27.4-0.2 55.8 17.2 77.8 17.4 22.2 43.6 34.8 71.8 34.8 32.6 0 63-17.6 77.6-43.2l366.4-553.4c16.8-28.6 16.8-63 0.2-91.6zM320.2 914.8l92.6-402.8h-317.8l100.4-416 255.2-1.8-95.6 291.8h313l-347.8 528.8z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-d4cd2144-8365","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-d4cd2144-8365" class="gspb_container gspb_container-gsbp-d4cd2144-8365 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-b0134b8e-db04","textContent":"Superpower","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#e4e4e7","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-b0134b8e-db04" class="gspb_text gspb_text-id-gsbp-b0134b8e-db04 ">Superpower</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-796097e0-a084","textContent":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1.2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#71717a","sizeUnit":"rem","size":[0.9],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-796097e0-a084" class="gspb_text gspb_text-id-gsbp-796097e0-a084 ">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-e1545d39-4223","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[0.8],"alignItems":["stretch"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-e1545d39-4223" class="gspb_container gspb_container-gsbp-e1545d39-4223 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-ba546218-e59d","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-ba546218-e59d" class="gspb_container gspb_container-gsbp-ba546218-e59d wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-15fd5f38-2226","type":"regular","shadow":{},"background":{},"iconBox_icon":{"icon":{"font":"rhicon rhi-leaf","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[24],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""}} -->
        <div id="gspb_iconBox-id-gsbp-15fd5f38-2226" class="gspb_iconBox gspb_iconBox-id-gsbp-15fd5f38-2226 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1152 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1092.4 19.4c-5.8-13-17.2-19.4-28.6-19.4-10.6 0-21.4 5.6-28 17-62 107.8-173 175-299.8 175h-160c-212 0-384 172-384 384 0 35.6 5.2 69.8 14.2 102.4-148.2 129-202.6 279.2-203.6 282-8.6 25 4.6 52.4 29.6 61 28 9.6 53.4-7.6 61-29.6 0.8-2.2 42-115 152.6-220.2 75.2 126.4 217.2 202.4 371 186.2 314.2-22.8 535.2-304.4 535.2-649.2 0-100.4-21.6-204.4-59.6-289.2zM606.8 862.4c-172.2 18.2-261.2-109-284.4-153 94.8-65.8 224-117.4 397.8-117.4 26.4 0 48-21.6 48-48s-21.6-48-48-48c-182.6 0-322.2 51-428 118.8-1.8-12.8-4-25.6-4-38.8 0-158.8 129.2-288 288-288h160c115.8 0 223.2-44 304-121.8 10.4 46.4 16 95 16 142.4-0.2 302-187.8 534.8-449.4 553.8z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-43a3c42f-c65a","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-43a3c42f-c65a" class="gspb_container gspb_container-gsbp-43a3c42f-c65a wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-7ed8eb55-92cd","textContent":"New Design","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#e4e4e7","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-7ed8eb55-92cd" class="gspb_text gspb_text-id-gsbp-7ed8eb55-92cd ">New Design</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-550486da-c8a9","textContent":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1.2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#71717a","sizeUnit":"rem","size":[0.9],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-550486da-c8a9" class="gspb_text gspb_text-id-gsbp-550486da-c8a9 ">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-caaa06a1-4f10","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[0.8],"alignItems":["stretch"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-caaa06a1-4f10" class="gspb_container gspb_container-gsbp-caaa06a1-4f10 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-1054936a-fc40","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-1054936a-fc40" class="gspb_container gspb_container-gsbp-1054936a-fc40 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-e128263e-8134","type":"regular","shadow":{},"background":{},"iconBox_icon":{"icon":{"font":"rhicon rhi-play-circle","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[24],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""}} -->
        <div id="gspb_iconBox-id-gsbp-e128263e-8134" class="gspb_iconBox gspb_iconBox-id-gsbp-e128263e-8134 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 1008c274 0 496-222 496-496s-222-496-496-496-496 222-496 496 222 496 496 496zM80 512c0-237.4 192.2-432 432-432 237.4 0 432 192.2 432 432 0 237.4-192.2 432-432 432-237.4 0-432-192.2-432-432zM743.4 476l-352-214c-31.6-17.6-71.4 5-71.4 42v416c0 36.8 39.6 59.6 71.4 42l352-202c32.8-18.2 32.8-65.6 0-84zM384 671.6v-317.8c0-9.4 10.2-15.2 18.2-10.2l269 163.4c7.8 4.8 7.6 16.2-0.2 20.6l-269 154.4c-8 4.6-18-1.2-18-10.4z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-45681454-48b6","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-45681454-48b6" class="gspb_container gspb_container-gsbp-45681454-48b6 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-e89f30ed-c4c8","textContent":"High Quality Sound","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#e4e4e7","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-e89f30ed-c4c8" class="gspb_text gspb_text-id-gsbp-e89f30ed-c4c8 ">High Quality Sound</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-67779f80-13f5","textContent":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1.2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#71717a","sizeUnit":"rem","size":[0.9],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-67779f80-13f5" class="gspb_text gspb_text-id-gsbp-67779f80-13f5 ">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-41987aaa-342b","columnspan":[null,2,null,1],"order":[null,1],"spacing":{"margin":{"values":{"bottom":[null,".5"],"top":[null,null],"right":[null,null],"left":[null,null]},"unit":["px","rem","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-41987aaa-342b" class="gspb_container gspb_container-gsbp-41987aaa-342b wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-5d9aa8ba-dacf","width":[null,null,null,null],"widthUnit":["%","px","%","%"],"minHeight":[100,700,null,400],"minHeightUnit":["%","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"background":{"color":"#e4e4e5"},"border":{"borderRadius":{"values":{"topLeft":"12","topRight":"12","bottomRight":"12","bottomLeft":"12"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}}} -->
        <div id="gspb_container-id-gsbp-5d9aa8ba-dacf" class="gspb_container gspb_container-gsbp-5d9aa8ba-dacf wp-block-greenshift-blocks-container"></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-f0d7a397-f57c","order":[null,3],"flexbox":{"type":"flexbox","rowgapUnit":["rem","rem",null,"rem"],"rowgap":[4,3,null,2]}} -->
        <div id="gspb_container-id-gsbp-f0d7a397-f57c" class="gspb_container gspb_container-gsbp-f0d7a397-f57c wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-e02526b4-e8ef","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[0.8],"alignItems":["stretch"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-e02526b4-e8ef" class="gspb_container gspb_container-gsbp-e02526b4-e8ef wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-f025b6e5-3714","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-f025b6e5-3714" class="gspb_container gspb_container-gsbp-f025b6e5-3714 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-e5a6491e-fe00","type":"regular","shadow":{},"background":{},"iconBox_icon":{"icon":{"font":"rhicon rhi-rss","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[24],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""}} -->
        <div id="gspb_iconBox-id-gsbp-e5a6491e-fe00" class="gspb_iconBox gspb_iconBox-id-gsbp-e5a6491e-fe00 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 896 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M160 736c35.29 0 64 28.71 64 64s-28.71 64-64 64-64-28.71-64-64 28.71-64 64-64zM160 640c-88.366 0-160 71.634-160 160s71.634 160 160 160 160-71.634 160-160-71.634-160-160-160zM895.992 935.23c-12.898-475.668-396.114-858.326-871.22-871.22-13.554-0.368-24.772 10.448-24.772 24.004v48.040c0 12.964 10.294 23.616 23.252 23.984 423.952 12.080 764.632 353.47 776.708 776.708 0.37 12.958 11.020 23.252 23.984 23.252h48.040c13.56 0.002 24.374-11.216 24.008-24.768zM623.514 935.13c-12.712-325.11-273.582-585.932-598.644-598.644-13.584-0.532-24.87 10.402-24.87 23.998v48.048c0 12.862 10.144 23.41 22.994 23.96 273.536 11.694 492.822 231.022 504.516 504.516 0.55 12.85 11.098 22.994 23.96 22.994h48.048c13.594-0.002 24.528-11.288 23.996-24.872z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-85417b14-d0ac","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-85417b14-d0ac" class="gspb_container gspb_container-gsbp-85417b14-d0ac wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-12214949-6a3e","textContent":"Superfast 5G","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#e4e4e7","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-12214949-6a3e" class="gspb_text gspb_text-id-gsbp-12214949-6a3e ">Superfast 5G</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-1a86fb48-e6d6","textContent":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1.2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#71717a","sizeUnit":"rem","size":[0.9],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-1a86fb48-e6d6" class="gspb_text gspb_text-id-gsbp-1a86fb48-e6d6 ">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-81284a15-86a4","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[0.8],"alignItems":["stretch"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-81284a15-86a4" class="gspb_container gspb_container-gsbp-81284a15-86a4 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-e6eb8721-755c","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-e6eb8721-755c" class="gspb_container gspb_container-gsbp-e6eb8721-755c wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-49ea782d-34c6","type":"regular","shadow":{},"background":{},"iconBox_icon":{"icon":{"font":"rhicon rhi-camera-retro","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[24],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""}} -->
        <div id="gspb_iconBox-id-gsbp-49ea782d-34c6" class="gspb_iconBox gspb_iconBox-id-gsbp-49ea782d-34c6 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M308 160h-232c-6.6 0-12-5.4-12-12v-72c0-6.6 5.4-12 12-12h232c6.6 0 12 5.4 12 12v72c0 6.6-5.4 12-12 12zM1024 160v704c0 53-43 96-96 96h-832c-53 0-96-43-96-96v-576c0-53 43-96 96-96h272l67.2-89.6c18.2-24.2 46.6-38.4 76.8-38.4h416c53 0 96 43 96 96zM928 288h-832v576h832v-576zM928 160h-416l-24 32h440v-32zM752 576c0-132.4-107.6-240-240-240s-240 107.6-240 240 107.6 240 240 240 240-107.6 240-240zM656 576c0 79.4-64.6 144-144 144s-144-64.6-144-144 64.6-144 144-144 144 64.6 144 144zM464 576c0-26.4 21.6-48 48-48 17.6 0 32-14.4 32-32s-14.4-32-32-32c-61.8 0-112 50.2-112 112 0 17.6 14.4 32 32 32s32-14.4 32-32z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-7ac446e8-58e8","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-7ac446e8-58e8" class="gspb_container gspb_container-gsbp-7ac446e8-58e8 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-0f695a10-060c","textContent":"Better Camera","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#e4e4e7","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-0f695a10-060c" class="gspb_text gspb_text-id-gsbp-0f695a10-060c ">Better Camera</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-e8080063-e83a","textContent":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1.2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#71717a","sizeUnit":"rem","size":[0.9],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-e8080063-e83a" class="gspb_text gspb_text-id-gsbp-e8080063-e83a ">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-7802ff90-36dc","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[0.8],"alignItems":["stretch"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-7802ff90-36dc" class="gspb_container gspb_container-gsbp-7802ff90-36dc wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-c703d8e7-8028","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-c703d8e7-8028" class="gspb_container gspb_container-gsbp-c703d8e7-8028 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-61fd8d78-c7bf","type":"regular","shadow":{},"background":{},"iconBox_icon":{"icon":{"font":"rhicon rhi-cloud-upload1","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[24],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""}} -->
        <div id="gspb_iconBox-id-gsbp-61fd8d78-c7bf" class="gspb_iconBox gspb_iconBox-id-gsbp-61fd8d78-c7bf wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M819.52 819.2h-179.52c-14.139 0-25.6-11.461-25.6-25.6s11.461-25.6 25.6-25.6h179.52c84.518 0 153.28-68.762 153.28-153.28s-68.762-153.28-153.28-153.28c-18.005 0-35.626 3.086-52.368 9.173-11.168 4.056-23.654-0.099-30.163-10.035-6.507-9.938-5.323-23.048 2.859-31.659 18.154-19.106 28.152-44.15 28.152-70.518 0-56.464-45.936-102.4-102.4-102.4-32.858 0-62.912 15.187-82.456 41.667-11.704 15.859-18.533 34.638-19.746 54.307-0.67 10.867-8.141 20.122-18.622 23.069-10.482 2.946-21.682-1.059-27.915-9.984l-0.238-0.342c-5.49-7.795-11.549-15.443-17.952-22.653-48.587-54.694-118.374-86.064-191.47-86.064-141.158 0-256 114.842-256 256 0 141.16 114.842 256 256 256h128c14.138 0 25.6 11.461 25.6 25.6s-11.462 25.6-25.6 25.6h-128c-169.39 0-307.2-137.81-307.2-307.2s137.81-307.2 307.2-307.2c82.050 0 160.621 32.933 218.142 90.901 4.47-9.989 10.026-19.52 16.608-28.438 28.867-39.112 75.090-62.462 123.65-62.462 84.696 0 153.6 68.904 153.6 153.6 0 17.976-3.099 35.542-9.035 52.050 3.11-0.139 6.23-0.21 9.357-0.21 112.75 0 204.48 91.73 204.48 204.48-0.002 112.75-91.731 204.48-204.482 204.48z"></path><path style="fill:#565D66" d="M658.101 621.899l-102.4-102.4c-9.997-9.997-26.206-9.997-36.203 0l-102.4 102.4c-9.997 9.997-9.997 26.206 0 36.203 9.998 9.997 26.206 9.997 36.205 0l58.698-58.698v194.195c0 14.139 11.461 25.6 25.6 25.6s25.6-11.461 25.6-25.6v-194.195l58.699 58.698c4.998 4.998 11.549 7.498 18.101 7.498s13.102-2.499 18.101-7.499c9.998-9.997 9.998-26.205 0-36.202z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-668a786b-6aca","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-668a786b-6aca" class="gspb_container gspb_container-gsbp-668a786b-6aca wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-04ab2e6e-b02f","textContent":"Cloud Storage","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#e4e4e7","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-04ab2e6e-b02f" class="gspb_text gspb_text-id-gsbp-04ab2e6e-b02f ">Cloud Storage</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-82b66307-6d64","textContent":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1.2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#71717a","sizeUnit":"rem","size":[0.9],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-82b66307-6d64" class="gspb_text gspb_text-id-gsbp-82b66307-6d64 ">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sagittis ante viverra in arcu et. Nec faucibus arcu, blandit ultrices nec.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/pricetableblock',
        array(
            'title'       => __('Price table', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('cta', 'price table'),
            'description' => _x('Price table', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-71556936-e767","inlineCssStyles":null,"align":"full","width":[1280,null,null,null],"displayStyles":false,"background":{"color":"#fafafa"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[80],"bottom":[80]},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-71556936-e767" class="gspb_row gspb_row-id-gsbp-71556936-e767 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-71556936-e767"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-9bab7637-63c5","inlineCssStyles":null,"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"right":[32,24,null,16],"left":[32,24,null,16],"top":[0],"bottom":[0]},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-9bab7637-63c5" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-9bab7637-63c5"><!-- wp:greenshift-blocks/heading {"id":"gsbp-0cc4562a-9125","inlineCssStyles":null,"headingContent":"The right Greenshift plan can change your life","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"marginAuto":[true]},"typography":{"alignment":["center"],"textShadow":{},"size":[48,36,null,30],"customweight":null,"line_height":[54]},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom","maxWidth":["600px"]}} -->
        <h2 id="gspb_heading-id-gsbp-0cc4562a-9125" class="gspb_heading gspb_heading-id-gsbp-0cc4562a-9125 ">The right Greenshift plan can change your life</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-f301eee0-2a1b","inlineCssStyles":null,"textContent":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Dignissim orci, velit, commodo sed iaculis odio. In congue eget.","spacing":{"margin":{"values":{"top":[24]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"marginAuto":[true]},"typography":{"textShadow":{},"alignment":["center"],"color":"#71717a"},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom","maxWidth":["576px"]}} -->
        <div id="gspb_text-id-gsbp-f301eee0-2a1b" class="gspb_text gspb_text-id-gsbp-f301eee0-2a1b ">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Dignissim orci, velit, commodo sed iaculis odio. In congue eget.</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-a28b1fc2-82ce","inlineCssStyles":null,"variableWidth":false,"width":[null,null,null,null],"widthUnit":["px","px","px","px"],"minHeight":[null,null,null,null],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row",null,"column","column"],"alignItems":["center",null,"stretch","stretch"],"rowgap":[null,null,30,32],"justifyContent":["center"]},"spacing":{"margin":{"values":{"top":[64,null,null,32]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":true},"marginAuto":[true],"overflow":[null]},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom","maxWidth":["1024px"]}} -->
        <div id="gspb_container-id-gsbp-a28b1fc2-82ce" class="gspb_container gspb_container-gsbp-a28b1fc2-82ce wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-f06e7c33-6bda","inlineCssStyles":null,"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"flexBasis":["custom"],"flexBasisCustom":["33.33%"],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"background":{"color":"#ffffff"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[36,24],"right":[40,24],"bottom":[36,24],"left":[40,24]},"unit":["px","px","px","px"],"locked":false},"overflow":[null]}} -->
        <div id="gspb_container-id-gsbp-f06e7c33-6bda" class="gspb_container gspb_container-gsbp-f06e7c33-6bda wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-118b0946-c285","inlineCssStyles":null,"iconBox_icon":{"icon":{"font":"rhicon rhi-rocket-launch","svg":"","image":""},"fill":"#2184f9","fillhover":"#2184f9","type":"font","iconSize":["40px"]}} -->
        <div id="gspb_iconBox-id-gsbp-118b0946-c285" class="gspb_iconBox gspb_iconBox-id-gsbp-118b0946-c285 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M71.37 704.133c-51.715 51.707-77.269 181.055-70.219 318.688 138.23 7.117 267.222-18.703 318.73-70.211 80.578-80.559 85.754-187.973 12.621-261.098-73.129-73.117-180.562-67.941-261.132 12.621zM234.636 872.195c-17.172 17.168-60.168 25.773-106.238 23.398-2.348-45.871 6.168-88.984 23.406-106.219 26.855-26.852 62.66-28.578 87.035-4.207 24.375 24.375 22.652 60.176-4.203 87.027zM1010.326 38.594c-2.352-10.926-13.977-22.531-24.902-24.867-64.191-13.727-114.496-13.727-164.586-13.727-206.437 0-330.238 110.406-422.656 256h-208.406c-32.594 0-71.199 23.848-85.777 52.996l-98.844 197.598c-2.917 6.275-4.741 13.593-5.028 21.303l-0.003 0.103c0.009 26.509 21.499 47.995 48.007 48l207.907 0c0.004-0 0.009-0 0.014-0 106.041 0 192.005 85.96 192.013 191.999l0 0.001v208c0.009 26.509 21.499 47.995 48.007 48l0.001 0c7.814-0.298 15.13-2.121 21.76-5.178l-0.354 0.146 197.496-98.813c29.121-14.57 52.949-53.129 52.949-85.687v-208.875c145.176-92.625 256.039-216.813 256.039-422.188 0.187-50.301 0.187-100.602-13.637-164.812zM716.276 544.664c-50.664 32.324-15.012 13.48-198.633 104.418-29.484-63.448-79.351-113.287-141.040-141.991l-1.78-0.744c90.746-183.367 71.793-147.5 104.426-198.906 94.078-148.207 196.234-211.441 341.589-211.441 35.297 0 67.082 0 102.746 4.496 4.609 36.527 4.488 68.937 4.363 102.91-0 144.539-63.305 246.598-211.672 341.258zM736.112 208c-44.178 0.007-79.988 35.821-79.988 80 0 44.183 35.817 80 80 80s80-35.817 80-80v0c-0.022-44.178-35.833-79.984-80.010-80l-0.001-0z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-625c679d-30a2","inlineCssStyles":null,"headingTag":"h3","headingContent":"STARTUP","spacing":{"margin":{"values":{"top":[24],"bottom":[0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"size":[17],"customweight":null}} -->
        <h3 id="gspb_heading-id-gsbp-625c679d-30a2" class="gspb_heading gspb_heading-id-gsbp-625c679d-30a2 ">STARTUP</h3>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-208a4db2-96a1","inlineCssStyles":null,"textContent":"Best for small business owners","spacing":{"margin":{"values":{"top":[6]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"size":[15],"color":"#71717a"}} -->
        <div id="gspb_text-id-gsbp-208a4db2-96a1" class="gspb_text gspb_text-id-gsbp-208a4db2-96a1 ">Best for small business owners</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-607e575f-d3b3","inlineCssStyles":null,"minHeight":[null,null,null,null],"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row"],"justifyContent":["center"],"columngap":[5],"alignItems":["flex-end"]},"spacing":{"margin":{"values":{"top":[25]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-607e575f-d3b3" class="gspb_container gspb_container-gsbp-607e575f-d3b3 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-144a40dd-9daf","inlineCssStyles":null,"textContent":"$","typography":{"textShadow":{},"size":[20],"customweight":"bold","color":"#a1a1aa","line_height":[null]}} -->
        <div id="gspb_text-id-gsbp-144a40dd-9daf" class="gspb_text gspb_text-id-gsbp-144a40dd-9daf ">$</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-ed9b4ad5-302f","inlineCssStyles":null,"textContent":"99","typography":{"textShadow":{},"size":[40],"customweight":"bold","line_height":[35]}} -->
        <div id="gspb_text-id-gsbp-ed9b4ad5-302f" class="gspb_text gspb_text-id-gsbp-ed9b4ad5-302f ">99</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-92aac79b-7d02","inlineCssStyles":null,"textContent":"/year","typography":{"textShadow":{},"size":[20],"customweight":"bold","color":"#a1a1aa"}} -->
        <div id="gspb_text-id-gsbp-92aac79b-7d02" class="gspb_text gspb_text-id-gsbp-92aac79b-7d02 ">/year</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/iconlist {"id":"gsbp-214c9330-e1f7","inlineCssStyles":null,"iconsList":[{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"#2184f9","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font","strokeColorHover":"","strokeColor":"","strokeWidth":""},"content":"1 Domain License"},{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font","strokeColorHover":"","strokeColor":"","strokeWidth":""},"content":"5 Email Account"},{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font","strokeColorHover":"","strokeColor":"","strokeWidth":""},"content":"Limited Reporting"},{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font","strokeColorHover":"","strokeColor":"","strokeWidth":""},"content":"Custom Domain"}],"textTag":"li","iconBox":false,"spacing":{"margin":{"values":{"top":[36]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"spacingList":{"margin":{"values":{"top":[10]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"marginAuto":[0]},"typography":{"textShadow":{},"customweight":"bold","size":[15],"alignment":["left"]}} -->
        <div id="gspb_iconsList-id-gsbp-214c9330-e1f7" class="gspb_iconsList gspb_iconsList-id-gsbp-214c9330-e1f7 wp-block-greenshift-blocks-iconlist"><ul><li class="gspb_iconsList__item" data-id="0"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">1 Domain License</span></li><li class="gspb_iconsList__item" data-id="1"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">5 Email Account</span></li><li class="gspb_iconsList__item" data-id="2"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">Limited Reporting</span></li><li class="gspb_iconsList__item" data-id="3"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">Custom Domain</span></li></ul></div>
        <!-- /wp:greenshift-blocks/iconlist -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-d2b6ac54-4b9b","inlineCssStyles":null,"buttonContent":"Start 14 Days Trial","background":{"color":"#f4f4f5"},"spacing":{"margin":{"values":{"top":[48],"bottom":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[16],"bottom":[16],"right":[32,16],"left":[32,16]},"unit":["px","px","px","px"],"locked":false}},"blockWidth":{"customWidth":{"value":["100%"],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom"},"typography":{"textShadow":{},"alignment":["center"],"color":"#000000","customweight":"bold","line_height":[24]}} -->
        <div id="gspb_button-id-gsbp-d2b6ac54-4b9b" class="gspb_button_wrapper gspb_button-id-gsbp-d2b6ac54-4b9b wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Start 14 Days Trial</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-57d2b12c-b18b","inlineCssStyles":null,"textContent":"No credit card required","spacing":{"margin":{"values":{"top":[16]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"size":[15]}} -->
        <div id="gspb_text-id-gsbp-57d2b12c-b18b" class="gspb_text gspb_text-id-gsbp-57d2b12c-b18b ">No credit card required</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-b991cc6d-88df","inlineCssStyles":null,"flexBasis":["custom"],"flexBasisCustom":["33.33%"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"background":{"color":"#ffffff"},"shadow":{"hoffset":"","voffset":"5","blur":"20","spread":"10","color":"#a6acb059"},"position":{"positionType":["","","",""],"positions":{"values":{}},"Zindex":10}} -->
        <div id="gspb_container-id-gsbp-b991cc6d-88df" class="gspb_container gspb_container-gsbp-b991cc6d-88df wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-8c12ccbe-7401","inlineCssStyles":null,"background":{"color":"#000000"}} -->
        <div id="gspb_container-id-gsbp-8c12ccbe-7401" class="gspb_container gspb_container-gsbp-8c12ccbe-7401 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-bad3ab72-681c","inlineCssStyles":null,"textContent":"MOST POPULAR","textTag":"p","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[8],"bottom":[8]},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"customweight":"bold","color":"#fefefe","alignment":["center"],"size":[12],"letter_spacing":["1px"],"textBorder":null,"textBorderHover":null,"line_height":[16]}} -->
        <p id="gspb_text-id-gsbp-bad3ab72-681c" class="gspb_text gspb_text-id-gsbp-bad3ab72-681c ">MOST POPULAR</p>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-cf3bdd0f-4fda","inlineCssStyles":null,"flexBasis":["custom"],"flexBasisCustom":["33.33%"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[36,24],"right":[40,24],"bottom":[36,24],"left":[40,24]},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-cf3bdd0f-4fda" class="gspb_container gspb_container-gsbp-cf3bdd0f-4fda wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-e784a5be-9248","inlineCssStyles":null,"iconBox_icon":{"icon":{"font":"rhicon rhi-crown","svg":"","image":""},"fill":"#2184f9","fillhover":"#2184f9","type":"font","iconSize":["40px"]}} -->
        <div id="gspb_iconBox-id-gsbp-e784a5be-9248" class="gspb_iconBox gspb_iconBox-id-gsbp-e784a5be-9248 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1280 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1072 960h-864c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h864c8.8 0 16-7.2 16-16v-32c0-8.8-7.2-16-16-16zM1168 320c-61.8 0-112 50.2-112 112 0 15.2 3 29.6 8.6 42.8l-112.6 67.6c-10.4 6.2-21.6 9.2-32.8 9.2-22.2 0-43.8-11.6-55.6-32.2l-148.8-260.4c22.6-20.6 37.2-50 37.2-83 0-61.8-50.2-112-112-112s-112 50.2-112 112c0 33 14.6 62.4 37.2 82.8l-148.8 260.4c-11.8 20.8-33.4 32.2-55.6 32.2-11.2 0-22.6-3-32.8-9.2l-112.6-67.6c5.4-13.2 8.6-27.6 8.6-42.8 0-61.8-50.2-112-112-112s-112 50.4-112 112.2 50.2 112 112 112c4 0 7.8-0.8 11.6-1.2l132.4 353.2h768l132.4-353.2c3.8 0.4 7.6 1.2 11.6 1.2 61.8 0 112-50.2 112-112s-50.2-112-112-112zM640 128c26.4 0 48 21.6 48 48s-21.6 48-48 48-48-21.6-48-48 21.6-48 48-48zM112 480c-26.4 0-48-21.6-48-48s21.6-48 48-48 48 21.6 48 48-21.6 48-48 48zM979.6 832h-679.2l-112-298.8 106.8 64c20 12 42.6 18.2 65.8 18.2 45.8 0 88.4-24.8 111.2-64.6l151.2-264.6c5.6 0.8 11 1.6 16.8 1.6s11.2-0.8 16.8-1.6l151 264.8c22.8 39.8 65.4 64.4 111.2 64.4 23.2 0 45.8-6.4 65.8-18.2l106.8-64-112.2 298.8zM1168 480c-26.4 0-48-21.6-48-48s21.6-48 48-48 48 21.6 48 48-21.6 48-48 48z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-3fb73498-c77f","inlineCssStyles":null,"headingTag":"h3","headingContent":"AGENCY","spacing":{"margin":{"values":{"top":[24],"bottom":[0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"size":[17],"customweight":null}} -->
        <h3 id="gspb_heading-id-gsbp-3fb73498-c77f" class="gspb_heading gspb_heading-id-gsbp-3fb73498-c77f ">AGENCY</h3>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-f6da7229-b583","inlineCssStyles":null,"textContent":"Best for medium agency","spacing":{"margin":{"values":{"top":[6]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"size":[15],"color":"#71717a"}} -->
        <div id="gspb_text-id-gsbp-f6da7229-b583" class="gspb_text gspb_text-id-gsbp-f6da7229-b583 ">Best for medium agency</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-c8f8580f-a62a","inlineCssStyles":null,"minHeight":[null,null,null,null],"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row"],"justifyContent":["center"],"columngap":[5],"alignItems":["flex-end"]},"spacing":{"margin":{"values":{"top":[25]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-c8f8580f-a62a" class="gspb_container gspb_container-gsbp-c8f8580f-a62a wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-6c9c5002-2f63","inlineCssStyles":null,"textContent":"$","typography":{"textShadow":{},"size":[20],"customweight":"bold","color":"#a1a1aa","line_height":[null]}} -->
        <div id="gspb_text-id-gsbp-6c9c5002-2f63" class="gspb_text gspb_text-id-gsbp-6c9c5002-2f63 ">$</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-5d155b15-1928","inlineCssStyles":null,"textContent":"199","typography":{"textShadow":{},"size":[40],"customweight":"bold","line_height":[35]}} -->
        <div id="gspb_text-id-gsbp-5d155b15-1928" class="gspb_text gspb_text-id-gsbp-5d155b15-1928 ">199</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-6ec7f25d-c29d","inlineCssStyles":null,"textContent":"/year","typography":{"textShadow":{},"size":[20],"customweight":"bold","color":"#a1a1aa"}} -->
        <div id="gspb_text-id-gsbp-6ec7f25d-c29d" class="gspb_text gspb_text-id-gsbp-6ec7f25d-c29d ">/year</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/iconlist {"id":"gsbp-94ed3c88-b010","inlineCssStyles":null,"iconsList":[{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Everything from Startup"},{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"10 Domain License"},{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[0,null,null,null],"rotateY":false,"rotateX":false,"type":"font","strokeColorHover":"","strokeColor":"","strokeWidth":""},"content":"20 Email Account"}],"textTag":"li","iconBox":false,"spacing":{"margin":{"values":{"top":[36]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"spacingList":{"margin":{"values":{"top":[10]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"marginAuto":[0]},"typography":{"textShadow":{},"customweight":"bold","size":[15],"alignment":["left"]},"flexcolumns":false,"flexbox":{"type":"grid"}} -->
        <div id="gspb_iconsList-id-gsbp-94ed3c88-b010" class="gspb_iconsList gspb_iconsList-id-gsbp-94ed3c88-b010 wp-block-greenshift-blocks-iconlist"><ul><li class="gspb_iconsList__item" data-id="0"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">Everything from Startup</span></li><li class="gspb_iconsList__item" data-id="1"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">10 Domain License</span></li><li class="gspb_iconsList__item" data-id="2"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">20 Email Account</span></li></ul></div>
        <!-- /wp:greenshift-blocks/iconlist -->
        
        <!-- wp:greenshift-blocks/iconlist {"id":"gsbp-70613be5-0570","inlineCssStyles":null,"iconsList":[{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Advanced Reporting"},{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Custom Domain"},{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Priority Support"}],"colorGlobal":"#a1a1aa","iconBox":false,"spacing":{"margin":{"values":{"top":[0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"spacingList":{"margin":{"values":{"top":[10]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"marginAuto":[0]},"typography":{"textShadow":{},"customweight":"bold","size":[15],"alignment":["left"],"color":"#a1a1aa"}} -->
        <div id="gspb_iconsList-id-gsbp-70613be5-0570" class="gspb_iconsList gspb_iconsList-id-gsbp-70613be5-0570 wp-block-greenshift-blocks-iconlist"><div class="gspb_iconsList__item" data-id="0"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">Advanced Reporting</span></div><div class="gspb_iconsList__item" data-id="1"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">Custom Domain</span></div><div class="gspb_iconsList__item" data-id="2"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">Priority Support</span></div></div>
        <!-- /wp:greenshift-blocks/iconlist -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-50f6bcbe-12a8","inlineCssStyles":null,"buttonContent":"Start 14 Days Trial","background":{"color":"#000000"},"spacing":{"margin":{"values":{"top":[48],"bottom":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[16],"bottom":[16],"right":[32,16],"left":[32,16]},"unit":["px","px","px","px"],"locked":false}},"blockWidth":{"customWidth":{"value":["100%"],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom"},"typography":{"textShadow":{},"alignment":["center"],"color":"#ffffff","customweight":"bold","line_height":[24]}} -->
        <div id="gspb_button-id-gsbp-50f6bcbe-12a8" class="gspb_button_wrapper gspb_button-id-gsbp-50f6bcbe-12a8 wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Start 14 Days Trial</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-1c268d42-20bf","inlineCssStyles":null,"textContent":"No credit card required","spacing":{"margin":{"values":{"top":[16]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"size":[15]}} -->
        <div id="gspb_text-id-gsbp-1c268d42-20bf" class="gspb_text gspb_text-id-gsbp-1c268d42-20bf ">No credit card required</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-226d9ee6-2aa4","inlineCssStyles":null,"flexBasis":["custom"],"flexBasisCustom":["33.33%"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"background":{"color":"#ffffff"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[36,24],"right":[40,24],"bottom":[36,24],"left":[40,24]},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-226d9ee6-2aa4" class="gspb_container gspb_container-gsbp-226d9ee6-2aa4 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-2fe9208c-bd44","inlineCssStyles":null,"iconBox_icon":{"icon":{"font":"rhicon rhi-cog","svg":"","image":""},"fill":"#2184f9","fillhover":"#2184f9","type":"font","iconSize":["40px"]}} -->
        <div id="gspb_iconBox-id-gsbp-2fe9208c-bd44" class="gspb_iconBox gspb_iconBox-id-gsbp-2fe9208c-bd44 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M965.392 598.552l-65.22-37.654c1.958-14.684 3.075-31.661 3.075-48.899s-1.117-34.215-3.284-50.863l0.209 1.964 65.22-37.654c19.152-11.056 28.39-33.804 22.092-55.002-22.428-75.498-62.35-143.456-115.070-199.19-15.268-16.14-39.634-19.672-58.874-8.564l-65.124 37.596c-24.475-18.797-52.351-35.208-82.151-47.995l-2.527-0.965v-75.228c0-22.26-15.304-41.608-36.968-46.734-75.288-17.818-154.236-17.82-229.54 0-21.662 5.126-36.968 24.472-36.968 46.734v75.228c-32.327 13.752-60.203 30.162-85.603 49.641l0.925-0.681-65.124-37.596c-19.242-11.108-43.608-7.576-58.874 8.564-52.72 55.734-92.642 123.694-115.070 199.19-6.298 21.198 2.94 43.944 22.092 55.002l65.22 37.654c-1.958 14.684-3.075 31.661-3.075 48.899s1.117 34.215 3.284 50.863l-0.209-1.964-65.22 37.654c-19.152 11.056-28.39 33.804-22.092 55.002 22.428 75.496 62.35 143.456 115.070 199.19 15.268 16.14 39.634 19.672 58.874 8.566l65.124-37.596c24.474 18.798 52.351 35.207 82.151 47.994l2.527 0.964v75.228c0 22.26 15.304 41.608 36.968 46.734 75.29 17.818 154.236 17.82 229.54 0 21.662-5.126 36.968-24.472 36.968-46.734v-75.228c32.326-13.752 60.203-30.162 85.604-49.64l-0.926 0.682 65.124 37.596c19.24 11.108 43.606 7.576 58.874-8.566 52.72-55.734 92.642-123.694 115.070-199.19 6.298-21.198-2.94-43.944-22.092-55.002zM834.434 799.474l-92.618-53.48c-53.976 46.142-73.118 57.752-142.078 82.118v106.958c-26.375 5.694-56.676 8.955-87.738 8.955s-61.363-3.261-90.578-9.459l2.84 0.504v-106.958c-67.242-23.758-86.71-34.79-142.078-82.118l-92.618 53.48c-39.42-44.18-69.378-95.978-87.858-151.916l92.658-53.48c-13.070-70.834-13.076-93.288 0-164.158l-92.658-53.48c18.48-55.938 48.44-107.738 87.858-151.938l92.618 53.52c54.754-46.868 74.126-58.13 142.078-82.138v-106.956c26.376-5.703 56.675-8.97 87.738-8.97s61.363 3.267 90.575 9.475l-2.837-0.505v106.958c67.956 24.010 87.33 35.274 142.078 82.138l92.618-53.52c39.418 44.198 69.378 95.998 87.858 151.938l-92.658 53.48c13.072 70.852 13.076 93.288 0 164.158l92.658 53.48c-18.48 55.936-48.438 107.736-87.858 151.914zM512 320c-105.87 0-192 86.13-192 192s86.13 192 192 192 192-86.13 192-192-86.13-192-192-192zM512 640c-70.58 0-128-57.42-128-128s57.42-128 128-128 128 57.42 128 128-57.42 128-128 128z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-d84af9e8-6611","inlineCssStyles":null,"headingTag":"h3","headingContent":"DEVELOPER","spacing":{"margin":{"values":{"top":[24],"bottom":[0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"size":[17],"customweight":null}} -->
        <h3 id="gspb_heading-id-gsbp-d84af9e8-6611" class="gspb_heading gspb_heading-id-gsbp-d84af9e8-6611 ">DEVELOPER</h3>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-cd6c8443-c44e","inlineCssStyles":null,"textContent":"Best for independent developers","spacing":{"margin":{"values":{"top":[6]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"size":[15],"color":"#71717a"}} -->
        <div id="gspb_text-id-gsbp-cd6c8443-c44e" class="gspb_text gspb_text-id-gsbp-cd6c8443-c44e ">Best for independent developers</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-bad66710-20f6","inlineCssStyles":null,"minHeight":[null,null,null,null],"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row"],"justifyContent":["center"],"columngap":[5],"alignItems":["flex-end"]},"spacing":{"margin":{"values":{"top":[25]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-bad66710-20f6" class="gspb_container gspb_container-gsbp-bad66710-20f6 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-fab47559-87c0","inlineCssStyles":null,"textContent":"$","typography":{"textShadow":{},"size":[20],"customweight":"bold","color":"#a1a1aa","line_height":[null]}} -->
        <div id="gspb_text-id-gsbp-fab47559-87c0" class="gspb_text gspb_text-id-gsbp-fab47559-87c0 ">$</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-58435daf-d468","inlineCssStyles":null,"textContent":"69","typography":{"textShadow":{},"size":[40],"customweight":"bold","line_height":[35]}} -->
        <div id="gspb_text-id-gsbp-58435daf-d468" class="gspb_text gspb_text-id-gsbp-58435daf-d468 ">69</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-108a70b4-6eb2","inlineCssStyles":null,"textContent":"/year","typography":{"textShadow":{},"size":[20],"customweight":"bold","color":"#a1a1aa","line_height":[null]}} -->
        <div id="gspb_text-id-gsbp-108a70b4-6eb2" class="gspb_text gspb_text-id-gsbp-108a70b4-6eb2 ">/year</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/iconlist {"id":"gsbp-bf2a5e64-a36a","inlineCssStyles":null,"iconsList":[{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"1 Domain License"},{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"5 Email Account"},{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Limited Reporting"},{"icon":{"icon":{"font":"rhicon rhi-check-circle","svg":"","image":""},"fill":"","fillhover":"","iconSize":[null,null,null,null],"rotateY":false,"rotateX":false,"type":"font","strokeColorHover":"","strokeColor":"","strokeWidth":""},"content":"Custom Domain"}],"textTag":"li","iconBox":false,"spacing":{"margin":{"values":{"top":[36]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"spacingList":{"margin":{"values":{"top":[10]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"marginAuto":[0]},"typography":{"textShadow":{},"customweight":"bold","size":[15],"alignment":["left"]}} -->
        <div id="gspb_iconsList-id-gsbp-bf2a5e64-a36a" class="gspb_iconsList gspb_iconsList-id-gsbp-bf2a5e64-a36a wp-block-greenshift-blocks-iconlist"><ul><li class="gspb_iconsList__item" data-id="0"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">1 Domain License</span></li><li class="gspb_iconsList__item" data-id="1"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">5 Email Account</span></li><li class="gspb_iconsList__item" data-id="2"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">Limited Reporting</span></li><li class="gspb_iconsList__item" data-id="3"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-273.934 0-496 222.066-496 496s222.066 496 496 496 496-222.066 496-496-222.066-496-496-496zM512 112c221.064 0 400 178.902 400 400 0 221.064-178.902 400-400 400-221.064 0-400-178.902-400-400 0-221.064 178.902-400 400-400zM792.408 372.534l-45.072-45.436c-9.334-9.41-24.53-9.472-33.94-0.136l-282.704 280.432-119.584-120.554c-9.334-9.41-24.53-9.472-33.94-0.138l-45.438 45.072c-9.41 9.334-9.472 24.53-0.136 33.942l181.562 183.032c9.334 9.41 24.53 9.472 33.94 0.136l345.178-342.408c9.408-9.336 9.468-24.532 0.134-33.942z"></path></svg><span class="gspb_iconsList__item__text">Custom Domain</span></li></ul></div>
        <!-- /wp:greenshift-blocks/iconlist -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-5f4b09fd-a2e1","inlineCssStyles":null,"buttonContent":"Start 14 Days Trial","background":{"color":"#f4f4f5"},"spacing":{"margin":{"values":{"top":[48],"bottom":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[16],"bottom":[16],"right":[32,16],"left":[32,16]},"unit":["px","px","px","px"],"locked":false}},"blockWidth":{"customWidth":{"value":["100%"],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom"},"typography":{"textShadow":{},"alignment":["center"],"color":"#000000","customweight":"bold","line_height":[24]}} -->
        <div id="gspb_button-id-gsbp-5f4b09fd-a2e1" class="gspb_button_wrapper gspb_button-id-gsbp-5f4b09fd-a2e1 wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Start 14 Days Trial</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-8750abc9-4b05","inlineCssStyles":null,"textContent":"No credit card required","spacing":{"margin":{"values":{"top":[16]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"size":[15]}} -->
        <div id="gspb_text-id-gsbp-8750abc9-4b05" class="gspb_text gspb_text-id-gsbp-8750abc9-4b05 ">No credit card required</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-9ea8dd41-ed7a","inlineCssStyles":null,"textContent":"We don’t bill you automatically until your confirmation. We don’t store or sell your data to anyone.","spacing":{"margin":{"values":{"top":[64,null,null,32]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"marginAuto":[true]},"typography":{"textShadow":{},"alignment":["center"],"color":"#71717a"},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom","maxWidth":["448px"]}} -->
        <div id="gspb_text-id-gsbp-9ea8dd41-ed7a" class="gspb_text gspb_text-id-gsbp-9ea8dd41-ed7a ">We don’t bill you automatically until your confirmation. We don’t store or sell your data to anyone.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/fourcircleicons',
        array(
            'title'       => __('Four circled icons', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/iconlist', 'greenshift-blocks/iconbox'),
            'keywords' => array('icons', 'info'),
            'description' => _x('Icon block', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-9b7bd1ca-6df9","align":"full","rowLayout":"4","brp_rowLayout":["36","36","36"],"width":[1200,null,null,null],"displayStyles":false,"shadow":{"hoffset":0,"voffset":5,"blur":20,"spread":0,"color":"rgba(0, 0, 0, 0.03)","position":null},"mobileSmartScroll":false,"mobileSSwidth":280,"mobileSSpoint":1024,"mobileSSpadding":1} -->
        <div id="gspb_row-id-gsbp-9b7bd1ca-6df9" class="gspb_row gspb_row-id-gsbp-9b7bd1ca-6df9 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-9b7bd1ca-6df9"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-6e493c54-cfc1","columnSize":"3","brp_columnSize":["6","6","6"],"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"right":["solid"]},"size":{"right":[1]},"color":{"right":["#f4f4f4"]},"styleHover":{},"sizeHover":{},"colorHover":{}}} -->
        <div id="gspb_col-id-gsbp-6e493c54-cfc1" class="gspb_row__col--3 wp-block-greenshift-blocks-row-column  gspb_row__col--md-6 gspb_row__col--sm-6 gspb_row__col--xs-6 gspb_col-id-gsbp-6e493c54-cfc1"><!-- wp:greenshift-blocks/container {"id":"gsbp-c492b1e1-7e79","flexbox":{"type":"flexbox","flexDirection":["row"],"marginRight":[15]},"spacing":{"margin":{"values":{"bottom":[10]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"position":{"positionType":["","","",""],"positions":{"values":{}},"Zindex":9}} -->
        <div id="gspb_container-id-gsbp-c492b1e1-7e79" class="gspb_container gspb_container-gsbp-c492b1e1-7e79 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-27b89b27-532c","type":"boxed","spacing":{"margin":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-paper-plane","svg":"\u003csvg version=\u00221.1\u0022 id=\u0022Layer_1\u0022 xmlns=\u0022http://www.w3.org/2000/svg\u0022 x=\u00220px\u0022 y=\u00220px\u0022 viewBox=\u00220 0 122.88 74.34\u0022\u003e\u003cg\u003e\u003cpath d=\u0022M94.42,18.73l-17.98-0.1V6.53c0-1.8-0.73-3.43-1.92-4.61C73.34,0.73,71.71,0,69.91,0H20.07 c-1.8,0-3.43,0.73-4.61,1.92c-1.18,1.18-1.92,2.81-1.92,4.61c0,0.98,0.79,1.77,1.77,1.77c0.98,0,1.77-0.79,1.77-1.77 c0-0.82,0.34-1.57,0.88-2.11c0.54-0.54,1.29-0.88,2.11-0.88h49.84c0.82,0,1.57,0.34,2.11,0.88c0.54,0.54,0.88,1.29,0.88,2.11v55.41 h-9.98c-0.98,0-1.77,0.79-1.77,1.77c0,0.98,0.79,1.77,1.77,1.77h11.75c0.98,0,1.77-0.79,1.77-1.77v-2.01h10.68 c0.81-18.42,27.26-20.96,29.95,0h5.81l-1.79-19.22l-19.07-7.3L94.42,18.73L94.42,18.73z M2.65,37.54c-1.47,0-2.65-0.8-2.65-1.78 c0-0.98,1.19-1.78,2.65-1.78h23.89c1.47,0,2.65,0.8,2.65,1.78c0,0.98-1.19,1.78-2.65,1.78H2.65L2.65,37.54z M8.12,27.96 c-1.1,0-1.99-0.79-1.99-1.77c0-0.98,0.89-1.77,1.99-1.77h18.43c1.1,0,1.99,0.79,1.99,1.77c0,0.98-0.89,1.77-1.99,1.77H8.12 L8.12,27.96z M10.65,18.38c-1.1,0-1.99-0.79-1.99-1.77c0-0.98,0.89-1.77,1.99-1.77h15.89c1.1,0,1.99,0.79,1.99,1.77 c0,0.98-0.89,1.77-1.99,1.77H10.65L10.65,18.38z M26.46,61.93c0.98,0,1.77,0.79,1.77,1.77c0,0.98-0.79,1.77-1.77,1.77h-6.39 c-1.79,0-3.42-0.78-4.61-2.01c-1.18-1.23-1.92-2.91-1.92-4.69v-13c0-0.98,0.79-1.77,1.77-1.77c0.98,0,1.77,0.79,1.77,1.77v13 c0,0.85,0.35,1.66,0.92,2.25c0.54,0.56,1.27,0.92,2.06,0.92H26.46L26.46,61.93z M44.46,50.37c-6.62,0-11.99,5.37-11.99,11.99 c0,6.62,5.37,11.99,11.99,11.99c6.62,0,11.99-5.37,11.99-11.99C56.44,55.74,51.08,50.37,44.46,50.37L44.46,50.37z M44.46,57.75 c-2.54,0-4.61,2.06-4.61,4.61c0,2.54,2.06,4.61,4.61,4.61c2.54,0,4.61-2.06,4.61-4.61C49.06,59.81,47,57.75,44.46,57.75 L44.46,57.75z M102.06,50.37c-6.62,0-11.99,5.37-11.99,11.99c0,6.62,5.37,11.99,11.99,11.99s11.99-5.37,11.99-11.99 C114.05,55.74,108.68,50.37,102.06,50.37L102.06,50.37z M102.06,57.75c-2.54,0-4.61,2.06-4.61,4.61c0,2.54,2.06,4.61,4.61,4.61 s4.61-2.06,4.61-4.61C106.67,59.81,104.61,57.75,102.06,57.75L102.06,57.75z M89.79,23.81l-8.93-0.1V35.2h14.97L89.79,23.81 L89.79,23.81z\u0022/\u003e\u003c/g\u003e\u003c/svg\u003e","image":""},"fill":"#00a2ff","fillhover":"","type":"svg","iconSize":[30]},"animation":{"duration":700,"easing":"ease","type":"zoom-in"}} -->
        <div id="gspb_iconBox-id-gsbp-27b89b27-532c" class="gspb_iconBox gspb_iconBox-id-gsbp-27b89b27-532c wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex" data-aos="zoom-in" data-aos-easing="ease" data-aos-duration="700"><svg id="Layer_1" style="width:5rem;height:5rem;margin:10px" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 122.88 74.34"><g><path d="M94.42,18.73l-17.98-0.1V6.53c0-1.8-0.73-3.43-1.92-4.61C73.34,0.73,71.71,0,69.91,0H20.07 c-1.8,0-3.43,0.73-4.61,1.92c-1.18,1.18-1.92,2.81-1.92,4.61c0,0.98,0.79,1.77,1.77,1.77c0.98,0,1.77-0.79,1.77-1.77 c0-0.82,0.34-1.57,0.88-2.11c0.54-0.54,1.29-0.88,2.11-0.88h49.84c0.82,0,1.57,0.34,2.11,0.88c0.54,0.54,0.88,1.29,0.88,2.11v55.41 h-9.98c-0.98,0-1.77,0.79-1.77,1.77c0,0.98,0.79,1.77,1.77,1.77h11.75c0.98,0,1.77-0.79,1.77-1.77v-2.01h10.68 c0.81-18.42,27.26-20.96,29.95,0h5.81l-1.79-19.22l-19.07-7.3L94.42,18.73L94.42,18.73z M2.65,37.54c-1.47,0-2.65-0.8-2.65-1.78 c0-0.98,1.19-1.78,2.65-1.78h23.89c1.47,0,2.65,0.8,2.65,1.78c0,0.98-1.19,1.78-2.65,1.78H2.65L2.65,37.54z M8.12,27.96 c-1.1,0-1.99-0.79-1.99-1.77c0-0.98,0.89-1.77,1.99-1.77h18.43c1.1,0,1.99,0.79,1.99,1.77c0,0.98-0.89,1.77-1.99,1.77H8.12 L8.12,27.96z M10.65,18.38c-1.1,0-1.99-0.79-1.99-1.77c0-0.98,0.89-1.77,1.99-1.77h15.89c1.1,0,1.99,0.79,1.99,1.77 c0,0.98-0.89,1.77-1.99,1.77H10.65L10.65,18.38z M26.46,61.93c0.98,0,1.77,0.79,1.77,1.77c0,0.98-0.79,1.77-1.77,1.77h-6.39 c-1.79,0-3.42-0.78-4.61-2.01c-1.18-1.23-1.92-2.91-1.92-4.69v-13c0-0.98,0.79-1.77,1.77-1.77c0.98,0,1.77,0.79,1.77,1.77v13 c0,0.85,0.35,1.66,0.92,2.25c0.54,0.56,1.27,0.92,2.06,0.92H26.46L26.46,61.93z M44.46,50.37c-6.62,0-11.99,5.37-11.99,11.99 c0,6.62,5.37,11.99,11.99,11.99c6.62,0,11.99-5.37,11.99-11.99C56.44,55.74,51.08,50.37,44.46,50.37L44.46,50.37z M44.46,57.75 c-2.54,0-4.61,2.06-4.61,4.61c0,2.54,2.06,4.61,4.61,4.61c2.54,0,4.61-2.06,4.61-4.61C49.06,59.81,47,57.75,44.46,57.75 L44.46,57.75z M102.06,50.37c-6.62,0-11.99,5.37-11.99,11.99c0,6.62,5.37,11.99,11.99,11.99s11.99-5.37,11.99-11.99 C114.05,55.74,108.68,50.37,102.06,50.37L102.06,50.37z M102.06,57.75c-2.54,0-4.61,2.06-4.61,4.61c0,2.54,2.06,4.61,4.61,4.61 s4.61-2.06,4.61-4.61C106.67,59.81,104.61,57.75,102.06,57.75L102.06,57.75z M89.79,23.81l-8.93-0.1V35.2h14.97L89.79,23.81 L89.79,23.81z"></path></g></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-c3c34317-77fe","headingTag":"div","headingContent":"Fast delivery","typography":{"textShadow":{},"color":"","size":[15],"line_height":[21]},"animation":{"duration":700,"easing":"ease","type":"flip-up","delay":100},"enablesubTitle":true,"subTitle":"Discount and points ","spacingsubTitle":{"margin":{"values":{"top":[5]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typographysubTitle":{"textShadow":{},"size":[13],"line_height":[14]}} -->
        <div id="gspb_heading-id-gsbp-c3c34317-77fe" class="gspb_heading gspb_heading-id-gsbp-c3c34317-77fe " data-aos="flip-up" data-aos-delay="100" data-aos-easing="ease" data-aos-duration="700">Fast delivery<span class="gspb_heading_subtitle">Discount and points </span></div>
        <!-- /wp:greenshift-blocks/heading --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-ce4977fa-2224","columnSize":"3","brp_columnSize":["6","6","6"],"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"right":["solid"]},"size":{"right":[1]},"color":{"right":["#f4f4f4"]},"styleHover":{},"sizeHover":{},"colorHover":{}}} -->
        <div id="gspb_col-id-gsbp-ce4977fa-2224" class="gspb_row__col--3 wp-block-greenshift-blocks-row-column  gspb_row__col--md-6 gspb_row__col--sm-6 gspb_row__col--xs-6 gspb_col-id-gsbp-ce4977fa-2224"><!-- wp:greenshift-blocks/container {"id":"gsbp-5af8222d-7a36","flexbox":{"type":"flexbox","flexDirection":["row"],"marginRight":[15]},"spacing":{"margin":{"values":{"bottom":[10]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"position":{"positionType":["","","",""],"positions":{"values":{}},"Zindex":9}} -->
        <div id="gspb_container-id-gsbp-5af8222d-7a36" class="gspb_container gspb_container-gsbp-5af8222d-7a36 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-81220a2f-41c7","type":"boxed","spacing":{"margin":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":[13],"right":[13],"bottom":[13],"left":[13]},"unit":["px","px","px","px"],"locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-shield-check","svg":"","image":""},"fill":"#00a2ff","fillhover":"","type":"font","iconSize":[22]},"animation":{"duration":700,"easing":"ease","type":"zoom-in","delay":150}} -->
        <div id="gspb_iconBox-id-gsbp-81220a2f-41c7" class="gspb_iconBox gspb_iconBox-id-gsbp-81220a2f-41c7 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex" data-aos="zoom-in" data-aos-delay="150" data-aos-easing="ease" data-aos-duration="700"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M933 167.4l-384-160c-10.902-4.648-23.586-7.35-36.9-7.35s-25.998 2.702-37.531 7.588l0.631-0.238-384 160c-35.8 14.8-59.2 49.8-59.2 88.6 0 397 229 671.4 443 760.6 23.6 9.8 50.2 9.8 73.8 0 171.4-71.4 443.2-318 443.2-760.6 0-38.8-23.4-73.8-59-88.6zM838.6 395.8l-368 368c-12.4 12.4-32.8 12.4-45.2 0l-208-208c-12.4-12.4-12.4-32.8 0-45.2l45.2-45.2c12.4-12.4 32.8-12.4 45.2 0l140.2 140.2 300.2-300.2c12.4-12.4 32.8-12.4 45.2 0l45.2 45.2c12.6 12.6 12.6 32.8 0 45.2z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-3a6a1a9a-48c6","headingTag":"div","headingContent":"Equipment insurance","typography":{"textShadow":{},"color":"","size":[15],"line_height":[21]},"animation":{"duration":700,"easing":"ease","type":"flip-up","delay":250},"enablesubTitle":true,"subTitle":"Discount and points ","spacingsubTitle":{"margin":{"values":{"top":[5]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typographysubTitle":{"textShadow":{},"size":[13],"line_height":[14]}} -->
        <div id="gspb_heading-id-gsbp-3a6a1a9a-48c6" class="gspb_heading gspb_heading-id-gsbp-3a6a1a9a-48c6 " data-aos="flip-up" data-aos-delay="250" data-aos-easing="ease" data-aos-duration="700">Equipment insurance<span class="gspb_heading_subtitle">Discount and points </span></div>
        <!-- /wp:greenshift-blocks/heading --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-5dca14bd-0cb5","columnSize":"3","brp_columnSize":["6","6","6"],"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"right":["solid"]},"size":{"right":[1]},"color":{"right":["#f4f4f4"]},"styleHover":{},"sizeHover":{},"colorHover":{}}} -->
        <div id="gspb_col-id-gsbp-5dca14bd-0cb5" class="gspb_row__col--3 wp-block-greenshift-blocks-row-column  gspb_row__col--md-6 gspb_row__col--sm-6 gspb_row__col--xs-6 gspb_col-id-gsbp-5dca14bd-0cb5"><!-- wp:greenshift-blocks/container {"id":"gsbp-804974e6-2651","flexbox":{"type":"flexbox","flexDirection":["row"],"marginRight":[15]},"spacing":{"margin":{"values":{"bottom":[10]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"position":{"positionType":["","","",""],"positions":{"values":{}},"Zindex":9}} -->
        <div id="gspb_container-id-gsbp-804974e6-2651" class="gspb_container gspb_container-gsbp-804974e6-2651 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-c6f345be-72fd","type":"boxed","spacing":{"margin":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":[12],"right":[12],"bottom":[12],"left":[12]},"unit":["px","px","px","px"],"locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-credit-card","svg":"","image":""},"fill":"#00a2ff","fillhover":"","type":"font","iconSize":[22]},"animation":{"duration":700,"easing":"ease","type":"zoom-in","delay":350}} -->
        <div id="gspb_iconBox-id-gsbp-c6f345be-72fd" class="gspb_iconBox gspb_iconBox-id-gsbp-c6f345be-72fd wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex" data-aos="zoom-in" data-aos-delay="350" data-aos-easing="ease" data-aos-duration="700"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1152 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1055.8 64h-959.6c-53.2 0-96.2 43-96.2 96v704c0 53 43 96 96.2 96h959.6c53.2 0 96.2-43 96.2-96v-704c0-53-43-96-96.2-96zM108.2 160h935.6c6.6 0 12 5.4 12 12v84h-959.6v-84c0-6.6 5.4-12 12-12zM1043.8 864h-935.6c-6.6 0-12-5.4-12-12v-340h959.6v340c0 6.6-5.4 12-12 12zM384 664v80c0 13.2-10.8 24-24 24h-144c-13.2 0-24-10.8-24-24v-80c0-13.2 10.8-24 24-24h144c13.2 0 24 10.8 24 24zM768 664v80c0 13.2-10.8 24-24 24h-272c-13.2 0-24-10.8-24-24v-80c0-13.2 10.8-24 24-24h272c13.2 0 24 10.8 24 24z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-c0a0b2d5-c95a","headingTag":"div","headingContent":"Installment and credit","typography":{"textShadow":{},"color":"","size":[15],"line_height":[21]},"animation":{"duration":700,"easing":"ease","type":"flip-up","delay":450},"enablesubTitle":true,"subTitle":"Discount and points ","spacingsubTitle":{"margin":{"values":{"top":[5]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typographysubTitle":{"textShadow":{},"size":[13],"line_height":[14]}} -->
        <div id="gspb_heading-id-gsbp-c0a0b2d5-c95a" class="gspb_heading gspb_heading-id-gsbp-c0a0b2d5-c95a " data-aos="flip-up" data-aos-delay="450" data-aos-easing="ease" data-aos-duration="700">Installment and credit<span class="gspb_heading_subtitle">Discount and points </span></div>
        <!-- /wp:greenshift-blocks/heading --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-f28ccc7b-c87a","columnSize":"3","brp_columnSize":["6","6","6"]} -->
        <div id="gspb_col-id-gsbp-f28ccc7b-c87a" class="gspb_row__col--3 wp-block-greenshift-blocks-row-column  gspb_row__col--md-6 gspb_row__col--sm-6 gspb_row__col--xs-6 gspb_col-id-gsbp-f28ccc7b-c87a"><!-- wp:greenshift-blocks/container {"id":"gsbp-458de7a0-a9cb","flexbox":{"type":"flexbox","flexDirection":["row"],"marginRight":[15]},"spacing":{"margin":{"values":{"bottom":[10]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"position":{"positionType":["","","",""],"positions":{"values":{}},"Zindex":9}} -->
        <div id="gspb_container-id-gsbp-458de7a0-a9cb" class="gspb_container gspb_container-gsbp-458de7a0-a9cb wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-fd968ccf-c967","type":"boxed","spacing":{"margin":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":[11],"right":[11],"bottom":[11],"left":[11]},"unit":["px","px","px","px"],"locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-tags","svg":"","image":""},"fill":"#00a2ff","fillhover":"","type":"font","iconSize":[22]},"animation":{"duration":700,"easing":"ease","type":"zoom-in","delay":550}} -->
        <div id="gspb_iconBox-id-gsbp-fd968ccf-c967" class="gspb_iconBox gspb_iconBox-id-gsbp-fd968ccf-c967 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex" data-aos="zoom-in" data-aos-delay="550" data-aos-easing="ease" data-aos-duration="700"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1280 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1251.882 587.646l-408.236 408.236c-37.492 37.492-98.276 37.49-135.764 0l-0.72-0.72 476.838-475.398-521.206-519.764h97.442c26.51 0 50.509 10.745 67.882 28.118l423.764 423.764c37.49 37.49 37.49 98.274 0 135.764zM995.882 587.646l-408.236 408.236c-18.744 18.746-43.314 28.118-67.882 28.118s-49.138-9.372-67.882-28.118l-423.764-423.764c-17.373-17.373-28.118-41.372-28.118-67.882l-0-0v-408.236c0-53.020 42.98-96 96-96h408.236c0-0 0.001-0 0.001-0 26.509 0 50.509 10.745 67.881 28.118l423.764 423.764c37.49 37.49 37.49 98.274 0 135.764zM928 519.764l-423.764-423.764h-408.236v408.236l423.772 423.756 408.228-408.228zM288 192c-53.020 0-96 42.98-96 96s42.98 96 96 96 96-42.98 96-96-42.98-96-96-96z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-fa39dafd-448b","headingTag":"div","headingContent":"Earn bonuses, rewards","typography":{"textShadow":{},"color":"","size":[15],"line_height":[21]},"animation":{"duration":700,"easing":"ease","type":"flip-up","delay":650},"enablesubTitle":true,"subTitle":"Discount and points ","spacingsubTitle":{"margin":{"values":{"top":[5]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typographysubTitle":{"textShadow":{},"size":[13],"line_height":[14]}} -->
        <div id="gspb_heading-id-gsbp-fa39dafd-448b" class="gspb_heading gspb_heading-id-gsbp-fa39dafd-448b " data-aos="flip-up" data-aos-delay="650" data-aos-easing="ease" data-aos-duration="700">Earn bonuses, rewards<span class="gspb_heading_subtitle">Discount and points </span></div>
        <!-- /wp:greenshift-blocks/heading --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/herocta',
        array(
            'title'       => __('Hero block with CTA', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('cta', 'features'),
            'description' => _x('Hero block with CTA', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-490a2a75-f7fc","inlineCssStyles":null,"align":"full","gutterClassName":"gspb_row\u002d\u002dgutter-custom-0","rowLayout":"2","brp_rowLayout":["30",null,null],"width":[1200,null,null,null],"displayStyles":false,"background":{"color":"#f4f4f5"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["6"],"bottom":["6"],"right":["2","1.5",null,"1"],"left":["2","1.5",null,"1"]},"unit":["rem","rem","px","rem"],"locked":false}},"columnGapNew":96,"rowGap":[null,40,null,null]} -->
        <div id="gspb_row-id-gsbp-490a2a75-f7fc" class="gspb_row gspb_row-id-gsbp-490a2a75-f7fc wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-490a2a75-f7fc gspb_row--gutter-custom-0"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-866d7828-65a3","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-96","flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"columnSize":"6","brp_columnSize":["12",null,null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_col-id-gsbp-866d7828-65a3" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-866d7828-65a3"><!-- wp:greenshift-blocks/container {"id":"gsbp-9e803b88-072d","inlineCssStyles":null,"minHeight":[378,476,null,248],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"","columngapUnit":["rem"],"columngap":[1.5]},"background":{"color":"#e6e6e7"},"border":{"borderRadius":{"values":{"topLeft":"17","topRight":"17","bottomRight":"17","bottomLeft":"17"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-9e803b88-072d" class="gspb_container gspb_container-gsbp-9e803b88-072d wp-block-greenshift-blocks-container"></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-e980a8c8-cb8f","inlineCssStyles":null,"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row"],"justifyContent":["center"]},"spacing":{"margin":{"values":{"left":[0,null,null,0],"top":["-3"],"right":[0,null,null,0],"bottom":[0]},"unit":["rem","px","px","rem"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_container-id-gsbp-e980a8c8-cb8f" class="gspb_container gspb_container-gsbp-e980a8c8-cb8f wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-e1ef4b67-63df","inlineCssStyles":null,"width":[null,null,null,280],"widthUnit":["px","%","%","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"justifyContent":["center"],"alignItems":["center"]},"background":{"color":"#ffffff"},"border":{"borderRadius":{"values":{"topLeft":"5","topRight":"5","bottomRight":"5","bottomLeft":"5"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":true},"padding":{"values":{"top":["1.5"],"right":["2.5",null,null,2],"bottom":["1.5"],"left":["2.5",null,null,2]},"unit":["rem","px","px","px"],"locked":false},"marginAuto":[true]},"position":{"positionType":["","","",""],"positions":{"values":{"top":[null]}},"Zindex":100},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom","maxWidth":["380px"]}} -->
        <div id="gspb_container-id-gsbp-e1ef4b67-63df" class="gspb_container gspb_container-gsbp-e1ef4b67-63df wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-76a4fede-cf88","inlineCssStyles":null,"textContent":"37%","typography":{"textShadow":{},"sizeUnit":"rem","size":[2.3],"lineHeightUnit":["rem"],"line_height":[2.5],"customweight":"custom","customweightnumber":700,"color":"#2563eb"}} -->
        <div id="gspb_text-id-gsbp-76a4fede-cf88" class="gspb_text gspb_text-id-gsbp-76a4fede-cf88 ">37%</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-d3cbea7e-fda9","inlineCssStyles":null,"textContent":"High Conversions\u003cbr\u003eon Landing Pages","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":["1.5"]},"unit":["rem","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1.1],"line_height":[1.8],"customweight":"custom","customweightnumber":500,"color":"#000000"}} -->
        <div id="gspb_text-id-gsbp-d3cbea7e-fda9" class="gspb_text gspb_text-id-gsbp-d3cbea7e-fda9 ">High Conversions<br>on Landing Pages</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-3bb73da5-7081","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-96","flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["column"],"justifyContent":["flex-start"],"alignItems":["flex-start"]},"columnSize":"6","brp_columnSize":["12",null,null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null,0],"bottom":[null],"left":[null,0]},"unit":["rem","px","px","px"],"locked":true}}} -->
        <div id="gspb_col-id-gsbp-3bb73da5-7081" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-3bb73da5-7081"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-2d690014-0307","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[15],"right":[15],"bottom":[15],"left":[15]},"unit":["px","px","px","px"],"locked":true}},"background":{"color":"#ffffff"},"iconBox_icon":{"icon":{"font":"rhicon rhi-bolt-regular","svg":"","image":""},"fill":"#ff6f12","fillhover":"","type":"font","strokeColor":"","iconSize":["25px"],"strokeColorHover":"","strokeWidth":""}} -->
        <div id="gspb_iconBox-id-gsbp-2d690014-0307" class="gspb_iconBox gspb_iconBox-id-gsbp-2d690014-0307 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 768 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M755.6 335.8c-16.4-28.6-46.2-45.8-79.2-45.8h-188.8l57.4-175c7.4-27.6 1.6-56.6-15.8-79.4-17.6-22.6-44.2-35.6-72.8-35.6h-261c-45.6 0-84.6 34.2-89.6 74.2l-104.8 424.4c-3.8 27.6 4.4 55.4 22.6 76.4s44.6 33 72.4 33h196.2l-69.8 303.4c-6.4 27.4-0.2 55.8 17.2 77.8 17.4 22.2 43.6 34.8 71.8 34.8 32.6 0 63-17.6 77.6-43.2l366.4-553.4c16.8-28.6 16.8-63 0.2-91.6zM320.2 914.8l92.6-402.8h-317.8l100.4-416 255.2-1.8-95.6 291.8h313l-347.8 528.8z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-f74dcb5e-90da","inlineCssStyles":null,"spacing":{"margin":{"values":{"top":["2.5","2.5"]},"unit":["rem","rem","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":true}}} -->
        <div id="gspb_container-id-gsbp-f74dcb5e-90da" class="gspb_container gspb_container-gsbp-f74dcb5e-90da wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-491947c9-41bd","inlineCssStyles":null,"headingContent":"Build a perfect team within hours.","typography":{"textShadow":{},"customweight":"custom","customweightnumber":700,"sizeUnit":"rem","size":[3,2.3,null,1.9],"lineHeightUnit":["rem"],"line_height":[3.4,2.5]}} -->
        <h2 id="gspb_heading-id-gsbp-491947c9-41bd" class="gspb_heading gspb_heading-id-gsbp-491947c9-41bd ">Build a perfect team within hours.</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-850356b6-a756","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia conse duis enim velit mollit. Exercitation veniam.","spacing":{"margin":{"values":{"top":["1.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[1.1],"lineHeightUnit":["rem"],"line_height":[1.6]}} -->
        <div id="gspb_text-id-gsbp-850356b6-a756" class="gspb_text gspb_text-id-gsbp-850356b6-a756 ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia conse duis enim velit mollit. Exercitation veniam.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-12583460-6f5a","inlineCssStyles":null,"buttonContent":"Explore more","align":"center","background":{"backgroundState":"Gradient","backgroundHoverState":"Gradient","gradient":"linear-gradient(92deg,rgb(168,71,207) 1%,rgb(120,70,207) 46%,rgb(70,81,207) 97%)"},"spacing":{"margin":{"values":{"bottom":[null],"top":["2.2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":["1"],"bottom":["1"],"right":["2.5"],"left":["2.5"]},"unit":["rem","px","px","px"],"locked":false},"overflow":[null,null,null,null]},"iconSpacing":{"margin":{"values":{"left":[null]},"unit":["rem","px","px","px"],"locked":true},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":"5","topRight":"5","bottomRight":"5","bottomLeft":"5"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"typography":{"colorState":"Classic","sizeUnit":"rem","lineHeightUnit":["rem","px","px","px"],"textShadow":{"hShadow":"0","hShadow2":"","hShadow3":"","vShadow":"2","vShadow2":"","vShadow3":"","blur":"1","blur2":"","blur3":"","color":"#00000066","color2":"","color3":""},"fluidSizeMin":"1.5rem","fluidSizeMax":"2.1rem","fluidSizePerfect":"1.7vw","fluidLineMin":"2rem","fluidLineMax":"2.5rem","fluidLinePerfect":"2.1vw","customweight":"custom","size":[1],"line_height":[1.5],"customweightnumber":600},"animation":{"duration":700,"easing":"ease","usegsap":false,"y":30,"rx":null,"s":0.5,"o":"0","type":""},"responsive":{"hideOnDesktop":false,"hideOnTablet":false,"hideOnMobile":false,"hideOnLandscape":false,"customcss":""},"buttonLink":"https://greenshiftwp.com/","linkNewWindow":true,"enableIcon":false,"iconRight":false,"iconBox_icon":{"icon":{"font":"rhicon rhi-arrow-right","svg":"","image":""},"fill":"#ffffff","fillhover":"#ffffff","type":"font"},"enableblockIcon":false} -->
        <div id="gspb_button-id-gsbp-12583460-6f5a" class="gspb_button_wrapper gspb_button-id-gsbp-12583460-6f5a wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" href="https://greenshiftwp.com/" target="_blank" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Explore more</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/videocta',
        array(
            'title'       => __('Two column video CTA', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container', 'greenshift-blocks/video'),
            'keywords' => array('cta', 'features', 'video'),
            'description' => _x('Video block with CTA', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-2a3f90b6-f45f","inlineCssStyles":null,"align":"full","gutterClassName":"gspb_row\u002d\u002dgutter-custom-0","rowLayout":"2","width":[1200,null,null,null],"displayStyles":false,"background":{"color":"#fafafa"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["6"],"bottom":["6"],"right":["2","1.5",null,"1"],"left":["2","1.5",null,"1"]},"unit":["rem","rem","px","rem"],"locked":false}},"columnGapNew":80,"rowGap":[null,null,null,40]} -->
        <div id="gspb_row-id-gsbp-2a3f90b6-f45f" class="gspb_row gspb_row-id-gsbp-2a3f90b6-f45f wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-2a3f90b6-f45f gspb_row--gutter-custom-0"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-866d7828-65a3","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-80","flexbox":{"type":"flexbox","columngapUnit":["rem"],"rowgapUnit":["rem"],"columngap":[null],"rowgap":[null],"enable":false,"gridcolumns":[1]},"columnSize":"6","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_col-id-gsbp-866d7828-65a3" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-866d7828-65a3"><!-- wp:greenshift-blocks/container {"id":"gsbp-9e803b88-072d","inlineCssStyles":null,"minHeight":[363,288,null,229],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"grid","columngapUnit":["rem"],"columngap":[1.5]},"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-9e803b88-072d" class="gspb_container gspb_container-gsbp-9e803b88-072d wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-7148efcd-6e12","inlineCssStyles":null,"minHeight":[null,null,null,null],"background":{"color":"#e6e6e7"}} -->
        <div id="gspb_container-id-gsbp-7148efcd-6e12" class="gspb_container gspb_container-gsbp-7148efcd-6e12 wp-block-greenshift-blocks-container"></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-862d2475-d485","inlineCssStyles":null,"width":[null,null,null,null],"minHeight":[null,null,null,null],"background":{"color":""}} -->
        <div id="gspb_container-id-gsbp-862d2475-d485" class="gspb_container gspb_container-gsbp-862d2475-d485 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/video {"id":"gsbp-87d221b4-aafe","inlineCssStyles":null,"src":"https://youtu.be/YMUL9qjb7rs","provider":"youtube","poster":"https://i.ytimg.com/vi/YMUL9qjb7rs/maxresdefault.jpg","isOverlay":true,"overlayOpacity":1,"overlayIcon":true,"overlayLightbox":true,"postDate":"2023-01-18T21:44:09","height":[363,288,null,229],"heightUnit":["px","px","px","px"],"playiconBg":"#0031e2","bgColor":"#e6e6e7"} -->
        <div class="wp-block-greenshift-blocks-video gs-video youtube gspb_video-id-gsbp-87d221b4-aafe" id="gs-video-gsbp-87d221b4-aafe"><div class="gs-video-wrapper" itemscope><iframe class="gs-video-element" data-src="https://youtu.be/YMUL9qjb7rs" data-provider="youtube" data-autoplay="true" data-playsinline="false" data-controls="true" data-loop="false" data-mute="false" data-overlay="true" data-lightbox="true" data-modestbranding="false" data-suggested="true" frameborder="0" allowfullscreen></iframe><div class="gs-video-overlay" style="background-image:url(https://i.ytimg.com/vi/YMUL9qjb7rs/maxresdefault.jpg)" data-type="youtube" data-lightbox="true"><div class="gs-play-icon" style="background-color:#0031e2"><div style="content:&quot;&quot;;display:block;position:absolute;border-radius:50%;border:1px solid #0031e2;left:-20px;right:-20px;bottom:-20px;top:-20px;animation:pulsevideobutton 1.5s linear infinite;opacity:0"></div><span></span><div style="content:&quot;&quot;;display:block;position:absolute;border-radius:50%;border:1px solid #0031e2;left:-20px;right:-20px;bottom:-20px;top:-20px;animation:pulsevideobutton 1.5s linear infinite;opacity:0;animation-delay:0.5s"></div></div><div class="gs-overlay-color" style="background-color:#e6e6e7;background-image:;opacity:1"></div></div></div></div>
        <!-- /wp:greenshift-blocks/video --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/svgshape {"id":"gsbp-9dcd47da-84c9","inlineCssStyles":null,"spacing":{"margin":{"values":{"top":["-5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shapeJustify":"center","width":[145,null,null,null],"position":{"positionType":["absolute","","",""],"positions":{"values":{"left":["0px"],"right":["0px"],"top":[null]}},"Zindex":10},"typography":{"textShadow":{},"customweight":"custom","customweightnumber":600,"sizeUnit":"rem","size":[1.4]},"shapeSeparator":{"shape":17},"enabletext":true,"svgtext":"Greenshift Page Builder","textlength":440} -->
        <div id="gspb_svgBox-id-gsbp-9dcd47da-84c9" class="gspb_svgBox gspb_svgBox-id-gsbp-9dcd47da-84c9 wp-block-greenshift-blocks-svgshape"><svg xmlns="https://www.w3.org/2000/svg" version="1.1" data-style="17" x="0px" y="0px" viewBox="0 0 200 200" preserveAspectRatio="none"><path data-style="17" d="M 100, 100 m -75, 0 a 75,75 0 1,0 150,0 a 75,75 0 1,0 -150,0" id="textshapegsbp-9dcd47da-84c9"></path><defs><linearGradient><stop></stop><stop></stop></linearGradient></defs><text fill="#333"><textPath href="#textshapegsbp-9dcd47da-84c9" textLength="440">Greenshift Page Builder</textPath></text></svg></div>
        <!-- /wp:greenshift-blocks/svgshape --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-3bb73da5-7081","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-80","flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["column"],"justifyContent":["space-between"],"alignItems":["flex-start"]},"columnSize":"6","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":["4",0],"bottom":[0],"left":["4",0]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-3bb73da5-7081" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-3bb73da5-7081"><!-- wp:greenshift-blocks/container {"id":"gsbp-2dbae771-32ed","inlineCssStyles":null} -->
        <div id="gspb_container-id-gsbp-2dbae771-32ed" class="gspb_container gspb_container-gsbp-2dbae771-32ed wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-7b96ebe7-aae4","inlineCssStyles":null,"headingContent":"Grow business with Celebration.","typography":{"textShadow":{},"customweight":"custom","customweightnumber":700,"sizeUnit":"rem","size":[3,2.3,null,1.9],"lineHeightUnit":["rem"],"line_height":[3.4,2.5]}} -->
        <h2 id="gspb_heading-id-gsbp-7b96ebe7-aae4" class="gspb_heading gspb_heading-id-gsbp-7b96ebe7-aae4 ">Grow business with Celebration.</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-5969df8a-a1bc","textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit. Exercitation veniam consequat sunt nostrud amet.","textTag":"p"} -->
        <p id="gspb_text-id-gsbp-5969df8a-a1bc" class="gspb_text gspb_text-id-gsbp-5969df8a-a1bc ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit. Exercitation veniam consequat sunt nostrud amet.</p>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-12583460-6f5a","inlineCssStyles":null,"buttonContent":"Get started now","align":"center","spacing":{"margin":{"values":{"bottom":[null],"top":["2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":["1"],"bottom":["1"],"right":["1.3"],"left":["1.3"]},"unit":["rem","px","px","px"],"locked":false},"overflow":[null,null,null,null]},"iconSpacing":{"margin":{"values":{"left":["1.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":"5","topRight":"5","bottomRight":"5","bottomLeft":"5"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"responsive":{"hideOnDesktop":false,"hideOnTablet":false,"hideOnMobile":false,"hideOnLandscape":false,"customcss":""},"buttonLink":"https://greenshiftwp.com/","linkNewWindow":true,"enableIcon":true,"iconRight":true,"iconBox_icon":{"icon":{"font":"rhicon rhi-arrow-right","svg":"","image":""},"fill":"#ffffff","fillhover":"#ffffff","type":"font"},"enableblockIcon":false} -->
        <div id="gspb_button-id-gsbp-12583460-6f5a" class="gspb_button_wrapper gspb_button-id-gsbp-12583460-6f5a wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" href="https://greenshiftwp.com/" target="_blank" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Get started now</span></span><span class="gspb-buttonbox-icon"><svg class="" style="display:inline-block;vertical-align:middle" width="15" height="15" viewBox="0 0 896 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M436.202 76.202l-39.598 39.598c-9.372 9.372-9.372 24.568 0 33.942l310.26 310.258h-682.864c-13.254 0-24 10.746-24 24v56c0 13.254 10.746 24 24 24h682.864l-310.26 310.26c-9.372 9.372-9.372 24.568 0 33.942l39.598 39.598c9.372 9.372 24.568 9.372 33.942 0l418.828-418.828c9.372-9.372 9.372-24.568 0-33.942l-418.83-418.828c-9.372-9.374-24.568-9.374-33.94 0z"></path></svg></span></span></a></div>
        <!-- /wp:greenshift-blocks/button --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/linedicons',
        array(
            'title'       => __('Step lines with icons', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('cta', 'icons'),
            'description' => _x('Icons with lines', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-93795c49-ee9b","inlineCssStyles":null,"align":"full","width":[1024,null,null,null],"displayStyles":false,"background":{"color":"#f4f4f5"},"spacing":{"margin":{"values":{"top":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["4","4",null,"2.5"],"bottom":["4","4",null,"2.5"],"right":[0],"left":[0]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-93795c49-ee9b" class="gspb_row gspb_row-id-gsbp-93795c49-ee9b wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-93795c49-ee9b"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-cd01a086-e9c3","inlineCssStyles":null,"variableWidth":false,"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","alignItems":["center"]},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":["2","1.5",null,"1"],"bottom":[0],"left":["2","1.5",null,"1"]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-cd01a086-e9c3" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-cd01a086-e9c3"><!-- wp:greenshift-blocks/heading {"id":"gsbp-562e76c8-a3de","inlineCssStyles":null,"headingContent":"How do we create success","spacing":{"margin":{"values":{"bottom":[20]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"alignment":["center"],"textShadow":{},"sizeUnit":"rem","size":[3,2.3,null,1.9],"customweight":"custom","customweightnumber":700,"lineHeightUnit":["rem"],"line_height":[3,2.5],"color":"#000000"}} -->
        <h2 id="gspb_heading-id-gsbp-562e76c8-a3de" class="gspb_heading gspb_heading-id-gsbp-562e76c8-a3de ">How do we create success</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-86430d32-28f8","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis.","typography":{"alignment":["center"],"textShadow":{},"lineHeightUnit":["px"],"line_height":[null],"color":"#52525b"},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom","maxWidth":["512px"]}} -->
        <div id="gspb_text-id-gsbp-86430d32-28f8" class="gspb_text gspb_text-id-gsbp-86430d32-28f8 ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis.</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/row {"id":"gsbp-ff28d6b0-767a","inlineCssStyles":null,"width":[448,null,null,400],"columnPosition":"","columnJustify":"","displayStyles":false,"spacing":{"margin":{"values":{"top":["4",null,null,"3"]},"unit":["rem","px","px","rem"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-ff28d6b0-767a" class="gspb_row gspb_row-id-gsbp-ff28d6b0-767a wp-block-greenshift-blocks-row gspb_row-id-gsbp-ff28d6b0-767a"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-56ec2781-0d93","inlineCssStyles":null,"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-56ec2781-0d93" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-56ec2781-0d93"><!-- wp:greenshift-blocks/container {"id":"gsbp-e847bdd4-806e","inlineCssStyles":null,"flexbox":{"type":"grid","enable":false,"gridcolumns":[1,null,null,1],"columngap":[null],"rowgap":[3],"columngapUnit":["rem"],"rowgapUnit":["rem"]}} -->
        <div id="gspb_container-id-gsbp-e847bdd4-806e" class="gspb_container gspb_container-gsbp-e847bdd4-806e wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-3b4c5ae8-be1e","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[1.5]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-3b4c5ae8-be1e" class="gspb_container gspb_container-gsbp-3b4c5ae8-be1e wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-1cc8c144-1fbc","inlineCssStyles":null,"minHeight":[100,null,null,null],"minHeightUnit":["%","px","px","px"],"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"left":["dotted"]},"size":{"left":[3]},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["4rem"],"left":["1.9rem"]}}}} -->
        <div id="gspb_container-id-gsbp-1cc8c144-1fbc" class="gspb_container gspb_container-gsbp-1cc8c144-1fbc wp-block-greenshift-blocks-container"></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-21df5973-4800","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-21df5973-4800" class="gspb_container gspb_container-gsbp-21df5973-4800 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-d1b4a080-ba4a","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[15],"right":[15],"bottom":[15],"left":[15]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#ffffff"},"shapePosition":"","border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-user","svg":"","image":""},"fill":"#7c09ff","fillhover":"","type":"font","iconSize":["30px"],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-d1b4a080-ba4a" class="gspb_iconBox gspb_iconBox-id-gsbp-d1b4a080-ba4a wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M874.040 661.96c-55.766-55.764-122.142-97.046-194.562-122.036 77.564-53.422 128.522-142.828 128.522-243.924 0-163.214-132.786-296-296-296s-296 132.786-296 296c0 101.096 50.958 190.502 128.524 243.924-72.42 24.99-138.796 66.272-194.562 122.036-96.704 96.706-149.962 225.28-149.962 362.040h80c0-238.206 193.794-432 432-432s432 193.794 432 432h80c0-136.76-53.258-265.334-149.96-362.040zM512 512c-119.102 0-216-96.896-216-216s96.898-216 216-216c119.102 0 216 96.896 216 216s-96.898 216-216 216z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-4c6677c5-3829","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"left":[null]},"unit":["rem","px","px","px"],"locked":true},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-4c6677c5-3829" class="gspb_container gspb_container-gsbp-4c6677c5-3829 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-11d9bf97-d846","inlineCssStyles":null,"textContent":"Create a free account","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#010101","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":600},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-11d9bf97-d846" class="gspb_text gspb_text-id-gsbp-11d9bf97-d846 ">Create a free account</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-d1c3a351-44f6","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#52525b","sizeUnit":"rem","size":[1]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-d1c3a351-44f6" class="gspb_text gspb_text-id-gsbp-d1c3a351-44f6 ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-2774682c-7a93","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[1.5]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-2774682c-7a93" class="gspb_container gspb_container-gsbp-2774682c-7a93 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-d314c250-e9a4","inlineCssStyles":null,"minHeight":[100,null,null,null],"minHeightUnit":["%","px","px","px"],"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"left":["dotted"]},"size":{"left":[3]},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["4rem"],"left":["1.9rem"]}}}} -->
        <div id="gspb_container-id-gsbp-d314c250-e9a4" class="gspb_container gspb_container-gsbp-d314c250-e9a4 wp-block-greenshift-blocks-container"></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-a505b460-6668","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-a505b460-6668" class="gspb_container gspb_container-gsbp-a505b460-6668 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-748a8cc4-e673","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[15],"right":[15],"bottom":[15],"left":[15]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#ffffff"},"shapePosition":"","border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-inbox","svg":"","image":""},"fill":"#7c09ff","fillhover":"","type":"font","iconSize":["30px"],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-748a8cc4-e673" class="gspb_iconBox gspb_iconBox-id-gsbp-748a8cc4-e673 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1152 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1133.638 454.754l-208.884-287.218c-17.658-24.078-45.844-39.536-77.64-39.536l-542.228 0c-0-0-0.001-0-0.001-0-31.795 0-59.98 15.458-77.449 39.268l-0.188 0.268-208.886 287.218c-11.474 15.625-18.362 35.239-18.362 56.463 0 0 0 0.001 0 0.001l-0-0v288.782c0 53.020 42.98 96 96 96h960c53.020 0 96-42.98 96-96v-288.782c0-0 0-0.001 0-0.001 0-21.223-6.888-40.838-18.55-56.731l0.188 0.268zM279.006 205.178c5.896-8.014 15.285-13.162 25.877-13.178l0.003-0h542.23c10.204 0 19.878 4.926 25.88 13.178l176.596 242.822h-273.146l-64 128h-272.892l-64-128h-273.146l176.598-242.822zM1088 544v256c0 17.646-14.356 32-32 32h-960c-17.644 0-32-14.354-32-32v-256c0-17.674 14.326-32 32-32h240l64 128h352l64-128h240c17.674 0 32 14.326 32 32z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-24430940-5a94","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-24430940-5a94" class="gspb_container gspb_container-gsbp-24430940-5a94 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-df9a62a6-d205","inlineCssStyles":null,"textContent":"Build your website","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#000000","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":600},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-df9a62a6-d205" class="gspb_text gspb_text-id-gsbp-df9a62a6-d205 ">Build your website</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-0ed58c68-5beb","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#52525b","sizeUnit":"rem","size":[1]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-0ed58c68-5beb" class="gspb_text gspb_text-id-gsbp-0ed58c68-5beb ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-67400cbd-d02a","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[1.5]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-67400cbd-d02a" class="gspb_container gspb_container-gsbp-67400cbd-d02a wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-28fc5380-6dd2","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-28fc5380-6dd2" class="gspb_container gspb_container-gsbp-28fc5380-6dd2 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-170aa8ad-57d0","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[15],"right":[15],"bottom":[15],"left":[15]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#ffffff"},"shapePosition":"","border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-cloud-upload1","svg":"","image":""},"fill":"#7c09ff","fillhover":"","type":"font","iconSize":["30px"],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-170aa8ad-57d0" class="gspb_iconBox gspb_iconBox-id-gsbp-170aa8ad-57d0 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M819.52 819.2h-179.52c-14.139 0-25.6-11.461-25.6-25.6s11.461-25.6 25.6-25.6h179.52c84.518 0 153.28-68.762 153.28-153.28s-68.762-153.28-153.28-153.28c-18.005 0-35.626 3.086-52.368 9.173-11.168 4.056-23.654-0.099-30.163-10.035-6.507-9.938-5.323-23.048 2.859-31.659 18.154-19.106 28.152-44.15 28.152-70.518 0-56.464-45.936-102.4-102.4-102.4-32.858 0-62.912 15.187-82.456 41.667-11.704 15.859-18.533 34.638-19.746 54.307-0.67 10.867-8.141 20.122-18.622 23.069-10.482 2.946-21.682-1.059-27.915-9.984l-0.238-0.342c-5.49-7.795-11.549-15.443-17.952-22.653-48.587-54.694-118.374-86.064-191.47-86.064-141.158 0-256 114.842-256 256 0 141.16 114.842 256 256 256h128c14.138 0 25.6 11.461 25.6 25.6s-11.462 25.6-25.6 25.6h-128c-169.39 0-307.2-137.81-307.2-307.2s137.81-307.2 307.2-307.2c82.050 0 160.621 32.933 218.142 90.901 4.47-9.989 10.026-19.52 16.608-28.438 28.867-39.112 75.090-62.462 123.65-62.462 84.696 0 153.6 68.904 153.6 153.6 0 17.976-3.099 35.542-9.035 52.050 3.11-0.139 6.23-0.21 9.357-0.21 112.75 0 204.48 91.73 204.48 204.48-0.002 112.75-91.731 204.48-204.482 204.48z"></path><path style="fill:#565D66" d="M658.101 621.899l-102.4-102.4c-9.997-9.997-26.206-9.997-36.203 0l-102.4 102.4c-9.997 9.997-9.997 26.206 0 36.203 9.998 9.997 26.206 9.997 36.205 0l58.698-58.698v194.195c0 14.139 11.461 25.6 25.6 25.6s25.6-11.461 25.6-25.6v-194.195l58.699 58.698c4.998 4.998 11.549 7.498 18.101 7.498s13.102-2.499 18.101-7.499c9.998-9.997 9.998-26.205 0-36.202z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-476498cc-f6d6","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-476498cc-f6d6" class="gspb_container gspb_container-gsbp-476498cc-f6d6 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-6aeb073c-18fc","inlineCssStyles":null,"textContent":"Release \u0026amp; launch","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#000000","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":600},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-6aeb073c-18fc" class="gspb_text gspb_text-id-gsbp-6aeb073c-18fc ">Release &amp; launch</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-0df57370-71a6","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#52525b","sizeUnit":"rem","size":[1]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-0df57370-71a6" class="gspb_text gspb_text-id-gsbp-0df57370-71a6 ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/ideainfo',
        array(
            'title'       => __('Info Idea', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('info', 'features'),
            'description' => _x('Info block', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-490a2a75-f7fc","inlineCssStyles":null,"align":"full","gutterClassName":"gspb_row\u002d\u002dgutter-custom-0","rowLayout":"2","brp_rowLayout":["30",null,null],"width":[1200,null,null,null],"displayStyles":false,"background":{"color":"#f4f4f5"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["6"],"bottom":["6"],"right":["2","1.5",null,"1"],"left":["2","1.5",null,"1"]},"unit":["rem","rem","px","rem"],"locked":false}},"columnGapNew":150,"gutterGap":["30px",null,null,null],"columnGap":[null,null,null,null],"rowGap":["30px",30,null,30]} -->
        <div id="gspb_row-id-gsbp-490a2a75-f7fc" class="gspb_row gspb_row-id-gsbp-490a2a75-f7fc wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-490a2a75-f7fc gspb_row--gutter-custom-0"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-866d7828-65a3","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-custom-0","gutterGap":["30px",null,null,null],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"columnSize":"6","brp_columnSize":["12",null,null]} -->
        <div id="gspb_col-id-gsbp-866d7828-65a3" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-866d7828-65a3"><!-- wp:greenshift-blocks/text {"id":"gsbp-1ab86896-b08b","textContent":"...........\u003cbr\u003e...........\u003cbr\u003e...........\u003cbr\u003e...........\u003cbr\u003e...........\u003cbr\u003e...........\u003cbr\u003e...........\u003cbr\u003e...........","typography":{"textShadow":{},"letter_spacing":["10px"],"line_height":[15]},"position":{"positionType":["absolute","","",""],"positions":{"values":{"bottom":["-40px"],"right":["-60px"]}}}} -->
        <div id="gspb_text-id-gsbp-1ab86896-b08b" class="gspb_text gspb_text-id-gsbp-1ab86896-b08b ">...........<br>...........<br>...........<br>...........<br>...........<br>...........<br>...........<br>...........</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-9e803b88-072d","inlineCssStyles":null,"minHeight":[592,786,null,359],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"","columngapUnit":["rem"],"columngap":[null]},"background":{"color":"#e6e6e7"},"border":{"borderRadius":{"values":{"topLeft":"17","topRight":"17","bottomRight":"17","bottomLeft":"17"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"left":[50]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-9e803b88-072d" class="gspb_container gspb_container-gsbp-9e803b88-072d wp-block-greenshift-blocks-container"></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-e1ef4b67-63df","inlineCssStyles":null,"width":[448,null,null,320],"widthUnit":["px","%","%","px"],"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row"],"justifyContent":["center"],"columngap":[1,1,null,0.5],"columngapUnit":["rem","rem",null,"rem"]},"background":{"color":"#2563eb"},"border":{"borderRadius":{"values":{"topLeft":"8","topRight":"8","bottomRight":"8","bottomLeft":"8"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":["2","2",null,"1"],"right":["1.3",null,null,".7"],"bottom":["2","2",null,"1"],"left":["1.3","1.3",null,".7"]},"unit":["rem","rem","px","rem"],"locked":false}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"bottom":["5rem","2rem"],"left":["0rem","0rem"],"top":["rem"],"right":[null,"3rem"]}}}} -->
        <div id="gspb_container-id-gsbp-e1ef4b67-63df" class="gspb_container gspb_container-gsbp-e1ef4b67-63df wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-dfeddda5-9914","inlineCssStyles":null,"iconBox_icon":{"icon":{"font":"rhicon rhi-lightbulb","svg":"","image":""},"fill":"#ffffff","fillhover":"","type":"font","strokeColor":"","strokeWidth":"","rotateZ":0,"iconSize":[40,null,null,32],"strokeColorHover":""}} -->
        <div id="gspb_iconBox-id-gsbp-dfeddda5-9914" class="gspb_iconBox gspb_iconBox-id-gsbp-dfeddda5-9914 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 704 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M352 160c-105.88 0-192 86.12-192 192 0 17.68 14.32 32 32 32s32-14.32 32-32c0-70.6 57.44-128 128-128 17.68 0 32-14.32 32-32s-14.32-32-32-32zM192.12 918.34c0 6.3 1.86 12.44 5.36 17.68l49.020 73.68c5.94 8.92 15.94 14.28 26.64 14.28h157.7c10.72 0 20.72-5.36 26.64-14.28l49.020-73.68c3.48-5.24 5.34-11.4 5.36-17.68l0.1-86.36h-319.92l0.080 86.36zM352 0c-204.56 0-352 165.94-352 352 0 88.74 32.9 169.7 87.12 231.56 33.28 37.98 85.48 117.6 104.84 184.32v0.12h96v-0.24c-0.020-9.54-1.44-19.020-4.3-28.14-11.18-35.62-45.64-129.54-124.34-219.34-41.080-46.86-63.040-106.3-63.22-168.28-0.4-147.28 119.34-256 255.9-256 141.16 0 256 114.84 256 256 0 61.94-22.48 121.7-63.3 168.28-78.22 89.22-112.84 182.94-124.2 218.92-2.805 8.545-4.428 18.381-4.44 28.594l-0 0.006v0.2h96v-0.1c19.36-66.74 71.56-146.36 104.84-184.32 54.2-61.88 87.1-142.84 87.1-231.58 0-194.4-157.6-352-352-352z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-d3cbea7e-fda9","inlineCssStyles":null,"textContent":"“You made it so simple. My new site is so much faster and easier to work with than my old site.”","typography":{"textShadow":{},"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1.1,null,null,0.9],"line_height":[1.8,null,null,1.3],"customweight":"custom","customweightnumber":500,"color":"#ffffff"}} -->
        <div id="gspb_text-id-gsbp-d3cbea7e-fda9" class="gspb_text gspb_text-id-gsbp-d3cbea7e-fda9 ">“You made it so simple. My new site is so much faster and easier to work with than my old site.”</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-3bb73da5-7081","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-custom-0","gutterGap":["30px",null,null,null],"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["column"],"justifyContent":["center"]},"columnSize":"6","brp_columnSize":["12",null,null]} -->
        <div id="gspb_col-id-gsbp-3bb73da5-7081" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-3bb73da5-7081"><!-- wp:greenshift-blocks/container {"id":"gsbp-f74dcb5e-90da","inlineCssStyles":null,"spacing":{"margin":{"values":{"top":["2.5","2.5"]},"unit":["rem","rem","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":true}}} -->
        <div id="gspb_container-id-gsbp-f74dcb5e-90da" class="gspb_container gspb_container-gsbp-f74dcb5e-90da wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-491947c9-41bd","inlineCssStyles":null,"headingContent":"We make things easy for projects.","typography":{"textShadow":{},"customweight":"custom","customweightnumber":700,"sizeUnit":"rem","size":[3,2.3,null,1.9],"lineHeightUnit":["rem"],"line_height":[3.4,2.5]}} -->
        <h2 id="gspb_heading-id-gsbp-491947c9-41bd" class="gspb_heading gspb_heading-id-gsbp-491947c9-41bd ">We make things easy for projects.</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-89126c29-d4a7","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia conse duis enim velit mollit. Exercitation veniam.","spacing":{"margin":{"values":{"top":["2.2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[2],"color":"#000000"}} -->
        <div id="gspb_text-id-gsbp-89126c29-d4a7" class="gspb_text gspb_text-id-gsbp-89126c29-d4a7 ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia conse duis enim velit mollit. Exercitation veniam.</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-83ace1f8-0350","inlineCssStyles":null,"textContent":"Velit officia conse duis enim velit mollit. Exercit ation veniam consequat sunt nostrud amet.","spacing":{"margin":{"values":{"top":["1.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[2],"color":"#010101"}} -->
        <div id="gspb_text-id-gsbp-83ace1f8-0350" class="gspb_text gspb_text-id-gsbp-83ace1f8-0350 ">Velit officia conse duis enim velit mollit. Exercit ation veniam consequat sunt nostrud amet.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/qasection',
        array(
            'title'       => __('QA section', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('faq', 'qa'),
            'description' => _x('QA section', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-5e9baeff-b823","inlineCssStyles":null,"align":"full","width":[1024,null,null,null],"displayStyles":false,"background":{"color":"#18181b"},"spacing":{"margin":{"values":{"top":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["6","4",null,"2.5"],"bottom":["6","4",null,"2.5"],"right":[0],"left":[0]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-5e9baeff-b823" class="gspb_row gspb_row-id-gsbp-5e9baeff-b823 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-5e9baeff-b823"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-26d79e4b-ff9c","inlineCssStyles":null,"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","alignItems":["center"]},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":["2","1.5",null,"1"],"bottom":[0],"left":["2","1.5",null,"1"]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-26d79e4b-ff9c" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-26d79e4b-ff9c"><!-- wp:greenshift-blocks/heading {"id":"gsbp-611498b6-3fed","inlineCssStyles":null,"headingContent":"Questions \u0026amp; Answers","typography":{"alignment":["center"],"textShadow":{},"sizeUnit":"rem","size":[3,2.3,null,1.9],"customweight":"custom","customweightnumber":700,"lineHeightUnit":["rem"],"line_height":[3,2.5],"color":"#ffffff"}} -->
        <h2 id="gspb_heading-id-gsbp-611498b6-3fed" class="gspb_heading gspb_heading-id-gsbp-611498b6-3fed ">Questions &amp; Answers</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-6e5823ec-4937","inlineCssStyles":null,"textContent":"Explore the common questions and answers about Celebration","typography":{"alignment":["center"],"textShadow":{},"lineHeightUnit":["px"],"line_height":[null],"color":"#ffffff"}} -->
        <div id="gspb_text-id-gsbp-6e5823ec-4937" class="gspb_text gspb_text-id-gsbp-6e5823ec-4937 ">Explore the common questions and answers about Celebration</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/row {"id":"gsbp-b7990eb0-73cb","inlineCssStyles":null,"width":[null,null,null,null],"columnPosition":"","columnJustify":"","displayStyles":false,"spacing":{"margin":{"values":{"top":["5",null,null,"3"]},"unit":["rem","px","px","rem"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-b7990eb0-73cb" class="gspb_row gspb_row-id-gsbp-b7990eb0-73cb wp-block-greenshift-blocks-row gspb_row-id-gsbp-b7990eb0-73cb"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-a93101e6-c622","inlineCssStyles":null,"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-a93101e6-c622" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-a93101e6-c622"><!-- wp:greenshift-blocks/container {"id":"gsbp-4172bb57-1614","inlineCssStyles":null,"flexbox":{"type":"grid","enable":false,"gridcolumns":[2,null,null,1],"columngap":[5],"rowgap":[4],"columngapUnit":["rem"],"rowgapUnit":["rem"]}} -->
        <div id="gspb_container-id-gsbp-4172bb57-1614" class="gspb_container gspb_container-gsbp-4172bb57-1614 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-01af9180-9015","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[0.8]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-01af9180-9015" class="gspb_container gspb_container-gsbp-01af9180-9015 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-985b3d1c-c1f7","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-985b3d1c-c1f7" class="gspb_container gspb_container-gsbp-985b3d1c-c1f7 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-dc5115c1-fc88","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[10],"right":[10],"bottom":[10],"left":[10]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#3f3f46"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-arrow-right","svg":"","image":""},"fill":"#ffffff","fillhover":"#ffffff","type":"font","iconSize":["17px"]},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-dc5115c1-fc88" class="gspb_iconBox gspb_iconBox-id-gsbp-dc5115c1-fc88 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 896 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M436.202 76.202l-39.598 39.598c-9.372 9.372-9.372 24.568 0 33.942l310.26 310.258h-682.864c-13.254 0-24 10.746-24 24v56c0 13.254 10.746 24 24 24h682.864l-310.26 310.26c-9.372 9.372-9.372 24.568 0 33.942l39.598 39.598c9.372 9.372 24.568 9.372 33.942 0l418.828-418.828c9.372-9.372 9.372-24.568 0-33.942l-418.83-418.828c-9.372-9.374-24.568-9.374-33.94 0z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-f7b94c2c-bad7","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-f7b94c2c-bad7" class="gspb_container gspb_container-gsbp-f7b94c2c-bad7 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-99667bca-1bfa","inlineCssStyles":null,"textContent":"How to create an account?","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":600},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-99667bca-1bfa" class="gspb_text gspb_text-id-gsbp-99667bca-1bfa ">How to create an account?</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-db62b19b-78cb","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#a1a1aa","sizeUnit":"rem","size":[1]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-db62b19b-78cb" class="gspb_text gspb_text-id-gsbp-db62b19b-78cb ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-20ea4d8d-b6ec","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[0.8]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-20ea4d8d-b6ec" class="gspb_container gspb_container-gsbp-20ea4d8d-b6ec wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-d57fb59b-7e83","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-d57fb59b-7e83" class="gspb_container gspb_container-gsbp-d57fb59b-7e83 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-55b9259f-e1a1","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[10],"right":[10],"bottom":[10],"left":[10]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#3f3f46"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-arrow-right","svg":"","image":""},"fill":"#ffffff","fillhover":"#ffffff","type":"font","iconSize":["17px"]},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-55b9259f-e1a1" class="gspb_iconBox gspb_iconBox-id-gsbp-55b9259f-e1a1 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 896 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M436.202 76.202l-39.598 39.598c-9.372 9.372-9.372 24.568 0 33.942l310.26 310.258h-682.864c-13.254 0-24 10.746-24 24v56c0 13.254 10.746 24 24 24h682.864l-310.26 310.26c-9.372 9.372-9.372 24.568 0 33.942l39.598 39.598c9.372 9.372 24.568 9.372 33.942 0l418.828-418.828c9.372-9.372 9.372-24.568 0-33.942l-418.83-418.828c-9.372-9.374-24.568-9.374-33.94 0z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-5c700752-cf05","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-5c700752-cf05" class="gspb_container gspb_container-gsbp-5c700752-cf05 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-3df03d62-206e","inlineCssStyles":null,"textContent":"How can I make payment?","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":600},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-3df03d62-206e" class="gspb_text gspb_text-id-gsbp-3df03d62-206e ">How can I make payment?</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-28ee3aa2-4977","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#a1a1aa","sizeUnit":"rem","size":[1]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-28ee3aa2-4977" class="gspb_text gspb_text-id-gsbp-28ee3aa2-4977 ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-1d6cb4bc-ad9e","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[0.8]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-1d6cb4bc-ad9e" class="gspb_container gspb_container-gsbp-1d6cb4bc-ad9e wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-9177c9d1-d086","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-9177c9d1-d086" class="gspb_container gspb_container-gsbp-9177c9d1-d086 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-40706615-0422","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[10],"right":[10],"bottom":[10],"left":[10]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#3f3f46"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-arrow-right","svg":"","image":""},"fill":"#ffffff","fillhover":"#ffffff","type":"font","iconSize":["17px"]},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-40706615-0422" class="gspb_iconBox gspb_iconBox-id-gsbp-40706615-0422 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 896 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M436.202 76.202l-39.598 39.598c-9.372 9.372-9.372 24.568 0 33.942l310.26 310.258h-682.864c-13.254 0-24 10.746-24 24v56c0 13.254 10.746 24 24 24h682.864l-310.26 310.26c-9.372 9.372-9.372 24.568 0 33.942l39.598 39.598c9.372 9.372 24.568 9.372 33.942 0l418.828-418.828c9.372-9.372 9.372-24.568 0-33.942l-418.83-418.828c-9.372-9.374-24.568-9.374-33.94 0z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-5b9bbf6c-0c3f","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-5b9bbf6c-0c3f" class="gspb_container gspb_container-gsbp-5b9bbf6c-0c3f wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-22dac27e-d6fb","inlineCssStyles":null,"textContent":"Do you provide discounts?","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":600},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-22dac27e-d6fb" class="gspb_text gspb_text-id-gsbp-22dac27e-d6fb ">Do you provide discounts?</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-156fad3a-235a","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#a1a1aa","sizeUnit":"rem","size":[1]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-156fad3a-235a" class="gspb_text gspb_text-id-gsbp-156fad3a-235a ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-361852b6-b639","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[0.8]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-361852b6-b639" class="gspb_container gspb_container-gsbp-361852b6-b639 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-a0e40cbb-87dc","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-a0e40cbb-87dc" class="gspb_container gspb_container-gsbp-a0e40cbb-87dc wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-1f1ad75b-c541","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[10],"right":[10],"bottom":[10],"left":[10]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#3f3f46"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-arrow-right","svg":"","image":""},"fill":"#ffffff","fillhover":"#ffffff","type":"font","iconSize":["17px"]},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-1f1ad75b-c541" class="gspb_iconBox gspb_iconBox-id-gsbp-1f1ad75b-c541 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 896 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M436.202 76.202l-39.598 39.598c-9.372 9.372-9.372 24.568 0 33.942l310.26 310.258h-682.864c-13.254 0-24 10.746-24 24v56c0 13.254 10.746 24 24 24h682.864l-310.26 310.26c-9.372 9.372-9.372 24.568 0 33.942l39.598 39.598c9.372 9.372 24.568 9.372 33.942 0l418.828-418.828c9.372-9.372 9.372-24.568 0-33.942l-418.83-418.828c-9.372-9.374-24.568-9.374-33.94 0z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-0e123419-deaf","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-0e123419-deaf" class="gspb_container gspb_container-gsbp-0e123419-deaf wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-8f7a7910-3aa4","inlineCssStyles":null,"textContent":"How do you provide support?","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":600},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-8f7a7910-3aa4" class="gspb_text gspb_text-id-gsbp-8f7a7910-3aa4 ">How do you provide support?</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-1f7bd4dc-ca75","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["1"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#a1a1aa","sizeUnit":"rem","size":[1]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-1f7bd4dc-ca75" class="gspb_text gspb_text-id-gsbp-1f7bd4dc-ca75 ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis enim velit mollit.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-6cf5f675-a842","inlineCssStyles":null,"textContent":"Didn’t find the answer you are looking for? \u003ca rel=\u0022noreferrer noopener\u0022 href=\u0022https://greenshiftwp.com/\u0022 data-type=\u0022URL\u0022 data-id=\u0022https://greenshiftwp.com/\u0022 target=\u0022_blank\u0022\u003eContact our support\u003c/a\u003e","background":{"color":"#27272a"},"border":{"borderRadius":{"values":{"topLeft":"99","topRight":"99","bottomRight":"99","bottomLeft":"99"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":["5",null,null,"3"]},"unit":["rem","px","px","rem"],"locked":false},"padding":{"values":{"top":["1"],"right":["2"],"bottom":["1"],"left":["2"]},"unit":["rem","px","px","px"],"locked":false}},"typography":{"alignment":["center"],"textShadow":{},"color":"#ffffff","colorlinks":"#fcd34d","colorlinksHover":"#eebc16"}} -->
        <div id="gspb_text-id-gsbp-6cf5f675-a842" class="gspb_text gspb_text-id-gsbp-6cf5f675-a842 ">Didn’t find the answer you are looking for? <a rel="noreferrer noopener" href="https://greenshiftwp.com/" data-type="URL" data-id="https://greenshiftwp.com/" target="_blank">Contact our support</a></div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/circlecloud',
        array(
            'title'       => __('Circle cloud', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container', 'greenshift-blocks/image'),
            'keywords' => array('logos', 'features'),
            'description' => _x('circle cloud', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-5e9baeff-b823","inlineCssStyles":null,"align":"full","width":[1290,null,null,null],"displayStyles":false,"background":{"color":"#f4f4f5"},"spacing":{"margin":{"values":{"top":[null]},"unit":["rem","px","px","px"],"locked":true},"padding":{"values":{"top":["4","4",null,"2.5"],"bottom":["4","4",null,"2.5"],"right":[0],"left":[0]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-5e9baeff-b823" class="gspb_row gspb_row-id-gsbp-5e9baeff-b823 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-5e9baeff-b823"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-1e02c348-7acd","inlineCssStyles":null,"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","alignItems":["center"]},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":["2","1.5",null,"1"],"bottom":[0],"left":["2","1.5",null,"1"]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-1e02c348-7acd" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-1e02c348-7acd"><!-- wp:greenshift-blocks/heading {"id":"gsbp-d7f5f49d-d844","inlineCssStyles":null,"headingContent":"Connect with all apps","typography":{"alignment":["center"],"textShadow":{},"sizeUnit":"rem","size":[3,2.3,null,1.9],"customweight":"custom","customweightnumber":700,"lineHeightUnit":["rem"],"line_height":[3,2.5],"color":"#000000"}} -->
        <h2 id="gspb_heading-id-gsbp-d7f5f49d-d844" class="gspb_heading gspb_heading-id-gsbp-d7f5f49d-d844 ">Connect with all apps</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-58ae368a-9a91","inlineCssStyles":null,"variableWidth":false,"variableType":"max","width":[576,null,90,90],"widthUnit":["px","%","%","%"]} -->
        <div id="gspb_container-id-gsbp-58ae368a-9a91" class="gspb_container gspb_container-gsbp-58ae368a-9a91 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-a00800b8-0b44","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis.","typography":{"alignment":["center"],"textShadow":{},"lineHeightUnit":["px"],"line_height":[null],"color":"#000000"}} -->
        <div id="gspb_text-id-gsbp-a00800b8-0b44" class="gspb_text gspb_text-id-gsbp-a00800b8-0b44 ">Amet minim mollit non deserunt ullamco est sit aliqua dolor do amet sint. Velit officia consequat duis.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-45390556-29f6","inlineCssStyles":null,"buttonContent":"Check all aps","background":{"color":"#f4f4f5","hoverColor":"#000000"},"spacing":{"margin":{"values":{"top":["2.3"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":["1"],"bottom":["1"],"right":["2"],"left":["2"]},"unit":["rem","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":"6","topRight":"6","bottomRight":"6","bottomLeft":"6"},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[2]},"color":{"all":["#e4e4e7"]},"styleHover":{},"sizeHover":{},"colorHover":{"all":["#000000"]}},"typography":{"textShadow":{},"customweight":"custom","customweightnumber":600,"sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.5],"color":"#000000","colorHover":"#ffffff"}} -->
        <div id="gspb_button-id-gsbp-45390556-29f6" class="gspb_button_wrapper gspb_button-id-gsbp-45390556-29f6 wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Check all aps</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-b418bd86-daae","inlineCssStyles":null,"width":[100,null,null,null],"minHeight":[500,null,null,null],"minHeightUnit":["px","px","px","px"],"background":{"color":"#f4f4f5"},"position":{"positionType":["relative","","",""],"positions":{"values":{}}}} -->
        <div id="gspb_container-id-gsbp-b418bd86-daae" class="gspb_container gspb_container-gsbp-b418bd86-daae wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-9421d3b1-9e12","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[55,null,null,null],"customHeight":[54,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["12rem"],"left":["3.5vw"]}}},"mediaurl":"https://api.lorem.space/image/watch?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-9421d3b1-9e12" class="gspb_image gspb_image-id-gsbp-9421d3b1-9e12 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/watch?w=150&amp;h=150" data-src="" alt="" width="55" height="54"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-d5bfb30e-8e6c","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[80,null,null,null],"customHeight":[80,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["","","",""],"positions":{"values":{"top":["3rem"],"left":["15vw"]}}},"mediaurl":"https://api.lorem.space/image/drink?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-d5bfb30e-8e6c" class="gspb_image gspb_image-id-gsbp-d5bfb30e-8e6c wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/drink?w=150&amp;h=150" data-src="" alt="" width="80" height="80"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-fe50fdcd-45e3","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[80,null,null,null],"customHeight":[80,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["15rem"],"left":["18vw"]}}},"mediaurl":"https://api.lorem.space/image/house?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-fe50fdcd-45e3" class="gspb_image gspb_image-id-gsbp-fe50fdcd-45e3 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/house?w=150&amp;h=150" data-src="" alt="" width="80" height="80"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-a3b06146-5a77","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[65,null,null,null],"customHeight":[65,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["22rem"],"left":["8vw"]}}},"mediaurl":"https://api.lorem.space/image/shoes?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-a3b06146-5a77" class="gspb_image gspb_image-id-gsbp-a3b06146-5a77 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/shoes?w=150&amp;h=150" data-src="" alt="" width="65" height="65"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-ddb74cb3-18e4","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[70,null,null,null],"customHeight":[70,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["5rem"],"left":["29vw"]}}},"mediaurl":"https://api.lorem.space/image/game?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-ddb74cb3-18e4" class="gspb_image gspb_image-id-gsbp-ddb74cb3-18e4 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/game?w=150&amp;h=150" data-src="" alt="" width="70" height="70"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-97f585bb-2e97","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[120,null,null,null],"customHeight":[120,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["10rem"],"left":[null],"right":["25vw"]}}},"mediaurl":"https://api.lorem.space/image/shoes?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-97f585bb-2e97" class="gspb_image gspb_image-id-gsbp-97f585bb-2e97 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/shoes?w=150&amp;h=150" data-src="" alt="" width="120" height="120"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-e35033e5-e422","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[70,null,null,null],"customHeight":[70,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["20rem"],"left":["29vw"]}}},"mediaurl":"https://api.lorem.space/image/furniture?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-e35033e5-e422" class="gspb_image gspb_image-id-gsbp-e35033e5-e422 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/furniture?w=150&amp;h=150" data-src="" alt="" width="70" height="70"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-a1bbc571-99fc","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[70,null,null,null],"customHeight":[70,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["18rem"],"left":[null],"right":["14vw"]}}},"mediaurl":"https://api.lorem.space/image/game?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-a1bbc571-99fc" class="gspb_image gspb_image-id-gsbp-a1bbc571-99fc wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/game?w=150&amp;h=150" data-src="" alt="" width="70" height="70"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-28d21404-f844","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[55,null,null,null],"customHeight":[55,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["5rem"],"left":["50rem"]}}},"mediaurl":"https://api.lorem.space/image/watch?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-28d21404-f844" class="gspb_image gspb_image-id-gsbp-28d21404-f844 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/watch?w=150&amp;h=150" data-src="" alt="" width="55" height="55"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-635c4ccb-48f0","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[80,null,null,null],"customHeight":[80,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["13rem"],"left":[null],"right":["6vw"]}}},"mediaurl":"https://api.lorem.space/image/car?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-635c4ccb-48f0" class="gspb_image gspb_image-id-gsbp-635c4ccb-48f0 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/car?w=150&amp;h=150" data-src="" alt="" width="80" height="80"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-a953f247-5f87","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[70,null,null,null],"customHeight":[70,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["7rem"],"left":[null],"right":["1vw"]}}},"mediaurl":"https://api.lorem.space/image/watch?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-a953f247-5f87" class="gspb_image gspb_image-id-gsbp-a953f247-5f87 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/watch?w=150&amp;h=150" data-src="" alt="" width="70" height="70"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-db9a036f-2292","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[55,null,null,null],"customHeight":[55,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["23rem"],"left":[null],"right":["1vw"]}}},"mediaurl":"https://api.lorem.space/image/shoes?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-db9a036f-2292" class="gspb_image gspb_image-id-gsbp-db9a036f-2292 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/shoes?w=150&amp;h=150" data-src="" alt="" width="55" height="55"/></div>
        <!-- /wp:greenshift-blocks/image --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/productcta',
        array(
            'title'       => __('Product Price table', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('cta', 'features', 'product'),
            'description' => _x('Product CTA', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-d2b23238-d2cc","align":"full","gutterClassName":"gspb_row\u002d\u002dgutter-custom-0","rowLayout":"2","width":[960,null,null,null],"displayStyles":false,"background":{"color":"#18181b"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["6","4",null,"2.5"],"bottom":["6","4",null,"2.5"],"right":["2","1.5",null,"1"],"left":["2","1.5",null,"1"]},"unit":["rem","rem","px","rem"],"locked":false}},"columnGapNew":100,"rowGap":[50,null,null,null]} -->
        <div id="gspb_row-id-gsbp-d2b23238-d2cc" class="gspb_row gspb_row-id-gsbp-d2b23238-d2cc wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-d2b23238-d2cc gspb_row--gutter-custom-0"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-bbc2dc8f-0e56","gutterclass":"gspb_row\u002d\u002dgutter-100","flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","justifyContent":["space-between"]},"columnSize":"6","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["1.3",0],"right":[0],"bottom":["1.3",0],"left":[0]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-bbc2dc8f-0e56" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-bbc2dc8f-0e56"><!-- wp:greenshift-blocks/heading {"id":"gsbp-0e9731fc-07fc","headingContent":"Join 35k+ web professionals \u0026amp; build your website","typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[3,2.3,null,1.9],"customweight":"custom","customweightnumber":700,"lineHeightUnit":["rem","rem"],"line_height":[3,2.5,null,2.2]}} -->
        <h2 id="gspb_heading-id-gsbp-0e9731fc-07fc" class="gspb_heading gspb_heading-id-gsbp-0e9731fc-07fc ">Join 35k+ web professionals &amp; build your website</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-e0edfec9-ccbf"} -->
        <div id="gspb_container-id-gsbp-e0edfec9-ccbf" class="gspb_container gspb_container-gsbp-e0edfec9-ccbf wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-a29e6f4c-9563","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"alignItems":["center"],"justifyContent":["flex-start"],"marginUnit":["rem"],"marginRight":["0.2"]},"animation":{"duration":700,"easing":"ease"},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"bottom":[null],"top":[null]},"unit":["rem","px","px","px"],"locked":true},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-a29e6f4c-9563" class="gspb_container gspb_container-gsbp-a29e6f4c-9563 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-a3b50702-c5f2","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"background":{"color":"#e2eefd"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-star-full","svg":"","image":""},"fill":"#f4751d","fillhover":"","type":"font","iconSize":[20]},"animation":{"duration":700,"easing":"ease"},"responsive":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-a3b50702-c5f2" class="gspb_iconBox gspb_iconBox-id-gsbp-a3b50702-c5f2 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1024 397.050l-353.78-51.408-158.22-320.582-158.216 320.582-353.784 51.408 256 249.538-60.432 352.352 316.432-166.358 316.432 166.358-60.434-352.352 256.002-249.538z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/iconbox {"id":"gsbp-1a7b443e-8bc8","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"background":{"color":"#e2eefd"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-star-full","svg":"","image":""},"fill":"#f4751d","fillhover":"","type":"font","iconSize":[20]},"animation":{"duration":700,"easing":"ease"},"responsive":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-1a7b443e-8bc8" class="gspb_iconBox gspb_iconBox-id-gsbp-1a7b443e-8bc8 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1024 397.050l-353.78-51.408-158.22-320.582-158.216 320.582-353.784 51.408 256 249.538-60.432 352.352 316.432-166.358 316.432 166.358-60.434-352.352 256.002-249.538z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/iconbox {"id":"gsbp-2ab9fab3-0a6f","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"background":{"color":"#e2eefd"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-star-full","svg":"","image":""},"fill":"#f4751d","fillhover":"","type":"font","iconSize":[20]},"animation":{"duration":700,"easing":"ease"},"responsive":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-2ab9fab3-0a6f" class="gspb_iconBox gspb_iconBox-id-gsbp-2ab9fab3-0a6f wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1024 397.050l-353.78-51.408-158.22-320.582-158.216 320.582-353.784 51.408 256 249.538-60.432 352.352 316.432-166.358 316.432 166.358-60.434-352.352 256.002-249.538z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/iconbox {"id":"gsbp-cd35e5b2-b199","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"background":{"color":"#e2eefd"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-star-full","svg":"","image":""},"fill":"#f4751d","fillhover":"","type":"font","iconSize":[20]},"animation":{"duration":700,"easing":"ease"},"responsive":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-cd35e5b2-b199" class="gspb_iconBox gspb_iconBox-id-gsbp-cd35e5b2-b199 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1024 397.050l-353.78-51.408-158.22-320.582-158.216 320.582-353.784 51.408 256 249.538-60.432 352.352 316.432-166.358 316.432 166.358-60.434-352.352 256.002-249.538z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/iconbox {"id":"gsbp-9ff277f4-1f92","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"background":{"color":"#e2eefd"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"iconBox_icon":{"icon":{"font":"rhicon rhi-star-full","svg":"","image":""},"fill":"#f4751d","fillhover":"","type":"font","iconSize":[20]},"animation":{"duration":700,"easing":"ease"},"responsive":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-9ff277f4-1f92" class="gspb_iconBox gspb_iconBox-id-gsbp-9ff277f4-1f92 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1024 397.050l-353.78-51.408-158.22-320.582-158.216 320.582-353.784 51.408 256 249.538-60.432 352.352 316.432-166.358 316.432 166.358-60.434-352.352 256.002-249.538z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-b11a1117-f501","textContent":"“You made it so simple. My new site is so much faster and easier to work with than my old site. I just choose the page, make the change.”","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"bottom":[0],"top":["1.8"],"right":[0],"left":[0]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"left":[0],"top":[0],"right":[0],"bottom":[0]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"typography":{"textShadow":{},"size":[18],"color":"#ffffff"},"animation":{"duration":700,"easing":"ease"},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{}} -->
        <div id="gspb_text-id-gsbp-b11a1117-f501" class="gspb_text gspb_text-id-gsbp-b11a1117-f501 ">“You made it so simple. My new site is so much faster and easier to work with than my old site. I just choose the page, make the change.”</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-6f953417-3189","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"marginRight":[15],"shrinkzero":false},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"left":[0]},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-6f953417-3189" class="gspb_container gspb_container-gsbp-6f953417-3189 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-12073617-6d4a","width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[40,null,null,null],"customHeight":[38,null,null,null],"border":{"borderRadius":{"values":{"topLeft":["99"],"topRight":["99"],"bottomRight":["99"],"bottomLeft":["99"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"mediaurl":"https://api.lorem.space/image/face?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-12073617-6d4a" class="gspb_image gspb_image-id-gsbp-12073617-6d4a wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/face?w=150&amp;h=150" data-src="" alt="" width="40" height="38"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-c1961c20-18ae","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-c1961c20-18ae" class="gspb_container gspb_container-gsbp-c1961c20-18ae wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-8be47785-4173","textContent":"John Doe","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"size":[1],"customweight":"bold","color":"#ffffff","sizeUnit":"rem","lineHeightUnit":["rem"],"line_height":[1.5]},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{}} -->
        <div id="gspb_text-id-gsbp-8be47785-4173" class="gspb_text gspb_text-id-gsbp-8be47785-4173 ">John Doe</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-3863795e-19e1","textContent":"Freelance React Developer","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"size":[0.9],"customweight":"normal","color":"#a1a1a1","sizeUnit":"rem","line_height":[1.3],"lineHeightUnit":["rem"]},"animation":{"duration":700,"easing":"ease"},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{}} -->
        <div id="gspb_text-id-gsbp-3863795e-19e1" class="gspb_text gspb_text-id-gsbp-3863795e-19e1 ">Freelance React Developer</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-90898490-eddf","gutterclass":"gspb_row\u002d\u002dgutter-100","columnSize":"6","background":{"color":"#ffffff"},"border":{"borderRadius":{"values":{"topLeft":"6","topRight":"6","bottomRight":"6","bottomLeft":"6"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["2.5"],"right":["2.5"],"bottom":["2.2"],"left":["2.5"]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-90898490-eddf" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-90898490-eddf"><!-- wp:greenshift-blocks/heading {"id":"gsbp-168db7a1-9ac3","headingTag":"h3","headingContent":"SINGLE PACK","typography":{"textShadow":{},"customweight":"custom","customweightnumber":600,"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[0.8],"line_height":[1],"letter_spacing":[1.6],"color":"#7c3aed"}} -->
        <h3 id="gspb_heading-id-gsbp-168db7a1-9ac3" class="gspb_heading gspb_heading-id-gsbp-168db7a1-9ac3 ">SINGLE PACK</h3>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-a6f6813f-9c67","textContent":"$ 99","spacing":{"margin":{"values":{"top":["1"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[3.8],"line_height":[3.8],"color":"#000000","customweight":"custom","customweightnumber":700}} -->
        <div id="gspb_text-id-gsbp-a6f6813f-9c67" class="gspb_text gspb_text-id-gsbp-a6f6813f-9c67 ">$ 99</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/iconlist {"id":"gsbp-d85f275c-ef6c","iconsList":[{"icon":{"icon":{"font":"rhicon rhi-paper-plane","svg":"\u003csvg class=\u0022pf me qd dn\u0022 xmlns=\u0022http://www.w3.org/2000/svg\u0022 viewBox=\u00220 0 20 20\u0022 fill=\u0022currentColor\u0022\u003e\n                                    \u003cpath fill-rule=\u0022evenodd\u0022 d=\u0022M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z\u0022 clip-rule=\u0022evenodd\u0022\u003e\u003c/path\u003e\n                                \u003c/svg\u003e","image":""},"fill":"#10b981","fillhover":"","iconSize":[21,null,null,null],"rotateY":false,"rotateX":false,"type":"svg"},"content":"1 Domain License"},{"icon":{"icon":{"font":"rhicon rhi-paper-plane","svg":"\u003csvg class=\u0022pf me qd dn\u0022 xmlns=\u0022http://www.w3.org/2000/svg\u0022 viewBox=\u00220 0 20 20\u0022 fill=\u0022currentColor\u0022\u003e\n                                    \u003cpath fill-rule=\u0022evenodd\u0022 d=\u0022M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z\u0022 clip-rule=\u0022evenodd\u0022\u003e\u003c/path\u003e\n                                \u003c/svg\u003e","image":""},"fill":"#10b981","fillhover":"","iconSize":[21,null,null,null],"rotateY":false,"rotateX":false,"type":"svg"},"content":"Full Celebration Library"},{"icon":{"icon":{"font":"rhicon rhi-paper-plane","svg":"\u003csvg class=\u0022pf me qd dn\u0022 xmlns=\u0022http://www.w3.org/2000/svg\u0022 viewBox=\u00220 0 20 20\u0022 fill=\u0022currentColor\u0022\u003e\n                                    \u003cpath fill-rule=\u0022evenodd\u0022 d=\u0022M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z\u0022 clip-rule=\u0022evenodd\u0022\u003e\u003c/path\u003e\n                                \u003c/svg\u003e","image":""},"fill":"#10b981","fillhover":"","iconSize":[21,null,null,null],"rotateY":false,"rotateX":false,"type":"svg"},"content":"120+ Coded Blocks"},{"icon":{"icon":{"font":"rhicon rhi-paper-plane","svg":"\u003csvg class=\u0022pf me qd dn\u0022 xmlns=\u0022http://www.w3.org/2000/svg\u0022 viewBox=\u00220 0 20 20\u0022 fill=\u0022currentColor\u0022\u003e\n                                    \u003cpath fill-rule=\u0022evenodd\u0022 d=\u0022M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z\u0022 clip-rule=\u0022evenodd\u0022\u003e\u003c/path\u003e\n                                \u003c/svg\u003e","image":""},"fill":"#10b981","fillhover":"","iconSize":[21,null,null,null],"rotateY":false,"rotateX":false,"type":"svg"},"content":"Design Files Included"},{"icon":{"icon":{"font":"rhicon rhi-paper-plane","svg":"\u003csvg class=\u0022pf me qd dn\u0022 xmlns=\u0022http://www.w3.org/2000/svg\u0022 viewBox=\u00220 0 20 20\u0022 fill=\u0022currentColor\u0022\u003e\n                                    \u003cpath fill-rule=\u0022evenodd\u0022 d=\u0022M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z\u0022 clip-rule=\u0022evenodd\u0022\u003e\u003c/path\u003e\n                                \u003c/svg\u003e","image":""},"fill":"#10b981","fillhover":"","iconSize":[21,null,null,null],"rotateY":false,"rotateX":false,"type":"svg"},"content":"Premium Support"}],"spacing":{"margin":{"values":{"top":["1.5"],"left":["-0.5"],"bottom":[0],"right":[0]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}},"typography":{"textShadow":{},"customweight":"custom","customweightnumber":500,"sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.5]},"responsive":{"customcss":"{GREENSHIFT}\n.gspb_iconsList__item__text {\n    margin: 0px;\n}\n"}} -->
        <div id="gspb_iconsList-id-gsbp-d85f275c-ef6c" class="gspb_iconsList gspb_iconsList-id-gsbp-d85f275c-ef6c wp-block-greenshift-blocks-iconlist"><div class="gspb_iconsList__item" data-id="0"><svg class="pf me qd dn" xmlns="http://www.w3.org/2000/svg" style="width:5rem;height:5rem;margin:10px" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>                                </svg><span class="gspb_iconsList__item__text">1 Domain License</span></div><div class="gspb_iconsList__item" data-id="1"><svg class="pf me qd dn" xmlns="http://www.w3.org/2000/svg" style="width:5rem;height:5rem;margin:10px" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>                                </svg><span class="gspb_iconsList__item__text">Full Celebration Library</span></div><div class="gspb_iconsList__item" data-id="2"><svg class="pf me qd dn" xmlns="http://www.w3.org/2000/svg" style="width:5rem;height:5rem;margin:10px" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>                                </svg><span class="gspb_iconsList__item__text">120+ Coded Blocks</span></div><div class="gspb_iconsList__item" data-id="3"><svg class="pf me qd dn" xmlns="http://www.w3.org/2000/svg" style="width:5rem;height:5rem;margin:10px" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>                                </svg><span class="gspb_iconsList__item__text">Design Files Included</span></div><div class="gspb_iconsList__item" data-id="4"><svg class="pf me qd dn" xmlns="http://www.w3.org/2000/svg" style="width:5rem;height:5rem;margin:10px" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>                                </svg><span class="gspb_iconsList__item__text">Premium Support</span></div></div>
        <!-- /wp:greenshift-blocks/iconlist -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-12583460-6f5a","buttonContent":"Get full access","align":"flex-start","background":{"backgroundState":"Gradient","backgroundHoverState":"Gradient","gradient":"linear-gradient(92deg,rgb(168,71,207) 1%,rgb(120,70,207) 46%,rgb(70,81,207) 97%)"},"spacing":{"margin":{"values":{"bottom":[null],"top":["1.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":["1"],"bottom":["1"],"right":["2.5"],"left":["2.5"]},"unit":["rem","px","px","px"],"locked":false},"overflow":[null,null,null,null]},"iconSpacing":{"margin":{"values":{"left":[null]},"unit":["rem","px","px","px"],"locked":true},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":"99","topRight":"99","bottomRight":"99","bottomLeft":"99"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"blockWidth":{"customWidth":{"value":[100],"unit":["%","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom"},"typography":{"colorState":"Classic","sizeUnit":"rem","lineHeightUnit":["rem","px","px","px"],"textShadow":{"hShadow":"0","hShadow2":"","hShadow3":"","vShadow":"2","vShadow2":"","vShadow3":"","blur":"1","blur2":"","blur3":"","color":"#00000066","color2":"","color3":""},"fluidSizeMin":"1.5rem","fluidSizeMax":"2.1rem","fluidSizePerfect":"1.7vw","fluidLineMin":"2rem","fluidLineMax":"2.5rem","fluidLinePerfect":"2.1vw","customweight":"custom","size":[1],"line_height":[1.5],"customweightnumber":600,"alignment":["center"]},"animation":{"duration":700,"easing":"ease","usegsap":false,"y":30,"rx":null,"s":0.5,"o":"0","type":""},"responsive":{"hideOnDesktop":false,"hideOnTablet":false,"hideOnMobile":false,"hideOnLandscape":false,"customcss":""},"csstransform":{"timebg":"","time":"","timeshadow":"","timeborder":"","timeopacity":"","timetransform":"","timecolor":"","timefilter":""},"buttonLink":"https://greenshiftwp.com/","linkNewWindow":true,"enableIcon":false,"iconRight":false,"iconBox_icon":{"icon":{"font":"rhicon rhi-arrow-right","svg":"","image":""},"fill":"#ffffff","fillhover":"#ffffff","type":"font"},"enableblockIcon":false} -->
        <div id="gspb_button-id-gsbp-12583460-6f5a" class="gspb_button_wrapper gspb_button-id-gsbp-12583460-6f5a wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" href="https://greenshiftwp.com/" target="_blank" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Get full access</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button -->
        
        <!-- wp:greenshift-blocks/iconlist {"id":"gsbp-b0aad058-4ded","iconsList":[{"icon":{"icon":{"font":"rhicon rhi-lock-alt","svg":"","image":""},"fill":"#0000009e","fillhover":"","iconSize":["15px",null,null,null],"rotateY":false,"rotateX":false,"type":"font","strokeColor":"","strokeColorHover":"","strokeWidth":""},"content":"14 Days Moneyback Guarantee"}],"spacing":{"margin":{"values":{"top":["0.8"],"left":["-0.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#71717a","size":[0.9],"sizeUnit":"rem","lineHeightUnit":["rem"],"line_height":[1.3]},"icon_spacing":{"margin":{"values":{"right":[5]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"responsive":{"customcss":"{GREENSHIFT}\n.gspb_iconsList__item__text {\n    margin: 0px;\n}\n"}} -->
        <div id="gspb_iconsList-id-gsbp-b0aad058-4ded" class="gspb_iconsList gspb_iconsList-id-gsbp-b0aad058-4ded wp-block-greenshift-blocks-iconlist"><div class="gspb_iconsList__item" data-id="0"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 896 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M448 824c-31 0-56-25-56-56v-128c0-31 25-56 56-56s56 25 56 56v128c0 31-25 56-56 56zM896 480v448c0 53-43 96-96 96h-704c-53 0-96-43-96-96v-448c0-53 43-96 96-96h64v-96c0-159 129.6-288.4 288.8-288s287.2 131.6 287.2 290.8v93.2h64c53 0 96 43 96 96zM256 384h384v-96c0-105.8-86.2-192-192-192s-192 86.2-192 192v96zM800 480h-704v448h704v-448z"></path></svg><span class="gspb_iconsList__item__text">14 Days Moneyback Guarantee</span></div></div>
        <!-- /wp:greenshift-blocks/iconlist --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/videofeatures',
        array(
            'title'       => __('Video with CTA', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container', 'greenshift-blocks/video'),
            'keywords' => array('cta', 'features', 'video'),
            'description' => _x('Hero block with video CTA', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-10983bef-3814","align":"full","width":[80,null,null,null],"widthUnit":["rem","px","px","px"],"displayStyles":false,"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["4"],"bottom":["4"]},"unit":["rem","px","px","px"],"locked":false}}} -->
            <div id="gspb_row-id-gsbp-10983bef-3814" class="gspb_row gspb_row-id-gsbp-10983bef-3814 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-10983bef-3814"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-a74daba9-492d","flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"left":["2"],"top":[0],"right":["2"],"bottom":[0]},"unit":["rem","px","px","px"],"locked":false}}} -->
            <div id="gspb_col-id-gsbp-a74daba9-492d" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-a74daba9-492d"><!-- wp:greenshift-blocks/text {"id":"gsbp-1b489258-5b78","textContent":"Smart email campaign builder, made for Developers","typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1.09],"line_height":[1.75],"color":"#52525b","customweight":null,"customweightnumber":100}} -->
            <div id="gspb_text-id-gsbp-1b489258-5b78" class="gspb_text gspb_text-id-gsbp-1b489258-5b78 ">Smart email campaign builder, made for Developers</div>
            <!-- /wp:greenshift-blocks/text -->
            
            <!-- wp:greenshift-blocks/heading {"id":"gsbp-eac8ff69-2a72","headingContent":"Turn your visitors into profitable business","spacing":{"margin":{"values":{"top":[1.3],"bottom":[0],"left":[0],"right":[0]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":true}},"typography":{"textShadow":{},"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[3.75,3,null,2.1],"line_height":[4,null,null,2.9],"customweight":"custom","customweightnumber":700,"alignment":["center"],"color":"#18181b"},"responsive":{"customcss":"{GREENSHIFT}{\n  margin-left: auto;\n  margin-right: auto;\n}"},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom","maxWidth":["42rem"]}} -->
            <h2 id="gspb_heading-id-gsbp-eac8ff69-2a72" class="gspb_heading gspb_heading-id-gsbp-eac8ff69-2a72 ">Turn your visitors into profitable business</h2>
            <!-- /wp:greenshift-blocks/heading -->
            
            <!-- wp:greenshift-blocks/container {"id":"gsbp-3a6d005c-4663","flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row",null,null,"column"],"justifyContent":["center"],"columngapUnit":["em"],"columngap":[1.5],"rowgapUnit":[null,null,null,"rem"],"rowgap":[null,null,null,1],"type":"flexbox"},"spacing":{"margin":{"values":{"top":["2.2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"right":[null,null,null,"2"],"left":[null,null,null,"2"]},"unit":["px","px","px","rem"],"locked":false}}} -->
            <div id="gspb_container-id-gsbp-3a6d005c-4663" class="gspb_container gspb_container-gsbp-3a6d005c-4663 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/button {"id":"gsbp-8a05e69d-24cf","buttonContent":"Get more customers","align":"center","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"right":["2",null,null,"3"],"left":["2",null,null,"3"],"top":[".8"],"bottom":[".8"]},"unit":["rem","px","px","rem"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":[".7"],"topRight":[".7"],"bottomRight":[".7"],"bottomLeft":[".7"]},"unit":"rem","locked":true},"style":{"all":["solid"]},"size":{"all":[2]},"color":{"all":["#19191c00"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"blockWidth":{"customWidth":{"value":[null,null,null,"100%"],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom"},"typography":{"textShadow":{},"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1.15],"customweight":"custom","customweightnumber":700,"line_height":[1.75],"alignment":["center",null,null,"center"]}} -->
            <div id="gspb_button-id-gsbp-8a05e69d-24cf" class="gspb_button_wrapper gspb_button-id-gsbp-8a05e69d-24cf wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Get more customers</span></span></span></a></div>
            <!-- /wp:greenshift-blocks/button -->
            
            <!-- wp:greenshift-blocks/button {"id":"gsbp-0fd3e1ee-9980","buttonContent":"Watch free demo","align":"flex-start","background":{"color":"#ffffff","hoverColor":"#18181b"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["0.8"],"right":["2"],"bottom":["0.8"],"left":["2"]},"unit":["rem","px","px","px"],"locked":false},"marginAuto":[true]},"iconSpacing":{"margin":{"values":{"top":[null],"bottom":["-0.5"],"right":["0.7"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":["0.7"],"topRight":["0.7"],"bottomRight":["0.7"],"bottomLeft":["0.7"]},"unit":"rem","locked":true},"style":{"all":["solid"]},"size":{"all":[2]},"color":{"all":["#a1a1aa"]},"styleHover":{},"sizeHover":{},"colorHover":{"all":["#18181b"]}},"blockWidth":{"customWidth":{"value":[null,null,null,"100%"],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom"},"typography":{"textShadow":{},"alignment":["center"],"color":"#18181b","colorHover":"#ffffff","sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1.15],"line_height":[1.75],"customweight":"custom","customweightnumber":700},"responsive":{"customcss":"{GREENSHIFT} .gspb-buttonbox-icon svg { \n         margin: 0px !important;\n}"},"enableIcon":true,"iconBox_icon":{"icon":{"font":"rhicon rhi-paper-plane","svg":"\u003csvg class=\u0022x s j\u0022 viewBox=\u00220 0 18 18\u0022 fill=\u0022none\u0022 stroke=\u0022currentColor\u0022 xmlns=\u0022http://www.w3.org/2000/svg\u0022\u003e\n                            \u003cpath d=\u0022M8.18003 13.4261C6.8586 14.3918 5 13.448 5 11.8113V5.43865C5 3.80198 6.8586 2.85821 8.18003 3.82387L12.5403 7.01022C13.6336 7.80916 13.6336 9.44084 12.5403 10.2398L8.18003 13.4261Z\u0022 stroke-width=\u00222\u0022 stroke-miterlimit=\u002210\u0022 stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022\u003e\u003c/path\u003e\n                        \u003c/svg\u003e","image":""},"fill":"#ffffff","fillhover":"#18181b","type":"svg","iconSize":["1.25rem"]}} -->
            <div id="gspb_button-id-gsbp-0fd3e1ee-9980" class="gspb_button_wrapper gspb_button-id-gsbp-0fd3e1ee-9980 wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-icon"><svg class="x s j" viewBox="0 0 18 18" style="width:5rem;height:5rem;margin:10px" fill="none" stroke="currentColor" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8.18003 13.4261C6.8586 14.3918 5 13.448 5 11.8113V5.43865C5 3.80198 6.8586 2.85821 8.18003 3.82387L12.5403 7.01022C13.6336 7.80916 13.6336 9.44084 12.5403 10.2398L8.18003 13.4261Z" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>                        </svg></span><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Watch free demo</span></span></span></a></div>
            <!-- /wp:greenshift-blocks/button --></div>
            <!-- /wp:greenshift-blocks/container -->
            
            <!-- wp:greenshift-blocks/text {"id":"gsbp-4feeb768-ab07","textContent":"60 Days free trial · No credit card required","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["2"]},"unit":["rem","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1],"line_height":[1.5],"color":"#71717a","customweight":null,"customweightnumber":100}} -->
            <div id="gspb_text-id-gsbp-4feeb768-ab07" class="gspb_text gspb_text-id-gsbp-4feeb768-ab07 ">60 Days free trial · No credit card required</div>
            <!-- /wp:greenshift-blocks/text -->
            
            <!-- wp:greenshift-blocks/container {"id":"gsbp-c7639f25-c1d0","border":{"borderRadius":{"values":{"topLeft":["12"],"topRight":["12"],"bottomRight":["12"],"bottomLeft":["12"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[50,50]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"marginAuto":[true]},"shadow":{"hoffset":0,"voffset":"4","blur":"25","spread":"10","color":"#a6acb059","position":null},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":["570px","370px",null,"270px"],"unit":["px","px","px","px"]},"heightType":""}} -->
            <div id="gspb_container-id-gsbp-c7639f25-c1d0" class="gspb_container gspb_container-gsbp-c7639f25-c1d0 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-6ae2e14c-ed56","flexbox":{"type":"flexbox","justifyContent":["flex-start"],"flexDirection":["row"],"rowgapUnit":["px"],"columngapUnit":["rem"],"columngap":[0.5],"marginTop":[null,null,null,null],"marginLeft":[null,null,null,null],"marginBottom":[null,null,null,null],"marginRight":[null,null,null,null],"marginUnit":["px","px","px","px"],"marginLock":false,"enable":false},"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"bottom":["solid"]},"size":{"bottom":[1]},"color":{"all":["#d9d9d9"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["0.8"],"right":["0.8"],"bottom":["0.8"],"left":["1.1"]},"unit":["rem","px","px","px"],"locked":false}},"responsive":{"customcss":""},"blockWidth":{"customWidth":{"value":[null,"100%"],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"","maxWidth":[null,"100%"]}} -->
            <div id="gspb_container-id-gsbp-6ae2e14c-ed56" class="gspb_container gspb_container-gsbp-6ae2e14c-ed56 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-474e2b43-0a34","iconBox_icon":{"icon":{"font":"rhicon rhi-circle-solid","svg":"","image":""},"fill":"#ff4444","fillhover":"","type":"font","iconSize":["0.7rem"]}} -->
            <div id="gspb_iconBox-id-gsbp-474e2b43-0a34" class="gspb_iconBox gspb_iconBox-id-gsbp-474e2b43-0a34 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-274 0-496 222-496 496s222 496 496 496 496-222 496-496-222-496-496-496z"></path></svg></div></div>
            <!-- /wp:greenshift-blocks/iconbox -->
            
            <!-- wp:greenshift-blocks/iconbox {"id":"gsbp-6f87497b-36b6","iconBox_icon":{"icon":{"font":"rhicon rhi-circle-solid","svg":"","image":""},"fill":"#fdb241","fillhover":"","type":"font","iconSize":["0.7rem"]}} -->
            <div id="gspb_iconBox-id-gsbp-6f87497b-36b6" class="gspb_iconBox gspb_iconBox-id-gsbp-6f87497b-36b6 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-274 0-496 222-496 496s222 496 496 496 496-222 496-496-222-496-496-496z"></path></svg></div></div>
            <!-- /wp:greenshift-blocks/iconbox -->
            
            <!-- wp:greenshift-blocks/iconbox {"id":"gsbp-0f330a4c-396d","iconBox_icon":{"icon":{"font":"rhicon rhi-circle-solid","svg":"","image":""},"fill":"#65d81f","fillhover":"","type":"font","iconSize":["0.7rem"]}} -->
            <div id="gspb_iconBox-id-gsbp-0f330a4c-396d" class="gspb_iconBox gspb_iconBox-id-gsbp-0f330a4c-396d wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-274 0-496 222-496 496s222 496 496 496 496-222 496-496-222-496-496-496z"></path></svg></div></div>
            <!-- /wp:greenshift-blocks/iconbox --></div>
            <!-- /wp:greenshift-blocks/container -->
            
            <!-- wp:greenshift-blocks/video {"id":"gsbp-740c37bf-1183","src":"https://www.youtube.com/watch?v=GxKUPFOI1fI","provider":"youtube","controls":false,"poster":"https://i.ytimg.com/vi/GxKUPFOI1fI/maxresdefault.jpg","isOverlay":true,"overlayIcon":true,"overlayLightbox":true,"postDate":"2022-12-24T18:20:37","playiconBg":"#00d827","bgColor":"#6f3ba1"} -->
            <div class="wp-block-greenshift-blocks-video gs-video youtube gspb_video-id-gsbp-740c37bf-1183" id="gs-video-gsbp-740c37bf-1183"><div class="gs-video-wrapper" itemscope><iframe class="gs-video-element" data-src="https://www.youtube.com/watch?v=GxKUPFOI1fI" data-provider="youtube" data-autoplay="true" data-playsinline="false" data-controls="false" data-loop="false" data-mute="false" data-overlay="true" data-lightbox="true" data-modestbranding="false" data-suggested="true" frameborder="0" allowfullscreen></iframe><div class="gs-video-overlay" style="background-image:url(https://i.ytimg.com/vi/GxKUPFOI1fI/maxresdefault.jpg)" data-type="youtube" data-lightbox="true"><div class="gs-play-icon" style="background-color:#00d827"><div style="content:&quot;&quot;;display:block;position:absolute;border-radius:50%;border:1px solid #00d827;left:-20px;right:-20px;bottom:-20px;top:-20px;animation:pulsevideobutton 1.5s linear infinite;opacity:0"></div><span></span><div style="content:&quot;&quot;;display:block;position:absolute;border-radius:50%;border:1px solid #00d827;left:-20px;right:-20px;bottom:-20px;top:-20px;animation:pulsevideobutton 1.5s linear infinite;opacity:0;animation-delay:0.5s"></div></div><div class="gs-overlay-color" style="background-color:#6f3ba1;background-image:;opacity:0.5"></div></div></div></div>
            <!-- /wp:greenshift-blocks/video --></div>
            <!-- /wp:greenshift-blocks/container --></div>
            <!-- /wp:greenshift-blocks/row-column --> </div></div>
            <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/infosteps',
        array(
            'title'       => __('Info with steps', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('steps', 'features'),
            'description' => _x('Info with steps', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-bce7693f-a06d","inlineCssStyles":null,"align":"full","width":[1290,null,null,null],"displayStyles":false,"background":{"color":"#0f172a"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["5","4"],"bottom":["5","4"],"right":[0,0,null,0],"left":[0,0,null,0]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-bce7693f-a06d" class="gspb_row gspb_row-id-gsbp-bce7693f-a06d wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-bce7693f-a06d"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-79115a73-e0c5","inlineCssStyles":null,"variableWidth":false,"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":["2"],"bottom":[0],"left":["2"]},"unit":["rem","rem","rem","rem"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-79115a73-e0c5" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-79115a73-e0c5"><!-- wp:greenshift-blocks/container {"id":"gsbp-194bed0a-b2f0","inlineCssStyles":null,"width":[320,null,null,null],"widthUnit":["px","%","%","%"]} -->
        <div id="gspb_container-id-gsbp-194bed0a-b2f0" class="gspb_container gspb_container-gsbp-194bed0a-b2f0 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-c4dddd5c-be6f","inlineCssStyles":null,"headingContent":"Let us see how it works","typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[3,2.3,null,1.9],"lineHeightUnit":["em","em",null,"em"],"line_height":[1,1.1,null,1],"letter_spacing":[-1.2],"fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709,"fontWeight":"600"}}} -->
        <h2 id="gspb_heading-id-gsbp-c4dddd5c-be6f" class="gspb_heading gspb_heading-id-gsbp-c4dddd5c-be6f ">Let us see how it works</h2>
        <!-- /wp:greenshift-blocks/heading --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/row {"id":"gsbp-97041926-ac3d","inlineCssStyles":null,"gutterClassName":"gspb_row\u002d\u002dgutter-custom-0","rowLayout":"4","brp_rowLayout":["37",null,null],"width":[null,null,null,null],"widthUnit":["px","px","px","px"],"displayStyles":false,"spacing":{"margin":{"values":{"top":["5","4",null,"3"]},"unit":["rem","rem","px","rem"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"columnGapNew":25,"columnGap":[null,null,null,null],"rowGap":[null,20,null,null]} -->
        <div id="gspb_row-id-gsbp-97041926-ac3d" class="gspb_row gspb_row-id-gsbp-97041926-ac3d wp-block-greenshift-blocks-row gspb_row-id-gsbp-97041926-ac3d gspb_row--gutter-custom-0"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-ed6d5c3b-9bd1","inlineCssStyles":null,"width":[null,null,null,null],"gutterclass":"gspb_row\u002d\u002dgutter-25","flexbox":{"type":"flexbox","enable":false,"flexDirection":[null,"row"]},"columnSize":"3","brp_columnSize":["12",null,null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0,0],"right":[0,0],"bottom":[0,0],"left":[0,0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_col-id-gsbp-ed6d5c3b-9bd1" class="gspb_row__col--3 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-ed6d5c3b-9bd1"><!-- wp:greenshift-blocks/container {"id":"gsbp-aef4017d-cef4","inlineCssStyles":null,"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row","column"],"alignItems":["center","center"]}} -->
        <div id="gspb_container-id-gsbp-aef4017d-cef4" class="gspb_container gspb_container-gsbp-aef4017d-cef4 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-0cc7dfbd-d4ee","inlineCssStyles":null,"type":"regular","spacing":{"margin":{"values":{"left":[null],"top":[null],"right":[null],"bottom":[null]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false}},"iconBox_icon":{"icon":{"font":"rhicon rhi-circle-solid","svg":"","image":""},"fill":"#334155","fillhover":"","type":"font","iconSize":[12]}} -->
        <div id="gspb_iconBox-id-gsbp-0cc7dfbd-d4ee" class="gspb_iconBox gspb_iconBox-id-gsbp-0cc7dfbd-d4ee wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-274 0-496 222-496 496s222 496 496 496 496-222 496-496-222-496-496-496z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-a197a2ef-da0a","inlineCssStyles":null,"width":[94,1,null,null],"widthUnit":["%","px","%","%"],"minHeight":[1,96,null,null],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"background":{"color":"#334155"},"spacing":{"margin":{"values":{"top":[0,"15"],"right":[0],"bottom":[0],"left":["14",0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_container-id-gsbp-a197a2ef-da0a" class="gspb_container gspb_container-gsbp-a197a2ef-da0a wp-block-greenshift-blocks-container"><!-- wp:spacer {"height":"10px"} -->
        <div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
        <!-- /wp:spacer --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-1fcea224-3447","inlineCssStyles":null,"width":[90,425,null,90],"widthUnit":["%","px","%","%"],"spacing":{"margin":{"values":{"top":["2",0],"left":[null,"1.5"]},"unit":["rem","rem","px","px"],"locked":false},"padding":{"values":{"top":[null,0]},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-1fcea224-3447" class="gspb_container gspb_container-gsbp-1fcea224-3447 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-1fd8f932-981a","inlineCssStyles":null,"headingContent":"Planning","spacing":{"margin":{"values":{"top":[0,"-10"],"right":[0,0],"bottom":[0,0],"left":[0,0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":true}},"typography":{"textShadow":{},"color":"#cbd5e1","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709,"fontWeight":"600"},"sizeUnit":"rem","size":[1.5],"lineHeightUnit":["em"],"line_height":[2]}} -->
        <h2 id="gspb_heading-id-gsbp-1fd8f932-981a" class="gspb_heading gspb_heading-id-gsbp-1fd8f932-981a ">Planning</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-fb4dbcf6-25fa","inlineCssStyles":null,"textContent":"Lorem Ipsum is simply dummy text of the printing and type setting industry.","spacing":{"margin":{"values":{"top":["0.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#94a3b8","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709},"sizeUnit":"rem","size":[1],"lineHeightUnit":["em"],"line_height":[1.5]}} -->
        <div id="gspb_text-id-gsbp-fb4dbcf6-25fa" class="gspb_text gspb_text-id-gsbp-fb4dbcf6-25fa ">Lorem Ipsum is simply dummy text of the printing and type setting industry.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-1f8b42d7-afb8","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-25","flexbox":{"type":"flexbox","flexDirection":[null,"row"]},"columnSize":"3","brp_columnSize":["12",null,null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_col-id-gsbp-1f8b42d7-afb8" class="gspb_row__col--3 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-1f8b42d7-afb8"><!-- wp:greenshift-blocks/container {"id":"gsbp-67b515a3-b61b","inlineCssStyles":null,"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row","column"],"alignItems":["center"]}} -->
        <div id="gspb_container-id-gsbp-67b515a3-b61b" class="gspb_container gspb_container-gsbp-67b515a3-b61b wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-d4c90126-3c6f","inlineCssStyles":null,"type":"regular","spacing":{"margin":{"values":{"left":[null],"top":[null],"right":[null],"bottom":[null]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false}},"iconBox_icon":{"icon":{"font":"rhicon rhi-circle-solid","svg":"","image":""},"fill":"#7217ff","fillhover":"","type":"font","iconSize":[12]}} -->
        <div id="gspb_iconBox-id-gsbp-d4c90126-3c6f" class="gspb_iconBox gspb_iconBox-id-gsbp-d4c90126-3c6f wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-274 0-496 222-496 496s222 496 496 496 496-222 496-496-222-496-496-496z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-521b32f2-670d","inlineCssStyles":null,"width":[94,1,null,null],"widthUnit":["%","px","%","%"],"minHeight":[1,96,null,null],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"background":{"color":"#334155"},"spacing":{"margin":{"values":{"top":[0,"15"],"right":[0],"bottom":[0],"left":["14",0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_container-id-gsbp-521b32f2-670d" class="gspb_container gspb_container-gsbp-521b32f2-670d wp-block-greenshift-blocks-container"><!-- wp:spacer {"height":"10px"} -->
        <div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
        <!-- /wp:spacer --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-858e25aa-e973","inlineCssStyles":null,"width":[90,425,null,90],"widthUnit":["%","px","%","%"],"spacing":{"margin":{"values":{"top":["2",0],"left":[null,"1.5"]},"unit":["rem","rem","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-858e25aa-e973" class="gspb_container gspb_container-gsbp-858e25aa-e973 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-33f1505d-631f","inlineCssStyles":null,"headingContent":"Build-up","spacing":{"margin":{"values":{"top":[0,"-10"],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#cbd5e1","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709,"fontWeight":"600"},"sizeUnit":"rem","size":[1.5],"lineHeightUnit":["em"],"line_height":[2]}} -->
        <h2 id="gspb_heading-id-gsbp-33f1505d-631f" class="gspb_heading gspb_heading-id-gsbp-33f1505d-631f ">Build-up</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-f0c4d8ee-982a","inlineCssStyles":null,"textContent":"Lorem Ipsum is simply dummy text of the printing and type setting industry.","spacing":{"margin":{"values":{"top":["0.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#94a3b8","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709},"sizeUnit":"rem","size":[1],"lineHeightUnit":["em"],"line_height":[1.5]}} -->
        <div id="gspb_text-id-gsbp-f0c4d8ee-982a" class="gspb_text gspb_text-id-gsbp-f0c4d8ee-982a ">Lorem Ipsum is simply dummy text of the printing and type setting industry.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-1c6acc13-c3d0","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-25","flexbox":{"type":"flexbox","flexDirection":[null,"row"]},"columnSize":"3","brp_columnSize":["12",null,null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_col-id-gsbp-1c6acc13-c3d0" class="gspb_row__col--3 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-1c6acc13-c3d0"><!-- wp:greenshift-blocks/container {"id":"gsbp-dfc7402e-2419","inlineCssStyles":null,"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row","column"],"alignItems":["center","center"]}} -->
        <div id="gspb_container-id-gsbp-dfc7402e-2419" class="gspb_container gspb_container-gsbp-dfc7402e-2419 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-2d0f7045-67a9","inlineCssStyles":null,"type":"regular","spacing":{"margin":{"values":{"left":[null],"top":[null],"right":[null],"bottom":[null]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false}},"iconBox_icon":{"icon":{"font":"rhicon rhi-circle-solid","svg":"","image":""},"fill":"#334155","fillhover":"","type":"font","iconSize":[12]}} -->
        <div id="gspb_iconBox-id-gsbp-2d0f7045-67a9" class="gspb_iconBox gspb_iconBox-id-gsbp-2d0f7045-67a9 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-274 0-496 222-496 496s222 496 496 496 496-222 496-496-222-496-496-496z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-95ad92bc-c3aa","inlineCssStyles":null,"width":[94,1,null,null],"widthUnit":["%","px","%","%"],"minHeight":[1,96,null,null],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"background":{"color":"#334155"},"spacing":{"margin":{"values":{"top":[0,"15"],"right":[0],"bottom":[0],"left":["14",0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_container-id-gsbp-95ad92bc-c3aa" class="gspb_container gspb_container-gsbp-95ad92bc-c3aa wp-block-greenshift-blocks-container"><!-- wp:spacer {"height":"10px"} -->
        <div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
        <!-- /wp:spacer --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-a7936ea3-3286","inlineCssStyles":null,"width":[90,425,null,90],"widthUnit":["%","px","%","%"],"spacing":{"margin":{"values":{"top":["2",0],"left":[null,"1.5"]},"unit":["rem","rem","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-a7936ea3-3286" class="gspb_container gspb_container-gsbp-a7936ea3-3286 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-cf2c80a8-027a","inlineCssStyles":null,"headingContent":"Implementation","spacing":{"margin":{"values":{"top":[0,"-10"],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#cbd5e1","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709,"fontWeight":"600"},"sizeUnit":"rem","size":[1.5],"lineHeightUnit":["em"],"line_height":[2]}} -->
        <h2 id="gspb_heading-id-gsbp-cf2c80a8-027a" class="gspb_heading gspb_heading-id-gsbp-cf2c80a8-027a ">Implementation</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-30e3261a-2b6b","inlineCssStyles":null,"textContent":"Lorem Ipsum is simply dummy text of the printing and type setting industry.","spacing":{"margin":{"values":{"top":["0.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#94a3b8","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709},"sizeUnit":"rem","size":[1],"lineHeightUnit":["em"],"line_height":[1.5]}} -->
        <div id="gspb_text-id-gsbp-30e3261a-2b6b" class="gspb_text gspb_text-id-gsbp-30e3261a-2b6b ">Lorem Ipsum is simply dummy text of the printing and type setting industry.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-5acffb28-8208","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-25","flexbox":{"type":"flexbox","flexDirection":[null,"row"]},"columnSize":"3","brp_columnSize":["12",null,null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_col-id-gsbp-5acffb28-8208" class="gspb_row__col--3 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-5acffb28-8208"><!-- wp:greenshift-blocks/container {"id":"gsbp-ac5c6263-ecfc","inlineCssStyles":null,"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row","column"],"alignItems":["center","center"]}} -->
        <div id="gspb_container-id-gsbp-ac5c6263-ecfc" class="gspb_container gspb_container-gsbp-ac5c6263-ecfc wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-1f6f1b59-a960","inlineCssStyles":null,"type":"regular","spacing":{"margin":{"values":{"left":[null],"top":[null],"right":[null],"bottom":[null]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false}},"iconBox_icon":{"icon":{"font":"rhicon rhi-circle-solid","svg":"","image":""},"fill":"#334155","fillhover":"","type":"font","iconSize":[12]}} -->
        <div id="gspb_iconBox-id-gsbp-1f6f1b59-a960" class="gspb_iconBox gspb_iconBox-id-gsbp-1f6f1b59-a960 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 16c-274 0-496 222-496 496s222 496 496 496 496-222 496-496-222-496-496-496z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-a536f3b9-611e","inlineCssStyles":null,"width":[94,1,null,null],"widthUnit":["%","px","%","%"],"minHeight":[1,96,null,null],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"background":{"color":"#334155"},"spacing":{"margin":{"values":{"top":[0,"15"],"right":[0],"bottom":[0],"left":["14",0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_container-id-gsbp-a536f3b9-611e" class="gspb_container gspb_container-gsbp-a536f3b9-611e wp-block-greenshift-blocks-container"><!-- wp:spacer {"height":"10px"} -->
        <div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
        <!-- /wp:spacer --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-7b29746f-c462","inlineCssStyles":null,"width":[90,425,null,90],"widthUnit":["%","px","%","%"],"spacing":{"margin":{"values":{"top":["2",0],"left":[null,"1.5"]},"unit":["rem","rem","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-7b29746f-c462" class="gspb_container gspb_container-gsbp-7b29746f-c462 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-cf48532c-a098","inlineCssStyles":null,"headingContent":"Closeout","spacing":{"margin":{"values":{"top":[0,"-10"],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#cbd5e1","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709,"fontWeight":"600"},"sizeUnit":"rem","size":[1.5],"lineHeightUnit":["em"],"line_height":[2]}} -->
        <h2 id="gspb_heading-id-gsbp-cf48532c-a098" class="gspb_heading gspb_heading-id-gsbp-cf48532c-a098 ">Closeout</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-b25f8fac-5c59","inlineCssStyles":null,"textContent":"Lorem Ipsum is simply dummy text of the printing and type setting industry.","spacing":{"margin":{"values":{"top":["0.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#94a3b8","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709},"sizeUnit":"rem","size":[1],"lineHeightUnit":["em"],"line_height":[1.5]}} -->
        <div id="gspb_text-id-gsbp-b25f8fac-5c59" class="gspb_text gspb_text-id-gsbp-b25f8fac-5c59 ">Lorem Ipsum is simply dummy text of the printing and type setting industry.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/infowithicons',
        array(
            'title'       => __('Info block with icon steps', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('steps', 'features'),
            'description' => _x('Info block with icon steps', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-b358605f-c280","inlineCssStyles":null,"align":"full","gutterClassName":"gspb_row\u002d\u002dgutter-custom-0","rowLayout":"2","brp_rowLayout":["30",null,null],"width":[1020,510,null,null],"widthUnit":["px","px","px","px"],"displayStyles":false,"background":{"color":"#f8fafc"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["5","3.5",null,"3.4"],"bottom":["5","3.5",null,"2"],"right":["2","1.5",null,"3"],"left":["2","1.4",null,"2"]},"unit":["rem","rem","px","rem"],"locked":false}},"columnGapNew":150,"customWrap":[null,"",null,null]} -->
        <div id="gspb_row-id-gsbp-b358605f-c280" class="gspb_row gspb_row-id-gsbp-b358605f-c280 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-b358605f-c280 gspb_row--gutter-custom-0"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-ed5b5cc3-7516","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-150","columnSize":"6","brp_columnSize":["12",null,null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"right":[0],"left":[0]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-ed5b5cc3-7516" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-ed5b5cc3-7516"><!-- wp:greenshift-blocks/text {"id":"gsbp-d57f8dbf-ebbd","inlineCssStyles":null,"textContent":"Say hello to Greenshift","textTag":"p","typography":{"textShadow":{},"color":"#2185ff","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709,"fontWeight":"600"},"sizeUnit":"rem","size":[1],"line_height":[1.5],"lineHeightUnit":["em"]}} -->
        <p id="gspb_text-id-gsbp-d57f8dbf-ebbd" class="gspb_text gspb_text-id-gsbp-d57f8dbf-ebbd ">Say hello to Greenshift</p>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-beef79bb-8c5a","inlineCssStyles":null,"headingContent":"Get your project going in 3 steps","spacing":{"margin":{"values":{"top":[null,null,null,"1.5"],"right":[null,null,null,null],"bottom":[null,null,null,null],"left":[null,null,null,null]},"unit":["px","px","px","rem"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[3,2.3,null,1.9],"fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709,"fontWeight":"600"},"customweight":null,"customweightnumber":900,"line_height":[3.7,2.5,null,2.2],"lineHeightUnit":["rem","rem",null,"rem"],"letter_spacing":[-1.2],"textBorder":null,"textBorderHover":null}} -->
        <h2 id="gspb_heading-id-gsbp-beef79bb-8c5a" class="gspb_heading gspb_heading-id-gsbp-beef79bb-8c5a ">Get your project going in 3 steps</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-d8a18471-ce57","inlineCssStyles":null,"textContent":"Clarity gives you the blocks \u0026amp; components you need to create a truly professional website for your SaaS and gives the blocks.","spacing":{"margin":{"values":{"top":[null,"-0.2"],"bottom":[null,0],"right":[null,null,null,0]},"unit":["px","em","px","em"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"line_height":[2,1.7],"lineHeightUnit":["em","em"],"sizeUnit":"px","size":[18,16],"fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709},"color":"#475569"}} -->
        <div id="gspb_text-id-gsbp-d8a18471-ce57" class="gspb_text gspb_text-id-gsbp-d8a18471-ce57 ">Clarity gives you the blocks &amp; components you need to create a truly professional website for your SaaS and gives the blocks.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-2fb873b7-bae0","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-150","flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"columnSize":"6","brp_columnSize":["12",null,null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"right":[0],"left":[0]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-2fb873b7-bae0" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-2fb873b7-bae0"><!-- wp:greenshift-blocks/container {"id":"gsbp-2387fa77-e602","inlineCssStyles":null,"flexbox":{"type":"flexbox","flexDirection":["row",null,null,"column"],"enable":false},"spacing":{"margin":{"values":{"right":[null,null],"left":[null,null],"top":[null,"1.5"],"bottom":[null,null]},"unit":["px","rem","px","px"],"locked":false},"padding":{"values":{"right":[null],"left":[null],"bottom":[null],"top":[null]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_container-id-gsbp-2387fa77-e602" class="gspb_container gspb_container-gsbp-2387fa77-e602 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-f6b3157b-4605","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"right":[null],"top":["-0.2"],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[1],"right":[1],"bottom":[1],"left":[1]},"unit":["em","px","px","px"],"locked":true}},"background":{"color":"#f1f5f9"},"shapePosition":"flex-start","shapeJustify":"","iconBox_icon":{"icon":{"font":"rhicon rhi-rocket-launch","svg":"","image":""},"fill":"#2185ff","fillhover":"","type":"font","iconSize":[27],"strokeColor":"","strokeColorHover":"","strokeWidth":""}} -->
        <div id="gspb_iconBox-id-gsbp-f6b3157b-4605" class="gspb_iconBox gspb_iconBox-id-gsbp-f6b3157b-4605 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M71.37 704.133c-51.715 51.707-77.269 181.055-70.219 318.688 138.23 7.117 267.222-18.703 318.73-70.211 80.578-80.559 85.754-187.973 12.621-261.098-73.129-73.117-180.562-67.941-261.132 12.621zM234.636 872.195c-17.172 17.168-60.168 25.773-106.238 23.398-2.348-45.871 6.168-88.984 23.406-106.219 26.855-26.852 62.66-28.578 87.035-4.207 24.375 24.375 22.652 60.176-4.203 87.027zM1010.326 38.594c-2.352-10.926-13.977-22.531-24.902-24.867-64.191-13.727-114.496-13.727-164.586-13.727-206.437 0-330.238 110.406-422.656 256h-208.406c-32.594 0-71.199 23.848-85.777 52.996l-98.844 197.598c-2.917 6.275-4.741 13.593-5.028 21.303l-0.003 0.103c0.009 26.509 21.499 47.995 48.007 48l207.907 0c0.004-0 0.009-0 0.014-0 106.041 0 192.005 85.96 192.013 191.999l0 0.001v208c0.009 26.509 21.499 47.995 48.007 48l0.001 0c7.814-0.298 15.13-2.121 21.76-5.178l-0.354 0.146 197.496-98.813c29.121-14.57 52.949-53.129 52.949-85.687v-208.875c145.176-92.625 256.039-216.813 256.039-422.188 0.187-50.301 0.187-100.602-13.637-164.812zM716.276 544.664c-50.664 32.324-15.012 13.48-198.633 104.418-29.484-63.448-79.351-113.287-141.040-141.991l-1.78-0.744c90.746-183.367 71.793-147.5 104.426-198.906 94.078-148.207 196.234-211.441 341.589-211.441 35.297 0 67.082 0 102.746 4.496 4.609 36.527 4.488 68.937 4.363 102.91-0 144.539-63.305 246.598-211.672 341.258zM736.112 208c-44.178 0.007-79.988 35.821-79.988 80 0 44.183 35.817 80 80 80s80-35.817 80-80v0c-0.022-44.178-35.833-79.984-80.010-80l-0.001-0z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-e4c3ea1c-57be","inlineCssStyles":null,"spacing":{"margin":{"values":{"left":["2",null,null,0],"top":[null,null,null,"1.8"],"right":[null,null,null,null],"bottom":[null,null,null,null]},"unit":["rem","px","px","rem"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-e4c3ea1c-57be" class="gspb_container gspb_container-gsbp-e4c3ea1c-57be wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-9173823d-72ab","inlineCssStyles":null,"headingTag":"h3","headingContent":"\u003cspan style=\u0022color: #64748b;\u0022 class=\u0022stk-highlight\u0022\u003eStep-1:\u003c/span\u003e Start with a great design","typography":{"textShadow":{},"color":"","size":[1.3],"lineHeightUnit":["em"],"line_height":[1],"sizeUnit":"rem","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709,"fontWeight":"600"}}} -->
        <h3 id="gspb_heading-id-gsbp-9173823d-72ab" class="gspb_heading gspb_heading-id-gsbp-9173823d-72ab "><span style="color: #64748b;" class="stk-highlight">Step-1:</span> Start with a great design</h3>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-e8ca2cd5-82d6","inlineCssStyles":null,"textContent":"Clarity gives you the blocks \u0026amp; components you need to create a website.","spacing":{"margin":{"values":{"top":[null,"1.3"]},"unit":["px","rem","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709},"sizeUnit":"rem","size":[1],"lineHeightUnit":["em"],"line_height":[1.5],"color":"#334155"}} -->
        <div id="gspb_text-id-gsbp-e8ca2cd5-82d6" class="gspb_text gspb_text-id-gsbp-e8ca2cd5-82d6 ">Clarity gives you the blocks &amp; components you need to create a website.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-fe8ef8bb-dde8","inlineCssStyles":null,"flexbox":{"type":"flexbox","flexDirection":["row",null,null,"column"],"enable":false},"spacing":{"margin":{"values":{"right":[null],"left":[null],"top":["3","3.2"],"bottom":[null]},"unit":["rem","rem","px","px"],"locked":false},"padding":{"values":{"right":[null],"left":[null],"bottom":[null],"top":[null]},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-fe8ef8bb-dde8" class="gspb_container gspb_container-gsbp-fe8ef8bb-dde8 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-b564a029-a3f2","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"right":[null],"top":["-0.2"],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[1],"right":[1],"bottom":[1],"left":[1]},"unit":["em","px","px","px"],"locked":true}},"background":{"color":"#f1f5f9"},"shapePosition":"flex-start","shapeJustify":"","iconBox_icon":{"icon":{"font":"rhicon rhi-gem","svg":"","image":""},"fill":"#2185ff","fillhover":"","type":"font","iconSize":[27],"strokeColor":"","strokeColorHover":"","strokeWidth":""}} -->
        <div id="gspb_iconBox-id-gsbp-b564a029-a3f2" class="gspb_iconBox gspb_iconBox-id-gsbp-b564a029-a3f2 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1152 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M927.4 0h-702.8c-8.4 0-16.2 4.4-20.6 11.6l-200.6 325.6c-5.4 8.8-4.4 20.2 2.4 28l552 650.4c9.6 11.2 26.8 11.2 36.4 0l552-650.4c6.8-7.8 7.6-19.2 2.4-28l-200.6-325.6c-4.4-7.2-12.2-11.6-20.6-11.6zM900.2 72l148.6 248h-166l-113.6-248h131zM690 72l113.6 248h-455.4l113.8-248h228zM251.8 72h131l-113.6 248h-166l148.6-248zM122.4 384h146l163.6 384-309.6-384zM346.4 384h459l-229.4 527.6-229.6-527.6zM720 768l163.6-384h146l-309.6 384z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-9f3019f2-20e3","inlineCssStyles":null,"spacing":{"margin":{"values":{"left":["2",null,null,0],"top":[null,null,null,"1.8"]},"unit":["rem","px","px","rem"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-9f3019f2-20e3" class="gspb_container gspb_container-gsbp-9f3019f2-20e3 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-a99393a2-dbfe","inlineCssStyles":null,"headingTag":"h3","headingContent":"\u003cspan style=\u0022color: #64748b;\u0022 class=\u0022stk-highlight\u0022\u003eStep-2:\u003c/span\u003e Add clever content areas","typography":{"textShadow":{},"color":"","size":[1.3],"lineHeightUnit":["em"],"line_height":[1],"sizeUnit":"rem","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709,"fontWeight":"600"}}} -->
        <h3 id="gspb_heading-id-gsbp-a99393a2-dbfe" class="gspb_heading gspb_heading-id-gsbp-a99393a2-dbfe "><span style="color: #64748b;" class="stk-highlight">Step-2:</span> Add clever content areas</h3>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-de0058a6-d6ba","inlineCssStyles":null,"textContent":"Clarity gives you the blocks \u0026amp; components you need to create a website.","spacing":{"margin":{"values":{"top":[null,"1.3"]},"unit":["px","rem","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709},"sizeUnit":"rem","size":[1],"lineHeightUnit":["em"],"line_height":[1.5],"color":"#334155"}} -->
        <div id="gspb_text-id-gsbp-de0058a6-d6ba" class="gspb_text gspb_text-id-gsbp-de0058a6-d6ba ">Clarity gives you the blocks &amp; components you need to create a website.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-94248aaf-3d8a","inlineCssStyles":null,"flexbox":{"type":"flexbox","flexDirection":["row",null,null,"column"],"enable":false},"spacing":{"margin":{"values":{"right":[null],"left":[null],"top":["3","3.2"],"bottom":[null]},"unit":["rem","rem","px","px"],"locked":false},"padding":{"values":{"right":[null],"left":[null],"bottom":[null],"top":[null]},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-94248aaf-3d8a" class="gspb_container gspb_container-gsbp-94248aaf-3d8a wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-9e57b088-94e0","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"right":[null],"top":["-0.2"],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[1],"right":[1],"bottom":[1],"left":[1]},"unit":["em","px","px","px"],"locked":true}},"background":{"color":"#f1f5f9"},"shapePosition":"flex-start","shapeJustify":"","iconBox_icon":{"icon":{"font":"rhicon rhi-layers","svg":"","image":""},"fill":"#2185ff","fillhover":"","type":"font","iconSize":[27],"strokeColor":"","strokeColorHover":"","strokeWidth":""}} -->
        <div id="gspb_iconBox-id-gsbp-9e57b088-94e0" class="gspb_iconBox gspb_iconBox-id-gsbp-9e57b088-94e0 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M512 614.4c-3.379 0-6.758-0.669-9.934-2.006l-486.4-204.8c-9.493-3.997-15.666-13.293-15.666-23.594s6.173-19.597 15.666-23.594l486.4-204.8c6.354-2.675 13.517-2.675 19.869 0l486.4 204.8c9.493 3.997 15.666 13.293 15.666 23.594s-6.173 19.597-15.666 23.594l-486.4 204.8c-3.176 1.338-6.555 2.006-9.934 2.006zM91.57 384l420.43 177.024 420.43-177.024-420.43-177.024-420.43 177.024z"></path><path style="fill:#565D66" d="M512 768c-3.379 0-6.758-0.669-9.934-2.006l-486.4-204.8c-13.030-5.486-19.146-20.498-13.659-33.528s20.498-19.146 33.528-13.659l476.466 200.618 476.466-200.618c13.029-5.483 28.042 0.63 33.528 13.659 5.488 13.032-0.63 28.042-13.659 33.528l-486.4 204.8c-3.176 1.338-6.555 2.006-9.934 2.006z"></path><path style="fill:#565D66" d="M512 921.6c-3.379 0-6.758-0.669-9.934-2.006l-486.4-204.8c-13.030-5.486-19.146-20.498-13.659-33.528s20.498-19.144 33.528-13.659l476.466 200.618 476.466-200.618c13.029-5.483 28.042 0.63 33.528 13.659 5.488 13.032-0.63 28.042-13.659 33.528l-486.4 204.8c-3.176 1.338-6.555 2.006-9.934 2.006z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-7afab42a-a5a5","inlineCssStyles":null,"spacing":{"margin":{"values":{"left":["2",null,null,0],"top":[null,null,null,"1.8"]},"unit":["rem","px","px","rem"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-7afab42a-a5a5" class="gspb_container gspb_container-gsbp-7afab42a-a5a5 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-118867ea-8621","inlineCssStyles":null,"headingTag":"h3","headingContent":"\u003cspan style=\u0022color: #64748b;\u0022 class=\u0022stk-highlight\u0022\u003eStep-3:\u003c/span\u003e Easily update your site","typography":{"textShadow":{},"color":"","size":[1.3],"lineHeightUnit":["em"],"line_height":[1],"sizeUnit":"rem","fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709,"fontWeight":"600"}}} -->
        <h3 id="gspb_heading-id-gsbp-118867ea-8621" class="gspb_heading gspb_heading-id-gsbp-118867ea-8621 "><span style="color: #64748b;" class="stk-highlight">Step-3:</span> Easily update your site</h3>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-c0bf5ffc-bdce","inlineCssStyles":null,"textContent":"Clarity gives you the blocks \u0026amp; components you need to create a website.","spacing":{"margin":{"values":{"top":[null,"1.3"]},"unit":["px","rem","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"fontFamily":{"value":"Poppins","label":"Poppins","fontIndex":709},"sizeUnit":"rem","size":[1],"lineHeightUnit":["em"],"line_height":[1.5],"color":"#334155"}} -->
        <div id="gspb_text-id-gsbp-c0bf5ffc-bdce" class="gspb_text gspb_text-id-gsbp-c0bf5ffc-bdce ">Clarity gives you the blocks &amp; components you need to create a website.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/productfeat',
        array(
            'title'       => __('Featured product with card', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('cta', 'features', 'product'),
            'description' => _x('Featured product with card', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-9d8f9039-7165","inlineCssStyles":null,"align":"full","gutterClassName":"gspb_row\u002d\u002dgutter-custom-0","rowLayout":"2","brp_rowLayout":["30",null,null],"width":[75,75,null,null],"widthUnit":["rem","rem","px","px"],"displayStyles":false,"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["5","5"],"bottom":["5","5"],"right":["2","2",null,"1.5"],"left":["2","2",null,"1.5"]},"unit":["rem","rem","px","rem"],"locked":false}},"gutterGap":[null,null,null,null],"columnGap":["5rem","0rem",null,null],"rowGap":["3rem",null,null,null],"customWrap":["nowrap","wrap",null,null]} -->
        <div id="gspb_row-id-gsbp-9d8f9039-7165" class="gspb_row gspb_row-id-gsbp-9d8f9039-7165 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-9d8f9039-7165 gspb_row--gutter-custom-0"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-bda71f74-5325","inlineCssStyles":null,"order":[null,1,null,null],"width":[40,100,null,null],"gutterclass":"gspb_row\u002d\u002dgutter-custom-0","gutterGap":[null,null,null,null],"flexbox":{"type":"flexbox","justifyContent":["center"],"alignItems":["center"]},"columnSize":"6","brp_columnSize":["12",null,null],"border":{"borderRadius":{"values":{"topLeft":["1.5"],"topRight":["1.5"],"bottomRight":["1.5"],"bottomLeft":["1.5"]},"unit":"rem","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["3"],"right":["5"],"bottom":["3"],"left":["5"]},"unit":["rem","px","px","px"],"locked":false}},"overlay":{"color":"#dbeafe"}} -->
        <div id="gspb_col-id-gsbp-bda71f74-5325" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-bda71f74-5325"><div class="gspb_backgroundOverlay"></div><!-- wp:greenshift-blocks/container {"id":"gsbp-068edf8b-7a8f","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[20,null,null,null],"widthUnit":["rem","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["rem","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{"color":"#ffffff"},"overlay":{},"border":{"borderRadius":{"values":{"topLeft":["0.7"],"topRight":["0.7"],"bottomRight":["0.7"],"bottomLeft":["0.7"]},"unit":"rem"},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-068edf8b-7a8f" class="gspb_container gspb_container-gsbp-068edf8b-7a8f wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-b729e7c3-0d6f","inlineCssStyles":null,"textContent":"Account Summary","textTag":"p","border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"bottom":["solid"]},"size":{"bottom":[1]},"color":{"bottom":["#f2f2f2"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["0.8"],"bottom":["0.8"]},"unit":["rem","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","size":[0.85],"customweight":"custom","customweightnumber":600,"letter_spacing":["0.015em"],"textBorder":null,"textBorderHover":null}} -->
        <p id="gspb_text-id-gsbp-b729e7c3-0d6f" class="gspb_text gspb_text-id-gsbp-b729e7c3-0d6f ">Account Summary</p>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/image {"id":"gsbp-5f115c62-3d8b","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"marginAuto":[true]},"align":["center",null,null,null],"width":["custom",null,null,null],"widthUnit":["rem","px","px","px"],"heightUnit":["rem","px","px","px"],"height":["custom",null,null,null],"customWidth":[5,null,null,null],"customHeight":[5,null,null,null],"border":{"borderRadius":{"values":{"topLeft":["99"],"topRight":["99"],"bottomRight":["99"],"bottomLeft":["99"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"mediaurl":"https://api.lorem.space/image/game?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-5f115c62-3d8b" class="gspb_image gspb_image-id-gsbp-5f115c62-3d8b wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/game?w=150&amp;h=150" data-src="" alt="" width="5" height="5"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-6081e06f-6d69","inlineCssStyles":null,"textContent":"$34,500","spacing":{"margin":{"values":{"top":["1.4"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1.65],"customweight":"custom","customweightnumber":700}} -->
        <div id="gspb_text-id-gsbp-6081e06f-6d69" class="gspb_text gspb_text-id-gsbp-6081e06f-6d69 ">$34,500</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-93a586c0-b84b","inlineCssStyles":null,"textContent":"Updated: 34 seconds ago","spacing":{"margin":{"values":{"top":["0.4"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","size":[0.77],"customweight":"custom","customweightnumber":500,"color":"#b2b2b2","letter_spacing":["0.005em"]}} -->
        <div id="gspb_text-id-gsbp-93a586c0-b84b" class="gspb_text gspb_text-id-gsbp-93a586c0-b84b ">Updated: 34 seconds ago</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-f17cd1bf-c9be","inlineCssStyles":null,"textContent":"SEND A PAYMENT","background":{"color":"#090914"},"border":{"borderRadius":{"values":{"bottomRight":[".7"],"bottomLeft":[".7"]},"unit":"rem"},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":["1.4"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":["0.8"],"bottom":["0.8"]},"unit":["rem","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","size":[0.7],"customweight":"custom","customweightnumber":700,"color":"#ffffff","letter_spacing":["0.05em"]}} -->
        <div id="gspb_text-id-gsbp-f17cd1bf-c9be" class="gspb_text gspb_text-id-gsbp-f17cd1bf-c9be ">SEND A PAYMENT</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-e9ee5a83-b060","inlineCssStyles":null,"order":[null,2,null,null],"width":[60,100,null,null],"gutterclass":"gspb_row\u002d\u002dgutter-custom-0","gutterGap":[null,null,null,null],"columnSize":"6","brp_columnSize":["12",null,null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["rem","px","px","px"],"locked":true}}} -->
        <div id="gspb_col-id-gsbp-e9ee5a83-b060" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-e9ee5a83-b060"><!-- wp:greenshift-blocks/container {"id":"gsbp-9b8df7fd-e25f","inlineCssStyles":null,"width":[null,null,null,null]} -->
        <div id="gspb_container-id-gsbp-9b8df7fd-e25f" class="gspb_container gspb_container-gsbp-9b8df7fd-e25f wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-b29e3362-0392","inlineCssStyles":null,"headingContent":"Clarity is here to make life a little bit easier.","spacing":{"margin":{"values":{"top":[0,null],"right":[0,null],"bottom":[0,null],"left":[0,null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[3.15,2.25,null,1.9],"customweight":"custom","customweightnumber":700,"lineHeightUnit":["rem"],"line_height":[3.5,2.5,null,2.25],"letter_spacing":["-0.01em","-0.015em"],"textBorder":null,"textBorderHover":null,"color":"#0f172a"}} -->
        <h2 id="gspb_heading-id-gsbp-b29e3362-0392" class="gspb_heading gspb_heading-id-gsbp-b29e3362-0392 ">Clarity is here to make life a little bit easier.</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-2026f889-0a6e","inlineCssStyles":null,"textContent":"Clarity gives you the blocks \u0026amp; components you need to create a truly professional website, landing page or admin panel for your SaaS.","spacing":{"margin":{"values":{"top":["1.5","1"],"right":[null,null],"bottom":[null,null],"left":[null,null]},"unit":["rem","rem","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":["3",0]},"unit":["rem","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1.2,1.1,null,1.1],"line_height":[2,null,null,1.9],"color":"#5a6779"}} -->
        <div id="gspb_text-id-gsbp-2026f889-0a6e" class="gspb_text gspb_text-id-gsbp-2026f889-0a6e ">Clarity gives you the blocks &amp; components you need to create a truly professional website, landing page or admin panel for your SaaS.</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-0fb06ec9-225f","inlineCssStyles":null,"buttonContent":"Start using Greenshift","background":{"color":"#2e63f5"},"spacing":{"margin":{"values":{"top":["2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":["0.9"],"bottom":["0.9"],"right":["1.7"],"left":["1.7"]},"unit":["rem","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":["99"],"topRight":["99"],"bottomRight":["99"],"bottomLeft":["99"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"typography":{"textShadow":{},"customweight":"custom","customweightnumber":600,"sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.5],"letter_spacing":["0.04em"]},"buttonLink":"https://greenshiftwp.com/","linkNewWindow":true,"linkNoFollow":true} -->
        <div id="gspb_button-id-gsbp-0fb06ec9-225f" class="gspb_button_wrapper gspb_button-id-gsbp-0fb06ec9-225f wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" href="https://greenshiftwp.com/" target="_blank" rel="noopener nofollow"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Start using Greenshift</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-fef7b569-9cf8","inlineCssStyles":null,"flexbox":{"type":"grid","enable":false,"gridcolumns":[2,null,null,1],"columngap":[2],"rowgap":[2],"columngapUnit":["rem"],"rowgapUnit":["rem"]},"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"top":["solid"]},"size":{"top":[1]},"color":{"top":["#e3e3e3"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":["6","4",null,"2"]},"unit":["rem","rem","px","rem"],"locked":false},"padding":{"values":{"top":["2"]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-fef7b569-9cf8" class="gspb_container gspb_container-gsbp-fef7b569-9cf8 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-0c50861b-125d","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-0c50861b-125d" class="gspb_container gspb_container-gsbp-0c50861b-125d wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-4060a1db-5a98","inlineCssStyles":null,"headingTag":"h3","headingContent":"Unlimited Resources","spacing":{"margin":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["rem","px","px","px"],"locked":true},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#0f172a","sizeUnit":"rem","size":[1.12],"line_height":[1.75],"lineHeightUnit":["rem"]}} -->
        <h3 id="gspb_heading-id-gsbp-4060a1db-5a98" class="gspb_heading gspb_heading-id-gsbp-4060a1db-5a98 ">Unlimited Resources</h3>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-ec142bc8-653a","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor.","spacing":{"margin":{"values":{"top":["1"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[0.9],"lineHeightUnit":["rem"],"line_height":[1.25],"customweight":null,"color":"#5a6779","letter_spacing":["0.02em"]}} -->
        <div id="gspb_text-id-gsbp-ec142bc8-653a" class="gspb_text gspb_text-id-gsbp-ec142bc8-653a ">Amet minim mollit non deserunt ullamco est sit aliqua dolor.</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-338dde9c-9b42","inlineCssStyles":null,"buttonContent":"Download Free Resources","background":{"color":"#00000000"},"spacing":{"margin":{"values":{"top":["1.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}},"typography":{"textShadow":{},"color":"#2563eb","lineHeightUnit":["rem"],"sizeUnit":"rem","size":[0.88],"line_height":[1.25],"customweight":"custom","customweightnumber":700},"buttonLink":"https://greenshiftwp.com/","linkNewWindow":true,"linkNoFollow":true} -->
        <div id="gspb_button-id-gsbp-338dde9c-9b42" class="gspb_button_wrapper gspb_button-id-gsbp-338dde9c-9b42 wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" href="https://greenshiftwp.com/" target="_blank" rel="noopener nofollow"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Download Free Resources</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-6679f3c4-55ff","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-6679f3c4-55ff" class="gspb_container gspb_container-gsbp-6679f3c4-55ff wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-f025caa2-54c0","inlineCssStyles":null,"headingTag":"h3","headingContent":"Figma Included","spacing":{"margin":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["rem","px","px","px"],"locked":true},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#0f172a","sizeUnit":"rem","size":[1.12],"line_height":[1.75],"lineHeightUnit":["rem"]}} -->
        <h3 id="gspb_heading-id-gsbp-f025caa2-54c0" class="gspb_heading gspb_heading-id-gsbp-f025caa2-54c0 ">Figma Included</h3>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-700a21ab-ee6b","inlineCssStyles":null,"textContent":"Amet minim mollit non deserunt ullamco est sit aliqua dolor.","spacing":{"margin":{"values":{"top":["1"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[0.9],"lineHeightUnit":["rem"],"line_height":[1.25],"customweight":null,"color":"#5a6779","letter_spacing":["0.02em"]}} -->
        <div id="gspb_text-id-gsbp-700a21ab-ee6b" class="gspb_text gspb_text-id-gsbp-700a21ab-ee6b ">Amet minim mollit non deserunt ullamco est sit aliqua dolor.</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-083d6ace-bae6","inlineCssStyles":null,"buttonContent":"Download Free Resources","background":{"color":"#00000000"},"spacing":{"margin":{"values":{"top":["1.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}},"typography":{"textShadow":{},"color":"#2563eb","lineHeightUnit":["rem"],"sizeUnit":"rem","size":[0.88],"line_height":[1.25],"customweight":"custom","customweightnumber":700},"buttonLink":"https://greenshiftwp.com/","linkNewWindow":true,"linkNoFollow":true} -->
        <div id="gspb_button-id-gsbp-083d6ace-bae6" class="gspb_button_wrapper gspb_button-id-gsbp-083d6ace-bae6 wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" href="https://greenshiftwp.com/" target="_blank" rel="noopener nofollow"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Download Free Resources</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/inforating',
        array(
            'title'       => __('Info with review', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('cta', 'testimonial'),
            'description' => _x('Info with review', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-490a2a75-f7fc","inlineCssStyles":null,"align":"full","gutterClassName":"gspb_row\u002d\u002dgutter-custom-0","rowLayout":"2","brp_rowLayout":["30",null,null],"width":[1200,null,null,null],"displayStyles":false,"background":{"color":"#f1f5f9"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["6"],"bottom":["6"],"right":["2","1.5",null,"1.5"],"left":["2","1.5",null,"1.5"]},"unit":["rem","rem","px","rem"],"locked":false}},"columnGapNew":200,"rowGap":[50,40,null,null]} -->
        <div id="gspb_row-id-gsbp-490a2a75-f7fc" class="gspb_row gspb_row-id-gsbp-490a2a75-f7fc wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-490a2a75-f7fc gspb_row--gutter-custom-0"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-866d7828-65a3","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-200","flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"columnSize":"6","brp_columnSize":["12",null,null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}}} -->
        <div id="gspb_col-id-gsbp-866d7828-65a3" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-866d7828-65a3"><!-- wp:greenshift-blocks/container {"id":"gsbp-9e803b88-072d","inlineCssStyles":null,"minHeight":[454,540,null,298],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"","columngapUnit":["rem"],"columngap":[null],"gridcolumns":[8]},"background":{"color":"#e6e6e7"},"border":{"borderRadius":{"values":{"topLeft":"24","topRight":"24","bottomRight":"24","bottomLeft":"24"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-9e803b88-072d" class="gspb_container gspb_container-gsbp-9e803b88-072d wp-block-greenshift-blocks-container"></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-3bb73da5-7081","inlineCssStyles":null,"gutterclass":"gspb_row\u002d\u002dgutter-200","flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["column"],"justifyContent":["center"],"alignItems":["flex-start"]},"columnSize":"6","brp_columnSize":["12",null,null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":["4",0],"bottom":[null],"left":[0,0]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-3bb73da5-7081" class="gspb_row__col--6 wp-block-greenshift-blocks-row-column  gspb_row__col--md-12 gspb_col-id-gsbp-3bb73da5-7081"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-2d690014-0307","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[20],"right":[20],"bottom":[20],"left":[20]},"unit":["px","px","px","px"],"locked":true}},"background":{"color":"#2563eb"},"iconBox_icon":{"icon":{"font":"rhicon rhi-quote-left","svg":"","image":""},"fill":"#ffffff","fillhover":"","type":"font","strokeColor":"","iconSize":[32]}} -->
        <div id="gspb_iconBox-id-gsbp-2d690014-0307" class="gspb_iconBox gspb_iconBox-id-gsbp-2d690014-0307 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M928 512h-160v-128c0-70.6 57.4-128 128-128h16c26.6 0 48-21.4 48-48v-96c0-26.6-21.4-48-48-48h-16c-176.8 0-320 143.2-320 320v480c0 53 43 96 96 96h256c53 0 96-43 96-96v-256c0-53-43-96-96-96zM352 512h-160v-128c0-70.6 57.4-128 128-128h16c26.6 0 48-21.4 48-48v-96c0-26.6-21.4-48-48-48h-16c-176.8 0-320 143.2-320 320v480c0 53 43 96 96 96h256c53 0 96-43 96-96v-256c0-53-43-96-96-96z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-850356b6-a756","inlineCssStyles":null,"textContent":"\u0022We love Gutenberg! Our designers were using it for their projects, so clients already knew what Gutenberg was and how to use it.\u0022","spacing":{"margin":{"values":{"top":["2.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[2.1],"lineHeightUnit":["rem"],"line_height":[2.5],"customweight":null,"customweightnumber":400,"color":"#000000"}} -->
        <div id="gspb_text-id-gsbp-850356b6-a756" class="gspb_text gspb_text-id-gsbp-850356b6-a756 ">"We love Gutenberg! Our designers were using it for their projects, so clients already knew what Gutenberg was and how to use it."</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-75a9b0db-3de2","inlineCssStyles":null,"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[1],"alignItems":["center"]},"spacing":{"margin":{"values":{"top":["2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-75a9b0db-3de2" class="gspb_container gspb_container-gsbp-75a9b0db-3de2 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-f80ed269-dcf4","inlineCssStyles":null,"textContent":"Jane Doe","typography":{"textShadow":{},"customweight":"custom","customweightnumber":600,"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1.1],"line_height":[1.5],"color":"#000000"}} -->
        <div id="gspb_text-id-gsbp-f80ed269-dcf4" class="gspb_text gspb_text-id-gsbp-f80ed269-dcf4 ">Jane Doe</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-cf9bd9d9-9075","inlineCssStyles":null,"textContent":"Co-Founder of","typography":{"textShadow":{},"customweight":"custom","customweightnumber":400,"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1.1],"line_height":[1.5],"color":"#000000"}} -->
        <div id="gspb_text-id-gsbp-cf9bd9d9-9075" class="gspb_text gspb_text-id-gsbp-cf9bd9d9-9075 ">Co-Founder of</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-0d2005d7-9857","inlineCssStyles":null,"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row",null,null,"row"],"columngap":[6],"alignItems":["center"]},"background":{"color":"#ffffff"},"border":{"borderRadius":{"values":{"topLeft":"99","topRight":"99","bottomRight":"99","bottomLeft":"99"},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"right":[0.6],"left":[0.5],"top":[0.3],"bottom":[0.3]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-0d2005d7-9857" class="gspb_container gspb_container-gsbp-0d2005d7-9857 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-3e9fbe60-c97f","inlineCssStyles":null,"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"iconBox_icon":{"icon":{"font":"rhicon rhi-gem","svg":"","image":""},"fill":"#0274ff","fillhover":"","type":"font","iconSize":["18px"]},"responsive":{"customcss":""}} -->
        <div id="gspb_iconBox-id-gsbp-3e9fbe60-c97f" class="gspb_iconBox gspb_iconBox-id-gsbp-3e9fbe60-c97f wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1152 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M927.4 0h-702.8c-8.4 0-16.2 4.4-20.6 11.6l-200.6 325.6c-5.4 8.8-4.4 20.2 2.4 28l552 650.4c9.6 11.2 26.8 11.2 36.4 0l552-650.4c6.8-7.8 7.6-19.2 2.4-28l-200.6-325.6c-4.4-7.2-12.2-11.6-20.6-11.6zM900.2 72l148.6 248h-166l-113.6-248h131zM690 72l113.6 248h-455.4l113.8-248h228zM251.8 72h131l-113.6 248h-166l148.6-248zM122.4 384h146l163.6 384-309.6-384zM346.4 384h459l-229.4 527.6-229.6-527.6zM720 768l163.6-384h146l-309.6 384z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-4b2d13f7-7e0e","inlineCssStyles":null,"textContent":"Company","spacing":{"margin":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["px","px","px","px"],"locked":true}},"typography":{"textShadow":{},"customweight":"bold","customweightnumber":900,"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1],"line_height":[1.1],"color":"#000000"}} -->
        <div id="gspb_text-id-gsbp-4b2d13f7-7e0e" class="gspb_text gspb_text-id-gsbp-4b2d13f7-7e0e ">Company</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/stepcards',
        array(
            'title'       => __('Step cards', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('cta', 'steps'),
            'description' => _x('Step cards', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-5e9baeff-b823","inlineCssStyles":null,"align":"full","width":[1280,null,null,null],"columnPosition":"","columnJustify":"","displayStyles":false,"background":{"color":"#000000"},"spacing":{"margin":{"values":{"top":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["5","4",null,"3"],"bottom":["5","4",null,"3"],"right":[0],"left":[0]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-5e9baeff-b823" class="gspb_row gspb_row-id-gsbp-5e9baeff-b823 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-5e9baeff-b823"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-26d79e4b-ff9c","inlineCssStyles":null,"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"alignItems":["center"],"type":"flexbox"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":["3","2",null,"1.5"],"bottom":[0],"left":["3","2",null,"1.5"]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-26d79e4b-ff9c" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-26d79e4b-ff9c"><!-- wp:greenshift-blocks/container {"id":"gsbp-ad47241d-c7e3","inlineCssStyles":null,"width":[512,100,null,null],"widthUnit":["px","%","%","%"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""}} -->
        <div id="gspb_container-id-gsbp-ad47241d-c7e3" class="gspb_container gspb_container-gsbp-ad47241d-c7e3 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-611498b6-3fed","inlineCssStyles":null,"headingContent":"Ut hendrerit ut in","spacing":{"margin":{"values":{"top":[0]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[0]},"unit":["rem","px","px","px"],"locked":false}},"typography":{"alignment":["center","left"],"textShadow":{},"sizeUnit":"rem","size":[3.9,3.9,null,2.7],"customweight":"normal","customweightnumber":400,"lineHeightUnit":["rem"],"line_height":[3,3,null,2.7],"color":"#ffffff"}} -->
        <h2 id="gspb_heading-id-gsbp-611498b6-3fed" class="gspb_heading gspb_heading-id-gsbp-611498b6-3fed ">Ut hendrerit ut in</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-45025090-c9b2","inlineCssStyles":null,"headingContent":"quam dolor.","spacing":{"margin":{"values":{"top":["-0.5"],"right":[null],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false}},"typography":{"alignment":["center","left"],"textShadow":{},"sizeUnit":"rem","size":[3.7,3.7,null,2.5],"customweight":"normal","customweightnumber":400,"lineHeightUnit":["rem"],"line_height":[null,null,null,2.5],"color":"#ffffff","fontstyle":"italic"}} -->
        <h2 id="gspb_heading-id-gsbp-45025090-c9b2" class="gspb_heading gspb_heading-id-gsbp-45025090-c9b2 ">quam dolor.</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-6e5823ec-4937","inlineCssStyles":null,"textContent":"Amet suspendisse sit condimentum et. Adipiscing blandit posuere lacus, porta non sed nec. Sodales cras rhoncus lectus tempus.","spacing":{"margin":{"values":{"top":["1.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"alignment":["center","left"],"textShadow":{},"lineHeightUnit":["rem"],"line_height":[1.8],"color":"#7f7f7f","sizeUnit":"rem","size":[1.2],"customweight":"custom","customweightnumber":500}} -->
        <div id="gspb_text-id-gsbp-6e5823ec-4937" class="gspb_text gspb_text-id-gsbp-6e5823ec-4937 ">Amet suspendisse sit condimentum et. Adipiscing blandit posuere lacus, porta non sed nec. Sodales cras rhoncus lectus tempus.</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-66c5fd6e-6c0f","inlineCssStyles":null,"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","alignItems":[null,"flex-start"]}} -->
        <div id="gspb_container-id-gsbp-66c5fd6e-6c0f" class="gspb_container gspb_container-gsbp-66c5fd6e-6c0f wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/button {"id":"gsbp-45390556-29f6","inlineCssStyles":null,"buttonContent":"Learn More","align":"center","background":{"color":"#000000","hoverColor":"#e4e4e7"},"spacing":{"margin":{"values":{"top":["2.3"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":["0.8"],"bottom":["0.8"],"right":["1"],"left":["1.7"]},"unit":["rem","px","px","px"],"locked":false}},"iconSpacing":{"margin":{"values":{"top":[0],"right":[0],"bottom":[0],"left":["0.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":"99","topRight":"99","bottomRight":"99","bottomLeft":"99"},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[2]},"color":{"all":["#e4e4e7"]},"styleHover":{},"sizeHover":{},"colorHover":{"all":["#000000"]}},"typography":{"textShadow":{},"customweight":"custom","customweightnumber":600,"sizeUnit":"rem","size":[1.1],"lineHeightUnit":["rem"],"line_height":[1.5],"color":"#ffffff","colorHover":"#18181b","alignment":["center","center","center","center"]},"responsive":{"customcss":".gspb-buttonbox-icon svg {  \n  margin: 0px !important;\n  vertical-align: middle;\n}"},"enableIcon":true,"iconRight":true,"iconBox_icon":{"icon":{"font":"rhicon rhi-paper-plane","svg":"\u003csvg class=\u0022cd rc wb\u0022 xmlns=\u0022http://www.w3.org/2000/svg\u0022 fill=\u0022none\u0022 viewBox=\u00220 0 24 24\u0022 stroke=\u0022currentColor\u0022\u003e\n                        \u003cpath stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022 stroke-width=\u00222\u0022 d=\u0022M13 7l5 5m0 0l-5 5m5-5H6\u0022\u003e\u003c/path\u003e\n                    \u003c/svg\u003e","image":""},"fill":"#ffffff","fillhover":"","type":"svg","iconSize":[24]},"enableblockIcon":false} -->
        <div id="gspb_button-id-gsbp-45390556-29f6" class="gspb_button_wrapper gspb_button-id-gsbp-45390556-29f6 wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Learn More</span></span><span class="gspb-buttonbox-icon"><svg class="cd rc wb" xmlns="http://www.w3.org/2000/svg" style="width:5rem;height:5rem;margin:10px" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>                    </svg></span></span></a></div>
        <!-- /wp:greenshift-blocks/button --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-4392ad64-83ff","inlineCssStyles":null,"width":[100,100,null,null],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","flexDirection":["row","column"]},"border":{"borderRadius":{"values":{},"unit":"rem","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":["3"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-4392ad64-83ff" class="gspb_container gspb_container-gsbp-4392ad64-83ff wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-5b2a87d7-58f6","inlineCssStyles":null,"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"background":{"hoverColor":"#1c1c1cc2"},"border":{"borderRadius":{"values":{"topLeft":["0.5"],"bottomLeft":["0.5","0.1"],"topRight":[null,"0.5"]},"unit":"rem"},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#7f7f7f"]},"styleHover":{},"sizeHover":{},"colorHover":{}}} -->
        <div id="gspb_container-id-gsbp-5b2a87d7-58f6" class="gspb_container gspb_container-gsbp-5b2a87d7-58f6 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-5b82f845-a9eb","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"right":[null],"left":[null],"top":[null],"bottom":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":["2.5"],"right":["3"],"left":["3"],"bottom":["2.5"]},"unit":["rem","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-5b82f845-a9eb" class="gspb_container gspb_container-gsbp-5b82f845-a9eb wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-7631d112-9eff","inlineCssStyles":null,"textContent":"Slack Community","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[1.5],"lineHeightUnit":["rem"],"line_height":[2],"customweight":"custom","customweightnumber":500,"alignment":[null,"center"]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-7631d112-9eff" class="gspb_text gspb_text-id-gsbp-7631d112-9eff ">Slack Community</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-6f58dbce-969d","inlineCssStyles":null,"textContent":"Non pretium mi, sagittis placerat. Elit risus malesuada ornare orci in.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["0.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.5],"customweight":null,"customweightnumber":400,"alignment":[null,"center",null,"center"]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-6f58dbce-969d" class="gspb_text gspb_text-id-gsbp-6f58dbce-969d ">Non pretium mi, sagittis placerat. Elit risus malesuada ornare orci in.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-8b4b1dd3-4101","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["50%","100%","100%","100%"],"right":["-1.5rem","0%","40%",null],"left":[null,"0%","50%",null],"bottom":[null,null,"0rem",null]}},"Zindex":10},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{"translateY":[-50,-50,null,0],"translateX":[null,null,null,0],"translateZ":[null,null,null,null],"unit":["%","%","%","%"],"rotateZ":[null,90,90,90]},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-8b4b1dd3-4101" class="gspb_container gspb_container-gsbp-8b4b1dd3-4101 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-3b02f771-4ac5","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[14],"right":[14],"bottom":[14],"left":[14]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#000000"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#7f7f7f"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"iconBox_icon":{"icon":{"font":"rhicon rhi-arrow-right","svg":"","image":""},"fill":"#ffffff","fillhover":"","type":"font","iconSize":["15px"],"strokeColor":"#ffffff"},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""}} -->
        <div id="gspb_iconBox-id-gsbp-3b02f771-4ac5" class="gspb_iconBox gspb_iconBox-id-gsbp-3b02f771-4ac5 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 896 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M436.202 76.202l-39.598 39.598c-9.372 9.372-9.372 24.568 0 33.942l310.26 310.258h-682.864c-13.254 0-24 10.746-24 24v56c0 13.254 10.746 24 24 24h682.864l-310.26 310.26c-9.372 9.372-9.372 24.568 0 33.942l39.598 39.598c9.372 9.372 24.568 9.372 33.942 0l418.828-418.828c9.372-9.372 9.372-24.568 0-33.942l-418.83-418.828c-9.372-9.374-24.568-9.374-33.94 0z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-f03dacc4-59ea","inlineCssStyles":null,"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"background":{"hoverColor":"#181818c2"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"top":["solid","none"],"right":["solid","solid"],"bottom":["solid","solid"],"left":[null,"solid"]},"size":{"top":[1],"right":[1,1],"bottom":[1,1],"left":[null,1]},"color":{"top":["#7f7f7f",null],"right":["#7f7f7f","#7f7f7f"],"bottom":["#7f7f7f","#7f7f7f"],"left":[null,"#7f7f7f"]},"styleHover":{},"sizeHover":{},"colorHover":{}}} -->
        <div id="gspb_container-id-gsbp-f03dacc4-59ea" class="gspb_container gspb_container-gsbp-f03dacc4-59ea wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-f59b5c50-d0c2","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"right":[null],"left":[null],"top":[null],"bottom":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"right":["3"],"left":["3"],"top":["2.5"],"bottom":["2.5"]},"unit":["rem","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-f59b5c50-d0c2" class="gspb_container gspb_container-gsbp-f59b5c50-d0c2 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-c725eae4-31af","inlineCssStyles":null,"textContent":"Slack Community","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[1.5],"lineHeightUnit":["rem"],"line_height":[2],"customweight":"custom","customweightnumber":500,"alignment":[null,"center"]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-c725eae4-31af" class="gspb_text gspb_text-id-gsbp-c725eae4-31af ">Slack Community</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-8082121a-c770","inlineCssStyles":null,"textContent":"Non pretium mi, sagittis placerat. Elit risus malesuada ornare orci in.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["0.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.5],"customweight":null,"customweightnumber":400,"alignment":[null,"center",null,"center"]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-8082121a-c770" class="gspb_text gspb_text-id-gsbp-8082121a-c770 ">Non pretium mi, sagittis placerat. Elit risus malesuada ornare orci in.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-28445742-11f9","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["absolute","","",""],"positions":{"values":{"top":["50%","100%","100%","100%"],"right":["-1.5rem","0%","40%",null],"left":[null,"0%","50%",null],"bottom":[null,null,"0rem",null]}},"Zindex":10},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{"translateY":[-50,-50,null,0],"translateX":[null,null,null,0],"translateZ":[null,null,null,null],"unit":["%","%","%","%"],"rotateZ":[null,90,90,90]},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-28445742-11f9" class="gspb_container gspb_container-gsbp-28445742-11f9 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-c3ecf9fe-b402","inlineCssStyles":null,"type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[14],"right":[14],"bottom":[14],"left":[14]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#000000"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#7f7f7f"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"iconBox_icon":{"icon":{"font":"rhicon rhi-arrow-right","svg":"","image":""},"fill":"#ffffff","fillhover":"","type":"font","iconSize":["15px"],"strokeColor":"#ffffff"},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""}} -->
        <div id="gspb_iconBox-id-gsbp-c3ecf9fe-b402" class="gspb_iconBox gspb_iconBox-id-gsbp-c3ecf9fe-b402 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 896 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M436.202 76.202l-39.598 39.598c-9.372 9.372-9.372 24.568 0 33.942l310.26 310.258h-682.864c-13.254 0-24 10.746-24 24v56c0 13.254 10.746 24 24 24h682.864l-310.26 310.26c-9.372 9.372-9.372 24.568 0 33.942l39.598 39.598c9.372 9.372 24.568 9.372 33.942 0l418.828-418.828c9.372-9.372 9.372-24.568 0-33.942l-418.83-418.828c-9.372-9.374-24.568-9.374-33.94 0z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-9be6db61-e71b","inlineCssStyles":null,"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"background":{"hoverColor":"#181818c2"},"border":{"borderRadius":{"values":{"topRight":["0.5","0.1"],"bottomRight":["0.5"],"bottomLeft":[null,"0.5"]},"unit":"rem"},"style":{"top":["solid","none"],"right":["solid","solid"],"bottom":["solid","solid"],"left":[null,"solid"]},"size":{"top":[1],"right":[1,1],"bottom":[1,1],"left":[null,1]},"color":{"top":["#7f7f7f"],"right":["#7f7f7f","#7f7f7f"],"bottom":["#7f7f7f","#7f7f7f"],"left":[null,"#7f7f7f"]},"styleHover":{},"sizeHover":{},"colorHover":{}}} -->
        <div id="gspb_container-id-gsbp-9be6db61-e71b" class="gspb_container gspb_container-gsbp-9be6db61-e71b wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-09a704e1-1667","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"right":[null],"left":[null],"top":[null],"bottom":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"right":["3"],"left":["3"],"top":["2.5"],"bottom":["2.5"]},"unit":["rem","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-09a704e1-1667" class="gspb_container gspb_container-gsbp-09a704e1-1667 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-323326e6-2b88","inlineCssStyles":null,"textContent":"Slack Community","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[1.5],"lineHeightUnit":["rem"],"line_height":[2],"customweight":"custom","customweightnumber":500,"alignment":[null,"center"]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-323326e6-2b88" class="gspb_text gspb_text-id-gsbp-323326e6-2b88 ">Slack Community</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-fa2d1a12-fd3f","inlineCssStyles":null,"textContent":"Non pretium mi, sagittis placerat. Elit risus malesuada ornare orci in.","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["0.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#ffffff","sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.5],"customweight":null,"customweightnumber":400,"alignment":[null,"center",null,"center"]},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-fa2d1a12-fd3f" class="gspb_text gspb_text-id-gsbp-fa2d1a12-fd3f ">Non pretium mi, sagittis placerat. Elit risus malesuada ornare orci in.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/infothreecolumn',
        array(
            'title'       => __('Columned info block', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('info', 'features'),
            'description' => _x('Info block', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-3a96751e-3155","align":"full","width":[80,null,null,null],"widthUnit":["rem","px","px","px"],"displayStyles":false,"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["4"],"bottom":["4"]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-3a96751e-3155" class="gspb_row gspb_row-id-gsbp-3a96751e-3155 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-3a96751e-3155"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-f5a8c42e-e34a","flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"alignItems":["center"],"type":"flexbox"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":["2"],"bottom":[0],"left":["2"]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-f5a8c42e-e34a" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-f5a8c42e-e34a"><!-- wp:greenshift-blocks/container {"id":"gsbp-9af877d5-b381","width":[42,null,100,null],"widthUnit":["rem","rem","%","%"]} -->
        <div id="gspb_container-id-gsbp-9af877d5-b381" class="gspb_container gspb_container-gsbp-9af877d5-b381 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-ba0a4ab9-c138","textContent":"Build any pages with 3 simple steps","typography":{"textShadow":{},"alignment":["center"],"color":"#52525b","sizeUnit":"rem","lineHeightUnit":["rem"],"line_height":[1.75],"size":[1.2]}} -->
        <div id="gspb_text-id-gsbp-ba0a4ab9-c138" class="gspb_text gspb_text-id-gsbp-ba0a4ab9-c138 ">Build any pages with 3 simple steps</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-20efaabb-cdfd","headingContent":"Meet Greenshift, the most powerful gutenberg solution","spacing":{"margin":{"values":{"top":["1.2"],"right":[0],"bottom":[0],"left":[0]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":true}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[3,2.25,null,1.9],"line_height":[3,2.5,null,2.25],"customweight":null,"customweightnumber":500,"color":"#18181b","letter_spacing":[null],"textBorder":null,"textBorderHover":null}} -->
        <h2 id="gspb_heading-id-gsbp-20efaabb-cdfd" class="gspb_heading gspb_heading-id-gsbp-20efaabb-cdfd ">Meet Greenshift, the most powerful gutenberg solution</h2>
        <!-- /wp:greenshift-blocks/heading --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-86a41bf2-933b","flexbox":{"type":"grid","enable":false,"gridcolumns":[3,null,null,1],"columngap":[4,1.5],"rowgap":[3,3],"columngapUnit":["rem","rem"],"rowgapUnit":["rem","rem"]},"spacing":{"margin":{"values":{"top":["5",null,null,"3"]},"unit":["rem","px","px","rem"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-86a41bf2-933b" class="gspb_container gspb_container-gsbp-86a41bf2-933b wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-64e945d2-a9c3","flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""}} -->
        <div id="gspb_container-id-gsbp-64e945d2-a9c3" class="gspb_container gspb_container-gsbp-64e945d2-a9c3 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-9c3c791a-bf95","headingContent":"Track your customers directly from website","spacing":{"margin":{"values":{"top":[null,0],"right":[null,0],"bottom":[null,0],"left":[null,0]},"unit":["px","rem","px","px"],"locked":true},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#18181b","sizeUnit":"rem","size":[1.5],"lineHeightUnit":["rem"],"line_height":[2],"customweight":"custom","customweightnumber":700,"alignment":[null,null,null,"center"]}} -->
        <h2 id="gspb_heading-id-gsbp-9c3c791a-bf95" class="gspb_heading gspb_heading-id-gsbp-9c3c791a-bf95 ">Track your customers directly from website</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-59992767-9028","minHeight":[265,163,null,268],"minHeightUnit":["px","px","px","px"],"background":{"color":"#e4e4e7"},"border":{"borderRadius":{"values":{"topLeft":["0.7"],"topRight":["0.7"],"bottomRight":["0.7"],"bottomLeft":["0.7"]},"unit":"rem","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"left":[null],"bottom":[null],"top":["2.3"],"right":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"left":[null],"top":[null],"right":[null],"bottom":[null]},"unit":["rem","px","px","px"],"locked":true}}} -->
        <div id="gspb_container-id-gsbp-59992767-9028" class="gspb_container gspb_container-gsbp-59992767-9028 wp-block-greenshift-blocks-container"></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-8f1bd7d8-c874","textContent":"Consectetur adipis cing elit. Mattis a, tincidunt pulvinar sodales. Quis tellus vel eget in nulla odio. Tellus pharetra sit convallis vel, fermentum dignissim cras in.","spacing":{"margin":{"values":{"top":["1.7"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.75],"color":"#18181b","alignment":[null,null,null,"center"]}} -->
        <div id="gspb_text-id-gsbp-8f1bd7d8-c874" class="gspb_text gspb_text-id-gsbp-8f1bd7d8-c874 ">Consectetur adipis cing elit. Mattis a, tincidunt pulvinar sodales. Quis tellus vel eget in nulla odio. Tellus pharetra sit convallis vel, fermentum dignissim cras in.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-5a4e1e3a-cd48"} -->
        <div id="gspb_container-id-gsbp-5a4e1e3a-cd48" class="gspb_container gspb_container-gsbp-5a4e1e3a-cd48 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-a507d480-ef1f","headingContent":"Track your customers directly from website","spacing":{"margin":{"values":{"top":[null,0],"right":[null,0],"bottom":[null,0],"left":[null,0]},"unit":["px","rem","px","px"],"locked":true},"padding":{"values":{"top":[null,null],"right":[null,null],"bottom":[null,null],"left":[null,null]},"unit":["px","px","px","px"],"locked":true}},"typography":{"textShadow":{},"color":"#18181b","sizeUnit":"rem","size":[1.5],"lineHeightUnit":["rem"],"line_height":[2],"customweight":"custom","customweightnumber":700,"alignment":[null,null,null,"center"]}} -->
        <h2 id="gspb_heading-id-gsbp-a507d480-ef1f" class="gspb_heading gspb_heading-id-gsbp-a507d480-ef1f ">Track your customers directly from website</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-7bc034ab-e19b","minHeight":[265,163,null,268],"minHeightUnit":["px","px","px","px"],"background":{"color":"#e4e4e7"},"border":{"borderRadius":{"values":{"topLeft":["0.7"],"topRight":["0.7"],"bottomRight":["0.7"],"bottomLeft":["0.7"]},"unit":"rem","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"left":[null],"bottom":[null],"top":["2.3"],"right":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"left":[null],"top":[null],"right":[null],"bottom":[null]},"unit":["rem","px","px","px"],"locked":true}}} -->
        <div id="gspb_container-id-gsbp-7bc034ab-e19b" class="gspb_container gspb_container-gsbp-7bc034ab-e19b wp-block-greenshift-blocks-container"></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-e68d3680-92e3","textContent":"Consectetur adipis cing elit. Mattis a, tincidunt pulvinar sodales. Quis tellus vel eget in nulla odio. Tellus pharetra sit convallis vel, fermentum dignissim cras in.","spacing":{"margin":{"values":{"top":["1.7"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.75],"color":"#18181b","alignment":[null,null,null,"center"]}} -->
        <div id="gspb_text-id-gsbp-e68d3680-92e3" class="gspb_text gspb_text-id-gsbp-e68d3680-92e3 ">Consectetur adipis cing elit. Mattis a, tincidunt pulvinar sodales. Quis tellus vel eget in nulla odio. Tellus pharetra sit convallis vel, fermentum dignissim cras in.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-3c221531-28fa"} -->
        <div id="gspb_container-id-gsbp-3c221531-28fa" class="gspb_container gspb_container-gsbp-3c221531-28fa wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-68ac8f4d-5ccf","headingContent":"Track your customers directly from website","spacing":{"margin":{"values":{"top":[null,0],"right":[null,0],"bottom":[null,0],"left":[null,0]},"unit":["px","rem","px","px"],"locked":true},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#18181b","sizeUnit":"rem","size":[1.5],"lineHeightUnit":["rem"],"line_height":[2],"customweight":"custom","customweightnumber":700,"alignment":[null,null,null,"center"]}} -->
        <h2 id="gspb_heading-id-gsbp-68ac8f4d-5ccf" class="gspb_heading gspb_heading-id-gsbp-68ac8f4d-5ccf ">Track your customers directly from website</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-959d475d-9a3d","minHeight":[265,163,null,268],"minHeightUnit":["px","px","px","px"],"background":{"color":"#e4e4e7"},"border":{"borderRadius":{"values":{"topLeft":["0.7"],"topRight":["0.7"],"bottomRight":["0.7"],"bottomLeft":["0.7"]},"unit":"rem","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"left":[null],"bottom":[null],"top":["2.3"],"right":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"left":[null],"top":[null],"right":[null],"bottom":[null]},"unit":["rem","px","px","px"],"locked":true}}} -->
        <div id="gspb_container-id-gsbp-959d475d-9a3d" class="gspb_container gspb_container-gsbp-959d475d-9a3d wp-block-greenshift-blocks-container"></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-f5a35fd7-bf5f","textContent":"Consectetur adipis cing elit. Mattis a, tincidunt pulvinar sodales. Quis tellus vel eget in nulla odio. Tellus pharetra sit convallis vel, fermentum dignissim cras in.","spacing":{"margin":{"values":{"top":["1.7"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.75],"color":"#18181b","alignment":[null,null,null,"center"]}} -->
        <div id="gspb_text-id-gsbp-f5a35fd7-bf5f" class="gspb_text gspb_text-id-gsbp-f5a35fd7-bf5f ">Consectetur adipis cing elit. Mattis a, tincidunt pulvinar sodales. Quis tellus vel eget in nulla odio. Tellus pharetra sit convallis vel, fermentum dignissim cras in.</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/categorygrid',
        array(
            'title'       => __('Category grid', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/container'),
            'keywords' => array('category', 'grid'),
            'description' => _x('Category grid', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-8cbedc72-652e","align":"full","width":[80,null,null,null],"widthUnit":["rem","px","px","px"],"displayStyles":false,"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["5","4",null,"3"],"bottom":["5","4",null,"3"],"right":[0,"1.5",null,"1"],"left":[0,"1.5",null,"1"]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-8cbedc72-652e" class="gspb_row gspb_row-id-gsbp-8cbedc72-652e wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-8cbedc72-652e"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-1d34f3d1-c4a6","flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":["2","1.5",null,"1"],"bottom":[0],"left":["2","1.5",null,"1"]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-1d34f3d1-c4a6" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-1d34f3d1-c4a6"><!-- wp:greenshift-blocks/container {"id":"gsbp-e4671677-058b","flexbox":{"type":"flexbox","flexDirection":["row"],"justifyContent":["space-between",null,null,"center"]}} -->
        <div id="gspb_container-id-gsbp-e4671677-058b" class="gspb_container gspb_container-gsbp-e4671677-058b wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-f93643c8-a288"} -->
        <div id="gspb_container-id-gsbp-f93643c8-a288" class="gspb_container gspb_container-gsbp-f93643c8-a288 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-8f4fc563-a7b0","headingContent":"Popular Categories","typography":{"textShadow":{},"sizeUnit":"rem","size":[1.87,null,null,1.5],"line_height":[2],"lineHeightUnit":["rem"],"customweight":null,"customweightnumber":700,"alignment":[null,null,null,"center"]}} -->
        <h2 id="gspb_heading-id-gsbp-8f4fc563-a7b0" class="gspb_heading gspb_heading-id-gsbp-8f4fc563-a7b0 ">Popular Categories</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-ffeed11a-27f9","textContent":"Choose from wide variety of items","spacing":{"margin":{"values":{"top":[null,null,null,"-0.5"]},"unit":["px","px","px","rem"],"locked":false},"padding":{"values":{"top":[null]},"unit":["rem","px","px","px"],"locked":false}},"typography":{"textShadow":{},"sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1],"color":"#52525b"}} -->
        <div id="gspb_text-id-gsbp-ffeed11a-27f9" class="gspb_text gspb_text-id-gsbp-ffeed11a-27f9 ">Choose from wide variety of items</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-7dbe33ac-51ec","responsive":{"hideOnMobile":true}} -->
        <div id="gspb_container-id-gsbp-7dbe33ac-51ec" class="gspb_container gspb_container-gsbp-7dbe33ac-51ec wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/button {"id":"gsbp-7275626c-2ee9","buttonContent":"ALL CATEGORIES","background":{"overlayOpacity":null,"color":"#ffffff00"},"iconSpacing":{"margin":{"values":{"bottom":["0.2"],"left":["0.4"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#a1a1aa","customweight":"custom","customweightnumber":700,"sizeUnit":"rem","size":[0.75],"lineHeightUnit":["rem"],"line_height":[1],"letter_spacing":["0.025em"]},"responsive":{"hideOnMobile":false},"enableIcon":true,"iconRight":true,"iconBox_icon":{"icon":{"font":"rhicon rhi-chevron-right","svg":"","image":""},"fill":"#a1a1aa","fillhover":"","type":"font","iconSize":["0.75rem"]},"enableblockIcon":false} -->
        <div id="gspb_button-id-gsbp-7275626c-2ee9" class="gspb_button_wrapper gspb_button-id-gsbp-7275626c-2ee9 wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">ALL CATEGORIES</span></span><span class="gspb-buttonbox-icon"><svg class="" style="display:inline-block;vertical-align:middle" width="15" height="15" viewBox="0 0 512 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M49.414 76.202l-39.598 39.596c-9.372 9.372-9.372 24.568 0 33.942l361.398 362.26-361.398 362.26c-9.372 9.372-9.372 24.568 0 33.942l39.598 39.598c9.372 9.372 24.568 9.372 33.942 0l418.828-418.828c9.372-9.372 9.372-24.568 0-33.942l-418.828-418.828c-9.374-9.374-24.57-9.374-33.942 0z"></path></svg></span></span></a></div>
        <!-- /wp:greenshift-blocks/button --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-0babf345-7f8b","flexbox":{"type":"grid","enable":false,"gridcolumns":[6,3,null,2],"columngap":[1.5,null,null,1.3],"rowgap":[1.5,null,null,1.3],"columngapUnit":["rem",null,null,"rem"],"rowgapUnit":["rem",null,null,"rem"]},"spacing":{"margin":{"values":{"top":["3",null,null,"2.5"]},"unit":["rem","rem","px","rem"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-0babf345-7f8b" class="gspb_container gspb_container-gsbp-0babf345-7f8b wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-393373ec-a4bb","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["rem","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","justifyContent":["flex-start"],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{"color":"#f4f4f5"},"overlay":{},"border":{"borderRadius":{"values":{"topLeft":["12"],"topRight":["12"],"bottomRight":["12"],"bottomLeft":["12"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":["1.5"],"right":["1.5"],"bottom":["1.5"],"left":["1.5"]},"unit":["rem","px","px","px"],"locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{"scaleHover":[1.1],"time":"0.3"},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-393373ec-a4bb" class="gspb_container gspb_container-gsbp-393373ec-a4bb wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-42e30d78-2096","width":["custom",null,null,null],"widthUnit":["rem","px","px","px"],"heightUnit":["rem","px","px","px"],"height":["auto",null,null,null],"customWidth":[6,null,null,null],"customHeight":[null,null,null,null],"border":{"borderRadius":{"values":{"topLeft":["99"],"topRight":["99"],"bottomRight":["99"],"bottomLeft":["99"]},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#000000"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"mediaurl":"https://api.lorem.space/image/watch?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-42e30d78-2096" class="gspb_image gspb_image-id-gsbp-42e30d78-2096 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/watch?w=150&amp;h=150" data-src="" alt="" width="6" height=""/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-57f0fe7a-b769","textContent":"Smart\u003cbr\u003eWatches","spacing":{"margin":{"values":{"top":["1.3"],"bottom":[0]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":true}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1],"line_height":[1.5],"customweight":"custom","customweightnumber":700}} -->
        <div id="gspb_text-id-gsbp-57f0fe7a-b769" class="gspb_text gspb_text-id-gsbp-57f0fe7a-b769 ">Smart<br>Watches</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-327d5af8-be53","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["rem","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","justifyContent":["flex-start"],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{"color":"#f4f4f5"},"overlay":{},"border":{"borderRadius":{"values":{"topLeft":["12"],"topRight":["12"],"bottomRight":["12"],"bottomLeft":["12"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":["1.5"],"right":["1.5"],"bottom":["1.5"],"left":["1.5"]},"unit":["rem","px","px","px"],"locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{"scaleHover":[1.1],"time":"0.3"},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-327d5af8-be53" class="gspb_container gspb_container-gsbp-327d5af8-be53 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-30c3792d-78f3","width":["custom",null,null,null],"widthUnit":["rem","px","px","px"],"heightUnit":["rem","px","px","px"],"height":["auto",null,null,null],"customWidth":[6,null,null,null],"customHeight":[null,null,null,null],"border":{"borderRadius":{"values":{"topLeft":["99"],"topRight":["99"],"bottomRight":["99"],"bottomLeft":["99"]},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#000000"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"mediaurl":"https://api.lorem.space/image/game?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-30c3792d-78f3" class="gspb_image gspb_image-id-gsbp-30c3792d-78f3 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/game?w=150&amp;h=150" data-src="" alt="" width="6" height=""/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-4fdd65bb-a531","textContent":"True Wireless Controllers","spacing":{"margin":{"values":{"top":["1.3"],"bottom":[0]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1],"line_height":[1.5],"customweight":"custom","customweightnumber":700}} -->
        <div id="gspb_text-id-gsbp-4fdd65bb-a531" class="gspb_text gspb_text-id-gsbp-4fdd65bb-a531 ">True Wireless Controllers</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-1a4d6940-e93e","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["rem","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","justifyContent":["flex-start"],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{"color":"#f4f4f5"},"overlay":{},"border":{"borderRadius":{"values":{"topLeft":["12"],"topRight":["12"],"bottomRight":["12"],"bottomLeft":["12"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":["1.5"],"right":["1.5"],"bottom":["1.5"],"left":["1.5"]},"unit":["rem","px","px","px"],"locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{"scaleHover":[1.1],"time":"0.3"},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-1a4d6940-e93e" class="gspb_container gspb_container-gsbp-1a4d6940-e93e wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-ef66040e-1157","width":["custom",null,null,null],"widthUnit":["rem","px","px","px"],"heightUnit":["rem","px","px","px"],"height":["auto",null,null,null],"customWidth":[6,null,null,null],"customHeight":[null,null,null,null],"border":{"borderRadius":{"values":{"topLeft":["99"],"topRight":["99"],"bottomRight":["99"],"bottomLeft":["99"]},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#000000"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"mediaurl":"https://api.lorem.space/image/furniture?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-ef66040e-1157" class="gspb_image gspb_image-id-gsbp-ef66040e-1157 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/furniture?w=150&amp;h=150" data-src="" alt="" width="6" height=""/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-62dfd187-049c","textContent":"Home and Furniture","spacing":{"margin":{"values":{"top":["1.3"],"bottom":[0]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1],"line_height":[1.5],"customweight":"custom","customweightnumber":700}} -->
        <div id="gspb_text-id-gsbp-62dfd187-049c" class="gspb_text gspb_text-id-gsbp-62dfd187-049c ">Home and Furniture</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-ce669569-6583","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["rem","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","justifyContent":["flex-start"],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{"color":"#f4f4f5"},"overlay":{},"border":{"borderRadius":{"values":{"topLeft":["12"],"topRight":["12"],"bottomRight":["12"],"bottomLeft":["12"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":["1.5"],"right":["1.5"],"bottom":["1.5"],"left":["1.5"]},"unit":["rem","px","px","px"],"locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{"scaleHover":[1.1],"time":"0.3"},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-ce669569-6583" class="gspb_container gspb_container-gsbp-ce669569-6583 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-321062bd-94a4","scale":["fill"],"width":["custom",null,null,null],"widthUnit":["px","px","px","px"],"heightUnit":["px","px","px","px"],"height":["custom",null,null,null],"customWidth":[100,null,null,null],"customHeight":[null,null,null,null],"border":{"borderRadius":{"values":{"topLeft":["99"],"topRight":["99"],"bottomRight":["99"],"bottomLeft":["99"]},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#000000"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"mediaurl":"https://api.lorem.space/image/car?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-321062bd-94a4" class="gspb_image gspb_image-id-gsbp-321062bd-94a4 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/car?w=150&amp;h=150" data-src="" alt="" width="100"/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-6c16b52b-8394","textContent":"Cars and drive tools","spacing":{"margin":{"values":{"top":["1.3"],"bottom":[0]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1],"line_height":[1.5],"customweight":"custom","customweightnumber":700}} -->
        <div id="gspb_text-id-gsbp-6c16b52b-8394" class="gspb_text gspb_text-id-gsbp-6c16b52b-8394 ">Cars and drive tools</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-fc77172b-ab62","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["rem","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","justifyContent":["flex-start"],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{"color":"#f4f4f5"},"overlay":{},"border":{"borderRadius":{"values":{"topLeft":["12"],"topRight":["12"],"bottomRight":["12"],"bottomLeft":["12"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":["1.5"],"right":["1.5"],"bottom":["1.5"],"left":["1.5"]},"unit":["rem","px","px","px"],"locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{"scaleHover":[1.1],"time":"0.3"},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-fc77172b-ab62" class="gspb_container gspb_container-gsbp-fc77172b-ab62 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-dae1e88f-0b00","width":["custom",null,null,null],"widthUnit":["rem","px","px","px"],"heightUnit":["rem","px","px","px"],"height":["auto",null,null,null],"customWidth":[6,null,null,null],"customHeight":[null,null,null,null],"border":{"borderRadius":{"values":{"topLeft":["99"],"topRight":["99"],"bottomRight":["99"],"bottomLeft":["99"]},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#000000"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"mediaurl":"https://api.lorem.space/image/shoes?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-dae1e88f-0b00" class="gspb_image gspb_image-id-gsbp-dae1e88f-0b00 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/shoes?w=150&amp;h=150" data-src="" alt="" width="6" height=""/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-bc0f5709-2926","textContent":"Running Shoes and cloth","spacing":{"margin":{"values":{"top":["1.3"],"bottom":[0]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1],"line_height":[1.5],"customweight":"custom","customweightnumber":700}} -->
        <div id="gspb_text-id-gsbp-bc0f5709-2926" class="gspb_text gspb_text-id-gsbp-bc0f5709-2926 ">Running Shoes and cloth</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-c45c6493-7429","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["rem","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"flexbox","justifyContent":["flex-start"],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{"color":"#f4f4f5"},"overlay":{},"border":{"borderRadius":{"values":{"topLeft":["12"],"topRight":["12"],"bottomRight":["12"],"bottomLeft":["12"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":true},"padding":{"values":{"top":["1.5"],"right":["1.5"],"bottom":["1.5"],"left":["1.5"]},"unit":["rem","px","px","px"],"locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{"scaleHover":[1.1],"time":"0.3"},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-c45c6493-7429" class="gspb_container gspb_container-gsbp-c45c6493-7429 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-e8e1f81f-6ed3","width":["custom",null,null,null],"widthUnit":["rem","px","px","px"],"heightUnit":["rem","px","px","px"],"height":["auto",null,null,null],"customWidth":[6,null,null,null],"customHeight":[null,null,null,null],"border":{"borderRadius":{"values":{"topLeft":["99"],"topRight":["99"],"bottomRight":["99"],"bottomLeft":["99"]},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#000000"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"mediaurl":"https://api.lorem.space/image/drink?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-e8e1f81f-6ed3" class="gspb_image gspb_image-id-gsbp-e8e1f81f-6ed3 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/drink?w=150&amp;h=150" data-src="" alt="" width="6" height=""/></div>
        <!-- /wp:greenshift-blocks/image -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-6027eae6-4abe","textContent":"Kitchen, Food, Drink","spacing":{"margin":{"values":{"top":["1.3"],"bottom":[0]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"alignment":["center"],"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1],"line_height":[1.5],"customweight":"custom","customweightnumber":700}} -->
        <div id="gspb_text-id-gsbp-6027eae6-4abe" class="gspb_text gspb_text-id-gsbp-6027eae6-4abe ">Kitchen, Food, Drink</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/ctasixicons',
        array(
            'title'       => __('Full Featured CTA', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/button'),
            'keywords' => array('cta', 'features'),
            'description' => _x('Full width Row with CTA', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-5e9baeff-b823","align":"full","width":[1024,null,null,null],"displayStyles":false,"background":{"color":"#fafafa"},"spacing":{"margin":{"values":{"top":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":["5","4",null,"3"],"bottom":["5","4",null,"3"],"right":[0],"left":[0]},"unit":["rem","rem","px","rem"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-5e9baeff-b823" class="gspb_row gspb_row-id-gsbp-5e9baeff-b823 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-5e9baeff-b823"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-f23dc2b5-cd88","flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"alignItems":["center"],"type":"flexbox"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":["2","2","1.5","1"],"bottom":[0],"left":["2","2","1.5","1"]},"unit":["rem","rem","rem","rem"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-f23dc2b5-cd88" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-f23dc2b5-cd88"><!-- wp:greenshift-blocks/container {"id":"gsbp-99af861b-1879","flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":true,"marginTop":[0,null,null,null],"marginBottom":[0,null,null,null],"marginLeft":[0,null,null,null],"marginRight":[0,null,null,null],"flexDirection":["row"],"alignItems":["center"],"columngap":[6]},"spacing":{"margin":{"values":{"left":["-10"]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-99af861b-1879" class="gspb_container gspb_container-gsbp-99af861b-1879 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-d3de6a39-bd5f","type":"regular","spacing":{"margin":{"values":{"bottom":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"background":{"color":""},"shapePosition":"center","shapeJustify":"","iconBox_icon":{"icon":{"font":"rhicon rhi-gem","svg":"","image":""},"fill":"#ff0000","fillhover":"","type":"font","iconSize":["30px"]}} -->
        <div id="gspb_iconBox-id-gsbp-d3de6a39-bd5f" class="gspb_iconBox gspb_iconBox-id-gsbp-d3de6a39-bd5f wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1152 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M927.4 0h-702.8c-8.4 0-16.2 4.4-20.6 11.6l-200.6 325.6c-5.4 8.8-4.4 20.2 2.4 28l552 650.4c9.6 11.2 26.8 11.2 36.4 0l552-650.4c6.8-7.8 7.6-19.2 2.4-28l-200.6-325.6c-4.4-7.2-12.2-11.6-20.6-11.6zM900.2 72l148.6 248h-166l-113.6-248h131zM690 72l113.6 248h-455.4l113.8-248h228zM251.8 72h131l-113.6 248h-166l148.6-248zM122.4 384h146l163.6 384-309.6-384zM346.4 384h459l-229.4 527.6-229.6-527.6zM720 768l163.6-384h146l-309.6 384z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-60fe6609-6253","headingTag":"div","headingContent":"Get Greenshift","typography":{"alignment":["center"],"textShadow":{},"sizeUnit":"rem","size":[2.3,2.3,null,1.9],"customweight":"bold","customweightnumber":700,"lineHeightUnit":["rem"],"line_height":[2.6,2.5],"color":"#000000"}} -->
        <div id="gspb_heading-id-gsbp-60fe6609-6253" class="gspb_heading gspb_heading-id-gsbp-60fe6609-6253 ">Get Greenshift</div>
        <!-- /wp:greenshift-blocks/heading --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-3e12f306-d62e","textContent":"No ads. No trials. No commitments.","spacing":{"margin":{"values":{"top":["0.8"],"right":[null],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"alignment":["center"],"textShadow":{},"lineHeightUnit":["rem"],"line_height":[1],"color":"#52525b","sizeUnit":"rem","size":[1],"customweight":"custom","customweightnumber":500}} -->
        <div id="gspb_text-id-gsbp-3e12f306-d62e" class="gspb_text gspb_text-id-gsbp-3e12f306-d62e ">No ads. No trials. No commitments.</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/row {"id":"gsbp-22ed571c-f456","rowType":"full-width","width":[1200,null,null,null],"widthUnit":["px","px","px","px"],"columnPosition":"","columnJustify":"","displayStyles":false,"background":{"color":"#ffffff"},"border":{"borderRadius":{"values":{"topLeft":"16","topRight":"16","bottomRight":"16","bottomLeft":"16"},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#ededed"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"shadow":{"hoffset":"0","voffset":"5","blur":"35","spread":"0","color":"#a6acb059","position":null},"spacing":{"margin":{"values":{"top":["3",null,null,"2"]},"unit":["rem","px","px","rem"],"locked":false},"padding":{"values":{"top":["2.5"],"right":["2.5"],"bottom":["2.5"],"left":["2.5"]},"unit":["rem","px","px","px"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-22ed571c-f456" class="gspb_row gspb_row-id-gsbp-22ed571c-f456 wp-block-greenshift-blocks-row gspb_row-id-gsbp-22ed571c-f456"><!-- wp:greenshift-blocks/row-column {"id":"gsbp-7ac52675-522f","width":[40,null,null,null],"columnSize":"4","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["rem","px","px","px"],"locked":true}}} -->
        <div id="gspb_col-id-gsbp-7ac52675-522f" class="gspb_row__col--4 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-7ac52675-522f"><!-- wp:greenshift-blocks/container {"id":"gsbp-b6e86034-a8fa","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row"],"columngapUnit":["rem"],"columngap":[1],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-b6e86034-a8fa" class="gspb_container gspb_container-gsbp-b6e86034-a8fa wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-3a44f864-2e12","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-3a44f864-2e12" class="gspb_container gspb_container-gsbp-3a44f864-2e12 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-7028ccda-3630","type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[10],"right":[10],"bottom":[10],"left":[10]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#ffffff"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#e4e4e7"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"iconBox_icon":{"icon":{"font":"rhicon rhi-cloud-upload","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[20],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-7028ccda-3630" class="gspb_iconBox gspb_iconBox-id-gsbp-7028ccda-3630 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1280 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1075.2 453.2c8.2-21.4 12.8-44.8 12.8-69.2 0-106-86-192-192-192-39.4 0-76.2 12-106.6 32.4-55.4-96-158.8-160.4-277.4-160.4-176.8 0-320 143.2-320 320 0 5.4 0.2 10.8 0.4 16.2-112 39.4-192.4 146.2-192.4 271.8 0 159 129 288 288 288h736c141.4 0 256-114.6 256-256 0-123.8-88-227.2-204.8-250.8zM795.4 580.6l-21.6 21.6c-19.2 19.2-50.4 18.6-69-1l-64.8-69v251.8c0 26.6-21.4 48-48 48h-32c-26.6 0-48-21.4-48-48v-251.8l-64.8 69c-18.6 19.8-49.8 20.2-69 1l-21.6-21.6c-18.8-18.8-18.8-49.2 0-67.8l185.4-185.4c18.8-18.8 49.2-18.8 67.8 0l185.4 185.4c18.8 18.8 18.8 49.2 0.2 67.8z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-c246fcc3-afe5","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-c246fcc3-afe5" class="gspb_container gspb_container-gsbp-c246fcc3-afe5 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-c880362d-686b","textContent":"Cloud Storage","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#000000","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-c880362d-686b" class="gspb_text gspb_text-id-gsbp-c880362d-686b ">Cloud Storage</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-bd2a7d12-b789","textContent":"Up to 100GB for works","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":[0.3]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#73737a","sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-bd2a7d12-b789" class="gspb_text gspb_text-id-gsbp-bd2a7d12-b789 ">Up to 100GB for works</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-1396e105-90c8","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[1],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["2.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-1396e105-90c8" class="gspb_container gspb_container-gsbp-1396e105-90c8 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-9e1bdfb0-93a7","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-9e1bdfb0-93a7" class="gspb_container gspb_container-gsbp-9e1bdfb0-93a7 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-6bf527cf-0d3e","type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[10],"right":[10],"bottom":[10],"left":[10]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#ffffff"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#e4e4e7"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"iconBox_icon":{"icon":{"font":"rhicon rhi-inbox","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[20],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-6bf527cf-0d3e" class="gspb_iconBox gspb_iconBox-id-gsbp-6bf527cf-0d3e wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1152 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1133.638 454.754l-208.884-287.218c-17.658-24.078-45.844-39.536-77.64-39.536l-542.228 0c-0-0-0.001-0-0.001-0-31.795 0-59.98 15.458-77.449 39.268l-0.188 0.268-208.886 287.218c-11.474 15.625-18.362 35.239-18.362 56.463 0 0 0 0.001 0 0.001l-0-0v288.782c0 53.020 42.98 96 96 96h960c53.020 0 96-42.98 96-96v-288.782c0-0 0-0.001 0-0.001 0-21.223-6.888-40.838-18.55-56.731l0.188 0.268zM279.006 205.178c5.896-8.014 15.285-13.162 25.877-13.178l0.003-0h542.23c10.204 0 19.878 4.926 25.88 13.178l176.596 242.822h-273.146l-64 128h-272.892l-64-128h-273.146l176.598-242.822zM1088 544v256c0 17.646-14.356 32-32 32h-960c-17.644 0-32-14.354-32-32v-256c0-17.674 14.326-32 32-32h240l64 128h352l64-128h240c17.674 0 32 14.326 32 32z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-c437bada-2ad2","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-c437bada-2ad2" class="gspb_container gspb_container-gsbp-c437bada-2ad2 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-17f64346-0826","textContent":"API Access","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#000000","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-17f64346-0826" class="gspb_text gspb_text-id-gsbp-17f64346-0826 ">API Access</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-13d900f7-327b","textContent":"Create anything you want","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":[0.3]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#73737a","sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-13d900f7-327b" class="gspb_text gspb_text-id-gsbp-13d900f7-327b ">Create anything you want</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-988fbcda-c51a","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[1],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["2.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-988fbcda-c51a" class="gspb_container gspb_container-gsbp-988fbcda-c51a wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-b4facb91-a495","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-b4facb91-a495" class="gspb_container gspb_container-gsbp-b4facb91-a495 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-b8d6eead-205b","type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[10],"right":[10],"bottom":[10],"left":[10]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#ffffff"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#e4e4e7"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"iconBox_icon":{"icon":{"font":"rhicon rhi-comments","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[20],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-b8d6eead-205b" class="gspb_iconBox gspb_iconBox-id-gsbp-b8d6eead-205b wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1152 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1139.8 882.2c-1-0.8-45.2-48.4-75.8-109.8 55-54.2 88-122.2 88-196.4 0-160-153-292.2-352.4-315.8-62.8-115.2-211-196.2-383.6-196.2-229.8 0-416 143.2-416 320 0 74 33 142 88 196.4-30.6 61.4-74.6 109-75.4 109.8-12.6 13.4-16.2 33-8.8 50 7.2 17 24 28 42.4 28 107 0 193.4-40.4 250.4-77.6 18.2 4.2 36.8 7.4 56 9.6 63 115 211 196 383.6 196 41.6 0 81.6-4.8 119.6-13.6 57 37 143.2 77.6 250.4 77.6 18.4 0 35-11 42.4-28 7.2-17 3.8-36.6-8.8-50zM310.8 628l-26.4-6-22.8 14.8c-40.2 26.2-101 56.4-175.4 65 17.6-22.6 40.4-55.2 59-92.8l20.8-41.6-33-32.6c-31.6-31-69-82.4-69-150.8 0-141.2 158-256 352-256s352 114.8 352 256-158 256-352 256c-35.4 0-70.8-4-105.2-12zM890.4 828.8l-22.8-14.8-26.4 6.2c-34.4 8-69.8 12-105.2 12-130.2 0-244-51.8-304.8-128.6 222.6-6.4 400.8-146.8 400.8-319.6 0-19-2.6-37.4-6.6-55.4 150.8 29 262.6 128.8 262.6 247.4 0 68.4-37.4 119.8-69 150.8l-33 32.6 20.6 41.4c18.8 37.8 41.6 70.4 59 92.8-74.2-8.4-135-38.8-175.2-64.8z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-01189163-d889","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-01189163-d889" class="gspb_container gspb_container-gsbp-01189163-d889 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-788451ea-ad2f","textContent":"Live Chat","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#000000","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-788451ea-ad2f" class="gspb_text gspb_text-id-gsbp-788451ea-ad2f ">Live Chat</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-ca8d8950-c932","textContent":"Connect with your customers","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":[0.3]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#73737a","sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-ca8d8950-c932" class="gspb_text gspb_text-id-gsbp-ca8d8950-c932 ">Connect with your customers</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-9ce2f27d-42b3","order":[null,null,null,null],"variableWidth":false,"width":[20,null,null,null],"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"justifyContent":["center",null,null,"center"]},"columnSize":"4","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[0],"right":[0],"bottom":[0],"left":[0]},"unit":["rem","px","px","px"],"locked":false}},"responsive":{"customcss":""}} -->
        <div id="gspb_col-id-gsbp-9ce2f27d-42b3" class="gspb_row__col--4 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-9ce2f27d-42b3"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-e8b0b2fb-5863","shapePosition":"center","iconBox_icon":{"icon":{"font":"rhicon rhi-paper-plane","svg":"\u003csvg class=\u0022zd ld qb ak\u0022 viewBox=\u00220 0 16 172\u0022 fill=\u0022none\u0022 stroke=\u0022currentColor\u0022 xmlns=\u0022http://www.w3.org/2000/svg\u0022\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 11)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 46)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 81)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 116)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 151)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 18)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 53)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 88)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 123)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 158)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 25)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 60)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 95)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 130)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 165)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 32)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 67)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 102)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 137)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 172)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 39)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 74)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 109)\u0022\u003e\u003c/line\u003e\n                                    \u003cline y1=\u0022-0.5\u0022 x2=\u002218.0278\u0022 y2=\u0022-0.5\u0022 transform=\u0022matrix(-0.83205 -0.5547 -0.5547 0.83205 15 144)\u0022\u003e\u003c/line\u003e\n                                \u003c/svg\u003e","image":""},"fill":"#d2d2d3","fillhover":"","type":"svg","iconSize":[170],"strokeColor":"#d2d2d3","rotateZ":0},"responsive":{"customcss":"@media (max-width: 767px) {\n{GREENSHIFT} {\n    max-height: 90px;\n}\n}"},"csstransform":{"rotateZ":[null,null,null,90]}} -->
        <div id="gspb_iconBox-id-gsbp-e8b0b2fb-5863" class="gspb_iconBox gspb_iconBox-id-gsbp-e8b0b2fb-5863 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="zd ld qb ak" viewBox="0 0 16 172" style="width:5rem;height:5rem;margin:10px" fill="none" stroke="currentColor" xmlns="http://www.w3.org/2000/svg">
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 11)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 46)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 81)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 116)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 151)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 18)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 53)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 88)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 123)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 158)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 25)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 60)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 95)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 130)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 165)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 32)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 67)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 102)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 137)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 172)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 39)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 74)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 109)"></line>
                                            <line y1="-0.5" x2="18.0278" y2="-0.5" transform="matrix(-0.83205 -0.5547 -0.5547 0.83205 15 144)"></line>
                                        </svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-88b44583-17e3","width":[40,null,null,null],"columnSize":"4","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"left":[0],"top":[0],"right":[0],"bottom":[0]},"unit":["rem","px","px","px"],"locked":true}}} -->
        <div id="gspb_col-id-gsbp-88b44583-17e3" class="gspb_row__col--4 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-88b44583-17e3"><!-- wp:greenshift-blocks/container {"id":"gsbp-c08165e4-5b9f","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[1],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-c08165e4-5b9f" class="gspb_container gspb_container-gsbp-c08165e4-5b9f wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-77ff0b12-c1a9","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-77ff0b12-c1a9" class="gspb_container gspb_container-gsbp-77ff0b12-c1a9 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-4fb231ec-b8e8","type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[10],"right":[10],"bottom":[10],"left":[10]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#ffffff"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#e4e4e7"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"iconBox_icon":{"icon":{"font":"rhicon rhi-users","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[20],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-4fb231ec-b8e8" class="gspb_iconBox gspb_iconBox-id-gsbp-4fb231ec-b8e8 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1280 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M1088 448c88.4 0 160-71.6 160-160s-71.6-160-160-160-160 71.6-160 160 71.6 160 160 160zM1088 192c53 0 96 43 96 96s-43 96-96 96-96-43-96-96 43-96 96-96zM640 512c123.8 0 224-100.2 224-224s-100.2-224-224-224-224 100.2-224 224 100.2 224 224 224zM640 128c88.2 0 160 71.8 160 160s-71.8 160-160 160-160-71.8-160-160 71.8-160 160-160zM1128 512h-80c-30.4 0-58.6 9.6-82.2 25.8 18.8 12.8 35.8 27.8 50.8 44.8 9.8-4.2 20.4-6.6 31.4-6.6h80c48.4 0 88 43 88 96 0 17.6 14.4 32 32 32s32-14.4 32-32c0-88.2-68.2-160-152-160zM192 448c88.4 0 160-71.6 160-160s-71.6-160-160-160-160 71.6-160 160 71.6 160 160 160zM192 192c53 0 96 43 96 96s-43 96-96 96-96-43-96-96 43-96 96-96zM800.2 552c-66.8 0-83.4 24-160.2 24s-93.4-24-160.2-24c-72.6 0-143.2 32.4-184.6 93.8-24.8 36.8-39.2 81-39.2 128.6v89.6c0 53 43 96 96 96h576c53 0 96-43 96-96v-89.6c0-47.6-14.4-91.8-39.2-128.6-41.4-61.4-112-93.8-184.6-93.8zM960 864c0 17.6-14.4 32-32 32h-576c-17.6 0-32-14.4-32-32v-89.6c0-33.2 9.8-65.4 28.2-92.8 27.6-41 76.8-65.6 131.4-65.6 54.8 0 74.4 24 160.4 24s105.6-24 160.2-24c54.6 0 103.8 24.6 131.4 65.6 18.4 27.4 28.2 59.6 28.2 92.8v89.6zM314.2 537.8c-23.8-16.2-52-25.8-82.2-25.8h-80c-83.8 0-152 71.8-152 160 0 17.6 14.4 32 32 32s32-14.4 32-32c0-53 39.6-96 88-96h80c11 0 21.6 2.4 31.4 6.6 15-17 32.2-32 50.8-44.8z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-80d05418-7d99","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-80d05418-7d99" class="gspb_container gspb_container-gsbp-80d05418-7d99 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-d4c0a6d6-7016","textContent":"Unlimited Accounts","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#000000","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-d4c0a6d6-7016" class="gspb_text gspb_text-id-gsbp-d4c0a6d6-7016 ">Unlimited Accounts</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-c1a3fe59-0bec","textContent":"We don’t limit you create account","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":[0.3]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#73737a","sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-c1a3fe59-0bec" class="gspb_text gspb_text-id-gsbp-c1a3fe59-0bec ">We don’t limit you create account</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-c90b6dc2-5606","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[1],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["2.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-c90b6dc2-5606" class="gspb_container gspb_container-gsbp-c90b6dc2-5606 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-12ad7fb7-3a94","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-12ad7fb7-3a94" class="gspb_container gspb_container-gsbp-12ad7fb7-3a94 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-f87085a1-ccf8","type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[10],"right":[10],"bottom":[10],"left":[10]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#ffffff"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#e4e4e7"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"iconBox_icon":{"icon":{"font":"rhicon rhi-code","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[20],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-f87085a1-ccf8" class="gspb_iconBox gspb_iconBox-id-gsbp-f87085a1-ccf8 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M712.832 798.165l256-256c16.683-16.683 16.683-43.691 0-60.331l-256-256c-16.683-16.683-43.691-16.683-60.331 0s-16.683 43.691 0 60.331l225.835 225.835-225.835 225.835c-16.683 16.683-16.683 43.691 0 60.331s43.691 16.683 60.331 0zM311.168 225.835l-256 256c-16.683 16.683-16.683 43.691 0 60.331l256 256c16.683 16.683 43.691 16.683 60.331 0s16.683-43.691 0-60.331l-225.835-225.835 225.835-225.835c16.683-16.683 16.683-43.691 0-60.331s-43.691-16.683-60.331 0z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-af7c0b50-9040","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-af7c0b50-9040" class="gspb_container gspb_container-gsbp-af7c0b50-9040 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-206aa74a-d938","textContent":"Custom Domain","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#000000","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-206aa74a-d938" class="gspb_text gspb_text-id-gsbp-206aa74a-d938 ">Custom Domain</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-0092d60c-1cf9","textContent":"Add your own domain","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":[0.3]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#73737a","sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-0092d60c-1cf9" class="gspb_text gspb_text-id-gsbp-0092d60c-1cf9 ">Add your own domain</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-b0b97765-9de6","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[1],"alignItems":["center"]},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":["2.5"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-b0b97765-9de6" class="gspb_container gspb_container-gsbp-b0b97765-9de6 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-e509fba2-6642","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":""},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-e509fba2-6642" class="gspb_container gspb_container-gsbp-e509fba2-6642 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/iconbox {"id":"gsbp-a1c180d7-5cd8","type":"boxed","spacing":{"margin":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[10],"right":[10],"bottom":[10],"left":[10]},"unit":["px","px","px","px"],"locked":true}},"shadow":{},"background":{"color":"#ffffff"},"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"all":["solid"]},"size":{"all":[1]},"color":{"all":["#e4e4e7"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"iconBox_icon":{"icon":{"font":"rhicon rhi-paper-plane","svg":"","image":""},"fill":"","fillhover":"","type":"font","iconSize":[20],"strokeColor":"","strokeColorHover":"","strokeWidth":""},"animation":{"duration":700,"easing":"ease","type":""},"responsive":{"customcss":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{}} -->
        <div id="gspb_iconBox-id-gsbp-a1c180d7-5cd8" class="gspb_iconBox gspb_iconBox-id-gsbp-a1c180d7-5cd8 wp-block-greenshift-blocks-iconbox"><div class="gspb_iconBox__wrapper" style="display:inline-flex"><svg class="" style="display:inline-block;vertical-align:middle" width="72" height="72" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M928 8.6l-896 516.8c-46 26.6-41.4 94.4 7.6 114.6l280.4 116v204c0 60.4 75.6 86.6 113.4 40.6l121.4-147.6 252.8 104.4c38.2 15.8 81.4-8.4 87.6-49.4l128-834.2c8.2-53.4-49.2-91.8-95.2-65.2zM384 960v-177.6l109 45-109 132.6zM832 898.2l-412.4-170.4 399-471.6c9.6-11.2-5.8-26.4-17-16.8l-510.6 435.2-227-93.6 896-517-128 834.2z"></path></svg></div></div>
        <!-- /wp:greenshift-blocks/iconbox --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-bc6e2ce1-ab82","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-bc6e2ce1-ab82" class="gspb_container gspb_container-gsbp-bc6e2ce1-ab82 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-eba89cc1-9a74","textContent":"Share Information","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#000000","sizeUnit":"rem","size":[1.2],"lineHeightUnit":["rem"],"line_height":[1.8],"customweight":"custom","customweightnumber":700},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-eba89cc1-9a74" class="gspb_text gspb_text-id-gsbp-eba89cc1-9a74 ">Share Information</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-0c156885-1a3e","textContent":"Easily share your message","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":[0.3]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{"textShadow":{},"color":"#73737a","sizeUnit":"rem","size":[1],"lineHeightUnit":["rem"],"line_height":[1.3],"customweight":null,"customweightnumber":400},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-0c156885-1a3e" class="gspb_text gspb_text-id-gsbp-0c156885-1a3e ">Easily share your message</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --></div>
        <!-- /wp:greenshift-blocks/row -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-d2aa1e33-e107","textContent":"All our features are available to all users","spacing":{"margin":{"values":{"top":["2.2"],"right":[null],"bottom":[null],"left":[null]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"alignment":["center"],"textShadow":{},"lineHeightUnit":["rem"],"line_height":[1],"color":"#52525b","sizeUnit":"rem","size":[1],"customweight":"custom","customweightnumber":500}} -->
        <div id="gspb_text-id-gsbp-d2aa1e33-e107" class="gspb_text gspb_text-id-gsbp-d2aa1e33-e107 ">All our features are available to all users</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-2acc2dd5-f593","flexbox":{"type":"flexbox","flexDirection":["row"],"columngapUnit":["rem"],"columngap":[0.7]},"spacing":{"margin":{"values":{"top":["3.2"]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_container-id-gsbp-2acc2dd5-f593" class="gspb_container gspb_container-gsbp-2acc2dd5-f593 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-23ad821c-72b7","textContent":"$","typography":{"textShadow":{},"color":"#a1a1aa","customweight":"custom","customweightnumber":700,"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1.3],"line_height":[null]}} -->
        <div id="gspb_text-id-gsbp-23ad821c-72b7" class="gspb_text gspb_text-id-gsbp-23ad821c-72b7 ">$</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-26c0de3c-fc3d","textContent":"99","typography":{"textShadow":{},"customweight":"bold","customweightnumber":700,"sizeUnit":"px","size":[70],"color":"#18181b","line_height":[70]}} -->
        <div id="gspb_text-id-gsbp-26c0de3c-fc3d" class="gspb_text gspb_text-id-gsbp-26c0de3c-fc3d ">99</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-9fa64a08-7c28","textContent":"/year","typography":{"textShadow":{},"color":"#a1a1aa","customweight":"custom","customweightnumber":700,"sizeUnit":"rem","lineHeightUnit":["rem"],"size":[1.3],"line_height":[null]}} -->
        <div id="gspb_text-id-gsbp-9fa64a08-7c28" class="gspb_text gspb_text-id-gsbp-9fa64a08-7c28 ">/year</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-d828dcc3-622f","buttonContent":"Get started for $99 only","align":"flex-start","spacing":{"margin":{"values":{"top":[20]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[20],"bottom":[20],"right":[30],"left":[30]},"unit":["px","px","px","px"],"locked":false}},"iconSpacing":{"margin":{"values":{"left":[null]},"unit":["rem","px","px","px"],"locked":true},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":["10"],"topRight":["10"],"bottomRight":["10"],"bottomLeft":["10"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"blockWidth":{"customWidth":{"value":[100],"unit":["%","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom"},"typography":{"textShadow":{},"size":[18]},"animation":{"duration":700,"easing":"ease","usegsap":false,"y":30,"rx":null,"s":0.5,"o":"0","type":""},"responsive":{"hideOnDesktop":false,"hideOnTablet":false,"hideOnMobile":false,"hideOnLandscape":false,"customcss":""},"csstransform":{"timebg":"","time":"","timeshadow":"","timeborder":"","timeopacity":"","timetransform":"","timecolor":"","timefilter":""},"buttonLink":"https://greenshiftwp.com/","linkNewWindow":true,"enableIcon":false,"iconRight":false,"iconBox_icon":{"icon":{"font":"rhicon rhi-arrow-right","svg":"","image":""},"fill":"#ffffff","fillhover":"#ffffff","type":"font"},"enableblockIcon":false} -->
        <div id="gspb_button-id-gsbp-d828dcc3-622f" class="gspb_button_wrapper gspb_button-id-gsbp-d828dcc3-622f wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" href="https://greenshiftwp.com/" target="_blank" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Get started for $99 only</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-3a52d43b-f4e5","textContent":"30 days money back guarantee","spacing":{"margin":{"values":{"top":[0.5]},"unit":["rem","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"alignment":["center"],"textShadow":{},"lineHeightUnit":["rem"],"line_height":[null],"color":"#73737a","sizeUnit":"rem","size":[1],"customweight":"custom","customweightnumber":400}} -->
        <div id="gspb_text-id-gsbp-3a52d43b-f4e5" class="gspb_text gspb_text-id-gsbp-3a52d43b-f4e5 ">30 days money back guarantee</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/imagecssgrid',
        array(
            'title'       => __('Image Grid with Headline', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/image', 'greenshift-blocks/container'),
            'keywords' => array('grid', 'image'),
            'description' => _x('Image Grid with Headline', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-343dd1ec-bf98","align":"full","width":[750,null,null,null],"displayStyles":false} -->
        <div id="gspb_row-id-gsbp-343dd1ec-bf98" class="gspb_row gspb_row-id-gsbp-343dd1ec-bf98 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-343dd1ec-bf98"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-8c88d67e-ba9d"} -->
        <div id="gspb_col-id-gsbp-8c88d67e-ba9d" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-8c88d67e-ba9d"><!-- wp:greenshift-blocks/container {"id":"gsbp-66016fc9-5dc3","width":[null,null,null,null],"widthUnit":["px","%","%","%"],"flexbox":{"type":"grid","enable":false,"gridcolumns":[2,null,null,1],"columngap":[50],"rowgap":[50]}} -->
        <div id="gspb_container-id-gsbp-66016fc9-5dc3" class="gspb_container gspb_container-gsbp-66016fc9-5dc3 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-9de9c87f-6e43","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"rowStart":["1"],"rowEnd":["2"],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-9de9c87f-6e43" class="gspb_container gspb_container-gsbp-9de9c87f-6e43 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/heading {"id":"gsbp-ced1361c-7fd7","animatedText":["creativity","imagination","inspiration","passion"],"headingContent":"My headline text","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"shadow":{},"typographyanimated":{},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"headingSeparator":false,"headingSepSpacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"headingSepAfterSpacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"spacingBlock":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"headingSepWidth":[50,null,null,null],"headingSepWidthUnit":["px","px","px","px"],"spacingsubTitle":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typographysubTitle":{},"dynamictext":{}} -->
        <h2 id="gspb_heading-id-gsbp-ced1361c-7fd7" class="gspb_heading gspb_heading-id-gsbp-ced1361c-7fd7 ">My headline text</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-6e5a14e0-973d","textContent":"My lorem ipsum text with several lines and other lorem ipsum text with several lines","background":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"animation":{"duration":700,"easing":"ease","type":""},"position":{"positionType":["","","",""],"positions":{"values":{}}},"csstransform":{},"responsive":{},"dynamictext":{}} -->
        <div id="gspb_text-id-gsbp-6e5a14e0-973d" class="gspb_text gspb_text-id-gsbp-6e5a14e0-973d ">My lorem ipsum text with several lines and other lorem ipsum text with several lines</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-56cd4b5a-b8be","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"rowStart":["1",null,null,"2"],"rowEnd":["3"],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-56cd4b5a-b8be" class="gspb_container gspb_container-gsbp-56cd4b5a-b8be wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-e699fe8a-33f2","mediaurl":"https://api.lorem.space/image/game?w=330\u0026h=400","alt":""} -->
        <div id="gspb_image-id-gsbp-e699fe8a-33f2" class="gspb_image gspb_image-id-gsbp-e699fe8a-33f2 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/game?w=330&amp;h=400" data-src="" alt="" width="" height=""/></div>
        <!-- /wp:greenshift-blocks/image --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-9d2ae30d-4658","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[400,null,null,null],"rowspan":[],"columnspan":[],"rowStart":["2",null,null,"3"],"rowEnd":["4"],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-9d2ae30d-4658" class="gspb_container gspb_container-gsbp-9d2ae30d-4658 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-0e045f48-9041","mediaurl":"https://api.lorem.space/image/furniture?w=330\u0026h=400","alt":""} -->
        <div id="gspb_image-id-gsbp-0e045f48-9041" class="gspb_image gspb_image-id-gsbp-0e045f48-9041 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/furniture?w=330&amp;h=400" data-src="" alt="" width="" height=""/></div>
        <!-- /wp:greenshift-blocks/image --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-46e23c4d-cd96","calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[400,null,null,null],"rowspan":[],"columnspan":[],"rowStart":["3",null,null,"4"],"rowEnd":["5"],"order":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"animation":{"duration":700,"easing":"ease","type":""},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-46e23c4d-cd96" class="gspb_container gspb_container-gsbp-46e23c4d-cd96 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-100807cb-6061","mediaurl":"https://api.lorem.space/image/shoes?w=330\u0026h=400","alt":""} -->
        <div id="gspb_image-id-gsbp-100807cb-6061" class="gspb_image gspb_image-id-gsbp-100807cb-6061 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/shoes?w=330&amp;h=400" data-src="" alt="" width="" height=""/></div>
        <!-- /wp:greenshift-blocks/image --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    register_block_pattern(
        'greenshift/ctaproductpanel',
        array(
            'title'       => __('CTA panel with button', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/button'),
            'keywords' => array('cta', 'features', 'product'),
            'description' => _x('CTA block with button', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-58acf672-8642","inlineCssStyles":null,"align":"full","width":[1100,null,null,null],"displayStyles":false,"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[80],"bottom":[80]},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_row-id-gsbp-58acf672-8642" class="gspb_row gspb_row-id-gsbp-58acf672-8642 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-58acf672-8642"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-db080cec-f94c","inlineCssStyles":null,"width":[null],"widthUnit":["%"],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"type":"","flexDirection":["column"],"alignItems":["center"],"shrinkzero":true}} -->
        <div id="gspb_col-id-gsbp-db080cec-f94c" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-db080cec-f94c"><!-- wp:greenshift-blocks/heading {"id":"gsbp-363b7d12-d692","inlineCssStyles":null,"headingContent":"All features for one price. Try Greenshift for free!","spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"marginAuto":[true]},"typography":{"textShadow":{},"alignment":["center"],"size":[48,36,null,30],"useFluid":false,"usePreset":false,"color":"#18181b","line_height":[54]},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom","maxWidth":["672px"]}} -->
        <h2 id="gspb_heading-id-gsbp-363b7d12-d692" class="gspb_heading gspb_heading-id-gsbp-363b7d12-d692 ">All features for one price. Try Greenshift for free!</h2>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/row {"id":"gsbp-ba46b6c7-cdd9","inlineCssStyles":null,"rowLayout":"5","brp_rowLayout":[null,"30",null],"rowType":"full-width","width":[1200,null,null,null],"minHeight":[null,null,null,null],"columnPosition":"","columnJustify":"","displayStyles":false,"background":{"color":"#18181b"},"overlay":{},"border":{"borderRadius":{"values":{"topLeft":["16"],"topRight":["16"],"bottomRight":["16"],"bottomLeft":["16"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{"top":[64,null,null,32]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[56,32],"bottom":[56,32],"right":[64,32,null,32],"left":[64,32,null,32]},"unit":["px","px","px","px"],"locked":false},"marginAuto":[0]},"responsive":{"customcss":""},"gutterGap":[null,null,null,null],"columnGap":[null,null,null,null],"rowGap":[null,null,null,null],"customWrap":["",null,null,null]} -->
        <div id="gspb_row-id-gsbp-ba46b6c7-cdd9" class="gspb_row gspb_row-id-gsbp-ba46b6c7-cdd9 wp-block-greenshift-blocks-row gspb_row-id-gsbp-ba46b6c7-cdd9"><!-- wp:greenshift-blocks/row-column {"id":"gsbp-1f2fcb00-8e09","inlineCssStyles":null,"width":[null,70],"gutterGap":[null,null,null,null],"flexbox":{"enable":false,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row",null,null,"column"],"columngap":[96,48],"type":""},"columnSize":"8","brp_columnSize":[null,"12",null],"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[60,null,0],"bottom":[null],"left":[null]},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-1f2fcb00-8e09" class="gspb_row__col--8 wp-block-greenshift-blocks-row-column  gspb_row__col--sm-12 gspb_col-id-gsbp-1f2fcb00-8e09"><!-- wp:greenshift-blocks/iconlist {"id":"gsbp-786af1fd-b329","inlineCssStyles":null,"iconsList":[{"icon":{"icon":{"font":"rhicon rhi-check","svg":"","image":""},"fill":"#ffffff","fillhover":"","iconSize":["16px",null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Unlimited members"},{"icon":{"icon":{"font":"rhicon rhi-check","svg":"","image":""},"fill":"#ffffff","fillhover":"","iconSize":["16px",null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"3 admin accounts"},{"icon":{"icon":{"font":"rhicon rhi-check","svg":"","image":""},"fill":"#ffffff","fillhover":"","iconSize":["16px",null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"100GB Storage"},{"icon":{"icon":{"font":"rhicon rhi-check","svg":"","image":""},"fill":"#ffffff","fillhover":"","iconSize":["16px",null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Custom domain"},{"icon":{"icon":{"font":"rhicon rhi-check","svg":"","image":""},"fill":"#ffffff","fillhover":"","iconSize":["16px",null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"Bulk importer"},{"icon":{"icon":{"font":"rhicon rhi-check","svg":"","image":""},"fill":"#ffffff","fillhover":"","iconSize":["16px",null,null,null],"rotateY":false,"rotateX":false,"type":"font"},"content":"API access"}],"textTag":"","colorGlobal":"currentColor","spacingList":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[10],"bottom":[null]},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"color":"#ffffff","customweight":null,"size":[17]},"flexcolumns":true,"flexbox":{"type":"grid","gridcolumns":[2],"columngap":[50]}} -->
        <div id="gspb_iconsList-id-gsbp-786af1fd-b329" class="gspb_iconsList gspb_iconsList-id-gsbp-786af1fd-b329 wp-block-greenshift-blocks-iconlist"><div class="gspb_iconsList__item" data-id="0"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M871.696 166.932l-526.088 526.088-193.304-193.304c-9.372-9.372-24.568-9.372-33.942 0l-56.568 56.568c-9.372 9.372-9.372 24.568 0 33.942l266.842 266.842c9.372 9.372 24.568 9.372 33.942 0l599.626-599.626c9.372-9.372 9.372-24.568 0-33.942l-56.568-56.568c-9.372-9.372-24.568-9.372-33.94 0z"></path></svg><span class="gspb_iconsList__item__text">Unlimited members</span></div><div class="gspb_iconsList__item" data-id="1"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M871.696 166.932l-526.088 526.088-193.304-193.304c-9.372-9.372-24.568-9.372-33.942 0l-56.568 56.568c-9.372 9.372-9.372 24.568 0 33.942l266.842 266.842c9.372 9.372 24.568 9.372 33.942 0l599.626-599.626c9.372-9.372 9.372-24.568 0-33.942l-56.568-56.568c-9.372-9.372-24.568-9.372-33.94 0z"></path></svg><span class="gspb_iconsList__item__text">3 admin accounts</span></div><div class="gspb_iconsList__item" data-id="2"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M871.696 166.932l-526.088 526.088-193.304-193.304c-9.372-9.372-24.568-9.372-33.942 0l-56.568 56.568c-9.372 9.372-9.372 24.568 0 33.942l266.842 266.842c9.372 9.372 24.568 9.372 33.942 0l599.626-599.626c9.372-9.372 9.372-24.568 0-33.942l-56.568-56.568c-9.372-9.372-24.568-9.372-33.94 0z"></path></svg><span class="gspb_iconsList__item__text">100GB Storage</span></div><div class="gspb_iconsList__item" data-id="3"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M871.696 166.932l-526.088 526.088-193.304-193.304c-9.372-9.372-24.568-9.372-33.942 0l-56.568 56.568c-9.372 9.372-9.372 24.568 0 33.942l266.842 266.842c9.372 9.372 24.568 9.372 33.942 0l599.626-599.626c9.372-9.372 9.372-24.568 0-33.942l-56.568-56.568c-9.372-9.372-24.568-9.372-33.94 0z"></path></svg><span class="gspb_iconsList__item__text">Custom domain</span></div><div class="gspb_iconsList__item" data-id="4"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M871.696 166.932l-526.088 526.088-193.304-193.304c-9.372-9.372-24.568-9.372-33.942 0l-56.568 56.568c-9.372 9.372-9.372 24.568 0 33.942l266.842 266.842c9.372 9.372 24.568 9.372 33.942 0l599.626-599.626c9.372-9.372 9.372-24.568 0-33.942l-56.568-56.568c-9.372-9.372-24.568-9.372-33.94 0z"></path></svg><span class="gspb_iconsList__item__text">Bulk importer</span></div><div class="gspb_iconsList__item" data-id="5"><svg class="" style="display:inline-block;vertical-align:middle" width="18" height="18" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path style="fill:#565D66" d="M871.696 166.932l-526.088 526.088-193.304-193.304c-9.372-9.372-24.568-9.372-33.942 0l-56.568 56.568c-9.372 9.372-9.372 24.568 0 33.942l266.842 266.842c9.372 9.372 24.568 9.372 33.942 0l599.626-599.626c9.372-9.372 9.372-24.568 0-33.942l-56.568-56.568c-9.372-9.372-24.568-9.372-33.94 0z"></path></svg><span class="gspb_iconsList__item__text">API access</span></div></div>
        <!-- /wp:greenshift-blocks/iconlist --></div>
        <!-- /wp:greenshift-blocks/row-column -->
        
        <!-- wp:greenshift-blocks/row-column {"id":"gsbp-d606e6e8-a6e9","inlineCssStyles":null,"width":[null,30],"columnSize":"4","brp_columnSize":[null,"12",null],"border":{"borderRadius":{"values":{},"unit":"px","locked":true},"style":{"left":["solid"]},"size":{"left":[1]},"color":{"left":["#606060",null,"#ffffff00"]},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[null],"right":[null],"bottom":[null],"left":[60,null,0]},"unit":["px","px","px","px"],"locked":false}}} -->
        <div id="gspb_col-id-gsbp-d606e6e8-a6e9" class="gspb_row__col--4 wp-block-greenshift-blocks-row-column  gspb_row__col--sm-12 gspb_col-id-gsbp-d606e6e8-a6e9"><!-- wp:greenshift-blocks/container {"id":"gsbp-4b9a5722-9898","inlineCssStyles":null,"flexbox":{"enable":true,"marginUnit":["px","px","px","px"],"marginLock":false,"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginLeft":[null,null,null,null],"marginRight":[null,null,null,null],"flexDirection":["row"],"alignItems":["flex-end"],"columngap":[5]}} -->
        <div id="gspb_container-id-gsbp-4b9a5722-9898" class="gspb_container gspb_container-gsbp-4b9a5722-9898 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-1f8dfaf4-8d30","inlineCssStyles":null,"textContent":"$19","typography":{"textShadow":{},"color":"#ffffff","size":[50],"customweight":"bold","line_height":[50]}} -->
        <div id="gspb_text-id-gsbp-1f8dfaf4-8d30" class="gspb_text gspb_text-id-gsbp-1f8dfaf4-8d30 ">$19</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-000a4cee-a06e","inlineCssStyles":null,"textContent":"/month","typography":{"textShadow":{},"size":[18],"customweight":"bold","customweightnumber":400,"color":"#a1a1aa","line_height":[null]}} -->
        <div id="gspb_text-id-gsbp-000a4cee-a06e" class="gspb_text gspb_text-id-gsbp-000a4cee-a06e ">/month</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-b4b012ce-0a79","inlineCssStyles":null,"buttonContent":"Download Now!","background":{"color":"#ffffff"},"spacing":{"margin":{"values":{"top":[20]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[18],"right":[30],"left":[30],"bottom":[18]},"unit":["px","px","px","px"],"locked":false}},"border":{"borderRadius":{"values":{"topLeft":["12"],"topRight":["12"],"bottomRight":["12"],"bottomLeft":["12"]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"blockWidth":{"customWidth":{"value":["100%"],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom"},"typography":{"textShadow":{},"line_height":[null],"alignment":["center"],"customweight":"bold","color":"#18181b"}} -->
        <div id="gspb_button-id-gsbp-b4b012ce-0a79" class="gspb_button_wrapper gspb_button-id-gsbp-b4b012ce-0a79 wp-block-greenshift-blocks-button"><a class="gspb-buttonbox" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Download Now!</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button --></div>
        <!-- /wp:greenshift-blocks/row-column --></div>
        <!-- /wp:greenshift-blocks/row -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-b1734396-0503","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["px","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"minHeightUnit":["px","px","px","px"],"flexbox":{"type":"flexbox","flexDirection":["row",null,null,"column"],"marginRight":[null,null,null,null],"shrinkzero":false,"marginLeft":[null,null,null,null],"marginTop":[null,null,null,null],"marginBottom":[null,null,null,null],"marginUnit":["px","px","px","px"],"marginLock":true,"columngap":[48],"rowgap":[null,null,null,24],"flexWrap":["nowrap"]},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{"top":[64,null,null,48]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"left":[0]},"unit":["px","px","px","px"],"locked":false},"marginAuto":[true]},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{},"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom","maxWidth":["672px"]}} -->
        <div id="gspb_container-id-gsbp-b1734396-0503" class="gspb_container gspb_container-gsbp-b1734396-0503 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/container {"id":"gsbp-4ad48fda-7cbf","inlineCssStyles":null,"blockWidth":{"customWidth":{"value":[],"unit":["px","px","px","px"]},"customHeight":{"value":[],"unit":["px","px","px","px"]},"widthType":"custom","heightType":"","minWidth":["125px"]}} -->
        <div id="gspb_container-id-gsbp-4ad48fda-7cbf" class="gspb_container gspb_container-gsbp-4ad48fda-7cbf wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/image {"id":"gsbp-8fbf5b43-a1b3","inlineCssStyles":null,"align":[null,null,null,"center"],"scale":["cover"],"width":["custom",null,null,null],"height":["custom",null,null,null],"customWidth":[125,null,null,null],"customHeight":[125,null,null,null],"border":{"borderRadius":{"values":{"topLeft":[99],"topRight":[99],"bottomRight":[99],"bottomLeft":[99]},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"mediaurl":"https://api.lorem.space/image/face?w=150\u0026h=150","alt":""} -->
        <div id="gspb_image-id-gsbp-8fbf5b43-a1b3" class="gspb_image gspb_image-id-gsbp-8fbf5b43-a1b3 wp-block-greenshift-blocks-image"><img src="https://api.lorem.space/image/face?w=150&amp;h=150" data-src="" alt="" width="125" height="125"/></div>
        <!-- /wp:greenshift-blocks/image --></div>
        <!-- /wp:greenshift-blocks/container -->
        
        <!-- wp:greenshift-blocks/container {"id":"gsbp-5fa8398b-d156","inlineCssStyles":null,"calcOperator":["-","-","-","-"],"secondWidth":[null,null,null,null],"secondWidthUnit":["px","px","px","px"],"width":[null,null,null,null],"widthUnit":["%","%","%","%"],"minHeight":[null,null,null,null],"rowspan":[],"columnspan":[],"minHeightUnit":["px","px","px","px"],"flexbox":{},"background":{},"overlay":{},"border":{"borderRadius":{"values":{},"unit":"px","locked":true}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"shadow":{},"typography":{},"position":{"positionType":["","","",""],"positions":{"values":{}}},"shapeDivider":{"topShape":{},"bottomShape":{}},"responsive":{},"csstransform":{},"carousel":{"arrowPos":[null,null,null,null],"arrowSize":[null,null,null,null],"arrowPosV":[null,null,null,null]},"imageBorder":{"borderRadius":{"values":{},"unit":"px","locked":true}},"imageShadow":{}} -->
        <div id="gspb_container-id-gsbp-5fa8398b-d156" class="gspb_container gspb_container-gsbp-5fa8398b-d156 wp-block-greenshift-blocks-container"><!-- wp:greenshift-blocks/text {"id":"gsbp-88b038c1-585d","inlineCssStyles":null,"textContent":"“You made it so simple. My new site is so much faster and easier to work with than my old site. I just choose the page, make the change.”","typography":{"textShadow":{},"size":[18],"color":"#18181b","alignment":[null,null,null,"center"],"fontstyle":"italic"}} -->
        <div id="gspb_text-id-gsbp-88b038c1-585d" class="gspb_text gspb_text-id-gsbp-88b038c1-585d ">“You made it so simple. My new site is so much faster and easier to work with than my old site. I just choose the page, make the change.”</div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-ef98c259-c792","inlineCssStyles":null,"textContent":"\u003cstrong\u003eJohn Doe\u003c/strong\u003e","spacing":{"margin":{"values":{"top":[20]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false}},"typography":{"textShadow":{},"size":[18],"color":"#18181b","alignment":[null,null,null,"center"]}} -->
        <div id="gspb_text-id-gsbp-ef98c259-c792" class="gspb_text gspb_text-id-gsbp-ef98c259-c792 "><strong>John Doe</strong></div>
        <!-- /wp:greenshift-blocks/text -->
        
        <!-- wp:greenshift-blocks/text {"id":"gsbp-d4745593-06c6","inlineCssStyles":null,"textContent":"Founder, Greenshift","background":{"overlayOpacity":50},"typography":{"textShadow":{},"size":[15],"color":"#18181b","alignment":[null,null,null,"center"]}} -->
        <div id="gspb_text-id-gsbp-d4745593-06c6" class="gspb_text gspb_text-id-gsbp-d4745593-06c6 ">Founder, Greenshift</div>
        <!-- /wp:greenshift-blocks/text --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/container --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );


    register_block_pattern(
        'greenshift/bannercta',
        array(
            'title'       => __('CTA banner block', 'greenshift-animation-and-page-builder-blocks'),
            'categories' => array('greenshiftwireframes'),
            'blockTypes'    => array('greenshift-blocks/row', 'greenshift-blocks/button'),
            'keywords' => array('cta', 'features', 'banner'),
            'description' => _x('Block with CTA', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
            'content'     => '<!-- wp:greenshift-blocks/row {"id":"gsbp-419f1ba8-cac7","align":"full","width":[1230,null,null,null],"displayStyles":false,"animation":{"duration":800,"easing":"ease-out-quart","type":"fade-up"},"spacing":{"margin":{"values":{"top":[0],"bottom":[40]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"overflow":[null,null,null,null]}} -->
        <div id="gspb_row-id-gsbp-419f1ba8-cac7" class="gspb_row gspb_row-id-gsbp-419f1ba8-cac7 wp-block-greenshift-blocks-row alignfull gspb_row-id-gsbp-419f1ba8-cac7" data-aos="fade-up" data-aos-easing="ease-out-quart" data-aos-duration="800"><div class="gspb_row__content"> <!-- wp:greenshift-blocks/row-column {"id":"gsbp-bc6cfe6d-16ff","background":{"backgroundState":"Classic","backgroundHoverState":"Classic","color":"rgba(118, 53, 243, 1)"},"border":{"borderRadius":{"values":{"topLeft":15,"topRight":15,"bottomRight":15,"bottomLeft":15},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"bottom":[50],"top":[50]},"unit":["px","px","px","px"],"locked":false},"overflow":[null,null,null,null]}} -->
        <div id="gspb_col-id-gsbp-bc6cfe6d-16ff" class="gspb_row__col--12 wp-block-greenshift-blocks-row-column  gspb_col-id-gsbp-bc6cfe6d-16ff"><!-- wp:greenshift-blocks/heading {"id":"gsbp-a59dcab1-2ab8","headingTag":"div","headingContent":"\u003cmeta charset=\u0022utf-8\u0022\u003eWE CREATED SPECIAL SITE WHERE YOU CAN GET","spacing":{"margin":{"values":{"bottom":[30]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"overflow":[null,null,null,null]},"typography":{"colorState":"Classic","sizeUnit":"px","lineHeightUnit":["px","px","px","px"],"textShadow":{},"customweight":"bold","color":"rgba(255, 255, 255, 1)","aligment":"center"},"animation":{"duration":800,"easing":"ease-out-quart","type":"fade-up"},"numberCircle":"1"} -->
        <div id="gspb_heading-id-gsbp-a59dcab1-2ab8" class="gspb_heading gspb_heading-id-gsbp-a59dcab1-2ab8 " data-aos="fade-up" data-aos-easing="ease-out-quart" data-aos-duration="800"><meta charset="utf-8">WE CREATED SPECIAL SITE WHERE YOU CAN GET</div>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/heading {"id":"gsbp-38700a2c-7e1f","headingTag":"div","headingContent":"\u003cmeta charset=\u0022utf-8\u0022\u003e\u003cstrong\u003eGet in Touch, and let Us\u003c/strong\u003e\u003cbr\u003eKnow how we can help","spacing":{"margin":{"values":{"bottom":[30]},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{},"unit":["px","px","px","px"],"locked":false},"overflow":[null,null,null,null]},"typography":{"colorState":"Classic","sizeUnit":"px","lineHeightUnit":["px","px","px","px"],"textShadow":{},"size":[40],"line_height":[50],"usePreset":false,"color":"rgba(255, 255, 255, 1)","aligment":"center"},"animation":{"duration":800,"easing":"ease-out-quart","type":"flip-up","delay":200},"numberCircle":"1"} -->
        <div id="gspb_heading-id-gsbp-38700a2c-7e1f" class="gspb_heading gspb_heading-id-gsbp-38700a2c-7e1f " data-aos="flip-up" data-aos-delay="200" data-aos-easing="ease-out-quart" data-aos-duration="800"><meta charset="utf-8"><strong>Get in Touch, and let Us</strong><br>Know how we can help</div>
        <!-- /wp:greenshift-blocks/heading -->
        
        <!-- wp:greenshift-blocks/button {"id":"gsbp-e1350e2a-3160","buttonContent":"Contact Us","align":"center","background":{"backgroundState":"Classic","backgroundHoverState":"Classic","color":"rgba(0, 208, 132, 1)"},"spacing":{"margin":{"values":{},"unit":["px","px","px","px"],"locked":false},"padding":{"values":{"top":[18],"bottom":[18]},"unit":["px","px","px","px"],"locked":false},"overflow":[null,null,null,null]},"border":{"borderRadius":{"values":{"topLeft":6,"topRight":6,"bottomRight":6,"bottomLeft":6},"unit":"px","locked":true},"style":{},"size":{},"color":{},"styleHover":{},"sizeHover":{},"colorHover":{}},"typography":{"colorState":"Classic","sizeUnit":"px","lineHeightUnit":["px","px","px","px"],"textShadow":{},"size":[19]},"animation":{"duration":700,"easing":"ease","type":"fade-up","delay":300},"buttonLink":"#","className":"act-rehub-login-popup"} -->
        <div id="gspb_button-id-gsbp-e1350e2a-3160" class="gspb_button_wrapper gspb_button-id-gsbp-e1350e2a-3160 wp-block-greenshift-blocks-button act-rehub-login-popup"><a class="gspb-buttonbox" data-aos="fade-up" data-aos-delay="300" data-aos-easing="ease" data-aos-duration="700" href="#" rel="noopener"><span class="gspb-buttonbox-textwrap"><span class="gspb-buttonbox-text"><span class="gspb-buttonbox-title">Contact Us</span></span></span></a></div>
        <!-- /wp:greenshift-blocks/button --></div>
        <!-- /wp:greenshift-blocks/row-column --> </div></div>
        <!-- /wp:greenshift-blocks/row -->',
        )
    );

    // register_block_pattern(
    //     'greenshift/herocta',
    //     array(
    //         'title'       => __( 'Hero block with CTA', 'greenshift-animation-and-page-builder-blocks'),
    //         'categories' => array('greenshiftwireframes'),
    //         'blockTypes'    => array( 'greenshift-blocks/row', 'greenshift-blocks/container' ),
    // 		'keywords' => array('cta', 'features'),
    // 		'description' => _x( 'Hero block with CTA', 'Block pattern description', 'greenshift-animation-and-page-builder-blocks'),
    //         'content'     => '',
    //     )
    // );
}
add_action('init', 'greenshift_plugin_register_my_pattern_categories');
