/*!
  * Tempus Dominus v6.0.0-beta5.1 (https://getdatepicker.com/)
  * Copyright 2013-2022 Jonathan Peterson
  * Licensed under MIT (https://github.com/Eonasdan/tempus-dominus/blob/master/LICENSE)
  */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@popperjs/core")):"function"==typeof define&&define.amd?define(["exports","@popperjs/core"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).tempusDominus={},t.Popper)}(this,(function(t,e){"use strict";var s;t.Unit=void 0,(s=t.Unit||(t.Unit={})).seconds="seconds",s.minutes="minutes",s.hours="hours",s.date="date",s.month="month",s.year="year";const i={month:"2-digit",day:"2-digit",year:"numeric",hour:"2-digit",minute:"2-digit",second:"2-digit",hour12:!0},o={hour:"2-digit",hour12:!1},n=t=>{switch(t){case"date":return{dateStyle:"short"};case"month":return{month:"numeric",year:"numeric"};case"year":return{year:"numeric"}}};class a extends Date{constructor(){super(...arguments),this.locale="default",this.nonLeapLadder=[0,31,59,90,120,151,181,212,243,273,304,334],this.leapLadder=[0,31,60,91,121,152,182,213,244,274,305,335]}setLocale(t){return this.locale=t,this}static convert(t,e="default"){if(!t)throw new Error("A date is required");return new a(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds()).setLocale(e)}get clone(){return new a(this.year,this.month,this.date,this.hours,this.minutes,this.seconds,this.getMilliseconds()).setLocale(this.locale)}startOf(e,s=0){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);switch(e){case"seconds":this.setMilliseconds(0);break;case"minutes":this.setSeconds(0,0);break;case"hours":this.setMinutes(0,0,0);break;case"date":this.setHours(0,0,0,0);break;case"weekDay":if(this.startOf(t.Unit.date),this.weekDay===s)break;let e=this.weekDay;0!==s&&0===this.weekDay&&(e=8-s),this.manipulate(s-e,t.Unit.date);break;case"month":this.startOf(t.Unit.date),this.setDate(1);break;case"year":this.startOf(t.Unit.date),this.setMonth(0,1)}return this}endOf(e,s=0){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);switch(e){case"seconds":this.setMilliseconds(999);break;case"minutes":this.setSeconds(59,999);break;case"hours":this.setMinutes(59,59,999);break;case"date":this.setHours(23,59,59,999);break;case"weekDay":this.endOf(t.Unit.date),this.manipulate(6+s-this.weekDay,t.Unit.date);break;case"month":this.endOf(t.Unit.date),this.manipulate(1,t.Unit.month),this.setDate(0);break;case"year":this.endOf(t.Unit.date),this.manipulate(1,t.Unit.year),this.setDate(0)}return this}manipulate(t,e){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this[e]+=t,this}format(t,e=this.locale){return new Intl.DateTimeFormat(e,t).format(this)}isBefore(t,e){if(!e)return this.valueOf()<t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this.clone.startOf(e).valueOf()<t.clone.startOf(e).valueOf()}isAfter(t,e){if(!e)return this.valueOf()>t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this.clone.startOf(e).valueOf()>t.clone.startOf(e).valueOf()}isSame(t,e){if(!e)return this.valueOf()===t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return t=a.convert(t),this.clone.startOf(e).valueOf()===t.startOf(e).valueOf()}isBetween(t,e,s,i="()"){if(s&&void 0===this[s])throw new Error(`Unit '${s}' is not valid`);const o="("===i[0],n=")"===i[1];return(o?this.isAfter(t,s):!this.isBefore(t,s))&&(n?this.isBefore(e,s):!this.isAfter(e,s))||(o?this.isBefore(t,s):!this.isAfter(t,s))&&(n?this.isAfter(e,s):!this.isBefore(e,s))}parts(t=this.locale,e={dateStyle:"full",timeStyle:"long"}){const s={};return new Intl.DateTimeFormat(t,e).formatToParts(this).filter((t=>"literal"!==t.type)).forEach((t=>s[t.type]=t.value)),s}get seconds(){return this.getSeconds()}set seconds(t){this.setSeconds(t)}get secondsFormatted(){return this.parts(void 0,i).second}get minutes(){return this.getMinutes()}set minutes(t){this.setMinutes(t)}get minutesFormatted(){return this.parts(void 0,i).minute}get hours(){return this.getHours()}set hours(t){this.setHours(t)}get hoursFormatted(){let t=this.parts(void 0,o).hour;return"24"===t&&(t="00"),t}get twelveHoursFormatted(){return this.parts(void 0,i).hour}meridiem(t=this.locale){var e;return null===(e=new Intl.DateTimeFormat(t,{hour:"numeric",hour12:!0}).formatToParts(this).find((t=>"dayPeriod"===t.type)))||void 0===e?void 0:e.value}get date(){return this.getDate()}set date(t){this.setDate(t)}get dateFormatted(){return this.parts(void 0,i).day}get weekDay(){return this.getDay()}get month(){return this.getMonth()}set month(t){const e=new Date(this.year,t+1);e.setDate(0);const s=e.getDate();this.date>s&&(this.date=s),this.setMonth(t)}get monthFormatted(){return this.parts(void 0,i).month}get year(){return this.getFullYear()}set year(t){this.setFullYear(t)}get week(){const t=this.computeOrdinal(),e=this.getUTCDay();let s=Math.floor((t-e+10)/7);return s<1?s=this.weeksInWeekYear(this.year-1):s>this.weeksInWeekYear(this.year)&&(s=1),s}weeksInWeekYear(t){const e=(t+Math.floor(t/4)-Math.floor(t/100)+Math.floor(t/400))%7,s=t-1,i=(s+Math.floor(s/4)-Math.floor(s/100)+Math.floor(s/400))%7;return 4===e||3===i?53:52}get isLeapYear(){return this.year%4==0&&(this.year%100!=0||this.year%400==0)}computeOrdinal(){return this.date+(this.isLeapYear?this.leapLadder:this.nonLeapLadder)[this.month]}}class r extends Error{}const d="tempus-dominus";class l{}l.NAME=d,l.version="6.0.0-beta5.1",l.dataKey="td",l.events=new class{constructor(){this.key=".td",this.change=`change${this.key}`,this.update=`update${this.key}`,this.error=`error${this.key}`,this.show=`show${this.key}`,this.hide=`hide${this.key}`,this.blur=`blur${this.key}`,this.focus=`focus${this.key}`,this.keyup=`keyup${this.key}`,this.keydown=`keydown${this.key}`}},l.css=new class{constructor(){this.widget=`${d}-widget`,this.calendarHeader="calendar-header",this.switch="picker-switch",this.toolbar="toolbar",this.noHighlight="no-highlight",this.sideBySide="timepicker-sbs",this.previous="previous",this.next="next",this.disabled="disabled",this.old="old",this.new="new",this.active="active",this.dateContainer="date-container",this.decadesContainer=`${this.dateContainer}-decades`,this.decade="decade",this.yearsContainer=`${this.dateContainer}-years`,this.year="year",this.monthsContainer=`${this.dateContainer}-months`,this.month="month",this.daysContainer=`${this.dateContainer}-days`,this.day="day",this.calendarWeeks="cw",this.dayOfTheWeek="dow",this.today="today",this.weekend="weekend",this.timeContainer="time-container",this.separator="separator",this.clockContainer=`${this.timeContainer}-clock`,this.hourContainer=`${this.timeContainer}-hour`,this.minuteContainer=`${this.timeContainer}-minute`,this.secondContainer=`${this.timeContainer}-second`,this.hour="hour",this.minute="minute",this.second="second",this.toggleMeridiem="toggleMeridiem",this.show="show",this.collapsing="td-collapsing",this.collapse="td-collapse",this.inline="inline"}},l.errorMessages=new class{constructor(){this.base="TD:",this.failedToSetInvalidDate="Failed to set invalid date",this.failedToParseInput="Failed parse input field"}unexpectedOption(t){const e=new r(`${this.base} Unexpected option: ${t} does not match a known option.`);throw e.code=1,e}unexpectedOptions(t){const e=new r(`${this.base}: ${t.join(", ")}`);throw e.code=1,e}unexpectedOptionValue(t,e,s){const i=new r(`${this.base} Unexpected option value: ${t} does not accept a value of "${e}". Valid values are: ${s.join(", ")}`);throw i.code=2,i}typeMismatch(t,e,s){const i=new r(`${this.base} Mismatch types: ${t} has a type of ${e} instead of the required ${s}`);throw i.code=3,i}numbersOutOfRage(t,e,s){const i=new r(`${this.base} ${t} expected an array of number between ${e} and ${s}.`);throw i.code=4,i}failedToParseDate(t,e,s=!1){const i=new r(`${this.base} Could not correctly parse "${e}" to a date for ${t}.`);if(i.code=5,!s)throw i;console.warn(i)}mustProvideElement(){const t=new r(`${this.base} No element was provided.`);throw t.code=6,t}subscribeMismatch(){const t=new r(`${this.base} The subscribed events does not match the number of callbacks`);throw t.code=7,t}conflictingConfiguration(t){const e=new r(`${this.base} A configuration value conflicts with another rule. ${t}`);throw e.code=8,e}dateString(){console.warn(`${this.base} Using a string for date options is not recommended unless you specify an ISO string.`)}throwError(t){const e=new r(`${this.base} ${t}`);throw e.code=9,e}};const c=[{name:"calendar",className:l.css.daysContainer,unit:t.Unit.month,step:1},{name:"months",className:l.css.monthsContainer,unit:t.Unit.year,step:1},{name:"years",className:l.css.yearsContainer,unit:t.Unit.year,step:10},{name:"decades",className:l.css.decadesContainer,unit:t.Unit.year,step:100}],h={restrictions:{minDate:void 0,maxDate:void 0,disabledDates:[],enabledDates:[],daysOfWeekDisabled:[],disabledTimeIntervals:[],disabledHours:[],enabledHours:[]},display:{icons:{type:"icons",time:"fa-solid fa-clock",date:"fa-solid fa-calendar",up:"fa-solid fa-arrow-up",down:"fa-solid fa-arrow-down",previous:"fa-solid fa-chevron-left",next:"fa-solid fa-chevron-right",today:"fa-solid fa-calendar-check",clear:"fa-solid fa-trash",close:"fa-solid fa-xmark"},sideBySide:!1,calendarWeeks:!1,viewMode:"calendar",toolbarPlacement:"bottom",keepOpen:!1,buttons:{today:!1,clear:!1,close:!1},components:{calendar:!0,date:!0,month:!0,year:!0,decades:!0,clock:!0,hours:!0,minutes:!0,seconds:!1,useTwentyfourHour:!1},inline:!1},stepping:1,useCurrent:!0,defaultDate:void 0,localization:{today:"Go to today",clear:"Clear selection",close:"Close the picker",selectMonth:"Select Month",previousMonth:"Previous Month",nextMonth:"Next Month",selectYear:"Select Year",previousYear:"Previous Year",nextYear:"Next Year",selectDecade:"Select Decade",previousDecade:"Previous Decade",nextDecade:"Next Decade",previousCentury:"Previous Century",nextCentury:"Next Century",pickHour:"Pick Hour",incrementHour:"Increment Hour",decrementHour:"Decrement Hour",pickMinute:"Pick Minute",incrementMinute:"Increment Minute",decrementMinute:"Decrement Minute",pickSecond:"Pick Second",incrementSecond:"Increment Second",decrementSecond:"Decrement Second",toggleMeridiem:"Toggle Meridiem",selectTime:"Select Time",selectDate:"Select Date",dayViewHeaderFormat:{month:"long",year:"2-digit"},locale:"default",startOfTheWeek:0},keepInvalid:!1,debug:!1,allowInputToggle:!1,viewDate:new a,multipleDates:!1,multipleDatesSeparator:"; ",promptTimeOnDateChange:!1,promptTimeOnDateChangeTransitionDelay:200,meta:{},container:void 0};class p{constructor(){this.viewDate=new a,this._currentCalendarViewMode=0,this.minimumCalendarViewMode=0,this.currentView="calendar"}get currentCalendarViewMode(){return this._currentCalendarViewMode}set currentCalendarViewMode(t){this._currentCalendarViewMode=t,this.currentView=c[t].name}refreshCurrentView(){this.currentView=c[this.currentCalendarViewMode].name}}class u{static _mergeOptions(t,e){var s;const i={};let o="";const n=["meta","dayViewHeaderFormat","container"],a="default"!==e.localization.locale?e.localization.locale:(null===(s=null==t?void 0:t.localization)||void 0===s?void 0:s.locale)||"default",r=(t,e,s,i)=>{switch(t){case"defaultDate":{const t=this.dateConversion(e,"defaultDate");if(void 0!==t)return t.setLocale(a),t;l.errorMessages.typeMismatch("defaultDate",s,"DateTime or Date");break}case"viewDate":{const t=this.dateConversion(e,"viewDate");if(void 0!==t)return t.setLocale(a),t;l.errorMessages.typeMismatch("viewDate",s,"DateTime or Date");break}case"minDate":{if(void 0===e)return e;const t=this.dateConversion(e,"restrictions.minDate");if(void 0!==t)return t.setLocale(a),t;l.errorMessages.typeMismatch("restrictions.minDate",s,"DateTime or Date");break}case"maxDate":{if(void 0===e)return e;const t=this.dateConversion(e,"restrictions.maxDate");if(void 0!==t)return t.setLocale(a),t;l.errorMessages.typeMismatch("restrictions.maxDate",s,"DateTime or Date");break}case"disabledHours":return void 0===e?[]:(this._typeCheckNumberArray("restrictions.disabledHours",e,s),e.filter((t=>t<0||t>24)).length>0&&l.errorMessages.numbersOutOfRage("restrictions.disabledHours",0,23),e);case"enabledHours":return void 0===e?[]:(this._typeCheckNumberArray("restrictions.enabledHours",e,s),e.filter((t=>t<0||t>24)).length>0&&l.errorMessages.numbersOutOfRage("restrictions.enabledHours",0,23),e);case"daysOfWeekDisabled":return void 0===e?[]:(this._typeCheckNumberArray("restrictions.daysOfWeekDisabled",e,s),e.filter((t=>t<0||t>6)).length>0&&l.errorMessages.numbersOutOfRage("restrictions.daysOfWeekDisabled",0,6),e);case"enabledDates":return void 0===e?[]:(this._typeCheckDateArray("restrictions.enabledDates",e,s,a),e);case"disabledDates":return void 0===e?[]:(this._typeCheckDateArray("restrictions.disabledDates",e,s,a),e);case"disabledTimeIntervals":if(void 0===e)return[];Array.isArray(e)||l.errorMessages.typeMismatch(t,s,"array of { from: DateTime|Date, to: DateTime|Date }");const n=e;for(let e=0;e<n.length;e++)Object.keys(n[e]).forEach((s=>{const i=`${t}[${e}].${s}`;let o=n[e][s];const r=this.dateConversion(o,i);r||l.errorMessages.typeMismatch(i,typeof o,"DateTime or Date"),r.setLocale(a),n[e][s]=r}));return n;case"toolbarPlacement":case"type":case"viewMode":const r={toolbarPlacement:["top","bottom","default"],type:["icons","sprites"],viewMode:["clock","calendar","months","years","decades"]}[t];return r.includes(e)||l.errorMessages.unexpectedOptionValue(o.substring(1),e,r),e;case"meta":case"dayViewHeaderFormat":return e;case"container":return e&&!(e instanceof HTMLElement||e instanceof Element||(null==e?void 0:e.appendChild))&&l.errorMessages.typeMismatch(o.substring(1),typeof e,"HTMLElement"),e;default:switch(i){case"boolean":return"true"===e||!0===e;case"number":return+e;case"string":return e.toString();case"object":return{};case"function":return e;default:l.errorMessages.typeMismatch(o.substring(1),s,i)}}},d=(t,e,s)=>{const i=Object.keys(t).filter((t=>!Object.keys(e).includes(t)));if(i.length>0){const t=u.getFlattenDefaultOptions(),e=i.map((e=>{let s=`"${o.substring(1)}.${e}" in not a known option.`,i=t.find((t=>t.includes(e)));return i&&(s+=`Did you mean "${i}"?`),s}));l.errorMessages.unexpectedOptions(e)}Object.keys(e).forEach((i=>{const a=e[i];let l=typeof t[i],c=typeof a,h=t[i];if(!t.hasOwnProperty(i)){if("undefined"===c||0===(null==h?void 0:h.length)&&Array.isArray(a))return void(s[i]=a);t[i]=a,h=t[i]}o+=`.${i}`,s[i]=r(i,h,l,c),"object"!=typeof a||n.includes(i)||Array.isArray(t[i])||(d(t[i],a,s[i]),o=o.substring(0,o.lastIndexOf(`.${i}`))),o=o.substring(0,o.lastIndexOf(`.${i}`))}))};return d(t,e,i),i}static _dataToOptions(t,e){const s=JSON.parse(JSON.stringify(t.dataset));if((null==s?void 0:s.tdTargetInput)&&delete s.tdTargetInput,(null==s?void 0:s.tdTargetToggle)&&delete s.tdTargetToggle,!s||0===Object.keys(s).length||s.constructor!==DOMStringMap)return e;let i={};const o=t=>{const e={};return Object.keys(t).forEach((t=>{e[t.toLowerCase()]=t})),e},n=(t,e,s,i)=>{const a=o(s)[t[e].toLowerCase()],r={};return void 0===a||(s[a].constructor===Object?(e++,r[a]=n(t,e,s[a],i)):r[a]=i),r},a=o(e);return Object.keys(s).filter((t=>t.startsWith(l.dataKey))).map((t=>t.substring(2))).forEach((t=>{let o=a[t.toLowerCase()];if(t.includes("_")){const r=t.split("_");o=a[r[0].toLowerCase()],void 0!==o&&e[o].constructor===Object&&(i[o]=n(r,1,e[o],s[`td${t}`]))}else void 0!==o&&(i[o]=s[`td${t}`])})),this._mergeOptions(i,e)}static _dateTypeCheck(t){if(t.constructor.name===a.name)return t;if(t.constructor.name===Date.name)return a.convert(t);if("string"==typeof t){const e=new a(t);return"null"===JSON.stringify(e)?null:e}return null}static _typeCheckDateArray(t,e,s,i="default"){Array.isArray(e)||l.errorMessages.typeMismatch(t,s,"array of DateTime or Date");for(let s=0;s<e.length;s++){let o=e[s];const n=this.dateConversion(o,t);n||l.errorMessages.typeMismatch(t,typeof o,"DateTime or Date"),n.setLocale(i),e[s]=n}}static _typeCheckNumberArray(t,e,s){Array.isArray(e)&&!e.find((t=>"number"!=typeof t))||l.errorMessages.typeMismatch(t,s,"array of numbers")}static dateConversion(t,e){"string"==typeof t&&"input"!==e&&l.errorMessages.dateString();const s=this._dateTypeCheck(t);return s||l.errorMessages.failedToParseDate(e,t,"input"===e),s}static getFlattenDefaultOptions(){if(this._flattenDefaults)return this._flattenDefaults;const t=(e,s=[])=>Array.isArray(e)?[]:Object(e)===e?Object.entries(e).flatMap((([e,i])=>t(i,[...s,e]))):s.join(".");return this._flattenDefaults=t(h),this._flattenDefaults}static _validateConflicts(t){!t.display.sideBySide||t.display.components.clock&&(t.display.components.hours||t.display.components.minutes||t.display.components.seconds)||l.errorMessages.conflictingConfiguration("Cannot use side by side mode without the clock components"),t.restrictions.minDate&&t.restrictions.maxDate&&(t.restrictions.minDate.isAfter(t.restrictions.maxDate)&&l.errorMessages.conflictingConfiguration("minDate is after maxDate"),t.restrictions.maxDate.isBefore(t.restrictions.minDate)&&l.errorMessages.conflictingConfiguration("maxDate is before minDate"))}}class m{constructor(){this.cache=new Map}locate(t){const e=this.cache.get(t);if(e)return e;const s=new t;return this.cache.set(t,s),s}}let y;class v{constructor(){this.optionsStore=y.locate(p)}isValid(e,s){var i;if(this.optionsStore.options.restrictions.disabledDates.length>0&&this._isInDisabledDates(e))return!1;if(this.optionsStore.options.restrictions.enabledDates.length>0&&!this._isInEnabledDates(e))return!1;if(s!==t.Unit.month&&s!==t.Unit.year&&(null===(i=this.optionsStore.options.restrictions.daysOfWeekDisabled)||void 0===i?void 0:i.length)>0&&-1!==this.optionsStore.options.restrictions.daysOfWeekDisabled.indexOf(e.weekDay))return!1;if(this.optionsStore.options.restrictions.minDate&&e.isBefore(this.optionsStore.options.restrictions.minDate,s))return!1;if(this.optionsStore.options.restrictions.maxDate&&e.isAfter(this.optionsStore.options.restrictions.maxDate,s))return!1;if(s===t.Unit.hours||s===t.Unit.minutes||s===t.Unit.seconds){if(this.optionsStore.options.restrictions.disabledHours.length>0&&this._isInDisabledHours(e))return!1;if(this.optionsStore.options.restrictions.enabledHours.length>0&&!this._isInEnabledHours(e))return!1;if(this.optionsStore.options.restrictions.disabledTimeIntervals.length>0)for(let t of this.optionsStore.options.restrictions.disabledTimeIntervals)if(e.isBetween(t.from,t.to))return!1}return!0}_isInDisabledDates(e){if(!this.optionsStore.options.restrictions.disabledDates||0===this.optionsStore.options.restrictions.disabledDates.length)return!1;const s=e.format(n(t.Unit.date));return this.optionsStore.options.restrictions.disabledDates.map((e=>e.format(n(t.Unit.date)))).find((t=>t===s))}_isInEnabledDates(e){if(!this.optionsStore.options.restrictions.enabledDates||0===this.optionsStore.options.restrictions.enabledDates.length)return!0;const s=e.format(n(t.Unit.date));return this.optionsStore.options.restrictions.enabledDates.map((e=>e.format(n(t.Unit.date)))).find((t=>t===s))}_isInDisabledHours(t){if(!this.optionsStore.options.restrictions.disabledHours||0===this.optionsStore.options.restrictions.disabledHours.length)return!1;const e=t.hours;return this.optionsStore.options.restrictions.disabledHours.find((t=>t===e))}_isInEnabledHours(t){if(!this.optionsStore.options.restrictions.enabledHours||0===this.optionsStore.options.restrictions.enabledHours.length)return!0;const e=t.hours;return this.optionsStore.options.restrictions.enabledHours.find((t=>t===e))}}class g{constructor(){this.subscribers=[]}subscribe(t){return this.subscribers.push(t),this.unsubscribe.bind(this,this.subscribers.length-1)}unsubscribe(t){this.subscribers.splice(t,1)}emit(t){this.subscribers.forEach((e=>{e(t)}))}destory(){this.subscribers=null,this.subscribers=[]}}class S{constructor(){this.triggerEvent=new g,this.viewUpdate=new g,this.updateDisplay=new g,this.action=new g}destory(){this.triggerEvent.destory(),this.viewUpdate.destory(),this.updateDisplay.destory(),this.action.destory()}}class b{constructor(){this._dates=[],this.optionsStore=y.locate(p),this.validation=y.locate(v),this._eventEmitters=y.locate(S)}get picked(){return this._dates}get lastPicked(){return this._dates[this.lastPickedIndex]}get lastPickedIndex(){return 0===this._dates.length?0:this._dates.length-1}formatInput(t){const e=this.optionsStore.options.display.components;return t?t.format({year:e.calendar&&e.year?"numeric":void 0,month:e.calendar&&e.month?"2-digit":void 0,day:e.calendar&&e.date?"2-digit":void 0,hour:e.clock&&e.hours?e.useTwentyfourHour?"2-digit":"numeric":void 0,minute:e.clock&&e.minutes?"2-digit":void 0,second:e.clock&&e.seconds?"2-digit":void 0,hour12:!e.useTwentyfourHour}):""}setFromInput(t,e){if(!t)return void this.setValue(void 0,e);const s=u.dateConversion(t,"input");s&&(s.setLocale(this.optionsStore.options.localization.locale),this.setValue(s,e))}add(t){this._dates.push(t)}isPicked(t,e){if(!e)return void 0!==this._dates.find((e=>e===t));const s=n(e);let i=t.format(s);return void 0!==this._dates.map((t=>t.format(s))).find((t=>t===i))}pickedIndex(t,e){if(!e)return this._dates.indexOf(t);const s=n(e);let i=t.format(s);return this._dates.map((t=>t.format(s))).indexOf(i)}clear(){this.optionsStore.unset=!0,this._eventEmitters.triggerEvent.emit({type:l.events.change,date:void 0,oldDate:this.lastPicked,isClear:!0,isValid:!0}),this._dates=[]}static getStartEndYear(t,e){const s=t/10,i=Math.floor(e/t)*t;return[i,i+9*s,Math.floor(e/s)*s]}setValue(t,e){const s=void 0===e,i=!t&&s;let o=this.optionsStore.unset?null:this._dates[e];!o&&!this.optionsStore.unset&&s&&i&&(o=this.lastPicked);const n=()=>{if(!this.optionsStore.input)return;let e=this.formatInput(t);this.optionsStore.options.multipleDates&&(e=this._dates.map((t=>this.formatInput(t))).join(this.optionsStore.options.multipleDatesSeparator)),this.optionsStore.input.value!=e&&(this.optionsStore.input.value=e)};if(t&&(null==o?void 0:o.isSame(t)))n();else{if(!t)return!this.optionsStore.options.multipleDates||1===this._dates.length||i?(this.optionsStore.unset=!0,this._dates=[]):this._dates.splice(e,1),n(),this._eventEmitters.triggerEvent.emit({type:l.events.change,date:void 0,oldDate:o,isClear:i,isValid:!0}),void this._eventEmitters.updateDisplay.emit("all");if(e=e||0,t=t.clone,1!==this.optionsStore.options.stepping&&(t.minutes=Math.round(t.minutes/this.optionsStore.options.stepping)*this.optionsStore.options.stepping,t.seconds=0),this.validation.isValid(t))return this._dates[e]=t,this.optionsStore.viewDate=t.clone,n(),this.optionsStore.unset=!1,this._eventEmitters.updateDisplay.emit("all"),void this._eventEmitters.triggerEvent.emit({type:l.events.change,date:t,oldDate:o,isClear:i,isValid:!0});this.optionsStore.options.keepInvalid&&(this._dates[e]=t,this.optionsStore.viewDate=t.clone,n(),this._eventEmitters.triggerEvent.emit({type:l.events.change,date:t,oldDate:o,isClear:i,isValid:!1})),this._eventEmitters.triggerEvent.emit({type:l.events.error,reason:l.errorMessages.failedToSetInvalidDate,date:t,oldDate:o})}}}var f;!function(t){t.next="next",t.previous="previous",t.changeCalendarView="changeCalendarView",t.selectMonth="selectMonth",t.selectYear="selectYear",t.selectDecade="selectDecade",t.selectDay="selectDay",t.selectHour="selectHour",t.selectMinute="selectMinute",t.selectSecond="selectSecond",t.incrementHours="incrementHours",t.incrementMinutes="incrementMinutes",t.incrementSeconds="incrementSeconds",t.decrementHours="decrementHours",t.decrementMinutes="decrementMinutes",t.decrementSeconds="decrementSeconds",t.toggleMeridiem="toggleMeridiem",t.togglePicker="togglePicker",t.showClock="showClock",t.showHours="showHours",t.showMinutes="showMinutes",t.showSeconds="showSeconds",t.clear="clear",t.close="close",t.today="today"}(f||(f={}));var w=f;class D{constructor(){this.optionsStore=y.locate(p),this.dates=y.locate(b),this.validation=y.locate(v)}getPicker(){const t=document.createElement("div");if(t.classList.add(l.css.daysContainer),t.append(...this._daysOfTheWeek()),this.optionsStore.options.display.calendarWeeks){const e=document.createElement("div");e.classList.add(l.css.calendarWeeks,l.css.noHighlight),t.appendChild(e)}for(let e=0;e<42;e++){if(0!==e&&e%7==0&&this.optionsStore.options.display.calendarWeeks){const e=document.createElement("div");e.classList.add(l.css.calendarWeeks,l.css.noHighlight),t.appendChild(e)}const s=document.createElement("div");s.setAttribute("data-action",w.selectDay),t.appendChild(s)}return t}_update(e,s){const i=e.getElementsByClassName(l.css.daysContainer)[0],[o,n,r]=i.parentElement.getElementsByClassName(l.css.calendarHeader)[0].getElementsByTagName("div");n.setAttribute(l.css.daysContainer,this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat)),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.month),t.Unit.month)?o.classList.remove(l.css.disabled):o.classList.add(l.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.month),t.Unit.month)?r.classList.remove(l.css.disabled):r.classList.add(l.css.disabled);let d=this.optionsStore.viewDate.clone.startOf(t.Unit.month).startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).manipulate(12,t.Unit.hours);i.querySelectorAll(`[data-action="${w.selectDay}"], .${l.css.calendarWeeks}`).forEach((e=>{if(this.optionsStore.options.display.calendarWeeks&&e.classList.contains(l.css.calendarWeeks)){if("#"===e.innerText)return;return void(e.innerText=`${d.week}`)}let i=[];i.push(l.css.day),d.isBefore(this.optionsStore.viewDate,t.Unit.month)&&i.push(l.css.old),d.isAfter(this.optionsStore.viewDate,t.Unit.month)&&i.push(l.css.new),!this.optionsStore.unset&&this.dates.isPicked(d,t.Unit.date)&&i.push(l.css.active),this.validation.isValid(d,t.Unit.date)||i.push(l.css.disabled),d.isSame(new a,t.Unit.date)&&i.push(l.css.today),0!==d.weekDay&&6!==d.weekDay||i.push(l.css.weekend),s(t.Unit.date,d,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${d.year}-${d.monthFormatted}-${d.dateFormatted}`),e.setAttribute("data-day",`${d.date}`),e.innerText=d.format({day:"numeric"}),d.manipulate(1,t.Unit.date)}))}_daysOfTheWeek(){let e=this.optionsStore.viewDate.clone.startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).startOf(t.Unit.date);const s=[];if(document.createElement("div"),this.optionsStore.options.display.calendarWeeks){const t=document.createElement("div");t.classList.add(l.css.calendarWeeks,l.css.noHighlight),t.innerText="#",s.push(t)}for(let i=0;i<7;i++){const i=document.createElement("div");i.classList.add(l.css.dayOfTheWeek,l.css.noHighlight),i.innerText=e.format({weekday:"short"}),e.manipulate(1,t.Unit.date),s.push(i)}return s}}class _{constructor(){this.optionsStore=y.locate(p),this.dates=y.locate(b),this.validation=y.locate(v)}getPicker(){const t=document.createElement("div");t.classList.add(l.css.monthsContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",w.selectMonth),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(l.css.monthsContainer)[0],[o,n,a]=i.parentElement.getElementsByClassName(l.css.calendarHeader)[0].getElementsByTagName("div");n.setAttribute(l.css.monthsContainer,this.optionsStore.viewDate.format({year:"numeric"})),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.year),t.Unit.year)?o.classList.remove(l.css.disabled):o.classList.add(l.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.year),t.Unit.year)?a.classList.remove(l.css.disabled):a.classList.add(l.css.disabled);let r=this.optionsStore.viewDate.clone.startOf(t.Unit.year);i.querySelectorAll(`[data-action="${w.selectMonth}"]`).forEach(((e,i)=>{let o=[];o.push(l.css.month),!this.optionsStore.unset&&this.dates.isPicked(r,t.Unit.month)&&o.push(l.css.active),this.validation.isValid(r,t.Unit.month)||o.push(l.css.disabled),s(t.Unit.month,r,o,e),e.classList.remove(...e.classList),e.classList.add(...o),e.setAttribute("data-value",`${i}`),e.innerText=`${r.format({month:"short"})}`,r.manipulate(1,t.Unit.month)}))}}class k{constructor(){this.optionsStore=y.locate(p),this.dates=y.locate(b),this.validation=y.locate(v)}getPicker(){const t=document.createElement("div");t.classList.add(l.css.yearsContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",w.selectYear),t.appendChild(e)}return t}_update(e,s){this._startYear=this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.year),this._endYear=this.optionsStore.viewDate.clone.manipulate(10,t.Unit.year);const i=e.getElementsByClassName(l.css.yearsContainer)[0],[o,n,a]=i.parentElement.getElementsByClassName(l.css.calendarHeader)[0].getElementsByTagName("div");n.setAttribute(l.css.yearsContainer,`${this._startYear.format({year:"numeric"})}-${this._endYear.format({year:"numeric"})}`),this.validation.isValid(this._startYear,t.Unit.year)?o.classList.remove(l.css.disabled):o.classList.add(l.css.disabled),this.validation.isValid(this._endYear,t.Unit.year)?a.classList.remove(l.css.disabled):a.classList.add(l.css.disabled);let r=this.optionsStore.viewDate.clone.startOf(t.Unit.year).manipulate(-1,t.Unit.year);i.querySelectorAll(`[data-action="${w.selectYear}"]`).forEach((e=>{let i=[];i.push(l.css.year),!this.optionsStore.unset&&this.dates.isPicked(r,t.Unit.year)&&i.push(l.css.active),this.validation.isValid(r,t.Unit.year)||i.push(l.css.disabled),s(t.Unit.year,r,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${r.year}`),e.innerText=r.format({year:"numeric"}),r.manipulate(1,t.Unit.year)}))}}class C{constructor(){this.optionsStore=y.locate(p),this.dates=y.locate(b),this.validation=y.locate(v)}getPicker(){const t=document.createElement("div");t.classList.add(l.css.decadesContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",w.selectDecade),t.appendChild(e)}return t}_update(e,s){const[i,o]=b.getStartEndYear(100,this.optionsStore.viewDate.year);this._startDecade=this.optionsStore.viewDate.clone.startOf(t.Unit.year),this._startDecade.year=i,this._endDecade=this.optionsStore.viewDate.clone.startOf(t.Unit.year),this._endDecade.year=o;const n=e.getElementsByClassName(l.css.decadesContainer)[0],[a,r,d]=n.parentElement.getElementsByClassName(l.css.calendarHeader)[0].getElementsByTagName("div");r.setAttribute(l.css.decadesContainer,`${this._startDecade.format({year:"numeric"})}-${this._endDecade.format({year:"numeric"})}`),this.validation.isValid(this._startDecade,t.Unit.year)?a.classList.remove(l.css.disabled):a.classList.add(l.css.disabled),this.validation.isValid(this._endDecade,t.Unit.year)?d.classList.remove(l.css.disabled):d.classList.add(l.css.disabled);const c=this.dates.picked.map((t=>t.year));n.querySelectorAll(`[data-action="${w.selectDecade}"]`).forEach(((e,i)=>{if(0===i)return e.classList.add(l.css.old),this._startDecade.year-10<0?(e.textContent=" ",a.classList.add(l.css.disabled),e.classList.add(l.css.disabled),void e.setAttribute("data-value","")):(e.innerText=this._startDecade.clone.manipulate(-10,t.Unit.year).format({year:"numeric"}),void e.setAttribute("data-value",`${this._startDecade.year}`));let o=[];o.push(l.css.decade);const n=this._startDecade.year,r=this._startDecade.year+9;!this.optionsStore.unset&&c.filter((t=>t>=n&&t<=r)).length>0&&o.push(l.css.active),s("decade",this._startDecade,o,e),e.classList.remove(...e.classList),e.classList.add(...o),e.setAttribute("data-value",`${this._startDecade.year}`),e.innerText=`${this._startDecade.format({year:"numeric"})}`,this._startDecade.manipulate(10,t.Unit.year)}))}}class E{constructor(){this._gridColumns="",this.optionsStore=y.locate(p),this.dates=y.locate(b),this.validation=y.locate(v)}getPicker(t){const e=document.createElement("div");return e.classList.add(l.css.clockContainer),e.append(...this._grid(t)),e}_update(e){const s=e.getElementsByClassName(l.css.clockContainer)[0],i=(this.dates.lastPicked||this.optionsStore.viewDate).clone;if(s.querySelectorAll(".disabled").forEach((t=>t.classList.remove(l.css.disabled))),this.optionsStore.options.display.components.hours&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.hours),t.Unit.hours)||s.querySelector(`[data-action=${w.incrementHours}]`).classList.add(l.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.hours),t.Unit.hours)||s.querySelector(`[data-action=${w.decrementHours}]`).classList.add(l.css.disabled),s.querySelector(`[data-time-component=${t.Unit.hours}]`).innerText=this.optionsStore.options.display.components.useTwentyfourHour?i.hoursFormatted:i.twelveHoursFormatted),this.optionsStore.options.display.components.minutes&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.minutes),t.Unit.minutes)||s.querySelector(`[data-action=${w.incrementMinutes}]`).classList.add(l.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.minutes),t.Unit.minutes)||s.querySelector(`[data-action=${w.decrementMinutes}]`).classList.add(l.css.disabled),s.querySelector(`[data-time-component=${t.Unit.minutes}]`).innerText=i.minutesFormatted),this.optionsStore.options.display.components.seconds&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.seconds),t.Unit.seconds)||s.querySelector(`[data-action=${w.incrementSeconds}]`).classList.add(l.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.seconds),t.Unit.seconds)||s.querySelector(`[data-action=${w.decrementSeconds}]`).classList.add(l.css.disabled),s.querySelector(`[data-time-component=${t.Unit.seconds}]`).innerText=i.secondsFormatted),!this.optionsStore.options.display.components.useTwentyfourHour){const e=s.querySelector(`[data-action=${w.toggleMeridiem}]`);e.innerText=i.meridiem(),this.validation.isValid(i.clone.manipulate(i.hours>=12?-12:12,t.Unit.hours))?e.classList.remove(l.css.disabled):e.classList.add(l.css.disabled)}s.style.gridTemplateAreas=`"${this._gridColumns}"`}_grid(e){this._gridColumns="";const s=[],i=[],o=[],n=document.createElement("div"),a=e(this.optionsStore.options.display.icons.up),r=e(this.optionsStore.options.display.icons.down);n.classList.add(l.css.separator,l.css.noHighlight);const d=n.cloneNode(!0);d.innerHTML=":";const c=(t=!1)=>t?d.cloneNode(!0):n.cloneNode(!0);if(this.optionsStore.options.display.components.hours){let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementHour),e.setAttribute("data-action",w.incrementHours),e.appendChild(a.cloneNode(!0)),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickHour),e.setAttribute("data-action",w.showHours),e.setAttribute("data-time-component",t.Unit.hours),i.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementHour),e.setAttribute("data-action",w.decrementHours),e.appendChild(r.cloneNode(!0)),o.push(e),this._gridColumns+="a"}if(this.optionsStore.options.display.components.minutes){this._gridColumns+=" a",this.optionsStore.options.display.components.hours&&(s.push(c()),i.push(c(!0)),o.push(c()),this._gridColumns+=" a");let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementMinute),e.setAttribute("data-action",w.incrementMinutes),e.appendChild(a.cloneNode(!0)),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickMinute),e.setAttribute("data-action",w.showMinutes),e.setAttribute("data-time-component",t.Unit.minutes),i.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementMinute),e.setAttribute("data-action",w.decrementMinutes),e.appendChild(r.cloneNode(!0)),o.push(e)}if(this.optionsStore.options.display.components.seconds){this._gridColumns+=" a",this.optionsStore.options.display.components.minutes&&(s.push(c()),i.push(c(!0)),o.push(c()),this._gridColumns+=" a");let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementSecond),e.setAttribute("data-action",w.incrementSeconds),e.appendChild(a.cloneNode(!0)),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickSecond),e.setAttribute("data-action",w.showSeconds),e.setAttribute("data-time-component",t.Unit.seconds),i.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementSecond),e.setAttribute("data-action",w.decrementSeconds),e.appendChild(r.cloneNode(!0)),o.push(e)}if(!this.optionsStore.options.display.components.useTwentyfourHour){this._gridColumns+=" a";let t=c();s.push(t);let e=document.createElement("button");e.setAttribute("title",this.optionsStore.options.localization.toggleMeridiem),e.setAttribute("data-action",w.toggleMeridiem),e.setAttribute("tabindex","-1"),l.css.toggleMeridiem.includes(",")?e.classList.add(...l.css.toggleMeridiem.split(",")):e.classList.add(l.css.toggleMeridiem),t=document.createElement("div"),t.classList.add(l.css.noHighlight),t.appendChild(e),i.push(t),t=c(),o.push(t)}return this._gridColumns=this._gridColumns.trim(),[...s,...i,...o]}}class M{constructor(){this.optionsStore=y.locate(p),this.validation=y.locate(v)}getPicker(){const t=document.createElement("div");t.classList.add(l.css.hourContainer);for(let e=0;e<(this.optionsStore.options.display.components.useTwentyfourHour?24:12);e++){const e=document.createElement("div");e.setAttribute("data-action",w.selectHour),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(l.css.hourContainer)[0];let o=this.optionsStore.viewDate.clone.startOf(t.Unit.date);i.querySelectorAll(`[data-action="${w.selectHour}"]`).forEach((e=>{let i=[];i.push(l.css.hour),this.validation.isValid(o,t.Unit.hours)||i.push(l.css.disabled),s(t.Unit.hours,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.hours}`),e.innerText=this.optionsStore.options.display.components.useTwentyfourHour?o.hoursFormatted:o.twelveHoursFormatted,o.manipulate(1,t.Unit.hours)}))}}class L{constructor(){this.optionsStore=y.locate(p),this.validation=y.locate(v)}getPicker(){const t=document.createElement("div");t.classList.add(l.css.minuteContainer);let e=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;for(let s=0;s<60/e;s++){const e=document.createElement("div");e.setAttribute("data-action",w.selectMinute),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(l.css.minuteContainer)[0];let o=this.optionsStore.viewDate.clone.startOf(t.Unit.hours),n=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;i.querySelectorAll(`[data-action="${w.selectMinute}"]`).forEach((e=>{let i=[];i.push(l.css.minute),this.validation.isValid(o,t.Unit.minutes)||i.push(l.css.disabled),s(t.Unit.minutes,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.minutesFormatted}`),e.innerText=o.minutesFormatted,o.manipulate(n,t.Unit.minutes)}))}}class T{constructor(){this.optionsStore=y.locate(p),this.validation=y.locate(v)}getPicker(){const t=document.createElement("div");t.classList.add(l.css.secondContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",w.selectSecond),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(l.css.secondContainer)[0];let o=this.optionsStore.viewDate.clone.startOf(t.Unit.minutes);i.querySelectorAll(`[data-action="${w.selectSecond}"]`).forEach((e=>{let i=[];i.push(l.css.second),this.validation.isValid(o,t.Unit.seconds)||i.push(l.css.disabled),s(t.Unit.seconds,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.seconds}`),e.innerText=o.secondsFormatted,o.manipulate(5,t.Unit.seconds)}))}}class U{static toggle(t){t.classList.contains(l.css.show)?this.hide(t):this.show(t)}static show(t){if(t.classList.contains(l.css.collapsing)||t.classList.contains(l.css.show))return;t.style.height="0",t.classList.remove(l.css.collapse),t.classList.add(l.css.collapsing),setTimeout((()=>{t.classList.remove(l.css.collapsing),t.classList.add(l.css.collapse,l.css.show),t.style.height=""}),this.getTransitionDurationFromElement(t)),t.style.height=`${t.scrollHeight}px`}static hide(t){if(t.classList.contains(l.css.collapsing)||!t.classList.contains(l.css.show))return;t.style.height=`${t.getBoundingClientRect().height}px`;t.offsetHeight,t.classList.remove(l.css.collapse,l.css.show),t.classList.add(l.css.collapsing),t.style.height="",setTimeout((()=>{t.classList.remove(l.css.collapsing),t.classList.add(l.css.collapse)}),this.getTransitionDurationFromElement(t))}}U.getTransitionDurationFromElement=t=>{if(!t)return 0;let{transitionDuration:e,transitionDelay:s}=window.getComputedStyle(t);const i=Number.parseFloat(e),o=Number.parseFloat(s);return i||o?(e=e.split(",")[0],s=s.split(",")[0],1e3*(Number.parseFloat(e)+Number.parseFloat(s))):0};class A{constructor(){this._isVisible=!1,this._documentClickEvent=t=>{var e;this.optionsStore.options.debug||window.debug||!this._isVisible||t.composedPath().includes(this.widget)||(null===(e=t.composedPath())||void 0===e?void 0:e.includes(this.optionsStore.element))||this.hide()},this._actionsClickEvent=t=>{this._eventEmitters.action.emit({e:t})},this.optionsStore=y.locate(p),this.validation=y.locate(v),this.dates=y.locate(b),this.dateDisplay=y.locate(D),this.monthDisplay=y.locate(_),this.yearDisplay=y.locate(k),this.decadeDisplay=y.locate(C),this.timeDisplay=y.locate(E),this.hourDisplay=y.locate(M),this.minuteDisplay=y.locate(L),this.secondDisplay=y.locate(T),this._eventEmitters=y.locate(S),this._widget=void 0,this._eventEmitters.updateDisplay.subscribe((t=>{this._update(t)}))}get widget(){return this._widget}get isVisible(){return this._isVisible}_update(e){if(this.widget)switch(e){case t.Unit.seconds:this.secondDisplay._update(this.widget,this.paint);break;case t.Unit.minutes:this.minuteDisplay._update(this.widget,this.paint);break;case t.Unit.hours:this.hourDisplay._update(this.widget,this.paint);break;case t.Unit.date:this.dateDisplay._update(this.widget,this.paint);break;case t.Unit.month:this.monthDisplay._update(this.widget,this.paint);break;case t.Unit.year:this.yearDisplay._update(this.widget,this.paint);break;case"clock":if(!this._hasTime)break;this.timeDisplay._update(this.widget),this._update(t.Unit.hours),this._update(t.Unit.minutes),this._update(t.Unit.seconds);break;case"calendar":this._update(t.Unit.date),this._update(t.Unit.year),this._update(t.Unit.month),this.decadeDisplay._update(this.widget,this.paint),this._updateCalendarHeader();break;case"all":this._hasTime&&this._update("clock"),this._hasDate&&this._update("calendar")}}paint(t,e,s,i){}show(){var s,i;if(null==this.widget){if(0==this.dates.picked.length){if(this.optionsStore.options.useCurrent&&!this.optionsStore.options.defaultDate){const e=(new a).setLocale(this.optionsStore.options.localization.locale);if(!this.optionsStore.options.keepInvalid){let i=0,o=1;for((null===(s=this.optionsStore.options.restrictions.maxDate)||void 0===s?void 0:s.isBefore(e))&&(o=-1);!(this.validation.isValid(e)||(e.manipulate(o,t.Unit.date),i>31));)i++}this.dates.setValue(e)}this.optionsStore.options.defaultDate&&this.dates.setValue(this.optionsStore.options.defaultDate)}this._buildWidget();const o=this._hasTime&&!this._hasDate;if(o&&(this.optionsStore.currentView="clock",this._eventEmitters.action.emit({e:null,action:w.showClock})),this.optionsStore.currentCalendarViewMode||(this.optionsStore.currentCalendarViewMode=this.optionsStore.minimumCalendarViewMode),o||(this._hasTime&&U.hide(this.widget.querySelector(`div.${l.css.timeContainer}`)),U.show(this.widget.querySelector(`div.${l.css.dateContainer}`))),this._hasDate&&this._showMode(),this.optionsStore.options.display.inline)this.optionsStore.element.appendChild(this.widget);else{((null===(i=this.optionsStore.options)||void 0===i?void 0:i.container)||document.body).appendChild(this.widget),this._popperInstance=e.createPopper(this.optionsStore.element,this.widget,{modifiers:[{name:"eventListeners",enabled:!0}],placement:"rtl"===document.documentElement.dir?"bottom-end":"bottom-start"})}"clock"==this.optionsStore.options.display.viewMode&&this._eventEmitters.action.emit({e:null,action:w.showClock}),this.widget.querySelectorAll("[data-action]").forEach((t=>t.addEventListener("click",this._actionsClickEvent))),this._hasTime&&this.optionsStore.options.display.sideBySide&&(this.timeDisplay._update(this.widget),this.widget.getElementsByClassName(l.css.clockContainer)[0].style.display="grid")}this.widget.classList.add(l.css.show),this.optionsStore.options.display.inline||(this._popperInstance.update(),document.addEventListener("click",this._documentClickEvent)),this._eventEmitters.triggerEvent.emit({type:l.events.show}),this._isVisible=!0}_showMode(t){if(!this.widget)return;if(t){const e=Math.max(this.optionsStore.minimumCalendarViewMode,Math.min(3,this.optionsStore.currentCalendarViewMode+t));if(this.optionsStore.currentCalendarViewMode==e)return;this.optionsStore.currentCalendarViewMode=e}this.widget.querySelectorAll(`.${l.css.dateContainer} > div:not(.${l.css.calendarHeader}), .${l.css.timeContainer} > div:not(.${l.css.clockContainer})`).forEach((t=>t.style.display="none"));const e=c[this.optionsStore.currentCalendarViewMode];let s=this.widget.querySelector(`.${e.className}`);switch(e.className){case l.css.decadesContainer:this.decadeDisplay._update(this.widget,this.paint);break;case l.css.yearsContainer:this.yearDisplay._update(this.widget,this.paint);break;case l.css.monthsContainer:this.monthDisplay._update(this.widget,this.paint);break;case l.css.daysContainer:this.dateDisplay._update(this.widget,this.paint)}s.style.display="grid",this._updateCalendarHeader(),this._eventEmitters.viewUpdate.emit()}_updateCalendarHeader(){const t=[...this.widget.querySelector(`.${l.css.dateContainer} div[style*="display: grid"]`).classList].find((t=>t.startsWith(l.css.dateContainer))),[e,s,i]=this.widget.getElementsByClassName(l.css.calendarHeader)[0].getElementsByTagName("div");switch(t){case l.css.decadesContainer:e.setAttribute("title",this.optionsStore.options.localization.previousCentury),s.setAttribute("title",""),i.setAttribute("title",this.optionsStore.options.localization.nextCentury);break;case l.css.yearsContainer:e.setAttribute("title",this.optionsStore.options.localization.previousDecade),s.setAttribute("title",this.optionsStore.options.localization.selectDecade),i.setAttribute("title",this.optionsStore.options.localization.nextDecade);break;case l.css.monthsContainer:e.setAttribute("title",this.optionsStore.options.localization.previousYear),s.setAttribute("title",this.optionsStore.options.localization.selectYear),i.setAttribute("title",this.optionsStore.options.localization.nextYear);break;case l.css.daysContainer:e.setAttribute("title",this.optionsStore.options.localization.previousMonth),s.setAttribute("title",this.optionsStore.options.localization.selectMonth),i.setAttribute("title",this.optionsStore.options.localization.nextMonth),s.innerText=this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat)}s.innerText=s.getAttribute(t)}hide(){this.widget&&this._isVisible&&(this.widget.classList.remove(l.css.show),this._isVisible&&(this._eventEmitters.triggerEvent.emit({type:l.events.hide,date:this.optionsStore.unset?null:this.dates.lastPicked?this.dates.lastPicked.clone:void 0}),this._isVisible=!1),document.removeEventListener("click",this._documentClickEvent))}toggle(){return this._isVisible?this.hide():this.show()}_dispose(){document.removeEventListener("click",this._documentClickEvent),this.widget&&(this.widget.querySelectorAll("[data-action]").forEach((t=>t.removeEventListener("click",this._actionsClickEvent))),this.widget.parentNode.removeChild(this.widget),this._widget=void 0)}_buildWidget(){const t=document.createElement("div");t.classList.add(l.css.widget);const e=document.createElement("div");e.classList.add(l.css.dateContainer),e.append(this.getHeadTemplate(),this.decadeDisplay.getPicker(),this.yearDisplay.getPicker(),this.monthDisplay.getPicker(),this.dateDisplay.getPicker());const s=document.createElement("div");s.classList.add(l.css.timeContainer),s.appendChild(this.timeDisplay.getPicker(this._iconTag.bind(this))),s.appendChild(this.hourDisplay.getPicker()),s.appendChild(this.minuteDisplay.getPicker()),s.appendChild(this.secondDisplay.getPicker());const i=document.createElement("div");if(i.classList.add(l.css.toolbar),i.append(...this.getToolbarElements()),this.optionsStore.options.display.inline&&t.classList.add(l.css.inline),this.optionsStore.options.display.calendarWeeks&&t.classList.add("calendarWeeks"),this.optionsStore.options.display.sideBySide&&this._hasDate&&this._hasTime){t.classList.add(l.css.sideBySide),"top"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i);const o=document.createElement("div");return o.classList.add("td-row"),e.classList.add("td-half"),s.classList.add("td-half"),o.appendChild(e),o.appendChild(s),t.appendChild(o),"bottom"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i),void(this._widget=t)}"top"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i),this._hasDate&&(this._hasTime&&(e.classList.add(l.css.collapse),"clock"!==this.optionsStore.options.display.viewMode&&e.classList.add(l.css.show)),t.appendChild(e)),this._hasTime&&(this._hasDate&&(s.classList.add(l.css.collapse),"clock"===this.optionsStore.options.display.viewMode&&s.classList.add(l.css.show)),t.appendChild(s)),"bottom"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i);const o=document.createElement("div");o.classList.add("arrow"),o.setAttribute("data-popper-arrow",""),t.appendChild(o),this._widget=t}get _hasTime(){return this.optionsStore.options.display.components.clock&&(this.optionsStore.options.display.components.hours||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.components.seconds)}get _hasDate(){return this.optionsStore.options.display.components.calendar&&(this.optionsStore.options.display.components.year||this.optionsStore.options.display.components.month||this.optionsStore.options.display.components.date)}getToolbarElements(){const t=[];if(this.optionsStore.options.display.buttons.today){const e=document.createElement("div");e.setAttribute("data-action",w.today),e.setAttribute("title",this.optionsStore.options.localization.today),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.today)),t.push(e)}if(!this.optionsStore.options.display.sideBySide&&this._hasDate&&this._hasTime){let e,s;"clock"===this.optionsStore.options.display.viewMode?(e=this.optionsStore.options.localization.selectDate,s=this.optionsStore.options.display.icons.date):(e=this.optionsStore.options.localization.selectTime,s=this.optionsStore.options.display.icons.time);const i=document.createElement("div");i.setAttribute("data-action",w.togglePicker),i.setAttribute("title",e),i.appendChild(this._iconTag(s)),t.push(i)}if(this.optionsStore.options.display.buttons.clear){const e=document.createElement("div");e.setAttribute("data-action",w.clear),e.setAttribute("title",this.optionsStore.options.localization.clear),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.clear)),t.push(e)}if(this.optionsStore.options.display.buttons.close){const e=document.createElement("div");e.setAttribute("data-action",w.close),e.setAttribute("title",this.optionsStore.options.localization.close),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.close)),t.push(e)}return t}getHeadTemplate(){const t=document.createElement("div");t.classList.add(l.css.calendarHeader);const e=document.createElement("div");e.classList.add(l.css.previous),e.setAttribute("data-action",w.previous),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.previous));const s=document.createElement("div");s.classList.add(l.css.switch),s.setAttribute("data-action",w.changeCalendarView);const i=document.createElement("div");return i.classList.add(l.css.next),i.setAttribute("data-action",w.next),i.appendChild(this._iconTag(this.optionsStore.options.display.icons.next)),t.append(e,s,i),t}_iconTag(t){if("sprites"===this.optionsStore.options.display.icons.type){const e=document.createElementNS("http://www.w3.org/2000/svg","svg"),s=document.createElementNS("http://www.w3.org/2000/svg","use");return s.setAttribute("xlink:href",t),s.setAttribute("href",t),e.appendChild(s),e}const e=document.createElement("i");return e.classList.add(...t.split(" ")),e}_rebuild(){const t=this._isVisible;t&&this.hide(),this._dispose(),t&&this.show()}}class ${constructor(){this.optionsStore=y.locate(p),this.dates=y.locate(b),this.validation=y.locate(v),this.display=y.locate(A),this._eventEmitters=y.locate(S),this._eventEmitters.action.subscribe((t=>{this.do(t.e,t.action)}))}do(e,s){var i,o;const n=null==e?void 0:e.currentTarget;if(null===(i=null==n?void 0:n.classList)||void 0===i?void 0:i.contains(l.css.disabled))return!1;s=s||(null===(o=null==n?void 0:n.dataset)||void 0===o?void 0:o.action);const r=(this.dates.lastPicked||this.optionsStore.viewDate).clone;switch(s){case w.next:case w.previous:this.handleNextPrevious(s);break;case w.changeCalendarView:this.display._showMode(1),this.display._updateCalendarHeader();break;case w.selectMonth:case w.selectYear:case w.selectDecade:const i=+n.dataset.value;switch(s){case w.selectMonth:this.optionsStore.viewDate.month=i;break;case w.selectYear:case w.selectDecade:this.optionsStore.viewDate.year=i}this.optionsStore.currentCalendarViewMode===this.optionsStore.minimumCalendarViewMode?(this.dates.setValue(this.optionsStore.viewDate,this.dates.lastPickedIndex),this.optionsStore.options.display.inline||this.display.hide()):this.display._showMode(-1);break;case w.selectDay:const o=this.optionsStore.viewDate.clone;n.classList.contains(l.css.old)&&o.manipulate(-1,t.Unit.month),n.classList.contains(l.css.new)&&o.manipulate(1,t.Unit.month),o.date=+n.dataset.day;let d=0;this.optionsStore.options.multipleDates?(d=this.dates.pickedIndex(o,t.Unit.date),-1!==d?this.dates.setValue(null,d):this.dates.setValue(o,this.dates.lastPickedIndex+1)):this.dates.setValue(o,this.dates.lastPickedIndex),this.display._hasTime||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline||this.optionsStore.options.multipleDates||this.display.hide();break;case w.selectHour:let c=+n.dataset.value;r.hours>=12&&!this.optionsStore.options.display.components.useTwentyfourHour&&(c+=12),r.hours=c,this.dates.setValue(r,this.dates.lastPickedIndex),this.hideOrClock(e);break;case w.selectMinute:r.minutes=+n.dataset.value,this.dates.setValue(r,this.dates.lastPickedIndex),this.hideOrClock(e);break;case w.selectSecond:r.seconds=+n.dataset.value,this.dates.setValue(r,this.dates.lastPickedIndex),this.hideOrClock(e);break;case w.incrementHours:this.manipulateAndSet(r,t.Unit.hours);break;case w.incrementMinutes:this.manipulateAndSet(r,t.Unit.minutes,this.optionsStore.options.stepping);break;case w.incrementSeconds:this.manipulateAndSet(r,t.Unit.seconds);break;case w.decrementHours:this.manipulateAndSet(r,t.Unit.hours,-1);break;case w.decrementMinutes:this.manipulateAndSet(r,t.Unit.minutes,-1*this.optionsStore.options.stepping);break;case w.decrementSeconds:this.manipulateAndSet(r,t.Unit.seconds,-1);break;case w.toggleMeridiem:this.manipulateAndSet(r,t.Unit.hours,this.dates.lastPicked.hours>=12?-12:12);break;case w.togglePicker:n.getAttribute("title")===this.optionsStore.options.localization.selectDate?(n.setAttribute("title",this.optionsStore.options.localization.selectTime),n.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.time).outerHTML,this.display._updateCalendarHeader(),this.optionsStore.refreshCurrentView()):(n.setAttribute("title",this.optionsStore.options.localization.selectDate),n.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.date).outerHTML,this.display._hasTime&&(this.do(e,w.showClock),this.display._update("clock"))),this.display.widget.querySelectorAll(`.${l.css.dateContainer}, .${l.css.timeContainer}`).forEach((t=>U.toggle(t))),this._eventEmitters.viewUpdate.emit();break;case w.showClock:case w.showHours:case w.showMinutes:case w.showSeconds:this.handleShowClockContainers(s);break;case w.clear:this.dates.setValue(null),this.display._updateCalendarHeader();break;case w.close:this.display.hide();break;case w.today:const h=(new a).setLocale(this.optionsStore.options.localization.locale);this.optionsStore.viewDate=h,this.validation.isValid(h,t.Unit.date)&&this.dates.setValue(h,this.dates.lastPickedIndex)}}handleShowClockContainers(e){if(!this.display._hasTime)return void l.errorMessages.throwError("Cannot show clock containers when time is disabled.");this.optionsStore.currentView="clock",this.display.widget.querySelectorAll(`.${l.css.timeContainer} > div`).forEach((t=>t.style.display="none"));let s="";switch(e){case w.showClock:s=l.css.clockContainer,this.display._update("clock");break;case w.showHours:s=l.css.hourContainer,this.display._update(t.Unit.hours);break;case w.showMinutes:s=l.css.minuteContainer,this.display._update(t.Unit.minutes);break;case w.showSeconds:s=l.css.secondContainer,this.display._update(t.Unit.seconds)}this.display.widget.getElementsByClassName(s)[0].style.display="grid"}handleNextPrevious(t){const{unit:e,step:s}=c[this.optionsStore.currentCalendarViewMode];t===w.next?this.optionsStore.viewDate.manipulate(s,e):this.optionsStore.viewDate.manipulate(-1*s,e),this._eventEmitters.viewUpdate.emit(),this.display._showMode()}hideOrClock(t){!this.optionsStore.options.display.components.useTwentyfourHour||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline?this.do(t,w.showClock):this.display.hide()}manipulateAndSet(t,e,s=1){const i=t.manipulate(s,e);this.validation.isValid(i,e)&&this.dates.setValue(i,this.dates.lastPickedIndex)}}class O{constructor(t,e={}){this._subscribers={},this._isDisabled=!1,this._inputChangeEvent=t=>{if(null==t?void 0:t.detail)return;const e=()=>{this.dates.lastPicked&&(this.optionsStore.viewDate=this.dates.lastPicked)},s=this.optionsStore.input.value;if(this.optionsStore.options.multipleDates)try{const t=s.split(this.optionsStore.options.multipleDatesSeparator);for(let e=0;e<t.length;e++)this.dates.setFromInput(t[e],e);e()}catch(t){console.warn("TD: Something went wrong trying to set the multidate values from the input field.")}else this.dates.setFromInput(s,0),e()},this._toggleClickEvent=()=>{this.toggle()},y=new m,this._eventEmitters=y.locate(S),this.optionsStore=y.locate(p),this.display=y.locate(A),this.dates=y.locate(b),this.actions=y.locate($),t||l.errorMessages.mustProvideElement(),this.optionsStore.element=t,this._initializeOptions(e,h,!0),this.optionsStore.viewDate.setLocale(this.optionsStore.options.localization.locale),this.optionsStore.unset=!0,this._initializeInput(),this._initializeToggle(),this.optionsStore.options.display.inline&&this.display.show(),this._eventEmitters.triggerEvent.subscribe((t=>{this._triggerEvent(t)})),this._eventEmitters.viewUpdate.subscribe((()=>{this._viewUpdate()}))}get viewDate(){return this.optionsStore.viewDate}updateOptions(t,e=!1){e?this._initializeOptions(t,h):this._initializeOptions(t,this.optionsStore.options),this.display._rebuild()}toggle(){this._isDisabled||this.display.toggle()}show(){this._isDisabled||this.display.show()}hide(){this.display.hide()}disable(){var t;this._isDisabled=!0,null===(t=this.optionsStore.input)||void 0===t||t.setAttribute("disabled","disabled"),this.display.hide()}enable(){var t;this._isDisabled=!1,null===(t=this.optionsStore.input)||void 0===t||t.removeAttribute("disabled")}clear(){this.optionsStore.input.value="",this.dates.clear()}subscribe(t,e){let s;"string"==typeof t&&(t=[t]),s=Array.isArray(e)?e:[e],t.length!==s.length&&l.errorMessages.subscribeMismatch();const i=[];for(let e=0;e<t.length;e++){const o=t[e];if(Array.isArray(this._subscribers[o])||(this._subscribers[o]=[]),this._subscribers[o].push(s[e]),i.push({unsubscribe:this._unsubscribe.bind(this,o,this._subscribers[o].length-1)}),1===t.length)return i[0]}return i}dispose(){var t,e,s;this.display.hide(),this.display._dispose(),null===(t=this.optionsStore.input)||void 0===t||t.removeEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&(null===(e=this.optionsStore.input)||void 0===e||e.removeEventListener("click",this._toggleClickEvent)),null===(s=this._toggle)||void 0===s||s.removeEventListener("click",this._toggleClickEvent),this._subscribers={}}locale(t){let e=H[t];e&&this.updateOptions({localization:e})}_triggerEvent(t){var e,s;t.viewMode=this.optionsStore.currentView;const i=t.type===l.events.change;if(i){const{date:i,oldDate:o,isClear:n}=t;if(i&&o&&i.isSame(o)||!n&&!i&&!o)return;this._handleAfterChangeEvent(t),null===(e=this.optionsStore.input)||void 0===e||e.dispatchEvent(new CustomEvent(t.type,{detail:t})),null===(s=this.optionsStore.input)||void 0===s||s.dispatchEvent(new CustomEvent("change",{detail:t}))}if(this.optionsStore.element.dispatchEvent(new CustomEvent(t.type,{detail:t})),window.jQuery){const e=window.jQuery;i&&this.optionsStore.input?e(this.optionsStore.input).trigger(t):e(this.optionsStore.element).trigger(t)}this._publish(t)}_publish(t){Array.isArray(this._subscribers[t.type])&&this._subscribers[t.type].forEach((e=>{e(t)}))}_viewUpdate(){this._triggerEvent({type:l.events.update,viewDate:this.optionsStore.viewDate.clone})}_unsubscribe(t,e){this._subscribers[t].splice(e,1)}_initializeOptions(t,e,s=!1){var i;t=u._mergeOptions(t,e),s&&(t=u._dataToOptions(this.optionsStore.element,t)),u._validateConflicts(t),t.viewDate=t.viewDate.setLocale(t.localization.locale),this.optionsStore.viewDate.isSame(t.viewDate)||(this.optionsStore.viewDate=t.viewDate),t.display.components.year&&(this.optionsStore.minimumCalendarViewMode=2),t.display.components.month&&(this.optionsStore.minimumCalendarViewMode=1),t.display.components.date&&(this.optionsStore.minimumCalendarViewMode=0),this.optionsStore.currentCalendarViewMode=Math.max(this.optionsStore.minimumCalendarViewMode,this.optionsStore.currentCalendarViewMode),c[this.optionsStore.currentCalendarViewMode].name!==t.display.viewMode&&(this.optionsStore.currentCalendarViewMode=Math.max(c.findIndex((e=>e.name===t.display.viewMode)),this.optionsStore.minimumCalendarViewMode)),(null===(i=this.display)||void 0===i?void 0:i.isVisible)&&this.display._update("all"),this.optionsStore.options=t}_initializeInput(){if("INPUT"==this.optionsStore.element.tagName)this.optionsStore.input=this.optionsStore.element;else{let t=this.optionsStore.element.dataset.tdTargetInput;this.optionsStore.input=null==t||"nearest"==t?this.optionsStore.element.querySelector("input"):this.optionsStore.element.querySelector(t)}this.optionsStore.input&&(this.optionsStore.input.addEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&this.optionsStore.input.addEventListener("click",this._toggleClickEvent),this.optionsStore.input.value&&this._inputChangeEvent())}_initializeToggle(){if(this.optionsStore.options.display.inline)return;let t=this.optionsStore.element.dataset.tdTargetToggle;"nearest"==t&&(t='[data-td-toggle="datetimepicker"]'),this._toggle=null==t?this.optionsStore.element:this.optionsStore.element.querySelector(t),this._toggle.addEventListener("click",this._toggleClickEvent)}_handleAfterChangeEvent(t){var e,s;!this.optionsStore.options.promptTimeOnDateChange||this.optionsStore.options.display.inline||this.optionsStore.options.display.sideBySide||!this.display._hasTime||(null===(e=this.display.widget)||void 0===e?void 0:e.getElementsByClassName(l.css.show)[0].classList.contains(l.css.timeContainer))||!t.oldDate&&this.optionsStore.options.useCurrent||t.oldDate&&(null===(s=t.date)||void 0===s?void 0:s.isSame(t.oldDate))||(clearTimeout(this._currentPromptTimeTimeout),this._currentPromptTimeTimeout=setTimeout((()=>{this.display.widget&&this._eventEmitters.action.emit({e:{currentTarget:this.display.widget.querySelector(`.${l.css.switch} div`)},action:w.togglePicker})}),this.optionsStore.options.promptTimeOnDateChangeTransitionDelay))}}const H={};t.DateTime=a,t.DefaultOptions=h,t.Namespace=l,t.TempusDominus=O,t.extend=function(t,e){return t.$i||(t.load(e,{TempusDominus:O,Dates:b,Display:A},this),t.$i=!0),this},t.loadLocale=t=>{H[t.name]||(H[t.name]=t.localization)},t.locale=t=>{let e=H[t];e&&(h.localization=e)},Object.defineProperty(t,"__esModule",{value:!0})}));
