(function ( $ ) {
    "use strict";

    tinymce.create( 'tinymce.plugins.WPB_Analytics_Opt_Out', {
        /**
         * Initializes the plugin, this will be executed after the plugin has been created.
         * This call is done before the editor instance has finished it's initialization so use the onInit event
         * of the editor instance to intercept that event.
         *
         * @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.
         * @param {string} url Absolute URL to where the plugin is located.
         */
        init: function ( ed, url ) {
            ed.addButton( 'wpb_analytics_opt_out', {
                title: 'Analytics Opt-Out',
                cmd:   'wpb_analytics_opt_out',
                image: url + '/../images/optout-editor-icon.svg'
            } );

            ed.addCommand( 'wpb_analytics_opt_out', function () {
                var shortcode = '[google_analytics_optout]Click here to opt-out.[/google_analytics_optout]';
                tinyMCE.activeEditor.execCommand( 'mceInsertContent', 0, shortcode + ' ' );
            } )
        },

        /**
         * Creates control instances based in the incomming name. This method is normally not
         * needed since the addButton method of the tinymce.Editor class is a more easy way of adding buttons
         * but you sometimes need to create more complex controls like listboxes, split buttons etc then this
         * method can be used to create those.
         *
         * @param {String} n Name of the control to create.
         * @param {tinymce.ControlManager} cm Control manager to use inorder to create new control.
         * @return {tinymce.ui.Control} New control instance or null if no control was created.
         */
        createControl: function ( n, cm ) {
            return null;
        },

        /**
         * Returns information about the plugin as a name/value array.
         * The current keys are longname, author, authorurl, infourl and version.
         *
         * @return {Object} Name/value array containing information about the plugin.
         */
        getInfo: function () {
            return {
                longname:  'Analytics Opt-Out',
                author:    'WP-Buddy',
                authorurl: 'http://wp-buddy.com',
                infourl:   'http://wp-buddy.com',
                version:   "0.1"
            };
        }
    } );

    // Register plugin
    tinymce.PluginManager.add( 'wpb_analytics_opt_out', tinymce.plugins.WPB_Analytics_Opt_Out );

})( jQuery );