import React, { Fragment, useState, useContext, useEffect } from "react";
import { Dialog, Transition } from '@headlessui/react'
import { XIcon } from '@heroicons/react/outline'
import ItemsEdit from './ItemsEdit'
import AddOrEditEventContext from '../context/AddOrEditEventContext'


const recommendedEventsItemParams = {
  'add_payment_info': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'add_shipping_info': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'add_to_cart': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'add_to_wishlist': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'begin_checkout': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'purchase': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'refund': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'remove_from_cart': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'select_item': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'select_promotion': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'creative_name': { 'type': 'text', 'required': false, 'placeholder': 'summer_banner2' }, 'creative_slot': { 'type': 'text', 'required': false, 'placeholder': 'featured_app_1' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'promotion_id': { 'type': 'text', 'required': false, 'placeholder': 'P_12345' }, 'promotion_name': { 'type': 'text', 'required': false, 'placeholder': 'Summer Sale' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'view_cart': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'view_item': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'view_item_list': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
  'view_promotion': { 'item_id': { 'type': 'text', 'required': true, 'placeholder': 'SKU_12345' }, 'item_name': { 'type': 'text', 'required': true, 'placeholder': 'Stan and Friends Tee' }, 'affiliation': { 'type': 'text', 'required': false, 'placeholder': 'Google Store' }, 'coupon': { 'type': 'text', 'required': false, 'placeholder': 'SUMMER_FUN' }, 'currency': { 'type': 'text', 'required': false, 'placeholder': 'USD' }, 'creative_name': { 'type': 'text', 'required': false, 'placeholder': 'summer_banner2' }, 'creative_slot': { 'type': 'text', 'required': false, 'placeholder': 'featured_app_1' }, 'discount': { 'type': 'number', 'required': false, 'placeholder': '2.22' }, 'index': { 'type': 'number', 'required': false, 'placeholder': '5' }, 'item_brand': { 'type': 'text', 'required': false, 'placeholder': 'Google' }, 'item_category': { 'type': 'text', 'required': false, 'placeholder': 'Apparel' }, 'item_category2': { 'type': 'text', 'required': false, 'placeholder': 'Adult' }, 'item_category3': { 'type': 'text', 'required': false, 'placeholder': 'Shirts' }, 'item_category4': { 'type': 'text', 'required': false, 'placeholder': 'Crew' }, 'item_category5': { 'type': 'text', 'required': false, 'placeholder': 'Short sleeve' }, 'item_list_id': { 'type': 'text', 'required': false, 'placeholder': 'related_products' }, 'item_list_name': { 'type': 'text', 'required': false, 'placeholder': 'Related products' }, 'item_variant': { 'type': 'text', 'required': false, 'placeholder': 'green' }, 'location_id': { 'type': 'text', 'required': false, 'placeholder': 'L_12345' }, 'price': { 'type': 'number', 'required': false, 'placeholder': '9.99' }, 'promotion_id': { 'type': 'text', 'required': false, 'placeholder': 'P_12345' }, 'promotion_name': { 'type': 'text', 'required': false, 'placeholder': 'Summer Sale' }, 'quantity': { 'type': 'number', 'required': false, 'placeholder': '1' } },
};





const ItemForm = ({ eventName, currentItem, setCurrentItem, index, saveItem }) => {
  const { openItemsForm, setOpenItemsForm } = useContext(AddOrEditEventContext)

  function setItemProp(key, value) {
    let data = { ...currentItem };
    data[key] = value;
    setCurrentItem(data);
  }

  function saveForm(e) {
    e.preventDefault();
    saveItem(currentItem, index)
    setCurrentItem({})
    setOpenItemsForm(false)
  }



  return (
    <Transition.Root show={openItemsForm} as={Fragment}>
      <Dialog as="div" className="relative z-[9999991]" onClose={setOpenItemsForm}>
        <Transition.Child
          as={Fragment}
          enter="ease-in-out duration-500"
          enterFrom="opacity-0"
          enterTo="opacity-100"
          leave="ease-in-out duration-500"
          leaveFrom="opacity-100"
          leaveTo="opacity-0"
        >
          <div className="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" />
        </Transition.Child>
        <div className="fixed inset-0" />
        <div className="fixed inset-0 overflow-hidden">
          <div className="absolute inset-0 overflow-hidden">
            <div className="pointer-events-none fixed inset-y-0 right-0 flex w-1/4 min-w-[700px] pl-10">
              <Transition.Child
                as={Fragment}
                enter="transform transition ease-in-out duration-500 sm:duration-700"
                enterFrom="translate-x-full"
                enterTo="translate-x-0"
                leave="transform transition ease-in-out duration-500 sm:duration-700"
                leaveFrom="translate-x-0"
                leaveTo="translate-x-full"
              >
                <Dialog.Panel className="pointer-events-auto w-screen flex-1 ">
                  <form
                    id="item-form"
                    onSubmit={saveForm}
                    className="flex h-full flex-col divide-y divide-gray-200 bg-white shadow-xl">
                    <div data-component="form-wrapper" className="flex min-h-0 flex-1 flex-col">
                      <header className="py-5 pl-10 pr-10 sticky top-0 shadow backdrop-filter backdrop-blur-lg backdrop-saturate-110 bg-opacity-80">
                        <div className="flex items-start justify-between">
                          <Dialog.Title className="text-2xl font-medium text-gray-900"> {index >= 0 ? "Edit" : "New"} Item </Dialog.Title>
                          <div className="ml-3 flex h-7 items-center">
                            <button
                              type="button"
                              className="rounded-md bg-white text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500"
                              onClick={() => setOpenItemsForm(false)}
                            >
                              <span className="sr-only">Close panel</span>
                              <XIcon className="h-6 w-6" aria-hidden="true" />
                            </button>
                          </div>
                        </div>
                      </header>

                      <div data-component="main-form" className="overflow-y-scroll bg-gray-100 p-10">
                        <div data-component="inline-form" className="bg-white w-full p-10 rounded-md">
                          <div data-component="fieldset-wrapper" className="sm:mt-5 space-y-6 sm:space-y-5">

                            {
                              Object.entries(recommendedEventsItemParams[eventName]).map(([key, attributes]) => (
                                <ItemsEdit key={key} pKey={key} pValue={currentItem[key]} required={attributes.required} type={attributes.type} placeholder={attributes.placeholder} setItem={setItemProp} />
                              ))
                            }
                          </div>
                        </div >
                      </div>
                    </div>

                    <footer className="flex flex-shrink-0 justify-end px-4 py-4">
                      <button
                        type="button"
                        className="rounded-md border border-gray-300 bg-white py-2 px-4 text-sm font-medium text-gray-700 shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2"
                        onClick={() => setOpenItemsForm(false)}
                      >
                        Cancel
                      </button>
                      <button
                        type="submit"
                        form="item-form"
                        className="ml-4 inline-flex justify-center rounded-md border border-transparent bg-indigo-600 py-2 px-4 text-sm font-medium text-white shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2"
                      >
                        Save
                      </button>
                    </footer>
                  </form>
                </Dialog.Panel>
              </Transition.Child>
            </div>
          </div>
        </div>
      </Dialog>
    </Transition.Root >

  )

}

export default ItemForm