<?php

namespace Give\Onboarding;

/**
 * Fork of woocommerce/18n/locale-info
 *
 * @since 2.8.0
 * @since 2.11.0 Added KR locale info (#5831)
 */
class LocaleCollection
{

    protected $localeInfo = [
        'AT' => [
            'currency_code' => 'EUR',
            'currency_pos' => 'left',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'AU' => [
            'currency_code' => 'AUD',
            'currency_pos' => 'left',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'BA' => [
            'currency_code' => 'BAM',
            'currency_pos' => 'right_space',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'BD' => [
            'currency_code' => 'BDT',
            'currency_pos' => 'left',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'in',
        ],
        'BE' => [
            'currency_code' => 'EUR',
            'currency_pos' => 'left',
            'thousand_sep' => ' ',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'BR' => [
            'currency_code' => 'BRL',
            'currency_pos' => 'left',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'CA' => [
            'currency_code' => 'CAD',
            'currency_pos' => 'left',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'CH' => [
            'currency_code' => 'CHF',
            'currency_pos' => 'left_space',
            'thousand_sep' => "'",
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'DE' => [
            'currency_code' => 'EUR',
            'currency_pos' => 'left',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'DK' => [
            'currency_code' => 'DKK',
            'currency_pos' => 'left_space',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'ES' => [
            'currency_code' => 'EUR',
            'currency_pos' => 'right',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'FI' => [
            'currency_code' => 'EUR',
            'currency_pos' => 'right_space',
            'thousand_sep' => ' ',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'FR' => [
            'currency_code' => 'EUR',
            'currency_pos' => 'right',
            'thousand_sep' => ' ',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'GB' => [
            'currency_code' => 'GBP',
            'currency_pos' => 'left',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'HU' => [
            'currency_code' => 'HUF',
            'currency_pos' => 'right_space',
            'thousand_sep' => ' ',
            'decimal_sep' => ',',
            'num_decimals' => 0,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'IT' => [
            'currency_code' => 'EUR',
            'currency_pos' => 'right',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'JM' => [
            'currency_code' => 'JMD',
            'currency_pos' => 'left',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'lb',
            'dimension_unit' => 'in',
        ],
        'JP' => [
            'currency_code' => 'JPY',
            'currency_pos' => 'left',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 0,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'KR' => [
            'currency_code' => 'KRW',
            'currency_pos' => 'right',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 0,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'LI' => [
            'currency_code' => 'CHF',
            'currency_pos' => 'left_space',
            'thousand_sep' => "'",
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'MD' => [
            'currency_code' => 'MDL',
            'currency_pos' => 'right_space',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'NL' => [
            'currency_code' => 'EUR',
            'currency_pos' => 'left',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'NO' => [
            'currency_code' => 'Kr',
            'currency_pos' => 'left_space',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'NP' => [
            'currency_code' => 'NPR',
            'currency_pos' => 'left_space',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'PL' => [
            'currency_code' => 'PLN',
            'currency_pos' => 'right_space',
            'thousand_sep' => ' ',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'PY' => [
            'currency_code' => 'PYG',
            'currency_pos' => 'left',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'RO' => [
            'currency_code' => 'RON',
            'currency_pos' => 'right_space',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'RS' => [
            'currency_code' => 'RSD',
            'currency_pos' => 'right_space',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
            'tax_rates' => [],
        ],
        'TH' => [
            'currency_code' => 'THB',
            'currency_pos' => 'left',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'TR' => [
            'currency_code' => 'TRY',
            'currency_pos' => 'left_space',
            'thousand_sep' => '.',
            'decimal_sep' => ',',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
        'US' => [
            'currency_code' => 'USD',
            'currency_pos' => 'left',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'oz',
            'dimension_unit' => 'in',
        ],
        'ZA' => [
            'currency_code' => 'ZAR',
            'currency_pos' => 'left',
            'thousand_sep' => ',',
            'decimal_sep' => '.',
            'num_decimals' => 2,
            'weight_unit' => 'kg',
            'dimension_unit' => 'cm',
        ],
    ];

    public function pluck($key)
    {
        return wp_list_pluck($this->localeInfo, $key);
    }

}
