<?php
/**
 * admin tools "Reset" tab
 *
 * @since  2.5
 *
 * @author Eyal Fitoussi
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Export/Import tab output
 *
 * @access public
 *
 * @since 2.5
 *
 * @author Eyal Fitoussi
 */
function gmw_reset_tab() {
?>
	<?php do_action( 'gmw_reset_gmw_tab_top' ); ?>

	<?php do_action( 'gmw_reset_gmw_tab_before_uninstall' ); ?>

	<div class="gmw-settings-panel gmw-uninstall-gmw-panel">

		<form method="post" action="<?php echo esc_url( admin_url( 'admin.php?page=gmw-tools&tab=reset_gmw' ) ); ?>">

			<fieldset>

				<legend class="gmw-settings-panel-title"><?php esc_html_e( 'Uninstall GEO my WP', 'geo-my-wp' ); ?></legend>

				<div class="gmw-settings-panel-content">

					<div class="gmw-settings-panel-description">

						<?php esc_html_e( 'Use this form to remove some or all of the data that was generated by GEO my WP plugin.', 'geo-my-wp' ); ?>

						<div class="gmw-admin-notice-box gmw-admin-notice-error" style="margin: 25px 0">

							<h3 class="gmw-admin-notice-title"><?php esc_attr_e( 'Proceed With Caution!', 'geo-my-wp' ); ?></h3>

							<div class="gmw-admin-notice-content">

								<div class="gmw-admin-notice-description">
									<?php esc_html_e( 'The actions on this form cannot be undone! Once you remove any of the data below you will not be able to restore it unless you have a backup. You should consider backing up your site before proceeding.', 'geo-my-wp' ); ?>
								</div>
							</div>
						</div>
					</div>

					<div class="gmw-settings-panel-field">

						<h4><?php esc_html_e( 'Check this checkbox to completely remove GEO my WP and all of its data:', 'geo-my-wp' ); ?></h4>

						<p>
							<input
								type="checkbox"
								class="gmw-reset-item"
								name="gmw_reset_items[]"
								value="uninstall"
								onchange="if ( jQuery( this ).is( ':checked' ) ) { jQuery( this ).closest( 'form' ).find( '.gmw-reset-item' ).prop( 'checked', true ); } else { jQuery( this ).closest( 'form' ).find( '.gmw-reset-item' ).prop( 'checked', false ); }"
							/>
							<?php esc_html_e( 'Completely uninstall and deactivate GEO my WP', 'geo-my-wp' ); ?>
						</p>

						<h4><?php esc_html_e( "Or check the checkboxes of the individual items that you would like to remove then click the \"Remove Data\" button:", 'geo-my-wp' ); ?></h4>
						<p>
							<input type="checkbox" class="gmw-reset-item" name="gmw_reset_items[]" value="settings" />
							<?php esc_html_e( 'GEO my WP\'s settings', 'geo-my-wp' ); ?>
						</p>

						<!-- License keys -->
						<p>
							<input type="checkbox" class="gmw-reset-item" name="gmw_reset_items[]" value="licenses" />
							<?php esc_html_e( 'License keys data', 'geo-my-wp' ); ?>
						</p>

						<?php
						global $wpdb;

						//look for places_locator table
						$forms_table = $wpdb->get_results( "SHOW TABLES LIKE '{$wpdb->prefix}gmw_forms'", ARRAY_A );

						//if table exists make it avaliable for uninstallation
						if ( count( $forms_table ) != 0 ) {
						?>
							<!-- forms -->
							<p>
								<input
									type="checkbox"
									class="gmw-reset-item"
									name="gmw_reset_items[]"
									value="forms"
									onchange="jQuery( '#form-table-remove-warning' ).toggle();"
								/>
								<?php esc_html_e( 'Existing forms and forms database table', 'geo-my-wp' ); ?>
							</p>

						<?php
						}

						//look for places_locator table
						$locations_table = $wpdb->get_results( "SHOW TABLES LIKE '{$wpdb->prefix}gmw_locations'", ARRAY_A );

						//if table exists make it avaliable for uninstallation
						if ( count( $locations_table ) != 0 ) {
						?>
							<p>
								<input
									type="checkbox"
									class="gmw-reset-item"
									name="gmw_reset_items[]"
									value="locations_table"
									onchange="jQuery( '#locations-table-remove-warning' ).toggle();"
								/>
								<?php printf( esc_html__( 'GEO my WP\'s locations database table ( %sgmw_locations )', 'geo-my-wp' ), $wpdb->prefix ); ?>
							</p>
						<?php
						}

						//look for places_locator table
						$locaitonmeta_table = $wpdb->get_results( "SHOW TABLES LIKE '{$wpdb->prefix}gmw_locationmeta'", ARRAY_A );

						//if table exists make it avaliable for uninstallation
						if ( count( $locaitonmeta_table ) != 0 ) {
						?>
							<p>
								<input
									type="checkbox"
									class="gmw-reset-item"
									name="gmw_reset_items[]"
									value="locationmeta_table"
									onchange="jQuery( '#locaitonmeta-table-remove-warning' ).toggle();"
								/>
								<?php printf( esc_html__( 'GEO my WP\'s locations meta database table ( %sgmw_locationmeta )', 'geo-my-wp' ), $wpdb->prefix ); ?>
							</p>

						<?php } ?>

						<p>
							<input type="hidden" name="gmw_action" value="reset_data" />

							<?php wp_nonce_field( 'gmw_reset_data_nonce', 'gmw_reset_data_nonce' ); ?>

							<input type="submit" class="gmw-settings-action-button button-primary" value="<?php esc_attr_e( 'Remove Data','geo-my-wp' ); ?>" id="gmw-clear-data-button" />
						</p>
						<script>
							jQuery(document).ready(function($) {
								$( '#gmw-clear-data-button' ).click(function() {
									if ( !jQuery('.gmw-reset-item').is(':checked') ) {
										alert("<?php esc_html_e( 'Check at least one item that you would like to remove.', 'geo-my-wp'); ?>");
										return false;
									} else {
										return confirm( "<?php esc_html_e( 'You are about to permanently remove some or all of GEO my WP data. This action cannot be undone! Would you like to proceed?', 'geo-my-wp'); ?>");
									}
								});
							});
						</script>
					</div>
				</div>
			</fieldset>
		</form>
	</div>
	<?php do_action( 'gmw_reset_gmw_tab_after_uninstall' ); ?>
	<?php do_action( 'gmw_reset_gmw_tab_bottom' ); ?>
	<?php
}
add_action( 'gmw_tools_reset_gmw_tab', 'gmw_reset_tab' );

/**
 * Admin notice.
 *
 * @param  [type] $messages [description].
 *
 * @return [type]           [description]
 */
function gmw_reset_data_notice_message( $messages ) {

	$messages['reset_gmw_data'] = __( 'GEO my WP data cleared.', 'geo-my-wp' );

	return $messages;
}
add_filter( 'gmw_admin_notices_messages', 'gmw_reset_data_notice_message' );

/**
 * Clear GMW data
 *
 * @since 2.5
 * @return void
 */
function gmw_reset_data() {

	// make sure at least one item is checked.
	if ( empty( $_POST['gmw_reset_items'] ) ) {
		wp_die( esc_html__( "You must check at least one checkbox of an item that you'd like to clear.", 'geo-my-wp' ) );
	}

	// look for nonce.
	if ( empty( $_POST['gmw_reset_data_nonce'] ) ) {
		wp_die( esc_html__( 'Cheatin\' eh?!', 'geo-my-wp' ) );
	}

	// varify nonce.
	if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['gmw_reset_data_nonce'] ) ), 'gmw_reset_data_nonce' ) ) {
		wp_die( esc_html__( 'Cheatin\' eh?!', 'geo-my-wp' ) );
	}

	// clear settings.
	if ( in_array( 'settings', $_POST['gmw_reset_items'], true ) ) {
		delete_option( 'gmw_options' );
	}

	// clear forms.
	if ( in_array( 'forms', $_POST['gmw_reset_items'], true ) ) {

		global $wpdb;

		$table_name = esc_sql( $wpdb->prefix ) . 'gmw_forms';
		$sql        = "DROP TABLE IF EXISTS {$table_name}";

		$wpdb->query( $sql ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
	}

	// clear licensess.
	if ( in_array( 'licenses', $_POST['gmw_reset_items'], true ) ) {
		delete_option( 'gmw_license_keys' );
		delete_option( 'gmw_premium_plugin_status' );
	}

	// clear posts table.
	if ( in_array( 'locations_table', $_POST['gmw_reset_items'], true ) ) {

		global $wpdb;

		$table_name = esc_sql( $wpdb->prefix ) . 'gmw_locations';
		$sql        = "DROP TABLE IF EXISTS {$table_name}";

		$wpdb->query( $sql ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
	}

	// clear members table.
	if ( in_array( 'locationmeta_table', $_POST['gmw_reset_items'], true ) ) {

		global $wpdb;

		$table_name = esc_sql( $wpdb->prefix ) . 'gmw_locationmeta';
		$sql        = "DROP TABLE IF EXISTS {$table_name}";

		$wpdb->query( $sql ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
	}

	$page = 'admin.php?page=gmw-tools&tab=reset_gmw&gmw_notice=reset_gmw_data&gmw_notice_status=updated';

	// deactivate GEO my WP.
	if ( in_array( 'uninstall', $_POST['gmw_reset_items'], true ) ) {

		$page = 'index.php';

		deactivate_plugins( GMW_BASENAME );
	}

	wp_safe_redirect( admin_url( $page ) );

	exit;
}
add_action( 'gmw_reset_data', 'gmw_reset_data' );
