<?php
/**
 * Export Import Posts Locator tab
 *
 * @since 2.5
 *
 * @package geo-my-wp
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * GMW_Post_Meta_Fields_Importer class.
 *
 * @since 4.0
 *
 * @author Eyal Fitoussi.
 */
class GMW_Post_Meta_Fields_Importer_Form extends GMW_Meta_Fields_Importer_Form {

	/**
	 * Name singular.
	 *
	 * @var string
	 */
	public $singular_name = 'post custom';

	/**
	 * Slug.
	 *
	 * @var string
	 */
	public $slug = 'post_meta';

	/**
	 * Importer class.
	 *
	 * @var string
	 */
	public $importer_class = 'GMW_Post_Custom_Fields_Importer';

	/**
	 * Importer class.
	 *
	 * @var string
	 */
	public $meta_field_function = 'gmw_get_custom_fields';

	/**
	 * Title.
	 *
	 * @return [type] [description]
	 */
	public function get_title() {
		return __( 'Post Custom Fields Importer', 'geo-my-wp' );
	}

	/**
	 * Get section description.
	 *
	 * @return [type] [description]
	 */
	public function get_description() {
		return __( 'Use this importer to import posts\' location from specific post custom fields into GEO my WP database.', 'geo-my-wp' );
	}
}

/**
 * Export/Import tab output
 *
 * @access public
 *
 * @since 2.5
 *
 * @author Eyal Fitoussi
 */
function gmw_output_posts_locator_import_export_tab() {

	// Posts custom fields importer.
	$post_meta_importer = new GMW_Post_Meta_Fields_Importer_Form();

	$post_meta_importer->output();

	// MapPress importer.
	do_action( 'gmw_import_export_before_mappress_import' ); ?>

	<div class="gmw-settings-panel gmw-export-data-panel">

		<fieldset>

			<legend class="gmw-settings-panel-title"><?php esc_html_e( 'MapPress Plugin Importer', 'geo-my-wp' ); ?></legend>

			<div class="gmw-settings-panel-content">

				<div class="gmw-settings-panel-description">

					<div class="gmw-settings-panel-description">

						<?php esc_html_e( 'Use this form to import locations from MapPress plugin.' ); ?>

						<p><?php esc_html_e( '*Note, since the current version of GEO my WP supports only single location per post, this importer imports only the first location created by MapPress from each post.', 'geo-my-wp' ); ?></p>

					</div>

					<div class="gmw-settings-panel-field">
						<?php
							$cf_importer = new GMW_Map_Press_Importer();
							$cf_importer->output();
						?>
					</div>
				</div>
			</div>
		</fieldset>
	</div>

	<?php

	do_action( 'gmw_import_export_before_geodirectory_import' ); ?>

	<div class="gmw-settings-panel gmw-export-data-panel">

		<fieldset>

			<legend class="gmw-settings-panel-title"><?php esc_html_e( 'WP GeoDirectory Plugin Importer', 'geo-my-wp' ); ?></legend>

			<div class="gmw-settings-panel-content">

				<div class="gmw-settings-panel-description">

					<div class="gmw-settings-panel-description">
						<?php esc_html_e( 'Use this form to import locations from the WP GeoDirectory plugin.' ); ?>
					</div>

					<div class="gmw-settings-panel-field">
						<?php

						if ( class_exists( 'GeoDirectory' ) ) {

							$geodir_importer = new GMW_GeoDirectory_Importer();
							$geodir_importer->output();

						} else {
							?>
							<div class="gmw-admin-notice-box gmw-admin-notice-error"><?php esc_attr_e( 'The WP GeoDirectoty plugin is not actavited.', 'geo-my-wp' ); ?></div>
							<?php
						}
						?>
					</div>
				</div>
			</div>
		</fieldset>
	</div>

	<?php // do_action( 'gmw_import_export_before_mappress_import' ); ?>

	<?php
	/*
	<div class="gmw-settings-panel gmw-export-data-panel">

		<fieldset>

			<legend class="gmw-settings-panel-title"><?php esc_html_e( 'Transfer Posts Location To Another Site.', 'geo-my-wp' ); ?></legend>

			<div class="gmw-settings-panel-content">

				<div class="gmw-settings-panel-description">

					<div class="gmw-settings-panel-description">

						<p><?php esc_html_e( 'This tool will help you in the process of exporting the post\'s locations created on this site and importing them into a different site.', 'geo-my-wp' ); ?></p>

						<p><?php esc_html_e( 'The export button below will save the posts\' location that were generated by GEO my WP into a specific post custom field named "_gmw_post_locations_export".', 'geo-my-wp' ); ?></p>

						<p><?php esc_html_e( 'You will then be able to export those custom fields using the exporting tool of your choice and import them into another site where you will then use the Import tool to import the location from the custom fields back into GEO my WP.', 'geo-my-wp' ); ?></p>

					</div>

					<div class="gmw-settings-panel-field">

						<?php
						$rr = new GMW_Location_To_Meta_Fields_Importer();
						$rr->output();
						?>

						<b><?php esc_html_e( 'To trasnfer the location from this site follow the steps below:', 'geo-my-wp' ); ?></b>
						<ol>
							<li><?php esc_html_e( 'Select the type of locations that you would like to export then click the Export button.', 'geo-my-wp' ); ?>
							<form method="post" enctype="multipart/form-data" action="<?php echo admin_url( 'admin.php?page=gmw-import-export&tab=posts_locator' ); ?>">

								<select name="gmw_meta_export_object_type[]">
									<option value="post"><?php esc_html_e( 'Posts', 'geo-my-wp' ); ?></option>
									<option value="user"><?php esc_html_e( 'Users', 'geo-my-wp' ); ?></option>
									<option value="bp_group"><?php esc_html_e( 'BP Groups', 'geo-my-wp' ); ?></option>
								</select>

								<input type="hidden" name="gmw_action" value="pt_locations_post_meta_export" />

								<?php wp_nonce_field( 'gmw_pt_locations_post_meta_export_nonce', 'gmw_pt_locations_post_meta_export_nonce' ); ?>

								<input type="submit" class="button-secondary gmw-settings-action-button" value="<?php esc_attr_e( 'Export Locations', 'geo-my-wp' ); ?>" />
							</form>
							</li>
							<li><?php printf( __( "The next step will be to export your posts using the native <a href=\"%s\" target=\"blank\"> WordPress export system</a>.", "GMW"), admin_url( 'export.php' ) ); ?></li>
						</ol>
					</div>
					</div>
				</div>
			</div>
		</fieldset>
	</div>*/
	?>

	<?php
}
add_action( 'gmw_import_export_posts_locator_tab', 'gmw_output_posts_locator_import_export_tab' );

/**
 * Locations importer class
 *
 * @since 3.0
 *
 * @author Eyal Fitoussi
 */
class GMW_Post_Custom_Fields_Importer extends GMW_Locations_Importer {

	/**
	 * The object type we importing.
	 *
	 * @var string
	 */
	protected $object_type = 'post';

	/**
	 * Records to import per batch.
	 *
	 * @var integer
	 */
	protected $records_per_batch = 15;

	/**
	 * Form Message.
	 *
	 * @var string
	 */
	public $form_message = '';

	/**
	 * Location meta fields.
	 *
	 * @var array
	 */
	protected $location_meta_fields = array(
		'phone'   => 'phone',
		'fax'     => 'fax',
		'email'   => 'email',
		'website' => 'website',
	);

	/**
	 * Get location to import
	 *
	 * @return [type] [description]
	 */
	public function query_locations() {

		global $wpdb;

		// get meta fields.
		$location_fields = get_option( 'gmw_importer_post_meta_fields' );

		// Count rows only when init the importer.
		$count_rows = absint( $this->total_locations ) === 0 ? 'SQL_CALC_FOUND_ROWS' : '';

		// get posts.
		// phpcs:disable
		$results = $wpdb->get_results(
			$wpdb->prepare(
				"
				SELECT {$count_rows}
				wpposts.ID as object_id,
				wpposts.post_author as user_id,
				wpposts.post_title as title,
				wpposts.post_date as created,
				wpposts.post_modified as updated,
				wppmeta.meta_value as latitude,
				wppmeta1.meta_value as longitude
				FROM {$wpdb->prefix}posts wpposts
				INNER JOIN {$wpdb->prefix}postmeta wppmeta
				ON ( wpposts.ID = wppmeta.post_id )
				INNER JOIN {$wpdb->prefix}postmeta AS wppmeta1
				ON ( wpposts.ID = wppmeta1.post_id )
				AND (
	  			( wppmeta.meta_key = %s AND wppmeta.meta_value NOT IN ('') )
	  			AND
	  			( wppmeta1.meta_key = %s AND wppmeta1.meta_value NOT IN ('') )
				)
				GROUP BY wpposts.ID
				ORDER BY wpposts.ID
				LIMIT %d, %d",
				array(
					$location_fields['latitude'],
					$location_fields['longitude'],
					$this->records_completed,
					$this->records_per_batch,
				)
			)
		); // WPCS: db call ok, cache ok, unprepared SQL ok.
		// phpcs:enable

		// count all rows only when init the importer.
		$this->total_locations = absint( $this->total_locations ) === 0 ? $wpdb->get_var( 'SELECT FOUND_ROWS()' ) : $this->total_locations; // WPCS: db call ok, cache ok, unprepared SQL ok.

		// abort if nothing was found.
		if ( empty( $results ) ) {
			return array();
		}

		// get rest of location data from custom fields.
		foreach ( $results as $post_key => $post ) {

			foreach ( $location_fields as $key => $field ) {

				if ( 'latitude' === $key || 'longitude' === $key || empty( $field ) ) {
					continue;
				}

				$meta = get_post_meta( $post->object_id, $field, true );

				$results[ $post_key ]->$key = ! empty( $meta ) ? $meta : '';
			}
		}

		return $results;
	}
}

/**
 * Locations importer class
 *
 * @since 3.0
 *
 * @author Eyal Fitoussi
 */
class GMW_Map_Press_Importer extends GMW_Locations_Importer {

	/**
	 * The object type we importing.
	 *
	 * @var string
	 */
	protected $object_type = 'post';

	/**
	 * Records to import per batch.
	 *
	 * @var integer
	 */
	protected $records_per_batch = 15;

	/**
	 * Form message.
	 *
	 * @var string
	 */
	public $form_message = '';

	/**
	 * Get location to import
	 *
	 * @return [type] [description]
	 */
	public function query_locations() {

		global $wpdb;

		$table_name = $wpdb->prefix . 'mappress_maps';

		// look for Mappress DB table.
		$table = $wpdb->get_results( "SHOW TABLES LIKE '{$table_name}'", ARRAY_A ); // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, db call ok, cache ok, unprepared SQL ok.

		// abort if no table exist.
		if ( count( $table ) === 0 ) {
			/* translators: %s database table name. */
			wp_die( sprintf( esc_attr__( '%s database table cannot be found.', 'geo-my-wp' ), esc_attr( $table_name ) ) );
		}

		// count rows only when init the importer.
		$count_rows = absint( $this->total_locations ) === 0 ? 'SQL_CALC_FOUND_ROWS' : '';

		// get posts.
		// phpcs:disable
		$results = $wpdb->get_results(
			$wpdb->prepare(
				"
				SELECT DISTINCT {$count_rows}
				mpposts.*,
				mpmaps.obj
				FROM {$wpdb->prefix}mappress_posts mpposts
				INNER JOIN {$wpdb->prefix}mappress_maps mpmaps
				ON mpposts.mapid = mpmaps.mapid
				GROUP BY mpposts.postid
				LIMIT %d, %d",
				array(
					$this->records_completed,
					$this->records_per_batch,
				)
			)
		); // WPCS: db call ok, cache ok, unprepared SQL ok.
		// phpcs:enable

		// count all rows only when init the importer.
		$this->total_locations = absint( $this->total_locations ) === 0 ? $wpdb->get_var( 'SELECT FOUND_ROWS()' ) : $this->total_locations; // WPCS: db call ok, cache ok, unprepared SQL ok.

		// abort if nothing was found.
		if ( empty( $results ) ) {
			return array();
		}

		$output = array();

		foreach ( $results as $location ) {

			$post_id  = $location->postid;
			$location = maybe_unserialize( $location->obj );

			if ( ! empty( $location->pois ) && ! empty( $location->center['lat'] ) && ! empty( $location->center['lng'] ) ) {

				$location_args                      = array();
				$location_args['object_id']         = $post_id;
				$location_args['title']             = get_the_title( $post_id );
				$location_args['latitude']          = $location->center['lat'];
				$location_args['longitude']         = $location->center['lng'];
				$location_args['address']           = $location->pois[0]->address;
				$location_args['formatted_address'] = $location->pois[0]->correctedAddress;

				$output[] = $location_args;
			}
		}

		return (object) $output;
	}
}
add_action( 'gmw_mappress_import', 'gmw_mappress_import' );

/**
 * WP GeoDirectory Locations importer class.
 *
 * @since 4.0
 *
 * @author Eyal Fitoussi
 */
class GMW_GeoDirectory_Importer extends GMW_Locations_Importer {

	/**
	 * The object type we importing.
	 *
	 * @var string
	 */
	protected $object_type = 'post';

	/**
	 * Records to import per batch.
	 *
	 * @var integer
	 */
	protected $records_per_batch = 15;

	/**
	 * Form message.
	 *
	 * @var string
	 */
	public $form_message = '';

	/**
	 * Get location to import
	 *
	 * @return [type] [description]
	 */
	public function query_locations() {

		global $wpdb;

		$table_name = $wpdb->prefix . 'geodir_gd_place_detail';

		// look for GeoDirectory DB table.
		$table = $wpdb->get_results( "SHOW TABLES LIKE '{$table_name}'", ARRAY_A ); // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, db call ok, cache ok, unprepared SQL ok.

		// abort if no table exist.
		if ( count( $table ) === 0 ) {
			/* translators: %s database table name. */
			wp_die( sprintf( esc_attr__( '%s database table cannot be found.', 'geo-my-wp' ), esc_attr( $table_name ) ) );
		}

		// count rows only when init the importer.
		$count_rows = absint( $this->total_locations ) === 0 ? 'SQL_CALC_FOUND_ROWS' : '';

		// get posts.
		// phpcs:disable
		$results = $wpdb->get_results(
			$wpdb->prepare(
				"
				SELECT DISTINCT {$count_rows}
				geodir.*
				FROM {$table_name} geodir
				LIMIT %d, %d",
				array(
					$this->records_completed,
					$this->records_per_batch,
				)
			)
		); // WPCS: db call ok, cache ok, unprepared SQL ok.
		// phpcs:enable

		// count all rows only when init the importer.
		$this->total_locations = absint( $this->total_locations ) === 0 ? $wpdb->get_var( 'SELECT FOUND_ROWS()' ) : $this->total_locations; // WPCS: db call ok, cache ok, unprepared SQL ok.

		// abort if nothing was found.
		if ( empty( $results ) ) {
			return array();
		}

		$output = array();

		foreach ( $results as $location ) {

			if ( empty( $location->post_id ) ) {
				continue;
			}

			$address_fields = array( 'street', 'street_2', 'city', 'region', 'zip', 'country' );
			$address        = '';
			$location_args  = array(
				'object_id' => $location->post_id,
				'title'     => $location->post_title,
			);

			foreach ( $address_fields as $address_field ) {

				if ( empty( $location->$address_field ) ) {
					continue;
				}

				if ( 'street' === $address_field ) {

					$address                .= $location->$address_field . ', ';
					$location_args['street'] = $location->$address_field;

				} elseif ( 'city' === $address_field ) {

					$address              .= $location->$address_field . ', ';
					$location_args['city'] = $location->$address_field;

				} elseif ( 'region' === $address_field ) {

					$address                     .= $location->$address_field . ' ';
					$location_args['region_name'] = $location->$address_field;

				} elseif ( 'zip' === $address_field ) {

					$address                  .= $location->$address_field . ', ';
					$location_args['postcode'] = $location->$address_field;

				} elseif ( 'country' === $address_field ) {

					$location_args['country_name'] = $location->$address_field;

					// get list of countries code. We will use it to make sure that the only the country code passes to the column.
					$countries = gmw_get_countries_list_array();

					// look for the country code based on the country name.
					$country_code = array_search( ucwords(  $location->$address_field ), $countries, true );

					$location_args['country_code'] = '';

					// get the country code from the list.
					if ( ! empty( $country_code ) ) {
						$address                      .= $country_code;
						$location_args['country_code'] = $country_code;
					} else {
						$address                      .= $location->$address_field;
						$location_args['country_code'] = '';
					}
				}
			}

			$location_args['latitude']          = $location->latitude;
			$location_args['longitude']         = $location->longitude;
			$location_args['address']           = $address;
			$location_args['formatted_address'] = $address;

			$output[] = $location_args;
		}

		return (object) $output;
	}
}
add_action( 'gmw_geodirectory_import', 'gmw_geodirectory_import' );
