<?php
/**
 * This template displays the single Product.
 *
 * @package Genesis_Connect_WooCommerce
 * @version 0.9.8
 * @since 0.9.0
 *
 * Note for customisers/users: Do not edit this file!
 * ==================================================
 * If you want to customise this template, copy this file (keep same name) and place the
 * copy in the child theme's woocommerce folder, ie themes/my-child-theme/woocommerce
 * (Your theme may not have a 'woocommerce' folder, in which case create one.)
 * The version in the child theme's woocommerce folder will override this template, and
 * any future updates to this plugin won't wipe out your customisations.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

remove_action( 'genesis_loop', 'genesis_do_loop' );
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );

add_action( 'genesis_loop', 'gencwooc_single_product_loop' );
/**
 * Displays single product loop.
 *
 * Uses WooCommerce structure and contains all existing WooCommerce hooks.
 *
 * Code based on WooCommerce 1.5.5 woocommerce_single_product_content().
 *
 * @see woocommerce/woocommerce-template.php
 *
 * @since 0.9.0
 */
function gencwooc_single_product_loop() {

	do_action( 'woocommerce_before_main_content' );

	$wc_query = apply_filters( 'gencwooc_custom_query', false );

	if ( ! $wc_query ) {
		global $wp_query;

		$wc_query = $wp_query;
	}

	if ( $wc_query->have_posts() ) {
		while ( $wc_query->have_posts() ) {
			$wc_query->the_post();

			do_action( 'woocommerce_before_single_product' );
			?>

			<div id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
				<?php do_action( 'woocommerce_before_single_product_summary' ); ?>

				<div class="summary">
					<?php do_action( 'woocommerce_single_product_summary' ); ?>
				</div>

				<?php do_action( 'woocommerce_after_single_product_summary' ); ?>
			</div>

			<?php
			do_action( 'woocommerce_after_single_product' );
		}
	}

	do_action( 'woocommerce_after_main_content' );

}

genesis();
