<?php
/**
 * Register layouts and sections for the Layout block.
 *
 * @package Genesis\Blocks
 */

namespace Genesis\Blocks\Layouts;

add_action( 'init', __NAMESPACE__ . '\register_components', 11 );
/**
 * Registers section and layout components.
 *
 * @since 2.0
 */
function register_components() {
	/**
	 * Manually register patterns
	 */
	genesis_blocks_register_layout_component(
		[
			'type'     => 'layout',
			'key'      => 'gb_layout_business_1',
			'name'     => esc_html__( 'Business', 'genesis-blocks' ),
			'content'  => "<!-- wp:genesis-blocks/gb-container {\"containerWidth\":\"full\",\"className\":\"gb-layout-business-1\"} --> <div class=\"wp-block-genesis-blocks-gb-container gb-layout-business-1 gb-block-container alignfull\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:1600px\"><!-- wp:genesis-blocks/gb-container {\"containerPaddingTop\":10,\"containerPaddingRight\":5,\"containerPaddingBottom\":10,\"containerPaddingLeft\":5,\"containerWidth\":\"full\",\"containerMaxWidth\":850,\"containerBackgroundColor\":\"#0b0b0b\",\"containerImgID\":3854,\"className\":\"gb-layout-hero-1\"} --> <div style=\"background-color:#0b0b0b;padding-left:5%;padding-right:5%;padding-bottom:10%;padding-top:10%\" class=\"wp-block-genesis-blocks-gb-container gb-layout-hero-1 gb-block-container alignfull\"><div class=\"gb-container-inside\"><div class=\"gb-container-image-wrap\"><img class=\"gb-container-image has-background-dim\" src=\"https://demo.studiopress.com/page-builder/gb-placeholder-hero.jpg\" alt=\"hero header placeholder\"/></div><div class=\"gb-container-content\" style=\"max-width:850px\"><!-- wp:heading {\"align\":\"center\",\"className\":\"gb-white-text\"} --> <h2 style=\"text-align:center\" class=\"gb-white-text\">The future of website creation is here.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"align\":\"center\",\"customTextColor\":\"#ffffff\"} --> <p style=\"color:#ffffff;text-align:center\" class=\"has-text-color\">With Genesis and Genesis Blocks, you can build beautiful, powerful websites in minutes with our robust theme framework and professionally-designed sections and layouts</p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-button {\"buttonText\":\"Launch your new site!\",\"buttonAlignment\":\"center\"} --> <div style=\"text-align:center\" class=\"wp-block-genesis-blocks-gb-button gb-block-button\"><a href=\"#\" class=\"gb-button gb-button-shape-rounded gb-button-size-medium\" style=\"color:#ffffff;background-color:#3373dc\">Launch your new site!</a></div> <!-- /wp:genesis-blocks/gb-button --></div></div></div> <!-- /wp:genesis-blocks/gb-container --> <!-- wp:genesis-blocks/gb-columns {\"columns\":1,\"layout\":\"one-column\",\"paddingTop\":10,\"paddingRight\":5,\"paddingBottom\":10,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customBackgroundColor\":\"#f1f1f1\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-service-2\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-service-2 gb-layout-columns-1 one-column gb-has-custom-background-color gb-columns-center\" style=\"padding-top:10%;padding-right:5%;padding-bottom:10%;padding-left:5%;background-color:#f1f1f1\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-container {\"containerMarginBottom\":5,\"containerMaxWidth\":700} --> <div style=\"margin-bottom:5%\" class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:700px\"><!-- wp:heading {\"align\":\"center\"} --> <h2 style=\"text-align:center\">Beautiful, responsive layouts ready to use.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"align\":\"center\"} --> <p style=\"text-align:center\">The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress.</p> <!-- /wp:paragraph --></div></div></div> <!-- /wp:genesis-blocks/gb-container --> <!-- wp:genesis-blocks/gb-columns {\"columns\":4,\"layout\":\"gb-4-col-equal\",\"marginBottom\":3,\"marginUnit\":\"%\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-4 gb-4-col-equal\" style=\"margin-bottom:3%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>From the Genesis Lab</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Rock Solid Standards</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Sites Built To Last</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Beautiful Designs</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-button {\"buttonText\":\"Start building your site!\",\"buttonAlignment\":\"center\",\"buttonBackgroundColor\":\"#0073e5\",\"buttonSize\":\"gb-button-size-large\"} --> <div style=\"text-align:center\" class=\"wp-block-genesis-blocks-gb-button gb-block-button\"><a href=\"#\" class=\"gb-button gb-button-shape-rounded gb-button-size-large\" style=\"color:#ffffff;background-color:#0073e5\">Start building your site!</a></div> <!-- /wp:genesis-blocks/gb-button --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\",\"columnsGap\":5,\"paddingTop\":10,\"paddingRight\":5,\"paddingBottom\":10,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-service-3\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-service-3 gb-layout-columns-2 gb-2-col-equal gb-columns-center\" style=\"padding-top:10%;padding-right:5%;padding-bottom:10%;padding-left:5%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-5 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:image {\"id\":3852} --> <figure class=\"wp-block-image\"><img src=\"https://demo.studiopress.com/page-builder/gb-square-placeholder.jpg\" alt=\"GB Square Placeholder\" class=\"wp-image-3852\"/></figure> <!-- /wp:image --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column {\"columnVerticalAlignment\":\"center\"} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column gb-is-vertically-aligned-center\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>Build blazing websites with Genesis and Genesis Blocks. <br></h2> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress, bringing it in line with modern coding standards, and aligning with open web initiatives. That sounds pretty great huh?</p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-button {\"buttonText\":\"Try Genesis Blocks Today\",\"buttonBackgroundColor\":\"#0073e5\"} --> <div class=\"wp-block-genesis-blocks-gb-button gb-block-button\"><a href=\"#\" class=\"gb-button gb-button-shape-rounded gb-button-size-medium\" style=\"color:#ffffff;background-color:#0073e5\">Try Genesis Blocks Today</a></div> <!-- /wp:genesis-blocks/gb-button --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\",\"columnsGap\":6,\"paddingTop\":10,\"paddingRight\":5,\"paddingBottom\":10,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customBackgroundColor\":\"#f1f1f1\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-service-4\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-service-4 gb-layout-columns-2 gb-2-col-equal gb-has-custom-background-color gb-columns-center\" style=\"padding-top:10%;padding-right:5%;padding-bottom:10%;padding-left:5%;background-color:#f1f1f1\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-6 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>Build creative layouts in minutes with our professionally-designed sections and layouts.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"customFontSize\":22} --> <p style=\"font-size:22px\">The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress, bringing it in line with modern coding standards, and aligning with open web initiatives. </p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-spacer {\"spacerDivider\":true} --> <div style=\"color:#ddd\" class=\"wp-block-genesis-blocks-gb-spacer gb-block-spacer gb-divider-solid gb-spacer-divider gb-divider-size-1\"><hr style=\"height:30px\"/></div> <!-- /wp:genesis-blocks/gb-spacer --> <!-- wp:heading {\"level\":3} --> <h3>Sites Built to Last</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress and aligning with open web initiatives. </p> <!-- /wp:paragraph --> <!-- wp:heading {\"level\":3} --> <h3>From the WPE Lab</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress and aligning with open web initiatives. </p> <!-- /wp:paragraph --> <!-- wp:heading {\"level\":3} --> <h3>Built-in Templates</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress and aligning with open web initiatives. </p> <!-- /wp:paragraph --> <!-- wp:paragraph --> <p><br></p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:image {\"id\":11445} --> <figure class=\"wp-block-image\"><img src=\"https://demo.studiopress.com/page-builder/gb-placeholder-tall.jpg\" alt=\"\" class=\"wp-image-11445\"/></figure> <!-- /wp:image --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":1,\"layout\":\"one-column\",\"paddingTop\":10,\"paddingRight\":5,\"paddingBottom\":10,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customBackgroundColor\":\"#ffffff\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-team-1\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-team-1 gb-layout-columns-1 one-column gb-has-custom-background-color gb-columns-center\" style=\"padding-top:10%;padding-right:5%;padding-bottom:10%;padding-left:5%;background-color:#ffffff\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-container {\"containerMarginBottom\":5,\"containerMaxWidth\":700} --> <div style=\"margin-bottom:5%\" class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:700px\"><!-- wp:heading {\"align\":\"center\"} --> <h2 style=\"text-align:center\">Meet our amazing team.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"align\":\"center\"} --> <p style=\"text-align:center\">We're a talented group of creative individuals interested in art, cinematography, design, music, and all niches in between.</p> <!-- /wp:paragraph --></div></div></div> <!-- /wp:genesis-blocks/gb-container --> <!-- wp:genesis-blocks/gb-columns {\"columns\":3,\"layout\":\"gb-3-col-equal\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-3 gb-3-col-equal\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10230} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10230\" src=\"https://demo.studiopress.com/page-builder/person-m-1.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Kyle Zion</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">Screenprinter</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10211} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10211\" src=\"https://demo.studiopress.com/page-builder/person-w-3.jpg\" alt=\"\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Fran Acadia</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">People Engineer</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10225} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10225\" src=\"https://demo.studiopress.com/page-builder/person-m-3.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Giannis Teton</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">Office Manager</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":3,\"layout\":\"gb-3-col-equal\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-3 gb-3-col-equal\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10230} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10230\" src=\"https://demo.studiopress.com/page-builder/person-w-5.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Mandi Arches</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">Lead Designer</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10211} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10211\" src=\"https://demo.studiopress.com/page-builder/person-m-2.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Walter Bryce</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">Lead Developer</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10225} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10225\" src=\"https://demo.studiopress.com/page-builder/person-w-1.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Kim Rainier</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">Support Specialist</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":1,\"layout\":\"one-column\",\"paddingTop\":10,\"paddingRight\":5,\"paddingBottom\":10,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customBackgroundColor\":\"#f1f1f1\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-testimonial-1\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-testimonial-1 gb-layout-columns-1 one-column gb-has-custom-background-color gb-columns-center\" style=\"padding-top:10%;padding-right:5%;padding-bottom:10%;padding-left:5%;background-color:#f1f1f1\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-container {\"containerMarginBottom\":5,\"containerMaxWidth\":700} --> <div style=\"margin-bottom:5%\" class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:700px\"><!-- wp:heading {\"align\":\"center\"} --> <h2 style=\"text-align:center\">See what our customers are saying.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"align\":\"center\"} --> <p style=\"text-align:center\">Our happy customers have a lot to say about our products and services!</p> <!-- /wp:paragraph --></div></div></div> <!-- /wp:genesis-blocks/gb-container --> <!-- wp:genesis-blocks/gb-columns {\"columns\":3,\"layout\":\"gb-3-col-equal\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-3 gb-3-col-equal\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column {\"padding\":15} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10230,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>It’s really great how easy your websites are to update and manage. I never have any problem at all!</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-w-4.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Mary Sequoia</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Author</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --> <!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10230,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>My new site is so much faster and easier to work with than my old site. It used to take me an hour or more to update a page.</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-m-5.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Marcus Alpine</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Author</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --> <!-- wp:paragraph --> <p></p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10211,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>My new site is so much faster and easier to work with than my old site. It used to take me an hour or more to update a page.</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-m-1.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Philip Glacier</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Publisher</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --> <!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10211,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>It’s really great how easy your websites are to update and manage. I never have any problem at all!</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-w-1.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Robin Yellowstone</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Publisher</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10230,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>It’s almost like having a designer right here with me. I just choose the page, make the change and click save. It’s so simple.</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-w-3.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Amy Redwood</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Consultant</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --> <!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10230,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>I can't believe how good the customer support is on this product. I'm used to waiting weeks to hear back. Not any longer!</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-m-3.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Rob Badland</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Consultant</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\",\"columnsGap\":5,\"paddingTop\":10,\"paddingRight\":5,\"paddingBottom\":10,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-contact-1\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-contact-1 gb-layout-columns-2 gb-2-col-equal gb-columns-center\" style=\"padding-top:10%;padding-right:5%;padding-bottom:10%;padding-left:5%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-5 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column {\"columnVerticalAlignment\":\"center\"} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column gb-is-vertically-aligned-center\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>Contact us to get started.</h2> <!-- /wp:heading --> <!-- wp:paragraph --> <p>We'd love to hear from you and build out your next dream project. Drop us a line and we'll get back to you as soon as we can!</p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-container --> <div class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:1600px\"><!-- wp:paragraph --> <p><strong>NASA Mission Control Center</strong><br>Clear Lake, Houston, TX 77058</p> <!-- /wp:paragraph --> <!-- wp:paragraph --> <p>Email: hello@example.com<br>Phone: 800-854-5841</p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-button {\"buttonText\":\"Drop us an email!\"} --> <div class=\"wp-block-genesis-blocks-gb-button gb-block-button\"><a href=\"mailto:name@example.com\" class=\"gb-button gb-button-shape-rounded gb-button-size-medium\" style=\"color:#ffffff;background-color:#3373dc\">Drop us an email!</a></div> <!-- /wp:genesis-blocks/gb-button --> <!-- wp:paragraph --> <p></p> <!-- /wp:paragraph --></div></div></div> <!-- /wp:genesis-blocks/gb-container --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column {\"columnVerticalAlignment\":\"center\"} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column gb-is-vertically-aligned-center\"><div class=\"gb-block-layout-column-inner\"><!-- wp:html --> <iframe src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3470.5670865756474!2d-95.09152774886842!3d29.558099181973784!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x86409da671292593%3A0xf684f098a7237a30!2sNASA+Mission+Control+Center!5e0!3m2!1sen!2sus!4v1560875318343!5m2!1sen!2sus\" width=\"600\" height=\"450\" frameborder=\"0\" style=\"border:0\" allowfullscreen=\"\"></iframe> <!-- /wp:html --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --></div></div></div> <!-- /wp:genesis-blocks/gb-container -->",
			'category' => [ esc_html__( 'business', 'genesis-blocks' ) ],
			'keywords' => [
				esc_html__( 'business', 'genesis-blocks' ),
				esc_html__( 'service', 'genesis-blocks' ),
				esc_html__( 'product', 'genesis-blocks' ),
			],
			'image'    => 'https://demo.studiopress.com/page-builder/gb-layout-business-1.jpg',
		]
	);

	genesis_blocks_register_layout_component(
		[
			'type'     => 'layout',
			'key'      => 'gb_layout_landing_1',
			'name'     => esc_html__( 'Product Launch', 'genesis-blocks' ),
			'content'  => "<!-- wp:genesis-blocks/gb-container {\"containerWidth\":\"full\",\"className\":\"gb-layout-landing-1\"} --> <div class=\"wp-block-genesis-blocks-gb-container gb-layout-landing-1 gb-block-container alignfull\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:1600px\"><!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\",\"marginUnit\":\"%\",\"paddingTop\":10,\"paddingRight\":5,\"paddingBottom\":10,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customBackgroundColor\":\"#2b2953\",\"columnMaxWidth\":1200} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-2 gb-2-col-equal gb-has-custom-background-color gb-columns-center\" style=\"padding-top:10%;padding-right:5%;padding-bottom:10%;padding-left:5%;background-color:#2b2953\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column {\"customBackgroundColor\":\"#5f58e5\",\"customTextColor\":\"#ffffff\",\"paddingSync\":true,\"paddingUnit\":\"%\",\"padding\":8,\"columnVerticalAlignment\":\"center\"} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column gb-is-vertically-aligned-center\"><div class=\"gb-block-layout-column-inner gb-has-custom-background-color gb-has-custom-text-color\" style=\"padding:8%;background-color:#5f58e5;color:#ffffff\"><!-- wp:heading --> <h2>Launch your latest product with Genesis Blocks layouts! </h2> <!-- /wp:heading --> <!-- wp:paragraph --> <p>Use the professionally-designed sections and layouts to launch your new product site, complete with a Mailchimp email newsletter block.</p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-newsletter {\"instanceId\":0} /--></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:image {\"id\":11790} --> <figure class=\"wp-block-image\"><img src=\"https://demo.studiopress.com/page-builder/gb-placeholder-illustration-4.png\" alt=\"\" class=\"wp-image-11790\"/></figure> <!-- /wp:image --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":1,\"layout\":\"one-column\",\"paddingTop\":10,\"paddingRight\":5,\"paddingBottom\":10,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-service-2\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-service-2 gb-layout-columns-1 one-column gb-columns-center\" style=\"padding-top:10%;padding-right:5%;padding-bottom:10%;padding-left:5%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-container {\"containerMarginBottom\":5,\"containerMaxWidth\":700} --> <div style=\"margin-bottom:5%\" class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:700px\"><!-- wp:heading {\"align\":\"center\"} --> <h2 style=\"text-align:center\">Beautiful, responsive layouts ready to use.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"align\":\"center\"} --> <p style=\"text-align:center\">Add beautiful illustrations from UnDraw, a constantly updated collection of images that you can use completely free in your sections and layouts. Or add your own!</p> <!-- /wp:paragraph --></div></div></div> <!-- /wp:genesis-blocks/gb-container --> <!-- wp:genesis-blocks/gb-columns {\"columns\":3,\"layout\":\"gb-3-col-equal\",\"marginBottom\":3,\"marginUnit\":\"%\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-3 gb-3-col-equal\" style=\"margin-bottom:3%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:image {\"align\":\"center\",\"id\":11799,\"width\":230} --> <div class=\"wp-block-image\"><figure class=\"aligncenter is-resized\"><img src=\"https://demo.studiopress.com/page-builder/gb-placeholder-illustration-1-500px.png\" alt=\"\" class=\"wp-image-11799\" width=\"230\"/></figure></div> <!-- /wp:image --> <!-- wp:heading {\"level\":3} --> <h3>From the Genesis Lab</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:image {\"align\":\"center\",\"id\":11798,\"width\":230} --> <div class=\"wp-block-image\"><figure class=\"aligncenter is-resized\"><img src=\"https://demo.studiopress.com/page-builder/gb-placeholder-illustration-2-500px.png\" alt=\"\" class=\"wp-image-11798\" width=\"230\"/></figure></div> <!-- /wp:image --> <!-- wp:heading {\"level\":3} --> <h3>Rock Solid Standards</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:image {\"align\":\"center\",\"id\":11831,\"width\":270} --> <div class=\"wp-block-image\"><figure class=\"aligncenter is-resized\"><img src=\"https://demo.studiopress.com/page-builder/gb-placeholder-illustration-3-500px.png\" alt=\"\" class=\"wp-image-11831\" width=\"270\"/></figure></div> <!-- /wp:image --> <!-- wp:heading {\"level\":3} --> <h3>Sites Built To Last</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":1,\"layout\":\"one-column\",\"paddingTop\":10,\"paddingRight\":5,\"paddingBottom\":10,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customTextColor\":\"#ffffff\",\"customBackgroundColor\":\"#2b2953\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-testimonial-1\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-testimonial-1 gb-layout-columns-1 one-column gb-has-custom-background-color gb-has-custom-text-color gb-columns-center\" style=\"padding-top:10%;padding-right:5%;padding-bottom:10%;padding-left:5%;background-color:#2b2953;color:#ffffff\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-container {\"containerMarginBottom\":5,\"containerMaxWidth\":700} --> <div style=\"margin-bottom:5%\" class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:700px\"><!-- wp:heading {\"align\":\"center\"} --> <h2 style=\"text-align:center\">See what they're saying.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"align\":\"center\"} --> <p style=\"text-align:center\">Our happy customers have a lot to say about our products and services!</p> <!-- /wp:paragraph --></div></div></div> <!-- /wp:genesis-blocks/gb-container --> <!-- wp:genesis-blocks/gb-columns {\"columns\":3,\"layout\":\"gb-3-col-equal\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-3 gb-3-col-equal\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column {\"padding\":15} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10230,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>It’s really great how easy your websites are to update and manage. I never have any problem at all!</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-w-4.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Mary Sequoia</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Author</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10211,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>My new site is so much faster and easier to work with than my old site. It used to take me an hour or more to update a page.</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-m-1.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Philip Glacier</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Publisher</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10230,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>It’s almost like having a designer right here with me. I just choose the page, make the change and click save. It’s so simple.</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-w-3.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Amy Redwood</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Consultant</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-container {\"containerPaddingTop\":10,\"containerPaddingRight\":5,\"containerPaddingBottom\":10,\"containerPaddingLeft\":5,\"containerMaxWidth\":1200} --> <div style=\"padding-left:5%;padding-right:5%;padding-bottom:10%;padding-top:10%\" class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-pricing {\"columns\":3} --> <div class=\"wp-block-genesis-blocks-gb-pricing gb-pricing-columns-3\"><div class=\"gb-pricing-table-wrap gb-block-pricing-table-gap-2\"><!-- wp:genesis-blocks/gb-pricing-table {\"borderWidth\":0,\"backgroundColor\":\"#ebebef\",\"padding\":8} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table gb-block-pricing-table-center gb-block-pricing-table\" itemscope itemtype=\"http://schema.org/Product\"><div class=\"gb-block-pricing-table-inside\" style=\"background-color:#ebebef;padding:8%\"><!-- wp:genesis-blocks/gb-pricing-table-title {\"title\":\"\u003cstrong\u003eFreelancer\u003c/strong\u003e\",\"fontSize\":\"medium\",\"paddingTop\":30} --> <div itemprop=\"name\" style=\"padding-top:30px;padding-right:20px;padding-bottom:10px;padding-left:20px\" class=\"wp-block-genesis-blocks-gb-pricing-table-title gb-pricing-table-title has-medium-font-size\"><strong>Freelancer</strong></div> <!-- /wp:genesis-blocks/gb-pricing-table-title --> <!-- wp:genesis-blocks/gb-pricing-table-subtitle {\"subtitle\":\"Our essentials package with tools for freelancers.\",\"customFontSize\":20} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table-subtitle gb-pricing-table-subtitle\" style=\"font-size:20px;padding-top:10px;padding-right:20px;padding-bottom:10px;padding-left:20px\">Our essentials package with tools for freelancers.</div> <!-- /wp:genesis-blocks/gb-pricing-table-subtitle --> <!-- wp:genesis-blocks/gb-pricing-table-price {\"price\":\"49\",\"currency\":\"$\",\"term\":\"/mo\"} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table-price gb-pricing-table-price-wrap gb-pricing-has-currency\" style=\"padding-top:10px;padding-right:20px;padding-bottom:10px;padding-left:20px\"><div itemprop=\"offers\" itemscope itemtype=\"http://schema.org/Offer\"><span itemprop=\"priceCurrency\" class=\"gb-pricing-table-currency\" style=\"font-size:24px\">$</span><div itemprop=\"price\" class=\"gb-pricing-table-price\" style=\"font-size:60px\">49</div><span class=\"gb-pricing-table-term\" style=\"font-size:24px\">/mo</span></div></div> <!-- /wp:genesis-blocks/gb-pricing-table-price --> <!-- wp:genesis-blocks/gb-pricing-table-features {\"customFontSize\":20,\"paddingTop\":15,\"paddingBottom\":15} --> <ul itemprop=\"description\" class=\"wp-block-genesis-blocks-gb-pricing-table-features gb-pricing-table-features gb-list-border-none gb-list-border-width-1\" style=\"font-size:20px;padding-top:15px;padding-right:20px;padding-bottom:15px;padding-left:20px\"><li>Product Feature One</li><li>Product Feature Two</li><li>Product Feature Three</li></ul> <!-- /wp:genesis-blocks/gb-pricing-table-features --> <!-- wp:genesis-blocks/gb-pricing-table-button {\"buttonText\":\"Buy Now\",\"buttonBackgroundColor\":\"#5f58e5\",\"paddingTop\":15,\"paddingBottom\":35} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table-button gb-pricing-table-button\" style=\"padding-top:15px;padding-right:20px;padding-bottom:35px;padding-left:20px\"><div class=\"gb-block-button\"><a class=\"gb-button gb-button-shape-rounded gb-button-size-medium\" style=\"color:#ffffff;background-color:#5f58e5\">Buy Now</a></div></div> <!-- /wp:genesis-blocks/gb-pricing-table-button --></div></div> <!-- /wp:genesis-blocks/gb-pricing-table --> <!-- wp:genesis-blocks/gb-pricing-table {\"borderWidth\":0,\"backgroundColor\":\"#ebebef\",\"padding\":8} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table gb-block-pricing-table-center gb-block-pricing-table\" itemscope itemtype=\"http://schema.org/Product\"><div class=\"gb-block-pricing-table-inside\" style=\"background-color:#ebebef;padding:8%\"><!-- wp:genesis-blocks/gb-pricing-table-title {\"title\":\"\u003cstrong\u003eAgency\u003c/strong\u003e\",\"fontSize\":\"medium\",\"paddingTop\":30} --> <div itemprop=\"name\" style=\"padding-top:30px;padding-right:20px;padding-bottom:10px;padding-left:20px\" class=\"wp-block-genesis-blocks-gb-pricing-table-title gb-pricing-table-title has-medium-font-size\"><strong>Agency</strong></div> <!-- /wp:genesis-blocks/gb-pricing-table-title --> <!-- wp:genesis-blocks/gb-pricing-table-subtitle {\"subtitle\":\"More tools for active agencies with large client bases.\",\"customFontSize\":20} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table-subtitle gb-pricing-table-subtitle\" style=\"font-size:20px;padding-top:10px;padding-right:20px;padding-bottom:10px;padding-left:20px\">More tools for active agencies with large client bases.</div> <!-- /wp:genesis-blocks/gb-pricing-table-subtitle --> <!-- wp:genesis-blocks/gb-pricing-table-price {\"price\":\"89\",\"currency\":\"$\",\"term\":\"/mo\"} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table-price gb-pricing-table-price-wrap gb-pricing-has-currency\" style=\"padding-top:10px;padding-right:20px;padding-bottom:10px;padding-left:20px\"><div itemprop=\"offers\" itemscope itemtype=\"http://schema.org/Offer\"><span itemprop=\"priceCurrency\" class=\"gb-pricing-table-currency\" style=\"font-size:24px\">$</span><div itemprop=\"price\" class=\"gb-pricing-table-price\" style=\"font-size:60px\">89</div><span class=\"gb-pricing-table-term\" style=\"font-size:24px\">/mo</span></div></div> <!-- /wp:genesis-blocks/gb-pricing-table-price --> <!-- wp:genesis-blocks/gb-pricing-table-features {\"customFontSize\":20,\"paddingTop\":15,\"paddingBottom\":15} --> <ul itemprop=\"description\" class=\"wp-block-genesis-blocks-gb-pricing-table-features gb-pricing-table-features gb-list-border-none gb-list-border-width-1\" style=\"font-size:20px;padding-top:15px;padding-right:20px;padding-bottom:15px;padding-left:20px\"><li>Product Feature One</li><li>Product Feature Two</li><li>Product Feature Three</li></ul> <!-- /wp:genesis-blocks/gb-pricing-table-features --> <!-- wp:genesis-blocks/gb-pricing-table-button {\"buttonText\":\"Buy Now\",\"buttonBackgroundColor\":\"#5f58e5\",\"paddingTop\":15,\"paddingBottom\":35} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table-button gb-pricing-table-button\" style=\"padding-top:15px;padding-right:20px;padding-bottom:35px;padding-left:20px\"><div class=\"gb-block-button\"><a class=\"gb-button gb-button-shape-rounded gb-button-size-medium\" style=\"color:#ffffff;background-color:#5f58e5\">Buy Now</a></div></div> <!-- /wp:genesis-blocks/gb-pricing-table-button --></div></div> <!-- /wp:genesis-blocks/gb-pricing-table --> <!-- wp:genesis-blocks/gb-pricing-table {\"borderWidth\":0,\"backgroundColor\":\"#ebebef\",\"padding\":8} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table gb-block-pricing-table-center gb-block-pricing-table\" itemscope itemtype=\"http://schema.org/Product\"><div class=\"gb-block-pricing-table-inside\" style=\"background-color:#ebebef;padding:8%\"><!-- wp:genesis-blocks/gb-pricing-table-title {\"title\":\"\u003cstrong\u003eEnterprise\u003c/strong\u003e\",\"fontSize\":\"medium\",\"paddingTop\":30} --> <div itemprop=\"name\" style=\"padding-top:30px;padding-right:20px;padding-bottom:10px;padding-left:20px\" class=\"wp-block-genesis-blocks-gb-pricing-table-title gb-pricing-table-title has-medium-font-size\"><strong>Enterprise</strong></div> <!-- /wp:genesis-blocks/gb-pricing-table-title --> <!-- wp:genesis-blocks/gb-pricing-table-subtitle {\"subtitle\":\"All the tools, updates, and support you need to get started.\",\"customFontSize\":20} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table-subtitle gb-pricing-table-subtitle\" style=\"font-size:20px;padding-top:10px;padding-right:20px;padding-bottom:10px;padding-left:20px\">All the tools, updates, and support you need to get started.</div> <!-- /wp:genesis-blocks/gb-pricing-table-subtitle --> <!-- wp:genesis-blocks/gb-pricing-table-price {\"price\":\"129\",\"currency\":\"$\",\"term\":\"/mo\"} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table-price gb-pricing-table-price-wrap gb-pricing-has-currency\" style=\"padding-top:10px;padding-right:20px;padding-bottom:10px;padding-left:20px\"><div itemprop=\"offers\" itemscope itemtype=\"http://schema.org/Offer\"><span itemprop=\"priceCurrency\" class=\"gb-pricing-table-currency\" style=\"font-size:24px\">$</span><div itemprop=\"price\" class=\"gb-pricing-table-price\" style=\"font-size:60px\">129</div><span class=\"gb-pricing-table-term\" style=\"font-size:24px\">/mo</span></div></div> <!-- /wp:genesis-blocks/gb-pricing-table-price --> <!-- wp:genesis-blocks/gb-pricing-table-features {\"customFontSize\":20,\"paddingTop\":15,\"paddingBottom\":15} --> <ul itemprop=\"description\" class=\"wp-block-genesis-blocks-gb-pricing-table-features gb-pricing-table-features gb-list-border-none gb-list-border-width-1\" style=\"font-size:20px;padding-top:15px;padding-right:20px;padding-bottom:15px;padding-left:20px\"><li>Product Feature One</li><li>Product Feature Two</li><li>Product Feature Three</li></ul> <!-- /wp:genesis-blocks/gb-pricing-table-features --> <!-- wp:genesis-blocks/gb-pricing-table-button {\"buttonText\":\"Buy Now\",\"buttonBackgroundColor\":\"#5f58e5\",\"paddingTop\":15,\"paddingBottom\":35} --> <div class=\"wp-block-genesis-blocks-gb-pricing-table-button gb-pricing-table-button\" style=\"padding-top:15px;padding-right:20px;padding-bottom:35px;padding-left:20px\"><div class=\"gb-block-button\"><a class=\"gb-button gb-button-shape-rounded gb-button-size-medium\" style=\"color:#ffffff;background-color:#5f58e5\">Buy Now</a></div></div> <!-- /wp:genesis-blocks/gb-pricing-table-button --></div></div> <!-- /wp:genesis-blocks/gb-pricing-table --></div></div> <!-- /wp:genesis-blocks/gb-pricing --></div></div></div> <!-- /wp:genesis-blocks/gb-container --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\",\"columnsGap\":5,\"paddingTop\":5,\"paddingRight\":5,\"paddingBottom\":5,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customTextColor\":\"#ffffff\",\"customBackgroundColor\":\"#5f58e5\",\"columnMaxWidth\":1200} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-2 gb-2-col-equal gb-has-custom-background-color gb-has-custom-text-color gb-columns-center\" style=\"padding-top:5%;padding-right:5%;padding-bottom:5%;padding-left:5%;background-color:#5f58e5;color:#ffffff\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-5 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column {\"paddingUnit\":\"%\"} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>Ready to join our beta?</h2> <!-- /wp:heading --> <!-- wp:paragraph --> <p>We're working hard on our official product, but we'd love to have your feedback on our beta product, launching soon! Use the Mailchimp form to subscribe for updates!</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-newsletter /--></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:paragraph --> <p></p> <!-- /wp:paragraph --></div></div></div> <!-- /wp:genesis-blocks/gb-container -->",
			'category' => [ esc_html__( 'landing', 'genesis-blocks' ) ],
			'keywords' => [
				esc_html__( 'product', 'genesis-blocks' ),
				esc_html__( 'landing', 'genesis-blocks' ),
				esc_html__( 'marketing', 'genesis-blocks' ),
				esc_html__( 'email', 'genesis-blocks' ),
				esc_html__( 'newsletter', 'genesis-blocks' ),
			],
			'image'    => 'https://demo.studiopress.com/page-builder/gb-layout-landing-1.jpg',
		]
	);

	genesis_blocks_register_layout_component(
		[
			'type'     => 'layout',
			'key'      => 'gb_layout_landing_2',
			'name'     => esc_html__( 'Profile', 'genesis-blocks' ),
			'content'  => "<!-- wp:genesis-blocks/gb-container {\"containerWidth\":\"full\",\"className\":\"gb-layout-landing-2\"} --> <div class=\"wp-block-genesis-blocks-gb-container gb-layout-landing-2 gb-block-container alignfull\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:1600px\"><!-- wp:genesis-blocks/gb-container {\"containerPaddingTop\":5,\"containerPaddingRight\":5,\"containerPaddingBottom\":5,\"containerPaddingLeft\":5,\"containerMaxWidth\":700} --> <div style=\"padding-left:5%;padding-right:5%;padding-bottom:5%;padding-top:5%\" class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:700px\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10230,\"profileBackgroundColor\":\"#ffffff\",\"profileLinkColor\":\"#26ad79\",\"profileFontSize\":20,\"profileAvatarShape\":\"round\",\"twitter\":\"#\",\"facebook\":\"#\",\"instagram\":\"#\",\"pinterest\":\"#\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box round gb-has-avatar gb-font-size-20 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10230\" src=\"https://demo.studiopress.com/page-builder/person-w-3.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Hi there, I'm Amanda.</h2><p class=\"gb-profile-title\" style=\"color:#32373c\"></p><div class=\"gb-profile-text\"><p>I'm a graphic designer living and working in the Midwest USA. When I'm not pushing the pixels, I'm out exploring the National Parks with my dog, Bolt.</p></div><ul class=\"gb-social-links\"><li><a href=\"#\" target=\"_blank\" rel=\"noopener noreferrer\">Twitter <i style=\"background-color:#26ad79\" class=\"fab fa-twitter\"></i></a></li><li><a href=\"#\" target=\"_blank\" rel=\"noopener noreferrer\">Facebook <i style=\"background-color:#26ad79\" class=\"fab fa-facebook-f\"></i></a></li><li><a href=\"#\" target=\"_blank\" rel=\"noopener noreferrer\">Instagram <i style=\"background-color:#26ad79\" class=\"fab fa-instagram\"></i></a></li><li><a href=\"#\" target=\"_blank\" rel=\"noopener noreferrer\">Pinterest <i style=\"background-color:#26ad79\" class=\"fab fa-pinterest\"></i></a></li></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --> <!-- wp:paragraph --> <p></p> <!-- /wp:paragraph --></div></div></div> <!-- /wp:genesis-blocks/gb-container --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\",\"columnsGap\":4,\"align\":\"full\",\"paddingTop\":8,\"paddingRight\":5,\"paddingBottom\":8,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customBackgroundColor\":\"#f6f5f1\",\"columnMaxWidth\":700,\"className\":\"gb-layout-service-3\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-service-3 gb-layout-columns-2 gb-2-col-equal gb-has-custom-background-color gb-columns-center alignfull\" style=\"padding-top:8%;padding-right:5%;padding-bottom:8%;padding-left:5%;background-color:#f6f5f1\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-4 gb-is-responsive-column\" style=\"max-width:700px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:image {\"id\":11968} --> <figure class=\"wp-block-image\"><img src=\"https://demo.studiopress.com/page-builder/gb-placeholder-square-3-600px.jpg\" alt=\"\" class=\"wp-image-11968\"/></figure> <!-- /wp:image --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column {\"columnVerticalAlignment\":\"center\"} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column gb-is-vertically-aligned-center\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>01. Check out my travel photography blog</h2> <!-- /wp:heading --> <!-- wp:paragraph --> <p>I take a lot of photos, and I'd love for you to check them out. Head over to my photography blog to take a look.</p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-button {\"buttonText\":\"Visit the Blog\",\"buttonBackgroundColor\":\"#26ad79\",\"buttonShape\":\"gb-button-shape-circular\"} --> <div class=\"wp-block-genesis-blocks-gb-button gb-block-button\"><a class=\"gb-button gb-button-shape-circular gb-button-size-medium\" style=\"color:#ffffff;background-color:#26ad79\">Visit the Blog</a></div> <!-- /wp:genesis-blocks/gb-button --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\",\"columnsGap\":4,\"align\":\"full\",\"paddingTop\":8,\"paddingRight\":5,\"paddingBottom\":8,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"columnMaxWidth\":700,\"className\":\"gb-layout-service-3\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-service-3 gb-layout-columns-2 gb-2-col-equal gb-columns-center alignfull\" style=\"padding-top:8%;padding-right:5%;padding-bottom:8%;padding-left:5%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-4 gb-is-responsive-column\" style=\"max-width:700px\"><!-- wp:genesis-blocks/gb-column {\"columnVerticalAlignment\":\"center\"} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column gb-is-vertically-aligned-center\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>02. Check out my design portfolio</h2> <!-- /wp:heading --> <!-- wp:paragraph --> <p>Have I mentioned I'm a designer? Maybe even your next designer! Check out my latest design work on the portfolio.</p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-button {\"buttonText\":\"Visit the Portfolio\",\"buttonBackgroundColor\":\"#26ad79\",\"buttonShape\":\"gb-button-shape-circular\"} --> <div class=\"wp-block-genesis-blocks-gb-button gb-block-button\"><a class=\"gb-button gb-button-shape-circular gb-button-size-medium\" style=\"color:#ffffff;background-color:#26ad79\">Visit the Portfolio</a></div> <!-- /wp:genesis-blocks/gb-button --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column {\"columnVerticalAlignment\":\"center\"} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column gb-is-vertically-aligned-center\"><div class=\"gb-block-layout-column-inner\"><!-- wp:image {\"id\":10225} --> <figure class=\"wp-block-image\"><img src=\"https://demo.studiopress.com/page-builder/gb-placeholder-square-1-600px.jpg\" alt=\"\" class=\"wp-image-10225\"/></figure> <!-- /wp:image --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\",\"columnsGap\":4,\"align\":\"full\",\"paddingTop\":8,\"paddingRight\":5,\"paddingBottom\":8,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customBackgroundColor\":\"#f6f5f1\",\"columnMaxWidth\":700,\"className\":\"gb-layout-service-3\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-service-3 gb-layout-columns-2 gb-2-col-equal gb-has-custom-background-color gb-columns-center alignfull\" style=\"padding-top:8%;padding-right:5%;padding-bottom:8%;padding-left:5%;background-color:#f6f5f1\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-4 gb-is-responsive-column\" style=\"max-width:700px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:image {\"id\":11962} --> <figure class=\"wp-block-image\"><img src=\"https://demo.studiopress.com/page-builder/gb-placeholder-square-2-600px.jpg\" alt=\"\" class=\"wp-image-11962\"/></figure> <!-- /wp:image --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column {\"columnVerticalAlignment\":\"center\"} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column gb-is-vertically-aligned-center\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>03. Want to get in touch?</h2> <!-- /wp:heading --> <!-- wp:paragraph --> <p>I'm always looking for a new challenge. If you think I'd be a good fit for your next job, let's have a chat and see where it goes!</p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-button {\"buttonText\":\"Contact Me\",\"buttonBackgroundColor\":\"#26ad79\",\"buttonShape\":\"gb-button-shape-circular\"} --> <div class=\"wp-block-genesis-blocks-gb-button gb-block-button\"><a class=\"gb-button gb-button-shape-circular gb-button-size-medium\" style=\"color:#ffffff;background-color:#26ad79\">Contact Me</a></div> <!-- /wp:genesis-blocks/gb-button --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\",\"marginBottom\":3,\"marginUnit\":\"%\",\"paddingTop\":8,\"paddingRight\":5,\"paddingBottom\":5,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"columnMaxWidth\":700} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-2 gb-2-col-equal gb-columns-center\" style=\"margin-bottom:3%;padding-top:8%;padding-right:5%;padding-bottom:5%;padding-left:5%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:700px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Pixel Perfectionist</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>I have an uncanny attention to detail. You'll find it all throughout my work! I use the Genesis Blocks plugin because it's also crafted with attention to detail.</p> <!-- /wp:paragraph --> <!-- wp:heading {\"level\":3} --> <h3>Expertly Trained</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>I studied graphic design for four years under the great designer, painter and art educator, Paula Scher. Everything I learned goes into every project I start.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Communicator Extraordinaire </h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>Communication is key, as they say! We'll keep in regular contact about any projects we start to ensure you get the end result you're looking for.</p> <!-- /wp:paragraph --> <!-- wp:heading {\"level\":3} --> <h3>Fair, Friendly Pricing</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>I like to work with each client directly to ensure their project is scoped and priced according to the specs. We'll work through the costs before we even start.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-cta {\"buttonText\":\"Let's connect!\",\"buttonBackgroundColor\":\"#26ad79\",\"buttonShape\":\"gb-button-shape-circular\",\"ctaBackgroundColor\":\"#f6f5f1\"} --> <div style=\"background-color:#f6f5f1;text-align:center\" class=\"wp-block-genesis-blocks-gb-cta gb-block-cta\"><div class=\"gb-cta-content\"><h2 class=\"gb-cta-title gb-font-size-32\" style=\"color:#32373c\">Drop me a line!</h2><div class=\"gb-cta-text gb-font-size-32\" style=\"color:#32373c\"><p>I'm accepting new clients through the rest of the year. Please drop me a line and we'll get started with your next project!</p></div></div><div class=\"gb-cta-button\"><a target=\"_self\" rel=\"noopener noreferrer\" class=\"gb-button gb-button-shape-circular gb-button-size-medium\" style=\"color:#ffffff;background-color:#26ad79\">Let's connect!</a></div></div> <!-- /wp:genesis-blocks/gb-cta --></div></div></div> <!-- /wp:genesis-blocks/gb-container -->",
			'category' => [ esc_html__( 'landing', 'genesis-blocks' ) ],
			'keywords' => [
				esc_html__( 'about', 'genesis-blocks' ),
				esc_html__( 'personal', 'genesis-blocks' ),
				esc_html__( 'profile', 'genesis-blocks' ),
				esc_html__( 'portfolio', 'genesis-blocks' ),
			],
			'image'    => 'https://demo.studiopress.com/page-builder/gb-layout-landing-2.jpg',
		]
	);

	genesis_blocks_register_layout_component(
		[
			'type'     => 'layout',
			'key'      => 'gb_layout_landing_3',
			'content'  => "<!-- wp:genesis-blocks/gb-container {\"containerPaddingRight\":5,\"containerPaddingBottom\":0,\"containerPaddingLeft\":5,\"containerWidth\":\"full\",\"containerMaxWidth\":1000,\"className\":\"gb-layout-landing-3\"} --> <div style=\"padding-left:5%;padding-right:5%\" class=\"wp-block-genesis-blocks-gb-container gb-layout-landing-3 gb-block-container alignfull\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:1000px\"><!-- wp:cover {\"url\":\"https://demo.studiopress.com/page-builder/gb-placeholder-hero.jpg\",\"id\":3852,\"hasParallax\":true,\"dimRatio\":80,\"align\":\"full\",\"className\":\"gb-layout-landing-3-cover\"} --> <div class=\"wp-block-cover alignfull has-background-dim-80 has-background-dim has-parallax gb-layout-landing-3-cover\" style=\"background-image:url(https://demo.studiopress.com/page-builder/gb-placeholder-hero.jpg)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading --> <h2>A better way to grow your creative business.</h2> <!-- /wp:heading --></div></div> <!-- /wp:cover --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-wideright\",\"paddingTop\":10,\"paddingBottom\":6,\"paddingUnit\":\"%\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-2 gb-2-col-wideright\" style=\"padding-top:10%;padding-bottom:6%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>Get to know me.</h2> <!-- /wp:heading --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:paragraph --> <p>I have an uncanny attention to detail. You’ll find it all throughout my work! I use the Genesis Blocks plugin because it’s also crafted with attention to detail. I studied graphic design for four years under the great designer, painter and art educator, Paula Scher. Everything I learned goes into every project I start.</p> <!-- /wp:paragraph --> <!-- wp:paragraph --> <p>Communication is key, as they say! We’ll keep in regular contact about any projects we start to ensure you get the end result you’re looking for.</p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-button {\"buttonText\":\"Check my availability\",\"buttonAlignment\":\"left\",\"buttonShape\":\"gb-button-shape-square\"} --> <div style=\"text-align:left\" class=\"wp-block-genesis-blocks-gb-button gb-block-button\"><a class=\"gb-button gb-button-shape-square gb-button-size-medium\" style=\"color:#ffffff;background-color:#3373dc\">Check my availability</a></div> <!-- /wp:genesis-blocks/gb-button --> <!-- wp:paragraph --> <p></p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-spacer {\"spacerDivider\":true} --> <div style=\"color:#ddd\" class=\"wp-block-genesis-blocks-gb-spacer gb-block-spacer gb-divider-solid gb-spacer-divider gb-divider-size-1\"><hr style=\"height:30px\"/></div> <!-- /wp:genesis-blocks/gb-spacer --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-wideright\",\"paddingTop\":7,\"paddingBottom\":8,\"paddingUnit\":\"%\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-2 gb-2-col-wideright\" style=\"padding-top:7%;padding-bottom:8%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>Frequently asked.</h2> <!-- /wp:heading --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-accordion {\"accordionOpen\":true} --> <div class=\"wp-block-genesis-blocks-gb-accordion gb-block-accordion gb-font-size-18\"><details open><summary class=\"gb-accordion-title\">What do you specialize in?</summary><div class=\"gb-accordion-text\"><!-- wp:paragraph --> <p>We specialize in email marketing, web design &amp; development and hosting services. We provide these services individually, as well as a complete package to launch your next project on.</p> <!-- /wp:paragraph --></div></details></div> <!-- /wp:genesis-blocks/gb-accordion --> <!-- wp:genesis-blocks/gb-accordion --> <div class=\"wp-block-genesis-blocks-gb-accordion gb-block-accordion gb-font-size-18\"><details><summary class=\"gb-accordion-title\">What kind of turn around do you offer?</summary><div class=\"gb-accordion-text\"><!-- wp:paragraph --> <p>A standard size project typically takes about a month to complete. We handle all of the work for you, and communicate everything along the way to ensure you're happy with your outcome!</p> <!-- /wp:paragraph --></div></details></div> <!-- /wp:genesis-blocks/gb-accordion --> <!-- wp:paragraph --> <p></p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-accordion --> <div class=\"wp-block-genesis-blocks-gb-accordion gb-block-accordion gb-font-size-18\"><details><summary class=\"gb-accordion-title\">How much does a typical project cost?</summary><div class=\"gb-accordion-text\"><!-- wp:paragraph --> <p>Prices can vary significantly depending on the size of your project. We handle projects for small agencies, and also large projects that can run upwards of $200k. Our minimum project cost is $5,000.</p> <!-- /wp:paragraph --></div></details></div> <!-- /wp:genesis-blocks/gb-accordion --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-spacer {\"spacerDivider\":true} --> <div style=\"color:#ddd\" class=\"wp-block-genesis-blocks-gb-spacer gb-block-spacer gb-divider-solid gb-spacer-divider gb-divider-size-1\"><hr style=\"height:30px\"/></div> <!-- /wp:genesis-blocks/gb-spacer --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-wideright\",\"paddingTop\":8,\"paddingBottom\":7,\"paddingUnit\":\"%\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-2 gb-2-col-wideright\" style=\"padding-top:8%;padding-bottom:7%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column {\"paddingUnit\":\"%\"} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>Things I can do.</h2> <!-- /wp:heading --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-2 gb-2-col-equal\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Pixel Perfectionist</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>I have an uncanny attention to detail. You’ll find it all throughout my work! I use the Genesis Blocks plugin because it’s also crafted with attention to detail.</p> <!-- /wp:paragraph --> <!-- wp:heading {\"level\":3} --> <h3>Expertly Trained</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>I studied graphic design for four years under the great designer, painter and art educator, Paula Scher. Everything I learned goes into every project I start.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Expert Communicator</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>Communication is key, as they say! We’ll keep in regular contact about any projects we start to ensure you get the end result you’re looking for.</p> <!-- /wp:paragraph --> <!-- wp:heading {\"level\":3} --> <h3>Friendly Pricing</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>I like to work with each client directly to ensure their project is scoped and priced according to the specs. We’ll work through the costs before we start.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-spacer {\"spacerDivider\":true} --> <div style=\"color:#ddd\" class=\"wp-block-genesis-blocks-gb-spacer gb-block-spacer gb-divider-solid gb-spacer-divider gb-divider-size-1\"><hr style=\"height:30px\"/></div> <!-- /wp:genesis-blocks/gb-spacer --> <!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-wideright\",\"paddingTop\":8,\"paddingUnit\":\"%\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-2 gb-2-col-wideright\" style=\"padding-top:8%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>My latest blog posts.</h2> <!-- /wp:heading --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-post-grid {\"postsToShow\":2} /--></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --></div></div></div> <!-- /wp:genesis-blocks/gb-container -->",
			'name'     => esc_html__( 'Freelancer', 'genesis-blocks' ),
			'category' => [ esc_html__( 'landing', 'genesis-blocks' ) ],
			'keywords' => [
				esc_html__( 'about', 'genesis-blocks' ),
				esc_html__( 'personal', 'genesis-blocks' ),
				esc_html__( 'profile', 'genesis-blocks' ),
				esc_html__( 'portfolio', 'genesis-blocks' ),
				esc_html__( 'freelance', 'genesis-blocks' ),
			],
			'image'    => 'https://demo.studiopress.com/page-builder/gb-layout-landing-3.jpg',
		]
	);

	genesis_blocks_register_layout_component(
		[
			'type'     => 'section',
			'key'      => 'gb_section_hero_1',
			'content'  => "<!-- wp:genesis-blocks/gb-container {\"containerPaddingTop\":15,\"containerPaddingRight\":5,\"containerPaddingBottom\":15,\"containerPaddingLeft\":5,\"containerWidth\":\"full\",\"containerMaxWidth\":850,\"containerBackgroundColor\":\"#0b0b0b\",\"containerImgID\":3854,\"className\":\"gb-layout-hero-1\"} --> <div style=\"background-color:#0b0b0b;padding-left:5%;padding-right:5%;padding-bottom:15%;padding-top:15%\" class=\"wp-block-genesis-blocks-gb-container gb-layout-hero-1 gb-block-container alignfull\"><div class=\"gb-container-inside\"><div class=\"gb-container-image-wrap\"><img class=\"gb-container-image has-background-dim\" src=\"https://demo.studiopress.com/page-builder/gb-placeholder-hero.jpg\" alt=\"hero header placeholder\"/></div><div class=\"gb-container-content\" style=\"max-width:850px\"><!-- wp:heading {\"align\":\"center\",\"className\":\"gb-white-text\"} --> <h2 style=\"text-align:center\" class=\"gb-white-text\">The future of website creation is here.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"align\":\"center\",\"customTextColor\":\"#ffffff\"} --> <p style=\"color:#ffffff;text-align:center\" class=\"has-text-color\">With Genesis and Genesis blocks, you can build beautiful, powerful websites in minutes with our robust theme framework and professionally-designed sections and layouts</p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-button {\"buttonText\":\"Launch your new site!\",\"buttonAlignment\":\"center\"} --> <div style=\"text-align:center\" class=\"wp-block-genesis-blocks-gb-button gb-block-button\"><a href=\"#\" class=\"gb-button gb-button-shape-rounded gb-button-size-medium\" style=\"color:#ffffff;background-color:#3373dc\">Launch your new site!</a></div> <!-- /wp:genesis-blocks/gb-button --></div></div></div> <!-- /wp:genesis-blocks/gb-container -->",
			'name'     => esc_html__( 'Hero Header', 'genesis-blocks' ),
			'category' => [ esc_html__( 'header', 'genesis-blocks' ) ],
			'keywords' => [
				esc_html__( 'header', 'genesis-blocks' ),
				esc_html__( 'hero', 'genesis-blocks' ),
			],
			'image'    => 'https://demo.studiopress.com/page-builder/gb_layout_hero_1.jpg',
		]
	);

	genesis_blocks_register_layout_component(
		[
			'type'     => 'section',
			'key'      => 'gb_section_service_1',
			'content'  => "<!-- wp:genesis-blocks/gb-columns {\"columns\":3,\"layout\":\"gb-3-col-wideleft\",\"align\":\"full\",\"paddingTop\":15,\"paddingRight\":5,\"paddingBottom\":15,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customBackgroundColor\":\"#f1f1f1\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-service-1\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-service-1 gb-layout-columns-3 gb-3-col-wideleft gb-has-custom-background-color gb-columns-center alignfull\" style=\"padding-top:15%;padding-right:5%;padding-bottom:15%;padding-left:5%;background-color:#f1f1f1\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>Build modern sites with Genesis Blocks layouts</h2> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress, bringing it in line with modern coding standards, and aligning with open web initiatives. When we refer to “blocks” we are talking anything that can be inserted into the editor to create content. </p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Sites Built To Last</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --> <!-- wp:heading {\"level\":3} --> <h3>From the Genesis Lab</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Beautiful Designs</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --> <!-- wp:heading {\"level\":3} --> <h3>Rock Solid Standards</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns -->",
			'name'     => esc_html__( 'Services - Three Column', 'genesis-blocks' ),
			'category' => [ esc_html__( 'services', 'genesis-blocks' ) ],
			'keywords' => [
				esc_html__( 'services', 'genesis-blocks' ),
				esc_html__( 'text', 'genesis-blocks' ),
			],
			'image'    => 'https://demo.studiopress.com/page-builder/gb_layout_service_1.jpg',
		]
	);

	genesis_blocks_register_layout_component(
		[
			'type'     => 'section',
			'key'      => 'gb_section_service_2',
			'content'  => "<!-- wp:genesis-blocks/gb-columns {\"columns\":1,\"layout\":\"one-column\",\"align\":\"full\",\"paddingTop\":15,\"paddingRight\":5,\"paddingBottom\":15,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customBackgroundColor\":\"#f1f1f1\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-service-2\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-service-2 gb-layout-columns-1 one-column gb-has-custom-background-color gb-columns-center alignfull\" style=\"padding-top:15%;padding-right:5%;padding-bottom:15%;padding-left:5%;background-color:#f1f1f1\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-container {\"containerMarginBottom\":5,\"containerMaxWidth\":700} --> <div style=\"margin-bottom:5%\" class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:700px\"><!-- wp:heading {\"align\":\"center\"} --> <h2 style=\"text-align:center\">Beautiful, responsive layouts ready to use.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"align\":\"center\"} --> <p style=\"text-align:center\">The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress.</p> <!-- /wp:paragraph --></div></div></div> <!-- /wp:genesis-blocks/gb-container --> <!-- wp:genesis-blocks/gb-columns {\"columns\":4,\"layout\":\"gb-4-col-equal\",\"marginBottom\":3,\"marginUnit\":\"%\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-4 gb-4-col-equal\" style=\"margin-bottom:3%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>From the Genesis Lab</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Rock Solid Standards</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Sites Built To Last</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading {\"level\":3} --> <h3>Beautiful Designs</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The new editor comes with a handful of default blocks such as paragraph, image, gallery, and more, to help you create better standard posts and pages.</p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-button {\"buttonText\":\"Start building your site!\",\"buttonAlignment\":\"center\",\"buttonBackgroundColor\":\"#3373dc\",\"buttonSize\":\"gb-button-size-large\",\"buttonShape\":\"gb-button-shape-rounded\"} --> <div style=\"text-align:center\" class=\"wp-block-genesis-blocks-gb-button gb-block-button\"><a href=\"#\" class=\"gb-button gb-button-shape-rounded gb-button-size-large\" style=\"color:#ffffff;background-color:#3373dc\">Start building your site!</a></div> <!-- /wp:genesis-blocks/gb-button --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns -->",
			'name'     => esc_html__( 'Services - Four Column', 'genesis-blocks' ),
			'category' => [ esc_html__( 'services', 'genesis-blocks' ) ],
			'keywords' => [
				esc_html__( 'services', 'genesis-blocks' ),
				esc_html__( 'text', 'genesis-blocks' ),
			],
			'image'    => 'https://demo.studiopress.com/page-builder/gb_layout_service_2.jpg',
		]
	);

	genesis_blocks_register_layout_component(
		[
			'type'     => 'section',
			'key'      => 'gb_section_media_text',
			'content'  => "<!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\",\"columnsGap\":5,\"align\":\"full\",\"paddingTop\":15,\"paddingRight\":5,\"paddingBottom\":15,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-service-3\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-service-3 gb-layout-columns-2 gb-2-col-equal gb-columns-center alignfull\" style=\"padding-top:15%;padding-right:5%;padding-bottom:15%;padding-left:5%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-5 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:image {\"id\":3852} --> <figure class=\"wp-block-image\"><img src=\"https://demo.studiopress.com/page-builder/gb-square-placeholder.jpg\" alt=\"GB Square Placeholder\" class=\"wp-image-3852\"/></figure> <!-- /wp:image --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column {\"columnVerticalAlignment\":\"center\"} --> <div class=\"gb-block-layout-column gb-is-vertically-aligned-center\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>Build blazing websites with Genesis and Genesis Blocks. <br></h2> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress, bringing it in line with modern coding standards, and aligning with open web initiatives. That sounds pretty great huh?</p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-button {\"buttonText\":\"Try Genesis Blocks Today\",\"buttonBackgroundColor\":\"#3373dc\",\"buttonShape\":\"gb-button-shape-rounded\"} --> <div class=\"wp-block-genesis-blocks-gb-button gb-block-button\"><a href=\"#\" class=\"gb-button gb-button-shape-rounded gb-button-size-medium\" style=\"color:#ffffff;background-color:#3373dc\">Try Genesis Blocks Today</a></div> <!-- /wp:genesis-blocks/gb-button --> <!-- wp:paragraph --> <p></p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns -->",
			'name'     => esc_html__( 'Media / Text', 'genesis-blocks' ),
			'category' => [ esc_html__( 'media', 'genesis-blocks' ) ],
			'keywords' => [
				esc_html__( 'services', 'genesis-blocks' ),
				esc_html__( 'text', 'genesis-blocks' ),
			],
			'image'    => 'https://demo.studiopress.com/page-builder/gb_layout_media_text.jpg',
		]
	);

	genesis_blocks_register_layout_component(
		[
			'type'     => 'section',
			'key'      => 'gb_section_service_4',
			'content'  => "<!-- wp:genesis-blocks/gb-columns {\"columns\":2,\"layout\":\"gb-2-col-equal\",\"columnsGap\":6,\"align\":\"full\",\"paddingTop\":15,\"paddingRight\":5,\"paddingBottom\":15,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-service-4\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-service-4 gb-layout-columns-2 gb-2-col-equal gb-columns-center alignfull\" style=\"padding-top:15%;padding-right:5%;padding-bottom:15%;padding-left:5%\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-6 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:heading --> <h2>Build creative layouts in minutes with our professionally-designed sections and layouts.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"customFontSize\":22} --> <p style=\"font-size:22px\">The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress, bringing it in line with modern coding standards, and aligning with open web initiatives. </p> <!-- /wp:paragraph --> <!-- wp:genesis-blocks/gb-spacer {\"spacerDivider\":true} --> <div style=\"color:#ddd\" class=\"wp-block-genesis-blocks-gb-spacer gb-block-spacer gb-divider-solid gb-spacer-divider gb-divider-size-1\"><hr style=\"height:30px\"/></div> <!-- /wp:genesis-blocks/gb-spacer --> <!-- wp:heading {\"level\":3} --> <h3>Sites Built to Last</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress and aligning with open web initiatives. </p> <!-- /wp:paragraph --> <!-- wp:heading {\"level\":3} --> <h3>From the WPE Lab</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress and aligning with open web initiatives. </p> <!-- /wp:paragraph --> <!-- wp:heading {\"level\":3} --> <h3>Built-in Templates</h3> <!-- /wp:heading --> <!-- wp:paragraph --> <p>The Gutenberg editor uses blocks to create all types of content, replacing a half-dozen ways of customizing WordPress and aligning with open web initiatives. </p> <!-- /wp:paragraph --> <!-- wp:paragraph --> <p><br></p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:image {\"id\":11445} --> <figure class=\"wp-block-image\"><img src=\"https://demo.studiopress.com/page-builder/gb-placeholder-tall.jpg\" alt=\"\" class=\"wp-image-11445\"/></figure> <!-- /wp:image --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns -->",
			'name'     => esc_html__( 'Text List and Image', 'genesis-blocks' ),
			'category' => [ esc_html__( 'media', 'genesis-blocks' ) ],
			'keywords' => [
				esc_html__( 'services', 'genesis-blocks' ),
				esc_html__( 'text', 'genesis-blocks' ),
			],
			'image'    => 'https://demo.studiopress.com/page-builder/gb_section_service_4.jpg',
		]
	);

	genesis_blocks_register_layout_component(
		[
			'type'     => 'section',
			'key'      => 'gb_section_team',
			'content'  => "<!-- wp:genesis-blocks/gb-columns {\"columns\":1,\"layout\":\"one-column\",\"align\":\"full\",\"paddingTop\":15,\"paddingRight\":5,\"paddingBottom\":15,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customBackgroundColor\":\"#f1f1f1\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-team-1\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-team-1 gb-layout-columns-1 one-column gb-has-custom-background-color gb-columns-center alignfull\" style=\"padding-top:15%;padding-right:5%;padding-bottom:15%;padding-left:5%;background-color:#f1f1f1\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-container {\"containerMarginBottom\":5,\"containerMaxWidth\":700} --> <div style=\"margin-bottom:5%\" class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:700px\"><!-- wp:heading {\"align\":\"center\"} --> <h2 style=\"text-align:center\">Meet our amazing team.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"align\":\"center\"} --> <p style=\"text-align:center\">We're a talented group of creative individuals interested in art, cinematography, design, music, and all niches in between.</p> <!-- /wp:paragraph --></div></div></div> <!-- /wp:genesis-blocks/gb-container --> <!-- wp:genesis-blocks/gb-columns {\"columns\":3,\"layout\":\"gb-3-col-equal\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-3 gb-3-col-equal\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10230} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10230\" src=\"https://demo.studiopress.com/page-builder/person-m-1.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Kyle Zion</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">Screenprinter</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10211} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10211\" src=\"https://demo.studiopress.com/page-builder/person-w-3.jpg\" alt=\"avatar placeholder\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Fran Acadia</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">People Engineer</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10225} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10225\" src=\"https://demo.studiopress.com/page-builder/person-m-3.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Giannis Teton</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">Office Manager</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:genesis-blocks/gb-columns {\"columns\":3,\"layout\":\"gb-3-col-equal\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-3 gb-3-col-equal\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10230} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10230\" src=\"https://demo.studiopress.com/page-builder/person-w-5.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Mandi Arches</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">Lead Designer</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10211} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10211\" src=\"https://demo.studiopress.com/page-builder/person-m-2.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Walter Bryce</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">Lead Developer</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-profile-box {\"profileImgID\":10225} --> <div style=\"background-color:#f2f2f2;color:#32373c\" class=\"wp-block-genesis-blocks-gb-profile-box square gb-has-avatar gb-font-size-18 gb-block-profile gb-profile-columns\"><div class=\"gb-profile-column gb-profile-avatar-wrap\"><div class=\"gb-profile-image-wrap\"><figure class=\"gb-profile-image-square\"><img class=\"gb-profile-avatar wp-image-10225\" src=\"https://demo.studiopress.com/page-builder/person-w-1.jpg\" alt=\"team member avatar\"/></figure></div></div><div class=\"gb-profile-column gb-profile-content-wrap\"><h2 class=\"gb-profile-name\" style=\"color:#32373c\">Kim Rainier</h2><p class=\"gb-profile-title\" style=\"color:#32373c\">Support Specialist</p><div class=\"gb-profile-text\"><p>Add biography text for your team member here. You can also remove this text if you'd rather just have a name and title.</p></div><ul class=\"gb-social-links\"></ul></div></div> <!-- /wp:genesis-blocks/gb-profile-box --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --> <!-- wp:paragraph --> <p></p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns -->",
			'name'     => esc_html__( 'Team Members', 'genesis-blocks' ),
			'category' => [ esc_html__( 'team', 'genesis-blocks' ) ],
			'keywords' => [
				esc_html__( 'team', 'genesis-blocks' ),
				esc_html__( 'member', 'genesis-blocks' ),
				esc_html__( 'user', 'genesis-blocks' ),
				esc_html__( 'author', 'genesis-blocks' ),
			],
			'image'    => 'https://demo.studiopress.com/page-builder/gb_layout_team.jpg',
		]
	);

	genesis_blocks_register_layout_component(
		[
			'type'     => 'section',
			'key'      => 'gb_section_testimonial',
			'content'  => "<!-- wp:genesis-blocks/gb-columns {\"columns\":1,\"layout\":\"one-column\",\"align\":\"full\",\"paddingTop\":15,\"paddingRight\":5,\"paddingBottom\":15,\"paddingLeft\":5,\"paddingUnit\":\"%\",\"customBackgroundColor\":\"#f1f1f1\",\"columnMaxWidth\":1200,\"className\":\"gb-layout-testimonial-1\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-testimonial-1 gb-layout-columns-1 one-column gb-has-custom-background-color gb-columns-center alignfull\" style=\"padding-top:15%;padding-right:5%;padding-bottom:15%;padding-left:5%;background-color:#f1f1f1\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\" style=\"max-width:1200px\"><!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-container {\"containerMarginBottom\":5,\"containerMaxWidth\":700} --> <div style=\"margin-bottom:5%\" class=\"wp-block-genesis-blocks-gb-container gb-block-container\"><div class=\"gb-container-inside\"><div class=\"gb-container-content\" style=\"max-width:700px\"><!-- wp:heading {\"align\":\"center\"} --> <h2 style=\"text-align:center\">See what they're saying.</h2> <!-- /wp:heading --> <!-- wp:paragraph {\"align\":\"center\"} --> <p style=\"text-align:center\">Our happy customers have a lot to say about our products and services!</p> <!-- /wp:paragraph --></div></div></div> <!-- /wp:genesis-blocks/gb-container --> <!-- wp:genesis-blocks/gb-columns {\"columns\":3,\"layout\":\"gb-3-col-equal\"} --> <div class=\"wp-block-genesis-blocks-gb-columns gb-layout-columns-3 gb-3-col-equal\"><div class=\"gb-layout-column-wrap gb-block-layout-column-gap-2 gb-is-responsive-column\"><!-- wp:genesis-blocks/gb-column {\"padding\":15} --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10230,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>It’s really great how easy your websites are to update and manage. I never have any problem at all!</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-w-4.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Mary Sequoia</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Author</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --> <!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10230,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>My new site is so much faster and easier to work with than my old site. It used to take me an hour or more to update a page.</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-m-5.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Marcus Alpine</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Author</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --> <!-- wp:paragraph --> <p></p> <!-- /wp:paragraph --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10211,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>My new site is so much faster and easier to work with than my old site. It used to take me an hour or more to update a page.</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-m-1.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Philip Glacier</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Publisher</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --> <!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10211,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>It’s really great how easy your websites are to update and manage. I never have any problem at all!</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-w-1.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Robin Yellowstone</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Publisher</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --></div></div> <!-- /wp:genesis-blocks/gb-column --> <!-- wp:genesis-blocks/gb-column --> <div class=\"wp-block-genesis-blocks-gb-column gb-block-layout-column\"><div class=\"gb-block-layout-column-inner\"><!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10230,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>It’s almost like having a designer right here with me. I just choose the page, make the change and click save. It’s so simple.</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-w-3.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Amy Redwood</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Consultant</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --> <!-- wp:genesis-blocks/gb-testimonial {\"testimonialImgID\":10230,\"testimonialBackgroundColor\":\"#ffffff\"} --> <div style=\"background-color:#ffffff;color:#32373c\" class=\"wp-block-genesis-blocks-gb-testimonial left-aligned gb-has-avatar gb-font-size-18 gb-block-testimonial\"><div class=\"gb-testimonial-text\"><p>I can't believe how good the customer support is on this product. I'm used to waiting weeks to hear back. Not any longer!</p></div><div class=\"gb-testimonial-info\"><div class=\"gb-testimonial-avatar-wrap\"><div class=\"gb-testimonial-image-wrap\"><img class=\"gb-testimonial-avatar\" src=\"https://demo.studiopress.com/page-builder/person-m-3.jpg\" alt=\"avatar\"/></div></div><h2 class=\"gb-testimonial-name\" style=\"color:#32373c\">Rob Badland</h2><small class=\"gb-testimonial-title\" style=\"color:#32373c\">Consultant</small></div></div> <!-- /wp:genesis-blocks/gb-testimonial --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns --></div></div> <!-- /wp:genesis-blocks/gb-column --></div></div> <!-- /wp:genesis-blocks/gb-columns -->",
			'name'     => esc_html__( 'Testimonials', 'genesis-blocks' ),
			'category' => [ esc_html__( 'testimonial', 'genesis-blocks' ) ],
			'keywords' => [
				esc_html__( 'testimonial', 'genesis-blocks' ),
				esc_html__( 'quote', 'genesis-blocks' ),
				esc_html__( 'review', 'genesis-blocks' ),
				esc_html__( 'user', 'genesis-blocks' ),
			],
			'image'    => 'https://demo.studiopress.com/page-builder/gb_layout_testimonial.jpg',
		]
	);

	/**
	 * Scan Patterns directory and auto require all PHP files
	 */
	$pattern_file_paths = glob( dirname( __FILE__ ) . '/../patterns/*.php' );
	foreach ( $pattern_file_paths as $path ) {
		genesis_blocks_register_layout_component( require $path );
	}
}
