/*

This function is used for generating the dynamic pdf (Proof of consent) it utilizes js-pdf library
along with autotable to dynamically display proof of consnet.
@since 3.0.0

*/
function generatePDF(
  date,
  ipAddress,
  country,
  consentStatus,
  tcString,
  acString,
  siteaddress,
  preferences,
  cookieData
) {
  if (typeof cookieData === "string") {
    try {
      cookieData = JSON.parse(cookieData, true);
    } catch (e) {
      cookieData = [];
    }
  }

  event.preventDefault();
  
  function filterCookiesByCategory(arr, category) {
    return arr
      .filter(c => c.category?.toLowerCase() === category.toLowerCase())
      .map(c => [c.name, c.duration, c.description]);
  }


  // Usage example:
  const necessaryCookies = filterCookiesByCategory(cookieData.data, "Necessary");
  const analyticsCookies = filterCookiesByCategory(cookieData.data, "Analytics");
  const marketingCookies = filterCookiesByCategory(cookieData.data, "Marketing");
  const unclassifiedCookies = filterCookiesByCategory(
    cookieData.data,
    "Unclassified"
  );
  const preferencesCookies = filterCookiesByCategory(cookieData.data, "Preferences");

  const websiteUrl = window.location.hostname;
  const { jsPDF } = window.jspdf;
  const doc = new jsPDF("p", "mm", "a4"); // Create A4 size PDF

  doc.autoTableSetDefaults({
    margin: { top: 20, left: 20, right: 20 }, // 20 mm margins
    styles: { fontSize: 11 }
  });
  var wrappedText = "";
  var actext = "";
  if (tcString != "") {
    wrappedText = doc.splitTextToSize(tcString, 230);
  }
  if (acString != "") {
    const [specVersion, consentedPart, disclosedPart] = acString.split("~");
    const consentedIds = consentedPart.split(".").join(", ");
    actext = doc.splitTextToSize(consentedIds, 250);
  }

  const pageWidth = doc.internal.pageSize.getWidth();
  const fontSizeHeading = 24;
  const text = "Proof of Consent";

  // Calculate the width of the text
  const textWidth =
    (doc.getStringUnitWidth(text) * fontSizeHeading) / doc.internal.scaleFactor;

  // Calculate the X coordinate to center-align the text
  const centerX = (doc.internal.pageSize.getWidth() - textWidth) / 2;

  // Set the font size and position the text
  doc.setFontSize(fontSizeHeading);
  doc.text(text, centerX, 20);
  doc.setTextColor(0, 0, 0); // Set text color to black
  // Other text
  const fontSizeText = 11;
  doc.setFontSize(fontSizeText);
  const tableData = [
    ["Consent Date", date],
    ["Website URL", websiteUrl],
    ["IP Address", ipAddress],
    ["Country", country],
    ["Consent Status", consentStatus],
  ];
  if (siteaddress) {
    tableData.push(["Forwarded From", siteaddress]);
  }

  // Create the table using autoTable
  doc.autoTable({
    startY: 30, // Position of the table
    // head: [["Field", "Value"]], // Table header
    body: tableData, // Table data
    theme: "grid", // Table theme (grid-like borders)
    styles: {
      lineColor: [0, 0, 0], // Black border color
      lineWidth: 0.2, // Border width
      textColor: [0, 0, 0], // Black text color
      fontSize: 11, // Font size for table content
    },
    columnStyles: {
      0: { cellWidth: 50, halign: "left", textColor: [0, 0, 0] }, // Left column (Field)
      1: { halign: "left", textColor: [0, 0, 0] }, // Right column (Value)
    },
  });

  if (!siteaddress) {
    // Subheading for Cookie Details
    const fontSizeSubheading = 16;
    doc.setFontSize(fontSizeSubheading);
    doc.setFont(undefined, "bold");

    // Center align "Cookie Consent Details"
    const pageWidth = doc.internal.pageSize.width;
    const cookieHeading = "Cookie Consent Details:";
    // const textWidth = doc.getTextWidth(cookieHeading);
    const cookieHeadingY = 85;
    doc.text(cookieHeading, 15, cookieHeadingY);
    let startY = cookieHeadingY + 15;
    // doc.text(cookieHeading, (pageWidth - textWidth) / 2, 85); // Center the text on the page

    doc.setFont(undefined, "normal"); // Reset font type to normal
    doc.setFontSize(fontSizeText);
    if (preferences) {
      
      
      // Check and display status for Necessary
      if (typeof preferences === "string") {
        preferences = JSON.parse(preferences);
      }
      if (preferences.necessary === "yes") {
        doc.setFont(undefined, "bold");
        doc.text("Necessary:", 15, startY); // Adjusted x-coordinate from 12 to 15
        doc.setFont(undefined, "normal");
        doc.text("Always Active", 40, startY); // Adjusted x-coordinate from 32 to 40
      } else {
        doc.setFont(undefined, "bold");
        doc.text("Necessary:", 15, startY); // Adjusted x-coordinate from 10 to 15
        doc.setFont(undefined, "normal");
        doc.text("Not Active", 38, startY); // Adjusted x-coordinate from 32 to 40
      }
      // Align the table with the previous table
      
      startY = startY + 1;
      doc.autoTable({
        head: [["Cookie", "Duration", "Description"]],
        body: necessaryCookies.length > 0 ? necessaryCookies : [["-", "-", "-"]],
        startY: startY + 5, // Position below the Necessary text
        theme: "grid", // Add grid lines to the table
        styles: {
          fontSize: fontSizeText,
          halign: "left", // Align text to the left
          valign: "middle", // Vertical alignment for text
          lineWidth: 0.2, // Set line width for the table grid
        },
        columnStyles: {
          0: { cellWidth: 65 }, // Adjust the first column width
          1: { cellWidth: 50 }, // Adjust the second column width
          2: { cellWidth: 69 }, // Adjust the third column width
        },
        headStyles: {
          fillColor: [164, 194, 244], // Header background color
          textColor: [0, 0, 0], // Header text color
          halign: "left", // Align header text to the left
          fontSize: fontSizeText,
        },
        bodyStyles: {
          textColor: [0, 0, 0], // Body text color
        },
        tableWidth: "wrap", // Let the table wrap to fit the content
        margin: { left: 10, top: 0 }, // Align with the previous content
      });

      startY = doc.previousAutoTable.finalY + 10; // Update startY for further content

      // Check and display status for Analytics
      if (preferences.analytics === "yes") {
        doc.setFont(undefined, "bold");
        doc.text("Analytics:", 15, startY);
        doc.setFont(undefined, "normal");
        doc.text("Active", 40, startY);
      } else {
        doc.setFont(undefined, "bold");
        doc.text("Analytics:", 15, startY);
        doc.setFont(undefined, "normal");
        doc.text("Not Active", 38, startY);
      }

      doc.autoTable({
        head: [["Cookie", "Duration", "Description"]],
        body: analyticsCookies.length > 0 ? analyticsCookies : [["-", "-", "-"]],
        startY: startY + 5, // Position below the Necessary text
        theme: "grid", // Add grid lines to the table
        styles: {
          fontSize: fontSizeText,
          halign: "left", // Align text to the left
          valign: "middle", // Vertical alignment for text
          lineWidth: 0.2, // Set line width for the table grid
        },
        columnStyles: {
          0: { cellWidth: 65 }, // Adjust the first column width
          1: { cellWidth: 50 }, // Adjust the second column width
          2: { cellWidth: 69 }, // Adjust the third column width
        },
        headStyles: {
          fillColor: [164, 194, 244], // Header background color
          textColor: [0, 0, 0], // Header text color
          halign: "left", // Align header text to the left
          fontSize: fontSizeText,
        },
        bodyStyles: {
          textColor: [0, 0, 0], // Body text color
        },
        tableWidth: "wrap", // Let the table wrap to fit the content
        margin: { left: 10, top: 0 }, // Align with the previous content
      });
      startY = doc.previousAutoTable.finalY + 10;

      // Check and display status for Marketing
      if (preferences.marketing === "yes") {
        doc.setFont(undefined, "bold");
        doc.text("Marketing:", 15, startY);
        doc.setFont(undefined, "normal");
        doc.text(" Active", 40, startY);
      } else {
        doc.setFont(undefined, "bold");
        doc.text("Marketing:", 15, startY);
        doc.setFont(undefined, "normal");
        doc.text("Not Active", 38, startY);
      }

      doc.autoTable({
        head: [["Cookie", "Duration", "Description"]],
        body: marketingCookies.length > 0 ? marketingCookies : [["-", "-", "-"]],
        startY: startY + 5, // Position below the Necessary text
        theme: "grid", // Add grid lines to the table
        styles: {
          fontSize: fontSizeText,
          halign: "left", // Align text to the left
          valign: "middle", // Vertical alignment for text
          lineWidth: 0.2, // Set line width for the table grid
        },
        columnStyles: {
          0: { cellWidth: 65 }, // Adjust the first column width
          1: { cellWidth: 50 }, // Adjust the second column width
          2: { cellWidth: 69 }, // Adjust the third column width
        },
        headStyles: {
          fillColor: [164, 194, 244], // Header background color
          textColor: [0, 0, 0], // Header text color
          halign: "left", // Align header text to the left
          fontSize: fontSizeText,
        },
        bodyStyles: {
          textColor: [0, 0, 0], // Body text color
        },
        tableWidth: "wrap", // Let the table wrap to fit the content
        margin: { left: 10, top: 0 }, // Align with the previous content
      });
      startY = doc.previousAutoTable.finalY + 10;
   
      // Check and display status for Preferences
      if (preferences.preferences === "yes") {
        doc.setFont(undefined, "bold");
        doc.text("Preferences:", 15, startY);
        doc.setFont(undefined, "normal");
        doc.text("Active", 40, startY);
      } else {
        doc.setFont(undefined, "bold");
        doc.text("Preferences:", 15, startY);
        doc.setFont(undefined, "normal");
        doc.text("Not Active", 40, startY);
      }

      doc.autoTable({
        head: [["Cookie", "Duration", "Description"]],
        body: preferencesCookies.length > 0 ? preferencesCookies : [["-", "-", "-"]],
        startY: startY + 5, // Position below the Necessary text
        theme: "grid", // Add grid lines to the table
        styles: {
          fontSize: fontSizeText,
          halign: "left", // Align text to the left
          valign: "middle", // Vertical alignment for text
          lineWidth: 0.2, // Set line width for the table grid
        },
        columnStyles: {
          0: { cellWidth: 65 }, // Adjust the first column width
          1: { cellWidth: 50 }, // Adjust the second column width
          2: { cellWidth: 69 }, // Adjust the third column width
        },
        headStyles: {
          fillColor: [164, 194, 244], // Header background color
          textColor: [0, 0, 0], // Header text color
          halign: "left", // Align header text to the left
          fontSize: fontSizeText,
        },
        bodyStyles: {
          textColor: [0, 0, 0], // Body text color
        },
        tableWidth: "wrap", // Let the table wrap to fit the content
        margin: { left: 10, top: 0 }, // Align with the previous content
      });
      startY = doc.previousAutoTable.finalY + 10;


      // Check and display status for Unclassified
      if (preferences.unclassified === "yes") {
        doc.setFont(undefined, "bold");
        doc.text("Unclassified:", 15, startY);
        doc.setFont(undefined, "normal");
        doc.text("Active", 40, startY);
      } else {
        doc.setFont(undefined, "bold");
        doc.text("Unclassified:", 15, startY);
        doc.setFont(undefined, "normal");
        doc.text("Not Active", 40, startY);
      }

      doc.autoTable({
        head: [["Cookie", "Duration", "Description"]],
        body: unclassifiedCookies.length > 0 ? unclassifiedCookies : [["-", "-", "-"]],
        startY: startY + 5, // Position below the Necessary text
        theme: "grid", // Add grid lines to the table
        styles: {
          fontSize: fontSizeText,
          halign: "left", // Align text to the left
          valign: "middle", // Vertical alignment for text
          lineWidth: 0.2, // Set line width for the table grid
        },
        columnStyles: {
          0: { cellWidth: 65 }, // Adjust the first column width
          1: { cellWidth: 50 }, // Adjust the second column width
          2: { cellWidth: 69 }, // Adjust the third column width
        },
        headStyles: {
          fillColor: [164, 194, 244], // Header background color
          textColor: [0, 0, 0], // Header text color
          halign: "left", // Align header text to the left
          fontSize: fontSizeText,
        },
        bodyStyles: {
          textColor: [0, 0, 0], // Body text color
        },
        tableWidth: "wrap", // Let the table wrap to fit the content
        margin: { left: 10, top: 0 }, // Align with the previous content
      });
      startY = doc.previousAutoTable.finalY + 10;
    }
     // Adjust position to fit text inside box
    if (tcString.length != 0) {
      doc.addPage(); // Add a new page

      doc.setFont(undefined, "bold"); // Set font type to bold
      doc.text("TC String:", 15, 20);
      doc.setFont(undefined, "normal"); // Reset font type to normal

      // Define the box position and size
      const boxX = 15;
      const boxY = 26; // Adjust the Y position as needed
      const boxWidth = 175; // Width of the box
      const boxHeight = 56; // Height of the box

      // Draw the rectangle
      doc.rect(boxX, boxY, boxWidth, boxHeight);

      // Add the wrapped text inside the box
      doc.text(wrappedText, boxX + 5, boxY + 5);

      // Adding Additional Consent Ids
      if (acString.length != 0) {
        doc.setFont(undefined, "bold"); // Set font type to bold
        doc.text("Google Ad Technology Providers Ids:", 15, 90);
        doc.setFontSize(11);
        doc.setFont(undefined, "normal"); // Reset font type to normal
        doc.text(actext, 15, 100);
      }
    }
  }
  doc.save("generated-pdf.pdf");
}
