<?php
/**
 * Copyright 2013 Alin Marcu
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
	exit();

if ( ! class_exists( 'GAINWP_Frontend_Setup' ) ) {

	final class GAINWP_Frontend_Setup {

		private $gainwp;

		public function __construct() {
			$this->gainwp = GAINWP();

			// Styles & Scripts
			add_action( 'wp_enqueue_scripts', array( $this, 'load_styles_scripts' ) );
		}

		/**
		 * Styles & Scripts conditional loading
		 *
		 * @param
		 *            $hook
		 */
		public function load_styles_scripts() {
			$lang = get_bloginfo( 'language' );
			$lang = explode( '-', $lang );
			$lang = $lang[0];

			/*
			 * Item reports Styles & Scripts
			 */
			if ( GAINWP_Tools::check_roles( $this->gainwp->config->options['access_front'] ) && $this->gainwp->config->options['frontend_item_reports'] ) {

				wp_enqueue_style( 'gainwp-nprogress', GAINWP_URL . 'common/nprogress/nprogress.css', null, GAINWP_CURRENT_VERSION );

				wp_enqueue_style( 'gainwp-frontend-item-reports', GAINWP_URL . 'front/css/item-reports.css', null, GAINWP_CURRENT_VERSION );

				$country_codes = GAINWP_Tools::get_countrycodes();
				if ( $this->gainwp->config->options['ga_target_geomap'] && isset( $country_codes[$this->gainwp->config->options['ga_target_geomap']] ) ) {
					$region = $this->gainwp->config->options['ga_target_geomap'];
				} else {
					$region = false;
				}

				wp_enqueue_style( "wp-jquery-ui-dialog" );

				wp_register_script( 'googlecharts', 'https://www.gstatic.com/charts/loader.js', array(), null );

				wp_enqueue_script( 'gainwp-nprogress', GAINWP_URL . 'common/nprogress/nprogress.js', array( 'jquery' ), GAINWP_CURRENT_VERSION );

				wp_enqueue_script( 'gainwp-frontend-item-reports', GAINWP_URL . 'common/js/reports5.js', array( 'gainwp-nprogress', 'googlecharts', 'jquery', 'jquery-ui-dialog' ), GAINWP_CURRENT_VERSION, true );

				/* @formatter:off */
				wp_localize_script( 'gainwp-frontend-item-reports', 'gainwpItemData', array(
					'ajaxurl' => admin_url( 'admin-ajax.php' ),
					'security' => wp_create_nonce( 'gainwp_frontend_item_reports' ),
					'dateList' => array(
						'today' => __( "Today", 'ga-in' ),
						'yesterday' => __( "Yesterday", 'ga-in' ),
						'7daysAgo' => sprintf( __( "Last %d Days", 'ga-in' ), 7 ),
						'14daysAgo' => sprintf( __( "Last %d Days", 'ga-in' ), 14 ),
						'30daysAgo' =>  sprintf( __( "Last %d Days", 'ga-in' ), 30 ),
						'90daysAgo' =>  sprintf( __( "Last %d Days", 'ga-in' ), 90 ),
						'365daysAgo' =>  sprintf( _n( "%s Year", "%s Years", 1, 'ga-in' ), __('One', 'ga-in') ),
						'1095daysAgo' =>  sprintf( _n( "%s Year", "%s Years", 3, 'ga-in' ), __('Three', 'ga-in') ),
					),
					'reportList' => array(
						'uniquePageviews' => __( "Unique Views", 'ga-in' ),
						'users' => __( "Users", 'ga-in' ),
						'organicSearches' => __( "Organic", 'ga-in' ),
						'pageviews' => __( "Page Views", 'ga-in' ),
						'visitBounceRate' => __( "Bounce Rate", 'ga-in' ),
						'locations' => __( "Location", 'ga-in' ),
						'referrers' => __( "Referrers", 'ga-in' ),
						'searches' => __( "Searches", 'ga-in' ),
						'trafficdetails' => __( "Traffic", 'ga-in' ),
						'technologydetails' => __( "Technology", 'ga-in' ),
					),
					'i18n' => array(
							__( "A JavaScript Error is blocking plugin resources!", 'ga-in' ), //0
							__( "Traffic Mediums", 'ga-in' ),
							__( "Visitor Type", 'ga-in' ),
							__( "Search Engines", 'ga-in' ),
							__( "Social Networks", 'ga-in' ),
							__( "Unique Views", 'ga-in' ),
							__( "Users", 'ga-in' ),
							__( "Page Views", 'ga-in' ),
							__( "Bounce Rate", 'ga-in' ),
							__( "Organic Search", 'ga-in' ),
							__( "Pages/Session", 'ga-in' ),
							__( "Invalid response", 'ga-in' ),
							__( "No Data", 'ga-in' ),
							__( "This report is unavailable", 'ga-in' ),
							__( "report generated by", 'ga-in' ), //14
							__( "This plugin needs an authorization:", 'ga-in' ) . ' <strong>' . __( "authorize the plugin", 'ga-in' ) . '</strong>!',
							__( "Browser", 'ga-in' ), //16
							__( "Operating System", 'ga-in' ),
							__( "Screen Resolution", 'ga-in' ),
							__( "Mobile Brand", 'ga-in' ),
							__( "Future Use", 'ga-in' ),
							__( "Future Use", 'ga-in' ),
							__( "Future Use", 'ga-in' ),
							__( "Future Use", 'ga-in' ),
							__( "Future Use", 'ga-in' ),
							__( "Future Use", 'ga-in' ), //25
							__( "Time on Page", 'ga-in' ),
							__( "Page Load Time", 'ga-in' ),
							__( "Exit Rate", 'ga-in' ),
							__( "Precision: ", 'ga-in' ), //29
					),
					'colorVariations' => GAINWP_Tools::variations( $this->gainwp->config->options['theme_color'] ),
					'region' => $region,
					'mapsApiKey' => apply_filters( 'gainwp_maps_api_key', $this->gainwp->config->options['maps_api_key'] ),
					'language' => get_bloginfo( 'language' ),
					'filter' => $_SERVER["REQUEST_URI"],
					'viewList' => false,
					'scope' => 'front-item',
				 )
				);
				/* @formatter:on */
			}
		}
	}
}
