<?php

namespace FrontisBlocks\Config;

use FrontisBlocks\Traits\Singleton;

class BlockList
{
    use Singleton;

    private $blocks = [];

    public function __construct()
    {
        $this->init_blocks();
    }


    private function init_blocks()
    {
        $this->blocks = [
            'container' => [
                'slug' => 'container',
                'title' => 'Container',
                'package' => 'free',
                'category' => 'layout',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/container.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'accordion' => [
                'slug' => 'accordion',
                'title' => 'Accordion',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'freemium',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/accordion.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'accordion-item' => [
                'slug' => 'accordion-item',
                'title' => 'Accordion Item',
                'package' => 'free',
                'category' => 'post',
                'badge' => 'freemium',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/accordion.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'true',
            ],
            'advanced-heading' => [
                'slug' => 'advanced-heading',
                'title' => 'Advanced Heading',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'freemium',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/advanced-heading.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'advanced-paragraph' => [
                'slug' => 'advanced-paragraph',
                'title' => 'Advanced Paragraph',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'freemium',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/advanced-paragraph.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'animated-heading' => [
                'slug' => 'animated-heading',
                'title' => 'Animated Heading',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'freemium',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/animated-heading.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'advanced-button' => [
                'slug' => 'advanced-button',
                'title' => 'Advanced Button',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/advanced-button.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'advanced-image' => [
                'slug' => 'advanced-image',
                'title' => 'Advanced Image',
                'package' => 'free',
                'category' => 'media',
                'badge' => 'freemium',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/advanced-image.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'advanced-navigation' => [
                'slug' => 'advanced-navigation',
                'title' => 'Advanced Navigation',
                'package' => 'free',
                'category' => 'navigation',
                'badge' => 'freemium',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/advanced-navigation.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'advanced-video' => [
                'slug' => 'advanced-video',
                'title' => 'Advanced Video',
                'package' => 'free',
                'category' => 'media',
                'badge' => 'freemium',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/advanced-video.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'breadcrumb' => [
                'slug' => 'breadcrumb',
                'title' => 'Breadcrumb',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'freemium',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/breadcrumb.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'call-to-action' => [
                'slug' => 'call-to-action',
                'title' => 'Call to Action',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/call-to-action.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'countdown' => [
                'slug' => 'countdown',
                'title' => 'Countdown',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/countdown.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'counter-number' => [
                'slug' => 'counter-number',
                'title' => 'Counter Number',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/counter-number.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'contact-form-7' => [
                'slug' => 'contact-form-7',
                'title' => 'Contact Form 7',
                'package' => 'free',
                'category' => 'form',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/form.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'dual-button' => [
                'slug' => 'dual-button',
                'title' => 'Dual Button',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/advanced-button.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'features-list' => [
                'slug' => 'features-list',
                'title' => 'Features List',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/features-list.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'flip-box' => [
                'slug' => 'flip-box',
                'title' => 'Flip Box',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/flip-box.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'fluent-form' => [
                'slug' => 'fluent-form',
                'title' => 'Fluent Form',
                'package' => 'free',
                'category' => 'form',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/form.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'image-gallery' => [
                'slug' => 'image-gallery',
                'title' => 'Image Gallery',
                'package' => 'free',
                'category' => 'media',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/image-gallery.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'info-box' => [
                'slug' => 'info-box',
                'title' => 'Info Box',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/info-box.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'icon-box' => [
                'slug' => 'icon-box',
                'title' => 'Icon Box',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/icon-box.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'post-grid' => [
                'slug' => 'post-grid',
                'title' => 'Post Grid',
                'package' => 'free',
                'category' => 'post',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/post-grid.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'post-meta' => [
                'slug' => 'post-meta',
                'title' => 'Post Meta',
                'package' => 'free',
                'category' => 'post',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/post-grid.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'post-title' => [
                'slug' => 'post-title',
                'title' => 'Post Title',
                'package' => 'free',
                'category' => 'post',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/post-title.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'post-featured-image' => [
                'slug' => 'post-featured-image',
                'title' => 'Post Featured Image',
                'package' => 'free',
                'category' => 'post',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/post-featured-image.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'post-category' => [
                'slug' => 'post-category',
                'title' => 'Post Category',
                'package' => 'free',
                'category' => 'post',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/post-category.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'post-comment-form' => [
                'slug' => 'post-comment-form',
                'title' => 'Post Comment Form',
                'package' => 'free',
                'category' => 'post',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/post-comment-form.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'pricing-table' => [
                'slug' => 'pricing-table',
                'title' => 'Pricing Table',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/pricing-table.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'progressbar' => [
                'slug' => 'progressbar',
                'title' => 'Progressbar',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/progressbar.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'slider' => [
                'slug' => 'slider',
                'title' => 'Slider',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/slider.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'slider-item' => [
                'slug' => 'slider-item',
                'title' => 'Slider Item',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/slider.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'true',
            ],
            'social-icons' => [
                'slug' => 'social-icons',
                'title' => 'Social Icons',
                'package' => 'free',
                'category' => 'social',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/social-icons.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'timezone' => [
                'slug' => 'timezone',
                'title' => 'Timezone',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/timezone.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'social-share' => [
                'slug' => 'social-share',
                'title' => 'Social Share',
                'package' => 'free',
                'category' => 'social',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/social-icons.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'social-share-child' => [
                'slug' => 'social-share-child',
                'title' => 'Social Share Child',
                'package' => 'free',
                'category' => 'social',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/social-icons.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'team-member' => [
                'slug' => 'team-member',
                'title' => 'Team Member',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/team-member.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'testimonial' => [
                'slug' => 'testimonial',
                'title' => 'Testimonial',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/testimonial.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'google-map' => [
                'slug' => 'google-map',
                'title' => 'Google Map',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/google-map.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'marquee-carousel' => [
                'slug' => 'marquee-carousel',
                'title' => 'Marquee Carousel',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/carousel.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'marquee-carousel-item' => [
                'slug' => 'marquee-carousel-item',
                'title' => 'Marquee Carousel Item',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/carousel.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'true',
            ],

            'tabs' => [
                'slug' => 'tabs',
                'title' => 'Tabs',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/tabs.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'tabs-item' => [
                'slug' => 'tabs-item',
                'title' => 'Tabs Item',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/tabs.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'true',
            ],
            'critical-css' => [
                'slug' => 'critical-css',
                'title' => 'Critical css separator',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/tabs.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
            'news-ticker' => [
                'slug' => 'news-ticker',
                'title' => 'News Ticker',
                'package' => 'free',
                'category' => 'content',
                'badge' => 'free',
                'status' => 'true',
                'icon' => FB_PLUGIN_URL . 'assets/icons/tabs.svg',
                'doc' => 'https://wpmessiah.com/',
                'demo' => 'https://wpmessiah.com/',
                'complete' => 'true',
                'child' => 'false',
            ],
        ];
        $this->blocks = apply_filters('frontis/blocks/list', $this->blocks);
    }

    public function get_blocks()
    {
        return $this->blocks;
    }

    public function get_block($slug)
    {
        return isset($this->blocks[$slug]) ? $this->blocks[$slug] : null;
    }

    public function get_default_blocks()
    {
        //now return init blocks
        return $this->blocks;
    }
}