// hieu ung tuyet roi
const LIFE_PER_TICK = 900 / 60;
const MAX_FLAKES = Math.min(75, screen.width / 1280 * 5);
const flakes = [];
const period = [
    n => 5 * (Math.sin(n)),
    n => 8 * (Math.cos(n)),
    n => 5 * (Math.sin(n) * Math.cos(2 * n)),
    n => 2 * (Math.sin(0.25 * n) - Math.cos(0.75 * n) + 1),
    n => 5 * (Math.sin(0.75 * n) + Math.cos(0.25 * n) - 1)
];
const fun = ["<img style='width:30px;height:30px;' src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAPoAAAENCAYAAAAmDHgoAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAAB3RJTUUH6AcDBjEtEVlnxAAAgABJREFUeNrsvXd4Hed15/+Zdnvv6B0ECIC9k2JV742SLdmSLNtyTXZTdpNNdn+r3U2xEzvFKU7c47hXSVRn772CYEPvvdzeZ35/XPACEClZtuUkjnGeR4+IwWDu3Hnn+55zvqfBvMzLvMzLvMzLvMzLvMzLvMzLvMzLvPynlj95n2vd85uR55/EvMzLz5bnnys0/fn7HEt/rW76zz5oW/35Zz3755dvXubl3ctfPOXq+sxTztJfxbXF9/qCf/p+s99sMPzYajEI80s3L/Py7kXRSbLDZnz1+e3o/kMDXQPBbDb9dNMt1QWyRO/80s3LvLx7kUVhZOWKijqfv+DL/6GB/vmn3E9VVXoWuAsKRU1lbH7p5mVe3r0IojDhLQxIpUWOu//qWc+K/5BAf/5Jl01vlP5k7epyV1I1oQraPNDnZV5+HqALwlhSNbF6VbnHajF8VQPhPxzQ7QblD9euKvNKskQGA6msOjS/dPMyL+9eVE0bzQh6ZFmkqamg+gsf9T/+Hwroz2/3WnR68YOVVV69oJjIapBNpgfml25e5uXdi5YhlFVFBMVEbY3XZDIrf/ReafX3BOh2i/DJpU2FPkEQkAxOtGxWC0XV8fmlm5d5efcST2ciaiaDqHciCAK11d7KL3zYv/U/DNAlnfCR6hqvDkA0OElnskhaNj2/dPMyLz+HRs9q6WxWRTI6Aahb4DcbzMrv/4cA+meedDb5vVa7okg5QkFvJZvNoopo80s3L/Pyc4BRFJLZbAZRZwVAp5OwWfQLn9/utfy7A91k1j1bW+P15bW7krsnMSPMA31e5uXn0eiamkYDQTeD6+pqT5HLLTzw7w50QWBbcbEj/4OgmNAbDCCp83nu8zIvPw+WZMmiMxgRFXP+WGmJU9IrysP/rkB//hkMsix5ZTl3GUHSgyAiKUZBJyu2+aWbl3l596KIgksxGEEQc1iaNt91iljz7wp0Xdq53Oe3GGd2JEPuuNGE0WRwzS/dvMzLz2MdC06dwTSNJf0s91jvff5Jl+3fDeiSINQGvBZr/kZFJQd0vQGdQfbOL928zMvPAUZJdCl6/bR1PFPXEvBbTQZBrfh3A7rRoGswmw3izI6UY94VnQ6jwVg1v3TzMi8/h+KUZL9OZ7iuNfPHbTaDVRakqn83oAsiNSaTcsPxHBkn1c4v3bzMy7sXWZI8OoP+uhk/Y7qbFMFo1S/6Nwf6888j/tWHvZ9OptJbMhk1f1ybvjmTxYqKUDq/dPMyL+9eshpe03VPWJsBejajkUplPvGFj/qe/DcD+j8/h+Lq9++sX+D7zKrV1dZwOHkzXwO9QTfPus/LvPw8FrIgGkXpOiRngB4KJ2hsLPYtXFjwj1/8ZMGX/k2AnsT/uYX1gbVrVpebDTY/kizMvtOZC8vzQJ+XeXm38lfbi406vSK/1TrOQV5AMXtYvqzYtnBhwWP/+OmC536lQP/zJ+yVOp305LJlRUZRbwedGU2blQCnZmb5G4rpn59DmV/CX3/5yw+6t84/hV+txOVojdPrlW+GJVVTEWQzgmJiUWOB3aRX/tvzz2D4lQHdYjH8v1UrS12CICCZ/SiKkTk+ejaV/7fb79ONh93zzPt/AlF04l/MP4VfrciCuNhfVDij0bMzLnE6paIzmpAtARBg6bKSCr+p6FO/EqD/YDtSRtVuLy9zCQCizobeYiWVynKzm/OWlItOj+6W+SX89ZY/227xxuPpZX/+hL1y/mn86sRsk9e7i0qFGSwlZoCezqIzmhGmi11KixySTidu/5UAvV2xLwn4LMp12l/UWzGabcTiMyaGlknCdNGar7AIs81x//wS/nqLzWP+HZ/PoqoIG+afxq9OJFm/yVdYdFPrOJbIYjKbEa/TXgLY7Yai558rNL3nQDeZ9A+UlbrseYJAsWBzOojFZzQ6moqm5srQLXY7sqQ0zS/hr688/1yhKZXMfmrZ0hJJJ0sF80/kVyM/2I6kIRRa7PYZkM/ivqKxDBanA3FWVVtZmavAmopvfs+BLknCGo93pqpGkCTMVhux2Nz+Emoykv+30Wp1/yp6VP8myl8/43D808eKa/6tPk8DwalmXqqu8lgKCmzIiuQD+OyzHuv8ary30qo4mnyFgTxO1FR4zu+j0RRWux2mM08BvF6LZDTq33ugq6pWZjHr57wJoiSSTqtzX5BZN1lcUWG2WTxr55fyl5N/erZosaDoejQhU/Rv8Xl/sd0b+PuP+fe43eaN69ZWiJoGgqCJADaD7jPzK/Leik4n31a+oCYPLi0ZmoOzSCSOyTy394TFrEOSpQXv9jPedc14VtXcRoMy6/M1BHJZcIlkGoNemd6NgvlzShYsFBzHjj4LY/PjmX5R0D3tWx8TUrtWLKtKHzl6teMG8/oZh8OCtFlnkFfKklAggIYgBFVVCGUzmbAkauNTU5lRRC0mooU0QYoLs5geFcEmijgURSjQ6XVbBZUNWU0ra2woMC5qKkQUBcbHo/FUWj37z79VdE8slnoc+NT8yrx3YjDoHiuuaRBuptEj0SQ2h31OjkrOwhZRFNH1ngJdA+ELoiDP7kepZdMIsoS3sIDJyQgFgRzQ09FJdNN1ay6vH53BMB+D/Tnkcx9zLbSYzKahs73ncrxLdsfGzUsMohrryiDmCZHPPutZYNHJX8pk1BWlJS5doNApGy0WJFEgncqQSqXJZDKk02nSyTSpVDaTSmUyiWQ2fw1BFAVBAINBFk0mg8HhtFJQ5MFqFtEysbyfeKFl8IqW0fYk4unzFou+c36V3lseRJLkBS5fvkkTqehkHmoTk3G8hYXT2jY1528VWTK9p0D/P9tRXMLc1lBaOgayAV9JGUNtRykI5BjBWGgMORZHb8qVqfsKC7x/8kR/2f/8zlT3/LK+s3zmKWepmJb2FQW8Xtdm8/Bw/9Tnkqm0dUFDDS2nTiOjSgBf/GTR78UTyT9btrJa17h2IzpHab5E+Ges9U3XW80k0JJBsrERMpFBtNQMz9LVNdHf1TX5XatN/0J1tcd59drovvmVeu9EH43dUbV2Rb6nQ3hykvjUCGZTzh8fGg7hK88NbVHTsbl/LLx71/tdAd1GsSQIb2nqmokBLoqq62g+tAsW5w6b9AI9V5upWboKgJqlq/Vdl699Aqb+cH5Zb24t/dVHvI8ZFfl9oiwZo9Fk1+jwuO59n/qE//XvfuuPxkensrKtRLY7r/olTVr8xY8X/K5G9pNPPPeY4ipfeiPNoqmo6ShqKpbTypk4ajaJlk2Dmsr9X1PR1EzOAcskQFNvxsnQ3Dwwcvxkj9toVP5PQ0PA6PVaes+cHdg1v2rvnVgthudqlq3K47DnWgvljhnSbXAoyqJbcxyslvkVAz1EUvKKc09VkyEkK1hsVhIpDVXVEMWcwTEx3AvkgF5YXoHObHwCmAf6TeTzz7j/h4LwKZ1O0q9e3+RAZ5MmR4aID57mrg98yHnt8Itkk0FKF65xug63/WM8kQ488dzTsiUwtwo4G+4jPdlONjE5A1wNJqZiOB3GOWWP7ySCzoIgiKQSKoLe7nvo0Y247SrRSHT4py81X5YC8je/9lsB77N/NzQ6v3q/pNn+pMsmiPL6ooqZXKTQ6CBMAz2TVYlGUrinzXo1FZq7VoLwroH+rk40kJEEUXgL0Cfz/w4UFzE6NmPuCekokWDw+s1QWbeg4K+e8c5nyd1Efv8b43/2X74yUjQ0Frv39ZdPXBATA6PL1q9GNnpIT7RTtWw9wb5mBFnhkUdXFr/vifVzQK6pWXrPvckb3/su50+1MDISnL3jo1Mkzpztv/5moA8sR+dfgjDdgFBVZzwyQdQhKRYkoxeT3cniRg8ywdHdu1sO/uCH53fY7MofOFLKaz1JMTq/cr+8mHTihxtWLTNd34SDExPIzGTEDQ+HKSgrzhNxanzyrdvyewt02cq6RCxlnZ3umo1Pcj0LrmJhE50dE/nfFfkUrp07m/958YZtss1l+bP5pb1R/uQJR9kXPhr4psWo7FDRFl+8GnaRTSCKMNp/jWxsHEGUiQ2cQssmUSTyGjsbH+PcG9/ixMFTbNiwgMaGAD7v3DC3xaLH7ZrmbDSN1NglJEshxtJNCKLM1dZR4ons9KaRIhufIBvpJxPq5fjRa9Hvf/+sZ2g4Wu5w6m9LxTmRTmd7n//SQGx+5X550SnS7y3ZsDVvp187f5bCWXUtHZ3jVCxsyq+dmpiawV9WZWIsWvn5j3reVYOXn2m6P7/da9HJ4tfLKwulwcEQZWW5KRJaNoWaDCHq7ZQ3LOLgKztYrWkIgoDDoefskVaWbdoMgNFiweMPLPmT9wVL/uf3Jubnpk/LX37Qc59K9kfFRXbdgoYSXB4HeoMZUe9ANLqwRaeYGOzEYdVxvT5ZzSToOPZTsqrGleZ2jCYD9z/1AUiHiQ1fZng4TCKZRhRFPG4zVque8vKZKIyWiZMaOIa++BZEc4BQsJ2e/iDV5U4kSUDT0sj2OnRmL+s9Y+YV64aITo6WKLLKnn1tJ7t6Q78/v3LvAfH6Aec9xWUlbpN1ZmMe6mpn4TpP3tLq7gmy9cml05v6BJo2o2hHRyMECj2GSDj8LQ1WC7zzwBTpZ93QQxus/2flspJbSxpWij2trZRc7+EOiIoFyehGFEWGu1rRSRms1lzcf3AwiMVdiMWWY+O9RcW63qsXGnccD/7r/DLnSn5lWfye1WbqNJnkvcPDIXVyIixnUlFjZLJfkNKjGK0eFDV8g3/d1x8iNBWicfkiGjfdy2RfC4d37ufMJZW4XMeZo0eRdArpjIaGiCQKyJKYD8VqmTjZ2AiibGByeJh4MovTYURRxGkTcYxMsBs1NoqgxtEpAqdO97Z0to3+8x9+a2Lf/Or9kr7584iWqP2Nu5/6kMc4nQgz3NfHeM8lSoqs02s8RVozsnBlLt8sG+wiG5+ZRH712ij+ygY81rTrhcJM22unoy2/sEb/wXakIU17urbWKxsq6jnyxlzCNRsdQnHlGMGGVWtpPvgaBQU5YC9t8nDglRd5+LlPgiDg8PooKCtZ99kPRuv/4F/HL/+mL/b/+E6wA8h39vzn51Da21x/LIjaH6xZU6GzmhRR0eJEoykURUKvl2e5QlsQDS6SoWGOvfwddu/v4XiHwh/96V9SGjAR7N1LVZUXv8eITr65d6YmJlETk0wF4zjcVtKZG5l3TdPYueva6MBAsCuRTH3+f3w7+P15mP7yYmzzvL98UWWBy+fPm+WHX36BjWtmGie3to6xcN0d+Z8z0eE51xgcitG0rQFxLGi8cLHvvwHf/4V99GuSa3Vhod0oSSKKJKIYzMTiqVl++jiJaI6EK65tYHgsTiKRC8MZjQoFPoXLZ87kz19/78Nmp8vyrfmlnpG/2l5s/NsP+/57NO0bszst/2v1lo2G6jX3ir7GezBV3oG5bAOt/RK79rQyNRUH4NjrO/jpl/6eL3zm6/zlv/RyNb0Ob+Ualq/dTN+1E2QzGoosvi3I82TPSJjevilGxyIkklnUt2BdlPUsW93gNRh0blnM7p1frfdAmz9XaNIbpM/dct9D+ZTXy2fOUOjXYTTmciHisTTDozEqGnL+eToemuOfJ1MZorEsDqcdWRJxucyB559xOH5hoFss0vayMpcjR9SkqV2ygvbO2Xm4Kt0tp/KM7tJ1a7jQPDMWvbHOTfPRA6TT1yvaHDSsWLHobz7m//C8+Yb4+Q/7PqZZk8M2t+sz9z79jO0j//P/E1ffcRcaIrFwBEE2YfGUsPquR9j20IMcOpxLSlu6pIjSUgfZTIZQUkfr5fPcdfstZGJjnHr9n1jYGMDt0L/j58fjaSYmY2x/ZDGJaIKRsQjD47GZjkFabiBH2cr7eeDxbRVmq+V78zD95cWaTv3Vik3rvVanOwfiVIrmI/tpqHPnzznfPMCSdWsQpZxnPdJ9idkueFdXiOpFi9DUnM9eUe4qsEnynb8w0CVZXOPzWaZJoCS1SxbT0RWcc05obDAP5Kb12+jqCeabUYiiwKJ6F8d3vpE/f8Wtd8lOp/Ozn3u/1fMbS8Q86Wyy9/paTSbjP9795AesT/7ufxPsbievfftf+NHff54Tr36PH3/piwRbd6ImctEMo9kCs5ITF9YF2P5QPR+6zcxXvvBHLCjS88O/uJ9tm4qoq/agyNI7Lq/RqNC4pB7ZaGXlilIG+6dIZzQSyZxaD4bjqMkw2fgY7pr1Qnm5r+kzH3AsnofqLy5/9j7bapvD9uTKbXflubHjO9+gaaEzn4OSTGXo7Jpk8cZbp3WpymjP3BKHtq4QdUuX5ZKdAJ/XKhoNum2/MNAzabUiX7GWiWGyWNCbbYQiM+a7157l2tlcKE2UJBatXk5Ly2D+9yXFVsZ62wlNTEwrfoHbHnvSbfe7X/pNW+h/fg7lr571/YUoCWcXr11b+cwf/JFYWlvLwRe+z4XdP2bFQgN33lZDfUMhHo8ZNRkk3r2PWOebJIdOc+vWWjRNI5vNgbGwwM4Dd5djnvwX9OPf5OG7iyktdSKIMjpXLaba+zCUbEDQWRgZjcy5F0ExYSjZiGwvR5JmyL7rc/S0LExMREmNXEAQJZasXe6xW4x/MA/XX0z+8oN+s8lq+tHdH3zaIoi5ZxyamGC8r53S4nybB1pahmhauRRFyZnxnZcvYjXMZKXG4mmisRS+4qJcGjpgNusQBOp/YaAjCNL1nUbL5PzDhctX0to5ky/hcRvpuDjjhy/eeCetHZMkkjM3t3KphwMvvzDzN4WFLFq7YfUXP136v39jdvPtFm806zlrddh+78n/+jvShnvvZ7Svk9OvfJv6Mlix1I/JrEORBQo8RjZtqEKny238WiqCpmYwGBQEQaB/IMTIaIR4PE00miKdyRIOJ7h0ZZhrraMMDU2SHL9Csv8oosGNsWg9Or3CpctDM15XOk42OkxooJVDhzsoKs5pFWW6q6/DYeTatVHUxBTZcD8OfwmKXqqbh+wvJoqe7629dVuht7A4f+zAjhdYuWyGgEsk01xrG2fp1rvyxy6fOIxv1nj01s4o9ctWTGMylleeiiyKvzjQNS1fKZGdTr+rXbyIzo7RvFYRBAFFTDI+nHuJZEVh9bZtnDw5Ey532I0YpQTdV6/mjy3dtEX0FRX94eefca35TSBgFJP+aHF56cInf+f3RW9hIbGRVoSJMzTV2zHeZNoN75CxWlriIJHIcOJkDxeaB5icSmH3V+CvXoLFX8vwpMjOXdeYHOoh2XcIZD3e0jr6+oKzuvZqZCIDuWYGgoDVZsQ4i9lHyJUiT07GSU+2I+qdGEyK4+ftPjov8BdPOz9RXFF629JNW/N467pyFZOSwG7L17Nw4mQPq7ZsQac3TGv8cbR0NG/Wa5rG5cuDNK1ePY3J8Oz1MvzCQNc0Lf97dboYXpJlqhoX0dU7k6rXtNDDyV1vzviPq9YzGcoyMTmTQLViiY/jO18jk5nR9Hc88UGD0+d56T+7v25MJv7W7rSX3fehjwmSqJLsO4o22YzFrORXSdRZkSxFSNainDlt8iLKhncE+6aNVaxfV8HixaWUllgpKrRSvXQda+//IHe8/wmOHO0mGx8nOXAM0VKATi/lOwJJ1iJ0vkWYDKCTJTLpbD7E1tIyRCyaYuHCAGfP9ZGNjwMqbqdFMaSdNfPQfffy50/aVlqs1r+48wMf0s+4xGlO7HqN5YtnSlMnJmKMT6ZpXLcpf+zkzldZ1OjP/9zTHyNQWobZZp3GZPBd38c7Al3VNPW6BrhuPgIsXreOS1dG5mjsVGSUSHDqusnPloce5cjR7jm+X9NCF8femCHmdHo9d3/gaa/V5zn0hbvQ/2dc6P/3AesCLat96O4nn5RJTZLo2k0mOpibI28txFC4BlPNPRgrbsNQtBpD4WpEVz2G4g0Yq+7GVH0fhuIN6Dz1SGbfTctR1UyCbHSE9EQb8e49qIlJjM6ciRgKp8lGR0gNniadUjEaFUS9A0PhKlLD59HScaKxNJqmkUpnyWY1Kivc7D/Yjt1mIKuqxGJpsuEBbE6TJYvqm4fvu5M/eZ+rxGQ2v/bQc89ZdPqZ1/vom2+waKEzz4cAHD7SxZaHtueTo2LhMKGxIdzumfZtFy+Ps3TDLdNKOIuWnnGhtYyWeKd7eceEGUkUo/FY2m4y66Z3kCkkowerw4HJ7mZkLIHPk9M6ixt9HH/jFbY9lhsPFSivwubx0dk5TkVFLnRQWmSh/VA3E8MjuPy598XlC7DtkUdqd/3oR69pr3Vt+1mpfL92vpkqfaK0qkRzWlUSfYcQZAM632JkewnxWIrW1qvp0Pi5oVgo2B6aCF7r7xnoiUaiYUWWPRa7qcThspdb7M6AyWL1FJRV2Iprl+l0YgY1PoGaCqOmQmjpOIJiQNQ7yEx1Eu/eiygbsFp0jIxHsVkdZNMJFEVEFIVpS0FAEGWOn+rG7bWi6HJ9RQQRjCYFl9tEJJKkuspDd88EZkcfFrPFKiH65yH8Lty17V6LxSLtv/vJJ91u30xfzfGhYULD3SxbP3Oso3Mci8tLUdWMsXTizR0sbpql8SeTpNJQWF6Ww2JicqaBpAYZVU3+QkD//LO+xaqqujq7J2hYGMj5BPFxJGPOyl61bStHXv4Jd2wtyRFsHjPnmjuIBINc72a56cHH+eHf/zWlpU6k6ZlSa5Z72f/ST3noI8/lq3JKa+uFFRs3bvpnLft3/F3vp/8zLbisk++rXlAsp4bPoTgrUbxNRIIhrfvo0dax4fGvtY50/cOnnm+J/Kzr7P9fDzTFuvpfOfj9A8VplyjofU4ql9VTXLsCRacnONwNU63I01141UyCSCSFXxDIqhpdXeMsWZxrOXfdMhN0JtDA6cwVveh0IuL0miyo9hGNpXE4TFxrHUFLRTDqNUlvlCvmYfzO8oPtSP024fX1d95WXragfrYrzIEdL7Bh5YynmsmqnDrdz2Of+q8zzHo4xMRQHysbq/PHzjaPsXrrTLOmnDs1bdL3TZFIZpf/6Qc8BX/8rbHBd226/2A7kk4WfnTH3WsMvf0zDr8Wm6lQC5SUoIl6xidm/PCli/wcf2NH/meT1Ub98mVcuDDz2UajTEmBnubjx+d85qINm8Sqhobn/u6TRb/zn2dXR5dOZ8s8lgQ6Tz2KdzGtZ04OHt356uPLHvnmgjU0vPC0646fOc1m6vO/u32hsfhVR8dkSc2URbB1Z7h08SLtl9s48JPvs/fbX2D82j5kdSaZqbV9nKwGRoOCKAgUFNhwOHLEj2hwoqlpMsFeFEkkO91dajYZ53Aap013SCZzG4PRICLJYvk8lN+B1wKhz+b/VuOqFWsWb9g8h1JtPnaM0iIDJuOM+3Xh/AD1y5dhnpXYdvyNHSxZFJhZ/2Ccick41Ytmuqers4DePxBm6x0rrW677gc/l4/errfdVl3t8ZVWFzM5lcgb09n4yJxuJGtuu4OzF2Y+0O02E50YIjI1Uze7fNtddPaEiMZmYu911VZaz53M16xfl00PPKqUVlb9+d9+3P++/xzLbrMIaJqroBjVVM7Z/W8e2PP3X66497f2/DC3WpIrKygnxz//u3879Y9/6HzrX0/89X9bP/6Z3zoY6x/4ytTpc8WJdIzTxkHOW0a5+6kn2HLPVtaucLJqRTF+X46gmZhKcOxUH20dY9TWBXDadQgCmIw590uQjYh6G/GuPajJIJPBZD5mazLOrXEyGGQQBeLTQzoMRgUJoWgezm8vf/Os53MVdTWPbLr/4TkPMzw1Rdu5U9RVzlSrRSJJ2rtCrLz17vyxaGiKqeE+/L6ZkNq5i5Os2rptprhJ0+YAPZoUqagtJ+C31v7JU+6idw10m8X0bE211yYIMk6vj7Hx6LTJl51jMhRVVpDIiExOxvPHlizyc/S1F2b8fElm04OPcOBQ10wkQBBYu9zL7h//aE6jegSBO97/QX1BcfnX/u4j/l/7ppI6oyYoOjmVMZWnzx7Y9a9r3veDTb/9GkmAz77PU3h67M9PZpPJjsi1tt9Kj01dHP/sb50c/8xv7xz7zKePjv7JJ1rjvX2vT55r3jDZ1WW7oozxhqUTy/IyPvTHf0RZiZ1E72FCUxFOn+2j5dIwvQNhIvEshUVOGhqL8bhMmAxv8c6yKZJDp8kmIxw91oXRrMNqM2C36pClG18HRRJJpXJAz1XAifZ5ON9c/vJZz+/6S0o+fdcTTytzurZqGrt//CPWrfLNCZseONTJlocfRpJn1ujE6y+yuGlGm4dCCYZHQtQtXTqzhInxXEswIJHIoDPaEASRujq/z2XVP/GugZ5VtSUulwnIUtm4iL7BGfM8Gxmac+6Gu+/jxOnBOVo9ERplYngm5720tg6LK0Bb20yZnc2mo8gncfbIkbk3JInc+/SHjK6CwEuffSqw6td54Q1xe0xAFDovXfrXjU+/8NScZyypjpMdzmt7hvfvlfzO8cnzFwrHj59eMXHm7K0TJ8+smTxzvnqw55rlnNjLG7Z2UotdvO+//Bdue2w7YvAiyaHTRCMJTp3tx+WzY3Va0GY1HHFYdTisNzL012uag8EETY2FrFpeTLHfjN1y8+aSoijk+ZXc+gjz47BvBvJnPB91e71/9uBHPqYT37Jhnj10iJKAgnXWM756bQSrp5CyBQtnQD02RGhsEL9/RuufPDPIutvvYvY1Z2OwfyhORcMiNFXF4zEjy8Kmdw10nU4yCoKAlklQtXAhHZ0zpngm3DtHCxdVlCMoZoaHZ3z5lctLOLTjJ3OuueWR93G2eThf3QZQX22jt+UkI/39cwksReH+Dz9nLizx7/ubjxTe9uu6+L/7w764IHH0lcs/+uhbf/dH3564hCBmRJf88dejRx27/f3qicIxDtu6OeTs41VbO8e9o9g31fPUH/wB9z79DA5DhETXLrKRAbKqRt9whKpqH9JbkqIsRgWb5Z27wjqdRiwWHbIs8k45VYos4vFZCYeT0+a9bHx+u9cyD+0Z+YsPuf+72+f9u+2f+LReVuY+9+H+XnqvnKGuega88Via880jbHl4rod68KUfsWJ5Sf7nsfEowYhK3dIlc1iATLhvhojrj1FRVw+ZBJIkotfJ7nfFuj+/3WtRlFzZjJZJYHM6EWU9oXASm1WPlkmQjY0imWeo/1vuf4id3/ka99+Ty5C0WvWY9Wl6r16kZEEjAHqDgY333s/+fa9xx23T3W8E2LC2kF0/+QEPfOQT6I0zCSJ6g4EHP/qc8aWvfnnH339K98yn/6Hr17J6Kh3Unnz+K6g3tZxS6v8Ojg7/5eNP31+EMUAwmELVNFDTWK1mDDqNbCqMFr1MfHQUTcuSSqtEommiiQxG042pBw6rgs3y3k3BUmSRQKGDzHRvOb/faujrnWwAjs9DHP76o4HPe/z+33roox9XdPq5zz0ZT3Dgpz/i1k3Fc9i6fQfb2XT/g3Pe94G2FhQhmSdMAU6c7OeWex+aM7whG5/I57hnMyqqoEdvNBCfnskhy+JNe73f0GHmnuWiw+60fLy2xmdFU1HcC0inM4wNDhHwGae/QBydvSRPDpgsFvra2tHS0fyN+rxWDuw6Sf2KtVxvLOn0BRjo7CA4MZHP35UlEZdDx8Fdx6hdsgxhlnqRZZm65cvl8f7+B7fUi4Hld02+vm/fr1ecfeel2NuGznZdTLS8WSV+UNYieq9pyqhLD6LPDKLPjkCsj0y4HzU2SjoZJhJLMRFKMT4Rp6d3kv6+ycTwUDCSiCdFo1EvSbKI1aJMt51670QUBcLRNIoiYdTLaJpm7R0IDbxxJrrvNxngf/6E3fnAGtdr1Q0Lt9/39IcVWZmrMzPpNC9//UusWuLOd10CuHBxANnsZ/mW22a5UxpvfPvrrF9XiiznINnbN8XIBKy/6+4554V6ziKpOc6suz+Bu6wRb2Eh6bHLoGVoax8f//HByX/8maa7qup00jTaNDWNlolTt3QJV68O5dl3ITnKldNH5/zdLQ88wsmzg/kceJ1OorbKwcldO+act/mRJ2jtCDI+PrswxkRdpZE3vv2NWbnYM2TenU9+QF628ZaP+8fLzv/Fdm/gP8vLIoCWUrOPHTrSqR0+1jUVjqWJJ7PEkxmiiSyhSJrRiQS9gxEuXxlWDx9qC+9882K6+VxPZ0fb8N7OzrHdzRf6Ovbvu5JMJTPYTG8D8tnEkCAh6m/uZut8TZhqH8iP522+OJjMZFQkSSQay6BqGgUFTkGWhUd+k0H+J0+61pgs5pZND9y/6fb3PSm/1SfPZjO89LV/pr7ajNs9o2BHRyN0dIfZ/Mhck/3Mrh1UlttnxpqpGseO97L10cfmnHf1zEnExEynmdb2KaqbmnIDOKY1uiBoyrvy0YWUlNGuV7STC8ybrVbcBcUMDEWmd3kIDbYTnpqa8QttVuqXr+T8hRmioLraQ3/bZULjM+mykixz9wc/xP6DnczuKltSYqfAneWNb3/9BrADLFq/UXzw2Y82+qo9LX/1jP+J/ywvzf/6TqgVhFuam/vHfvj9M/H9+9tiZ872Jy6c70ucOtMT3H+gdeiNV5rjZ053HxgbCf93JZst/INvTVb+j+8E7/7j70w96rYEF6WTmUujQ5MJaZZ9JsgzJqDiWTgL5wo635I59xCPpdl3oJ1MZAgBEUGX8yfPXxjQv/BiM7KYo2ViiQw6m4/SYof/s095tvymAfz5ZzB8/kOez5aW+F7/4O/+bkH9ilU3lB5pqsorX/8yVSU6SkscM2Z8KsP+Q53c/dSHkKQZ7R+dHKXrSgt1tTOu8MVLQ5QtqMftn0lCTMTjjHZf4fqfhkIpzA4POr0OLTE+W+tn35XpfleDK6uYtN+ur89Rf6JkQLIEMNtsnD95gary3G5vt4kcO9xCddNML4KC8nIOvLGPshIrOiV3aZ/HzIGdR6lbsSZv6hvNFkxmI4f3nqC6ypM/7naZSMcjnDp0gsqmxYji3NszWa3ULV9pHBvsffCW6uyjG+uEnbsvJCd+3V+g3c3x0VtciS8KRn3bxFQsMjIcCg0NhbvGR6NH4rHU91Q19fE/+k74H3Y3J069eTE1p9Xyy6dRtzYZCkwm3cqa2gIDmorO24hk9JCNDSPIRnT+JWQmW5mYjBKPprGXL0M0eZDNPtT4GM1XpujtGmawf4iKMhuKq4rw+AiClmJoKEgwnMXrMZPJgtVmp6CkyNx6uXPr+jrD9/ZciEV+E0D+p0867zLL1v1VDQu33f/h54wGk/mGc3Lm+j9RXiRTXeWdpeFV3njzKmvuuIfCytrZIRBe/ZcvsWpF4UwbqXiaQ0f7uOepZ5ntDhx+5SVqSkGvyx07dynE4o3bMFutZKa68g1Krl0bHfzJ4akv/kygv3EplLlnpfX3GhYGpktksijOSmxOJyf3HaQwYMSgl5ElkaHBMfQWL1anc1rTi9g9Pk4cOEVVZe6YXi+jZtL0dA1SXD0z5dVdUEQsOMaVix2Ulc20I3a5TChShgOv76O8vhFlVjHA5MgI3/+Hv8VmyIrlZXZ/Jq09vG2xoXJ1hengvkux1K/zi7SvC3X3xcTFPc2JHbubE/+6uznxrd0XEzt2NydO7bmYfseBCbc1Ge4vq625paJhsajGRtEVrCA92kxvzwhD4+BxSITHBjl0qJPzF4co9qnYi5vIBLu51tKKrXgplQUZzp0bYHxkkNJCCz0dXXhceiRZZnwyy8jwJF6flWwqiqu4jpLSgL2/q/uZe1ZafRtrlUu7muOhWXyT8H/+kwD8/z1hq7lvlfUHfq/14wvrfb54JCweeXMvJTW1mCwzTHo0OMVLX/lHGuvslJfNJb73H2ijvH4RDWs3zzl+atfL2PQxSmZp/gOHe1h8yzYKysryx4LjY7SdPcyCalfeOrjaHmP55pxRlRptRsvmoiJXrgwPvHAk+M8/E+h/9ZGCW5LJ1KcqKtyiwaCgZZPI1iIEWY/eYOTS+SuUl063cPYYObT3DPXLV+X9QIfHTfe1DtRUFKcjxyq63WZaLrRjcXq53isLoKi6js6WC4yPTeWHNALYbAY8TgO7duwiUFKMyZbbNLqvXsVlCLJqfSM+t0LdAr/N5TIvm5oKP3PbEqNtTVP0+L5zZH6TzEkNhKPLzF9esWWLw25MEgtO0HK+le62Ds6c6UWnVzAKk/T3TaFmNZrWrOXNl/ZT6U/R2nwJWW/GVVKPLj2AXifR1j7O6GgERcpQELAxOBji1gfvpvnMFUaGJrA5zCRCw7j9AZZuvt1kc7jWqdnUJ7fU81v3rLQ8fe8q28c77vSEf3Rg6sKv83P97JOu4ntWWb5kMRv+bNvmmoUrV5SaA34blQsqyaaiqLIDT0GuMGW0p53XvvMNbllTgs83d4DGqdO9yEYH6+6f65cPdl7l2slDrFpZOhMq6w0yNAmb7n9wrsX3w2+zvMmZ7wR8/uI4NStuweX1oqXDpMZyTZXHx6OcvzDovm2Z7V/fPBsJviPQ711h3n3bg7d5Ott6KCrMgU+UdEgmL+5AgGO7D1BcaEI/rdXj0TiRmIpnVueMoupqdu3YQ1WlPZ9tVVxoY98bhymoqMGYH+ouUNG4hAtHjzM1FZkDdqNRoaTYzr7XD5BNRvGXVaOqKj1XW6hZ/xBqYhwtHcdmM4gL6/02k1G3LjKuPX3rYqO8ZlH07G8K4I0fdP53g1H/wLYH7hdTIxe40hnDZ08RiaSIRJNkBR0aAk31Xto6Rll7x+2EJsc4deQi0ViauoUVGD0VCNEuIpEUNpsBg7scqxk8ToXWtlEW1JdTWNNAbLyHM6d7MFv0WjoeEiKj7Vh1EWqrrPKihgKLKItmTdVeeuz/tn/m1xngd6+0fk5vlP5m7eqK5Zs2VpptNqMAIBk9GErW0XLiGFVLVmO2Wjm/73XO7NvFts1Vc9j16yCPpSRue+KjzB6TNjkywL4ff4/Nm6ryyUjpdJZde7u47+ln0Rtn+JW+tlZCA5eprMhp81Qqy8WrQTbcfW/u7yY7UKf7vZ89P8SKjaulkb7ehh3Hw//6tkD/syddCwsLbZ9eu22zsfnsNSrLLAiCgJqJozirEQQBs83GxVPNlJc5prW6mSP7z1G1aBnXkwUURcFssXH+1BXKSy3T7LlIcZGN3a/so3RBPXpDjo0URImaxcu4fPo0I8NTFBXOZFgqikR1lZvOq51cPHWGBUuW03zsCDU1AXT+JWjpOGoyiCAIuN1mqWFhwGEy6jaExtQP37bYHNhUL5/e3ZxM/Kdkfp+wrbpnhfXbBoPhQw8/+6wsRS5y5eowC5auxKqEab44SGGhi7ue+S0sDJFOxWlvH6d+2Qr8fiuVRQJtbaNUVpdgDdSghdqYmIwxOhbh1kffj0GKIakxLl8eprDQhr10MUXWCSKROFeuDvdOjIYmo9GkNjYeTba1j0UvXx68MjYY/u0nPtv517+WPvgHnY33Lbd+UW+S/2z96vJVmzdV2zxus3idP5LtpRgKV5OZ6uDMsXM0rVnPm9/+KlpijFs2VKAoc3XmsWPdqKKe2578GMIs8i08PsIb3/k6WzdV5moJpuXQyVFql66hrHbGh89mMuz83r+wYU1xfkM4c2GEhWtvw+HxABrJoXOgpshmVS61hli7ZT2dly7rm6omvzhb2c0J/pn08j0V5S6npmWpaFhCT38bZcU2tHSUbGQIyRKgurGRE7vfZGgoTCBgRRQFVi7zs/+nP+COJ57OX6tm8SLaL1+ioztJZZk+r6U3rS/ltX/5MhsffIxAWW6KpCjruePpT7L3B9/k4OEO1q+tyLfPEQSB5ctLGBoK8+JX/oFwKM5o+yn8ihF9wQokS4DUyHm0TBJBEKit9Zpqa7yl3X2Tv3f2bP/7/uFjhoPBqdj/+6Pvh6/9upvof/Nh3wN6o/JIMpG5x2Q0GhtXLTU0LV3AQOsZDp+6xl3vfxxZSBEPqWSzoFdydLlep9HZG8Fs0aOmwugNekSDDrNJx9jwIP4mHWlRIB5PEYulyEaGMJptJOJDyJJIV0c/y6rSJA12bHYzJSU6X2t734qh8akhISPaZckw/N/+dfjXbvDi888jKq3OO0wG+X/Z7YaKFctK/CXFTmF2Prog63P9A6zFZII9DF89QXAqyotf+QdWLS8mELC+JbSmcuhIFxaXn40PPTlnDuJgxzUOvvRjNt1SniffALr64iTSMkvWrZ1zraOvv0xTnSu/iUwF44xNZNhcl+O6stERtHQuI7WjK0j14hVoaoaycpe/byC4Bsb23VSj37fa9jsLFwYW2j0BPOVNnNh3lMoy63TYIIlsKwVBoKCsnN0v76VugTen5c06hgbGyGLA5Z8Jc5fW1LLnlT2UlNjRKbmnp9PJlJc6OLz7CKIk4S4onga0SEXjUmKxJIf3naOw0JpnGCE3LLC60k13zwRDQ2HGBzoIFHjQOcqRHZUIspJrcq9lQQCH3SjWLfA5Skqci1Ip9cFb6pXtm+sM4xsejl/7dUu6Afg/wO1Lze/Tstpzd9+32rpmbaUspMfVY/vPCCZfPfHgECXFbgQtybnzvVhMOtKZNEVlRaRDPZw40UP9Ah/DfQN4AgGuXLiK223i6tUhaheUkQz209k1QSadIRocobC0jGstV0klNRS9ESk9jNnu5ezJy6y9/Ta549KVOzKa+I9/+M3J4Z0Xoulfp2f550/YnXcsMf22MWL9ZnWl59GtW6vrlywuttjtxjzIBcmAzlOfUyYGB4mxNg6/+iIdneMYDDJ33V6HzTa31VcolGDnnnbqVm5gxa33zslfuHT8IOcP7OTWrVVzQB6Nq+w90MkDH3qW2V1oBjo76Wk5MaeV1N79nWzd/kGMlhzjnx65gJrOBT2Onx7hlvseREiMkYmOSIPD4asvHw8duinQ715h+Z2GhkCJ3mRG7yxjaGAIkxTHYJDR0jFkawGCbMBktRIaH2V0cJCAP+dXB/wWDu87TXHNwryPIckSBWVlvPnKYSrL7MjTbYUlSaSy3Mmls5cY6u2npKY+/1D8pRUUlFex65XDGPQSDvvMwxRFgb7+KW67dQGJeJqDu45iFoM4AuVI5sA04PWoySmYTgUwGBQqK932ugX+EkUR7wm2qb9/7yprxdp6uWXvheTUr9ML+ubZ6L71NfL3hvpH7Fev9AkjY6pv9bo6Ue8swWuc4lJzK9FgGKO/Hqchgk6R6G9vo28gjt1pprrCyeFDV3HbVM5dHGbViiK6e6aITAxztXWMxU0BRsdixJNZxPQkw8NhXC4jNoeF7v4kial+Usk0Okchq9Y2OttaWh/dvNB4duf5aO+vg/a+rci+9d6V1i8giH+3amXZxm1ba/zVVR7L9USVHMB1KK5a9IUrkUxeyKZpO/Eqe3fsorLCzfLlJQwMhvJdk65LZ3eIU+fGuOPJD1FaWzcnrn7gp98h2H+NTRsr5xQIJZMqr+7sZNsjj+IJzCjIeCzG7h98k03rS/Lnt7WNoXcUs2DZylwwLBkkNdoMwPBonIzio6qhkfRkG5lEiI6OsdYdx8Ov3BTo96ywfLi+PlCiyAKKsxpPIMCJAycpL8n52clwCL2rPEe4VdWw79VdFPosuT5kokCB38y+N45Qu3R5PgZutlqxu9zs33WaqnLrHJO8uNhOcHyUY/uOULqgPt/90mS1UrdiFS3NXVy61IfHZcAwzTh2do5TWeHG6TRRUeHm4oVOrp07idMuY3L6kUxeZEcFgqRDTQXzgJ+cijMwENQvW1ZiLC12rkjFs09tazJ84LZGY3ztktiVXxfy7p5FOglZvmXxisW3WD0BY2VNCZmsgF03xekzvYiKgYWrN6JL9xCJpLh2bZiypnX4HFkMeo1LV0YYHs+wYu0yzLo4nZ3jWBweLJ5Cir0CrW2j1NQW0TUkUFthwWiU6OoaYfOjT3Ny32FWryrm2sVWapevFpauW+s2SOntK0riH717uenBe1Zb79vSaHxmy0Ll6O7m5OR/CC7jfa6Se1aa/rtuyvxtn8fy+MoVZUucDqMyOBjS+XzWvHYVZQOKux59wSpksw80ldHWk+x74YfEglNs2liNa3r8dHfPJOXTIeGpUJIDx4YRzUXc8f4nmT0dNTI1wUtf/Qf8To2lS4rnDMvMZDRe39PDyq3bqFy4cM7G8Nq3vs6qxW7M0y3cIpEkx08PcucHnkWcThGP9J1GyOa8pSMnhtlw7wPoDQZSoxfJpFK0tY+f3nE89MpNfXQEUqlUrumcmgpjsdtRLC6C4TR2q0I2PsJI1zV85bXIisJdT3yQ1771DR64twGdTsJi0dNUZ+eN73ybez74dF5Ll9XWkkzEeXXXLm7fUszsHXRBrQ+fJ8bLX/1H1t55D6V1i/KE3raHH2FscJDDr72CrI1RX2ufzjPIjWdWFIl1aysYH49yfPc+kqk9NCxbTM3yDSiuWmRnFZlgN1eP7SEcSbBhfSWCkOu4WrGgxhmdHHZeuTr8j1euKn/6dx/LHgyFk5/54+9MnfuPBOzPvN/VgKRtNBn1a0VJWBEo9js23nWb3+4rFY/u+C6SvgkrCdQkGC1m6hctwKCTEHUysYSKzW5k4cqVhNt2kkmGUBSR+596jFR4HC04QUYVWLS8HtFaQrr/AIIkMTkxxR3v+wThtjdJRqYQENBSU2y7/za04DUmxoJEuw6hGIwsbAhYF9Z7rX2dHRU7d16NKJr2sd/PDZD899Pe29HpFfsDBqPyeyJi/cKFAUN9fYHO5i1ATSfQ0mHisTT7D7VTvyBAzapNyPZyBEEim4hw7eQ+Lp1rxmSUWdpUiMNpvIEwGR6JcKUtjKCzs+Xh90+TYzPS0XyS42++wS3rynG65taZJJJp3tjVTeO6jSxYsnRuzP3Fn1JZJOOc/sxsVmXPvja2bf9Avm59tLcdJTKAqEiMTyQwOXxYHQ7UVBgtEyedzqIJ2pwecvJcnNOVTKQ3gZFsZBDRZWXNbXdweMcPuWWVG51OovvqCXxl1SCI+EvKWbFxI3v3HeOO2+pAgKJCG9HYJPt3vMSm+x/IX7t20WL0RhOvvfBjbt1ahtUy4484XSbuuq2Gw4fepLPlPBvufx/SNIPvKSjggWc/Qn9nF2989ztMjI/T2FiQ76hyPU6/eVM1yWSGK1fbOXv0FMXlhSxet5mMqpFIplnUVJgzYcw+9IVrEEQZfUmWNdXjxlVbRo397ZcfP3+2bdvff9wwnkln/nkqoX71+W9PhP69gZ7ISN12E79fU+0uXbO+TpZNHtT0INH2FsaGxtCyKUQ1zPhkHE3QMTE0iK8i13IoFBPJpLNk4xPIskh7RwS9TiE21ovBYiWSyqAh0331CjVrykkDqZTGxESEdLgPnclCf+8giiIxcu0E/to1JKaukc5qvLijmUxazeoN8nAslhKzWe1yNJr95B99d/zKv+emqDeIv5XVtMdKih3iomU19pKaRiSzF8noAkFEy6ZJDhzByDi337qAXbuvUbJYQh3q4Pyh/Qz2DlFR7mLr5ur8AI3ZMjYe5dKVIXoHYtz15JOUVlfP+X06leTAT75NKjLBPXfWIb1l0GU4kuSNne2su+s+ahbPnXB19sB+9OoEFeUzbsHhI500rV6Dv3S6VZ+mMXDlBNWlOfycvzTJpofen7MSIrkeEPFEmmwie/ltw2u3LjKUuz2WO70eC1omjuKsRG8w0t3ejVmXwWgQEbQ0/b1jeEtyjLmvtIL+jjbGhsfzI5PdLiMjg6N0dQzOCRc43G4C5RW8+eJeLBYFu22u/11W5iQRCbP3lZ14Aj6sztwuOdLXx54ffpv6Oi8b1pZx5coIg4Mh3C7znLCGLIsE/FYW1PjIZpKcOHiSC8dPs3JFaf48fWAFos6SJwBFnRnJ7MNRvJDaRU2mhsZSj0mX3pqMxJ65fZl528YGpXnXucTIv9fLu+9SLHVro/WroWjU1dLcX9jV0RVtudBlvtY2JWSRUIQIejlLy5UJispLGenpoajIysVzrThL6jEwxcRgDzarkYtXJmmod3Ph1CVKy32cPtWBv7SCyeF+vB4D7Ve70XQOqkpNtJxuprg0wNW2KYqLzFxu6cbvNdDbM0wGM3dsK6evP5rp7Jm626aM/rdPfSn69d0XZw3w/jeSH2xHWrnU9dhdK80/str1n1q+qnr97Q/fbWracKfBVb4EyexFVEx561IQJZANZEO9OVNagP2vH2Sou5XKMhvLlxXj81nm+NI5vznN6TO9dHVNctu2BZgtBo7tP4rd5cXly6W79l29wKv/+nUqS0wsWVKUd1OvS2/fJHv2dXLb409SUT93glLz8WOMdzezfMlM6uyVqyPEVTPr7t0+h9Rz6qYwGhWGR5NEMlbql+cmt6SGzqFlk/T0TiQvXxn50z0XkwM3BfrmBp3BajZsLy116rRsCsnkR1RM+IuLObjrKFXlOZ/m9PFLFFbXozfkzIvyhYs4efAIWjad70Md8JsY7B+hs62P8roZcsJss1G7ZBmHd+XaIBUErHN8F6fTRGmJnaN7jzLc20VJTT2n9+xiUb2V6sYGFOKUljjQ62XOnuunfyCI2aTDNLtyS8hl11VVuikI2AiHk3mGNBsZRFOTiIoZQZpb7SXIBhSLj0D1Yqlh8QJbkV+uSYQij21q0D+6rcnQ9ubZWNe/B9h3XoimXzsVfXXlvZG/yfRLxfULy9ZsfuwZwWMJcubENbo7h9m6/UnS4SF8ToE9u85g9wbwlZRT5Exw+kQHXV0jLNl6D1Zpgng8yamjLVQ1NmF3uSjyZNj9xmmSWR31y1fjtUa52DJA29Vult32AJnIKBWlVva8eZax8QRL1t+CUZhkKqxKUxOhZZGY/L1/63yFH2xHWrnS+cmwwfKT8nLXI7fetaZo3T33m4obNwg6i/+GtQVQUyHS41dJj1/K9z7s7p5gyZIiGuoDNyS8AAwPhzl1ppfWtlGqq70sW1qMyaRQVLWAkgKFC+e6qKivZ/8P/5WuS+fYsqkKn29uXw5N0zh9po+r7UEe+fin8RQUzvl9y6kTjLSeY/WKmcKW7u5JWjtC3POhj+f98mgwxOk9O1hY7wMN9h8ZYMvDj6HT68nGx0hP5CLIly+NjE0Mxf7vrkuJ5E2Bfssa14gaT3yqsaHAnCMGUsi2EnR6PdFwjFhoAodNwec1s/vVQ1QvWoosywiiSM2SZRx8fS8GnZivSS/0mxgZmqD9WjcVC+ryu6qi01G/cg0DPUOcPHaZwkLbnFCaokhUVbqJhafY98ououEItdUOrKWrUOxlaJk4RiVNebkLj9tCR8cYF1uGSCbS2O3GObux0agwNBSeaYSvZVHjE6SnchlFgigj6qxvKeUUEPVWrIFaapoaTNUluqLwxNQDG+uVpasskRf2dd28kcR762faXPsuJeMAn9nutN+53PyYLW3/cu3C2vtXbl4rZTIiZrWfK60jFBQ6qVy6icxUG4qc4crVETbdfSuSToecGmFkJExhWYDi2uXIiR5kGfr7g6y9dQuiKKLTJmi5NMgtW1dg8lYgxnqIxVKEI0mWb96GmprCKCW4enWEusYyShrXkw12kk4nWbh6i398ePDpjfVS9ZaF8sju5hkt8itLbnm/2R8zO45UV3oevfv+De7FWx/Q24oapy21txaUqWRCfaSGz5MavZgr/pjV4LSjY5wFtb4bfOhLl4c5eryLZDJDU0Mhi5oKsduMSJYAhsJVSAYXWriLkyc7uHb6CBWlJpYvK7khcSYUTvD6G9eweku555mPYDDO9ddP7z/AeM8lVi+f8fEHh0KcvTDCgx/7bRSdbtolSPHyv3yJ1csDGPQybV0RbIULqFiQi6mnh8/nQ20XLg52fPrLQ3/ztqb7vtPh9F1LzR+uW+D3SJKIlooiWwsRZAOBkhIO7zpMWbEJg0HBYZc5tOcUtYuXIogikiRTtWgRe17ehcNuyPvgBT4jkXCM8ydbKK+ry898FgSBkto63IUl7H75EGhZvG7LnHVyucyUlthpbx9iaCiEWZzA4vKj8zTm8u8FCVlMEfCZqKpwk0pnOX+hn+6eSfR6GatZDwJMTsYxm3VzJmMAaOkYmXA/mWAXmppB1FkRxLfwk7IRg7uSiupCg5wZr51MZretvi/yzV91LP7Oxabldywz7bxnheV5d8DyyRVrFj62+Y6NpWODvWJ540rE7CTJ0DAXW0aorSnAU94EU5fp6Z0iFIpR21iPQa8nGx2kvXMCp91A0cKVZCbbGBsNMz4Zo7qhBp3emDunK4LRoFG8cA3piWtMTKUZGw1T11iDTiejxsfo6JxE0NJUNS5DS4WQidN+5Zpwx/0brQV+y9J0MnXv2krhf29tMjyztVE/sLs5cfm9fi6fe7/VozMaTm/ZtKByzZ33GczFyxDeMrpK0zTIxMlMXiM5eIpMqCc/kHC2jI5FyGY1fF4LmqbR1x/kxMluWq+NEfBbWb26jPIyFyabDcVehr5gOYqjimxslLHWI5w53U0ykeDO2xfg9dyoxS9fHubw8T62PPwYi2/ZnNfMAGpWZd9LLyKlhlnWOJMNOjYW5djxPh742Ke5XiGnqSqvfutfWFxvxe0ykUplOXl+nG0PP4ogiqiJKVKjF3PmeyrLxZahoy+fCH3/bYEOcPcq82KzSb8srwEzMWRbKYIoYrY7OH+ymdIiC2aTDkVSOXviEtWNTSAIKDo9VY2N7HpxNw7HDNg9TgVJzLL/jSOUVFXNyeW1OpwsXLWGrvYBTp24is9tmpNQoCgSqqbhsBvpaB/lwskzCPEBnIEidI4qFFc1siWAIOmwmAXKSywE/DZ6eyc5d76fcDhJWamTjo7xGwoOZp56BjU+RnqqjeHeHno6+nH6CpFkKe8LSAYnvpJySQ33FUQ7tNpXTkV++qsE+q6LiZ7NC8UfGgy6lQa9UmA2YElGRsWuzlHqmhaSDfVw9vwQkk5BzSQoqqohMdnO5dYwxYUmwsEwbp+XiaFeegeiCGqG4spyspEBLlyaQBY1zEoaq6eQ0d4OIikb40P9VNWUoqam6OqNoaoaieAQgbIaUqF+uvsTOGwyJCex+UsZ6+/m/Pl+NREZjw0NTMTGxiLpjKoeTcTV9//xdyff81ZTX7gLPQ77kY2b6iobNj8kSZa5PUiCExO0HD2IEOtEDF8mGxvLh1dvJqdP91Jb66Pl4iDHjnejaRqLFhWxeFEhngI/emcFel8TOm8TkslPNjFFz9k3OPDGPnq6x3A5TdjtBkqKnDcQdjt3t6HYirj3mQ/j9s+9z1gkzCvf/hZlAaitmNuY4vCxHh788Kcw2x3547t//APK/BpFBbnN5ODRAZZtuzvP9KeGzuS1eWvbKH29oc+/ejp85h2Bfs9K62eDobS3ptqNKAqoqSiS3oaot2F3u+lu70bMRrBa9dhteuKREFcutlOxsCGX+WYwUdW4iN07dmO16rBZc7utzSJT6Dex982jmKwOHJ4ZZlGUJEoX1FNQWcuBnSeYnAgT8FvyZEYikQENli4poqTEQU/XCEd3HyE2fBWjHEdvNCPbStG5FyBbi1AMJvxeA1VlFkRRpPniIB2dYxgMMnqDkq+Vv5kYlTQGQhzbe5iRgWG8xSX5HH5RMVFQXimNdV+tXrtAjL12KnrsVwn2PRfT0ddOR7+9vir7r739sYPdvZPjNodzmduSkloutFG6eAtSZozJ8SABV5YLzUOY3cXUVxg4fuwaZUVGLl4NYXeaKPDo6G1rJRaNozirsBgSdHcMEvBIHD/RTfXiZVjEKTqvXEGSZARzAXoFxGyEaGiCgb5xfLUrsMphOjv7MemytLZOUFRVmT22/+IfDo2F/iSTEJ//va+PfHPPxfivJFpxxxbvd5uaitetuPNxRTTMgGtieIRDr7zARHcz9RUCRvmdE/WyGZWOjnHOXehnbCxGcbGDNavLKK+twBpYgN63GJ1nIaLBhpqYIjZ0mSvH3uTgG/uJhCMsW1pCw8IA8VgKWZZxT4fP0uksx0/0cak1xG2PfYCmteuR5bkW4mBPD/t/8iPWLHPh98zwCMMjEY4c7+HBj34Cs2OmbPvgyy9hk6eorrBPx/CDJEUPS9ZvyOnh6CDp6UCHqmocOd4LgmrYcTz0rbcF+p89bq0tKLD/l9rlq40jvX15UiEbH0d25OKMJTU17H/9IGXFOWbS4zYxNTFBe2sP18fP6AxGqhctYveOPZhNCvbp7DadIlBZZuHimcv0dPRSXFWVN+Uh13uuYdVqwnGNA7vPoNdJOJ1GNFVjdCyC329FliUKCmzU1niJxhK0XGjl/PHTDLaeIxvuwWSUUSx+FE89ir0Cg5hgcnwMURARBIFr10Y4f2GAgYEgqqpisRhuYFgVRaKkyIKWnOLA6/voae8mUFqKzmBAVEyUVhYrLafOrV7fKP5w99lffWLIzgup6KZGGYfV8rmHPvqs/ZUfvELVgkrsBZVYtQHcTiOvvnKOTffdj5pNYzPEmJiKceJ4K7e+/8Mkp/oo8us5fryDUDjNxgceJzRwmZJiKy/+9DQbtq1DMblwm4IMD4e42NzLlgfuJxYKUlkss2/vZSLRNJsfepzRnlbqax3s2tmMyWpjze13ipfPnlkQj6r/8D++M/YrY90/+4z7QbfT9Ht3P/mUWTJdj8b088b3v8dQRzNL682UlVhuYLqvx6IHBoO0XBri3Ll+2jvGicaSJOJZ6up81C9pwFy2CcWVC5Wp4UEGrxyh+dBeTh46Tue1LswmhZUrSqmocOeTt/r6gjicRixmHa2t4+w92EXl4tXc/tj7scyavJIz1bMc2/kmvZdPcssaL0bDzHs/MBjkxKkBHvrYpzDbZkB+5PXXUNJDLFzgyiu842fGuPPJDyKKEpqWJdl/DLK5VgyXroxQtGAxUyP9psWFU3+37xLZm8bRjSbjg9XVPmfD8qX88EtnWLDAiyyLaJkE6bFLueR+WWHjA4+y/6UfcOuWUgRBoKHOw4WLwxx+dQfr775vGrQOHvnU7/DyV/+RcCTBwvpAPoy2ZrmH7t4pfvxPf8/6e+6juLJ6DhG2aM1aahcv4egbr9HyWhtLF3mJROb2lRBFgcoKN5XTqYgTEzG6e0Y4f6YVAYGiQgclFcVcam6jvs7PksXF0z64jmxinFAwTk/PJDt3XcFk0tPYEMD7li7GgYCVuwJWevpjvPT1r7L1ke0ESkrQOUq584Gtzh0/2vnK888HG55//r0h555/rtCkhKOfEjTtgCbrelSSNjkrVJithvudXvf2h555yiOSoiBgoWZxE1ORBFaLwlQ2g96gYPMWkIyFQAVUKC/z5DITHRYggsmgo2lZLaIsY7EasFtFzBY9/kIvoaQJfVamosLN6FgETU3h8PkhHcLnNqEYFbRsCoevEEEYRpIlGhbYkSSZp37ruYqffuM7R/72OXFHJJJ6EcRhEU0SBalC1bJVydrgX/4yz+hz77d6ZEn80j2P3GW/bq63NV/k/OH9rFjqweO4eWvryYkYFy8NMjkVp7jQQXW1h9WrK1DMXrRMnERkiostg+z48T5uvSNCf3c/PT0TRCJJPG4zJaUOFjUV3KAI8nnqsSRyUOTo8X4KKqp5328/gclyYyfs4b4+Dr70E+qqbSxaOZf4u3J1hI7uMA994rcxmmb+9uTunRDtpbHRk9fW+w71sOXhJ5Dl3PdNj11CS0WmM+1UOnriPHJrE/GRq66h4ci62UUtc4CuM0qbvB6zIGTCrNh6Bxcun2RZUw5I6akOJGsxktGNr6iImhXrOXryOOtW5SbALGr0ceZcD4dfeYH19zyYyzM3mnj4E7/Lm9/5OkePdbNmdWk+lFZWYqOowMKpI69z+YSNdXc/iNk2U49uMBrZ8uDDTI2N8aN/+idQEzgcBgoL7HNa4s4QdyZcLhNLKSKdztLfH+TwwQts3liN1WpCcVbnUmMVE5qaQh8exFXQT2PTCFMTUc419xM9lWJRUyElxXN34wK/kWyDm90/+iGPfPwTGIxGChrWU3fxYuXVy8IfwuCfvSdA/9JA7K8/5D6dyqgHvB5j2BsoFosryhyB8grB7vaSjfQTGmkjFEwg6GxYTXGyMejunkIQcnnaNqseNQiRaBqrNfeC2uxmiEeIJzNkMrlN3m4zgpYkm1HJZDLYXE5SEUDVSKXUXEdfX4BMfys2hylnAcVHsQfKUUeGMRp1vLnzEg+a9Rjc1Wx/7tni0NjAJ0Z6ez4y0NM9OdA3YRifjGTUuLD8l90IFbPxK2s31LnsFcvzvviZg/toWmjHaZVvGhI7f2EARRFpbCjA57MjWgLIlkIkSwBBVFBTYaTJDpbpFQwtA7y64zh1C3ysXFGCxfLOE7yTqQyDgyF6+4JcujrO45/8JL6iGychxWNRjr76ItnYBNtuKZiTgKNpGidO9pDImnnkk7+DOKuU9eSeN4mPtbF8yYxvf/hYD3UrN+ItLMxb2enJtpkQ3dUgK7fdAakgXq9Fb7Po7gD23dR0v2up5Y+WLyv2CZKMv2Y5Jw4cJ+DVo5++QTU6DOYCJFmHr6iI4YExJkbG8HpywCsIWBkZGKTtcjsV9Q0gCAiiQPXiZUyMTXLySAtFRfZ8CEIUBYqLrBiVNAde38fkyBAF5VVzRtQceu1VyoqNLFvsJxZLc+3aKGfP9zMwECSVyqDTy/nOG/kvJeVCfEajDp1ORq+X8g8mG+5DU7NIFh+KsxrFVYPJ5aOi3EOhR+LatRHOnO0j4LdiMOR2TkkUiCVVjBYHw4MTFFdWIAgSBUVeqfnUuWXrFui/+V71TnvjXLzzzgbjPkUnfLys2GYqLdILBm2K9FQPPe1dHDk+iNkoUVVfD5kw6cgYZ86PotdBbeNCtNQU6dgE7d0x4pEotYvqITVFKjpFW8cUajpOacNSsqEuhocm6R9MYDZk8JbXk55so707xMREnAKvhLWgnsxkK519McLhJAUeDWtRA+nJNvqHUiiKTMvFPoxCGH1mCDk7iZqOSsODk6bRkciVaFJb/0ffmej7ZZ7HX3zIs8llN/7htkcfM13vXnvo1VepLHegUzJzBlUMj4Q5eLCDeDzNqpXl1C9twlGyCF3BcpTpysvMVDepkWbSY5dyo4fRCIeTlJY6qar0oNPduHGk01n6B0JcvjLE1WsjDA+HsVr1LF1SjM1h5+zxizSsXDkrjz3NyTdf4fSu11hYY6Su1jPHKojH0uzc04qntJ4tjz4xp8X54VdeIBvqYtnimbHKzS2j6J0VLJtuHZVOhkkNHIXpsUyRWJYrHXHW3Xkn6fEriNk419rGhnccD/3gpkC/e7n5vy9ZUuQgE0d21eAtLObA7hPUVNhzvYnVDFfPXyJQ2QiCQEl1DRfPXUFNx3HYc7ug32chNDlO8+lmqhoX5zV4YWUNroJSdr18EKNxblWayaSjuspFJhHkwGu7cplaxaUoOj2XTh1n/dY12Aob8fqcVJTaqKtx4nKaCIUSXL4yzLlzAwwPh0mnsxiMM2Sb3Wrg0qUhArOScrRsCjU+Rmaqg2ykH03NIBncKI4KTL4FlFeX5xZcjOdHCOd28SyKInClpZfGVblFlY0O7MqkcaB3ZM2rpyJfe6/80SdWme5cuUm7veX8pHitfVS4dHmQyy0DmrukRjBY3ZiVOIqUwaBoHD1yDYPdh05MohfjmE06Tp1sR2/3oRMSCMlJbA4LZ890YbA6CU5O4PcoSFqC02cG8RSX0X2tjcrqAImpIboHVOwOCz3tPZSXe0iFx7naFsLt99Hd3kmRX4+manT1RzFbzaxZ7ufIwctcbR3UWi4PCJ3XRrSKxoga7da+/+mvj/34l3kO//wcCoJlzz0P3xKwFi/JHz+xdx9Ffgm9TpwzW07TROqWLqZ2xUbMpSumwQ3ZYBfJ4bOkx6+gxsfyrZGvE3Mtl4ZoaijMh3azmZxPf/nKMJevDDPQH8JoUKip9rJggY/y6lK8pQswFzThDbhpPnOJRWvXkYhGObXzJU7sfIUSPyxfVoTZPNc66Omd4sDhPm556HEWrlwzOx7H3h9/FyPjNDXOaPL2rhBjURObH5rusK2qtOx/Eadlxkjae3iYjfc/iNGoJzV8DkmClktDoy+fCH/j7Ypasrm4XYZsqA9fURlFVXVc6xqntmK6/5s1y/m9L7F46wMgCNy2/XFe/c63yWgxqsty7GP9Ah/tHWO88o0vcvdTzyFO+xQFZWU8+un/yv4Xf0JrRxdrVxVinpXRVlzkoLjIQf9AkF3f+id0JjvRqRhqZAjFXpafDqNmEhjiY3jLx2iMjaImw4xPROkfCHLgQDuxWAqPx0JRoZ2SUgfnzg2wZEnhnAw8ADUZQk1eIj12CUExIxndiIoJWRbJvoXUkSQRNZFGFDQy6fQ0Ey9QvvgWfGevLfnbD/vf91++OvyeTJORJbRMWhO9dgFVTacDVUJ2akjQL9l4G+f276Syws+efecwm/WULlxBKhGhyKHw+mtnqKzy4iurJZOF0lqJHS+3sHBiHFugEtQkDVU63nhhN4GAjYblywhFs/itIfbveI14Is2tj32Q9otnKC+U2LPjNVKpLCs238bE2ASeUoE9r+zDZNLTsGQtk5NhTKYQbotGQY2W7bmURTQKks2MppO0X7pZZzLr/f8WNhT4PFUrZhJQJiawWI2oahZZmuubWy06ZIMONTFBJtxLNjaGlom/7fVzLHUXS5cWMzgUoq9/ionJGLIkEgjYqKvzYbcZEXVWJJMXyeRBNHoR5Bx4tUycxMhFYpEIb37rSyQjU9TWemi6rfaGvJ1oNMXREwPIZifbf+u/YpgVYtZUlTe/81V8do3aWck71zoiDIyJ3PXE4/lj5/e+hNuaAXLfvbUnTWHlAjyBAOnJdkBFQABhbjWmPDfITzabzTXsT0+1I9vLWHPrrfzgi/9ESWERRr2K02Wi50IvHeeOUrlkLaIkcc+TH2DXj39E8MIky5ucIJDTisoUL335C9z51EcwmHPhAb3BwO2PP8FQbw97XvgpxUU2Gmosc/yXokI7RYV2IpEkR45O8MPv7cNsPkJBsZ/CylqKanIJM5K1eFpLp9HHJyhYMMHS+DjZ2ATDw5MM9Ie4cnWY8Ykoff1T+PwWrFY9TocJr8cyJ4FGS0fJvEOzVXka+Fa7kdGBgXyXTsnsY+O2JebvffvA3/35E/Y3/sd3gr80C68YtPKhLnAVCmI2I4jJGGhZm4BsxG7RcgSpqqKTJBasXE/X6V0Y9Apmq47BwSCr71tJ79WLyHKIsgoXLZcH+cB//QDdl09hMeTSlMdGI2yoKEUYmMQtOOjomAAhl0no8PjwKGnaO8aYGI/h81tRBT02QlRXezhxoof1t8rYAkuI9u/D5nQx3j8q290COiN0ntE0TYfnl3kGf/KEo0zWyZ9YsbbJKBlnmOihvt7pkVMq0g0Mu0Ym2PO219Q0jWAwQTCYIBJJ0tk1QSSSIB5L59prVbhZtaoK0ehCMroQ9NP/n7WhJMJj9F09RH97GyNDoyTiGawmiUV1VqxWz039+YtXgvT0Btn0wEOUVFW9pQgmxuvf/DIVxSYqKjzXvwanmydIiQ7ufvLhvGnfce4I0Yk+qotzfno8LdHaPsojH92e++5TuaLBVDqLgBB/W6CLkjicSGZqzCYdamKKbHgAyVrI1oceZN9LL3Dn1gIEYPGiQk6fPoneaKRowRIEUeS27Y9x7vBh3tx/hg2rfZiMCiUlDvQGiRe/9A/cuv1x3MUzXzJQUsrjn/5t2pov8uaBffi9Rhpr7Rhnzei2WPQsaipgcipOTbWX4ZEw3RfPcGrfQTQNzHY7/uIifMVl+Eoq0bnrUBBA0ygvncRoP0kkegGXy4TXa8XrMTMVjDM0HOL8hQFSyQyFhXbKypw3ZOW9Va4bA0Z9luG+/jnteG2Fjaxe0eU6cab3mxC875d5wfc+j5w1ip/S6cDhExju1rTYlCCve+AeoqEgHrtKNqsSCqfYuLUWARGrSctnRXncZgTZhMVqhBSkkxlsZgMIIla7FZLj6BV5egSyhM1hhyAUF9m51jaKlklg9/gh2I/PZ2VwKIyWiuEvW0Ck7QrFRQ4Op7sY7mqndO1yRsddNCwTOLx7HKtd1TylCPGwoPntPPHN55z/96kvTfb8vM9AA+ELZuXHW7fUuA3eurlEW28fel0GEGd3aXpbCYUSdHVP0Nc/haZqOJ0m7HZjLg/Eric9TU5W1dfgrV6JqHdOL7ZGbHKUofbTjPT1MDwwQCoWQ5YE/H4rJYVWli2q58rVYWRJuiFPPhrLAbyvf4qlGzex4eHlc0LJAMHhPnb+4F9Z3BigcLpXYjyR5uDxUSoalrFk/br8uf3XztN35TTLlxZNPyOBA4cH2Prgw4iSSCbUg5oKT18jBara+bZAR+PMxER0w3VzOjnajMkSwFdURGXjYk41d7CyKRcCWL6smOMn9qEzmvCW5irUlqxfT2FZObt/+iOa6hyUl1rxea1s21LF3h9/n9olS1i06e5Z4BGoWdRETVMjnVevcvzECVLxIOUlFipKLSiKhNdr4VrrKPV1/rymn20OjY2N03G2h5O7XiedyaLTKXi8NlwOPePjEdavq0QUxdzOLBtxF8RQU5Gcr65qDI+E6eya4OzZfoxGmYKAHZvdgMWsx2RS5twrgNkoMNzTBbMWQbYWUd9UIba2j27+/Iec9/7e1ydf/kWB3tXlXtqwQZAHWrOEx4W0JoDNIyjxKNhtcZIiXL02hreoCJPdjgaYlCSpZBbFZGfao8BiksikIBxJIUoimprCYjWRSUJWA4NRRs2ksNhsJIM5LWA261CTQayuKhJBUBQRl8PI+GAPBf7FGMw2tFQYk1lH67V+ipaM4/CVE+kbxeKAVFLLXDsmkEpqQu0qUey9KG4FvvHzPoO/esbzOwsqvbUFJYVIloK5QO/pZkFNLmtTfMvOnE5nyWRUJiZi9PZPMTERxWLRU1Lk4NatC9DpJATJgKgzIygmKhZEycYnmJiMsX/nCRb09DA+kWBiIoyqqhgNCm63GY/HTO2awjn1GHkLYyicb9mcTGbo6o3Q1hkEUc+iNWvZ8vjiOWTbdaBdO7mPC0ePsnFDZb7BRHdvmOYrQbY8+Ai+4hkWf7TnGldP7GX1ipnW0GcvJ6hqWoI74M8N3xy7NBNWnIxriYR64G2BHosmD42ORj9RUuxUrpuz6alOFGcVy27ZwCvf7qZrIE15oQICrFpZwpE9r7DsVgVPca5e1ldcxKOf+CQHXnqJrkO9rFuVm0Jxx+0LuNDczk+/+Hm2PPwYDn/JHHVZUVdHRV0diXic1uZmDp25SDIaxG2XCYeTpFLZG+qDzWYdZrOOsrKZLKlUKsv4eJTRsQh2uwFRFJAd5ej9S2/Ic8/Gxyl1jVNUNo6aDJJMZRjoD9LfF6S01DEH6NcHz5lNeq61vqVuQxDRuevZtiVo+ckLF776p+83L/rj70aHfxGgi6ImD7ZrOpNNVHzlAmTRui9pWG61oCbGSCYzuRbMKzYyMTREkS+KpmY5e26A0ppFDLaeRI2OgpoiHk+TSAvopCzJyW4knR40CEczmPQS0bEurMW5muiuniBlxXYG2y9SuqoWBIme3imqq72cONLCPTUrEPV24pEpDHqZ0bEIw1ePEFi4GZ1eITisUr1clMOTmhALCXRdUDNZnTr1837/P3/KsdRkVv5ozeoyq27WKKnrvmUiGkaWb57K3NY2xvBoGKfDSFWFmzWryhD1DiSTG9HoRjK654yqAkgOnsRFL26PmVQ6TWW5nRXL3j52PgcvsXSuPv3yCAMjMSTFRMXCRu58chk2p/PmfzM5wt6ffA+LUeP2W2tzbnI6y9GTQxicRTzy8Zk4OcBYbwdn97zCujWleYuzexgiMbhluplkZrI9P2EVYGgwPBWNJE69bWbcHQ3ySErl2fo6f37ejJqYzGfFVdbXs++1g9gdRiymXKZZcZGd04dPYrY7sDg80y+rREX9QvRWF3veOIHdomCz6QkEbLmhDzsP0d92mUBpOYphbjWPrCj4i4qoXbyUgrIqju8/jtdtpL1jjCtXh+numSQSSZJKZ9FUDUWW5mRDSZKI1arH77fS3TWBopMwiFGykX7UxBRqMpR7KAJIOiuStQjFWYXirEJvduPyOPF7FYyGudoilVKJJ3ONJ4cHp6hevBxl1ixs0eBASk/gdUrmvv7IfXf5Il9+rY3sz/uif/ge4+HalZI5FtJkNBjqQkhJBRQWGNDSEXa9eYFlKxbgLG3k/OFDlFe46LjcRka0Ynb5SIUG0UtxTAaZgwev4isqp7RQ5sqFa5SUF3D5YjuqbKe+xsqp49cor/TR3dbBZFhi5VIfR450UBKQSaXSnDjRwZrVpVy5OkIyOIC/uJDzZ67i9pgZn4gQDiVxWTPIssj584OkghlBEAR0erTCajGdCAu3f/dg/HPvOpS23RswWOQD99/T6LN4itB5G+ZUo40ODjLY3pJPbDLqZXTKDCC9XgsV1cUU1zbhKGlCF1iK4qxGNLoRJRk1HUeNjZGJDpIJdpMeayEbG2NkNMzkZIKlS4oxm3U3ZNfF42mmgnFGhsN0dE5w/kI/zRcHGRgIYbMZ6B+K88CHnmPFlq0UV1bOqeXIvz+JCEdf/iHnDu1lxZICKitzKeZDw1EOHB1g+bZ7WLJ+w5wxZMNdV2k+8BprVpXk72l0SuPshVHufeoDuey4bILk4Ik5FXnnzvd3feqfh/50Ls/+1sKBjwWuvP+xpQtmE1WyrQR9wcrphPwIP/3Kl9m8rhCHXcmTHKfP9FOxeB2lDSvmlvzF4+z60ffRaxFWLPXntfLIaJiz5wYx2Zws23wrvtKqGx7O9/72c9y6tQaTQUBTM3nzaGQ0zNRUgmg0SSSSJJPV8n602aTDbNFhNRswW3S0tY2iKDKLFxXOKZaZ63/nmhGIsh4EkWx8MtdNdpaEI2kmwzkiubtrnNKG1SxcObc9r5aKEO/Zy9UrA+kTJ7tPJ2Lc+vO2Qd79F67xVELQZ1OaAUHQ6tcKcvvFOhLpCVKpDKlUhvvedzejURtnd/6IwgIbFy8O8eQnnqG9cwSf0sOu3dewOwyUL1yR6/pjG+fNnVcpLrYTSZkpLK+g2D7GseOdGE16BodTNKxcTol9nM6Ocdo7xhBkBbsnwIpGEydP9hJPpPH57Zy/MMCjDzXwxs4rrF5bx8XLE9j0CYIjIaoXR+g6p2VERRUFQUgZrSS2/P64811p8ifslXqjfs+dt9aUFJb4RWP51hu079HXXiYV6sLnz7lvLocOy1vWVBAkRKMrV46cjqNlUzes5Wzr70LzAJNTMWqrfcRiuaEX4XCSaDRFOp0BQcBgkLFa9FjMBpwuIz6vNW/tCaLCVCjJmfPD3Pvsp274jMjkCGf2vMZIfz+LGgsoKrLnM9lOnxsmoVrZ9uhjc2alA3Q1H6e7+TgrlhXnURoMZ9h/ZJAHP/wRjOacLk4MHCcb7p9D/u3Y0fLiR7/Q9+Db++iAIGqHWi6PLFjcNBPLy4R6ka2FSJYiTBYL9z71NDu+8XU2ryvA6TQgCAIrlhfTfPEEoYlxGm+5Y06G270ffIb2iy28+ubL1Nc4qK3x4PNaueM2K1NTcc7veZGxiRQlNdUsWLEWb0HOP9Hp9Tirb0EyOMnGJ1CTE8iJIOXOKGomCek4c4ZHahCLpwlHEsRiKcbGomjAheZ+OrvGcTpN6HUyHrcZf8CKx21GFIXcNdJRsu/AumuztkSf30rbhbM3AF3QWdAXrKJWPaIYDfKq/Yc6z37+w97Hf++ro2ff1cv+AVv11LDQ7vSxomylKAy2a1p3i0jhgno6Ww6zcmUJBw91IOmdSJE469aWc+RIFyazAjojNpsJXVairMzJ1WsjbH20jtGBAdDGaVpUwIGD7Tz56Y8xMTwG2hg1VT527rnKI88+TSwWBXUcm91AVtVwuAqobawDurE7dKTHMqQlL4tX+5GkDG6XhYGeYW7d/gFe+tpXWLO8lKvNLTgKkPyVotB1TtOP9autWm7/fduS3uefRzR3ON+n6JS/ufP2Oq8/4EBftOYGkAN0XrlMU5Pvrd7UW6z7LNnY6E0/KxJJMjQcZmw8QnAqQV//FNmsRkWFi5HRMBZzzhKsrvJiternRGUEQQLFiCjrEWQLosGOqHciGV3oExOo52aqQmPhEFdPHaXjUjN6RaVhoZ/ljXX5e27rGONya5DVt997Q6cZgOaDrxMb7WDF8pnpR1PBJPuODHLfU8/kQZ4J9swBOcClS6PEU9lXboga3eAjqsK2sZDCyEgUn29mYmRy6CyGcjeibMDucnHfMx9ix9e/xqYNBbimU1KbGgP09fdz4MdfZ91970fWzexSVY0NlC2o5cTO13nx1RYWN3ipKHPicBhZt7YcTdMYGYnQvPuHjE6k0RstjI5McPXIy3gKy3EUlCGbfCiOqjlN8TU1C9kkmppCyyTRZ1M4skm0dJTWc6eIxpI89MAifD47SDoS0Sgjo0F6eiY5c6YPVVOxWQ24PWY8bjMup+nm/tmsl8po1BEc60dT1RuIFsnsx1CwihJOiA/fb645cap31xc/LbdlU+p3Q9H0m4KWHaxKB0M9stWZlOWA1ajfbDTIW602vd+oZRY5vVFzOqkKoXGBiQEoqFxGYWWAIkcFQ0Mh9IqEaLBjNacQMgoVlW46OsYRZWOuUnAqZ9UYDDKCKGBz2CCXAIbDYUCWdTmmfRIyWRWL2YDVYUPWyTCR0zRGo46Nt28glZHRxroxmfSk0xFW3rKCZEpAGztOYaGVtrYxxNQEdz3xfhg9hsHkZWJ4WDBaBFQNoaBSbPrWJzwjn4tpf5lJqUfSUmYUQUzpUrIhI6vlJoN8B308WlbttK5aWWYzmw3oi1YjGd03SSeNIJKaGxLV3j5MEo2lGB+LMj4eY2w8QiqdxWLRT7caC+Bw20km4nS0jdDeMY6/1k7VomUIihlB0iNIOgRZjyDqQNLnWlDNvHQ5QjcZZKLjKqPdHUyMhtj9/W8xNTaC2aBRVurg1i3l+ZFkuWSZIBcvj1NSu5Dtn3p2TgZoLtQW58iL36PADZUNM4p2airBvsMD3PvMs9hcrmmOKU5q5PzcyrjhCONhCYNefgr48tsC/c+fsFfaHUbbrQ/eyY5v/5htt+gxGuV8Rlms9wSW8g0giNhdLh748EfY8Y2vsKzJlc8PLy5y4LAn2f/Dr9K04TZ8ZbVz/O91d9/H0s3bOLV3F+dfvUJlpYfaSgsGvYzfb8Wfm9ZMKpWlq1vk9MkOiorGCYcPk1U1QECn12OzmzEYDegNRgxmIwaTGaPJhNFkxmC2MDw4hgCsWVWO4qpBcdUhSAomwKlmqE1HUFMR1GSY4NgwI/39dHePc+58P9mMhiDCxvVVGE0z7slscTiN9F49R2n9shteMslahEFcjzBwnM2bqlyZrLpqZDi8anAoNB6LpRKZTCBTr5clq91g9HnMbq8nV3V1ZNdpnH6RzmZIxTWaNglC54VB9GKcFNDROYHJpAdRRi+lSQED/UGMRgUtm0anl0hNp4LKkoiWjmMwGUlMQjiUzHVzzUTzx0LhJIg5YtJgMpKcgHAkgawIZKOjGP2LiI3lZqOrqkoiOIipcAmxsVy//FQqS3j4Ks4FdxKbNKJpKWpXCLSf1shmBAIVIi6v4GmsrvzMwGB4KhJOppKpDDpFksxmvb6o0GYtKLDnNiVJh75wDdcr024g2k4fxeMxv2Xv1eaUeV5sGSCVyoIGJrMOX8BDSU0NSzcVYbA4ERQLgs6Sby5iVtNY/S0sWNDGwcMdOAqm8BbZScejJOIjJKIRErEY8VicRCJOPBonGo4SCcdguhOx2axjcCjEwgV+SkpFbEvKb4gEtHdFae+aoqiqhvs+8r45yTJ5Aq3jMi1HdtO00JNn4QH6B4KcPj/B/c9+BOt0RVw2kybefwJBTc/a2NKcvjDJ/U8+yivf/EbZ888jzq4xkN9SEbbI67XYFDXMbY8/wd6f/IDbNgbyGk6NjXB+3yss3pILFVsdDh752Kd5+V++QjicyvWymo5/r1lewOXzu+m5dI4l2+5B1plnVcmZuOWe+8nccRdXz55n39FTqJkEJUVWfO6caa3TSdRWe2m5NMTqlWVz2IRUKkskkiSZzJBIBAmPjTOWzJBMZEgmMySTWZLJNE2NucSC9EQr6cm2XGhFMYJkQJD1iNM7t7OwEmdxPQsALR3OkXaxEdRM4sZA+rR4vFbaz5+8KdCvJ9IYyzeT6D+BnAxSWGinsNDufifTXScrJCJxXAUwNZJjUCTFQDY6Sl//FDarnonJWC7HIRVkciKGJOUaHGYiA4iiTDKZIRhM4PVYGO5sIVCdSx0dHArh9VgYam+hoDbHowwMBPF7LAy2XaSgPsfBjIxEqaxw09p8ngZPbnPs6ZmkqtLDxZOnWHlPHYJkYGx0mKJCO2eOXWajtxLZEkDLSqAJaBo4/LnNShB0lJe5hfIy99v66qLBiaFwFYJifttn09HSTEmpfa6rNGvvdbtNbN7SiN4WQDQ6EWRL7oRMCk1N5bIgYyNomSRaJoGWTaBlEqBpSJKI121h76v7MRoVJEnAYFDQ62X0ulwthdEg4/AoWCr8mI26Oe/jjpdbaFgYyB+bmoozPJ6mdyAKooHaxUt55M5FN2hwgGQsyInXX8IgRlizonDOdS9fGaF7MMPDH/vUHB++ef/LVBep+Xcyk1U5eHyEO973JHJ2GLvDaDO0OIthJodhzifLBqnAatPL6VAvrsp6lm2+lT2H9rJtvR9RBEkWUSMDjHZewluRC33ojQYe+ugn2P/ij9mzr50N68pzhJsA9Qv8xONpjr/4DTwl1dSu3DKnaZ8sKzSsXEHDyhUk4nH62tro7Wzn1PkutEwSp11GU1UGh0NzJq3qdFK+mf47SfPFQV5/4wolxQ5Ky5zolDSSFL2hpdS7Cnu9xUq0O020H+8gEx3JNfy/GcmnWNEHlhHv3vuz0z3jKdLZFKN9GnXrBFIxjeb9Ass3VzI21Edb+xibbqni5KkeRjsuYDRoHD/Zw9YtNYxPRGk5foyFy5o4eqyLZcuKsVr1HDx4njv9Prq6J/D7LVRWeNh/sJm7CgJ0d0/i81moKHex/0AzdxcG6O2dwuu1EAjYOHK0i6L2Q2SyAiOjYdavraC1bZSu029SUODkyrVh7ritnmAozsndb7J8w2riqkj7WQmdPkNJvcDF/RqSlCI0FcPmePv10heseEeQx8Z7iITDGE3eG0qVZ9KGRSBFJtQDoXeXo5PJqAwOhmhtG8Vs0fHAfY3vmDR1MxkZDSMIAqfP9jEZzKBJepz+YooqqrhzS/UNJFveGsmkuHpiDyM9bSys82I0+ucossNHezC5i3noo4/OSbQZbj+PkBhFEK6Xr8LeQyOsvv0eHB43sc4zOGwGXTajuYCem7Luf/m068Pr1lZ8eWF9QNAXrUe2+Lly5ixt50+wea0HQRDQNI3Dh7tYvOlOAtUNc5nCy5c4+MqLrFk+k+mTzwIKxenpCWH1FLBg9SZkwzuTsZqqcvHkcQ7seAWv20AylcFgkDEZdbmdVi8jCJDNamQyKpqqkUpnSaczpNJZkskMmqqRyWokEmmisRSFBXZ0Oik3AAKBrKrmestZDHg8ZrxeM3ar8aaLHY1nGJ9Kzv2+7cPU1ldQte5h3u4NUZNB4l27f+YLc/F4B4UNo1w6ouErFTBYoPeyguxwEwom2bypCkWRiMXSHDnagaYJLF9WnN/w9u5rw2YzIMsiixcV5uPKE5NRgqEEt26tRRAE2trHGJ+IEpp17Oq1Eaam4sRiabZsqgYBEok0x050k0pmWVDry+cqHD/ZjSJLBIMJtmyuzn9OOJqgo32cCp+EtyJGNKgx3Kmx7E6B1iM2lt1S/7bf3VR5J4Jieru8VU6/+g0ioQi+grnlw16nYU4Dh7cy6mNjEcbHY0QiSaLxFKlUBk3L8RWhUIJQOIHJpMM4rb01TUOSBBRFRqeTkGURWZbQ62QkWUAQhGmLMUMsniKbyZ3fNxhh03330rhy9U2SY95SCRef4uqJfUTGBigtdcxpeX7d8jp6YoAN99xPxcLGub9rvcD5A2+yYX1FHot7j4xSv3ID1U2NZKJDJPuO0HxxMHzkUNfaP/zuRMtNgf7nH3BsXrq4eMfqVWUW0eDEWLYZEGg5eYrey2fZsMqVG6Osahw91k3JwuXUr940d/eNRNj/wo9RE5OsXB6YU7QCuReofyCEbLDiKarCW9Hwtov84te+xi2rHFwf7JJMZohGUyRTGVLJLIIAoiTkY+mKTkISRXS63OIgCnR0jDEyHKGu3ofLX4hkcKJmE2ipCFo6RiKRy30eG48wNholFE4gigJul5mSYses1MQso5NzOxrHokkGe8e54/FHUZxVvPLKKQb65jZZ0RKTZMI/uzFqf9cI9kCSsR4JQZBwFaaZHIKsaKS01DmHIBwezmWnzR6CkUplGB4OU1IydwPt7Zsk4LfNdCcVBHrHkwT81jkdS3v7JikI2JBlaVb8OMPIaIiyUtccTrKzc4ySEifKrHPHxqIgQDwYxFOqMdwugaDhLc8y1a9QVOF/+9x+WwnobXOOVZV52bqxntT4FX70tR+waFkJkjTX9PW7DfkS6pHRCIODIYaHw6RSGRSdhMdlxu02Y7MbsFqN6M0OBJ0ZUTKQjIxyraWda9dGWLqkmJJSZ67YI6OSyaokU7n2ZclkBm36+QqCgE6RMBgVTEYlvyaJlMahU0Ee+NCzN9+r0lFGOlsY6+sgmwxRVGjPl0DPvEspTpwdBsXG5ocexWydmxR06cge+q6eY+2asulIkcbBExNULVlF7aLFgEa8ay9qcoqDh9uHrl6erJ4d2p1b1CJmmwcHQ2HAoiYmyQS7ke3lNKxcgapm2Xv0HJtWu5EkkfXryjl/4SKvt3aw+ZEZgsFksXDXB55msKebvS+9QMBrYNFCVz5+bjAoVFXmXNXhoUv0XDmFpJjQm534K6pw+kpybXsFEX9JKRHMOKuWoGUS6LMJbJl0jmHXsvl6XAQpx5JKOhB1iIoeJAMdZ4+SSY+wZk0ZhsI1SNbCGxbBkElgT0UpyUTQkhGy6TBqIsTY8CjRSOKmZmJeE5n1BMNJprpP45L1fOWzP+a/XvvFZj00vH22NjD8Ls8FGLzJuTPHNJNMw4uv/Ryff6M08quVTCbDV7/4f9m42Ej/5RMYjLobQD57TVRVo78viNtjYeGiKgxWJ5JiQdDZcsBWLPmKs7z754fF3lqqq06ye881dO5KypvWQDaBmk6CmkLLpubG4SUFQZByTLysIEoGBNnASMtpCsoccxj5yeFehrvaSEYnyabjuBwmyous8JZan3Q6y4VLU/QNhtl030MUVVbckIey90ffxmlKsn5djujLZjX2HxulZumaaZBDerIzN1wUiIZTN4yxvuHt/buPBS6///GldZIkIkgKxrJteY177cJ5mo8cYMv6QH4nHR+PcuLMMMu33ZVrNvEWs6vtYgsXjh7EbITGWgcOx827d0SjKYaGQ0xNJUimMgiiQjiSZnwsiN1uwWyzoDcYERUdsiSiKDKpZIJsOkMikSCbSZFJZ0glU2QzGdLp3H/339OIyaxDEBUExZQLk8xu6axmcyG6G41utHQ0/7t0RmVw9MaSx5HhENl0mtUrS3nmI4d5oXWK/8iiWXUIoeR/6HtMp9M88cAKvvyHJby58wpFZR6s1huZ6iK/KV/Bdn19b+ZCCZIEwiwTX82gqZn8+vb1T7F3XxsWsw4EEUmSEGUZvUGPLMvIig690ZBn61PJJGo2SzKRIB6NEpqK4A04sZoUNC2NXpFwOI34fda37VYzFUzSci3IZDDN4rUbWLB0yQ1l1B0tFzm953XWrAzgcpqmE2JU9h8dZemmrZRP93TX0lHiXXvQ1DSpVJaXXm35wUf/uvfxd4yjp7Pq1zo6x/9vTbXXoGXTJAaOYyzdBIJI7aLFmC02Xn/pp2xaW4TDkUv6v31rOafO7OHCkUPcct9DuHy+vJlY3dRIdVMjw319nN6/n0RkgKICGyUFOuw23Zy89arKG0Mrly4NkcmqlJTYyKSzZLIpstnpqIERFEVGFE3odTYkWZzeBHKmfCajsm9/K8XFDqoqPSjqLz7GW5ZzJRRvzdHw+q0cP9zO0kWF8Kuf6/AbI5qWZWIiRiyeuSnIRUGYU6aqqWm0ZPDn+oxsVqWjc4K29lG2P7IEw6wmFslkhqyqkkmrpNNZsqpGKpWYLmyRUGQdsmJmbNxALGpl4cLAz/y8YChF71CKnr4pdEYbyzfeTnFl5Q3nTYyMcHDHT7AZUtyxrTzvIkwF0xw5NcrWR7bj9vvzzykxcBxt+t2+em1kMh5M3tDa7Ibt7y8/6DfbHFLL9keWlF3fYSRLAYbCNXk6PxIM8uq3v01thYWaSsuswH6c46cHsbiLWH/XvZhtNxYfZDMZutvaaG++yNhgHy6nCZfTgN2sYbfpbtgBU6ksr79xmfvva/wFNEOOlLt6bZSLlwYJ+K0I5AiVTFadLtUUboiR50NkssAdt84MyhscjZPO3Ajm4aEQ8WiCr32jjxdaQ/+xAfRrotHff/9S7m+KUlUTwGq7kbnW60T8bmPeqjxytOvtWf3pVmOKIk2HzmTi8QxdXRNUV3uor/ej18voFOmGSSs/S/bsbWXD+sobCq4ikSTBcJqpCExOJRkZDuLyB6hpaqK8rg6d/kZNH4uEOfzqDkKj/axZUTinN2JrZ5i27hh3P/nBmQaUmkpi4BjZyFB+43r11csHn/pc18afCXSAf/xEQXNBobtx8y0z8evZ+e65i2Y49OprBAfaWb+mcM5uODQU4ezFUQJlNSzbvAWTxfr2GUyhMKODg4wODjDe30skHCSbSgNZspkM2UyWcChCSbEDg0HBaFDIqirpVJasqqLN+hKCIOTaP02r3uvk3PmL/dgsekpKnJQUO/H5rEiKHiQZQXhL/ruWRbteIKCpczqUjAeTRGM3H6N+6kQnL7wwwUsd4XmgvwdAf/iOJp5Yr9LQWHTTc6xmBecsi1CQjfmMSUEQ55jqqVSGbCZJKpEkk0zS0zdB/0CQvv4giixRXe3Ja+5kMnODCY2godfJ6HQ5Nl6UBFKpLLFYioGBEA6nFVXNWbCilDP1TRYbnqJivIEAnsICHG732zLy8ViUM/v2MtBxhaVNXgoC1lnkdYb/n733DpfrrO79P3t6r2fOzOm9H+mo994tuRcMBptqCEkIgUsglCROIOGGXAI4tAAOBLDBNu5NsiSr66h36fTe2/Q+s/f+/THHIx1LluVGuPf5vc9zHlvSnJnZ797rXWt913d916Gjw1jzKlix9abLWIUsEx85jhgazBK6Xn2tm0Q8+buPfqf7vrekwAJIMmp3SQXNx/tYOq3ymg4OgEKJ1p0hiCiVKlbfcguD3V3seO4Z6qqtVFc4QQCPx8RNHhPDw1PsfPQRdBYX89euJ8dzdXhjtJgxWsyU1lRfXSJJJHn2kZ+zZWMVer2SRELMIKpqJRqN8rqthIJCBUo9+/ee56ZNdbjdZtS2MlS2MhQa6wwCjCylp1H4MGIyjJwMZSiOqZl6jzqN8k0NfdbsIn7/+Dj//3pvViKRpra+4E3/XffGkcZyOsNB15gQNGaUGlOWCae/EpORZfKTAVL+HmITnZw+O0QomGDjlnnI6eg18RpZlkkmRRLJNKmkiCTJqNRKDAY1sajIgeOT3Pngp6/ppa+3psbGOLl3N1H/BLVVZuZsvCKMl6Gj20trR5CVt95JQVnpjGtIjJ7KGjkyHDg8QN3cOZw51HzNL3FNQxcEhMZ6ByeScOL0IAvmZgw07e+FdAyNZ1FWXqewvIIPfO7zHH11By/uuMiSBflZquI0G4xAMMapnc8SjKQpq59FzZx5mCzmtz7ZEwmQ0hjNJgSVDqNRjVGpRhDUCErVNMquQlBoQaVBodRMI6I6BEFJJBBElFvJzTVl0FKNESkeQIxOICfDSMlIdnj8jSydVsk1E3VAq1NdM+x7Fdj0RzAMEXgFuPn/EUPX6dUo38QDCgJotW+YoyemkEXftLIrXInGCKqM7ptCY5ymwGpQaIyoNRrmzS3kuRdb0RatRaFSZao56TiymEASk9PMugRaKY1JTGWwACkFYgpZTKHXx1EqJkmnUjdk6OFgiLbTp+ltOYfZoKC+xordVjTzAJiKcPTkCMU1s7nnLzfMqDjIUprEyLFsuA7QfHyIgtoFlBXCBZVKvGFDF0UZMTzO0nWrad5zmENHeli2uABBEEiHx5D69yHbZ2Ow5U4DVWqWb70Z/+QSDr/8HPEzI8yb48kOnrNa9CxfpEeSZIZHBtj/9CXicRFnQTHFlTW4i/KvGd4bLWaKquvomdDSsHR19nSNx6IkojEiwSCxgJeg30s04CcU9BMJBJFEEQEJg0GFyahhz95O5jYVYJcv3NBDJkkysXiKYCCOzx+lsMCGxaJDqRDQaZTEE9due7xWCe4PgAFY8T4aRRy4C8j9f8jQrwqfr1h6rTKr0OvzxUgm0zgchjfNr+V0DDGd0cCfAXr5ohxu7iE/18hLj3wXSRJAUKFUq7HYbBitVsw2BwarE5PNicFqRfsGY754ZD/F1fXXHNzwet49OjjEQHsb40N9GLRKykvMbFqdd9XzMjUV4fS5UXSWXLbc/yBm20xORMQ3guA/nx3aIEkyBw4PUFg3n4a5tcT69pF6Xbj/RgxdpVL0xmKpasXEOVZsvZmT+/eya88p1q0qydBgk0FC3ftpCxhpWLYejTaTK9lyctj6wCfxjo/R/MoLxE93U1ttp7jIhkIhTOu4GygsMEzfpBAjbftoOZIgFksjKJSo1Go0Wh1qtZJUKk00HOF47yDnmg9nCDIKGa1GiUarRKdVYdCpMRo12OwaDIVmjAbnVRuYSomZEO1MnNJSB8VFdsLhJFNTEfyBGNFYklg0xZWYnMGgxmzW4nBY0Osv31yTXvWmhn7NhxL4FrD9fTSK/w28DPz2j2SEkizR3HmWJ45t52DHKbonBhEQsBst2AxmXGY7Ve5SajylLK6YzfzSehSC4j37fNMVyj+yIDA8GubipVGSSRFBkdFg0GiUGIxqjAYtRoMGu02PdRrcGhoK0No+hkajYt3aKgx6zVVofCicIBbzEhkbZao3STSaIh5PkUxJyAgZTj8wMuyjpLKYnb8bRK1Rk4gnSMZjJOIJQEKnVZLj0FOeZ2RBdeFVqJgsywwMBmnr9KE3O1hzzyewOp1vOCzCXDi0m3JPOiuIkkqJvLavj/qlq6mdu4BY3x5i0RQqlfLcjXt0Kd08PhHeVGJQk/J3Mn/1WuyuXF7Z+TJrVxZhNGowGxUoCfD8Lx6macU6qpouN3c4ct1s++iniARDnD/azPPbz5KfZ6OsyEiOU5s9re12PXa7/ipvmkqJJJMiKpUWvc7GkaNpPHlmSkscb8/TJVJMTUXxeaPEYyl8vhg9vZ3k5VlwuUzYbUaKSvIwO51Y7C4UWhMKlQ6UGuRkJCMbPB3mZw1Xr0IdTl0Tfb9mrjkdvrcD1e8HuMblfsSi9zNqSCX47vZfcbqvhdP9rUxF/SiMykyeZ1IgizJTySDeRJDu0BDHxi/COZCiEtW5xXz/vr9lWeXcd/09tBoFOs3lQ8Nh0+HMrUJlcE83sxhASpGIBokEJon5ffh9Xrp7vHj9EXy+GFNTEVwuE3keC329vuyUn9cjAqVSgc2qx2bVX/e7DI8EcNjUzJvrIh5PIUkygkKHXmd+y34Knz9F90CEkZEg5Q2NbL7/A9k+8yvX+SOH6TjVzOrlRVnAOxRKcKB5kOW33k1+SRkpbwdSws/oeFiMhOI7btheJ6WXAACAAElEQVTQI8Hka8Mjgb8qKbHbkxMXUepzKK9vwOrIYcfvf8PcRifFRVYMRg2b15Vx6sxhWk8dZ9Wtd884jYwWM0s2bmLxho0MdnfTdfEih090Y7MZKSzOweVQY9FLIKdnhL/aN0xfaWrKZ/urLeTmmDAYNdcso3m90cyPL/PfZDKNVqvG6TBgs+ux2fSIosRNW+qxFzWiNOej0NqyoJwspRDDo6SDg4jRMeRp1l08nqKlZRxZlpk3rxCBjLLJ2GT8hh7MvmljfBH44vtggGPA6wRb5/tk5JNhP/f99G841n0eQSOgsKtQ5+lA+dYdIEJApH2kj1u//5d89eYH+eLmj143LL/+m4HNos3es8PNPZSVOsnLg1QyDH4QFBqUJjdaUx56ZzmCUk3xdAVFjPsRQ4O0nGjmzJlh8jwW1BolY+MhWlvHSaXTCAoBo1FLjsOIffq5uRbom0imOX16iPXrq1CpFNcd4yQo1ESTKia8Sfr7vQSDMdyFxVTMX8yq0pKrOiMBpkZH2P/80+TlKNm0rjS7Z929Xlo7w2y5/1OYbXakuI/kZIbSPjYWHCQ1fP5Ntu7q9dAaVHmz8js+cPfcUgBBbUBfvAZBpSOdSnHghWeI+4dYsrAwWz/0B2KcPD2CweZhwfot2dnN11re8XGGensZGxjAOzaOLEtY7ZasYIJer0KnU4KYRpZSSGKKkWEfHe0j5HnMGfQ9lUYUM80sGo06Ex049DjtRux2w4y6ZiQmce5sP0sXl6LQ29GXZEbbyMkI6fAIYmQEMTbdeE2mq2lg0Edn5ySSLFNfX0xxkTVLSgDwh5IEwzMJOF//2kleuKK8JgMeYBz48PsUWrcBrwsi7wbWvcfltSeO7eDrT3+PiWiGjKIq1SKohOvGGHISSEvIKZCmUsjJaakvnYJ7Zm/kR/f/HWql6rrltbu3NvHNT83kx1vNGqxXjGCKxmUuXBxidMRPcZGdqkrXjF5uBAVKQw5KY2bu2usMz1jPTiJ+L6/suMS2m5uyvRRX1sC9vozTCAbiiKKc4ZcjI0sZfsX4WJjq2gKcTgsanRalSoMsKInFRWLxNLGYSCyWxOcNgCBgdTjxFBVRUFaG3eV6cyR+dIzju19BSvhYMDcv2ysSj6c5enwIR2EVizdtRVBk9AZi/XuzYPKOV1te/eA/d2++YY/+0F7SD1el9/t80RK73SDIqSjxwYPoilahUmtYe+cHGOjq4JXnn6ax1k5FWQ42q571a8qZmAyz/6n/RhR0zFuzjpKq2qtOLEduLo7cXGYtWpQJ10WRaDhM0B8gFgoSCgTxRmZ6zJGJKRwOM7Nn5WdmqmmVM9Q7rry5Cq0lK/Oj0NsJjvpRqoZAACnhJzHYjJQKZ3WwZVlmcirC0FCAkdEgCkGgsMjJmi0r0Ok1SHHfDJVNAJtJjZiWiMTfPF8/BUwqFCxdvJjR5ub3xdte6Ud23oChv5318M7f8g8v/ghVqRa1Uke6L0m6K46gFhBMKpS5b1ALF2Wk4SRoFchxCTkuZXyJEpAFlIUanurczdRPAvz6wW9j1OrfRl6ummHkAAadwOLFVQh6J/29Yxw70UokEicnx0hhgY08twUi44iRcZLj5zLPhcqAlAyjN6gxm/UoPKvQWzRIMR9ibAop4cckBDGZtBQX2d+k7p3i8LFBhidBacuFK1jlao0Ws8uCy2TGbLNisliu0nO/Vvmu++IFzhzYi14j0tTowmYruVxm65qkoyfE6js+QG5B0fReJ4kPHswa+fBIMOkPxn91nWDo2uub91vLivMcR2++qc71Oril0FjQFS3P6nmlkkmObH+Roa5WFi0oxJ17GXmMRJK0tU8yOhnHkZtPZdM8iiqr3vKir1mSCATY/uiv2Ly28DLQJigR1HoUKj0KjQmF1o5Cb0OhtZBKiYz2dTPUcYmxgQHSyShatYJ0WqSs1ElBvhWFSqCv10f/oA9RlHA6jBQU2MgrrUDnKEUWUyR9Hdn8fGgowKWWUZqa8sl1mbMe2+tPEImlr+nR/xZ4beFCmpqa6PrFL3jt/ag3TwN+MlAOdHL9luob8eiyLPO3T/47P9v/JMpiHYJOQBxLIfnSCEYlCpMCQaNAME4LknjTyHEJKSqhKtYgaK6Tn4oyqe44G2qW8Pif//s1S2hv9OgmowqHWZN1GG3t40RjSepqPNm8VdAYUdurEQQlY90X6evsZHQ0hChJuHMtlJc5sdv10wMTA7S2jaNUKIgnRDR6A57iEgqr6vCUVKDRqjJCFTE/UsKXUSJKx5BTsWyDiyzL7NgzzK2f/AxqjeZt37d0OkV/RwedZ04SnBqjwKOnqjJnhoDpyEiQk2dGKG9oYv66zVnbkdMx4gMHs45KTEvs2NXeed+3u6rfTJ/vTeMnVUqQU2nBsvfgAKuXF2ZmjyWDxPr2oM1biNLgQq3RsPLWOwkHAhx84RlOnW5nVmMuhQU2jEYN8+bmZ8P6wYt7OLvvFWSFlhxPHnllVXhKSt+0LPHGZbObMRSvRFDpEFQaBKUuu2FBn4/Rjl6Guw8Q8vtQCSlyHDrcuSbqV+Rnc6xEMk3zkV52vtZGbo6Zptn5rFpRgdZgQmUpQm0rQ0wGSU5cREoESacl2jvG6e72kpdnYeWKykxKccUp6bRp0agV+ENX8+ifAO5Zu5ZoNIod3jeP7ppOD/qUSs6LIrPf5Xv+tvkF/nPfkyjz1AjTKK8yV43CoUJQX+MY0SuQwyKkZeSodIWhy5mCtpLLyh1KAYVJya5LR/jnF/6Tv7/ts9ctsdmt6quUXqurXAwMhdi7rxO9Qc3shjzsDkiOnUahMeOpnE1+4xrSoQES3m6G+0doaR2lb8BHKJigusrFqpXlWbQ9lRIZHw/Qd3InJ3a+QEpUYs/JIb+yBndhCeYcG4bp7syMMk0yo07DY9fMr6+JewWCjAz0MtLdwdTYKEpSuF1aZlfZMM+bSZQZGPRz4dI4zoISbv3059EbLrdxi9FxEiMnpj8/89137O4mkZDz3gLeeJOSzX2221aurX/KVbVceXL3y6xbVTQj7w2KuTjLF6DRXeYhR/wBju16idH+XirLbFRU5lw13UIUM5M0prwRvP4UkYiIjAKVVoPBZEJrMKMzmlHrdAhcPu1PHdhPZW0ZiViKSDicoapKEiqFhMmkwmlX4861vGHowvR3DcXpaJ+gu2eKaDxFdYWLRYuKURudqHNqURnzECNj0wbuJx5Pc+7CMBPjIWqq3VTUFqNUKEknwpw/P0QsnmLJopKZJ7Qo84kHD/J8V4br3gLUA6dPn+aRRx5B88Mf8t33ydibgMn8fEpKSvhYczOffhcefcg3xpJv3kfUnEThVN04+h8WSQ8mp72rkDEASc78v16B0pHRByAtk+rJjItRKZTs+vIjzCmuvcqj37ttDj//aslVQNjefZ00NuaRk2NCoTbh80c4d6qDSDRFY4OHwgJbJvrU2dG4GlDqXYjhEZJTLUyNjLDrtXZkwOkw4HAYqa56Q14/vQLBGGOjYbz+FKFwilg8DYpMb4TBZEZAwucNMmf5iitsVCIRiRCLhEhEw0RDIdLJBAoFmE1qHDYNTqcBp8N4VQk4nkjR2TFJz0CIwvJK5q+/aQYKHw2FCA6exay4zL6MxpLs2NXN/LWbmew+Hjy6v6Xya0+GJ96WR0dQmgUpqSwssmG84152P/skyxa6sVoyWaFJGKP52V9Ru2Qd7tJM4chos7L27vtIJZO0nzzKngMnUSnSlBabKSq0o9WqMvpcLlNWhP+NFxuNhkmngySnw2FBUCEoFKxdVU5n+xAgs355yVtK/iSSabq6J2lvn0ChEKiuyuWWWxo4fLiXpUtLQRDQOGszjQH9+xFjk8RiKc6eGyYYjDOrMY8lyxpRGlyko2MM9w9x9Hg/VRU5NC2umFEpAFApBa6MQncDy5YtY86cOUxOTrLyfSx9uYDqZctwOp0MvEss4B+e+RFhOYbKoZ3hZcSJFIJWgcKinLn3oowUFJFCIoJRgdKtQVAKoJCv6e0kbzozEwpISyJ/++S/s/1//exq8pFSuCbavXBhOYcOdWA0ali4oBibzcr627YS8Q5y7mQb584PU1fjpqwU4gMHURozysGanFrsiSC33trI00+fY/26aqamIpw7N0w4mqCo0E55mTPrzKwWPVbL1RhCWpQ4caIfpUpF47Ji0okuRFEknUqi1igxqZVocpXo9FoM+uuzP+PxFIODAXr6gwhKHXULF7Lg9vlX9d4Ptp2n+2wz82Y7s755airCnoODrL7tbooKLPh7jwqSUqN70wj9TU9oSZ5MJNKR1Ph5o6t0PVs+/HFeeew31JYbKC/NEGDmz3Fx/NDLXDi8j0VbbsXscE8DEhoalq6kYelKwoEAXRfOcuBYC8lEBLfLTI5TTY5Dd5X6jE6rRqdVv+nG5Cwu5uixPl7b28GihcVXlTTEtMTAkJ/29gl8/iiV5TmsX1eNxWpGZSlCaS4isfc/SaVE1Gol8aHmLMp+5uwQXm+UeXMLceXloraVISXDBEfaOHK0F4AtW2ZjsDgQo5OcPD2YzfuutfYA69evB6Cnp4f730dDtwEajYby8nJ63sX7eCMBnjm1C0WBKgNcBkSkQBrSICczvAEpokKVr758AIymkEIiKATUVbrLh4AIckpGTknIIRGFXYWgVyA4VOAXQcoY+5Guc+xpOcbaukXXL1P2+dDpVLg9Fm66dTk9Hb289MolZjXkUVkZQW8tZdnWGqLjrVw618WLL19k7txCCvJBjIxf8YzImEw6dCVr8dgHyMntR0wlGBjwc/BQZhppRXkOhQXWbNdiNmKNJjlxcgCLWcvcOa9rrqtvHGsKJ5jyJZj0JpmYjKIzmimtb2LzmsZr1tCnBvs4tuslLEaR+U2Xef8tbZOcvzTFLR/7ODmeXKI9u0jGUyGtWu1924auUHBhZDQUkJIhY9LbjslZy12f/nMOvfIih470sXhhHiqlgkULigkEYxx8+jeoDDYWrN2EPe/yMDiT1UrT8lU0LV+FKKYZ7R9kfHiI0239hPwjIIvotGoMRg0mgwa9TpFpUJBlNJrMcIVUUiSeSBOPpZEkmJyK8tvHTuJ2m1EpFUiyTDiUQKEUyM+zMntWPnl5NhQmDyprMaistJ3YT+vpV9BplRw42I0oyhiNGgQBJibDzG0qZOHiajTOWgSllsTEWS6d76W9Y4LFC0sorGlAFlMk/EPs2ddBvseOxaJldDSIx2O5isSyF7itMqOp1tbWRv77aOiTQKlajclkYvJdvE/PxBAiMmrjFQ94QkJWzPxz1mgmp42c6caxKxy4OJxEilx+bcbjKzPeXJIRzEqUOSrSA0l+c/j56xq6PxDDk2fmtdc6qaxMUFUpU1ZXQ3FNLcf3HealVy6yYnkUm8OO0dPEQs8sagfPcOJYG5daRinIt5JOSwSD8Wm8R8dvv/cwFfXVNK3aiEEnUOHop7RskHgsRlf3JHsPdJJMiGi1KtJpiXg8xehYCJfLhFaj4vSZIXR6FXqtGpU6M5k2mZIzrDlBRTQmEommiUYTpCUZGRUWhwN3YQV19YWszMt7Uz7BSHcbp/e9hlaZYGFTXlZyPJkUOXC4H6XBxX1//QW0Oh3JyRbkZJhIPDlyvalAb2roX3nUO/ijP9OGJEkmNdmCQm1EZSli5c230t/RwfZXXmTBnBw8biNWi55VK8sJhuIc3/4ksbSSWYuXUTZrQaZlcHoplSoKykqnO3GWX1GuiBINhggF/ERCIcRUCpkMhzsD9oDVaMJjMmIwmpidTrHj97+nqcFCjtOIUqXI9BNrDSgMuajMeSiMHiYHejn73Ev4J8cpLbGzfk1Flv3UP+Dj6NE+ItEk99w9B4u7DK2rkcT4eWLeAfYd6MRm1XPrHYvRuepJeTsIecd5bU8H8xZWUJhn4fChdnLdV6cg3ukflUpFPB7H7/eT+xbstl3A08DFaXspBTYAdwDXgyuHgKPAltrazNTYd2HoU2E/gnC58VdhVaKw6pECIuJIEkGvQFl4RRSmFDKhvCQjp0COSQh6BcgZUC6bBWoVKPM0yJKMIIMUlzK66NpM7r6n9dh1v9epU4PU1bnZsmUWh4904/X2sWihjMroYsXNdzDReZx9e1uoqc6lOh1HZSnGWrWeFRYnbWfOsXN3GzlOI4sWlmRFLtOiRG+Pl1d+9Z+otAYaly6nYtZmtPEJZrtGaIiOIacTVzDZYhw57WfTvfchCAKRUIhoOEwsHCGRTqHR6tBMpxoKhQKHyYzZasFgMc8YmvimxYh0irbjh2k7cxKHVcmiuZ4ZCHxff4CjJ4ZYvHEz9Qsy7eJiaIjUVAuSJBMOJS5d7/2vi7bEkulfdXVP/n1VpUufHD2FoNSiNOZSXFWFu/CzHHjxOdo6B1k4JxeDUYPFrGP5sjKSSZG29uOc3LMbV0E+DYtX4ioqf9PPyQxeMOD0uG/ogbx04iRzF1ZRVZWX0WfXWFHobCi0ZnyjA/QdP0nXxVasJhW1tW7s82uzJZHeXi8tbWPkujKqIDqdCqNBgxSdIta7G78/xGt7Oli0oISShjmoTAUkR08wOjLJkSO9rN00H6tFS097HylRorK2lKmxcRLxyzn7xBVlKp1Oh8ViYTwYvKZXvwh8ctpYr1z7gV8DVuBvgP8FvDEBGwDuAUS1mg9/+MN8//vfv+6BciOhu3ytvHoihWBUoCrQzNC9Vjqu/fjI4swaj8KqRNAJCNMHiNKoIN2dQCSFHBLxJYL4IkHsRstV4XphoZVVa5t46YVjbN6oZ+XqWVy6OMiu3R2sXSMjJSPk1q3m1rxSDr26j9EDQVYslxHDIyAoqKzMoa/fS1GhncmpCOcvDFNb46a83EllZQ6VlTmEQglaLx3m6M4dFJaXUlRVR27hEkwmNVLch5QM4LIkKPX3Mj44SOWsWdlhCu9mybLMUPtFLh1vJhzwUVFqY/3q4hnYRCAY5+iJUWSlkbs+8+fZSS3pyCiJkRPTqeHUuHc88t13bOiKkPYHx0/0/1l5mbNEqYT40GG0nnmoLMVo9To23HMvowP97H/pOZw2JbMbcqYb9JXMasxjVmMek1MRzux+Fq8/iSsvj9L6RvIr6685reKGyRNWC8OT/Uz4YXy4m6mRUZLxGLKUxmzS4MoxsWl9RRbZFEWJ9o4JurunKC6ys3F9DWq9mT172li+OMNSCgeDdHRN0NPjZcOGBlw1q5BTMeKDh+nunqCtfZytd65Bp1HjH+vl7Pkhbv3gVuTIAMeO9bN8eVm2KeZ1D3z+fIaNeMstt/B/Hn30Kmbcz4G/BqLXudYA8I3p1/49sG369b8F/pUMV+Nf/vEfcTqdPPnkk3zjXTx4T514FWXuFQ0jaRlSMnJaRl2qzRq5HBaRIiLKXM01QVFBJSCoFdm8Xk5IiGMpBAUIegVSREJOSsiTl71+Ury6PBmJJWhtHaehUcXKDUvYu+8EWzapaZhbg81uYfuO86xbUwXSYbSeBay9617O7X2J7a+2MG9OIW63GUEQqKpyMTKeZsmSGlKxEC0tY7z40kXKy3OorcnFbNaycEExC+bLjI6GGGtvpqX5NUKRFAqlGnuOA1deHsNDPgrrre/KuEN+P4PtF+lrvUQk4MXt1tNU58JkekMjSyzJ6bPjDI+EWXnzrVQ0XlZYSgd6SYydBllGkmRa28ab/+q/3jCf6UbLa6+v73zUcVd1Ze4PV6+qyKpGqKzFaNxzM4PnplfXpUuc2rMbuwVmN7quAtpeRwr7B/yMT8ZIpRVY7A7yyiqxuz2YrFZMVita3dXAYSwSIRwIMDE8wkhvJ2MDfUyOTbF4UQm5uUYcduM1mwiSSZGLl0YYGgpQXZ1LZUUOSp0ZjbOOgb4JDu94BSmdRFAITE1FSaVFPnDXHArmbkUMDpLyd3H69BChcJzVW1ag0hiJT7bzyvZWVq2fg8OTz1D7Bdrbx1i1ppEPf2Q7L/ZkCDZuQOHx0NbWxvj4OE1NTdwdjfLZ6ZTkR2RaWN/t+uAHP8jDDz/MAw88wK7t2+mD6+IBb1ZeO9PfyroffgploRo5KiFOpJBj0vQTIqAq0mTCcgHS/QnkqISqQpsx6IiEnBBBo0BQC0g+EcmfflvXMfz9PRg0+mx57YO3zOEX36jl+edOsm1rPfqcak43nyAVCzN3biEaRw2TY0Ps3X6EZUvLyMkxocmpRaG10vziUxw51ovdnpl8Go0lSYsKVm67mfwCB8mpFsR4iM6uSVpbx8jPt9LY6LkmECxJMgF/jNGJEEeO9OHMdeJw55NfXokj143VYcdgMqO4wgtLokQ0HCLoDxANBpgaHWa0r4dUPILRoCQ3R0dxkf2apWC/P8bZC+OMjoWZv2Y9sxYvyb63LIukJi6Q8nXzesx09Fhf69mW0fVf+a/J4Xfs0QG+/N/epx7+tObjx08ObVs4ryBzowP9SHE/2rwFmcYQoKK+nor6eoa6uzmydxdSMkxVmYXiYnvWszqdGZ3tK1HIsfFW+oYuEEvIGc32VAZ8A9DptYjpNFqNCrNZi9WspCpfz+LGClpaTAwOBaiucs00chnGJ0PTwwuiNDbkMbepEIVah8pRy4Q3RfNv/4DTKrB1czWCAIcP92KzGojFkzidRhLDx0gnIuw/0I3DoWft1tUoDTkkx86wb38XjY355FYvJTFwkLNnh1ixvAKF1owkXg5YPwN8c3SU22+/naeeeoof/OAHfPWrX+WgxYLH48HpdKLftYtYLPaOjdzj8VBQUEB9fT1Tk5N8+y2M/LokmcMvIEXSyF0ickqeCSAgk+5PZKplagVyKuOJxbEUCpsKySsiR8V3fB3FzryskV9mjkmoDTZqazy0tY3TqNGyYNOtvPKb/6K3z0sp7biK5nDTHVp2vniA+loPpbQgqPQ0NHg4d3EYu82AXq9m1aoK0imR00d3cyKmYNlN23DmKanVtFJd6aK338uuXR3YbDqqqnJxu0xZF6hQZMYzdXdNsXJ5OZUVOfgCMSYmL9Dec5ZINEUkkkSSJFLJNBpNBpwz6DUYjRr0WhmnVU3t0hxUqtw3YclJmVJwpx9JUDF/zTq2zJoz8/CI+0iMnMiy4QAuXJqgd8D/47cy8hsy9ExZIf3o4HBsazDYLaxZWZrpSU9kWHJqewVqZ31WCregvJyC8k8TDYdpOX6EHXvOo9dAYb6BwgL7DG05k0l73a6f6636eg8arZLHnzxNaYkdjUaF1xslkUzjyjFRWZHDMrcZQW1Aba8kEFFy+OmXMKrTrFmej06nZmg4wLHjfcyfV4zdbuD8hcx+Bf1+du5so67eTeOcOtTmQuIjRzl9ZhCrRUfVvKWIkXHCkRiCAix5FYiRcaQrGtq/DLwE7Nmzh5qaGj71qU+xY8cOGhsb0UxTJkdHR/mXf/kXfvrTn5JKvX2F2tHRUb7/3e8yD3gEuPVdRAZlrkKQmWnk02t2UTXnBtozqUlSuoIkIyGGk+86KllUNusa4JSEGA9SO6eJ5594lYZ6D1LMx/pbNvH8717AYtHh4CymwiXcdEuK7S8cZXIqwvx5mUYrs0nH+nU1dHVP8MKLF1ixrJylS0uJRJOc3P0caXQs23Iz1hwFZZo2SkscjI2F6Oyc4HBzD2aTBpvNQCiUoK/fy+qVFZSVZcJru02P3aZ/V9cciSTp7/fRPxTGH4xT2TCLTR++87KCcrbMnSI1eYmUvzvbdCVJMkeODTM2EZMCU9FnbuTzboi/982PmGtm1ZUfLJuzLOfU3p1sWFM6w0AFlY60vhz0uVjsV/eMR8Mhui+cp6/tEslEDI0KXC4TTpsGs1GJTqe6rv5bWpSIRpJEo0m8/gST3gSSLKDW6lFpdIz09bN0UQEWiw69Xp0ZpmjIQW3OJxhK0vzqdhRSjPlzCjAYNaTTEkeO9pJIpFmxvBydyYyoL+R3P30cl8tINJrEH4jx0fsXotRakNMxOtpHGRj0s27DXPSla4j17OTk8U5yXCaqF28iPnyMD35kD9sHojPQ908DT11xLatWrWLfvn0zru/QoUPcddddjI2Nve0H5i7gUWY2t/AOQvdB7yhz/v4u0pLIFzY/QDge5ef7/sB9S7bxjVs/Q/3XbkUhKFAqFKTE9Dt+wJdUNOGPhqj2lHD7vPV84pFv8NDtf8Ffb7p/BjPu1vX1/O5bNWjzF7H7yd9TXZ2LO8+FvnQDU5de4tUd59iwrhqTxQhKLX1dA2zf0UplRWYaaUfnJPf/+f0Q6SHsD7B3fye5LhPz5xWhUAgEg3FOnh5EpTOzZNMWzEY1qdAwUnQSWYwTjSUJBhI0HxvE6c4j6PORSMSxWXXkugzYrBpMBi366Y7L6xG3opEU4ajIlDfBxGSYQCCKzmiirLaO8oZZ5ORdzV5Np5LEvb0ow50zhn3G42n2HRqkYdkaRlpPdG/666MVN7LvN+TRv/HbUPtP/2IitvEuJ66Cj7H90d9QV2WlttoFAsjpOMrgJc4cOcjoRJLyxiYq6uqyCKHBZKZxyTIalyzLXHwszvjwEJMjowyN+Ij4/ciyiDBdmsjooyuQJBFZklHrtJitdkx2O/nFHuYWFqBSZ/KbZ37+c7ZsrsXoyM+0JBpchHw+Os4cp797L3qNwNw5BVjMGYhhbDxMc3MPTU35lJU6UZoLCMZ17Pn982zaVI1ep2bfgS48Hktm/FQyxNBQgLb2cW7aUofW3YgYGkROxxkY8rNgWRNSOkEqJV51ajqm8/BTwH3AiMXCj3/84wym0dXF8PAwK1euZPny5XR1dTF79my6u7vfHoBGRnDie+/SqxY6PNy3dBuPNr/Il7Z8nOdPZ1pw7luyjXxbLnajhS9u/igLy2ax5bsZkm21u5T2sV7m60vpS3upjFoJhUNccgRw6q1MRv3Z98+1OBgPenn4w1/jqROvIskSRY7MPanNK7sGIv06IBinYU4N50+3kusyIUZGsRXPY/WqCDt3tXHTTXVoNSkK8q1otEoSiTRLFpeSn2/h2d88waa778Ba4GHbFg0XW0Z54aWLrFpejt1hYO3qSny+GAeefYKUKFBSVU510yKMNiua6ATm6CRb7GZOtSS49/OfQJZlvGPjDPf3MTk5Qc+Il3Bwglg0M0Y5k9tMlyeFTI1Bo9djttowWZ24yvOpW1WA3eW6Zg09lco0ulw6dgiDKsXCebkIM+arB7nYHmDd3R/BrAlz6ZC340bvr+oG3b78cEocCPafLLJXruUDf/nX7Hv+aV56tZ1Vy0syM8AEmNPgyLR8+oc4u7ebcETE6HBSXtdAfklpNufQ6nUUVVRQVFHxrsO+vOIiRr1JzEo1vUcOMjU6hkGvpLTUwca1M5H34yf7CQWTbN5Ui8FkQJPbRFdLO+eP7GL92koUCiGj072igjNnxzN96QM+XtvbwbJlZSgUChR6O7G+A4xPhsjNMaG2lSKGhoiEM6Detda86dtvsVj467/+a2KxGMePH+eb3/wmK1dmyLH9/f0MDg6+5fWumP7ZDpydft//BP6ZjDbdu1kPrr6bY93nMWr1NBZWTafoGYvLt+Uyt7iOfFumStFYWMX3b/prHvyvf8DQEaVe0FNbU4YyR0ki0UKtJo+9YhtP/MV3+eLv/o3v3/cVtn3vs1TkFjGrsIruiUEcxgyCXZrz5mqvUmQcT8VsDuw5nVEf8nWgy1+CzarHZNLw8iuX2LypFgGBgkIXc2e72Xegkw3rqlm7Ws+OJ59m0erllNcvplF1msJCG/v3d1FUZKNpdj52u551a6tIixJDgwEOvPA48biIKz+fkroGfBOgm24qEQQBp8d9w2XgG1kBr5fuSxcZ7e1CSZJ8t5YV820z+koSiTTNx0fQ2/O57cEPo0gHCHWfJhCInnpPDR0gHkv/vLtrfG6D/rBeW7CUjfd8kJG+PvY88wcK3Fpmz3KjVisRBAGXXYXLrpouE8QYaDvI+YOvotbosbvz8JRW4ikqvua86LezxFQKo0nLmeaTRMNH2bihhvmNVW84JUU6uyYzgE5DHksW5aA05aFxNnDwxaeIBibZvKmWdFpiz94Oli0vx1a8GP++x9mzt4NgMI5xmiMAMtGuV0CW6eqcorzciVLvJDl+llAkfl3llCQwODjI4OAg+uk/e72XGYs6nQ5RfGtAaznw7emfYeC5aaLNQd692mxDQSXzSjLjsOvzKzHpDOSYMmBriTOflJgmnMikJl/Z+klIyxT1ZQ5vd24ulZWVTE1N4RzQEu4bY83a+Vj1ZhoKKphXUo9Vb0apUDC3pA5vJIjTZMOiN1HlLrlmTplOSwixSTS5synIszI07KeoUCDak1FLstkM+Pwx9uztJM9jQRTBVbmERQLsfq2D9euquHlrA3v2HWdscJhl2+7Aob/Azdu0nD03nJlr3uChtMSBSqmgpMSeIdTIMDwa4PlfP4lGp2HrvXdd4bHf3Qr5phjp6WC4p5tI0I/FqKSowEj1Ass19eTaO7z0DsVZvu1O3EVFiNEJEkPNdHePj3r90Z++54YeleSnL1wc+d/19R59fPAAGlcDeSVVfPCvvsDZ5kO8tOMQpcUm6mvdM04jg15FTbmJmumJLuHwFONt/XQeTSChQqHSYXU4MTtzsTpzsbjcaK4lSCDLpBIh/ONDjPT04BsfIRkJUlpi4/Zb6hgaCnDm3BArlmWmZgwNB+jsnCQQjFNV6eKmm+rQG0xocmcTDEu88J8/oqrCwfxZFcSiKfbu72TZsnIcZUt4/rGnWbwgD5tdz+7d7SyaVXKZECPLXGodpat7kqVLSkkH+5GlNOFwEsV1noMm4OvAndN/rgKmpqYA2LFjB5s3b+bWW2/lmWeuxlY2b96MKIrs2rWL0iv+Ph/47PTPe7EUgoJNjZn0SqlQsL5uCZXTRritaRXxVAKdWsuXtnyMm5tWz8AaxsfHOX78OOFwGE00hiTDusYluK05NBRUolGpqcjNiCYU2N00FFRi0RtZVjnnmj3pCqWCcDiBzaYgHeynpMTBrt1tbNmiy2q5pVMSq1ZUcPhID9VVLsrLJHY88wpb776ZRcDO3W2sW1PFxnU1XLg4whM/+RGbP3Q/loIi5qnPUVkRoKV1jJOnBsnzmCkrc+JxWwiHExw91sfatZUUFthobznEuYO7sDqd5JdVkFdWgdZgR1Dprmn8siySCPkJ+MYJjo8yPjxMIhpGSicx6ATcuSbm1ppQqTxvSqTp6vHS1ROhcu5C7ti2FEEhkPK2Z2SjZJmBgUDH3/7a1/+eG/pDj3qD3/+0u3loyH9bQYFNSI5fQIx60bqbmLN8JbOXLKflxBFe3rGfXJeW2hpXdjDcDLLLNNJefkX5JhqLEA61MjZ6js5QYrq5SXF5E2URWZRQqRWYjBqcdgMVs+0w3eUtihLptEQyKfHY70+Rl5fplps/vxCrRY+gVKO2VaCwVnJqz3b6Wi+wakUZJpOWQDDGgQPdrFpVSU7lMl588gXqqy14PBZ27m5j6ZIynIXl7NpxikRijLHxEO0d4xQV2kGA5FRr5qQOJ67r0R9/A2D2IaBnOIPyP/DAA7z00kt85jOfucrQ/+Zv/obvfOc7PPTQQ+zatYsG4BgZLbp3xMZKSwhPPvnmUZIk8mRX5t8XKop59unM91HLMhNpP8VKB9+49c8yYOMVEYksyzin9QIjkQgmk4kHVt2OSqHkYytuzxx2RTXZ188vzUQOq2rmv8mhIxCOJLDZ9CSnWrHb9ARDCV586SJzZhdgtekIJ9Tkl1WwSqVg774utm2to6nOwq4XdrHp9vUsBV7d1cba1VU0NuZRWGjjld/8kuqmucxdswmHtYNF1i4WzC9ieCRIT88Uzc29+AMxKipysdv1qFSK7Fy1RDLNyEgbJ9rOIIoSkiRlKigK5XSInUKlEpBFEY1GidGowWTUUl9uQKNxvXXUnEjR0eFlaCxO7YKl3L5pEQqlIiM0MXI6q+U+OhZKjvvCv3k79/1txc7hYOqv9uztWn7PPU0urUaFGB4mFhlD7ahE5aihYfEy6hctpfviBU41HyDk66G01EZxoQ2nw3htjF/ISCsbDOpMv+WNphLxNCPjcXp6/URiaUqqq9jwoVvY9+wf2LDKjVKlQmF0ozTkEYiq6Tl7ls5zz1NVYeWmTbUgwPhEiJOnBlm/vgZb+TJ2Pb+LwhwlZaVOWlrHyHWZcOY6ici5aBRJcnNd2e985XzreCJFS8vodQ39jaj4A8CmQ4eIRCJ8/etfZ9euXXz+85+/ahbcqVOnuOeee3juuedQAnOna/SPvVO3HUvDBz7wjr3+3//93/OP//iPAFcBh8XFxajVasbGxrBYLKimDeD1XPwjy265umqw4NoJh6AQuHRpjMJ8W0aNSqnA4TCQ6zJhNuvQaNTEI2OEySfHHaCgwM+Zs0PMnVNILO7jwM4jrNq0gvVaFXv3dbBkcSlOp5FbttVx/kIPv/vBv1E3fwFl9Quw6FIUW4YpLBwjEU/y0s4+lt92P22nj+G7NIrFrKas2IzNrKK0xEFpyXuWopNIpBkY9NPTH0KpMVK/aAWL72zMPAdSitTEJVK+rsxgiWkS2LFjfccmnCOPvG+G/o3fewd+/OcFB557se3ORQvyKS22I8siyak2Uv4+1PYyVJZSKhpnUdE4i3gsRveFs5y7eJbJkR6cdh0Opx6nw4jTabhKT/tNAkqiKSXRqMSkL8HoiJ9QMIbOZKKosorVd8/CYr+s37J06zZ2vfIcVrsD70QfiVgEh01HQb6RbZsrs2W8Sy2jjI6G2LShDmPxYpr3NKPFT319Mf5AjN5eL1u21IN9Fs1PPs6aFSUkUyIXL41y6y2NtHYG6OiYQJQkTp4azBi+cOOii4uAvECAL33pS/zkJz8hkUgQj8dnGHpRURFut5vHHsuY9eppeq3M/9x6/buJosjp06cBqKmpIRAIoFKpsoedJF0th/1GgQkAt8X5Jh4907X2yo4WFi8uYWoyQlGxm3lNLl7d2caWTbWsW13Ozicf57aP3c+cOQleeukSRYURSkvsxFrHOdl8nvnLlrFJq2Lv3g5KS51UVebQNDufhnoPXd3dHH7uHIFQGqPFSo7byfjQMOvvuhuHx83SmzIHU2BqivZz5znfMQJSEqtVT67bTI5Ng1qZyqi9yDcg/y1DIBRnairC1FSMKV8SnclKWWMTW9bOztLC5VSMVLCXlK8HWbxcWuvt83H4yAAmo/oPDz309kb3vm00LJlKXVi5cvadkwGBtl1dLFlUgNWiQxbjJCdbSE61EpOtXGqboqxhDnXzF1G/cAnIMr6JScYHexkb7Kela5xEPJ6ZqiIIqFSqzAMsCIAwPXA+E74bzGbMViuewjKqFxdfs6FAEiV6Wls5e+gAiBITA72sX1uVbfF7/SEdHQ1x/uIwpcUO1q+vR1uwhNPNJwiM9LBmVQWiKHHwYA9rVlegcTWy89kXWLwgH6VKwcF9HSxZUoLe6kZttTDSfQ6n04hWq6KqtoiXXr7wtvbyfuDrP/0p8+bN48EHH+Q3v/nNDANZuXIlS5Ys4bHHHsMAPHwlWe1/2NCPHj1KKBRCq9VSVVVFa2trRoAhncEyAoEA0WgUg+Gd1QIkWaa8ooDBgVHGx0P4/TGsBQ1ozRqamkIcP9nPksWlLJqfz44nn2HbXetZszrBq7vauPXmRupqczl5qpeLZ400zFvBpo0aLlwY5LU9HcydU4jdrqemOpea6gxBxe+LsWvPRcw2O807dtC0YiVlNbUolAqsTicL1665jJRPTTHS18+Z1kFikWimJCxLgJiZ3SbLKJUCyBLJRIY1p1CqEEUJi8OOu6CS2fNLsee4pj23xGB3F70Xz1JX60Qv+LlymkgolODw0UGMznzmLKgWj+4/d+rt7ufbNvR4JLl7YmjgCyu33WYOp1ay79k/oFbEmdvkwWrRgSyjx09dkcSlY9s59GIMp9tD5ez5FFZWYc9dSM28he/JQ5dOpejv6qL7wjlGensoKrSydK4Vi8VFKJzgwKFuqqpyCATiTHkjJJMi+XkWli8rx+KuRGGrYtczzyFGx1i1shxJltn9WgdNs/OxFdRw9OAZqsr0mExaevu86LQqiopdRJUl9Lc8web1FYyMBSkqslFYt5R4/PTb+v4fAf4OeOihh3jwwQfZvXv3jH+vrq5meDqPvxeyWnB/Cob+9NNPT4eSSZqbm5mamqK3tzdbOYjFYvzgBz/gy1/+Msp3IAgai6UoqFuAgkPYbQZqa9zs2nOBivp7KCrK5NNj42E8HjNeb4Qjhy+yeGEl8+ZE2PVaO5s21DB/XgFnzrWwf/sEq7ZtpcnUgneok7b2cXy+GGq1khynEb1eTVf3JFs21U7jNgnazu7n8MsvkFdaRkVDE0VV5dl2U6vTidXppHbetQdSiOl0lumo010bsEslk/ReukTnuRNMjY2R59ZTX+dCjy97g0OhBGfOjRKMCKy+40M4TEl2P/3UGBHtiffd0DUp0/GeHm9i8fg5s6VwKbd/+s8Z6Oqk+dWX0SgSzJmdh8NhwGBQs2Bepj7q80bpPb+bk7tfREaFKz+f3MISXEVl2HKcN6SimUomCfp8jA8NM9rfy8TQAGIqQV6emYoCA0sbq2YKH6QlTCYNu17rYMXyMtasqkSlNaK2lqCyldHV2sHRR39ETaWduvnliKLEa3s7qK5yUVpbQ89gAnVqkoJ8N/F4irNnh9m2tR51zmxe+u0zrFqaGa9z6dIoS1bOpqd/AK1OzRVd9G+5ioElwOh0I88bmXHz5s3jiSeeAGDjzAjwHa+P31XPL5+69I5/3+v18k//9E+0t7dnDf/16sHr3vz11dzczFe+8hXuuusu5s+fn6X+3sjS6zUMDwxRN6uCE82XcLvNLFtcyJ7nnuOWe7exZHGSV3e1sXljLfX1Hvbu76F3pJiKuiriiRSv7mpj/doq5szOY2Q0zEu//m9mLV9DWdOtOEt7EYP9xKMRLrWOsntPO7Mb87PTd6wWLYvm5bJobi7jk2H6zr5G8/bnUGl05BYU4ykuwVWQj8Vuv+azq1SpZpSOk4kkgalJxvt7GR/qY3J4BIEUHreeujIn9nmVM37f749x+twowYjEwvWbqWqcRTo6RmLoBN7JqO+LTw7G3ndD/+KTg7H/+Iy7MxiM5jDUjC5/EUUVlRR99q+YGBri2K5XCE71U1Vup7zciVarwu4wYHcYsgi51xtlcuwsp1uOEAqnSYlCRqJEBoVSNS1XIiOmxQxLTs7MWzMY1NisGkqcWuZV51+l655IpunsnKKnP4TF7mDWipupXJRmqOUoxtI1SGoTbceaOXfsBexmFZs3lKPXq4lEkuzd18msxjzKaqoIUkjPuWdYtbwYZNh/oJtlS0vROcs4dewS5cUZLx8KJ5AkGXtBJQcPvXrNIYtvtWYB2pKSGd7ySkP/wQ9+gMBMvfZ3Y+hf/9w6zlwY4nRb4B39/q5du6itrb3h17e3t/Ptb38bnU7H3LlzEUURr9fLV7/6VVzXGWSgVisYaG9j6ZJtiOJForEkBoOGsiIdZ890M6u2lAXzojQf6WHligpWLi/h5R2v4fzAh6lvktHrMnJSa1dXkecx4c41cqnlABcP76Fy9hyq529AkwxA+4vc9rGPkkrEaD56mFQsSnWlg8oKJ2q1klyXiVyXCea6SYsSU5MBxvuP03MuQ8lOJqVpj61AqVJO08skJDE9PXlXQq2UsZjUOBw6yjxG5tcVX0X5TqVEenq9tLZ70RrMLNxwG0XTCkViaJjEyDEmJ0MkUtLL7+S+vSPGSjga//rRo31PbNxY44wPHUHjrEXtrMNVUMC2j36KRCxOx9nj7D10CjEVo6TQQkG+FZtdf11xyNcfdkmSr8t9v/K1E5MRBoejjI5FUKp1VM9byJ3b5mRPWjGdZu9zzzI0+AipRJziQhsb15ZkgcDhkQCnTg2ycmUFDk8hkn0uh3/7C9atzNR8L14axeUykVvgISDmMtj+Gls2ZBh9584NM6sxH1HlRKUQ3xGfQg/E43HS6TSdnZ3Zv1+4cCEFBQWMj4/TQKbt9d0a+qpFJeQX5nHXhvx3bOhNTU3ccsstGTVUgwGlUoler8/+V6VSZcLV68GrCgUOx/Xn6GVAPZGUYKOhwcP5CyMsXlhCdaWT3XvPUV73QTyFUwwNBejt9VJa6mDdmjJ2PP4od376LyivBZtdz569HTQ25FFZkUNjgxtJkunpbWH7r46STisIhFMsm0a5a+cvIhwIcOHoUZ7ffgaNWqCowEJhnoEcpxGVUoHbbcbtfnPRx7QooVIobqiLJBiKMzQUoG8gSCKloLqpiVs++UFMVutl7shUS7aEe+JEf69vNPLPfzRD/+pvAq9971O68/0DvhXFRXZVcqqVdGQMrXsOCp0drV5H45KVNC5ZSSwSoePsSc60teEd78NoUOO0a7HbdTjtRkxm7Yw2U0EQMkDGNWqM4XCKqYCEz5/A540gyQrcxaWUzlnC0vKyGZI9sUiEMwf2MdbfyYJ5bsbHgqjVeubOKUChEBgbzwgQqNVKtmyuR++qRjSWsvPR/2bJQg9KlYLR0RCDQ342b65H7VnE7v/8BetXFYGQUf4IhRLklxTR2dJFUf47A51UwJEjR2hqaspSYA0GA7/4xS/w+XyMjIzwZ1eDt+9offVza0GAu9bl8w8/aUWU3v47VVRU8MADD/xR8IDiAjMdbb1U5edx/vwwkUgSo1HDskUF7Hn2KW5/4D7mzouza3cLdocBq0XHkvn5PP9fv+CWT3wKp9bKLVs1HDnWR0fHBPV1HgoLrBQW2ujr86EUJKrLzDz7s4epmj2PukVLMVmtLNm0iSWbNhEJBOlpb+NCawvjB9owW/Q4c0w4bXocVgGzSXOVDsK1pgeJokQkmsTrjeLzxZnyJ5iajGCx2yiurmb9BxdcNcJMintJjJ5BSvgB6OmZCgeD8f/82yd97+iEfsecvoc+ZrPZlJpTmzfVFns85izaojQXoHHWZPvU37gigSATo0OMD/bjHRsjEgySjCeQZelyXiMIyOL0nwUFMgI6oxF7joucvHyc7lycbvdVFFpZkujraKPt5DHSUR91NY4Z02P6B/wcP96PRqPE4zFTV+vG4nShcc3CFxDZ/9wTLF/kzoblu3e3s/WmeixlKzi85yhGeYyamky4uWNnK4sWlpBbtYCX/rCbdctz+dSfHeLZjuDb20fgH9+Ig2g0FBYW0t/fj5ROcwmoubL2TIb2+nZXsPO7qIQ4icHD3Pz5Ixw6M/W23+PLX/4y//qv//q+GngqleJDt87l+5/LY/eBYe758GYme89x8tQAa9dkKM4dXT5S2iLmLqwj2NfM3n2drFtThVqdGZrYfHyEjffej9MqkJy4SGBqkrb2cXp6p7KNL5UVOdnIsLtniq7eEDl5hdQvXYXTfXVHWdDnY3JsjMmREaZGRvFPTZJOJEAAhSCj1qiRASmVIpXOzB2QAbVajd5kIsfjxlVQQk5eHjkeT6aq9MZqQ9xH0tuGGLrcYj4yEogdONjz4md+OPSOCRDvmGz+0K/8/n+5x7R4+86W7XW1eXPmzclXqNVKxNAQsdAQCp0dlaUkM7VUdTmUM1otGK0WSmvq3hvCQTzOQEc7vZfOEQl4KXDrWDjLhlYzM7waGPRz5vw4zvwCIr5JGuc1YC2cxdh4mEsv7ESZDrJ2RQEajRJ/IMbefZ2sWV2JqXAe/f0+xnvb2LIp85B1dU9iteiw2w0EoloMGhGVSoH0DjzkvcCPuawz9zqS/ToZ5S/eYOTv1KPffVMdOpONdCTDrrprXd47MvQ34gjv15IkGZNJi0YlM+ZXYLfoMZq09PX5KCmxU1VhZ9fe8xRUVpFT0MTiRWn27u9k1coK3Llm1q/ScPj5x1GbHDQuXoq7qo4KxRkGh4K4CoroHYrgdMSw2/UIgkBFeQ4V5Tn4AzEu7P4DvpBEbmEJZbPm4CkqQRAELHY7Frud8mtgFLIsk4hngFiVWnVDgpDZa03HEcPDpAN9SHHfjDTg/IWxeHvb6C8+86Phz3/mXeznu2bpf/s+63yXx3VEkmVVZbmDxjpnVmk1m5Pp7Ch0DlpahxFlNTkFJeQWFMwYNXNDGyJK+CYmGBsaYLy/h5BvCgUpivL0FBZarpoKAzAyGuTkqVFsnkKW3XQzZpuNydERnv3Fz1ErJSornVRVXJ7WMTjk5/TpITasq8VeuZTOrknO7HuVTevK0GiU+Hwx9u3v5JabG9BaCnh110UWzTJiMmn50P17eKU/+rb3cBj4d+BlMrPTtEDudJ39G9c4je8Ann2bn7HvqT9j6fKFGVHBwcP4gilq79xFMvW2eBd86Utf4t/+7d/ed49+24YGHvtmNZNTUY6c8nHbbXNIhcd5+ZVLrFhejs2mzzQiHRxiwcab8eSo8HUd5XBzF/PnF2eFISanInR2TtLROYFGb+D2Tz6II9dN0Ovl8PYXEaNe5ja5rjmswR+IMTAQYHwqiUpnxJVfiLu4nNyi4nekeSiJIlNjY4wP9KKU45SVOZHiXqS4f8bxnRYl2joCdPb4SKeS8U9+t8sgvMuqqurd3hRtynxJISfH7v3snxWcO9XCsy81U1xkp7rcnB1uIMV9SHEfVR6Ymppk/FInlw7GSSVlUCpRKjVodVo0Wi0arQYEBaIoEotEicfjIEmZCT9iEptFS45DQ2OZEX39m0vzdHRN0tbhw+bKY/P9n8rmQGODAxx68VmqKuyEglF83hix/BRarYpjx/uIxVLcdMtC9AUL2ffqPkLj/dy0oRylSkE8nvEa69dVodIa6RkTMOuSmEwOfP7YO74V+cD/mf65Ia/6Nt9foRBYOL9hxt/ZLWpWzXOy6+jEn6xHDwRj5DgNmA1TtPSkqSk0sHZNFa/t6WDjhhp0OhXrVhZwcN8rDBXWsGDlZtYYmzm47xxOu5HGRg8KhUA8kaK42I5ep2X/c0+x8pY7cXo8bLnvAXzjEzTveIlUfIKaCguF+dYsu89m1WcbaGRZxuebYrytj5bDSVKijFKpQUaBRqfFYDRiMOpAUIIskk5LpBIJopEI0VAYWUoDEnarFo/HSJ7HQtrvn5nWRpK090TpH/BRN38xd60p46Xf/PcZ4T2gTrxrQ//ik4OxH3827+L4pdcK5i3ezPyVK2k7c5ZDRw6Tjg9QXe2mvNiQ5Ya/rhtX94abmkylSSZEUqkYKrUSAVCrdejfYqzNle8xNh6iozvAxGSM2rnzuP3TSzGaM78/MTzE0Z2voEhHWLnYkxXm8/qinD07TGfXBEsWl7H6lpvp7o1w8mf/TW21jcWri0HI5Pdnzw6xakU5tpxcgkIpF488w6Z1mfackyf7UaqVhP8IRvB2Race/OACVLqro6e7NxS8bUNPJpOEw+H33aNrtSqOHRtg44ZqViwu4LmXm8lx34rTrmTl8nJ27W5n7pwCCgqsrF6WT2fvCM/9+jEWrNvApjtLOL1vL7/69XEqKpzMaSrIGmwkkuToi79DqbezaNM27Lkutt7/MSKhEBePHuaVXS3kufVUlJmnW5Mvg8QOhwGH4+p9zKjIJEmnY5ncXAaNQYnaqkSrNaDXv7lyrJiW6BmM0945AQods5YsZdnts5FiEwye2SmFQ4lX3os9Fd6LN/n2RyyVToe5+c7b5+ToPbNQ2ytBEAgHArScPk3bqVMoBJHCIid5OVpcOZqrwvt3skKhBMOjIQaGInh9UfJLS6lbsJjiiooMoCfLGVrsgT3oVCmaZuXMCNFEUeLipVG6+8LUL1rGxWPNGMxmXDkmmmqNKJUCyaRIc3Mvao2CxQtL0NjyiapK2Pn7R9mwphSdTpUZ4xtN8uGvX2QknOZPbZ145fPMnpvh1b0eumfKpGmqbt9FPHF1H7zJqEWtunyPorEkieQf79qqS5384M89OB1GqqpcRCNJXt7ZyeYPfhibcohEYJTDzT0gwJJFpWg0StKizNmWCKFICjmdoKxxPuePHKC8yEBdrXsGz8Hnj3Hu4gSywkDTqvUUlldkS1oD3d20nDhKYHIMu01HUZ6ePLfpqhFN72TJsow/KDI8nqK/f5JUWqZy1hzq5s3FZLVmlF4nW4iPt/LCyxdbk6H+2Z/5Gak/CUMH+MGDuV8qLLR+Y92aaqugMaFx1qEyF2bpf7FohKGubvo7uxjs6kCW0ljtFmxWHVaLGq1KQKcFnU6RFfp/3VPH4imi0RTROIQiKSYnIsTiCax2B8U1tZTV1ZPjudzbG/R6OX/kEAMdbRTmG6mtdMzgvCNDd+8UZ8+NUrdgIXNXb0ShULD90V8xNdyPSqWgsNCGwaCho2OcBQtKcLstqB01hEUnr/7uV6xfVYzBqGFiMsyZs0NsXFdD/QcOMjIe+KMZw198ZA7/9KUNqEUfYngcrtHnEAinsOYWYyxaAggzDF2pd6AtWjVjms4Mb5OMEg+MsOfABT7xlR34Q4k/nqHn6ml+fC3bX21hyaJSHA4DgWCcnbu72fLhj+IwJUhOXGB0JMCJU/2UlzlJxNMMDWeqHs6CEjZ84CPIssyZ/TtpPXmCplme7KSW7AEWTdHSPsnYRJySmnrqF6/AZLkcRXonxultaaW/sw0xGUOjEnDmGLEYlOi1MlqdGsP0RBVBENBolKRSIrGESDwhE08IBCNp/IE4fl+EVFIkJy+fwopyympqMVot0weASNrfS9rbhpSKs3tvx8jwaHjbX/10+PSfjEd/fX3/wdx/Lymyf3z1qgqbIAgoVDqUpnyU5kKUeucMzm8iFsc3OY5vfBL/1BSxSIRYNEIsHEGS0lnpLa1ej9FsxmDK/DhyXbgK8tEbZg6lGxsapPPcGYa6OjHpBSrKzNkWxyvDpLaOcdo7vRSUV7Jky63oDAZikRDbf/NL8lyZwRPxRIpTp4Y4f2GErVvqKS7zoCtcymDfOIdfeZYNq0vQ69VEY0lee62TTRtr0GiU3PN3A/zzv/38fTeCL37xixw6dAiAptpcdjz+OewuF1JknHRkBDE0gizNdAJqVwMaR03W0AWVDn3Juox4wpUpUDKIGB5FjIwQmBzn7358iV+90D+jSvDF9/n60sA/Nzp59EdLiMVS7NzVxqaNteh0KsLhBDt297B82+2UlrtJDB9haGCcV7a3MntWHnPnFKJSKbhwcZRxr8zGD38cnd5AIhrj2KsvMNTdRVWljapK1wxSlizLDA4F6O4NEksqKKyoprJpLk63+6oqz+TIKL6J8cxYpmCIWDRMOpWaVqHJNGJpNFr0RiN6sxGr3Y7N5cKe40Kj1V7xmWLmnoUGEcMjyFIaSZLZt69zeGw09InP/nRkx3u1p8J7fZO+96mcvzabtH+7ZXO9+8ohDoJChUJnRaG1odDaETRGFCrDm6p0XG9FgiHGhocY7etlrL8XMRnFYdVSUmTC7TZd1Rfu88Xo6PIyNBKhbt58Zi1fld3wtpNHOL57J4sXFZKfl8mlLl4aY2hCYuO9H2H3U0+gV4ukJRVIMZYvykOlUpBOS7y6q5UVy8qxWHQoNGYe+GY/z750aMZnT3UfYarvPNVrH3zP9njbtm28/PJlJqRWo+T5//ooa9cvm05ZRKToFGJkhHRoKNNGCWgLM+oxyaGj6IpXodDZQZYR417E8Ajp0AhyKqMbfuKSn8986wzdQzPn9v0V8IM/AgZx34JifvHwIuRUjKmpCMeO97NpYw1KpYJEIqOEqtIZ0WtlVDo7y7bdzmt/+B12fZTGhkx0Nzoa5PjJEeav20DVnIXZ/P9i835aTp0k32OkssyG7Q3SzbIsMzYWoncgTCCYQqkx4C4pJ6+0lNz8/GtOPr1+uC4ip6LIqRhSKoQU8yMl/EjJ4IwutWAozt59HR1+X+pDn//FyMn3ck+F9+NGfed+58e0WtV/uXJtgsdtoKjQSo7zzYQnBNKSmrb2CSa9UVIpGa1ej1qtJpWWEASBZCJBKpFAlmUEZHQ6FU67DpdTTY7TcE26rNcbpWcgwuCgH2tOLrULFlNeV5c9BMb6+9j/wlNYDDKLFxajVitJixIHDvVhyytn+bbbEQSBdDrF0z/7GemoF0kSceVk6Lv9Az6aZheQ6zIhKJToStZxx8d+zcu7Z96fjl1/S6B/J0XLH8Zds/w92d+tW7fyyitXYzSf//hivv2PD6B6w5hsKeEnHRpBjIyispQgKJWg1GQ8d3h4xjDBtCjzw8e7+ZdH2kilrwZ7P8fldtn309DvqHPyh5e+QnzwAMgSg0N+Ojom8XjMjE+ECQUTaHVq0goTt3z0k2j1mWs+vXcnw10XWLmkCOX0gXz8xAChmILlN99JbmFRNhfv6+ig5fhR/FNjFOZZKCsyYrvGGGxRlJicijI+mWDKFyeZlJDJPHMarQaVRouAjEqlIJVMkYjF0aghN9dIVYUTpZB+03x9fCLM4GCQiakEo6NTUjIsFX3l9289kOGPjrpf8wLUwlNKlfDv2z5wk33Yq6Dr0kWaT/aiUkg4nXpcdg25ueZM7VqWUQlJGmqsgBUxLZFKSySngR+1WolGbbwuEJJKifj9Cca9KYZGwkQiCXLy8qmavZLld1bPYNANdnVy9NWXUBFn6fzCbAlwaCjAyXMTLNpwExWNmYECk6MjvPr7R2moslFZ2QByprNoz8FeBGRyc0yAgNazgKGBceRriA/IqT5mLzrDkV3/NsPQw5N9mHLemVTJm5W4fvDLo+w80MnOJ/8KV17h5fKa1oZabUKpsyDFppBFFelwV5Ze+frqH43xmW+d4ch573tW2nvH5bV0Cq8/gd09l8ToSQryrZw4OYQvmGLTuvLsXIHBoQBP/vhh1t5xDwXlZcxdsxFXcRmvvvwcDXV2igttLF1SQjAY59jLj5OSdSzcuJXC8nJKqqspqa5GEiX6Ozu4dPYM3hMD6LRK8t0mXDlq7NYMRduda5rBsryylJtKiaRSGUBTq9WjVNmuoMKmZ4DH4xMhJn1JvN44CpUWd1EJFUtWssgQ4fe/eLLnC78YGn4/9lN4v27UDz/reW7Nyspbi6vK0eQ2odDaiEWjjA8NMT7Qx9hgP8EpL8giBr0Gg0GFXiugNyjRqJUolYoZPOJkQswAcwmJeApiMYlQKE5alFFpdOTk5ZNfUkphRfnlpoDXQyKfj5bjR+i8cA67RcXsRk/WwGOxFEdOjKKz5rLy5jvQ6nXIsszp/XtoO3mUNStLsFh0WQM7fGwUT818krEoZw/uQ6lQEE+IhEMRDo2V8uKu01cQJFL07riFkvIdnDq8iLpbn8CUU0I8OMH2f17NLf98GqXq7U+q2bJlCzt2vHn6plIqePKn93LT1pXI0cnpvH0IQWNB46wlHR5G65mPnIpMe/ohfv30Wb7y/YtEYtdH1v8C+OEfwaPfVWdl2TwF7vxc9FoQJYkFG7YR8AYYuHiM1SuLs8YUjSXZf3AAd1ktSzffhFKlQkynObLjZXwjPSyef7mcGgzGOX9xDF9ApLSugboFi7PzB15fsUiE4Z4ehnp6mRobIZ2IoRAkjEYtep2ATi2g02Wac64UQk2nJERJIpkQiSZE4nGJaFQkLUrIghqby0luUQnuwhJy8jyoVGqkhJ/k2FnaL7TJZ84OffVTPxh8X/jFqvfrZgUjkb85eKh77QfyLWax9zVUxjzU9jKKK8spqZopyZxMJAj5/YT8AcIBH8lYlHgyQSqWAEFArdYgqwXUGj22fAsGswmDyYTV4bhmP3AqlWKkt5eBjlYGOttRCSJVFTZu3lKRfThisRTnW71MekVW3nInnqKi6Xr7MK899QTF+Vpu2VqdDfXTaYn9hweZtXITpbUZYcP5q9bQeeEcJ3a9wuqVJez7xeX6cioeJhYYx2TLPGBma4zI1CCmnBIGT/4n1fM1THQcw1O3csZ3bz7XgSjLmA06akvy0GrUN+zRL4ffEnd++ndceHKCfJd2GiNRostbiJgKkw70odS7UFmLUTsqUTsqOdt76S2N/I/p0cW0xJ13NNF8dIim1duonNWU/Tez1cKru7ezfnUpWq0Kg17Dlo0VtHeM8vh/fI9Vt91FYXk5y7fdim9igoMvPYdelWJ2gx2LRcfypSVIkszAwDB7nvgVibSC/LIyCitryS8tQ280UtHYOGOCqSSKhPx+IuEIsXCYaDiIlE4SiGWm+CKD1mBEUCqxmizkW2xY7LarBjC+nrOL0QkSoz2ZQ1iUOHFqYGx0bPh779d+vm+G/rVfh9of/oz+1ydODn5i4YIifToyQjoygiAoURpcKEzuDDCnMaPRanG63VchnG/5MIhpfOMT+CfH8U2M4hsfZWJ4FEEW8biN5HkMzFpfMiPs9wcSXGoPEI7B/DUbWDt96MRjMZpffgHfaB+rlhRkvTjA5FSUE2cmWX3HvdnxOWI6zd6nHycZGmfb5iqUKgU6bSKb/7300HK2fG0XcUEBghlJUqPSGklGfCgTe7C5tES8Q5cPhrTIa8cvUlGUR1m+k/Ndw+w51cqGhQ3X7Ih6qzWr0pI1ciAz/VZjglTmMEqOn0Ght6OY7gn42AcX8/PfneBPZel1anJdZrZtqWb/wZ30tVxgzZ33olSpqJw1G5PNxo6nHmfh3FzyPJlrqK5yUlRg4cju5zh3yMGqW2/H7nJxy8c+xcTwMMdf24lS9lFfacHh0Gd13CVJZmLCz9D51zixM0JaFHC6XdhcbmwuN3aXO6sqY3U6336qJSWREqEMABceQ4xOZMUeAQ4e7g4gSZ976EmS/9cZOoDHO/75Sy1Cg0LBovlziwwI0/XCyChMN1cACEotCo0JQaEGpRpBoaa9ZYCBvmEEQSCVTCFKErIskUokARlZFJFkCZNRjcmoxm43UpmvZ2FDyVXgXCKRprsvTHdfELPDxZxVW8krLs4eFmcO7KP11HHmNeWyqLFihuc8e2GCaNrELZ/8bBapnxga5LU//I66aisVTSVXedqof4Sc/DgDZ15BjxZU9URCoLe66T/0eUobFjF86begvZw5XewaxONykWMzc+hCH8W5NioLc2k+18HKuTVvy6MDbFl2+dBUmgtQWYrf8PClSQwfRVeyFkFQMrep9ioF2vfKo6e0AjGtgCUovQ3jyHySSqVg3Zpy2trHeeI/vsv6e+4jt7AIT1Exd3zmL3ntD4/TPzTEgjl5KJUK9AY1a1eVMDYW5sVf/pSCyloWb9yCKz+frR/5KP7JSc4cPsTRM30UFZgpL9Zj0GuyfeZzZmX2NxCM4/P1M3apna5IgnAkhYSAgAJZEJAlAY1Ok+UgqNVKikrzqa0vRZaSIKaQpRRSMowsXpt/IEkyBw/3BMaGQ9/7sx+P/uH9tMX31dA/8CTiQ2vGNl4QpB909059YOmiEmdBgU14Y/lLFhOIsZmbUZYHRblOkvF01iMrFMINMepeRzOHx5IMj4ZRa43UzlvAHVtmoZ6e2ZZKpTh/8ABtZ09QWWbm1puqZjCnxiYinL3gZ/bKtVQ0NGbDt+ZXnme8r4P1q0pmkHBGRkMkp8c9i6kENXPh4smfk1u9Dkf0ONGwm3Tci80yhZCeYLjPQ93NTUz1nsFZOgejTstwMIRiXODA8Clmpyvxd0U4MHIMTa7E4oLLpGHjDZR3Ni/L9AEIaj1az7W1zaREkOT4ObTuuah0Bu7Z1sATL15f4NL4Np+BU+v1sFDA4BBpuaSk7pkEloD4lodJJJpibDycBcBqqnMpyLey76nfkFdey7Ktt6HT69l6/8doP3uGV3buZs5sJ4X5GQKK223ili1VdPWM89SPf0BxTS3zVq/HlpPDmltvm25p7uDEyeNE/GPkOLQUeHS4c00olYrLPPfS619fIpkJ2zUaJYIgkvJ3vTXQKMn09nlTp04PjCaifOkvfz78xPsdIQn8kdY377NUGXSan1itxvU5ORZsFjVWixbr9Aytd0KJleXMTPVQKIE/GGfKl8LvT4BChaekjJKaOgrLy7IDGSHTD3/24Gv0tLZQV22nqtI1w8CDwTinzk9hdhWxaMPmbJfSYHcnh196lqpSC9XVOTO+w7kLo4RSZh7ZleSZFw+TCHvxnmjAVvwFDvz+WQqq9UwOpqhYupa8giS+vl8xOPYpbB4LnYd3s/oLL/LnL/4754cHmExOodeqmIiEUAoCMjK9n38SjfLymfyZz3yGn/3sZ2+6Ly67htanN2RmexetQGnIGH0s7Ofjf/Fzip0pvvqJajTq6Vl4eQtRWYo4sO8I6++9PuHnX8mMhL7e8jlVmAMi/WVqkl8U4LhAZErAfpPI5H4Vix67foefD/jrFRVsWmumOE9FY33uZW6EDJfaRunoDrHyljspqryceh3duQPvSB8L5+TMHGssQ2+fl7MXJ3AXljBn1fqZ89NkmfHhYXpbWxjq7kBMxtDrlDhtaqxWHRaTFpNF+7ZTKEmSicfThCNxAoEEgUCcUDiNzx+RIoHwP3rFye889Ku3ITL4p+rRr1x/91iw41v3Wb5WVODYu2rrZr0vosI3OUn3+BiBtikS0ei0ZG6mVp5Oi9Ohm5BVEZWBRDzF69MqFYISk82K1ZmDPT+f0kUFOFy5V4Ef6VSK9lPHaD11AqWQoLrSyext1TOINV5/nIttQRRaK6vveiCL3EfDIfY9+xRy3Mv6VcUzRuQGQ3GOHBumcelqls1dyK/3/jLTkGFyIAt1aFTdzFlXx9mDo6iUGgRxkHTgRVrPLWbpg9+gf/eHUOBDEFMkhBjt8YsIgow/kbkzaaBAX4xaMfMQ9Hg8bxm2KxQCGkfNtJHLnD5+ho0f/BnBSCYN3Hl0gp98rYlZlRaSY6dQ6m0sXNDwlvfxeihKXK/g1AY9jqVp2k5qSMUVuJRpYikFrjMpxNsEqIWBIjWRfCUI4GlNYfPP9PBhwGozcc9n/4Jju3bw8o5zrFpRnB3mWV/roazESfPu5zh3yM6aOz6A0WJm9a23E/L7Ofjyi6SjQzTU2nC7MvyN0lIHpaUOxsbDHH3xUYIRiapZTdQvXobeaCS3oIDcggJYvyHjEEIhxoeG8I+PMjo8TvDCJGI6mSG4yNL0MyZf9pfTz5JCochqyCmUKvRGM3ZXAdYSD8W5LkzqMC8+9qQ3HZ789kOPvHsO+5+coQN8/bHg8Yc/pfN6e04U5HhycFcUoWyqRqlzvCk7LpVMzhg+eCN9wLKUZqSnnf62Fob7+pFScQryzaxe7kGnVc84cQeGI3R0h7DmFrDs5i3ZUksqleLUntfobz3HvKZcPJ7SGR6ipX2S4QmRTR/+NEarhXgshpyMEgqFMKhEEsIi5OjD2FwfQGu0Evd1oJCSnDxYxZx7fsjo+cfJKc5jrG+ERNjLhxtuosc/TKuvHQSBFcYl5Onc5DlcjE4FyMuxZT9+wYIF1w/bl+ZmaueuOsRUnG/+79/zLz86MOM1F7uCbPzsIf7249V87oPlxIcy+fqW1ZVs39f5pu89/03+ftKl4uJWHZU3J+jYrqX0QwksBgmFVaalS89UsQrZC5ULEqQXgH9QgU4t09uqwf1omrzBy898EEglMgy9xZtuoqx+Fjsff5S6agc11RkwTK9Xs25NOcPDAV74rx9TXNPIgnUbMdts3HTfRwj6fJw+sI/T53qprrBSXGTOaL5N18PTaYmu7i62/+oUSVFBbn4eRVV1FNfWo9FmaNdltbXwNoQw3yTsRIz7MsISwVMMDo0TDEZOvheNKn+Sofvr6zsfzV1uMipfvuO2WZbXW1cFhRJBY0GhMaPQWlBojKDQIEwDcyjVma8qpbMTMdKpBF0XLhAO+EnEYsQjESKhUGZWNWly7CYKCi3keawz6vGyLDMyGqarL0w0IVDROIf6BQuyZTpJFDl3pJmWY8001topL3PM2KWpqRgnL3gpb5hL07LlIAi0nT7F2UP7OD2k4yN/9XNMvl2MtF+koMxPYcHzHNy+Ep3ZhJTow1T0QWrXfgLf2fvILd/K/id+z5x7fo29qIGxsI/vHH6M4HiSBxfcQUNpPue6hkklUxTn2igtyMhYBQIBnE7nNaevatUKul7cQk7dJqamgmz54H9wvu36ragL6m385GtzqJs1m72ng9z8sV9d83UOMko41wpgD9xjovSOBBf+YMA9mcL8QZFYSsHwUTU1m+OIBkicVTLUqSJnRRqtXyb9jIB4u0DyPCx54nI4/zJw5MOl1JUZWX3HB3AVFJJOpTjw8stMDPSwZH4uToduxsHb2eXlfMsk9YuW0rR8OcrpVCeVTNJy8iSd506jVYmUl5goLLDMSNdeFxkdGvIzOhYmLYJCqUZvMKAzGlBrdTjdbmrnNF1mHQoKUKgyHz4NvMliCqQkUjKClAgiJUPIyWBmqAMQiSZ56ZVLQ1P+YNPXfh2a+n/a0AG++4ncu7Rq4ZFNm2qtrhzTO36fdFoiFIyTSIrotCp0BtUMj50NBcMJBoeCDI3GSElKiqvrqZ03f8bEl2QiwbkjzXScOUlFiZnaascM9D4aFTl53ovWksvSzVvQ6fUEpqbY++zTOEwic2a7eHrvFLbGL7GiVsR76VsEY2vJq61iovUp2psvYXdrabztP5Fjhygo8xCf+A77ni1EENJs+UYzgkLFxe5BEmkozXPiDUZRCAK5diPnOgcpLrHi0JsxqLUsWrSI48ePX3WtGxa7ePq/PsWrB/u5988fQxRvDCfXaZV85WNVfPDutdRt/Mk1X3MHM7Xq4noF7bM0xK0KwhoF+R9IkZ+fouNrWhJVSorvTZB4SEA/LiNpBDyDKc7drUOoFNA+L5GcLZByCciTsOjXlw39BwYVFd9ewPwaC83HBrG4S1i29TbUajXesXH2PPcMBq3EwiYXer3iinKrRGu7l86eABWz59G0bNmMCDAcCNB25hS9LRdRkiIvV0dhgeUqrvvrh0c8kSKZFNFoldd8rt7OGhkNyvsOdA3EYqn1X3xkovOPbXP/I4YO8M8fss82GtVPl5bYPQvmFxtfl3J6d1GSTDCUwO+LMeWNMulLIkoKrE4XJfWNFFfVXBX6B7xezhw8xHB3G3W1OVSUmGec9rGEgovtAYIRWL71JhyuXBKxOEd2bic0McCCOS7Mpsx3339ynAuRm/jy33yJyeZZpKVq2k6lqd30VQyOAg7+aCVrvnCCUPvXcOe1c/hlNa6araiTz6Ip/BeK5myh+XwHJqOZqsIcTnUMIagkQokI3aMjPNz+GJf+8pcA/OhHP+Iv//Ivr9qDL31yDi29UV7a3f6O9vCmlQUcPjNJ4Botqc8Bt15h5MfuMlB6RxI5LZNKKHAVpOjv0BJuFXDPTRP/vYL6V2ZiTeeW6PF8LcWlPTqaNscI+JR4f6Zi3p7Lhv4XDg2f+o8llBVm6uNDQwHOXpqiftFyGhYuAUGgu6WFw9u3U1TsoqHGhF4tzUjJuvtCXGydxFNSQdPSZTPBNzJDFQa7Oui9dB7f+CiCnMJh0+B0GLDZ9VgtuhuSHH+rFQjGOHq0z+/1xQ6ORaL3P/SrN8jK/L9u6AAPrUFlLHF8VKVU/FN5WU5uTo5RpdWpUCmVKFUCWo3qKrGDdFomFheJxkXisTTxeJpEKo1CoQRBhdVhx+kpJLe4jNzCgmw57coVi0ZoO32WjnNnMehkqspMFHhMM3YjFFdx/pKPlKRi/urVuAsLkUSJs0ea6TxznHmzcvC4DdkDpqVljIvtfnb3V/P7P7zMwP67yC8KICpXc273q9gqP42341HyF3wRdeDr+EaDCI4volOfwe0Z4eLpGubf+6+MTPi4NDBGTBGne2qYX7Q+RVJM40+EqHbl8doDD6NSKAmFQhQUFBAKhf4o96oQ6AVehwUvztdjeyhN/081qLQy+R9J0b1Hg8IPBreE6+U0hZeuTkNFJRzbYCRcqWTJB8Ic+56RVS+HUScvRx7b8kzc/eFc5s52U1riuLzHbZP0DcZYsvUWCssqkESJtjNnOHXgADkuC02NOZh1Mz9zdCxKe0+YYChFecOsrMDDVQi5KDE1NsbEQC9TI4P4vZOZIQxSRs1Vo1GiNyjRa1XodEoUgoyAgEarvOI9ZFJpMaOUlBYZHw/FJibCJ8Px9Oe//MvJU/+Ttqb6HzX0vaTB+8jDN/HbbkHRZnR4SsyuKhLxBClBIJhIZRtF1FodSqUShVKFVafHYzJiMJswmi1o32JgQDKRYLi7g4GODkYH+lEIIuVlTjauzJlR1hMlmcFxmc4uP3qLjQXrt2LPdSGK6emw/jiVJWZuWl+URewnJsIcPtJHWW09D3zpz3juE5lptqaiTxMauxNzwQLmbH6QPb/5GZUrP83wyZ9gsUwx6VtG/cLZCL79qFQhEsFML0NvfITfte7i+eFdGJUGQooxJBkUGkiTgyhJqBRKzGYzDzzwAD/60Y/+KPfqs1cYOUDcIiAmBWQjOE6KdBm05FUkqfxhMgNCvwk3JqFVkCwSyKtMIWjAOk/kmMrI8j9kGHsJwOixc+9ffYkDzz5JS2sby5dm+g3qa11UlKU5e/glTu9RM3/dFurmz6Nu3ly6W1vZv2cvKpVAbY2bwlwZpQI8bgMet4G0KNE/NMDO358jFk3iLiygoKKSwspaTJYMTdWVn4crP++a3zsWjRILhYlGwojpNMlYDElKk06LiJKIVqNBIUsYVSrsOg2tJ5plv3/i6T//yehH+BNYAn8i61sPOAssGuWxzVsa8vNKSlAacjJ96yotgkqHoNROj2qaiWjKchqk9DQYkkROx5HTCfyT47RfaGdyfJJUPIHTqcfjtpCffzU4NzaVpLs/RjgiUdHYSE3THLR6Hel0ivOHD9F5/jTVFTYqSi1ZA49GU5w41U88pWH1HXfjcGfmzH3xG3/gi1/7EWWlpQwe+Ruchh+gsWyl7dQkSvvHGTj6beIRFUs++XviY0+TV5yHv/vvOHdqLYWzN/Mt/wQv9+0GSYmsSKFGxSrzMpKkKLYU8PcbP4rTmsE1vF4v1dXV2dln79cqAlqmyTLnF+rxzVeSmBDwrEtRWJXizG8MVG6IE3lRSe2T1y8Lj+arCXxDQf9RDUVLUoycUeG0i8z+35lxYgeAQ5/bzP/6ekbCfKS3k33PPo0nV0vTrPxsE0k8keLchXECYYEFazdSWJVhD06NjnHh+DG6L12ioCiHskIdHpduRjr2ur7g2FiIickoSpWaHE8OtbPqMNkcKFRaUOkQlJoMGKxQIQiqqytDsoQsJrLPnJTwIcamaDvfJp4+2XfgwR8OrRP+Z2di/ukZOsC3P2grNVo0O+bPLSyrr8tTv1/fLhROMDISZmAkiiipKaisoWr2bOzTs8Cmxkc4d2AfgYkRyktMlJc5sgYei6U4c2aICV+SFdtupqj6cuPD2NAgP/j331G9+vOsq1Uw1nGawvoSCD2FQXuR9vMVjHQFUShCbPraebznv0x+4QDHX5NwlG1gomMHnm0/Z8Oz/4g/PYVKKbPBspZ/u/nzJFJpItEEw5NTeBwW5lRnqLc//OEP+dznPve+3pcngbuBtkYtkXsUqJQy+jIZhz3NxVd05FhE5HaBihcT6GLXp7kOFWmIPQRTf1DjbkkSWKxCUQSz/k/G0P/Bokb7oWr+7AufuAyWyjKtp45w/LXXKCsy09iYl43E4vE05y+O4A9KVDbOpmbxctRqXWaMdlsbHefOMdTdgdNhpLjAiMdjykz9fR+WKEocPzEQGRwMvDx0buC+TMT6p7H+pAwd4OGb0MoF7oeVGuG2qvIcfVVVrsVm1V2lGnMjKyMZHMfvj+L3J5iYiiNKYM3JpbCqgdK62qwkVSqZpP3EYdrOnsFskKmvzZ2BxgaCMc5fGCUQkpi3ajWVTQtn6OE1b3+FmH+MptkO/tdPJR777W9peXYN3jEHKmM+SrUTq6eUnPL5tLz8Bao3/zv4f4JBs5/egU/jKhTQCzsZmbqXhm1/w49PPMP5jkE+seAWSnJyCEYTqFVKCnMs7Dp+kaDFy70NaxBFkdWrV2elpd7rdQvw/LQn7v2wGptNYmK3ispPx5nwq0m/AHNfjiHcoN/qL9GQ+iaMtaqx2EUivUoMGolZ38sY+rocLb/85QqOnBijqLqReavXZvUERDHNxSMHOH/kCAV5BhrrPFkacmam2hRd3T7Mdjuzlq7AXVqXFQkdGxyg++IlBjpaCfh8OO1GXE4dNrsOh82AxfrOwDdRlJicjNDSOjY5OhYKpCXx7z/3k7HH/tTs6k/O0LPe/T6rHUF5hyDIP3fnORR6gxFkGYVSgVarBmQEQUYzPbQhkUghihKSKCGhAFlAFgRsDicOT152aMSVba2+8XE6z59ksKMdQUpQWmylrNyZpTrKsszAoJ+W1kkUaj3z126kqPoy5zydSnF6/x76Wi8wb3Yu7lwDU1MRPv8jP489vQ/f6b+hsLAVSTmf0FQ7rcemcDd9Hq3ZRtvLX6B6oYuBdhUL7n+a0eOfoqAowMEX1az+fEYmat/pNgpyc8i1mTjZPghqiZPDbVwa76Al0UHzJ3+ciSTGxli4cCEDAwPv6T2oAY4ANqC1QYvm6zKDBzRYYmlivUpy70oTalYw57Ebn+IbMis4cqeJ+ptj+MeUKPwy0eMK5j8Xoxf4cpOTv/tyLUWFNnr7/Fzq8DN7yQpq5l0+WGVZpv30CU7t34tJDw11uTMGHwaCMVpax/D7EjjcbsoamiiqnY1yenqKLElMjIwwOtDP5NAgU6Oj+L1ekGU0WjVGkxaNWoVao0KtViKJEqKUMZdkMkValIiFE4TDESRJBGRvJJJc//XH/Gf+VO3pT9bQX1/fe8Bxt0qveuTW2xdanEV1qC0FxNMqkrGZD5egUKA3ma6Jss/IEXu7aT11DO/YCCY9FOSbKSywzcjbp6YitHd6GZuIUlpbR9OKtTOQ2ngsypk9r9Lf1UZdpYPyMmd2J3ftGxCHqFG6ym/hA3ffTv/uNZRUR8Dw5yC4Ofnyf2DMvwd/z3NI6Sn0uRsoW3Q7hsTDaFSH2f9iA2s+/zKCQsWJlm4EpYZgMkrrRB//evbngEA4GSbfksPJBx9BPU0MOX36NCtWrCAajb4n+24BmoFyg4JLi3RE7QpCLiUrPxnizHN67HqRhFeg6hcJzKEb60oLWRScu1mPfXGa4sUpjv/MQOMLCVwTGaT8X01q3P9wK2rvOXHblmrl65760qVRBkai1MydR8OStTMozhNDw5w5+Bqjff0UF5mprnS+ocU4Ql+fj/GJCBq9kaLKKqrmLMRkz3kT4DZJNBQkGo6QSmYkzCQpc30KhQKNXo9GJaMS/QjxUXa9eubs2KT/ti894u/7U7ajP3lDB/jO/bbVao36D4sWldjra9xKhdaMwuBEqXMiaMwo1EaENyi1yGIKOR1FSk+L8sV8pKKThH1eDAb1jDAtLUqMjYXoGwgxMRkjt7CQuoVLKSgtuwzAyDKDXR1cOHKAaGCS+tocigovSwdHoyl27mwblVRG552f/Zz6Y597gmdeeI2Yr4+O7R+jvKYZvdEMgsRQt5VLxy0oGcJR9QB5NeW4HScJDD3J4VdnYcnNZ9VnnyQlSjyyex/fvPgj0qKEpPUjSqAQIF9XzOkHf4nyikF927dv58477yQWi72r/bYCLwGL1ALN9xipuDtBsFtJ/tIkl3bpcXnShHoUlDySwjFx42no0ZsMmTLcq1pm3RPDN6Uk9t9KGl+LIQM3Fdt45tC/8otv/ZNoMaknN22sduv1l0Pzjs4Junt8uIuKmLV8Hbbc/MshdDpNb0srLaeOEZiaID/PQkmBEZfLmAXiRFEiGEwQjSUpKC5AZXROC5XqUaiMCCo9gnKmo5DTCaRUBDkZQox5EaOTyKkQg4P+aPPR3qOTI4F7v/ZkeOJP3Yb+rzB0gH/+kNFtMBh+aTJpl6xYVmb3eCxXX4xCBQjTlMM39zLxRIrR0TBjE0kmvVHUOgNFVTWU1TZcRawITI5zoXk/I7095Lq01FS5snplmbq+xOnTg4G29ol+UP5y9soV3126cZPwha8/yWe/8H9oqK9nx78sJxaOklOYj8XjRm/NQWWoIxboIzBwhNIF68i1vczpfQk09s1o0r9Dlft1fpVO84uzzyCKIrIqgaDIJMLl6jJW2VewtXIJiaRIRZGLEk8OGrWKAwcOcNdddzEx8c6evYLpnHwe0FeuQXwIhp/WYDRKiLWgE2WM/y2SM5m+YU+eNfT7DeAQkE5m6rrSUhnDsMysR2PsUAic+dxmvvjVe9j55ONy64mz/1ulle+sr3XnzW0qtFwpHjI+EaK9fZJIHMobGqhduBLdFfLfkigy1NtLb8tFhnu7EWQRd64Rt0uDJ9f8Fp2SCgSFEpCnxyjNXIFAXDx2rL99bDL86JRn5NsPPYT0f4P9/F9j6Nky3H2WRSaD9h8VSsWCynKnIj/P5rDb9eh06hn6XamUSCyWIhxO4A/GCARSBMIpBIUGrcFEbmEJeaVl5JUUZ3nRr+d/Q53tdJ0/xdTYCEadTGV5Dh7PzNFQiWSaCxdGI61to2PxRPIb/+uXvt//6m/rWm6+/+M1VqeTlrYhfv77Xv7jx4/g7Xye5MCDRKLFhHwCsaiOWNjI3Hv+jbZXPo2gKqJp0R6O7F5MxfI7yXM8yYHnoqz6/G6W//ef0RnszAYWekHPd5q+wYamJiYDUewmPZF4gp6hUdS5EqtKZtHb28t9991Hc3Pz29rbtcCjwOuV5M5qDYp/lhl7WUP+wRRj9Sqsq0SKv5FCH3t7z7ekgKNbjRi3ShQWJzn+WwPVt8UJ/ZeK2Ttj3O3U8R8H/pUch4nB7m52/O53nWPO7hpjj+vjOq3i7+obPM7G+jzTlfdYFCX6B3z09HgRBS0FZWWUNszFVVB8VQ18sKOT4f4+Jof6SSXjaNUCVrMSm1WLzarHZNai06quAuTSooTPF5EG+gP9g0P+qWA48fJUPP7v/1MMt3e6VP+3Gfo3HgseA2566MMOy5lzI6ta2sY2qZXKSgnyxLRUb7MZNBqtDpVGg8Vuw+p0YSlyUzTPQ47HM6M3/XKYn0SMe5FjXiYHOokHfNSWaDA1lF712onJMGfPD0+OjoTGEvHEt8N9vscf2ks6fY/dmqdUl70uNZT299N2vpmJiQlclbcyHuvBLf+O0rmfBOLEvS9w6LcPUrLkk/Qe+CqdOjNlyz6FFNuDoKrEYDxIMjTJ3vt/xOMXX+P8eBeBRIjUlEB1XlGmZTeVRq1SEIol2TlwnI6eTlaVzKK0tJQDBw7w3e9+l29961tvyZ6zAf9ERvhRQYa91tGgQxeRGDihYd5nYpw36ClYkuT/a+86w6OqtvZ7zvReMpPeCwnpoRN6kSaCKCiCItgRLCA2lGssKIodEcF6FaliRaQTeiekkEJ6L5PpvZyzvx+DE3LVa0G96pf1PD6SmTOn7LPfvcpe6126XdxfDXKrnIPi64XgKAl4YGGycZA41o2OHTxkH3KhFIBXy4W5uQYadSYi4uLgZbyxonJN6MObdO+vvQsfnz/tu+nChbZHI8Ll2oyMcK1W4yeIiIsNQlxsEFiWoFNvRnvxLtgagxCZ1Bu0MAi0SAWRWIykrEwkZWUG7slusULX2gKTrh1N+g5YqjthNZkBwoDxeeF2ejsJhUMsS9rdPm+xx+Hb9fgGcw3+pkLhHyQvzw2+Tijire0zMFOR3r8vjy9RgKL5XdFalgHrcwBeJ4jPCcZjA+sygnjtP3lOQgj0egcqq3Wmmhq9jSXkmN3mfPnxTy3dKkrWPtRreZ8hw5Zm5ebCZjTimw9WQx0ZhsMNffDiy6v8gcDC18G1vgZVZA7ASYLXvB4lZxLQXt0AkYSLzBu2wt2Yh9AYPs7ubYAgaCJkIQmIz701cJ3PD5zG+MFZ6DTZUdHSAYPLjK/qDqDUWAk904Yvpr+C/uFd1FNtbW14/vnn8cEHH8Bu7/6cMgB3AngcwOWhqYLRImgX+NBey0Nitgtl+0QQ2VmQBiB5txsix68D+vEpEkTe5EHFcSEGzrLj6HsyxB11oVe5GxQBZgUJcN/KfigvacL1CxdDJJbi0LffovTUmZX3r23oxnPxwmx5f4lU9ACXpofFxKikSYlatUYj+S/brxQovgQcocpPV8YVAlyRP64TSMBiwfq88DhMKDl1znHxQlWlyWa9dtE7bXX/FGz8o4AOAHmz1XIRl1ogFHDuCNbIZEmJQUHaYBl9eWfM/yZOhxcGkwMdOpu9vs5gsdrcDorCKZvV9UGC13zghq34UR6kdx5IMM16cJGCz+XiwOZ3kJmuhVjEx81PN+CDjXsRHBwMxudGZ9VBePVbAdc5+DwOsJDDYg6Hvu4EEsasAc/xPkIjSnFyXwKCEq6Cs+UTRAx5D9qEAQCA744VITE6HCIBDwW1jVh04nk4fE54uSYQlsKDfebiyeFzfnB/er0en3zyCT796ANwC4sxC/7+68r/fH4RjQvzhfC5Kah6M6AVBIyFQtBzPmhbf33+R0M8H57FFDpOcCFxsvCkALGjvWh4iYe+u5y4AOClQRq88eJAWCwuXKw2YcSN98Co02PDqjftEaYWxY+NeV4eaEGVcrhMKryFAgaLJDxZTLRartVI5SqlqFsc5adXccBsdaGj3eququ7ssFjd5Raj8+VHPjXs/qfh4h8H9G6r/yxFXx6PO4Yv5I5jGfTiccDl8DiUUMhjhUIeYRiG9noZxuNmaZ/PR/lYYgOhWliWKXA4vIfh9R3+JRHVtQ/EzYhOTtk85trrqLbCryAWMOBwaFRc1OGrfa2wqcfhzdXvweu0YN/LoyBWxyI07WqIVRHgi+RQhCejteRbNJ17B3HpwVArvkNp2XyoIlIQLH8PpQVRGDDXXyDaYTDjeEkt/l2/HQ7WisLOMvi4VsghwwjFcCQoY5CmSoBYwENqXAQiQ7pzlrNtVaDDkn7yWYqGiqB8kEHpFiEEdgJGRCFlmhPcRwhCm3890E9MlCDuPjdqDgoguEhgldCIGu6B6DmCsAYvZmhEyBivwKTRMUhM1PibIVAiaNMm4Yv33mdb6+rmPfhe28e/ZIEXsMgVSuj+PB63P8WSWA6PI+ZyODRFER6PxyVcLg2Xy0sYFl4Q1uNjYKPAFlhd3u12xnf47+Z39wD9v8irMyJFXo5L5eG6ZVyW9hIua5bqrLb7v8NvahWaNwP80PDEzpkLFsiozuNgL7kB54uaUFphwo33LsQjy3di4UMrkZOTA0P150D7PfAyCbCaffA4aTSUu9BrzONoObcSMpUCQrEO6swP0FayEb0zLbh45jSiR30DqSYahBAs37URmy7uQ7O3HlwuA1DA/NDb8cg1M9BhtEPA50LI5+JwQRmsKgPGxPVBuCzoFwH9zFQRQm5mwGEJ2vZzQQUB/BaCtI9+PbVZQxwfNb35YGMpDJxnx6lPxUgc7IZuAxd9vnLiOx6Nk7eOwJ33jMK2dWvRJzME6Rn+UCAtUMAhTMOWt992GI2ekLytuitqyr5ihkrhkhDqnwzmf1Qw7kpl8dYmJwDn73W+6NiUdzMGDZCi4xBYxgObzY2Dh6qJ0eKjpt89H3K1GsufnIK59y3Ejl2HoU64DkY4ILY8DE3MdYDgKiQONuLUFyvQ2QIQphl2QSSS4/uh88IroDjBEEsdqD6yHmkTH4SdEOxqPYFWtgaXEr0gpSRI0kaDYQnsLg+4XBo2pwcUxcWz+f8GISzmZI3/2WcxBnHgJByUH+Zi4Aw7OBlcaEO88G399frg3FUiqGYxiOF4IItgcXG3AGqKQes+HtL3uOAE8EqoHF8suxFCAQ+Tb70V33z0EZpaTGTEsERKBDNETAEyBw8QlZ4reB/Q3Xgl7+mxrUYz/h8LBz3ym+XdBbFTJUrpMwPSeJzmZgNOnKgjZ841wctyqNwJkxCb3AsA4LaaUHj8CFrMXPTtNwAidSZc3nSY6z+FmF4LmilEVEIbJDILWqoIfB4WCcPvheHiNqi1erTVe2E32qAr/xwRKddgds4k1Og7oeCpEC4Kw9Xq8bgpdxRoikKnxYHSlia0m61YfOolmDwWNFhbMS9rkp+33WYA9cqqH0bGZTTKbxIi9hoPtAlemA1cNOzjQbAHSCz4dX0FdFouOLcStJ7gw1tBQ9GLgd3EQfg7XiQdcYPvJfiXjIfIUUoMGTUQPL4ACrUaXq8XtZV1VFVVO2lrtUDAA5UYzaeqakzJo1M5tTvP2Yt6Zl0P0P9s/z/ey7IHaOKhz5xpoFtabYhKyaFS+uRQ9RcrMWHmTFA0DbNOh3O7t2Dm1dF488ODyO4/ChqNBkJFIoj4KlhsmbCaZTCbk+Gl+yMkfS6chuPgiqPhc9RBpapCS0MQpKEDEBefj4pjFxCddT2mJg/F7IyrcHPmOIgZMQw2N8KC5GjptOC5s2vxafXnsLFmgO8v5JmVPh5invAngV6ZI0D4XV7UrRIALgrGSi6C1AzSN/96k92g5UJwHUHLBR6kRhb1RXxEj/WC2UNDbmZwhKZwbKAWjyxMx8n8o4hISgOPz4daG4zCY8cwePwESiAPpopOl5GzBfWEsF7icHinjsoSfrG/yNXRM/t+vdA9Q/DbJMFrrvd6PEMtdt87Mckp5LYn86jsIbk4sWsHuDw+aA4HrM8NfcVeDOwfDoGAgxfu0eLBhbfC4/FryIZTa3Fh51rUlehhMkbA5YqCw2JFr/FrUbPvQehbnICvDhQ/FlJNCgidAoVkHzoqT8Bt6+p42js+HCaLBWuP7MZzZ9eiztIKD8cCmusFTQEmjwn1pv+OD8Kl4HHQgIaCaDsLjoeA/Q2OXVs4D3X9eKg7JkDm7S5QQwiiRnrRdpgHbYcXJgBPhYmR93gWJBI+hgyMQOOZr0AYHyQKObw+H84c2I3efXJwy2NPUonpWcTr494HD5XlTTCW9sy8HqD/qXLDVjAisTBRrlTNH3vDTTTD+LD9w7UYOSwBHA5FQFi46vci5LL+Z8EqAeaO4+FfTywBAKROWo6kvgr0zT2L6JiziAjdCzHzKc5uuhfC4GlwtH6Lplox+LJecBjKIZZroQ1rgq5yP46um46iLx4H6/NAJhYhPS4Mp1tLcLy9EA5OBwjpStOnwYOY9985+WKL3DCf5yDpThd0M7gIm+oFW/LrxqQlgo+m63iIvckD7WAvbO00GDcFSzmN8G1e8N0EC5V8PPVUDqRi/ypCURQiQkVwNuwHQMChaYwanoDtH66Fz+vFqGnXc9TB6teFco7q75Ju2gP0f5C8PEc1USCRfDz9rru5fAEfBzZ9iOzMEISESMGyhHLW7gPxdQ/k+3wsJD49aop2Y/OmT0FRNCKHfw69KR1i/jnItUmIzJyL0bNGgrXthrFTBF0TF25zLYTyULgdVoAANIdGWOpgRITtR8Fni0EIi1cLN2Ovfj+4AgcoqjsZioDDg4T/3/nwZVYWkk0sOD4Cp52Dug8EyNz1y2OWumAumq7mQpnIoHq3EJpQH0w6DgT7Cfq860RovRcrpDxI+gbBaTb9oMcb8djgbDwMgECjkaBfnzDs2/g+OFwupsy7QyBTBe155bbgrJ6Z1+Oj/6kgFyuVX94wfwFfplSg5MDXCFb5oNVIsGtXGbE7PRSX9sLp9KG9w4qGRiMpKmzF6bP1lNVBYckTd+HVVesRFZOCqOhYyKKmo7MFsDZ/Dj7zHnjUMag0HRDJVGipFoJPl0Obdg9cHV8Avkb4RLOhisqFz1ICmWg/2ps0uGn0nWixmODy+hAqCUG8PBpDw/sjXByOSksNjjeU44bUUeA6LT/qoxcPEqGzPxcRuV54+RQ4ToLwE79837y4rwhJD7pR8bUQ4mYWdWcFiBrggd7KReR5L7YJOCiZkIUX3lyAo/uOoqiwAQaDndhsHjicXspmd6O1sR2NzSa0NBtJZkYEJRPTqKuuQ1SvDMSnZfDqSktuHZEi3L67wNreMwt/nVA9Q/AbQK5QfHnD/AV8uVIOw8V8ELcBbo8Pu3aXswajg07OSGN5AhHtshkIhysEAw5VWVwEpUqJUddeh4T0NDicHsy++yOsXrcZMTF+WqgdTw8AaBGkmmCoo/ogKH4IgpMG4vxnC8DYz4PLFyM0rBgkdCv4YiWYthXQanbgzLHJGDjvp/v0PXf4E3xY8iVyQ3Pw78Ezf7CP7uVTOPegCDwBgSyGRc13AvS6zgXRowShTT/dUMQQxEH1KAHoIAKzngNRIpB5nQPn3hdBHczAJ6Kh+cCHthovlmdH4dOvl4HLpdFSW4ftn3wEu9WOXhlZYHwu4vV6KaUmGO319aS9tZVSKkXsxPG9aaGQC5YbBHWvkbBbbfj8vXccJr0t96EPmgt7ZmOPRv/DQC6SKr66/s55fLGvAa62s+DCBV2nDbt3lxOL1U2LJUIMvGoi1X/0KKT06U9pIyKpYzt3IDRYBo5AihFT/MzoPB4HwwbF4457/oWrxl8DmUwGTbQcKuEHkMlF8NjKYW3ag4r9H0Hb6zp4nQ5YWk5ApJBBFDoTkqBIGKo2QhVkQHtzMMKzZ//kfQ+PycKIqH4YE9cXQSzzA43OYYDmVB4oQkH6HguhlYDqDZjdHISU/7hWd4pplN0khHa4FzYdB5pRPiQNdKPoaxGSJrlhN9NQ/NsHc6UPD8Uosf6bf0F0qTOPTKVEw8UKSAQMDJ0GXHvn3VTm4FzEp6bCYbNRHU31sNhcVHVVJ9FoJFSQgoLPeBFcDoPEviN4tWUltw5LFn2757y1rWdW9gD9d5WXblZP4AmF3wwdmshz6SthM+phNNlRUNCMkgttRBsRQ/XLCUFbm40MvfoaisvjwulwYPuHazB0UDQ6Op3IHDIa2vAusgQBlwLbfBTPv7kVY8Zdg+DowWChhpT/OcKTRyKk1xzEZAxGe9n7sNmVYBkOfE49CDcB4Wlj0Xj2YwRHMmhvlCI8e85/vf9QqRoaseInt9f0Ci7UU32oooWIvdsNt5uGq5lCeHF3oDtFNCr7CNAUyUX4TQyaPxUg4qgHyAXaarlQfcKg4yIPQbsYOCq9WBQjxa23xKBXRgb4l9Fyi2Vy6JsuIjVFi7OHj6FXzgBQtL8WvPZCCcnKjKI40mCquKAaBoMdXA4Nu1EHS2s5wsLUvLZ209wxGYLtuwvsPWb8LxBuzxD8vLwwWzGOUORLHheGMycvNrE0J1smlVIcPp+KSOqD2CwJ5e4sR3ioGAQ0JRAJwfg8qD3+GSZelQgej4OTZ9tIaFRUN1epOP9rTJsQg8EDvJg7+xr8e8N2hCXeCXNDGDpqHoNG+wFofjhSsu2wGo+gsrg32msBhnkL9pypoMU58DgugCDqip8x9rwHteUCRA7ygssB7J00XDwOim4RQXaWQWidDyXDhfClUdAO9IIu5ULfSiNymgftfB6ch2iE5HihNrBI/M6Bcgq4P0aKd1YNhkLCxYVjuzBgwoxAlVlwZAQcTpYkJmio6CgVGs5sQ2z/6VBpg+Dx+qisjGAUluiRNesm1FVUobC0GmAZYrXawQF7hvWReMbHHF5xs3LYY+tNPWZ8T9T9yuT5GVItC1rj5JDQBWtaQwwm18fxadmYcf8S6rp77ocmWAW+uwaxURLs2FFKOBwOIawP7ro9iImUBthMfAxD8S9rB9VRdR4JkRR4PA6iQoRYcZcCs2+YgKqqKiiiJyN0+HkYyCq0dY5Hc+s4GB1zoE64Gjk3vA1Vwk04++FA0DSFqhKNn9ueXBl9uMLIIHq1B+LnWNR9wEfyVS7wQ1mQCID7MHDkWgk0c33gO1k0fCpAUKoP8f08YNSAdCCDuOlu6I9yoNb7cIRD4d5IMd5ZNRhqOR8cDo3eMTR0NV2JbQKBCAzrjxHx+RxolVw46vdALBbB6/Fi954Kkp2hgb25AL1z0nDj/Utw44OPUgiwVmkAAGTDSURBVKHRcYzO4Hr2vrVtGjjpXoSl0lfeEiLpmak9pvsVyb5Sj2N/sas4/7zL9dIMbShPwvti0uybhXyhEB01RRA4qyGTcPDdd2UkIjkNdosVSWFOivj8W1NtbRacOFFHnG6WSs7OgVAsBuvQgRgKuxFSuh0ueDpr8d6WfYiISkRsXAL4kjic3PAK7DYJGBIBl80NU0sJvB4KUQMeRFvJNhiaqqHUcsBXDYdIEfyzz/NTpjsAiBwslEYGbf24sDBccE4BgjME5kQaAhUBV0zgraIh8bEQxxPUnOLD/jUHMAK+nRSy9jvxGZ+Df+dEY1QujahwKRRy/+JG0xT4jBFcaSgorggejxuFx4+ivdUEsYQPqUQAMF4wTh3Ona2FKiwcVeWN6JsTRjmNLWAJD0K5BlJVEF1fVjJiYJzlrSe2Osz7il3Fe4rs3p6Z+j8A+oLnnw/qP2qS5vT+3ZZ/TCDuJpmGIxOcGH3t1ODQMCXl0RWB66wHYRns2l1OojP6YPjVU6mj3+2g9DojSkrbcP58M9GbvCRz5CS6sboKwVExUMhFcDbkg7qMCL2p2YQ9ey/imltvxa1zxmDxoqdAaBFy+uciJCESIcp3EBoBhMbKEJmggUTSgpI9n0MWMQoUVw2PpQhWI4Xw9KuuCOjfS3M6Dxw5oPnWB3M6BxETveDTBEIFgdlNw95GA3wKIilB6Dc+JJ1yQ9PkwzMSHo5mqfHRF08jIiYWOz/fC7GYj6CgSwqXAhhLIzjyGHS261BbVorEnCE4f7qEPXu2nqqq6kRTfSsMBjvmPvwoVXuxChdLG9A7RUNxvZ0gHisU2jA4XV6py+Yc0l9s3pBf989JosnLy+Pm5+ezfxugn963zzlg+LiHB428anLuyEmnTuTvcv2dX8CKm1RD+RLh0dwRfUOTIkF7DRdBPFZ0dtqxe3c5yRg6lhow5iqq6PgJ1JaVI6XfEAybOh0DrppApQ0cSpWfO4OWuhoIhUIEc2sBwsDnY9HcYsbRY7VscXErlTE4F9lDhqKm8DRS5M04VXAeX313HBOnLQRXOg62lk0QCytA0SIIxALE9moC5c6Hz+tGazUgERWivWQ9nHYxpMEJ4HD5vxnorJ2GayANZhgg7s3AWscBdxVg0HMRPcULUSSBtYgD2bcsoms86ARwq1qA1FsScdVQOewOH5KysuHzeHD2RDFqajoJj8ehRCIeuFwKPksDqmsNpL68goqKj8e4mbdQfUeOQVxaFowmO1obGqENDcOg8ROotlYddfpIMYmKVlJcOOAz1yEyTEZZnWy0h2JvGdyb/uZAkdv0d55fd61YoRg8dMILTgj1p/J3Nf+tgnFa2J7SQ3acoUnngryXX12dt+SRv+uLYDmguFzKXl5UKrXoZDwejwO7zUOaWy3UNbcvoIJCQ3Dh1AmUHNkDhVqJ/mPGBoJOZw/sBbHUYdTwROzcdRQXCwTweRji9PgokZBPHA4vrVArMHTS1fB5vWguPY3Bg2OQkGjD2o07XRPGDBK+ueZjZAw4ivbiN8C27QHjaoLPw4GbHQSuKhVXPb4IAqkK9Sc/gqnqdTSfWgRp+BQkj38eYmXor37eqBoPOG/z0NKPCzA0Qs4xiGrwwN5Co8oogKrah/41fv74AxwKT6n5yB0q8YwdpuGHhspw8mwBPDn9MXj8BNSWXYCurZM6c7aZHDlSQ3E4NAEFyuNhqClXp6Gi6hwuCHhIG5gLuUqFYVdPRvm5czi64wvQXGDUtdehNjmV2r51PUlNDSEiEZ9yu9tg7DB6WZYhlBdBAGr/rnPrvryXXyJuajGANavyFp/6o67zhybMLHpuTQRNe6s9Xq+ApjltLsJMWPuvh/62EdJnb5Yl0wydxaG5GSqN8tGZ9z/IE0nEKD66Fx3VxaAogK+OJ0OvnkoBQNXZQ6AddQgJlsJud2PbV2WYOu82KILUkMjk2PbuOjhN7ejdfxj6jhyJ+uJjUNItaGu3IP9glc3p8n2SOXLc/Hc/r8fo8TNwz/z7QdM/Hz+1tFWh8cTTMDcdQ/r03ZCHJnQtWj9DPPFLxQXgaRkPhn4a3HBtCDl9sv4lvoBeNGZUMj8iUgETG4GY9ME4m78fFWePQiALwfV33gmn0wmH1Yotb7+FGdPSIRLxUN9gglCbhPjsYQCAvZ9tIqy1ifIxQK8+uUjskwtTZyc2vvmmz2m3vc8S6igI5/TSjfryv+tcuvfZF3vL+NJ8u9MZzOFw2p2N4qh16+7+w2INf2jU/bUn5zd7Pe5+UomYDOmTEargC87dm/fS31azL1tvreD5+IdUWtWiG++7nyeSiNBatBdS0oJBA2Og07tIbO8MCgDcrWcQKulESLC/8+nho/XIHjIU4bGxkMjkqK+shEpC4GMoktynLwBALTChQ2dFfn6VyWx1p4sl4sTY2AhsWHcbLhxYgwljBqCg4OfbbMtDE5F27SeI6PcwSrcNRfHXz8Ju+P0swp0cCpM0IpCr1Hgxrw+0ajEllfJVHiczaP+Bi87mJjOChH6eh5Q+/cESHlFKgfqqKojEYgSFhCBjwEAcPe5XxDHRSmj47XC3nAJAEJ+WRbXrHBgxLB6sqQIdZQeg1Ggwe9EirkginfP3BjmhHlr+xrsKkfxCUlxUsFjIt7McZ8YfCfI/HOgA8GbewyV2p2NFTUMTnlgwl06Nj1vx6IurK+7Neyn0b/eKAEoWKt43YeZNEiEfcFR9B7nAgmCtH8wMQ0EsFsBZsxs+SwOoS1H3PXsroDc6kT5gQOBcdUUnkJGiAMXhUVK5DCAEHrcVBw5Uumw2V98nN5jqaVCxCrW/k2t6mBuPTwde+dcc3HrzjF/UKjlm0D3odfVX4NNn0VG+/4qfvwXAPLUA64fE4Pl3bkZMmD/TTS4Xgsenez++yVTgcHtG7su/6HPa/HFYiVwGoVCEzN4K1BZ1WaapAwagvcOBg4erodfbweHQ8Fmb4KzZC4VKAZbxRysjIhSQ0EY4qr+DVCbAhFk3iURS/q68uRD+3ebPwmdezXj85TWGiFDtHYtvm0m16fSM1e2ZsWrp0j+808ufkjCjZqz/sjrE99U2tUgX3DKdOll4IenrfUea5j/98u1rnlry77/Li3pnYfTzmYMGp2gUXjhr9+CHra9Z7Nvyb1alENJWqxvtHVawLEFITBwYtjnQBtjQ3oTECC5oDg0Oxx8PZZydqKjQgSVY9z1/uNfLaEUSf8TabrOjd1IKrm6tBdFyMfvGCRg7biruXbgYYrH4p8c+dgDUsV9e0XPrALwo56M2RoKbZ0eDJSL0zk7Dke1fAACEQi4YFpGAn3f/9dtDvqioaJ8RlGIELVSBw+eBy6WRFMWFoa0F6tBwqLXB8HgYeGg19h+sBFhAo5VCKhHAaDrHcjjdlRDxOeGs3oXo8Byk9esbWXL69FtA+x1/l7mzePkbzwkE/KXXjB5CDc7JwMFT50in0Xx8zVNLvvszrv+nJMzk5eX5TFbbsj2H/Sv6wKw06qHbb+LEhYV8+NDyN77Oy8v7y2foPTtLniSUSB5Miwft6SgOgJxlCVrbLDh0uIq4HC4EKcV0cXErCUvph+nz78e9z70ApVIK/mWNI3g+PZQqARqbTPB63KzX4wFjb0dFeYfXZnas/v44r9cjEYpEcDmdCFJLIBRy4XITjBiaim8+nQ+26UtMmzQQK55/6ndrrni56AE8pRRgTkoIgmdG4f23cpGaoITDbIRYKoMqSA232wc+nwuflwnQzTodrncqLnb4fPZWMD4fHFYbW99ghFLBAx9dhBkCoQByuRRzH38Gk29fAFV0FgoKmklkuIzm8yhy4lQ9jCZnN5vK1XoO/TLltEgknv38TPnAv/q8WbJypWTpK2suBCnlTyyadyM1OCcDAHCyoJRhfMzDf9Z9/GkA48s5ay02+ytmq41WyKRQK+R46PZZ1Oe78iefLSlvmv/Y273XrLjX+Fd9YVKR6BF9h4776cf5XoGQB4oQ2u1lKa+HobShwVR8XBg1JFeELVsLPf1GjuAPGuvf03ba7airKIPHS+N7Nggea0JLuxUnTtVZeTzhyjP5+59OjhNRXi9jXrrZevF7N+FlChTN4cButiAqUnnJPWACrZ9nTIjEndf78N3xPbh24hcYMnIS7rz7foRflk//W6QCwBqlAHVRQVi8/FY8OSARzSWHAejA49HwXmLIiUvpBbvDDrVKDApUYKvWnWzOt9fxfFaDnltTdJB1O50PnTxpel4uF4ojJH6TnhACl9OF6tJi5DqnQBMaAs2E8fC43VRR8RnvzBnZvNZOoLTaCEN7A+v1uAmPS4PL4zAMw/q4NOPhCXhTAZz8ywbc8l5NFNCikszkJMH1E0YGrLc2nR4Gs9m4Ku+hE3/WvfxpKbCvLV7s9DJMRUVNQ9fFaRrTJ46mrp84KlihRv3CvBfD/6ovbdH77XfaajtFHqslxmF3142cNJpz29I8etS06yiplEZ8tBAcmobF4uTlju9iXD275wuMGpEIsYiL5to6PxCsBuzPr/Q53J4hQe31z5eePqMrOFMOmiY7v//dy7eEiPk8AQsAFlMnoqL8QKfg7+9NGBdUUh8oCpiUq8aWZ6PhKPkAi+6ajGsmjsDWLZvBMMwvfj4PgK0cCtO0QiztLYN0UjC27nkWgwckAgDCUwf5AcoQfL9ZE5eWAbvDH0Oi6K4dnLw8sHw+fbTwTBkunDrZcPdbDW86fK4R+w9U+Fw2f2yhsaoKAiEXw4fG4/SuLwL3MWzSRFhMTi4IECRnwHrtyBk5jr7l0TzOlFlTOPpOe1VDgy7+zjcaVQ//W7/0rzpf7nnmlRyFVFQ+aWSu4IarxwRADgAFpRcZu8u16c+8nz81193hcn5SWFb5g8/7pfembrl2vFQhU1Q++MJrsX/Vl5eXDx8tlP5ryIj+sVGZw2HUdUJfW4xecQq0tVtQVWcEl8cF55KZ7rGbEKUlCAmWISJUjGM7vwVhvTh1qoZQIK8+9pGx+IatYExG/ZCS89Vek9mzMWC2u+xinoBHAIB1WRCs9fvqNIdC7cWLYGzdi7ZOnmqAUujDsw+NxdpXrkPJifUYPzIHjy1ZiFOnTv2A0QUAfAD2URQWBIlwdZQU9XcmY/X6kXhwYSJktA3FJ7uCZxTNA8URor7RCO6lKrTwmDgQShBYtC8Xm929uaSw2tPRrh9JAeTRD8xnKApvnDx+ESAsju36DpFh/t70WpkLDqvfpOfyeOBwuahtMKG11YJecQp01hRB394OcVgWrrnhqkSBULie/IW5FBbmrRytEonO3DhpDCe3T+YPvq+qa2QJwWf/WKDTDL2xpaPzR79LTYqn5s2YLBZzRRceWP56yF/xBa6cqxkZHhk8M2P0NB5AoezcWYSH8KHVShESLIfZ6gZ9qTMrYX3wth2FRiNBU7MZxcWtxGQw1p7auxvVNXp9u65t2ffnfXy9pcrjZqfRXhwNaFgJ18v4GBoAgtW8QAIODS/qK8rBOP2B2uYmM9ZvOIOC800ABUQmxkMbJMO861Px6VMRmJxahC/evQeTxmTh3rtmYf/hY/iaonCbWohpSVqcvX88HtjxFDbvzcO148IhFnIQGakCyxLs3rIZn7zyKgw6/6JCi5RobjaBL5RdWnQ4CA0PuxSrYLvNJYpgn9vjm/DkBlP995+1d7QtranVG0/u3QVDR3tbRUU7aW295JZ0nAKI3wLhcDkwWpwID5dDo5EgPJSPi4VFACiEp43kZ/fplfnSzUEL/opz5IFnVg6USqR7b73+ajqr9w/zFQgh6DRbaC1sJ/6xQH89b1EdQ1ivwfTjKfAJURG4edp4kZjPK78v7035X0qbz1UqRULuJ1fNnKX8npCtz/BhOH+hE2aLC51mD3g8GoTxgXWb4ajeAZ/bgfz8Knz7bQlhaGqxVW+55tiefK/D6h2ZtxXdyNKf2GT89vImA+p2k9PjcnMBgEd3cc85HV7UV1ahvqIKGzedxa59FegzYgxkciloigr47xolIOBzkJ4ox6O3hGNjXjQGaM7hvdWPYPNAKcY+1B+fH16BRY/PQFyMFjKFCtpLoFXIhQAoCIV8xEXysOH1N7Bh1ZuwuARoabXCYevqzipR+mNwLCHd2tQ+vsFc88QG04FuY7gVHofDPerorn2M3eaaRTjUI19/U0IOH6mBz22Do2oHiMsClmHA5/KgN3tgsbpxvqQTWbmDL60gFIZcMz1YqRQ+sGK2KuOvNEfmP/tiskQkOTZ7yjgqOS76R49pbtfB4XBV5+Xlef7Me/tDgnF5eXlcPS1LIwS9KIIIFkTqX1Ron8vlMtc1t2rUyh/Hce+EWGrahFGKz787UDY3Ly/ho7y8v0SefJCAv3ns1bkRYmWXsSGWyjBy2k3Yt/E9ZPaJgkgsgMfro7aufpM4XV7KqHcQiku3w0ONW7rVUAwAz81Uj3xyk+HCz10vVApfHcNQAAJtnhiGhdnsAksIvv32LIaMn4ABo0fD7XLj1P59EAj5aKisRHRSEoir+9ZsYVEL9K0GzL42E9aOGsigQ8Hhg8gZNqJrMoiC4HWbUFdngFAsAI/LQXKyFtlZ4Th7rgUb1m4Gy7LQtbYBLAvQNCi+P4cAzC+rm3hsvalw+UzV1KWbTPkUcGDl9cG7L17s2FVW3h6i0UgombSEeDxeSizngyUEJ040YOysOyCWSgPn4AiVuGbG6PiN//7uw7w8DPgrsMMufPHFcDlHVjx17Ag6vVf8Tx5XWl3Putxu+/15K1eyoIUsWBdF060UQT0IuaCB7WJeXh77lwX6fc+8kgWWLFTKpddSXG5QjEhEyaQSqORSwuF2zQGXy039FMi/l/7pvSm73Rm2I//Y2by8vIw/4sF/jbw4RzMqLETZNzZjcDe/0N16BsRkwJjRvWB1eMH4gNT0cDQ26GGxuh1gfW9JO6z/uryv25ObDMd+yTUrecrhUpHAH+H2+Rf/g4dqAArg0DQS0zIwYMwYAIBZr0dCXBAkUj6+27gBd//rKbAeR2BxOHiwGtU1nbjp/gdQf7EcrK0ZQ3Lj8e13h2DU6TD62uv8oBX4TfLDR2uQPXgYwDpgMdshFvHRr28EDAYr6hrMYBkGh3Z8i+GTrwHFl8DnY8Hl0dSzN8uSl623Vvzcsz2xyfjtE5f+/fC2jiIAYc/eqJrcqXesMZkcESm9w8ClORDyuRgzuhfYzvNw+4IgCOsbOIcqOpNO630u5Fyh71bA9OH/cn4sWblSIqCllWMG9+MNyEr9r8eGqJVUZkpijlgoyPk+zODxeInZZqNsDic8Xhn76EtvNVkdjm0A9+238xZX/c+BvvDZlXEUi4cFfMEdMomENyg7DTlpvaBVq7q5a7/l3CMH9qF0emPK8fOlWwFc/798kWIh59Who7KDaGFXZ1KvoRI+SwMENOCjAbeHAUBgMjpYj9u7l3bjhse2Wn9zvy+ZVDRPLJPBajRBQHxob7OgqkaH5KxM6JuqYTObuhYctx29kjQICZGhqkaPTW+9hSEDNNi5oxg2mweasGDctnQp5CoV9B1tcEn4oGkKE8al4HxhE9579l8QytSYOmsqvvyyCHyhBEMnTYShoxXtxV35HHaHByGRkZBwHTh78BDSBwyEUiGGzeaGSMxHEIU7AOtv2htettm4HcD29xZFrmhuNDwSEammeFwKcikPXNoGn8UGWqAAT+3fBeCI1BgwJCuyrLz9IQD/Q6ATSkitK89MiRePGtzvZ4/O6p1E/YjvHsCI1+ejG1vbo08XlT1YVl23aNHyNx0+n+dD8PhPr1p6/2/OoPtNPnpeXh69IO+lPhRDjyAEXIZhGaPFArPVDh739/MGpk8cQydGh197/9OvPPW/eo3PzVRHyeTCUHlE10rts7fCoyv2g8zDoE3vhM9HUHS+kZjMjm8XfaCfcCVN/QhAsaCuDY2KhKGjHYRh8O3OcgyfdDVYrwOZmRHoaG0NHK+WcxES4tfGM67NgMemx5bNp2G2ujF6+vW45aGHIVf5F1+ZQgGx1O/H83gc9O8XjQkTesNlM2Ddy2vgYwW47bHHAIqCOiQcoeFBgesYjE70GTYUPIEQ6Wlh2PL2alBcPoxGB7QaCQioOVc63ne81vSYXC5eefpkDZwuBu2dTri9/iCdR1cExtb13EJNLwRr5ZL/pa/+xMtr94do1ZHTJ475Xc7H43KhVipA0xTlcrlBGJ+XAsB6vZkztmz5zWXlv+mH+fn55HT+ntZT+bvPn8rf882J/TuX9x81oVin06cdLygJtjuciI0MB5dzZeXuFAVkp/aiiiuqh/ceMOzCqfzdZX/2i5w6UP7YwMGJ40J7D6UBCoT1wdN0FIT1wenyocPoBiFAdXU70XVYjt23tn0c9cPc2F/3smfJB4RFRtwZn5rO6Wiqx4WiCoAjxsTZN6Pk2GH0ywlFeUUHfF4WkQnxgLsDrEN3acwoREeqUFbRDg6HRnh0LCLi4gLnZn0MPIZqKBRdtFbtbVa06xzwelnMevABCMWXMTPZm0AYN84VNMFiIxgxZSrKzpzCqOGxKC5pgcVkg93ciYgwBRqbjYLcBP5H+0ucV0Q48sUx496ZIzUJLS2mrNBwBRxOBnwuBzwuDcapA1cZB4rigBbIIPA1S2tr2n27zjt3/tlz45EX33xFKhHfdP+tM654rgOAy+3B53vyyec786nKusbjLsZ3/ap/PXT/yfzdO07n764t3br1N8+r3y3qvmrZos9fevy+DIfHk3XsXHHdM6veR3lN/e+ywi2cM4NWK2SbH3j29eQ/80VumQEOj0fdkJQzmPP9UPkMFWB9LjAsgd7kBgjQ0W5GfZ2+ljS0j7lSkAOAWCK6JTmnLz8qMRHlBYWoqzNh+t3zAQDySxxs48Ym4cTePXDaHSCertbhtbUGbNx6DlFRQYiLC0J1afd2ZVKlEjKJoNtnDY1GJGX3R1RcJD54YQUuFndxu1FcIVxOL86ea8LU2++AQCSETKEAAEye1BtFJ06grs6AkFAp4uM0XJmMd/PvMfZzXq6d42N8xy+Wt4EQQG92gyUExOeGz3AxMH1jUgdwBQL+pDcnQvBnzo37n351Gp/HX7zglund0pt/q5y7UIFnVr2PY2eLL1jMzsxVTy3JfftfS07/Xvf7u2+vvfHEg0UvProwzmqx3fPxF98x23bmg2WvLJYmFYtw2/TJHIlIcHrJypV/GhFge1D4w5l9EqP4l/xCn6UeHr0/1mQwe8ASwGS0o6iw0eixscMuD7pdiXAozqzEjEwoNRrwBUJI5XJIFP4ApkrpN7uDtTLExaqxZc1qEMYDr4/BN99ewIGDVejdpy9CgmXo1zcKrXV1sBi7Mot5fD7kiq7CL7vdg5YWC/qNHIWI2GgkJ2nw3acbsOXtNfC4XADNx9ffXkBKTg60Yf7tN3Wov/BQqRBBwOeAz+dCKOAhPk4NPp9zz+81/q0tzSPbW0wtdbWdYFkCo8k/vB59BXwWvxLhqRKQOyI9ggnVPPdnzYuHXn4rRiYRf3b7jClQyqRXdC6vz4d/b/uWbNy+x2txOOa8sWxRxlvPLi7+ve/5D9tHX/XMw2ttNkvsmaLS1lfe2wC703lF54uJCMP44QOlNCM6DpA/PCvqlXnqKKmE92DfcdfyQVFgHJ1wt/lrwS02L5wuH8xmB86eqrV4Pb5Rj27qbPk9rvv8bHWqTKmQSOV+n3vgVeMgV/r/TQiBVt1lcquVItjNZpw4UoxNm84BPDnuznsG8b1TIRbzIZcJEBenwcZVq7qxxHI4dOB8+w9UIqXfQPCFQkjlCkRHqzD3ln7w2HRY99xzOHmkGA6HB9qwrm3FkOguV0AqEyAr078ABGtk8HqZ8Jdvkml+j7HI2wqP3ehJra/v1DXUdcLuYmC7lHLrbjsHxtEJUBR6504QR0Sprl9xszr3j54Xd61dyxPR3JIJIwfRsZFhV3Quo8WKF9Z8jIKyyos2nzdu9VNLPvmj7vsPTZhZlfdok0HJjdFbzEdefX8jLDb7FZ1veP8cqndibNr9z7z2zo99P/+Ft1UL8lYMv9Kc+bw80BKJaMeEaRNCOEIVWI/VT4pACGx2H0xWDywWJ86crLW63d7RvyevOE/ImZXSp0+A8M3rcgUsIuLzICjIX5LqsHtQUanDdXfdjaqKZkgVcgy/5lrwBXyIpVKIJf6g6FWjk0AxHnz+3ns/uNbxE/UAV4Ihkyb7QauQQyzmg8ulkTsoBgqFEBWl9Rh/VQrOHjwYSJQJi08E+T5QTAAulwrEjuNi1VxaJJj+e43HY1uNZrvFmVxb02lsrNfDYPbA7vTTW7tbToH1WEELlBh33aQ4hVyw9kqpn+cvX5m54NlXJt+7evWPqupgB3WiV2y0dGjfK+v3qDMY8er7G9BhNHyjYsyZ7zy5uPmPxOIfnhm37u67vS8+vHCY1ebc+ea/N8PlvrKEoFumTaRDgpR3LMxbOfr7z+5d/lr2stfe7YhRSQ0ZvXodjAmPaHry1bWmB/JWzvot19C2hT2T3TcxOSixH4jHDlfjYRDGn7djsXthtbpw+mSNzeFyj318g/ns7zleQp7g9qSMrIDF0lJfC4fV74OzHkOgS+qhozVI6tMPNE0hLkYJiqIhlIgumdYh4PM5gTd8zdWpaK6pxjcffQizwQCTyYkdO8tQVaXD5Lm3Ba7NFwihUvrPIRBwweNxkDE4FzSHRky0HIe++vKSRcAHh++3MpwuBh0dXSWy8fFBEIv4D/yeY/L4BrPRYHQk1lR1mBob9LDa/FqdMC64mo6AeGwQh6Zj7IQ+SVweefU37HNQD73w5svLXn3HG68NL0yLi/1G4+VbHlmxqujB5csDavuhF15fJOLz+syaMu6Knsdis+Otjz+D0Wr7ZPVTS6b+GVlyfxqv+7F9324YMPLYxPLqhoiB2WmB3O1fvTJRFBKiI6mi8prp2ZPHvTJ06Pglaqls623TJ0uuHjUE/TJ6I7dvJpWRHC+sb2mfljV41MT0YQM3ns3P/0VUPc/PkQWp5NIPx82+UwYKcDYeAvH63Q4f4689P3m8xu5yMuOe2Gj6XUskn5uljJEr5A8PGjcusEd5bOe3YFkfMgblArYmME49Llbq0NRix9Tb7kLVuaPQqhjUN1qRlTsEPL4APB4PjLEiwBtvMDrQafRAJJHj2M7vUHGxHXK5AFKZEMqQGCiD/FtoHJqAdjYG7qeyqhMDxk1CU1Up+uWE4+TxCiiCtFBpg8E4dHBajKiuN8Pp9CC5l9ZvFUgFOFfQqBiVLX59b4Hjd5vA+aVu55hk+n2L3XMPj88ThAZLQdMUwPrgc7SDK4+BIjSB21heGJQd5d1xoNht+CXnvee5VyMmTi6u7RUXPebOmdfSowb1Qf/M3hg1qA8lk4qDa+raH+w7ZEzBgHEjjWKBdM/8WddRMulvNxq8Ph9e/3Az0RmNO7XEdkN+/ijyZ+DvT8x1p4jI0TlEbzR17jx4/IrOFB6iRUp8tEjkpC6GB2tWPHzXbComojszlVatwqLbZtFD+mUNVIm0DffkrQn+JedWSiRvDb96gpbiicBYm8G6bWhpNaOouBX1zVacPlVrc7o81yzdaDj+e48Qj0vdkJKTHTDbO1tboVIKEREuR115BVi3BUaTE6dON2DKnff6/TxdC0KCZSAsi8tjniJRV8CtQ2eDVBWMyXPnIn1Qf6QkB2Pc2BSEhshx4UyXQRKwAgB4PAwACprQULi9/nVn/FVJ2Lt1K2xmM2i+BE1NJsSnpILDE8HlvlSuSlGIjlFzKcJO+r3HZ8lGa6fTx/QuL2txnDzTiJOnG9HYZALrtoKxtYDiiTDq2smxMolg1S8C+TOv5GjFkrpp40aq502fDJmkO1PPoOx06r65N3LlculXAlpWNDArjQrRqK/oGTZ8s5t0Goy1GmK79s/M+PxTi1ry8vJ8Rqet37GCEram8be7JAxLYDBb6JT42OgHb7sJYuGP04dRFDB17DBqylXD1EoRqb/3yRd7/9eYwt1h/RQq0VWRiUnwdpaC4kpA0TSCg2UQyyU4faKG2O2eh/+zWOP3EolEek+vrD4BU6em7AKiwiVISQrC2YP74LL7+ecyhoyAUu2fcAIOC5qmEBMpxb7PtnSVo1J+cJpMThQWNmPktdcCAGRyOSQi/1qS3EuL9poyNFRV+39zqbsMw7A4eKgaKf38sS2h1B/xV8iFSE5U4csP3gVLCVBS2o703KGITc1EU2NXflBcTBCllIoe+iPG6NEPOltcTvctRqMTkTFBiIpUgqI5oLgieDtLoQwOR2JCcPqrc1T/1W1b8PSLV2ll0jO3Xj+Jm5PW6yePC9MG4bF75tAapTyUZa9M+Z4pLkNpZa3PS3xj/+yilj+999rqJ5fUW222eZ988R0czl9fr2Kx2fDC2x8hMyUR86ZPBucX0B/n5mRQt0wbL1Qq5YX3PfPqsB87Zu2DMX1EIu72sWN6B7maj6G54gxainf7o9UE4As4EEv5hCXkDykvXHmLNJii6Yig0K7odl3pBURGyqHVSsGFG1s3H4VCE4yw6K7KKIXMD+gB/aPgs+vw7ScfgWF8oLh8OJ1efLuzFP3HjodK4w+Ei2VyiES8gB8+ODcWuz79CCa9HqzPCa+XwXc7yyDTRKDvyFH+a2i6jKHISAXgtWPDuk2QqoKh1gYjPi0dDU3mbsc4nN6svBng/xFjxVDcErfTTQgh8DEEjM+Hgr3b0HrxLFzNxzAkNz4iLCrouVdv097+o5bB82/eGaLW7rpvzg10QnTkz15PLBJiyR2zoTeZsXbDF7+pzV2n0YQv9xyCy+m8+a1lD//pPPT/kyaLb/zroY/dHt+Ojz7/9lf9rqaxBa++vwnXTxiJUYP6/qrfpibF455Z03gqmTR/wdMv3xIIwwDUvx9LzFMGaY9On39viFgZCuJzQ6uRwmh04OSZJrTonDDq7dB3WJuWbvhjOncyhDctOSszAAyP2wOv2wnxJe2bmRYMu9OHyIRecDkubVUSAgG/6xVmZoSguboam1e/BacT2PFdKUJjktBv5MjAMVK5DGJxF/6iIpTo3VuLTavegK65BV99UwKrnUFKvy46NokyOGApOJ1eRITLYTFbkTt5KgBAExoKg8kdOIbDoREeJucJ+aoxf8RYLf2486Lbw5yrqelEQ7MV3+2qQFSUCkFBEhCfGxxpKK67Z2Fc/6H9X3trfthnL8xSBIovHn3xzVeCVIp1i26bSWnVyl8ezOJwcPuMaxAdGYoVaz+G2/vL2ZkZlsW7m7+GyW7/6M28h7f8LzD3P2uyOHZI/88sPs4iiVjIjwz9efe5sKwSn+3Yj7tnTUNc5G/bPVPIpMhKSaLKKmunZgweHnZbZrm5eGTomdT+uZNGXns9ly+UgqI48Fn9boVaJUZrixk6nRVlpS0Wu8c9fESRp/OPGI9pQ7UfDJ4wKfT7rLO68jIQRysiwv3R7fNFLeCK1IhJToahowPRiYnwee3wGashEPi1enuHFTYXD9rIKOz+5hAAgt59ByIsJqbrQqwXxFYf+A0AtLVZ0Wn0oPDMBWRkhMHlYSFThyI02t+OmScQwqWrAJfLQW2dERIxH1arCzyBCBFx/pLM9oY6iHleSCT879cgymR2hm4/Zf34jxiv4RmCjXazc76+0yocNCgWalVXfgFfmwmOSI3IpFRBfO+kVGN7y82DE4iw38yXVkSFh92w4JbpEAl/WyJdUkwUZGIx3t/yNbJ6J0Ek+PnzfL33ECmvqW8lcs5Vp777jvlf4O1/1jY5Ly/PY7OYh3174CiMFut/PfbI2ULsyD+G+26dgdArDIaolXIsuWMm3Yfec09sSsbh6+5eoM0eOhxg3WCc+gBzy/fSv28U9B1Wl8vtu/eXlGD+prGYq1QyLEkOi+rqc159oRhREV1buQ0NJqQPGIDgiEjomv0LEcV6IZN2TbSWVgtCYxMw9rrpUAfJkZkRjuba7tRdYqmkm0YHgOYWM2bcfQ80WiWyMsKhVvDRUlfTFdiTSCEQii5F8O3QaCRISNCi9ExXhmZ8eg4aL/PTY6JVcDo9Q/NG/jGcB49+0Gm12HxzNUFiR2hw9y1v1tkOxmkAYTxQhUTh+nsfjJg6Z/byXs7Pc2eOzbnilNXs1CTMuX4SXv9wExrbOv7rsU1tOpwoLIXHw0xddf/97v8V3v6n/dFfz3vkvMPleu+jz779Sb/n6NkifL4rHxRN41hBCdyeK4th2M1t2P76JAwb2Qejpl0HIQ9wNx2Do2oHXA0H4TXVghaqwRFp/NE8CsjJCaeVcqH4jxoHvgfXJKan8XDZlmNrXR2CL01gxsfC4fAgtW9fqLRamPV6uF0ugPUFChw9HgbVNZ3IGToUAKAKkqFXr2A0VFaDYXxdAUqa7t6u2eODx8NAFRwMmcK/bZSWGorasnK4LstmpHk8MD4WRoMDQUES9O4dDJPeGMi4i+6VhMaWrloWHo8DrVbK44cph/xR4yaXcK/unRIivPRg4Ig1oIUqeA1VcDXkw1G1Ha6WEyA+J2JSMjBtzlQc+Oh2VJ799oquazBbcPxcMYQCAd74cAvMVtuPm+wMg48+204cDterb+UtPvO/xNr/FOgA0JAQdo/eYjYeOXP+R7+32u24avQwjB09FD4KWPXJZ2j6mVX0p6Ts8HvY+c4NGD1tCiJjo6CvOomCnZ+ivaEaFF8CflAKxPETIIoZCWH0cFBc/xyKiQniK5WiZz99OHbulhm/v7sjV8kWJuf0DbwLfVs7lEqhf58YQPlFHaRKOWgOBxRFoVd2JkpOnQRhuxa94gutCA6PgPxSNF4ml0Ak5EEqFeDi+aKfvHZpWRuCwv2m/fdAVyiE0GikKDhy+LIjuaio7EBcbBBomoJQwAOPS6O+0m8xCIRCcHhCuFxdi0p8nIYO0oh/1+j72rvAWz5bMWb1vWH/zs6KmBAcLKP9C5EEwqjhEMWMgjh+PHjqXqB4YrTVVOL8zvUw1p2BUMDH5Dmz0Vryb3z37l1w2U2/+vqni8vwyZe7EBoRhnFjhyM7I+Unk8C+2HOQ6E2WxiBi+Z+z1f7Pgb71hhsYh9UxbPfhU+g0/nDgw0O0sNnsoCgKEeFhGDyoHzbv2I/G1vZfHqnX1eKrVyfA3HoE19x6C4SkAy3nvsTZI8cgCeuN8P4zII4bD54mFaC5gXrz7xNlaJrCpKlDQ3KG9vlAljtAt/6x2A15eb/P2OXdFS5mvSQz8rJS0uoLJYiK6DIgLlbpEJ+W3hUck6tQdOwYWObSFprZiaKiFkyc3VUOrrgE2v59wnHk2+3w/MhktDs8uFjZiRHT/LwecnmXCTxqeAzOHz4MfXv7JavCjQul7d0KYiIjVSg4fDDwd1xaJpqaut5hXJwaLqdv7O/F2PrSDG0oTxq157rpI7fcctd1c7IHpAd8HdZjhbezFD57G8ARgq9Nhzh+AiL63wCRNhGnDhxE+/kvwVhqMHj8eGT1i8L2t67DhSMbf/H1j50rRkF5FYbk9oPiUi2C2+WCRqX4wbG1TS04W1xO3Iz3mj97K+0vCXQAeO1fiy84Xe6VH2zdDvY/bPiY8FAY9F1JTkIBH7mD+mLzt/vQ2vHf42KMz4Ojmxfj4Kd3Yfjk8cju2wvOun3wdJTAYLBg9LRp6JUzEJTbCMbaBK+xGs7avXA3HYfX4NdUDrsHdfVGcCTBSBw4iRpz092qPv2SbwzThz32ezw7z2qfHJeazKMu2yasLS1GVGTX5NF32tF3WNeuYEtdDSLCxDiy7zCsNjd27apA35GjAy2fLtfOMTFqqBQ8fPjiim6muMnoxNbPCtG7by4kUv+klSu7gC6RCNA7RYOvPvwANosVp09VIyKhF3S6LjM1PTUkwFUPAPFpGWi4zE8X8LlQqsSC5bPVv0tHFXEQ74Wrp+aOSBg8RS0M7QNaFISDB6vhvFTo4tGXw910DM76ffCaqsFYm0B7jUjuNxSjr50KXYcZno4iOOv2Qa3gYeqts+HW78WXr14LY/t/3/E6erYIxZW16JOd0S2rk6KobpztAODxevHvbTvgcLry1uQ9XPRXwNhfAugA8MoT9z1qtdubdh0+8YNIufM/9ts5HBouj4e8s+Fz6Aw/bn4ZWkrx+cqxCI0QYPz0a8G1lcLVfCxQux0TrYLXWAVnzXdwNR+Hq+UUPB2FYL1OeLwMfD4WhABtHTbU1Bvg1ZfB3e53L7TBKtrtYUf/Hs+tUMgXpPTp19XlxOWCz+MKbKvpOmygOZxAmioAtFTXoH+fMJha6/HlV0VIHZALn6d7daBc1pWmGR2tgMvpwNqnn8GWt9/F1m2F2PZlIQQCDiISE7t+I+8ehrBZ3egVJ8XmVW/A6uJj6ORr0drWFTgNCZHD6/XAZvG/A01oKEwWTzcO+cSEIFqrEj34e4wVRbEJfIEAAIG79TQ8+goog6Qoq+wAIYDPx8LjZcC6bfC0F8LVcgqu5mNw1uyEz1SLmBj/LpvN3AlX0xG4Wk8jvV8/jJ42FofW34nSYz+u3QtKL5JvDxwFzaEvD6PAx/ggEvwwVeDTr3cRk9V6Xk2sy/8q+PrLAB2giN3hGHTsTBHb3N498s2hqUCwzuX2YM+Bo8Rqs1/Uma3T1qzfRto6u6c1lx56D0c2LcCEm25AeLAAzrp98Flb0NjOwintB4ovAYdDg3VbQNiu3Q6WJWjpcKCt04UWnRNlVQaUlrUjISkEXi8Ln6kWzvp81FXVAaBtVx5th5BhmAFRCV39y+svViDy0pYaABSXtiEsumt7zGY2gy+kwedzkZWhgUgoJoPGjUdrfUM381x6mXauqdEjITUNdz7xODg8HoK1UsydMwDJvUJw4VRXur5U3rU4OB1edHbakJ0VDg7FkkHjr4FIIgFFcQPprqCAIJUEBYe7+C5DomPQoeuqUoyLDYLL7Zv8u0wRQlwH955G3ckv4TM3wucjUAVJ0dnpxNGTDWjpcPrfXYejm2VIWC9YjxUcDg1aIIcoejQKS00wtVbDWbcbPE87Jt18E2xN32Lfvx8EIV2ZqWdLysmmb/eyFrv36rr6Jueps0WBhcxksv5gF6j4YjXKq+q8bgqT/9ekpn9RoAOvPbm42Wx1PPD+5q+7Rde9DAuKAlpa2/HdnoPEaLbs7XB2Zq/JW/Jlp8U6bu2GL8j3PvvZHS9CV7MTE26cDujOwN12BnarDUdO6RCSMhxyvgnEYwchBDoDA444FBR9yde1usEwLDxuHyor2nDkYAWEIj4cdg+sTi8uVupw8sh5OBxu8Pm07Iqj7T7luJjkJB59melXXVyEqMgukDY2mZE5aFBX8LKyCuGh/ku3t1uhDI2kQFHo3bc/Tu7pInK8nNqovcOKviOGQyyTIy45ATExKnA4NKKjlGiv7yIZvTwaf+J0PVJTQ0BRFGRSHlrq/UQPEfGxaL0sup6crEVlYVdAOSEjBw2NXUQXIhEPcplA+MJMZc6VBuEEAp60T3YEnBYDysrbYLF5UFPdAYPBhuLCRhw/WomWJhMsVhc69X4Lh+LwQEtCcbHGDLPFCdZtgYDtxICrb0bhBRNqqtvgbi+Aq+kosobkIjKSxe73/Gw+h08Xks++28+6nK6rVuc9sINva5c3Njc379iVD5vdDoGA182iNFlt2PT1Hjgdjtv+6LLTvzXQAWBV3uK3bC7n0XWbvgLDsmjvNMLucOLAoRM4fvo8Y7OZ73zlsfvGfc/3vmrZor36TsOIdzd/xZzYtx6GxiMYPHYEnA0HwTg70dpmwalCPUZOvwUiXw28hioYjW4cL7BCnTIWwqhc8LV+bsGGRjOKi5qwd/cF0NI0XHXry9CkzcGpk02oqzeA4vLQr180MjPCER+rzn5htrz/FUXb5dL5KX37cy7TWGhvbAz0W/d4GLjdPiRldbX1aai6iLAQ/552a6uFxKelXdLgStSXl6K2rOzSBPcvXpVVnaA5nIBVIBAKAskyGo0EYFk01dZe0nx+6+ZipQ56gwdyuT/wFhWloJprKggAxPTOQktrF9B7JQXDaraBZfzKKzopCc0t3fMiEhM0HGWQ+P4rGSuLW31zTnZEb5lMgKhoFUQyCU6faYDBJsT0x/fjwbXV6D/hXhQVNqC6sgNGsx/o/JAciCJzkXXVHFQ3Uygt64BHXw5GX4hxN98Jo42H02cawNg74G48jLjkZGg0bmx8dyn5dv8Rr9nqHvXmUw8dAPy1Gi88dG9kp8m0ctfeQ6iuacTFusaAX776k23EardvWfXMo5/+1XD1lwM6AEic+pGtus6q5W9/hDc+3kzsDhda29u/dLhcEW8se/j9HywOzz5y2GzuzK7Y/xoZOmkcnI2HQbwONDaaUFFtw4Rb7gQ6z4KxtqCmwYYLdSxGz7gZcpUKjL0Dns4SOJw+KJVieDwsRs98EtMWf4acMfMwcvrjuCVvP0qKdf4GCla/pREVqVTz+PyhV6KhfF52RHRSl4/c3twMTZA4EOwpLWuDQq3sFvxpqalGWKi/yETXaaN6ZfsXKaOuA9ERYhQd2oHCI4dA0QKwLMGJE7WBvXUAEIpEEPC7clgyM0Nx6Mtt/v1wxoOCgibUNvsQn54D8yXqpsQEDdrqmvwaPSEBrW1dXguPx4FAwEVViZ/9iMfngy+SwmHvssgS4jXweHxXRNnN4/ESxWK+EgDMVg9amk2wOni49Znj0IT3gkiqRp+rl2L20s9htbhAQMHh9MHTfh6MsxM0l4Nh184CPygJBw7VwmWoh6flFIZdNwciuRrHjteC9VjhbDqMjIED4ardBa+xccCaZxcf/sF8W7b4kTa+L7i8sqZKbzBh5bvryfK3P0KHQX8yCLbZf0VM/SWBnpeX53thyfxeOqN5tsXpWGx3OHq/uvTBaW888eBP7qmFVb4oik6IZBndeRCvA+3tVlTWWjDx1rvh6ywG4+jEybPtsPiCMP7GWeBwufCaauBqPgqr1QGdwYnzBc3oc/WTGDB5McrLywPnVoclYvxtb+HcuWboDU4/2UKn0+XxeBt/6zN22uSjoxPjeFxuV5ZWdUkJoiK7AmJV1QYkZmR198/5NHg8Dmw2NzgcmggEfu2ub6mHWiXG2BFxKD5+CPl7TmLnrnJ4WQpDJ13dFQm/TKMDQEKCFm67Gds//hC7d5xEfbMb0+6cD21ERGBREwi4ICCwW60QicWgKA7c7q798phoFYqOduEhPj0HDZdts4nEPEgkfNHzs9Wpv3W83C7f6dp6k6+2zoCi4lZU15gw84k94HC7B8MiUkbg2kVbcP5sE5parLBa7XA1HIHP4u/imzVsDNKHjMO335XD2tkIT0cRBkyeDZFUgQulbSAeG9zt5xGbEOlTN675yfzWD++/X/fyYwuT3E5HVl2DblGn2TrzzWWLc/Py8nx/RUxx8ZcVirz1L2z4xYeznESlRsvx2XXwehmcLWjB1LvvB2Opg89Uj0PHmhGalI2cYcMAEHh1JXAbLsJk8cBi86DwfCv6XL0MmSNvBQBs2LAB5eXlWLVqFUJCQpA8YAqcNgMOffYsfG4XGJYIHRlPvHt/Htf2Zt7iX001LJfJ70np07/b+NeVXcD40VGXrHgCg9GO64cP7e6fh/m1eVu7BVJlUEDVGzt0SI0JASiAy6GIUKal+mUPwP4vv+x2XYFIBD7DucyXp8ESoHcsF+VVBGK5jFA0Tam1WhSauzI2JWIuWuvqkZiRjoj4OLS2WhAb6w9EZWSE48uvuvgME9PTsX/TCaQkB1+2oGi4Xk/bfAD3/dqxujfv5aEOufDD6vp1XL3FB01kf9xy2zLI1OGorKyEQqFAcHDXtcISc3Ht4q348rUZIH2jEKwhUOIs+F4n+EHJiE3NAE8kwa7PNmDSBBpSvhxDrr0FX727CvGxXog5ekjkMi4X9M+Swq15/okiAJe20B76y6KJxj9ICOPvF15Xb0TWkOHgwg1PRzGKyzuhCE+8BHLAo7sAt74CnUYXLFYPCguakTXhkQDInU4nNm/eDC6XiyeffBKnT/tzurNHz8X9b1fjvjVVWPhmMe685RZlWIh6xyMvrrq44JlX037pfW6ZAQ7DMuNiUlK6otx2Oyj4IBT6sd/cYgaPz4dUJr8M6OUIDxV9H4gjEQldHT9MBhNkcr8CYhggISMDcb1T4XW5u0XjxRIxeLwuoJvMTohEPISGShEbqYLnUmWcKlgLi6mLIkoTJKSaa6sIAMSmZaG5pWu/XKUUgWVZmHT+vAZFUBCsNh8ur99OiNOAYTDr1wH81cRlr66tTIgKP3zX7BuVC18vxM3PnsKEuz+AMtifYPTuu++iT58+OHr0aLffhsYPxJT7NuDc6Xro9A50Gpxwd1yAR++31CLi4tH/qkk4eboJHl0RCONG2sBc1DdeoutiWMLSIP8UbPyDgM563A4rQwtUsFndkAVpAtTM1TVmDB433r/3aWmA13ARBpMbTieDkpIWJA+7G1mj7gicadmyZXA6nVizZg3uvfde3HGH/zufz3fJDxVBJAtCdHgoHrvnVurmqROSwtTK4odfeuvY4ldWR/3cnVYLlMPCYmN4vMuKK2rLyhEV0QXqC6UdiEro3qyvuaYGoSH+Y1paLOid08d/X14vaKqL3ZUhIEKxP5AWGhONg19/0aWZL6NBYlmCw4drERGmCJjoPq8r4GuzxJ9nDwCJiVo0XSKoiIxP7OanA3766XOH8gN/RyYmoa29K2gnkwnAE3Dkz98o6/Vz4/P4888H/evVd45HhQRdvPnaCYmLb7sJ4cGay+6bhd3u38KbM2cOtFotRo8ejTfeeKPbecJ7DcWEu9fh3Jl6WG0eGC1ueDtLwVyqTuyV3QcGsxdgWXgNF0FxePD5CGiBEjaznqEYYusB+l8N5qArGyov2mlJMCQSPjpbmkBxhbDZ3JCrVaBoGsTrgKe9EA4XA7uLQXW1DuFp0zBw8pLAeY4fP47XX38dixcvhkwmw4oVKyAW+/3mBx54ACtXroTL1T2BJyM5EUvvnUfNnDh2sEogqn/4hVUn7nvppYSfDDZKRXek9unbrYSq+kIhoi/bVmtpMSNrcFc9iMVohFDoJ2xkfCycbi+ljQi/FIjrhELR5U4yPpYSivyaP7pXLzRVlePMgf2XPCIq4BrkH6oGJVRArRZ3Ad3XVWet0gTBbPE/a0iwFFaTGQzjg0AkBM3lweXqOja1dwiqL3SZ73FpmWho6N6VKilew5Wrxbf91Lg8/NLq0MdXrskXy0N1k8cMH/To3XOoXv/RfriwsBCjRo1CQ4Pf505PT8fEiRPx+eef46mnnsK0adNgNl/GdpM5CSNuXI6Ccw2wObxwuBi42wvA+vzPJZEr4HR5QXEEaG+oh1olAhFqUFVW6SY+prgH6H8xWbrRWNzc0FF6Kv+0MyJSgaqSC+DKo+FjWPAvZS+5O4rh83lgtLjQ3moGESZj1KwXu8xnpxPz5s3DbbfdBplMhgkTJkAoFOLjj/0l1R0dHdi4cSO+/PJLFBYWwnsZ+QBFAX3Sk/HEvXOp6yeMGqASqCoffXF1wd15L3cLQBGAIiw1JS61y9InLAt9ayuC1H5t63B44POxiE3pakxTX1mJ8DDZ99F2iMWSgFlp1HVAeVkOOuNjIbgEdJ/Hi8y0EFQWnMDR73YEQH7gYDXEmljEp6bD62MCQGeZrgQidUgwTKaujDuRiA9di5++PiohAa1tXRo7NlYNu80ZWCiiExPR0t5dIcbFB4ECPe8/390DK96Ifur1taeVUknL9RNGjnji3rlU/8ze3bLQrFYrjh49Cp1OB4VCgd69u1jBwsPDERYWhgkTJqCxsRGDBw9GQUFBAPC9h85BYr/rUVneDqPFBcbnhrfT37n6Ut0QaGk46iqr4WNYbP1gm4dlvK8s3WrT9QD9rxa6A4iVdIw6c7Lwta2fFTQ01jZ52tttkMhVcF0y81h7G+wOH5wOH+qbPJi84N+B3xcUFODhhx+G3W7HypUrMW/ePFy4cAHr1q1DUlISjh8/ji+++AIffPABZs6ciRMnTiA1NRVbtnQnDKEoCgOz06i8+26nZl5zVXZcaHDJ4yvX1D/wr1euB4Dls9UDgyPCBPzLCAta6ur9JamXJl1xSRtUwd17IDReLENYiF/ztnVYiCo8OgCDzrYWKC/rpUYAcC7to3vdLgj4HFw9vhcaygpx5tAxHD5aC2lwAsZcfwP4AiF8PhIAOtMN6BEwmbusF6mUQzXX+PfcY3pnofmyxBkOh4ZUwkfZWX+TCw6XC4lcCau1K6CnVIhA01CvmKOKBoAFz708/Kk336sMU6rqp08c0+/xe26l+qan/IAheP369UhOTkZLSwvGjh2L/v27py/ceOONWLhwId5++20cOXIE6enpGDhwIDZt2hQ4ZvhNK+FipLDZvLA5fGBsbf7F3eGERBmMwjMlMHYaHceO1+03mSwD5r/VlPdPil/9o4JxeR/B9cjHxifMls4kj5e9ft+WDU5BUFwA6ODwIZXwQIFAGj8CPEGXqexwOLBz504sX74cCoUC7777LsxmMwghIIRgyZIluOmmm5CdnQ0A+Prrr6FUKhEZGYmDBw9i48aN3UBCURSyeyfh0btvoebPnhadkBC19fGX3nbao294NzFnYLc9oZrSYsREdPnONXVGJGf3+Q//vC6wf97SbEFiWpdFYGhthEIp6nbt78XjdoHL44DDpTFubDxOHzoGvYnFyGuvC/jivkvJLlwuDcJ0xZ9UwVqYLd7LttGUaKquJAAQER+Ptv/Q2PHxQSg+ceSybbY+aGgwdjsmISGY64yY/u6zb71v6RUZdfCmq8cmPnr3LUjvldBNgxNCsG3bNnz88cfIzs7G0KFD8corr4BhGDgcjm7n1Gq1GDBgAFQqFYRCIbKzs3Hw4EHcfffdXePg9cFOBxMOWEjFPFAcPtwuFzg0gc4iwNkDB1wWK0Lmr24Z89AHHYX4hwmNf6DkbYVn6afG7fpO/WsfvbXe4rDb2NrycuidMjQ22VBdZwPHVMCuXvcWMZj9WmnIkCEoLCxEY2Mjbr75ZixZsgSrVq2CUCjEtm3bcO7cOQwfPhxr1qzBV199hR07duC1115Dbm4usrOzccstt2DKlClobGz8Qa+5qLAQ3DdnBrXkrtnCPsNmpO+o64N133lQ2ewP7tVXVCAiQhEIkFksDmQPHYwu01wHsYQfSFHt1DuopIyMy77XQ3VJo7Msi8tTan1uJ3hc/99CAQ9BQWJkDhkeWAx4fD68vi5wUzQFcun+g4KDYbJ0me6JCRq0X2Lv5Qv44PL53fz09LQw6Fs7AidLSEsNkEa22SXYWpGLk7z7kD3q5nEPzJ0pu//WG5AcH/PDeAvL4t5778XMmTMRFBSE9PR0rFq1CuXl5XjppZewYsUKXHPNNait7ao4S0tLw6JFi1BdXY2lS5di8OCu8SutqsObLz1A0hJFTHObFydPN6HTLsH5I0fR2tzO7vz8u06f0zE8b6vOhn+ocPEPlkc+Nj6x4mblFpfdfdfhr7+4deYDiyWUOBwTckPA5wvoQ998xWx8t5RKzp1HjxncDxKJBE888QScTifWrVsHsVgMj8eDxx9/HAsXLsSdd94Jp9OJ3r1747rrrsPQSxlnq1evRmxsLL7++mt0dnZi1KhRuOuuuzB7dvckKbVCjukTR4MlBGVVddh95CS2HDKBIxkHi68FQTwn6uoNEIpEEF5GaNNYVYWIML/1YbG4wOdxCY/PD+g/h80eoIey2bwQXMaH5nW7cXl0n8/jgMfv+p7L58H3HykeLpcLIrEYMpUKVmuX6c7jcUDT/sQdqUKBmIQktLQYER/vr6yTSPigaFAdzc0IjogA4ctRzb8KqwuzIJepMHJ4H6QlxYP+GeZemqaxZs0acLlc5OXlYdKkSQgJCUFeXh4effRRrFu3Dnv37kVaWhoeeughzJ8/HwKBAAkJCUi4rEDI4XJh/ZbPWGfZR2TyqBSSmDUpMN9b6+pQeOxDu9PtGb74fd05/MOF+09/wEt90RasmEM3f/zSikcnzrpJLhJLYDeboVIrKNfpbZ7DJm7NmaKy3nOnT6ZCNWqILgWy2trasGTJEjQ3N+Pxxx8HABw8eBAtLS3Ys2dPABSrVq3Cs88+Cw6Hg5CQEFitVrz99tuYPXs2CgoKIJPJkHhZOShNUUhLikNaUhzsTidOnb+AbcVl8HntYDvPIzqxezOKhovlSIrym/btbVZIVOoAyG1msx/klz6xWJ0QisUElz7xeNzg8n6awJDPFwRMdz+YadgtlksZcBTEUikcDi/EYv9iIRFx0FJfh16ZWYhKzULZ4a8CQAcAVXgUNu/TwyeLAM0RYdTke9A3PQVCwa9nfn7iiSeQkJCAb775BlOmTMHChQvxwQcf4NSpU9i8eTN27tyJ6667DgcOHMCmTZsQGdlF3Xy2pJx8tfcwHB2FB+MtlX1OHWiTm0xWhEZFofL8OVwsLDI53Z5RT6w3n8f/A+Hi/4k89rH++eWzfSc/f+/9N0HRURSB3uP1bgCNtc8sX9Vw/9OvTn3r4y0bM5MTRVOvGgEBn4fQ0FC89957yMnJQUdHB3g8Hh5//HHcc889SEryJ6u899574HA4mDPHz+5SVFSEiIgInD3r74ASHR2N2NhYvPDCCzAajZg5c2bgt37giDBqcD+MGtwPdqcT5y8MxvHzJXhuow0aGUFmPEFTXSOG9fMH71vbLSQqMT0A9I7WVqgv67Bqt3kgvKzjiM/tAY/706+ZK+DB5+0CulDIg9lohOZSa2RtWBg69TZEi1WX/GER1VxTRXplZlERcbE4uM2J4o5gFBuTYXCrIY6Tom96CnJSe0H+E62LGIbBnj17MGDAAKjVP032GRoaigULFuDJJ5/E5MmTweVysXr1aowaNQrXXHMNcnNzsXbtWtx8880BV6RDb8QnX37Htuk6DYzbc9NrL6zeCwAvz9EOZZmjCy+coDIJ496pJ+TJvI90jv8v859CjwRkxpYtnNjK1rekMsndY4f0pwbndLGJuN1u3HXXXVi/fj2ampoQFhYGr9eLXr164f7778eiRYsAAGvXroVCocCsWbPgcDjQ0tKCTz/9FMuWLcO8efOwc+dOtLa2wmazweVyQaP58Q7DHq8XlXWNKCyrQn1zK3xeB+RcPaz1BeS6awdQSfH+Xmcn9+4CMVchI92frXmuoAk+Xjg76vrpNABsfH0lJoyJDbRb2rXnInrnjkfvPv6qUYOuA4e3fYqxo/y+8t69FSQ2ZxSVlesvjT2dfwCejgvIzvLv2Te2s9hRICaKlLGUyc4FAQ+xEWHol9kb8dERP9tQY8eOHVi0aBFSU1PxxRdf/Ow70ev1iI+Px7p163DjjTeCEII+ffqgX79+eOmll6BS+Rcgp8uNL3bnsyVVtcRitS/3hsmeW3f33d6eWf3/TKP/Etl6ww0MgPn3vrT66e0Hjn938OT5rBsnj6HioyIgEAjw73//G4sWLUJdXR0EAgG2bt0Kq9WKu+66CwBgMpmgUCiQkJAAQgjq6+vx2WefYeHChf6gmdGItrY2NDc3Q6FQYNKkSUhNTcXIkSORkpKC/v37B2iJ+Dwe0pLikZbkz45ze7yoaWzGhYu51LclLXCfdYPHJfCYeyFEpIG3zY1ohQUOuxeKSElgAfd6vN3qzH/MdPde5qQLRFzYLGaY7Cxq2xhcdPRCqyMSZ0qj4WYEEIlESB0TSaUkxCI6PAQC/n83yb1eL6ZMmYKNGzdCqVRi0qRJaG1txbJly+Dz+cDl/vcpGBQUhEWLFmHZsmUQiUSBgOigSzX6LCE4eLKA7D9xBmazbTeHR9+2Om9Ja89s7tHov1gW5r0wUiFTbQ7RqLXTJ46mwrRdvmh+fj4effRRhIWF4ctLhSNvv/02br31Vni9XqhUKnz99dc4deoUnn32WTQ0NODLL7/EQw89hM8++wxTp07F3LlzsWbNGuTn52PSpElYunQp3G43EhMTMW/ePAh+pjmA0+VGS4cO9c1taGrtQKfRBLfHC5b1AWDB59Hw2M1QyShwKS/AutDRZoA8KAQSpQoEPHh9BEaDBTyBCB4fBVA8cLg8CAUChGjViAzRIlQbhBCN+idN8UD032hEe3s7qqurcfXV/oo5j8cDgUCAO++8E+vWrfO7F3Y7wsLCsH79ekyZMuVn38PmzZvx8ssvIy8vL3BeQoCC0gqyff8RmCy2Co+b3Lb62UXHe2Ztj/x2wD/90ox/vbHO9Pb6bWxrRye5XPbs2UMcDgd59913yfXXXx/4XKPRkFGjRpFz584RQgh57bXXSGdnJ8nKyiLLli0jVquVPPvss4Hv4uPjCSGEmEwmEh8fT8rKysigQYPIddddR/Lz80lZWRkxm83klwrLssRstRGdwUSa23WkoaWNVNTUk/LqusB/FTX1pKGljbR36onFZicMw5BfI+3t7YF/v/DCC+Spp54iS5cuJTExMYHPfT4fmTx5MhEKhWTPnj2Bz2+//XYyZcqUwN/btm0jLMv+6HWampoC37EsIWcvlJPlqz9kl6xYVX/fs6+O65mhPab77yJvPfXIVgBb73vmpTntGwyrlQqZZMbE0VREiBZjx44FAGRlZaG4uBhGoxEqlQoJCQlwuVzIyckJ+JpBQUHo378/zp49i2+++QbXXHMNAGD37t0YP348rFYrbDYbbrrpJqSkpEAqlSI2NhYjRozAqlWrsHLlSrzxxhuYNm0aAODjjz/GrFmzftT8pSjqZzXwLxWdTgepVAqRSIQ1a9agrq4O58+fB5fLxbfffouTJ08iPz8fO3f6q3Xlcjna2toQGhoKDoeDhIQEZGZm4q677kJxcTEkEgluv/12DB8+HK2trQgLC0NJSQmCg4MDW5aXS0REBACgrKqOfLH7IEwWa4fT57vnrWWLvuyZnT3yBwmhFjz7yvzHX37b/Or7G9mKmoYf1UKzZ88m69evJ4QQcuTIEbJq1SpCCCFr164lISEh5JFHHiGEEOJ0OolYLCbXXnstGTt2LKmvrycej4ewLEuUSiXZtm0bKSkpIQsXLiQmkylw/oKCAgKA1NXV/aTGPXToEFm2bBlZsWIFee2118jatWvJN998Qw4fPky2bNlC1q5dSxwOB/n444/JihUryP79+8kDDzxAZs6cSUwmE/F6veTmm28mmZmZpL29nXz++ecBq8Vut5MJEyYQQgh56qmnyB133PGT9zF//nyyfft2olarA89NCCGpqankhRdeICzLkkmTJpF77733B7/1eL3k0OkC9tlVH7BLnn+jceHTr9wIkB6Xs0f+PFnw9MtXPfX6usrnVn/I7j16mrg9nsAEbW5uJi6Xixw9epTExcWRt99+mxBCyLlz5wgA8vTTTwdMf6FQSPR6PZk4cWLg9xUVFQQAWb9+Pbnnnnt+YFYvXryYJCUlkfz8/J8E2NNPP03y8vLIc889R8aPH0+++eYbMmjQIHLx4kWi1WrJK6+8QhiGIe3t7WTw4MHE4/GQsrIyAoDMnDkz4AI888wzhBBCJk6cSN54443A+WtrawkhhDzyyCOBezeZTOSLL74gixcvJhUVFYQQQq655hpSX19PTp8+Tfh8Pjlz5kxggYiKiiK33XYbefXVV4lOpwuc22y1ka3f7WOefG0du+jZ14ruzXtpQs+M6zHd/yey+qklewAkLXj+rV67Dp985+CpgpGpCbEYN2wgFR7u347Kzc3FhQsXUFBQAMBfVikSiXD99dcHzPYhQ4ZArVbj2WefxYULF5CWlobTp09DKBTigw8+gEgk6pZNVlNTE9if/75c88fE5/Nh8eLFePXVVyGXyzF58mRs374dSUlJCAsLQ2hoKGiaRnBwMCZPngwej4eUlBRMmzYNW7Zswfjx4zF37lxEXWr+WF9f342zPTIyEhcvXkRMTAw++ugjMAwDi8WCo0eP4sMPP8TLL78MAIiPj0d0dDSio6MxYsQITJw4EW+88UaA4OP7dFVCgIu1jdh16DjTbjDBZLFu4oHz5Ot5i+p6ZluP/GXkrhUrFPc+88rKJ19Za3lp3SfsoVMFxO5w/kDTfvjhh4H/h4aGkuXLlxNCCNHpdAFNev/995MZM2aQAwcOEJFIRGw2W+D3999/P6msrCRz584NaNsfE7fbTQghZMmSJWTOnDmBaxBCSP/+/cn7778fOPaVV14J/HvVqlXk0UcfJRKJhJSXl5P33nuPEELIgAEDyJIlSwghhGzdupVERkaScePGkebmZsLlcsnu3bsJIYR0dHQQiqLIhQsXiN1uJ/369SM1NTWkoaGBrFq1KmAJfC+tOj3ZumMfm/fGe+xDy99sWfjMy4/cl/emvGdG9Wj0v6Sse+wxM4CHATz8YN5L2d+2Vn60/1hElkQixtC+2eiTngw+j4e5c+cCAG644QaEhYXh8OHDuOeee/DFF1/ggQceAOAnwLjmmmswZMgQ8Hg87Nu3D1OmTEFHRwdcLhc2b96MgoKC/7oPzb+0x+10OgNpvd8n6AiFwm4EGpdXvNE0jeeeew4HDx7E7NmzA/c7YsQIHDzo77U2ffp0nD59GlVVVQgPD8fDDz+MJUuW4MiRI9BoNIiMjERjYyNaW1sxZcoU+Hw+xMXFBXIKzFYbThZeQGFZJWxWCyz6xiNEpLrzjWWPVvTMpB6g/23k9bxHzr81P1J93bQFaLWxyD99ADvyjyFYo0T/zDSkJsZBJhFj/PjxGD/eT3OVl5cHHo+HdevWQSaToa6uDkajEaGhodi2bRumTJmC5cuXY+nSpYiJiYHH48Hx4z+/dex0OiGXd1eQQqEQzst6sV1ecUdRFLhcLtavX4+cnBy8/vrrWLhwIW677TasXr0aJ0+exMCBA5GcnIzt27cDAJ577jmEh4djwYIFiI2Nxccff4yRI0cCAMaMGQMAaOnoRFFZJYrKK2G1O6DlNWF0dD340jocrKiMvm9dew/Ie4D+95IVNyuzZEpViCY4GJpgICOeD4YFPvpgI06a0rHrYCQIOIiPjsCAzFQkxEQi9FJ++V133RXItmtra8Njjz2Gc+fOYdWqVfjkk09w++23w+FwwGq1oqysDISQH5A1XC4OhyNw7u8lKioKjY1dbNU2W1eFZmlpKQghSEhIwOrVqzFnzhw4nU6kpKRg48aNWLhwIW644QbU1tbiiSeeCFgB32vr78XudKKipgEFFyrQ0tEJinih4OoRajqAO4YIEeBeVCoAGhHLb1b0eWK9+VzP7OkB+t9GJBLJ8/1Hj+mWH2oz6qF0lWLCMC+AAnQ6xNiQzyO1Nf0oliOFXCpGSnwcesVHIzo8BHyev7Bm3rx5mDfPz8C0cOFCeDweNDQ0QK1WY8yYMdi6dStuuOGGH72Ps2fPoqSkBF6vFwaDIVBEMnv2bNxwww0YOHAgLBZL4POqqip89dVX4PF4ePXVV3HLLbegpKQEdrsdIpEIU6ZMwZQpU+DxeAKuwfdisdlR09iM0spa1DW1wuF2AfYWyLw15I7ZIymNggeQEGx4vRleT3RXIwkKyEwP554vbHkGME/umT2/v/TsR/4B8uJMTbhUK626Y+mToss17c71HyApioPQS73TCCF4/4OT5J5nnqF4fCEadF6cr/biYr0HLlYILleAIJUM8VERSIiJQkSIFlKx6FfdS1VVFdrb2+F0OpGQkIC4y/qwnz59GocPH0ZycnIgtdRut4Om6YBP/2PCEgKDyYym1g7UNDajoaUNFpsDDOMF19OMtFATUjU6BEvtcDk82LDpHHngxRcDA1F2rgAdFUfRr0944JxeL4NPPj3jdbmcUU9stLf3zKIejf6XF4GM/0T/ESOFl4Pc0NEGp7kTof276tILi1ogUyohEPqJHWNDeIgN4WHr+Q+Q21cFSqREjUGB/TtZlMcPgNPDA0No8Hk8SMUihAUHQatWQa2UQy6VQimXQiIWdasgS0xM7FYLf7n079//B/xrEokEHq8XnUYzzFYbzFYb9EYz2vUG6PQGOFxueLw+cOGCiNLB1FiFadcNR2wIFx6rAQc2b8DoQV3EjWIxDwIhh1QWFwdYcVJyslF49CCcLi9EQn+dO4/HQe/kEF5VjeExwL6oZxb1AP0vLS/MUqg4HHpu2sBB3ayl/M82YWC/iG7HFpe0sbkTJ3crLXPYrLCajFAqwwG4EYJKpAqsmD51uN/8N1vx2fsfIWNQNpraZKioE8HJSOEmMjh8PIDig1AUODQNDs3x88AR4v+bQ8PHMKAoCjRFg2VZ+FgCEAKGYcCwLBiWBQUWFOuFWMSBkO+DUgJo5BxkZnBw4vN3MXW0JtDW6fOGMmg4vSCXRAPiEFisHrhcXgiFXaw2ab1D6CM7trNJGRn098G+wROuxukjOzE8t2tMMjPDUX6x4568Gdpl/2Rapx6g/wOELxAszR46VHQ5fVPZyUPQqGgoLyNwbG+3wuNlkT5gYHef+tAhpKZoA3/X1RqQ0n9E4O+LheeRkchDSpAOKUHd2Yg3bi1hr797Pq3SauF0E3zx4VqkJsoRpJHBw3DAEgpHT7UiNr0/ElN7gUMDfC6Fxooy1JzdjVHD48HnMGhvt+Lg4Rp23hNP00D3Cjp331TU1JShd+8QvxUSrUB1SSHCY6IBikLm4FxcKK1A3z5dbC/ZWZE4d/4krCYjZEp//XhMUhLKzp5FW7sdoSGSS9YEH4kJakFltf4hAE/3zKbfT+ieIfj9JG+GXM3h8ebnDBsR0OYmXRuKjx9BTnZ3bZ5/qIpN79+Xojldr8ButqDi7Bmk9PKXw7IsQU29AcnZXY0Wq4rOIDHhh2QVZrMLLEMolda/SIgEFGy6FkQFE6hFToRKbQiXWaEgLQiTuxCp4SBMzUGQnEZEhBoOixV8jp/FNjhYCq/HR5n1+h9cp3e/QahrvKw/ei8NSs+cDRBKZg4ZgcpqPZzOLs4HmqaQEK+hdm3c0I01c+TUqThdaITH08Wem5MdRVEEj+bdFS7umVE9QP9LilQmXNp32FDR9w0jPG4XDny2HqOGx4Omuyz52jo97A7GN3j8xK4PCcF3Gz/FwAERgd5oNbWdCI2ICpA7GnQdkIrwo0QSp07Vk8iEuEB+qsftAWG8EAp4/3HkD+OvqmANzBZ3IL2VoiioVWL2+O7dP4w/iIQQy4ICfO0SMR9yuRDVF0r83wuFGH7NNBw6XNPtd4MGxFCtjY3e9uauLT2hSIQx18/AsbN6sJeuLZUKkJCgEcoZ7+KeGdUD9L+kNudyufOzhw2nAYDxeZG/6T30zw6FWNK1DWU0OHDyZJ1ZqVawIklXGWnBkcMQcV2Iv9ShlGFYnDnTSIZMndZl1u/bhdSUoB9c22p1Q6d3uhPSMwLvs6WuDiGhyh8cS1gfcdq7U6VxuTyogpQwGLo+j45RcerKSrymzs4fnCNrxGgUl3a5Df1yQpD/9ddgGD9TTVJWNsTqMJRXdASOEYl4kEj47Hfr11vsFmvgc214GDKGjsW5C45AR8OcnEiKAh5/dUakqGdm9QD9r6XN5aIns4fkigRCITxuBwp2bUKfTC1U6i4LtLPTjj37LzqsTt8byTk5Aee3obISFWePY+jgrv6M5wubCc0VsJrgkIBZbze2QauRdrsu42NxIL/S42OJNyqxi3SyuaYaUeE/rEf3MSwxd3Yw//l5XO80tLR2meSRkQpwubTpm48+ZLweT7djI+LiYXNxAuZ5eJgCNBjm1N79gWPG3jgbdU0utLV1gTohTi00GgzPfPHeOofVZOpaVBITkT50HCobKRBCIJMKEBurFlFK94M9M6sH6H8ZefkmmYZL0/f0HT6KYj1WuOoPoXeiBKJLFMksS3ChtA35+ZU6nc6ZIpNK5iTn9KMAf1/zU7u/xoSx8QGTvKHBiAul7bbe/QcG3s/Rb7eib3b3dt2EEOzdf5Gx2NzLJDK5QCztWgSqS4oQH/dD7W+3eTzNNbWe//w8bcAg1NZ1gU8hF4GAyF0285vffPQBS/6jKcXAcZNRUNx5GYgV9LnDh5zVJSUBK2HKnQtQUm4KmPmJCVpKJRfO0rfqB372ztsdNaWlgd8HhYQgZ8y1oLX9AVDokxNJgcGyHq3eA/S/jogk/8rKzRXSria46veDQ/wmsMfDoLyiHdu+KHJVVOo+bm5rjuSA1QSFhIQr1GrYzCYc274FY4ZHB/zylhYz9h+otHO4fHdqX/9i0FxTAR5rDXQ9/R7k+YeqWYvV/YqPgTZj4MCAM65raUF4iCjA/Pq9dOisoLn0abfDXvOfJrlcrYZcEwybratXWq9EDd/t9VTp29u+2rlxA7kc7OGxMeCIg6E3+AtjUpJDKKGAbvlu40Z3/cWLAAAej4eJc+ejuNwCh90DpVIEqVTY2035jCaLOfHI9u1fbXrzTWf1hVJ/c0eKgjgoGqL48VAGaREbpxZSCs+Sngl25cLpGYIrk5W3SINB0Z9mpAZxdXUVaGkxoaa2k5w4VceUlrWbdXrbmpYWz6TF77duyS8Fc/3I4D1jp88MA1iUHf0WfTOUfk1OgNKyNhw+WmuwO90LohLib8weMpTjcdlxcvtGDOwfFQjoeb0M9u67yJiNzpfvWNX0+Kl+8q1jpk8Xft+B5fj2z5GTqQSX2/31HjxU42tvN91gd7HHnBb9jb2ycrot9KHRsSg6dQ4RYX6TXyzhU3W1xkxdcHOur5nJbKi8mByXmkZxLwUHIxOTcPpYIcJDBRAKuGhpMYl1nbYZtaUlU2iaww+LiQGXy0V8eh9Ul9dAxPNArRbzdO3WnAfWtr/79XH9pv5xjnd0Tc3KomNH46uKizg2i4W2WhyUlxcMpVJOVZZWDcodoHwt/6y1h7q5B+j/OxmdJhqoVImj21sN5S1t5pPNTeZPa+uNL5gczINL3u945psT1t35pQ4PALw8T3NTVHz8ndmD+9O2+qMIC/JHuDt0VuzZV+mtrzccMHo9QzVy5bqR114XIZOLUXFwM1KTNQHQtrZZsGffRafD4b317reaXxfMUk2K65U0J33gIBoAOhqqIfTVQ6XsvjtVeVGH+gbDVw++1/naviJH5fBeGKfUaKPVwcGBYwQiMVhCgXUaIBDQEAp5qK0ziBz19LaH3m9/a0QymJKTJ4eptKEclVYDDoeDiPgkNNbroRB5IJPzuboOm8Jpt47RtbYNLz1zNkwRpKFVWg1C4lJAOAJIOWY0N5sjcxPoQ7vOO+r3FXqc208Ytn9zwvBi3xjbmoaLtfv1zQ3ljdUVbc0NLc08Hr/JYzIW7yt2t/TMtt8uPbnuf5K8cLM8UaFSF910xywRZSmF3W5HfZ0RZRUdbofdU2u3uu98bKPxyPOz1amhkaEFsxbezXfWHwAYvyJra7OisKjZZ7O5z7brXdOeWN/ZCgBvzY8sv3rOvOSIuFh43A60F3wNtap7sUlTswmHj9S22K1Mr4c/abcDwPMzpFpFsLp00uxbNRHxsd2Ob6sphcRdAZomqKs34MSphv3z32oeAwDLb1JlKlWyL1TB2pi+I8Zw4lJ6ARQFxtoCd/tZfPVVgaO53RC99GOrfvlNiqsUSvkajkAQkzFgADchLR0qlQSmyr345stzpo5OU0pPXnsP0P8x8vxNQSlCMbcgIiqYD5+T6dTbfSwhJh/DfuK0MR8u3agv//7Y1Qtidw8d03+sjNZTJrMDTc0mtrXV6ubS1LH2Tsf9Sz81BCJYz81U50bGhh+Y9eAiPuu1w1m3D2C7d0ysqdHjxOn6JovJkfn4BnO3HsYvztSEi9Wi82Ovm65NSE/v9jvG3gF3yymwjBtbtxW6DTp7yuObTHWBhWu2YpxSrXrJ4/GmxSYn09FJybRKo4Cu+jQ5d7Li/btXNd35/bHLb1GlS0Ti27kcziyfz6fShoZSjM9BG/VGu8vuTX30U0NTzyzpAfrfWvLmKpUCHxZLRALKbvOUgmaqJAZL0f3fwf0DrT9LoRIIhYVSCZficOhWL8MeNeismzxtlrN5+eiG4Lw80OqWiJpr5t0WE6oVwNVyEiBdwTKn04vDR6sZs8l1pMXgnJL3qcHyo4vQDKlWERK0IyImOnvUdTO4l+/tE48NrpYTqKmow/ETdafuXdM68AfPN0Ou5nPp4Yog+Uwuzclye7whHpfbRdsFCYu3Njn/8/hXZ0SKXBxLJkVzEkVifqrL4Xa6pOJX89a1OHpmSw/Qe+Q/5JV5wUviU1NWjBmTzGGsXe6rrtOGkgttvvY2i8HhcM176CPjjl90vluD5/AlgjeiE5NkfYaP4ARHRICiKBCWgbezBF9t3O5rbTXfuOQj/ec9o98D9B75U1wB5Qguj7N/yNAEmvgYOFweVqeze0xmp49LUef1JudjSz81Hv3V1kceaF65aqJKI3+aYdhUTYiW1kZE8sUyBcV6HTi+N5/xeNg+T2w0FvW8hR6g98gfKASgVtykmi+VCRPtDlcny7LtNKhOL4cULfvEXPt7XueF2ereFMv0Bk1rKUJrZHKh0mSxlzyxwfRRz5vokR7pkR75i8n/AUPtrJqhro/qAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDI0LTA3LTAzVDA2OjQ5OjQ0KzAwOjAwr+dnNwAAACV0RVh0ZGF0ZTptb2RpZnkAMjAyNC0wNy0wM1QwNjo0OTo0NCswMDowMN6634sAAAAASUVORK5CYII='/>"];
const cssString = `.snowfall-container {
    display: block;
    height: 100vh;
    left: 0;
    margin: 0;
    padding: 0;
    -webkit-perspective-origin: top center;
            perspective-origin: top center;
    -webkit-perspective: 150px;
            perspective: 150px;
    pointer-events: none;
    position: fixed;
    top: 0;
    -webkit-transform-style: preserve-3d;
            transform-style: preserve-3d;
    width: 100%;
    z-index: 99999; 
	}
  .snowflake {
    pointer-events: none;
    color: #ddf;
    display: block;
    font-size: 24px;
    left: -12px;
    line-height: 24px;
    position: absolute;
    top: -12px;
    -webkit-transform-origin: center;
    transform-origin: center; 
	animation: snowflakeScale 1s infinite ease-in-out;
	}
	@keyframes snowflakeScale {
    0%, 100% {
        opacity:0.1;
    }
    50% {
        opacity:1;
    }
	}`;
function ready(fn) {
    if (document.attachEvent ? document.readyState === 'complete' : document.readyState !== 'loading') {
        fn();
    }
    else {
        document.addEventListener('DOMContentLoaded', fn);
    }
}
function resetFlake(flake) {
    let x = flake.dataset.origX = (Math.random() * 100);
    let y = flake.dataset.origY = 100; // Thay đổi vị trí khởi tạo y từ 0 thành 100 (dưới cùng)
    let z = flake.dataset.origZ = (Math.random() < 0.1) ? (Math.ceil(Math.random() * 100) + 25) : 0;
    let life = flake.dataset.life = (Math.ceil(Math.random() * 4000) + 6000); 
    flake.dataset.origLife = life;
    flake.style.transform = `translate3d(${x}vw, ${y}vh, ${z}px)`;
    flake.style.opacity = 1.0;
    flake.dataset.periodFunction = Math.floor(Math.random() * period.length);

    if (Math.random() < 0.1) {
        flake.innerHTML = fun[Math.floor(Math.random() * fun.length)];
    }
}

function updatePositions() {
    flakes.forEach((flake) => {
        let origLife = parseFloat(flake.dataset.origLife);
        let curLife = parseFloat(flake.dataset.life);
        let dt = (origLife - curLife) / origLife;

        if (dt <= 1.0) {
            let p = period[parseInt(flake.dataset.periodFunction)];
            let x = p(dt * 2 * Math.PI) + parseFloat(flake.dataset.origX);
            let y = 100 * (1 - dt); // Thay đổi hướng di chuyển của y để bay từ dưới lên
            let z = parseFloat(flake.dataset.origZ);
            flake.style.transform = `translate3d(${x}vw, ${y}vh, ${z}px)`;
            if (dt >= 0.5) {
                flake.style.opacity = (1.0 - ((dt - 0.5) * 2));
            }
            curLife -= LIFE_PER_TICK;
            flake.dataset.life = curLife;
        } else {
            resetFlake(flake);
        }
    });
    window.requestAnimationFrame(updatePositions);
}

function appendSnow() {
    let styles = document.createElement('style');
    styles.innerText = cssString;
    document.querySelector('head').appendChild(styles);
    let field = document.createElement('div');
    field.classList.add('snowfall-container');
    field.setAttribute('aria-hidden', 'true');
    field.setAttribute('role', 'presentation');
    document.body.appendChild(field);
    let i = 0;
    const addFlake = () => {
        let flake = document.createElement('span');
        flake.classList.add('snowflake');
        flake.setAttribute('aria-hidden', 'true');
        flake.setAttribute('role', 'presentation');
        flake.innerHTML = "<img style='width:30px;height:30px;' src='data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgaGVpZ2h0PSI1MTIiIHZpZXdCb3g9IjAgMCA1MTIgNTEyIiB3aWR0aD0iNTEyIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPjxnPjxwYXRoIGQ9Im01MTAgMjU2LjAwMWgtNTA4YzAtMTQwLjI3NCAxMTMuNzA4LTI1NC4wMDEgMjUzLjk5OS0yNTQuMDAxIDE0MC4yNzQgMCAyNTQuMDAxIDExMy43MjcgMjU0LjAwMSAyNTQuMDAxeiIgZmlsbD0iI2VkMWMyNCIvPjxwYXRoIGQ9Im01MTAgMjU2LjAwMWMwIDE0MC4yNzItMTEzLjcyNyAyNTMuOTk5LTI1NC4wMDEgMjUzLjk5OS0xNDAuMjkxIDAtMjUzLjk5OS0xMTMuNzI3LTI1My45OTktMjUzLjk5OXoiIGZpbGw9IiNmMWYyZjIiLz48L2c+PC9zdmc+'/>";
        resetFlake(flake);
        flakes.push(flake);
        field.appendChild(flake);
        if (i++ <= MAX_FLAKES) {
            setTimeout(addFlake, Math.ceil(Math.random() * 300) + 100);
        }
    };
    addFlake();
    updatePositions();
}
ready(appendSnow);