<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Displays the content of the dialog box when the user clicks on the "Deactivate" link on the plugin settings page
 */

function whatsform_add_feedback_form()
{
    $contact_support_template = __('Need help? We are ready to answer your questions. <a href="https://chatbot.page/whatsform/" target="_blank">Contact Support</a>', 'form-to-chat');

    $reasons = array(
        array(
            'id'                => 'NOT_WORKING',
            'text'              => __('The plugin is not working', 'form-to-chat'),
            'input_type'        => 'textarea',
            'input_placeholder' => esc_attr__("Kindly share what didn't work so we can fix it in future updates.", 'form-to-chat'),
        ),
        array(
            'id'                => 'SUDDENLY_STOPPED_WORKING',
            'text'              => __('The plugin suddenly stopped working', 'form-to-chat'),
            'input_type'        => '',
            'input_placeholder' => '',
            'internal_message'  => $contact_support_template,
        ),
        array(
            'id'                => 'BROKE_MY_SITE',
            'text'              => __('The plugin broke my site', 'form-to-chat'),
            'input_type'        => '',
            'input_placeholder' => '',
            'internal_message'  => $contact_support_template,

        ),
        array(
            'id'                => 'COULDNT_MAKE_IT_WORK',
            'text'              => __("I couldn't understand how to get it work", 'form-to-chat'),
            'input_type'        => '',
            'input_placeholder' => '',
            'internal_message'  => $contact_support_template,
        ),
        array(
            'id'                => 'FOUND_A_BETTER_PLUGIN',
            'text'              => __('I found a better plugin', 'form-to-chat'),
            'input_type'        => 'textarea',
            'input_placeholder' => esc_attr__('Can you please name the plugin and why you liked that it more?', 'form-to-chat'),
        ),
        array(
            'id'                => 'GREAT_BUT_NEED_SPECIFIC_FEATURE',
            'text'              => __('The plugin is great, but I need a specific feature', 'form-to-chat'),
            'input_type'        => 'textarea',
            'input_placeholder' =>  esc_attr__('Can you share more details on the missing feature?', 'form-to-chat'),
        ),
        array(
            'id'                => 'TEMPORARY_DEACTIVATION',
            'text'              => __("It's a temporary deactivation, I'm just debugging an issue", 'form-to-chat'),
            'input_type'        => '',
            'input_placeholder' => '',
        ),
        array(
            'id'                => 'OTHER',
            'text'              => __('Other', 'form-to-chat'),
            'input_type'        => 'textarea',
            'input_placeholder' => '',
        ),

    );

    $modal_html = '<div class="whatsform-modal whatsform-modal-deactivation-feedback">
    <div class="whatsform-modal-dialog">
        <div class="whatsform-modal-body">
            <h2>Quick Feedback</h2>
            <div class="whatsform-modal-panel active">
                <p>If you have a moment, please let us know why you are deactivating</p><ul>';

    foreach ($reasons as $reason) {
        $list_item_classes = 'whatsform-modal-reason' . (!empty($reason['input_type']) ? ' has-input' : '');

        if (!empty($reason['internal_message'])) {
            $list_item_classes      .= ' has-internal-message';
            $reason_internal_message = $reason['internal_message'];
        } else {
            $reason_internal_message = '';
        }

        $modal_html .= '<li class="' . esc_attr($list_item_classes) . '" data-input-type="' . esc_attr($reason['input_type']) . '" data-input-placeholder="' . esc_attr($reason['input_placeholder']) . '">
        <label>
            <span>
                <input type="radio" name="selected-reason" value="' . esc_attr($reason['id']) . '"/>
            </span>
            <span>' . esc_html($reason['text']) . '</span>
        </label>
        <div class="whatsform-modal-internal-message">' . $reason_internal_message . '</div>
    </li>';
    }
    $modal_html .= '</ul>
                    <label class="whatsform-modal-anonymous-label">
                        <input type="checkbox" checked/>
                        Send website data and allow to contact me back 
                    </label>
                </div>
            </div>
            <div class="whatsform-modal-footer">
                <a href="#" class="button button-primary whatsform-modal-button-deactivate"></a>
                <div class="clear"></div>
            </div>
        </div>
    </div>';

    $script = '';


    global  $whatsform_active_plugin;
    $basename = '';
    $plugin_name = '';
    foreach ($whatsform_active_plugin as $key => $val) {

        $plugin_name = sanitize_title($val['Name']);
        $basename = $key;
    }



    $script .= '(function($) {
            var modalHtml = ' . wp_json_encode($modal_html) . ",
                \$modal                = $( modalHtml ),
                \$deactivateLink       = $( '#the-list .active[data-plugin=\"" . $basename . "\"] .deactivate a' ),
                \$anonymousFeedback    = \$modal.find( '.whatsform-modal-anonymous-label' ),
                selectedReasonID      = false;
            
            /* WP added data-plugin attr after 4.5 version/ In prev version was id attr */
            if ( 0 == \$deactivateLink.length )
                \$deactivateLink = $( '#the-list .active#" . $plugin_name . " .deactivate a' );

            \$modal.appendTo( $( 'body' ) );

            whatsformModalRegisterEventHandlers();
            
            function whatsformModalRegisterEventHandlers() {
                \$deactivateLink.click( function( evt ) {
                    evt.preventDefault();

                    /* Display the dialog box.*/
                    whatsformModalReset();
                    \$modal.addClass( 'active' );
                    $( 'body' ).addClass( 'has-whatsform-modal' );
                });

                \$modal.on( 'input propertychange', '.whatsform-modal-reason-input input', function() {
                    if ( ! whatsformModalIsReasonSelected( 'OTHER' ) ) {
                        return;
                    }

                    var reason = $( this ).val().trim();

                    /* If reason is not empty, remove the error-message class of the message container to change the message color back to default. */
                    if ( reason.length > 0 ) {
                        \$modal.find( '.message' ).removeClass( 'error-message' );
                        whatsformModalEnableDeactivateButton();
                    }
                });

                \$modal.on( 'blur', '.whatsform-modal-reason-input input', function() {
                    var \$userReason = $( this );

                    setTimeout( function() {
                        if ( ! whatsformModalIsReasonSelected( 'OTHER' ) ) {
                            return;
                        }
                    }, 150 );
                });

                \$modal.on( 'click', '.whatsform-modal-footer .button', function( evt ) {
                    evt.preventDefault();

                    if ( $( this ).hasClass( 'disabled' ) ) {
                        return;
                    }

                    var _parent = $( this ).parents( '.whatsform-modal:first' ),
                        _this =  $( this );

                    if ( _this.hasClass( 'allow-deactivate' ) ) {
                        var \$radio = \$modal.find( 'input[type=\"radio\"]:checked' );

                        if ( 0 === \$radio.length ) {
                            /* If no selected reason, just deactivate the plugin. */
                            window.location.href = \$deactivateLink.attr( 'href' );
                            return;
                        }

                        var \$selected_reason = \$radio.parents( 'li:first' ),
                            \$input = \$selected_reason.find( 'textarea, input[type=\"text\"]' ),
                            userReason = ( 0 !== \$input.length ) ? \$input.val().trim() : '';

                        var is_anonymous = ( \$anonymousFeedback.find( 'input' ).is( ':checked' ) ) ? 0 : 1;

                        $.ajax({
                            url       : ajaxurl,
                            method    : 'POST',
                            data      : {
                                'action'			: 'whatsform_submit_uninstall_reason_action',
                                'plugin'			: '" . $basename . "',
                                'reason_id'			: \$radio.val(),
                                'reason_info'		: userReason,
                                'is_anonymous'		: is_anonymous,
                                'whatsform_ajax_nonce'	: '" . wp_create_nonce('whatsform_ajax_nonce') . "'
                            },
                            beforeSend: function() {
                                _parent.find( '.whatsform-modal-footer .button' ).addClass( 'disabled' );
                                _parent.find( '.whatsform-modal-footer .button-secondary' ).text( '" . __('Processing', 'form-to-chat') . "' + '...' );
                            },
                            complete  : function( message ) {
                                /* Do not show the dialog box, deactivate the plugin. */
                                window.location.href = \$deactivateLink.attr( 'href' );
                            }
                        });
                    } else if ( _this.hasClass( 'whatsform-modal-button-deactivate' ) ) {
                        /* Change the Deactivate button's text and show the reasons panel. */
                        _parent.find( '.whatsform-modal-button-deactivate' ).addClass( 'allow-deactivate' );
                        whatsformModalShowPanel();
                    }
                });

                \$modal.on( 'click', 'input[type=\"radio\"]', function() {
                    var \$selectedReasonOption = $( this );

                    /* If the selection has not changed, do not proceed. */
                    if ( selectedReasonID === \$selectedReasonOption.val() )
                        return;

                    selectedReasonID = \$selectedReasonOption.val();

                    \$anonymousFeedback.show();

                    var _parent = $( this ).parents( 'li:first' );

                    \$modal.find( '.whatsform-modal-reason-input' ).remove();
                    \$modal.find( '.whatsform-modal-internal-message' ).hide();
                    \$modal.find( '.whatsform-modal-button-deactivate' ).text( '" . __('Submit and Deactivate', 'form-to-chat') . "' );

                    whatsformModalEnableDeactivateButton();

                    if ( _parent.hasClass( 'has-internal-message' ) ) {
                        _parent.find( '.whatsform-modal-internal-message' ).show();
                    }

                    if (_parent.hasClass('has-input')) {
                        var reasonInputHtml = '<div class=\"whatsform-modal-reason-input\"><span class=\"message\"></span>' + ( ( 'textfield' === _parent.data( 'input-type' ) ) ? '<input type=\"text\" />' : '<textarea rows=\"5\" maxlength=\"200\"></textarea>' ) + '</div>';

                        _parent.append( $( reasonInputHtml ) );
                        _parent.find( 'input, textarea' ).attr( 'placeholder', _parent.data( 'input-placeholder' ) ).focus();

                        if ( whatsformModalIsReasonSelected( 'OTHER' ) ) {
                            \$modal.find( '.message' ).text( '" . __('Please tell us the reason so we can improve it.', 'form-to-chat') . "' ).show();
                        }
                    }
                });

                /* If the user has clicked outside the window, cancel it. */
                \$modal.on( 'click', function( evt ) {
                    var \$target = $( evt.target );

                    /* If the user has clicked anywhere in the modal dialog, just return. */
                    if ( \$target.hasClass( 'whatsform-modal-body' ) || \$target.hasClass( 'whatsform-modal-footer' ) ) {
                        return;
                    }

                    /* If the user has not clicked the close button and the clicked element is inside the modal dialog, just return. */
                    if ( ! \$target.hasClass( 'whatsform-modal-button-close' ) && ( \$target.parents( '.whatsform-modal-body' ).length > 0 || \$target.parents( '.whatsform-modal-footer' ).length > 0 ) ) {
                        return;
                    }

                    /* Close the modal dialog */
                    \$modal.removeClass( 'active' );
                    $( 'body' ).removeClass( 'has-whatsform-modal' );

                    return false;
                });
            }

            function whatsformModalIsReasonSelected( reasonID ) {
                /* Get the selected radio input element.*/
                return ( reasonID == \$modal.find('input[type=\"radio\"]:checked').val() );
            }

            function whatsformModalReset() {
                selectedReasonID = false;

                whatsformModalEnableDeactivateButton();

                /* Uncheck all radio buttons.*/
                \$modal.find( 'input[type=\"radio\"]' ).prop( 'checked', false );

                /* Remove all input fields ( textfield, textarea ).*/
                \$modal.find( '.whatsform-modal-reason-input' ).remove();

                \$modal.find( '.message' ).hide();

                /* Hide, since by default there is no selected reason.*/
                \$anonymousFeedback.hide();

                var \$deactivateButton = \$modal.find( '.whatsform-modal-button-deactivate' );

                \$deactivateButton.addClass( 'allow-deactivate' );
                whatsformModalShowPanel();
            }

            function whatsformModalEnableDeactivateButton() {
                \$modal.find( '.whatsform-modal-button-deactivate' ).removeClass( 'disabled' );
            }

            function whatsformModalDisableDeactivateButton() {
                \$modal.find( '.whatsform-modal-button-deactivate' ).addClass( 'disabled' );
            }

            function whatsformModalShowPanel() {
                \$modal.find( '.whatsform-modal-panel' ).addClass( 'active' );
                /* Update the deactivate button's text */
                \$modal.find( '.whatsform-modal-button-deactivate' ).text( '" . __('Skip and Deactivate', 'form-to-chat') . "' );
            }
        })(jQuery);";
    wp_register_script('whatsform-deactivation-form', '', array('jquery'), '1.2.1', true);
    wp_enqueue_script('whatsform-deactivation-form');
    wp_add_inline_script('whatsform-deactivation-form', $script);
}
