<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<?php

// platform_check.php @generated by Composer

$issues = array();

if (!(PHP_VERSION_ID >= 80200)) {
    $issues[] = 'Your Composer dependencies require a PHP version ">= 8.2.0". You are running ' . PHP_VERSION . '.';
}

if ($issues) {
    if (!headers_sent()) {
        header('HTTP/1.1 500 Internal Server Error');
    }
    if (!ini_get('display_errors')) {
        if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') {
            // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_fwrite
            fwrite(STDERR, 'Composer detected issues in your platform:' . PHP_EOL.PHP_EOL . implode(PHP_EOL, $issues) . PHP_EOL.PHP_EOL);
        } elseif (!headers_sent()) {
            echo 'Composer detected issues in your platform:' . PHP_EOL . PHP_EOL
                . esc_html(
                    str_replace(
                        'You are running ' . PHP_VERSION . '.',
                        '',
                        implode(PHP_EOL, $issues)
                    )
                ) . PHP_EOL . PHP_EOL;

        }
    }
    //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_trigger_error
    trigger_error(
        'Composer detected issues in your platform: ' . esc_html(implode(', ', $issues)),
        E_USER_ERROR
    );
}
