<?php

namespace UpsFreeVendor\WPDesk\Tracker;

use UpsFreeVendor\WPDesk\PluginBuilder\Plugin\Hookable;
/**
 * Can enqueue assets.
 */
class Assets implements Hookable
{
    /**
     * @var string
     */
    private $script_version = '1';
    /**
     * @var string
     */
    private $plugin_slug;
    /**
     * @param string $plugin_slug
     */
    public function __construct($plugin_slug)
    {
        $this->plugin_slug = $plugin_slug;
    }
    public function hooks()
    {
        add_action('admin_enqueue_scripts', [$this, 'admin_enqueue_scripts']);
    }
    public function admin_enqueue_scripts()
    {
        $screen = get_current_screen();
        if ($screen->id === 'admin_page_wpdesk_tracker_' . $this->plugin_slug) {
            $handle = 'wpdesk-helper-tracker_' . $this->plugin_slug;
            wp_register_style($handle, plugin_dir_url(__FILE__) . '../../../assets/css/tracker.css', [], $this->script_version);
            wp_register_script($handle, plugin_dir_url(__FILE__) . '../../../assets/js/admin.js', [], $this->script_version);
            wp_enqueue_style($handle);
            wp_enqueue_script($handle);
        }
    }
}
