<?php

namespace WPDesk\ShowDecision;

class OrStrategy implements ShouldShowStrategy
{

    /**
     * @var ShouldShowStrategy[]
     */
    private array $conditions = [];

    public function __construct(ShouldShowStrategy $strategy)
    {
        $this->conditions[] = $strategy;
    }

    public function addCondition(ShouldShowStrategy $condition): self
    {
        $this->conditions[] = $condition;

        return $this;
    }

    public function shouldDisplay(): bool
    {
        foreach ($this->conditions as $condition) {
            if ($condition->shouldDisplay()) {
                return true;
            }
        }

        return false;
    }

}
