<?php

namespace VendorFPF\WPDesk\Tracker;

use VendorFPF\WPDesk\Notice\Notice;
use VendorFPF\WPDesk\PluginBuilder\Plugin\Hookable;
class OptOut implements Hookable
{
    /**
     * @var string
     */
    private $plugin_slug;
    /**
     * @var string
     */
    private $plugin_name;
    /**
     * @param string $plugin_slug
     * @param string $plugin_name
     */
    public function __construct($plugin_slug, $plugin_name)
    {
        $this->plugin_slug = $plugin_slug;
        $this->plugin_name = $plugin_name;
    }
    public function hooks()
    {
        add_action('admin_notices', [$this, 'handle_opt_out']);
    }
    /**
     * @internal
     */
    public function handle_opt_out()
    {
        $screen = get_current_screen();
        if ('plugins' === $screen->id && isset($_GET['wpdesk_tracker_opt_out_' . $this->plugin_slug])) {
            $security = sanitize_text_field(wp_unslash($_GET['security'] ?? ''));
            if (wp_verify_nonce($security, $this->plugin_slug)) {
                $persistence = new \VendorFPF\WPDesk_Tracker_Persistence_Consent();
                $persistence->set_active(\false);
                delete_option('wpdesk_tracker_notice');
                new Notice(sprintf(esc_html__('You successfully opted out of collecting usage data by %1$s. If you change your mind, you can always opt in later in the plugin\'s quick links.', 'flexible-product-fields'), esc_html($this->plugin_name)));
            }
        }
    }
}
