<?php

namespace WPDeskFIVendor\WPDesk\Library\FlexibleInvoicesCore\WooCommerce;

use WPDeskFIVendor\WPDesk\Library\FlexibleInvoicesAbstracts\Documents\Document;
use WPDeskFIVendor\WPDesk\Library\FlexibleInvoicesCore\Integration\MetaPostContainer;
use WPDeskFIVendor\WPDesk\PluginBuilder\Plugin\Hookable;
/**
 * Save custom post meta for WooCommerce.
 *
 * @package WPDesk\Library\FlexibleInvoicesCore\WooCommerce
 */
class DocumentPostMeta implements Hookable
{
    /**
     * Fires hooks
     */
    public function hooks()
    {
        add_action('fi/core/document/save', [$this, 'before_save_action'], 80, 2);
    }
    /**
     *
     * @param Document          $document
     * @param MetaPostContainer $meta
     *
     * @internal You should not use this directly from another application
     */
    public function before_save_action(Document $document, MetaPostContainer $meta)
    {
        if (!empty($_POST['add_order_id'])) {
            // phpcs:ignore
            $add_order_id = (int) $_POST['add_order_id'];
            // phpcs:ignore
            $meta->set('add_order_id', $add_order_id);
        }
        $meta->set('add_order_id', 0);
    }
}
