<?php

namespace WPDeskFIVendor\WPDesk\Library\FlexibleInvoicesCore\Settings\Tabs\Reports;

use WPDeskFIVendor\WPDesk\Forms\Field\Header;
use WPDeskFIVendor\WPDesk\Forms\Field\InputTextField;
use WPDeskFIVendor\WPDesk\Forms\Field\SelectField;
use WPDeskFIVendor\WPDesk\Library\FlexibleInvoicesCore\Settings\Tabs\FieldSettingsTab;
class KSeFDummyTab extends FieldSettingsTab
{
    const KSEF_DUMMY_FIELD_NAME = 'dummy-field';
    protected function get_fields()
    {
        $fields = [(new Header())->set_label(esc_html__('KSeF', 'flexible-invoices'))->set_description(sprintf(
            // translators: 1. Open a tag with href. Ready for url. 4. Finish a tag with class and target, break line
            esc_html__('Soon we will publish an add-on for Flexible Invoices WooCommerce that will enable Polish users to send documents to Krajowy System eFaktur (The Polish National System of e-Invoices). %1$sSign up for the waiting list%2$s', 'flexible-invoices'),
            '<a href="https://wpdesk.pl/sk/fi-ksef-settings">',
            '</a><br/><hr/>'
        )), (new SelectField())->set_name(self::KSEF_DUMMY_FIELD_NAME)->set_label(esc_html__('Environtment', 'flexible-invoices'))->set_options(['test' => esc_html__('Test', 'flexible-invoices'), 'demo' => esc_html__('Pre-prod', 'flexible-invoices'), 'prod' => esc_html__('Prod', 'flexible-invoices')])->set_disabled()->set_default_value('test'), (new InputTextField())->set_name(self::KSEF_DUMMY_FIELD_NAME)->set_label(esc_html__('Token', 'flexible-invoices'))->set_description(__('Paste the token allowing integration with KSEF. See how to do it <a href="">here</a>. Connection status: ', 'flexible-invoices'))->set_disabled()->add_class('hs-beacon-search'), (new SelectField())->set_name(self::KSEF_DUMMY_FIELD_NAME)->set_label(__('VAT exempt rate', 'flexible-invoices'))->set_description(__('If you are exempt from VAT, select from the list (otherwise, the system may send, for example, the VAT-exempt rate).', 'flexible-invoices'))->set_options([])->set_disabled()->add_class(self::KSEF_DUMMY_FIELD_NAME), (new SelectField())->set_name(self::KSEF_DUMMY_FIELD_NAME)->set_label(__('0% rate', 'flexible-invoices'))->set_description(__('If you are using a 0% rate, select it from the list (otherwise, the system may send, for example, the VAT-exempt rate).', 'flexible-invoices'))->set_options([])->set_disabled()];
        return $fields;
    }
    public static function get_tab_slug()
    {
        return 'ksef';
    }
    public function get_tab_name()
    {
        return esc_html__('KSeF', 'flexible-invoices');
    }
}
