 <?php global $wp_version, $wpdb, $wp_post_types; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Final Tiles Gallery</title>
		<!--<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.9.0/jquery.min.js"></script>-->
		<script>
		var wpColorPickerL10n = {"clear":"Clear","defaultString":"Default","pick":"Select Color","current":"Current Color"};
		</script>
		<script type="text/javascript" src="<?php print esc_url( $admin_url ) ?>/load-scripts.php?c=1&load%5B%5D=jquery-core,jquery-migrate,utils,jquery-ui-core,jquery-ui-widget,jquery-ui-mouse,jquery-ui-draggable,jquery-ui-slider,jquery-tou&load%5B%5D=ch-punch,iris,wp-color-picker"></script>
		<link rel="stylesheet" href="<?php print esc_url( admin_url( 'load-styles.php?c=1&dir=ltr&load=buttons,wp-admin,iris,wp-color-picker') ); ?>" type="text/css" media="all">			
		<link rel="stylesheet" href="<?php print esc_url( $css_path ) ?>">
		<script language="javascript" type="text/javascript" src="<?php echo esc_url( includes_url( 'js/tinymce/tiny_mce_popup.js' ).'?ver='.$wp_version); ?>"></script> 	
		<style type="text/css">
			h1
			{
				color: black;
			}
			body {
				overflow-y:scroll;
				padding: 5px 20px 100px 20px;
				height: auto;
			}		
			#galleries{
				width: 100%;
				border-collapse: collapse;
			}	
			tr:nth-child(1){
				background-color: #90caf9;
			}
			tr{
				background-color: #e3f2fd;
				cursor: pointer;
			}
			tr:not(:nth-child(1)):hover{
				background-color: #bbdefb;
			}			

			#galleries td, #galleries th{
				border: 1px solid white;
				padding: 10px;
			}
		</style>
	</head>
	<body class="popup">
		<h1> YOUR GALLERIES: </h1>
		<br>
		<table id="galleries">
			<!-- list here galleries -->
			<!-- loop variable $galleries -->
			<tr>
				<td>
					<b> Name </b>
				</td>
				<td>
					<b> Type </b>
				</td>
				<td>
					<b> ID </b>
				</td>
			</tr>
			<?php foreach($galleries as $gallery): ?>				
				<tr>
					<td>
						<label  id="<?php print 'gall_' . esc_attr( $gallery->Id ) ?>"> <?php print esc_html( $gallery->name ); ?> </label>
					</td>

					<td>
						<?php print !empty($gallery->source) ? esc_html( $gallery->source ) : "images"; ?>
					</td>

					<td>
						<?php print esc_html( $gallery->Id ); ?>
					</td>
				</tr>
			<?php endforeach ?>
		</table>
		<script>
		jQuery("#galleries tr").click(function (e) {
			var id = jQuery(this).find('label').attr('id').split('gall_');
			id.shift();	
			top.tinymce.activeEditor.insertContent('[FinalTilesGallery id="'+ id +'"]');
			top.tinymce.activeEditor.windowManager.close(); 
		});
		</script>
	</body>
</html>
