<?php

namespace FakerPress\ThirdParty\Faker\Provider\it_IT;

class Text extends \FakerPress\ThirdParty\Faker\Provider\Text
{
    /**
     * The Project Gutenberg EBook of Una notte bizzarra, by Anton Giulio Barrili
     *
     * This eBook is for the use of anyone anywhere at no cost and with
     * almost no restrictions whatsoever.  You may copy it, give it away or
     * re-use it under the terms of the Project Gutenberg License included
     * with this eBook or online at www.gutenberg.org
     *
     * Title: Una notte bizzarra
     * Author: Anton Giulio Barrili
     * Release Date: August 8, 2009 [EBook #29636]
     * Language: Italian
     *
     * *** START OF THIS PROJECT GUTENBERG EBOOK UNA NOTTE BIZZARRA ***
     *
     *
     * Produced by Claudio Paganelli, Carlo Traverso and the
     * Online Distributed Proofreading Team at http://www.pgdp.net
     * (This file was produced from images generously made
     * available by The Internet Archive/Canadian Libraries)
     *
     *
     * CAPITAN DODERO
     *
     * UNA NOTTE BIZZARRA
     *
     * NOVELLE DI ANTON GIULIO BARRILI
     *
     * Settima edizione.
     *
     * MILANO
     *
     * FRATELLI TREVES, EDITORI 1881.
     *
     * PROPRIETÀ LETTERARIA
     *
     * Tip. Treves
     *
     * UNA NOTTE BIZZARRA
     *
     * A LUIGI MORANDI
     *
     *
     * _La è proprio una inezia, frutto di tre giorni di lavoro, che intitolo
     * a te, giovine amico e compagno d'armi; ma sappi che fu un gaio lavoro
     * campestre, e lavoro gaio riesce facile, e val meglio assai che sudato,
     * ma uggioso._
     *
     * _Nè paia fuor del naturale a te, nè ai lettori cortesi, che i
     * personaggi della mia novella s'innamorino in una notte. Anco a non
     * volerne cercar la ragione, la scusa, nella novità de' casi narrati, io
     * so che la cosa non è poi tanto difficile, io che ti ho per la prima
     * volta veduto, ed amato come fratello, in un giorno. Tu dirai che,
     * anche là, era quistione d'urgenza, imperocchè chi poteva morire il
     * giorno di poi non avea tempo da perdere. Or dunque, concediamo la
     * parte loro agli eventi, e non se ne parli più, se non per ricordare
     * che l'amicizia, nata e cresciuta in un giorno, ha da fortificarsi in
     * tutti que' molti, o pochi, che ci comporranno la trama della vita._
     *
     * Di Genova, il 19 di Luglio del 1868.
     *
     * ANTON GIULIO BARRILI.
     *
     * @see https://gutenberg.org/cache/epub/29636/pg29636.txt
     *
     * @var string
     */
    protected static $baseText = <<<'EOT'
I.


Era la notte dal 12 al 13 di gennaio 1857, e per la via Assarotti, a
Genova, soffiava un vento come suole soffiare in quest'ampia via,
quando Eolo scatena uno de' suoi sudditi sulla regina del Tirreno.

È tramontana? è scirocco? è libeccio? Non ne sapete nulla. Esce, non
si sa da dove, e v'investe da tutte le parti. Guai allo scribacchino
municipale che si lascia cogliere ad occhi aperti, perchè risica di
andare a palazzo Tursi colla polvere negli occhi, di non veder più lo
scrittoio e di dover chiedere una licenza di ventiquattr'ore, che il
capo uffizio non è sempre disposto a concedere! Guai alla signora, che
non sta attenta a raccogliersi la veste dattorno, perchè il vento è
curioso di segreti e, quel che è peggio, ama troppo di propalarli ai
viandanti.

Ma perchè sto io a discorrervi del vento? La storia che vi racconto
non occorre in mezzo alla strada, ma in un elegante quartierino al
terzo piano del secondo palazzo a sinistra.

Abita colassù, cioè, dico male, abitava nel gennaio 1857 il
protagonista del mio racconto, uomo sui trentaquattro, laureato in
leggi, scapolo, non brutto, nè antipatico, e con ventimila lire
d'entrata.

Trentaquattro anni son forse troppi; la laurea in leggi non è nulla;
ma l'essere scapolo, non brutto nè antipatico, e l'avere ventimila
lire d'entrata, è già molto per esser felici, quando si abbiano
desiderii modesti.

Pure, Roberto Fenoglio non era felice; si annoiava da mattina a sera,
da sera a mattina. Aveva buoni e gioviali amici, ai quali imprestava
spesso del denaro, e che qualche volta glielo restituivano; una
vecchia governante che non gli dava molestia; un cuoco che non lo
derubava; un cavallo proverbiale per la dolcezza del suo trotto; uno
scanno a teatro senza noiosi vicini; e tuttavia non era felice, e si
annoiava maledettamente.

Aveva provato a fare qualcosa, ad occuparsi; ma nessuna occupazione
gli andava a' versi, e a breve andare se n'era stancato. Ma queste
cose le mie belle lettrici le udranno dalla sua bocca, imperocchè io
lo presento loro nel primo salotto del suo quartierino, alle tre dopo
mezzanotte, vestito da cinese, in atto di congedare uno sciame di
giovinotti e di allegre mascherine.

Perchè vestito da cinese? perchè quelle mascherine?

Roberto Fenoglio aveva raccolto in casa sua quella sera tutti i suoi
amici, tanto per passar la noia in compagnia. S'era suonato, ballato e
cenato, colla massima libertà ed allegrezza. Le dame non erano severe,
nè contegnose. Il rispettabile corpo di ballo del teatro Carlo Felice
aveva dato il suo meglio a quella festa; le mammine erano sazie e
contente; le silfidi, contente e non sazie, domandavano un'altra festa
come quella che Roberto Fenoglio aveva dato loro, con tanta
splendidezza di mandarino annoiato.

Le allegre mascherine se ne andavano, accompagnate dai fidi cavalieri,
ben chiuse nei loro accappatoi, per custodirsi dal vento, che si udia
zufolare di fuori; se ne andavano giù per le scale, ridendo e
cinguettando come uno stuolo di passere, o di cingallegre, e destando
tutto il pacifico vicinato.

Il tranquillo berretto di cotone si rizzava commosso dalla
rimboccatura del letto matrimoniale, e chiedeva:

--Che cos'è quest'allegro rumore? Ah, capisco; si balla dall'avvocato
Fenoglio.

E un sospiro mal represso chiudeva la frase. E lì, una cuffia lavorata
all'uncinetto si rizzava a sua volta, per soggiungere:

--Ma come fa l'avvocato Fenoglio a dar delle feste da ballo, egli che
non è ammogliato? Quali signore possono andare in casa sua?

Domanda, questa, a cui il berretto di cotone non rispondeva, e si
voltava dall'altro lato, tirandosi la rimboccatura del lenzuolo fin
sopra il becchetto.

La cuffia intanto pensava, pensava.... che cosa pensava? forse, che il
berretto di cotone non era la più bella cosa del mondo. E il berretto
di cotone, dal canto suo, fantasticava una serie di variazioni su
questo tema: «beato Fenoglio! egli l'ha indovinata davvero!»

Lasciamo pensare, fantasticare e riaddormentarsi da capo questi due
malinconici simboli dell'Imeneo, e torniamo al nostro protagonista,
che, ritto nel salotto, si volgeva a Felice Magnasco, ultimo rimasto
de' suoi convitati, per dirgli, con piglio di burlesca cerimonia
cinese:

--_A-ing-fo-hi_!

Felice Magnasco, un giovinotto elegante ed attillato, come ogni figlio
d'Adamo che usi farsi vestire (o spogliare) da un sarto di grido,
diede una crollata di spalle, che fece far due grinze al suo abito
nero, e rispose:

--Orvia! Gli è così che tu accomiati il tuo amico migliore?

--Sto in carattere,--soggiunse Fenoglio.--Non ti pare che io sia un
bel mandarino cinese?

--Al diavolo la Cina!--proruppe l'altro,--io preferisco la tua cena.

--Oh bello, bello, stupendo! Ripetilo, Felice, te ne prego.

--Che cosa?

--Il tuo bisticcio. Sai che amo i bisticci, come tu le bistecche....
Ah, ah! che te ne pare del mio? Gli è un po' stiracchiato, come le mie
braccia, tutta questa sera, per effetto della noia.

--Tu sei dunque annoiato?

--Sì, Felicino, pur troppo; il figlio della luna, il cugino del sole,
s'è maledettamente annoiato.

--Male! io mi son divertito. È vero che le spese non le ho fatte io, e
piacere che non sente il rame è pretto piacere. Che ottima cena! Viva
te, Roberto primo ed unico della tua dinastia! Viva il tuo vino, i
tuoi tartufi! e le tue _bajadere_. Che vispe ragazze! Oh non sai tu,
che, se non era il pensiero della mia bella cugina, io questa sera ne
sposavo una, senza tanti preamboli?

--Ti ringrazio per lei della tua buona intenzione,--rispose,
spalancando le fauci e tendendo le braccia, il buon mandarino,--e ti
ringrazio per me, se non sei costretto a sbadigliare, come io faccio
in questo punto per la millesima volta.

--Ma che diamine ti saltò in mente di vestirti a quel modo e di
costringerti a non metter fuori che cinque o sei monosillabi?

--Compatiscimi, Felicino! Ho pensato che, essendo i cinesi il popolo
più cerimonioso del mondo, io, come cerimoniere di casa mia, non
potevo fare a meno di vestirmi da mandarino. Ora tu m'hai veduto ed
udito; non ho fatto altro che dire _A-ing-fo-hi_, che in cinese, io
credo, significa: son molto lieto di vedervi.

--E i tuoi convitati,--soggiunse ridendo Felice,--ti hanno trovato
compitissimo.--

Roberto Fenoglio si lasciò cadere con aria stanca sul canapè.

--Tu mi consoli, amico!--diss'egli, dopo un lungo sospiro.--Morrò
almeno contento dell'altrui contentezza.

--Che diamine dici? Sei tu pazzo ora?

--No, parlo da senno e del miglior ch'io m'abbia. Sentimi, Felice; io
non posso più tirare innanzi questa monotona vita. Io non faccio un
passo senza che il piede medesimo si annoi d'esser mosso.

--Ecco una variante del _Malade imaginaire_!--esclamò Felice, in
quella che andava a sedersi comodamente in una poltrona, di rincontro
a Roberto Fenoglio.

Questi non badò all'atto di Felice, intento com'era a rispondergli.

--Ah sì, in tal guisa parlano i sani agli infermi. Anch'io, al
capezzale di un tisico, gli ho detto un giorno: ma che diamine parlate
voi di morire? Avete le guancie colorite come una mela. E dieci giorni
dopo era morto.

--Dilla su dunque una volta, questa tua malattia, ed io farò di
trovarti un buon medico.

--Ah ci vuol altro che un medico! La scienza non conosce il mio male,
non lo ha classificato ancora ne' suoi libri; ma esso esiste, esso è
là dentro.

--Dove?

--In quell'orologio a pendolo. Esso ne è il simbolo parlante, esso il
complice infame. Non odi? tran.... tran.... tran.... Maledetto! È lui
che ci misura la vita e ce la fa mandar giù in ventiquattro pillole al
giorno; è lui l'omeopatico che ci tiene a bada con sessantesimi d'ora,
con sessantesimi di minuto, e ci fa morire con dosi infinitesime; è
lui.... Insomma, che ti dirò? Io odio gli orologi. Giovinetto ancora,
io già presentivo la guerra che m'avrebbero mossa questi nemici
dell'umanità, e mi vendicavo, anticipatamente, mandandoli, l'un dopo
l'altro, al Monte di pietà. Adesso, si è uomini sodi, padroni di sè e
delle sue ventimila lire d'entrata, e queste vendette bisogna
lasciarle in disparte. Ma io troverò pure uno spediente; metterò, non
foss'altro, un premio di mille lire per colui che scriverà un libro
contro gli orologi, da camera e da tasca, pendoli, cronometri,
ripetizioni, cilindri, saponette, áncore, castelli, ecc., ecc., e
proverà che il loro inventore è stato un cattivo arnese.... un
briccone.--

In quella che l'avvocato Fenoglio tirava giù con burlesca gravità
contro i poveri orologi, Felice aveva cavato il suo dalla tasca del
pianciotto e ne faceva scattare il coperchio d'oro.

--O il tuo va male, o il mio;--disse egli.--Son già le tre e mezzo del
mattino, e debbo ancora chiederti un servizio innanzi di andarmene.--

Ma Fenoglio non gli dava retta; aveva veduto l'oriuolo di Felice e
volea rompergli una lancia addosso.

--Ah, _tu quoque, Brute_? E tu sei un uomo che si diverte? col nemico
in saccoccia?

--Che vuoi? è la consuetudine. E poi, non si è mica schiavi del
proprio orologio! Il mio, come quello di tutti i figli di Adamo, va
bene una volta all'anno. Io lo consulto per passatempo; egli fa a modo
suo, io al mio, e andiamo d'accordo come marito e moglie. Ma tu,
piuttosto, perchè non rompi il tuo, e non te lo levi dai piedi?

--Bravo! e la gente di servizio? Esso è in casa un arnese necessario,
fatale, come la noia per me; il suo _tran tran_ ha dato la misura al
tran tran della mia esistenza. Rompessi anche il pendolo, la mia vita
monotona suonerebbe, io credo, le ore e i quarti d'ora in vece sua. Oh
Felice, felice te che non ti annoi!

--E non mi avverrà mai fin ch'io viva:--rispose Magnasco;--io ho per
cotesto un segreto infallibile.

--Dove si vende? ch'io vo subito a comperarlo, senza nemmanco levarmi
questa zimarra di dosso....

--Oh, non tanta furia! Tu non hai bisogno di andare dallo speziale per
questo. Fa a modo mio; abbandonati all'ignoto. Non chiedere mai a te
stesso: «che cosa debbo io fare quest'oggi, per passar mattana?» Vedi,
Fenoglio; io non mi sono mai così divertito, come un giorno che uscii
di casa nell'intento di annoiarmi. Lascia operare il caso. Passi per
una strada? Non isvoltare alla solita cantonata; va innanzi. Là
troverai quell'amico che andavi cercando al caffè, e che, svoltando
alla cantonata anzidetta, non avresti trovato di certo. Là vedrai una
bella merciaia, che ti venderà un fazzoletto, mezzo seta e mezzo
cotone, che regalerai poscia alla cameriera della tua bella, col
risparmio di tre lire. Là vedrai una sconosciuta; la seguirai, e ti
buscherai un dolce sorriso da lei, o un duello coll'amante; le quali
cose ti condurranno in un altro ordine di pensieri e di conoscenze,
che tu non avevi, uscendo di casa, e che potranno anche mutare del
tutto il tuo sistema di vita. Insomma, non ragionare innanzi di fare,
ragiona dopo; non andar colla testa, ma coi piedi; fa conto insomma di
giuocare a mosca cieca.

--Ma....--soggiunse Roberto Fenoglio,--e se dò del naso in qualche
spigolo?....

--Gli è,--rispose gravemente Magnasco,--uno tra gli sconci di questa
teorica, per altro bellissima.

--Orbene, mi proverò;--disse Roberto. E intanto si stiracchiava sul
canapè, sbadigliando di bel nuovo.

Felice se ne avvide e fu sollecito ad alzarsi.

--Il tuo sbadiglio,--diss'egli,--mi prova che debbo partire. Diamine!
le quattro suonate! Ed io già avevo dimenticato lo scopo della mia
fermata! Fenoglio, sai? debbo chiederti un servigio....

--_In manus tuas, domine._ Ti occorre denaro? Bada che non potrei oggi
imprestarti più di duemila lire.

--Che! non ho bisogno di denaro, sibbene di un servigio assai più
rilevante e più delicato.

--Un duello?

--Quasi; vo' prender moglie.

--Ah, per tutti i diavoli! _e come e quando nacque tal fiamma in te!_

--La storia sarebbe troppo lunga a raccontarsi ora,--rispose
Magnasco,--ed io ho bisogno di riposare almanco tre ore, innanzi di
tornare da te.

--Tornare! ma come? perchè?

--Eccoti il negozio in poche parole. Io ho una cugina....

--La vedova?

--Per l'appunto; la conosci forse?

--No, in fede mia; me ne hai parlato tu stesso qualche volta, e ancora
poco fa, mi dicevi....

--È giusto, vedi che bestia! Or dunque, mia cugina, la vedova, è una
crudele quanto adorata beltà, e quando io le parlo di amore, ella si
mette a ridere. Io le accenno cori, ed ella mi risponde picche.

--Che c'entro io nel vostro _tresette_?

--Tu puoi venire da lei; le ho già parlato di te, come d'uomo a modo,
rispettabile, assennato....

--Ti par proprio ch'io sia tutto ciò; Felicino?

--Io ti presento a lei,--proseguì, senza turbarsi, Magnasco,--e tu
perori la mia causa; non subito, ci s'intende, ma a poco a poco, con
delicate entrature.... mi capisci? Colla tua parlantina di Cicerone,
puoi essermi molto utile. Le fai vedere che buon partito sarebbe per
lei sposare un giovane par mio, gentile di modi, dolce di umore, e
molto avveduto in materia d'interessi....

--E ti par proprio d'essere tutto ciò, Felicino?--chiese Roberto
Fenoglio.

Felicino anche qui fece orecchie da mercante, e tirò innanzi nella sua
orazione.

--Mia cugina è ricca, e il suo fattore la deruba a man salva, la
spoglia....

--Ah! codesto gli è grave!--interruppe Fenoglio,--spogliarla eziandio?
Questo è un cumulare gli uffici di fattore e di cameriera, e capisco
che, se la cugina è bella, siccome m'hai detto, ti spiacerà
maledettamente che altri faccia questo uffizio presso di lei. Ah, ah,
che te ne pare di questo?

--È stiracchiato più degli altri;--rispose Felicino.--Ma dunque, vuoi
rendermi questo servigio?

--Ci stavo appunto pensando. Tu vuoi far di me una specie di Barbiere
di Siviglia.....

--Potresti supporre che....?

--Altro che supporre! lo credo, lo vedo; ma non importa. Se pensi che
i miei talenti oratorî possano giovarti presso di lei.... Ah,
Felicino! io ero nato per essere oratore! Basta, ti servirò; tu mi hai
dato il tuo specifico contro la noia, io ti son debitore del
ricambio.... se pur lo sarà! A che ora si va da lei?

--Sul mezzogiorno; ella è mattiniera come una allodola. Io dunque
verrò da te alle dieci: ti vesti, andiamo ad asciolvere insieme, e
poi, a piccoli passi, verso il tempio della diva. Addio, dunque, e
rammenta i miei consigli....

--Abbandonarsi all'ignoto....--disse Fenoglio.

--Sicuro;--soggiunse Magnasco,--lasciare operare il caso....

--E ragionar co' piedi;--conchiuse l'altro.--Non dubitare, Felicino,
ti imiterò fedelmente, servilmente, e comincierò a ragionare in tal
guisa, facendo il tuo elogio alla bella cugina.

--Se' arguto, per un mandarino!

--_A-ing-fo-hi!_--rispose con piglio di umiltà reverente Roberto
Fenoglio,--_A-ing-fo-hi._

--Che in cinese significa....

--Amico, te ne ringrazio di cuore.

--La si tira per tutti i versi, quella tua
frase....

--Ah, che vuoi? la è una delle prerogative della lingua cinese.--

E così, giostrando a sciocchezze, si separarono.

--Stattene a tuo bell'agio sdraiato,--disse Felicino a Roberto, che
voleva alzarsi per accompagnarlo in anticamera:--conosco la strada;
tirerò l'uscio dietro di me.

--_Fiat voluntas tua!_--rispose Roberto, a cui in quell'ora la
posizione orizzontale era dolce come a Magnasco il pensiero di sposar
sua cugina, o, per dir meglio, le sue cinquecento mila lire.

Alle quali cose pensando, e al soccorso che gli avrebbe prestato
Fenoglio contro la ostinata resistenza della cuginesca cittadella,
Magnasco se ne andò col cuore contento e il piè leggiero.

E andandosene, trasse l'uscio dietro a sè, siccome aveva detto a
Fenoglio; ma non badò punto a sincerarsi se la stanghetta della toppa
a sdrucciolo, che chiudeva la porta del suo amico, avesse battuto
nell'orlo della bocchetta, per modo da cacciarvisi dentro e chiuder
davvero.

Oh dio Caso, eccone delle tue!




II.


Roberto Fenoglio, come vi ho detto, era rimasto sdraiato sul suo
canapè; un soffice canapè foderato di velluto, dal quale io, se ci
fossi stato, non mi sarei mosso neanco per andare a nozze, e metto
pegno non vi sareste mosso voi, cortese lettore, neanco per mandare a
comperare il libro che mi dà modo di ragionare con voi.

L'annoiato mandarino stava fantasticando, tra la veglia e il sonno,
intorno ai consigli di Felice Magnasco.

--Vedete mo che ingegno ha quel capo ameno di Felicino! Egli è giunto
a sciogliere un problema, pel quale io mi vo beccando da dodici anni
il cervello. Abbandonarsi all'ignoto, lasciar operare il dio Caso,
ragionare co' piedi, equivale a sfuggire il _tran tran_ della vita.
L'equazione è perfetta, e un matematico non ci troverebbe nulla a
ridire. Applichiamola dunque!... E prima di tutto, che cosa farò io
tra dieci minuti? che bestia! cominciavo a ragionare! non debbo, non
voglio sapere, che cosa farò tra dieci minuti.... Auf! che sonno!
andiamo a dormire; sarà la miglior cosa che io possa fare. Felicino
dovrà tornare stamane per condurmi dalla sua bella cugina, e non posso
andare da lei morto dal sonno. E da capo! No, io non debbo andare a
dormire; la è cosa troppo usuale; io ricasco nella consuetudine, e
questa io debbo sfuggirla ad ogni costo. Eccomi qui, su questo
canapè... Ci sono a caso.... Chi ardirebbe asserire che io non ci sono
per mero caso? Che cosa mi accadrà egli di nuovo su questo canapè?
L'ardua sentenza ai posteri. Che sonno! andrei volontieri a letto....
Ma via, Fenoglio, non lasciarti così vilmente sopraffare dalla
ragione! Si direbbe che hai paura dell'ignoto. Chi è questo signor
ignoto?... È brutto o bello? E la cugina di Felice, è bella davvero
come ei la dipinge? O non l'ama piuttosto per le sue ricchezze? Già,
volere o non volere, il denaro si ficca sempre dappertutto. Diciamo di
no; sacramentiamo che non è vero; ma la ricchezza comanda agli occhi
del nostro corpo, come a quelli della nostra ragione.... Ma chi sa?
potrebbe anco esser bella, questa cugina!...

Lettrici e lettori, io vi fo grazia di tutte le altre considerazioni
scucite del mio protagonista. La pigrizia, più assai de' consigli
dell'amico, lo aveva tenuto sul canapè, dove, pochi minuti dopo, egli
era rimasto assopito.

Non vi giurerei che le copiose libazioni dello sciampagna spumante non
c'entrassero anch'esse per una larga porzione. Roberto Fenoglio era
uomo che non disprezzava punto il bicchiere, e quella notte, poi, in
mezzo ad una brigata di capi scarichi e di gaie alunne di Tersicore,
egli aveva pensato a dare il buon esempio, bevendo allegramente per
quattro.

Dormi, Fenoglio; dormi, mandarino annoiato; il tuo sonno non vuole
durar molto.

Imperocchè, voi già lo avete indovinato, belle lettrici e lettori
cortesi, io non lo lascierò solo sul suo canapè, e non prolungherò la
_scena muta_ oltre i confini della vostra pazienza.

Venite con me verso l'uscio di casa. Non udite su per le scale un
muover di passi frettolosi e leggieri? Non abbiate timore di ladri;
insieme co' passi, s'ode il fruscìo di una veste di seta.

Chi è questa donna che sale, o, per dir meglio, che vola, sfiorando
appena del piede e del lembo della sua veste gli scalini, e si ferma,
si rannicchia spaurita, tremante, ansante, sul pianerottolo, vicino
all'uscio semichiuso di Roberto Fenoglio?

Aspettate, e lo saprete. La bella incognita (imperocchè essa è bella,
ed io già lo so, quantunque siamo tuttavia al buio), la bella
incognita, dico, rattiene colassù la sua corsa, e raccolte intorno a
sè le larghe pieghe del suo accappatoio di seta, tende l'orecchio per
cogliere ogni più lieve rumore che possa giungere dal basso. Non ode
nulla, e le si allarga il cuore; perciò, fattasi più animosa, si
attenta di sporgere il capo sulla ringhiera.... Ma ohimè! Appunto
allora comincia ad udirsi giù in fondo alle scale uno stropiccìo di
piedi, quindi un rumore confuso a cui tien dietro lo scoppiettìo di un
zolfanello strofinato su d'una ruvida superficie, e un raggio di luce
balena dal pozzo della scala.

La povera bella si rannicchia da capo nel suo angolo, ma non istà
ferma al suo posto neppure un minuto secondo.

--Dio mio! come fare?--ella mormora tra sè,--dove potrò salvarmi!--

Tremante, confusa, ella si avanza a tentoni, brancicando verso la
parete, come per cercare le imposte di un uscio; che certo ha da
trovarsi su quel pianerottolo. Ella suonerà, domanderà soccorso.... ma
giungeranno in tempo ad aprirle? Chi sa? intanto ella va cercando
colle mani il vano di quest'uscio e la corda del campanello, ma senza
pro. La sua manina leggiadra (io lo so, quantunque siamo al buio, e la
conoscerei tra mille), la sua manina leggiadra, dico, erra un tratto
nel vuoto, quindi urta in uno dei battenti dell'uscio; ed oh
maraviglia! il battente si apre da sè, e il pianerottolo si rischiara
d'un subito, all'interna luce dell'anticamera di Roberto Fenoglio.

Benéfici effetti della trascuratezza di Felicino Magnasco, che non
aveva badato a far scorrere la stanghetta della toppa a sdrucciolo
nella sua rispettiva bocchetta! Oh caso, caso! E i filosofi verranno
poi a sostenere che esso non è l'ordinatore, anzi l'azzeccagarbugli
delle umane vicende?

La povera bella fu, sulle prime, come sbigottita da quello aprirsi
improvviso dell'uscio, al semplice tocco delle sue dita. Quel
quartierino aperto, e in apparenza deserto, le metteva paura. Tremò
tutta dal capo alle piante, e si ritrasse fin presso la ringhiera. Ma
di là tornava ad udire il rumore dei passi, e al rumore dei passi si
mescolava il discorso di due persone che salivano, del qual discorso
giunse fino a lei spiccatamente una frase: _andiamo su, ella non ci
sfugge di certo_. E allora la poverina si fece animo, guardò in alto
come per chieder protezione dal Cielo innanzi di commettersi
nell'antro ignoto di quel quartierino, che si schiudeva luminoso a'
suoi occhi, e si buttò perduta nell'anticamera. La sala era deserta;
imperocchè l'unico servitore di genere mascolino che fosse in quella
casa, trattandosi di una festa un tal po' scapigliata, aveva avuto
licenza di andarsene a letto dopo l'ultima versata di sciampagna, e la
licenza gli era paruta un comando. La bella sconosciuta non ardì
nemmeno richiuder l'uscio; chè le sembrava di cadere di Scilla in
Cariddi, e non voleva precludersi la ritirata da un male peggiore. Si
inoltrò guardinga fino ad una portiera di seta azzurra; stette incerta
un tratto, quindi si provò a sollevarla dolcemente, sporse la sua
testolina nel vano, e le si parò davanti agli occhi lo spettacolo del
mandarino dormente.

--Ah? Che vuol dir ciò?--chiese tra sè, con atto di meraviglia, la
sconosciuta visitatrice. Di maraviglia, notate, non di paura!

Un uomo che dorme non fa paura ad una donna. Giaele, Giuditta, e tante
altre donne famose di quella risma, ne fanno testimonianza non dubbia.
La nostra sconosciuta, che non aveva nè chiodi di configger nelle
tempia a Sisara, nè testa da troncare ad Oloferne, e che però ci aveva
la coscienza tranquilla, dopo quel primo atto di meraviglia, compose
le labbra ad un sorriso; un bel sorriso, in fede mia, e che
illeggiadriva di molto le sue bellissime labbra.

Essa era bella, mio candido lettore, bella quasi come voi, mia adorata
lettrice. Qui, poichè siamo alla luce dei doppieri (parlo in poesia,
ma in umile prosa bisognerebbe dire di una lucerna Carcel), cadrebbe
in acconcio uno scampolo di descrizione della sua ammirabile bellezza.
Ma siccome non ho tempo da perdere, lascio che ve ne formiate voi un
concetto colla fervida immaginazione, mio candido lettore, e che ve la
raffiguriate voi, guardandovi nello specchio, mia adorata lettrice.

--Un cinese?--pensò la sconosciuta, guardando Fenoglio.--O dove
diamine son capitata? E nessun altro in questa casa.... non una donna
a cui volgermi.... E quei due che salgono le scale!... Dio mio che
faccie sinistre! E come mi correvano dietro! Ah! essi sono già qui,
sul pianerottolo.... urtano nell'uscio.... Ma io non l'ho chiuso, non
l'ho chiuso! E come fare adesso? Signore! signore!--

Ma sì, chiamalo, Roberto Fenoglio aveva legato l'asino a buona
caviglia, e non dava segno di volersi svegliare.

Ella ripetè, collo stesso tono di voce sommessa con cui aveva
cominciato a chiamarlo: signore! signore!

--_A-ing-fo-hi!_--borbottò nel sonno il bravo mandarino Fenoglio.

Cotesto non era rispondere, siccome ognun vede. La povera bella,
sgomentata dal rumore che si faceva sul pianerottolo, ebbe ricorso ad
uno stratagemma simile a quello del fagiano quando tenta di
nascondersi agli occhi del cacciatore, ficcando la testa sotto un'ala;
buttò l'accappatoio sotto una poltrona, che stava di fianco al canapè
del mandarino, e si lasciò cadere su quella poltrona, rimanendovi
supina in atto di donna dormente.

--Ohè, Piccione! una porta aperta....

--Vedo bene; la sarà entrata qua dentro, la fuggitiva.

--Impossibile! Avrebbe badato a chiudere l'uscio dietro di sè. Qui c'è
un altro negozio.... un furto consumato....

--Ragione di più per entrare!

--Sicuro, entriamo!




III.


Questo dialogo avveniva sul pianerottolo, tra i due persecutori della
bella sconosciuta, i quali non erano altrimenti due Adoni da
quadrivio, sibbene due sergenti di Questura, il Negri e il Piccione.

Lo strepito dei loro passi mascolini nell'anticamera e il percuoter
delle loro daghe contro le masserizie, fecero quello che non aveva
potuto ottenere la vocina della sconosciuta; vo' dire che destarono
dal sonno l'avvocato Fenoglio, il quale balzò in piedi dal suo canapè,
e vedendo alzare la portiera di seta e un braccio e una gamba
introdursi nel salotto, urlò prontamente: _ai ladri!_ e diè di piglio
ad una sedia di Chiavari, per servirsene come di una mazza ferrata
contro gl'invasori del suo domicilio.

--Si cheti, signore, si cheti!--disse il Negri facendosi innanzi.--Noi
non siamo ladri, nè gente che le voglia far del male. Guardi alla
nostra divisa.... Ma chi vedo? il signor avvocato....

--Roberto Fenoglio in carne ed ossa,--rispose Fenoglio, che a sua
volta aveva riconosciuto i sergenti;--ma che cosa vogliono le signorie
loro a quest'ora, in casa dei pacifici cittadini?

--Oh, la ci scusi, signor avvocato. Aveva l'uscio
aperto....

--Amico mio,--disse una vocina sottile che fece balzare due passi
indietro il mio protagonista,--gli è stato di certo quel briccone di
Battista, che va a ciaramellare di notte colla cameriera del quinto
piano. Bisogna scacciarlo dal nostro servizio, non è egli vero?

--Si certo, lo scaccieremo!--rispose Fenoglio.

E intanto guardava, con aria da melenso, ora i sergenti, ora la
sconosciuta, che lo aveva chiamato «amico mio.»

--Non vorremmo aver cagionata la disgrazia di un povero
servitore....--si provò a dire il Piccione.

--Che! che!--ripigliò la signora.--È un fannullone, un che so io; non
è egli vero, Roberto?

--Sì, un briccone, un ladro, un assassino!--soggiunse Fenoglio, il
quale non sapeva più quello che si dicesse.

--Oh, in tal caso,--disse il Negri,--con licenza di Vossignoria, lo
arresteremo.

--Sì, arrestatelo.... cioè, no, lasciatelo stare, povero diavolo! Son
questi i miei modi di dire.... io non uso chiamare con altri nomi la
mia gente di servizio....

--Egli bisogna tuttavia che tu gli tolga questo mal vezzo, Roberto
mio!--disse la donna, mettendo con leggiadra dimestichezza il suo
braccio sotto quello di Roberto Fenoglio.--Dimmi, non è egli vero che
tu contenterai in ogni cosa tua moglie?--

Fenoglio aveva l'aria di cader dalle nuvole. Si lasciò mettere il
braccio di lei sotto il suo; anzi, posso giurarvi che, galante
com'era, anco nei momenti più difficili, curvò con bel garbo il
gomito, per accogliere il dolcissimo peso. Quel braccio si appoggiò
sul suo con una pressione particolare, che parea dirgli: «tenetemi
bordone, per carità!»; gli occhi della sconosciuta si volsero languidi
a cercare una buona risposta ne' suoi; la sconosciuta era bella, assai
bella; il contatto della sua aggraziata persona gli recava una
commozione subitanea per tutte le vene, insomma, il sangue non è
acqua, siamo tutti uomini, e Roberto Fenoglio rispose:

--Si, moglie mia, farò di contentarti.--

Tutto ciò era avvenuto in un batter d'occhio. Ora, accettata una
condizione di cose, bisognava andare innanzi, mettere in buona vista
tutto quel garbuglio; e Roberto, comunque fosse impacciato, ci si
provò.

--Vedete un po' che bel caso!--disse egli, voltandosi ai
sergenti.--S'era suonato e ballato.... una festicciuola tra amici....
ai quali avevo fatto conoscere mia moglie....

--Ah sì!--interruppe il Negri.--Ella è ammogliato di fresco; noi nol
sapevamo neppure....

--Infatti,--disse Fenoglio,--io non ne avevo dato notizia a nessuno.

--Un matrimonio _al gran destino_....--entrò a dire con aria peritosa
il Piccione.

--Come sarebbe a dire; al gran destino? Vorrete dir clandestino?
Sicuro, ho fatto un matrimonio clandestino; ma ora l'abbiam propalato;
tutti gli amici, i parenti, Genova tutta lo ha da sapere.--

Così dicendo, Roberto Fenoglio si volse a guardare la sua improvvisata
metà, che lo ricompensò delle sue parole con uno sguardo d'ineffabile
tenerezza.

--Che io possa morire, se ne capisco un'acca!--pensò egli tra sè.

--Oh ce ne rallegriamo grandemente con Vossignoria!--disse il
Piccione, che era il più cerimonioso dei due sergenti.--E ce ne
rallegriamo anche colla sua signora....

--Grazie, grazie!--rispose la leggiadra donnina, accompagnando le
parole col più grazioso dei suoi divini sorrisi.

--Suvvia, Piccione:--disse il Negri al compagno--noi adesso
disturbiamo....

--No, no, amici miei!--interruppe Fenoglio.--Voi non ve ne andrete
così senza aver prima bevuto un bicchiere.

--Scusi Vossignoria: ma noi eravamo venuti in questa scala per seguire
una donna.... una....

--Che cosa?--domandò con molta curiosità il padrone di casa.--Avete
detto una.... Se la cosa può dirsi, finite, di grazia, la frase!

--Oh, niente di male in quanto alla moralità personale....--

Fenoglio respirò a larghi polmoni. Intanto il Negri proseguiva:

--....Insomma, debbo dirlo? Si tratta di una emissaria di Mazzini. Il
signor Questore ha saputo che questa donna, una delle più terribili
cospiratrici contro il governo, è venuta da Londra a Genova, e che
ella doveva trovarsi appunto in una casa qui presso.... Le nostre
passeggiate debbono averla messa in sospetto di qualcosa, poichè una
donna appunto (ed era certamente lei) è uscita dalla casa in discorso;
ma, inseguita da noi, s'è ficcata nelle scale di questo palazzo....

--Ah diamine!--esclamò Roberto Fenoglio.--E adesso come farete a
trovarla?

--Ella a quest'ora avrà potuto ridiscendere le scale!--si affrettò a
soggiungere la signora.

--Sicuro! dice bene la signora Fenoglio!--gridò il Piccione,
percuotendosi la fronte colla palma della mano.--Vedi che bestia siamo
stati noi altri! Ma qui bisogna correre.

--Non tanta fretta!--interruppe ella sorridendo.--A quest'ora ella ha
potuto andare molto lunge, e come vorreste trovarla! Gli è un colpo
fallito, al quale non si rimedia, e sarà meglio vi ricordiate che il
mio Roberto vi ha pregato di fermarvi ancora pochi minuti per berne un
bicchiere.

--La signora ha ragione!--disse il Negri con aria melanconica.--Ora,
poichè la ci è sfuggita, beviamo.

--Signor avvocato,--ripigliò il sergente Piccione,--beveremo alla
salute della sua signora moglie, che è tanto gentile quanto bella.
Scusi, signora, il complimento, compatisca; siamo gente alla
buona....--

Intanto Roberto Fenoglio era andato in una camera vicina e ne tornava
con una bottiglia di Sciampagna, che fu sollecito a sturare per quei
due ragguardevoli personaggi.

--Alla salute della signora Fenoglio!--disse il Negri, alzando il
calice spumante.

--Che il Ciel la benedica, e le conceda una mezza dozzina di bei
bambocci somiglianti al l'ottimo avvocato Fenoglio!--soggiunse il
Piccione.

--Grazie, amici, grazie!--rispose Fenoglio.--Noi faremo di non mandar
vani i vostri amorevoli augurii.--

E guardò sott'occhi la sua sconosciuta vicina, che si fe' rossa in
volto come una ciliegia.

Intanto quei due, sebbene, dopo una seconda e una terza libazione,
avessero veduto il fondo della bottiglia, non se ne andavano ancora.
Fenoglio era sulle spine, poichè gli premeva di sapere chi fosse
quella donna, e come gli fosse capitata in casa. La donna, dal canto
suo, ci doveva avere le sue buone ragioni, per affrettare coi voti la
loro partenza.

Il Negri, dopo una sosta di parecchi minuti secondi, così prese a
parlare:

--Signor avvocato, la mi scusi; avrei a chiederle.... ma non mi dia
dell'indiscreto....

--Oh, niente affatto!--rispose Fenoglio.

--Sì, sì, la è una indiscretezza la nostra.... ma tant'è, non possiamo
fare a meno di pregarla....

--Ahi, ahi!--pensò il mandarino--che cosa vuole ora costui?--

La povera bella, di rossa ch'ella era divenuta, si fe' più pallida di
prima.

--Vossignoria,--proseguì il sergente, senza addarsi di nulla,--è in
relazione col nostro capo, il cavalier Gallesi....

--Sicuro, sono in relazione con lui, con quella degna
persona;--rispose Roberto.--Lo vedo qualche volta ed ho l'onore del
suo saluto. Ma che cosa....

--Ecco;--interruppe il Negri,--noi abbiamo fatto il nostro dovere,
niente più niente meno del nostro dovere.... Ma se il signor cavaliere
venisse a risapere che ci siamo lasciati sfuggire.... mi capisce?

--Ah! sì, capisco,--disse Fenoglio, tornando a respirare
liberamente,--io non debbo dir nulla. Non dubitate, sarò muto come una
tromba.... cioè no, volevo dirle come una tomba. Che diamine! vedete
mo' come talvolta ci tradisce la lingua.--

Non era vero niente; Roberto Fenoglio, rasserenato dalla piega che
aveva preso il negozio, tornava ai suoi primi amori col bisticcio.

--Le siamo riconoscentissimi della sua bontà, signor avvocato!--entrò
a dire il Piccione, colla lingua impacciata dallo Sciampagna.--In
verità non potevamo aspettarci altro da un galantuomo pari suo. Oh se
tutti fossero come Vossignoria, a questo mondo!

--Taci là, bestione!--interruppe il Negri, che voleva schiccherare
anch'egli un complimento all'avvocato.--Se tutti fossero come il
signor cavaliere....

--No, no, lasciate i titoli da parte, io non son cavaliere e me ne....
me ne.... insomma, non lo sono!--conchiuse Roberto.

--Il governo ha torto!--sentenziò il Negri.--Io lo servo, lo rispetto
e lo venero, come è debito mio; ma egli ha torto a non far cavaliere
un personaggio come Vossignoria. Basta, io non c'entro.... Che cosa
dicevo, Piccione?

--Dicevi che se tutti fossero....

--Ah si, mi ricordo; volevo dirti che se tutti fossero come il signor
avvocato, noi perderemmo il nostro pane, perchè non ci sarebbe nulla
da fare nel nostro mestiere.--

E accompagnate queste parole con un inchino, il Negri si congedò
dall'avvocato Fenoglio, pregandolo, scongiurandolo da capo a condonar
loro la molestia che gli avevano involontariamente recata.

Così finì quella scena, che poteva avere ben altre conseguenze per uno
dei due personaggi rimasti. Fenoglio accompagnò i due sergenti fino
all'uscio di casa, e questa volta lo chiuse egli, colla debita
attenzione, anzi con due mandate di chiave.

Quindi tornò nel salotto, dov'era rimasta la sconosciuta, e, giunto
sul limitare, si fermò, sporgendo il capo verso di lei, in aria d'un
maiuscolo punto interrogativo.




IV.


La bella ignota era caduta sulla poltrona accanto al canapè. Lo sforzo
di quella scena difficile l'aveva svigorita per modo da non sentirsi
più reggere in piedi.

--Oh, signore!--mormorò ella, più che non dicesse--la mia
gratitudine....

--Nulla, nulla, non mi ringraziate!--interruppe il mandarino.--Ditemi
piuttosto, se non è un prentender troppo, chi siete voi, o signora,
voi che vi fate di punto in bianco mia moglie, mi togliete dalla
fronte quell'aureola di vergine.... e martire, la quale mi si
confaceva pur tanto?

--Signore....--balbettò la povera bella,--o signore.... voi siete così
buono, avete un cuor così nobile....

--Signora, io non ho cera qui sotto le mani per turarmi gli orecchi,
come fece Ulisse, allorquando egli ebbe a trovarsi in un caso simile
al mio; ma vi giuro che, se voi proseguite a parlarmi così dolcemente,
io supplirò alla cera colla palma delle mani.--

E dicendo queste parole, le quali arieggiavan assai più il madrigale
che l'invettiva, Roberto Fenoglio fe' il doppio gesto di un uomo che
vuol turarsi gli orecchi.

Era grazioso in quell'atteggiamento, il nostro mandarino posticcio; e
la signora, quantunque il momento non fosse da ciò, non potè
rattenersi dal ridere.

--Ah, vi pigliate anche giuoco di me, bella e terribile
sconosciuta?--incalzò Roberto Fenoglio.--Avete ragione, in fede mia.
Eccomi ammogliato senza saperlo, e con chi? con una donna
_contemplata_ dall'articolo 185 del Codice penale.

--Oh!--esclamò la signora alzandosi in piedi.

--Non vi adirate per sovra mercato, signora!--fu sollecito a
soggiungere Fenoglio.--L'articolo 185 non può offendere la dignità
della donna. Ma in fine, i fatti _enunciati_ vi accusano; la
prevenzione è contro di voi. Chi inseguivano quei due degni tutori
dell'ordine pubblico, se non voi? se non una.... _horresco
referens_.... una rivoluzionaria?

--Mio buon signore,--disse la sconosciuta, accennandogli con atto
leggiadro, che volesse chetarsi un tratto,--io vi prego, per quella
cortesia che m'avete dimostrata fin qui, ad usar pazienza ancora un
tantino. Tutto quello che è avvenuto stanotte ha bisogno di una
spiegazione, e voi, gentile come siete, mi darete agio ad esporre le
mie ragioni.

--Tolga il Cielo che io voglia condannarvi senza ascoltarvi--rispose
Roberto Fenoglio.--Non siamo più ai tempi della inquisizione, la Dio
mercè, ed io son qui tutto orecchi ad udirle, queste vostre ragioni.

--Or bene, signore, parlerò.... Ma anzitutto, voi siete un gentiluomo,
e....

--E me ne vanto, signora! Ho sempre saputo custodire i segreti che mi
furono confidati, e tanto più facilmente, in quanto che io sono l'uomo
più smemorato che viva sotto la cappa del cielo. Tutto ciò che ode il
mio orecchio destro non ha neppure il tempo di giungere all'orecchio
sinistro, che io già l'ho dimenticato.

--Tanto meglio! Sappiate dunque che la rivoluzionaria c'è, e appunto
quella che i due uomini della Questura cercavano....

--Ah! voi lo confessate? Ma come mai una così leggiadra donnina
(scusate la schiettezza, ma io amo dire anzitutto la verità, la pura
verità, niente altro che la verità), come mai una così leggiadra
donnina, quale voi siete, va a ficcarsi in questi viluppi?

--Ringrazio i vostri occhi dell'inganno in cui mostrano
d'essere,--rispose ella, sorridendo traditorescamente,--ma non debbo
lasciar del pari in errore il vostro giudizio. Quella rivoluzionaria,
di cui si parla, non sono io; siete contento?

--Respiro, signora, respiro; ma proseguite, di grazia!

--Ecco dunque;--continuò la signora,--questa rivoluzionaria è mia
amica. Rivoluzionaria! Anche il vocabolo è improprio, imperocchè essa
non è che la moglie di un ottimo cittadino, il quale è condannato nel
capo e vive lontano dal suo paese, amandolo da lungi e facendo voti
perchè si muti quest'ordine di cose, che nessun italiano di core....

--Dovrebbe tollerare!--conchiuse Roberto Fenoglio.

--Ah, son lieta di parlare con un uomo!--disse la signora, stendendo
la mano a Roberto, che l'afferrò prontamente e vi stampò un rispettoso
bacio, se pure è vero che i baci siano una testimonianza di rispetto.

Ella ritrasse dolcemente la sua mano e proseguì:

--La mia buona Erminia (così ella si chiama) non è qui venuta per
cospirare, sibbene per vedere un suo figliuoletto che ha lasciato a
Genova in casa de' suoi congiunti, e che da qualche settimana era
infermo. La poverina, giunta ieri, mi ha fatto pregare stanotte di
recarmi da lei, e voi potete argomentar di leggieri che io non
mettessi indugio a contentarla. Il mio servitore mi accompagna fino
alla porta, e lo rimando a casa per maggior precauzione. Ora ecco che,
mentre io salgo le scale, odo rumor di passi.... intimorita, mi
ritraggo; essi mi hanno sentita, e giù per le scale verso di me!
Allora io non so più quel che mi faccia, esco fuori, e senza pure
voltarmi indietro, vengo a rifugiar nel portico di questo palazzo,
sperando che non mi abbiano veduta ad entrarvi. Ero in errore; mi
seguono; io salgo pian piano fin qui.... trovo un uscio aperto, e voi
sapete il rimanente, voi che mi avete presa a proteggere, senza pur
sapere chi io mi fossi. E di ciò permettete che vi ringrazi, o
signore, poichè, sebbene per me non avessi nulla a temere, la mia
dignità di donna era tuttavia a repentaglio, nel trovarmi sola, di
notte, e inseguita a quel modo!... Ah, mio Dio? rabbrividisco al solo
pensarvi.

--Avete ragione, signora,--disse Roberto, com'ella ebbe finito il suo
discorso,--avete ragione. Una donna sola, di notte, e così bella, come
voi.... Ma perchè siete voi così bella?--

E uscendo in questa esclamazione, improvvisa, Roberto Fenoglio mandò
un lungo sospiro.

--Che cosa avete?--domandò ella a sua volta.

--_A-ing-fo-hi_!--rispose egli sospirando da capo.

--E che cosa vuol dire quest'altra frase?

--Vuol dire, o signora.... Ma anzitutto, mi promettete di non andar in
collera?

--Ve lo prometto, purchè non mi diciate
complimenti.

--Oh, saranno verità sacrosante: vi dirò quello che sento e nulla più.
Sapete voi che cosa avvenga allo zolfo quando un raggio di sole,
attraversando il fuoco di una lente, viene a percuotergli sopra?

--Credo che si accenda, ma non potrei giurarlo, perchè non m'intendo
di fisica.

--Oh, giuratelo, signora mia, giuratelo pure! Cotesto è avvenuto a me,
dacchè voi siete entrata qui, cioè, mi spiego, da quando io mi sono
svegliato. Voi siete il raggio di sole; l'occasione bizzarra che vi ha
condotto qui è la lente; lo zolfo infine sono io, Roberto Fenoglio,
avvocato, e scapolo per giunta. Siete nubile voi?

--No, signore.

--Ah! c'è un marito!...

--Neppure; egli c'è stato.

--Siete vedova, dunque! Vedova! oh dolce nome! siete vedova, e siete
bella! Ma tutto ciò è un sogno.... Abbandonarsi all'ignoto! lasciar
operare il caso!... L'ignoto è venuto, il caso ha operato un miracolo!

--Che dite voi ora?

--Lasciatemi dire, o signora; parlo col mio angelo custode. Non
credete che io ci abbia un angelo custode? È lui che vi ha condotta
quassù: consentite che io adori in voi i decreti della divina
Provvidenza. E l'esservi voi dichiarata mia moglie non è forse una
voce del cielo? La vocazione di Abramo è stata determinata da assai
più lievi cagioni. Insomma, o signora, vengo difilato alla conclusione
del mio discorso, che vi sarà parso sconclusionato; ma io m'intendo e
basta. Che direste voi di un uomo non vecchio, nè al tutto sgradevole,
e con ventimila lire di entrata senza contare uno zio materno,
decrepito, senza figli, e con mezzo milione?

--Direi,--rispose la signora che sapea stare alla celia,--ch'egli è un
uomo fortunato.

--Non mi avete inteso; mi spiegherò meglio. Che direste di quest'uomo,
se egli vi proferisse la mano, dopo avervi umilmente chiesto la
vostra?

--Direi ch'egli è un bel pazzo, a concepire di così fatti disegni e
più pazzo ancora a dirli a me, la prima volta che egli mi vede, e in
una somigliante occasione.--

Roberto Fenoglio chinò il capo e lasciò cader le mani penzoloni lungo
i braccioli della scranna sulla quale era venuto a sedersi per
cominciare il suo dialogo.

--Tutte così, le donne!--esclamò egli, sospirando.

--Tutte così, voi dite? e perchè di grazia?

--Perchè?--ripetè con accento di amarezza Roberto Fenoglio.--Voi mi
chiedete ancora il perchè! Perchè esse si dilettano a tormentare il
cuore di un uomo, lo girano e rigirano per tutti i versi, scherzandovi
su colle loro unghie feline che lacerano dovunque toccano e fanno
spicciare il sangue. Dite loro: _vi amo_, lo dite con tutta la
sincerità dell'anima vostra, ed elleno vi ridono sul viso con aria
d'incredulità. Per esse l'amore non esiste che allo stato di
vecchiezza; lo fanno nascere dalla consuetudine, vi negano ch'e' possa
essere il risultato di una commozione subitanea. L'amore per gradi;
che bella cosa! Ma qual è, dopo quant'altri gradi incomincia quello in
cui si può dire _vi amo_ ed esser creduti? Io mi ribello, o signora,
contro questa falsa teorica. Voi stessa, che la lodate palesemente,
non ne credete in cuor vostro una jota. Ma essa vi torna acconcia per
guadagnar tempo, per pigliarvi diletto dei nostri tormenti... Orvia,
signora, non crollate la vostra testolina a quel modo! Lasciatevi dire
la verità da un uomo che riceve per la prima volta la scossa
elettrica! Io non ho amato mai, sebbene molte fiate siasi potuto
argomentare il contrario, da certe vaghe apparenze. Questo affetto che
io vi confesso candidamente ora, è già padrone di me. Se la cosa
dovesse procedere diversamente, se io dovessi innamorarmi di voi a
gradi, a gradi, avreste ragione a non usarmi misericordia, perchè io
sarei un uomo da nulla. Come è nato questo amore? Non lo so. La novità
del caso era fatta piuttosto per ispirarmi la diffidenza; ma non ne fu
nulla. Se debbo confessarvi un mio sospetto, vi dirò che vi ho amato
in quel momento che avete posto il vostro braccio sotto il mio. In
quella dolce pressione che volea dirmi: _salvatemi_! io ne ho sentito
un'altra che diceva: _amatemi_. Ho inteso la vostra preghiera, ho
accettato il vostro comando; perchè una corrente elettrica mi ha
signoreggiato ad un tratto. E subito, comunque turbato, ho messo ogni
mia virtù a tornarvi utile. Chi, se non il cuore, mi ha detto allora
che voi eravate una gentildonna? Sì, una gentildonna; questa
persuasione si è trasfusa a quel contatto in tutto l'esser mio, ed io
non ho sospettato di sapere il vostro nome per obbedirvi, come non lo
chiedo ora, innanzi di confessarvi che vi amo. E adesso ridete pure,
ridete liberamente di me!

--Perchè riderei?--chiese la sconosciuta, con piglio soave.--A
schietto parlare schietta risposta. Che cosa direste voi di una donna,
la quale, alle prime parole di un uomo che ella vede per la prima
volta, gli rispondesse: vi credo, e accettasse di grand'animo l'amor
suo?

--Direi che ella è una donna superiore a tutte le altre, o, per rubare
una sua magnifica frase al divino Petrarca, «_colei che sola a me par
donna_.»

--No, signor Fenoglio, non lo direste, o, dicendolo, non lo
pensereste. Se questa donna non conosce ancora quest'uomo....

--Ma neppure io, o signora, conoscevo voi, e tuttavia....

--Gran bella ragione!--interruppe la donna.--Vedete mo il gran risico
che correvate voi! Ed è egli possibile che il vostro senno non vi
dimostri la grave, la profonda differenza che corre tra un cuor d'uomo
e un cuore di donna? Che sacrifizio fa l'uomo ad amare e a dirlo, egli
tentatore, egli padrone di perdere nel giuoco quel tanto appena che ha
messo di posta? Noi, povere donne, quando amiamo (il che più veramente
ci avviene che a voi, e con più violenza di subitanea passione che voi
non crediate) paghiamo i nostri errori col dispregio di noi medesime.
Non parlate più? Non crollate più a vostra volta il capo, in segno di
incredulità? Vedete pure che non avevate ragione, e, schietta come
sono, vo' confessarvelo. Ho detto testè: _se questa donna non conosce
ancora quest'uomo..._ e ho detto male, poichè io già vi avevo
conosciuto, sebbene da mezz'ora, più addentro che se la nostra
conoscenza già contasse anni di vita. Siete un galantuomo e un
gentiluomo, ed io vi ho veduto alla prova. Credete pure che io so
rendervi giustizia! Noi povere donne non possiamo parlare liberamente
come voi fate.... E per legge di natura, e per vincolo di educazione,
noi siamo il sesso debole; non abbiamo altra arma migliore in nostra
difesa che la diffidenza, la eterna diffidenza.

--Il sesso debole!--soggiunse Roberto.--Siamo noi il sesso debole!

--Quando ci amate, s'intende. Ma dura così poco in voi, questo stato
di malattia! La convalescenza è sempre assai pronta, e ripigliate
sempre le forze smarrite.--

Roberto Fenoglio rimase muto. Era quella la più eloquente risposta che
egli potesse dare alla sconosciuta. Ella aveva ragione sulle generali,
e sebbene egli non avesse torto nel suo caso particolare, non era
quello il momento per costringerla a riconoscerlo.

Perciò, tacendo egli, v'ebbe un tratto di pausa nel dialogo. Roberto,
colla fronte china, contava i pezzettini di marmo del suo pavimento a
mosaico; la signora guardava Roberto, aspettando che dicesse qualcosa.

E così guardandolo, e vedendolo silenzioso, le scese inavvertita in
cuore quella pietà traditora che è sorella dell'amore e che non ha
altro ufficio se non questo, di aprir l'uscio di casa al fratello.

--Povero giovine!--le susurrava al cuore la pietà.--Tu gli hai detto
di brutte cose, ed egli non ardisce nemmanco risponderti. Vedi com'è
contrito ed umiliato! Ora, lo hanno detto le sacre carte: _cor
contritum et humiliatum Deus non despiciet_. Egli ha una cera
simpatica, per verità! E poi, com'è gentile di modi! Come si è
adoperato volenterosamente a farti servizio! Quanti altri uomini, nel
caso suo si sarebbero diportati com'egli? Quanti altri, posti con una
donna sola, sconosciuta, in casa loro, non avrebbero piuttosto ceduto
a diverso consiglio? Gli uomini, in genere, sono un'assai brutta
razza, animi volgari, carne impastata di fango.... Ma egli! povero
giovine! Suvvia, bisogna ricompensarlo con una dolce parola!--

E la cercò, la dolce parola; ma lì, sulle prime, non le venne fatto
trovarla. Trovò bensì un più soave accento e un più soave sorriso, per
dirgli:

--Or dunque, signor Fenoglio, voi sarete il mio cavaliere, per
accompagnarmi a casa. Non è egli vero?

--Come vorrete, o signora, come vorrete. Vado subito a levarmi di
dosso queste ridicole insegne di mandarino cinese e sono ai vostri
comandi. Ma innanzi di partire udite ancora una parola, e sarà
l'ultima, ve lo giuro!

--Con che aria mi dite voi questo!--rispose la signora.--Siate più
gaio, ve ne prego; amo meglio udirvi a scherzare, come poco fa, che
parlar malinconico e guardarmi accigliato, come ora.

--Perdonatemi,--disse Roberto,--ma non posso far forza al mio
naturale. Sotto la forma di uno scherzo vi ho detto poco fa tutto
quello che il mio cuore sentiva. Vi ho profferto sinceramente e
prontamente la mia mano, perchè aveste a scorgere sulle prime la
purità de' miei intendimenti. Era quello il primo omaggio che io
dovevo rendere ad una donna come voi, al primo momento che sentivo di
amarla. Voi mi avete tolto in quella vece per un uomo leggero, per un
di quei capi scarichi che s'innamorano al primo uscio; ed ecco, io
porto la pena di aver fatto un giusto proposito e di non averne subito
dichiarato le lodevoli ragioni....

--Ah signore! E credete voi che io non le abbia pensate, tutte queste
cose gentili? Andate, andate a mutar abiti, senza fantasticare più
altro, poichè davvero stillandovi in questa guisa il cervello, non
siete più giusto, nè con voi, nè con me.

--Vado, signora, vado; ma ditemi ancora... io vi accompagnerò a casa!
me ne tornerò senza un conforto nel mio solitario quartierino da
scapolo.... E quei due che mi sanno ammogliato... che lo andranno a
ridire....

--È vero!--esclamò la sconosciuta, lasciando cadere la sua testolina
leggiadra contro la spalliera della poltrona.--Non ci avevo pensato!
Mi fate adesso riconoscere quanto io abbia operato sconsideratamente
con voi. Oh quanto me ne duole!--

E l'espressione del volto di quella donna fu così melanconica, nel
pronunciar ch'ella fece quel suo _me ne duole_, che Roberto Fenoglio
cadde ginocchioni a' suoi piedi, e, prendendola per mano, si fece a
dirle con accento concitato:

--Non vi addolorate, per carità! Ho detto una sciocchezza.... Ma dove
diamine l'ho pescata io! Piuttosto che vedervi piangere, mi ucciderei.
La gente dirà quel che vuole... mi crederà ammogliato; non me ne
importa; mi condannerò ad un eterno celibato, e non sarà un grave
sacrifizio per me, dopo quello che vi avrò fatto, di non riuscirvi
altrimenti molesto. Veduta voi, quale altra donna al mondo amerei?--

La pietà traditora inumidì leggermente le ciglia della sconosciuta.

--Avvocato,--disse ella con piglio di leggiadra dimestichezza,--voi mi
accompagnerete; saprete dove sto, ed io vi annunzio fin d'ora che sarà
sempre aperta per un gentiluomo pari vostro la casa di Laura
Moneglia....--

La folgore, cascata ai piedi di Roberto, non gli avrebbe fatto più
senso di quel nome e di quel casato che uscivano soavemente dalle
labbra della sua ospite leggiadra.

--Che?--gridò egli, balzando in piedi.--La cugina di Felicino
Magnasco?

--Conoscete mio cugino?--dimandò la signora Laura.

--Se lo conosco, signora... se lo conosco.... Figuratevi! egli era qui
seduto su quella medesima poltrona, mezz'ora innanzi che giungeste
voi, e mi stava pregando... mi stava dicendo.... Insomma, oggi stesso
e' doveva presentarmi a voi.

--A me? voi? Ah, mi ricordo... mi parlò di un signore, suo amico....
Sicuramente. Infatti il vostro nome non mi giungeva nuovo. Mio cugino
Magnasco parla molto bene, e meritamente, di voi. Orbene, che male c'è
che io sia sua cugina?

--C'è, o signora, che voi... già lo sapete... Felicino vi ama....

--Orbene, che mi ami!

--Ah! sta bene?--dimandò sbigottito Roberto.

--Si, certo, ma io non amo lui.--

A Roberto Fenoglio fu per balzar fuori un sospiro di contentezza; ma
si rattenne in tempo.

--Lo amerete più tardi;--si provò a dir egli.--Vi piegherete a' suoi
voti, alle sue preghiere. Felicino è un bel giovane, ha un ottimo
cuore....

--Tutto ciò che vorrete,--rispose la signora Laura,--ma egli non mi
piace oggi, e non mi piacerà domani, nè poi.

--Egli sta fresco, allora, il mio povero amico; ma cotesto non potrà
giovarmi, non farà crescere d'un punto le mie speranze, dopo la
promessa che gli ho fatta....

--Che promessa?

--Faccio male a dirvelo? Mi pare di no, poichè intanto avevate a
saperlo!... Di aiutarlo presso la sua divina parente, di persuaderla a
concedergli la sua mano.

--Ah! ah! un mirabile spediente! E come lo ha scelto bene tra
tutti!--gridò Laura, ridendo a più non posso.

--Signora, e perchè?

--Ma si, lasciatemi ridere per carità! Si vede che il mio cuginetto è
molto perspicace.

--Signora, io non so... non so se debba imbronciarmi o ridere con voi.

--Si, ridete, ridete! Tutta questa gaiezza non ha nulla che possa
recare offesa al vostro carattere, ve lo giuro!

--Mi fido di voi, bella signora, e rido anche io. Povero Felicino!

--Orvia, si fa tardi; andate a vestirvi.

--Sì, avete ragione; questa volta vado subito. Due minuti, e torno.--

Uscito Roberto dal salotto, Laura rimase sola a pensare. Che cosa
pensasse non vi dirò, poichè non sono mai penetrato nel cuore d'una
donna.

Dieci minuti dopo, Roberto Fenoglio ricompariva nel salotto, vestito
da cristiano, col suo abito nero di gala, il pastrano sul braccio e lo
staio in mano. Come avesse potuto spicciarsi a quel modo non saprei
dirvi. So che l'amore fa miracoli a palate, e non mi stupisco di
questo.




V.


Il mio protagonista, levandosi di dosso quegli abiti da cinese,
tornava quel che era, un simpatico giovinotto, se pure può dirsi
giovinotto chi ha passata di anni parecchi la fatale trentina. La
signora Laura lo guardò e i suoi occhi manifestarono una lieta
maraviglia. E invero la cosa non poteva essere diversa, poichè
l'avvocato Fenoglio, oltre all'avere un gentile aspetto, era
innamorato cotto; e l'amore, come tutti sanno (e se qualcheduno nol
sapesse, glielo dico io), abbellisce la gente, sia che conferisca più
vivacità allo sguardo, sia che impallidisca le guancie, secondo che è
lieto, o sfortunato per coloro che l'hanno nel cuore.

Quello di Roberto Fenoglio non potea dirsi ancora nè una cosa, nè
l'altra; era fresco di un'ora, ma era nato vigoroso come Ercole, di
cui narra la favola che, stando in cuna, strozzasse colle sue poderose
manine i serpenti. Il desiderio di piacere a quella bellissima donna,
il rispetto che sentiva per lei, sebbene l'avesse conosciuta in così
strana maniera, la stranezza medesima del caso che metteva, sto per
dire, un pizzico di sale su quel negozio, già di per sè saporito
abbastanza, tutto ciò trasfigurava Roberto Fenoglio. Se non temessi di
farmi dare dell'eretico, direi che quello era il suo Tabor, e che
intorno alle tempie egli ci aveva un'aureola.

--Dunque, signora,--diss'egli accompagnando le parole con un
grandissimo inchino,--poichè così volete, andiamo; io sono ai vostri
comandi.

--Voi siete un gentil cavaliere!--rispose la signora Laura.--Andiamo
dunque; mi sa mill'anni d'essere a casa mia.

--Questa sarebbe casa vostra, se voi voleste, o signora....

--Pazzo!--interruppe ella, e temperò la frase con un divino
sorriso.--Di ciò mi parlerete più tardi....--

Così dicendo ella seguì Roberto Fenoglio nell'anticamera fino alla
porta.

E qui avvenne un caso mirabile, strano, bizzarro, non mai più udito,
nè visto; un caso che io potrei darvi ad indovinare alle cento, alle
mille, alle diecimila, ma tanto e tanto non vi apporreste al vero; un
caso che parrà inverosimile, e che infatti è inverosimile davvero,
come è spesso inverosimile la verità.

Non vi è egli mai avvenuto, o lettori, di vedere un tramonto di sole,
di notarne gli strani colori, i più strani effetti di luce, e dire tra
voi che, se un pittore lo copiasse fedelmente, gli darebbero
dell'esagerato? Non vi è egli mai occorso di udire un fatto, o non
avete nella vostra storia particolare un caso tanto bislacco da farvi
dire, quando ve ne ricordate, che se un romanziere lo raccontasse, non
parrebbe vero a nessuno?

Orbene, uno di questi casi occorse per l'appunto ai miei due
personaggi; uno di questi tramonti toccò alla mia narrazione, la quale
non è un sole pur troppo!

Roberto avea posto la mano sulla chiave e faceva girar la stanghetta
per aprire. In quel punto, proprio in quel punto, si udiva una forte
scampanellata. Egli, sebbene quel suono improvviso gli urtasse
maledettamente i nervi, non fu più in tempo a fermarsi. L'uscio si
apriva sotto le sue mani, e un uomo si presentava nel vano. Questo
uomo fu sollecito ad entrare, e la prima persona che egli ebbe a
vedere (poichè Roberto, nello aprir l'uscio, si cansava per darle il
passo) fu la bellissima Laura Moneglia.

Chi era costui? Perchè al veder quella donna e' dava uno sbalzo
indietro, spalancando tanto d'occhi a guisa di spiritato?

Era Felicino Magnasco, che vedeva innanzi a sè la sua crudele cugina.

Fu un colpo di scena che io non vi starò a descrivere, e di certo non
potrei se pur lo volessi. Il fatto, l'atto istantaneo, non si dipinge;
lo scrittore non può mutarsi in fotografo.

Felicino Magnasco entrò coll'aria più impacciata che vi possiate
immaginare, e ne aveva ben donde. Roberto Fenoglio non lo era meno di
lui.

--Oh, buon giorno, Felicino!--esclamò egli, senza sapere che cosa si
dicesse.--Che buon vento ti porta quassù? Come va la salute?

--Bene, grazie; e la tua?

--_Optime_, Felicino, optime; e che cosa mi frutta una tua visita così
mattiniera?

--Ah sì!...--rispose l'altro.--È un'ora indebita... giungo in mal
punto....

--Ma no, Felicino, ma no... figurati! un amico come sei tu giunge
sempre gradito.

--Grazie da capo; ma lasciatemi raccapezzare...--soggiunse Magnasco.

--Sì, raccapezziamoci, vuoi sederti un tratto? Signora....--

La signora Laura intese com'egli le chiedesse licenza di fermarsi
ancora qualche minuto, e fe' per tornare nel salotto.

--Oh, mi rincresce di recar fastidio....--ripigliò Felicino,--ma
proprio non capisco... non ricordo più perchè io sia tornato
quassù....--

E il povero Magnasco, cavato di tasca il fazzoletto, si andava
asciugando il sudore che gli gocciolava in copia dalla fronte.

--Ecco...,--diss'egli, come furono nel salotto,--mi ricordo.... Appena
ti ho lasciato, son corso verso casa.... Ma ho trovato degli amici
sotto i portici del teatro Carlo Felice, che uscivano da cena.... Essi
mi hanno trattenuto colle loro chiacchiere.... Poi, sono andato a
casa... ma giunto a mezza scala, mi avvedo che ho dimenticata la
chiave. Dove posso averla lasciata, se iersera l'avevo? Allora ho
pensato che il mio pastrano l'avevo riposto nella tua anticamera, e
che per conseguenza.... Ma permettimi, vo subito a vederci; di certo
la è cascata in qualche cantuccio....--

E senza aspettar altro, Felicino Magnasco, che non aveva ancora alzati
gli occhi verso la sua cugina, uscì a precipizio dal salotto.

--Or bene, che si fa?--chiese Roberto alla signora Laura.

--Che si fa?--rispose ella.--Raccontargli.... È il partito migliore.

--Oh no, signora, nemmeno per sogno!--disse Roberto.--Egli crederà che
lo si voglia ingannare. Non c'è di peggio che la verità. E poi avete
voi un gran tornaconto a scolparvi con lui? Già voi lo amate?

--Ma che! vi pare?

--Dunque....

--Dunque, ditegli ciò che vorrete.

--Ampia facoltà?...

--Pieni poteri.--

Era tempo che s'intendessero; Felicino tornava nel salotto.

--Ecco la chiave!--gridò egli, entrando col prezioso arnese tra le
dita.--Essa era a terra, di costa al tavolino.

--Anch'io ho trovato la mia!--borbottò Roberto Fenoglio, guardando di
sott'occhi madonna Laura.

Quindi, fattasi scorrere la palma della mano sulla fronte, come un
uomo che ha presa una deliberazione, entrò a parlare in tal guisa.

--Felicino, amico mio, ti presento mia moglie!

--Tua moglie!--

Questo grido uscì dalla bocca di Felicino Magnasco, come il «_tu
quoque, Brute, fili mi_?» dalla bocca di Cesare. In quel grido si
distingueva la meraviglia, l'ironia, il rimprovero, e Dio sa quante
altre cose ancora!

Roberto Fenoglio non s'era vantato oltre i suoi meriti, dicendo com'ei
fosse nato per far l'oratore. Il discorso che gli venne fuori in
quella difficilissima occasione, comunque spezzato dalle necessità del
dialogo, lo ha collocato (nella mia stima, s'intende) all'altezza di
Cicerone e di Demostene.

--Felicino,--diss'egli, con accento grave che dimandava altrettanta
gravità dal suo uditore,--ricapitoliamo, e t'avvedrai di non poter
darmi il torto.

--Ah, vedremo!--rispose Magnasco.

--Sicuro, vedremo, e da senno, non già per mo' d'ironia, come tu dici.
E prima di tutto, che cosa sapevo io de' tuoi disegni matrimoniali con
tua cugina? Innanzi che la signora Laura Moneglia diventasse la
signora Laura Fenoglio, potevo io prevedere che un amico mio l'avrebbe
un giorno chiesta in matrimonio? ed anco pensandolo in anticipazione,
dovevo far io, era egli ragionevole di chiedermi il sovrumano
sacrifizio di rinunziare alla sua mano... che è così bella? Tu non
sarai così crudele da aver di cosiffatte pretensioni, Felicino mio,
non è egli vero? Tu non vorrai inoltre negli amici tuoi, per atto di
amicizia, il dono della profezia!

--No certo, io non pretendo tanto.

--Or bene? che colpa puoi tu fare a me, se ho sposato la tua leggiadra
e nobilissima cugina... se un matrimonio clandestino....

--Ma, signore...--entrò a dir Laura con aria turbata.

--Or bene?--disse voltandosi a lei, Roberto Fenoglio.--E i pieni
poteri?--E nell'accento, come nello sguardo di Roberto, c'era tanta
malinconia, che madonna Laura si diè quasi per vinta, e ricadde colla
sua bella testolina inerte sulla poltrona.

Roberto Fenoglio proseguì volgendosi all'amico Magnasco:

--Io te lo ripeto, che colpa ci ho? Stanotte tu mi cogli alla
sprovveduta, mi tiri un colpo a bruciapelo, chiedendomi di renderti
servizio presso la tua signora cugina.... Io casco dalle nuvole....
Non so risponderti... non so dirti, spiattellarti la verità... piglio
tempo, per aspettare il tuo ritorno e raccontarti a mente serena ogni
cosa... ma ecco, tu capiti cinque ore prima; mi trovi solo colla mia
signora... che colpa ci ho io?

--Sta bene;--rispose Felicino, mettendo fuori le parole a stento,--ma
tutto ciò non è molto chiaro. A qual pro un matrimonio clandestino?

--Ah, per cotesto ti assicuro, Felicino, che ci abbiam avute le nostre
gran ragioni. Io te lo dirò poi.... se la mia signora consentirà.

--Felice, io vi giuro....--incominciò la signora Laura.

--Che se non fosse mia moglie,--proseguì prontamente Roberto, dandole
sulla voce con molta accortezza,--tu non l'avresti colta in casa mia,
sola, a notte inoltrata.

--Mi congratulo con gli sposi!--soggiunse Felicino colla sua aria
imbronciata.--Ma ormai non ci sarà più ragione a nascondere il fatto,
e tu farai pubblica la nuova delle tue contentezze.

--Sì, certo, domani stesso; le ragioni che ci hanno fatto tacere e
dissimulare fin qui, son cessate; non è egli vero, Laura?

--Voi siete crudele!--mormorò la signora.

--Vi ho già detto,--soggiunse egli, curvando la persona verso di lei
per parlarle a mezza voce,--che la verità non sarebbe stata creduta.

--Mi accorgo,--notò Felicino,--che ci avete delle tenerezze a dirvi, e
me ne vado. Già non ho sonno, e andrò a fare una cavalcata. Hai veduto
il mio baio, Fenoglio?

--Sì, un bell'animale; ma aspetta, usciamo anche noi.--

Il bel cuginetto diede una girata sui tacchi, e se ne andò ad ammirare
un quadro appiccato all'opposta parete.

Madonna Laura, a sentirlo parlare come aveva fatto allora, fu
costretta a pensare che il suo cugino non si pigliava po' poi grande
rammarico della sua perdita.

Felicino era un uomo del suo secolo, o per dir meglio, del suo mezzo
secolo. Il decimonono va diviso in due periodi; il primo è di _Jacopo
Ortis_; il secondo di.... manca il nome, perchè ancora manca il libro,
ma i lettori capiscono.

Intanto Roberto conduceva la signora Laura verso la strombatura di una
finestra.

--Signora, vi chiedo scusa, ma già ve lo avevo detto.

--Sì, sì, ho inteso; m'avete reso pan per
focaccia.

--Accettate il mio pane?

--Ne parleremo più tardi.

--No; ora io debbo mutar registro con vostro cugino. La verità, detta
adesso, senza ch'egli possa sospettare che si voglia mendicar pretesti
con lui, può essere, deve essere creduta.

--Ma, signore....

--Signora....--

Dicendo questa parola, Roberto aveva le lagrime agli occhi. Laura se
ne addiede, e gli stese affettuosamente la mano.

--Ah!--gridò egli balzando una spanna da terra.

--Che cosa c'è?--chiese Felicino, voltandosi indietro.

--C'è, Felicino mio, che la tua bella cugina non è altrimenti mia
moglie.

--Come? che dici tu?

--Cioè.... mi correggo.... non lo è ancora, ma lo sarà tra breve.
Perdonami, Felicino, ma la gioia mi soffoca. Io non conoscevo tua
cugina. Un caso, nota, un mero caso l'ha condotta qua, questa notte,
per l'uscio che tu, nell'andartene hai lasciato aperto....

--Ah, diamine!

--Sì, tutto ciò sarebbe troppo lungo a narrarsi ora, ma lo saprai per
filo e per segno più tardi. Il fatto sta che un tessuto di bizzarre
avventure ci ha condotto a questo punto, e che adesso, per la prima
volta, la mia divina fidanzata mi ha sporto la mano.

--Adesso!--esclamò Felicino stupefatto.

--Adesso, mentre tu stavi guardando quella incisione del Morghen, che
io ti regalo, se la ti va a genio.

--No, grazie; non saprei dove metterla.

--Come ti piace; ma dimmi, che ora fai?

--Che domanda balzana!

--Per carità, Felicino, te ne prego, che ora fai? Felicino guardò
l'oriuolo.

--Le sei e un quarto!--diss'egli--sei rappattumato cogli orologi?

--Sì, Felicino mio; ne comprerò dieci, venti, trenta, ne riempirò
tutte le camere, tutti i bugigattoli di casa; ma tutti segneranno le
sei e un quarto, eternamente le sei e un quarto.

--Bravo!--soggiunse Magnasco, sforzandosi a sorridere e non venendo a
capo che di fare una smorfia.--Così non ti seccheranno col loro _tran
tran_.

--Certamente; _tu dixisti_! A proposito del _tran_ _tran_, sai tu,
Felicino, che m'hai fatto un vero regalo colla tua teoria dell'ignoto,
del dio Caso e del ragionare coi piedi? Senza quel tuo discorso
eminentemente filosofico, io sarei andato a letto, in cambio di
starmene sdraiato su questo canapè ad aspettare l'ignoto. L'ignoto non
sarebbe venuto senza quell'uscio che tu lasciasti aperto, e il dio
Caso non avrebbe potuto rompere la monotonia dei miei giorni.
Felicino, amico mio; una stretta di mano, e non aver rancore contro il
tuo amico, se gli è stamane più felice di te. Ah, che cosa ne dici di
questo?

--Grazioso, e me lo merito! Ma tu mi
racconterai....

--Sì, tutto.... se la mia bella fidanzata lo consentirà.

--Perchè no?--soggiunse madonna Laura.--Qui non c'è nulla che non si
possa raccontare. Ma andiamo, che già gli è giorno chiaro.

--Cugina,--disse Felicino Magnasco,--mi permettete di offrirvi il
braccio? Il mio Roberto non ne sarà mica geloso?

--Oh, spero di no!--rispose ella, volgendo a Roberto una di quelle
occhiate che solo le donne sanno dare, e nelle grandi occasioni.




VI.


Lettrici e lettori, qui la mia storia sarebbe finita; ma perchè non
abbiate a dire che io vi ho piantati sul più bello, aggiungerò ancora
poche note, a guisa di epilogo.

E _in primis_ vi dirò che, quaranta giorni appresso, Laura Moneglia,
la leggiadra vedova (vedova di due mesi di matrimonio con un decrepito
zio) andava a seconde nozze, anzi a prime, coll'avvocato Roberto
Fenoglio.

La cerimonia fu fatta nella aristocratica chiesa della Maddalena.
C'erano parecchi amici, e tra essi Felicino Magnasco, il quale aveva
finalmente saputo tutti i particolari di quella notte bizzarra, e
ancora non potea darsene pace.

Gli sposi, appena ebbero detto il dolcissimo sì, partirono alla volta
della campagna. Non talentava loro di andare a Parigi, nè a Londra, nè
cullare i primi giorni di amore tra la polvere delle strade maestre,
l'ingombro delle valigie e la inevitabile filatessa prosaica delle
mille necessità di viaggio, nè far confidente di susurrati discorsi
leggiadri il cortinaggio ristucco di un letto di locanda.

Se ne andarono in quella vece ad una villeggiatura di Roberto, posta
mirabilmente su di una collina, di rincontro al mare, graziosa
palazzina di due piani, contornata di fiori, con due falde di vigneti
e di boscaglie, i vigneti a solatìo, le boscaglie a bacìo. I primi
tepori della primavera rinverdivano la natura, smaltando di gaie tinte
il fondo del più bel quadro d'amore che mai potesse immaginare una
mente d'artista.

Colassù non vedevano alcuno, nè d'alcuno avevano, o cercavano,
notizia. Giungevano lettere e le lasciavano chiuse nella sopraccarta;
i giornali s'affastellavano sui canterani, accanto alla parete, colla
fascia intatta.

Come fu passato un mese di quella vita, si ricordarono un giorno che
avevano promesso di tornare a Genova: ma se ne ricordarono per
guardarsi in viso, ridendo, e dirsi a vicenda che amici e congiunti
potevano aspettarli ancora un bel pezzo.

Insomma, ve l'ho a dire? non si mossero per tutta l'estate, e
sarebbero anco rimasti fino a tardo autunno, se la signora Laura non
avesse proprio dovuto andare in città, per certi apprestamenti che
l'accorta lettrice indovina....

Il dì della partenza, scesero la collina a passi lenti.... Ella non
era così leggiadra come il primo giorno che era salita lassù, e aveva
bisogno d'un saldo appoggio al braccio di Roberto.

Ella e lui, si voltavano indietro ad ogni passo, per guardare il loro
bel nido, che splendeva di rincontro al sole, e andavano ripetendo a
vicenda: «Torneremo? torneremo questa primavera. Oh come ci parrà
lungo il tempo!»

E tornarono; ci tornarono tutti gli anni seguenti, e ci torneranno
quest'altro, innamorati come prima, circondati dalla più vispa, dalla
più ricciuta e dalla più leggiadra famigliuola, che abbia mai potuto
desiderare, nei suoi sogni di paternità, il vostro umilissimo servo.



FINE.
EOT;

    /*
    End of Project Gutenberg's Una notte bizzarra, by Anton Giulio Barrili

    *** END OF THIS PROJECT GUTENBERG EBOOK UNA NOTTE BIZZARRA ***

    ***** This file should be named 29636-8.txt or 29636-8.zip *****
    This and all associated files of various formats will be found in:
    http://www.gutenberg.org/2/9/6/3/29636/

    Produced by Claudio Paganelli, Carlo Traverso and the
    Online Distributed Proofreading Team at http://www.pgdp.net
    (This file was produced from images generously made
    available by The Internet Archive/Canadian Libraries)

    Updated editions will replace the previous one--the old editions
    will be renamed.

    Creating the works from public domain print editions means that no
    one owns a United States copyright in these works, so the Foundation
    (and you!) can copy and distribute it in the United States without
    permission and without paying copyright royalties.  Special rules,
    set forth in the General Terms of Use part of this license, apply to
    copying and distributing Project Gutenberg-tm electronic works to
    protect the PROJECT GUTENBERG-tm concept and trademark.  Project
    Gutenberg is a registered trademark, and may not be used if you
    charge for the eBooks, unless you receive specific permission.  If you
    do not charge anything for copies of this eBook, complying with the
    rules is very easy.  You may use this eBook for nearly any purpose
    such as creation of derivative works, reports, performances and
    research.  They may be modified and printed and given away--you may do
    practically ANYTHING with public domain eBooks.  Redistribution is
    subject to the trademark license, especially commercial
    redistribution.

    *** START: FULL LICENSE ***

    THE FULL PROJECT GUTENBERG LICENSE
    PLEASE READ THIS BEFORE YOU DISTRIBUTE OR USE THIS WORK

    To protect the Project Gutenberg-tm mission of promoting the free
    distribution of electronic works, by using or distributing this work
    (or any other work associated in any way with the phrase "Project
    Gutenberg"), you agree to comply with all the terms of the Full Project
    Gutenberg-tm License (available with this file or online at
    http://gutenberg.org/license).

    Section 1.  General Terms of Use and Redistributing Project Gutenberg-tm
    electronic works

    1.A.  By reading or using any part of this Project Gutenberg-tm
    electronic work, you indicate that you have read, understand, agree to
    and accept all the terms of this license and intellectual property
    (trademark/copyright) agreement.  If you do not agree to abide by all
    the terms of this agreement, you must cease using and return or destroy
    all copies of Project Gutenberg-tm electronic works in your possession.
    If you paid a fee for obtaining a copy of or access to a Project
    Gutenberg-tm electronic work and you do not agree to be bound by the
    terms of this agreement, you may obtain a refund from the person or
    entity to whom you paid the fee as set forth in paragraph 1.E.8.

    1.B.  "Project Gutenberg" is a registered trademark.  It may only be
    used on or associated in any way with an electronic work by people who
    agree to be bound by the terms of this agreement.  There are a few
    things that you can do with most Project Gutenberg-tm electronic works
    even without complying with the full terms of this agreement.  See
    paragraph 1.C below.  There are a lot of things you can do with Project
    Gutenberg-tm electronic works if you follow the terms of this agreement
    and help preserve free future access to Project Gutenberg-tm electronic
    works.  See paragraph 1.E below.

    1.C.  The Project Gutenberg Literary Archive Foundation ("the Foundation"
    or PGLAF), owns a compilation copyright in the collection of Project
    Gutenberg-tm electronic works.  Nearly all the individual works in the
    collection are in the public domain in the United States.  If an
    individual work is in the public domain in the United States and you are
    located in the United States, we do not claim a right to prevent you from
    copying, distributing, performing, displaying or creating derivative
    works based on the work as long as all references to Project Gutenberg
    are removed.  Of course, we hope that you will support the Project
    Gutenberg-tm mission of promoting free access to electronic works by
    freely sharing Project Gutenberg-tm works in compliance with the terms of
    this agreement for keeping the Project Gutenberg-tm name associated with
    the work.  You can easily comply with the terms of this agreement by
    keeping this work in the same format with its attached full Project
    Gutenberg-tm License when you share it without charge with others.

    1.D.  The copyright laws of the place where you are located also govern
    what you can do with this work.  Copyright laws in most countries are in
    a constant state of change.  If you are outside the United States, check
    the laws of your country in addition to the terms of this agreement
    before downloading, copying, displaying, performing, distributing or
    creating derivative works based on this work or any other Project
    Gutenberg-tm work.  The Foundation makes no representations concerning
    the copyright status of any work in any country outside the United
    States.

    1.E.  Unless you have removed all references to Project Gutenberg:

    1.E.1.  The following sentence, with active links to, or other immediate
    access to, the full Project Gutenberg-tm License must appear prominently
    whenever any copy of a Project Gutenberg-tm work (any work on which the
    phrase "Project Gutenberg" appears, or with which the phrase "Project
    Gutenberg" is associated) is accessed, displayed, performed, viewed,
    copied or distributed:

    This eBook is for the use of anyone anywhere at no cost and with
    almost no restrictions whatsoever.  You may copy it, give it away or
    re-use it under the terms of the Project Gutenberg License included
    with this eBook or online at www.gutenberg.org

    1.E.2.  If an individual Project Gutenberg-tm electronic work is derived
    from the public domain (does not contain a notice indicating that it is
    posted with permission of the copyright holder), the work can be copied
    and distributed to anyone in the United States without paying any fees
    or charges.  If you are redistributing or providing access to a work
    with the phrase "Project Gutenberg" associated with or appearing on the
    work, you must comply either with the requirements of paragraphs 1.E.1
    through 1.E.7 or obtain permission for the use of the work and the
    Project Gutenberg-tm trademark as set forth in paragraphs 1.E.8 or
    1.E.9.

    1.E.3.  If an individual Project Gutenberg-tm electronic work is posted
    with the permission of the copyright holder, your use and distribution
    must comply with both paragraphs 1.E.1 through 1.E.7 and any additional
    terms imposed by the copyright holder.  Additional terms will be linked
    to the Project Gutenberg-tm License for all works posted with the
    permission of the copyright holder found at the beginning of this work.

    1.E.4.  Do not unlink or detach or remove the full Project Gutenberg-tm
    License terms from this work, or any files containing a part of this
    work or any other work associated with Project Gutenberg-tm.

    1.E.5.  Do not copy, display, perform, distribute or redistribute this
    electronic work, or any part of this electronic work, without
    prominently displaying the sentence set forth in paragraph 1.E.1 with
    active links or immediate access to the full terms of the Project
    Gutenberg-tm License.

    1.E.6.  You may convert to and distribute this work in any binary,
    compressed, marked up, nonproprietary or proprietary form, including any
    word processing or hypertext form.  However, if you provide access to or
    distribute copies of a Project Gutenberg-tm work in a format other than
    "Plain Vanilla ASCII" or other format used in the official version
    posted on the official Project Gutenberg-tm web site (www.gutenberg.org),
    you must, at no additional cost, fee or expense to the user, provide a
    copy, a means of exporting a copy, or a means of obtaining a copy upon
    request, of the work in its original "Plain Vanilla ASCII" or other
    form.  Any alternate format must include the full Project Gutenberg-tm
    License as specified in paragraph 1.E.1.

    1.E.7.  Do not charge a fee for access to, viewing, displaying,
    performing, copying or distributing any Project Gutenberg-tm works
    unless you comply with paragraph 1.E.8 or 1.E.9.

    1.E.8.  You may charge a reasonable fee for copies of or providing
    access to or distributing Project Gutenberg-tm electronic works provided
    that

    - You pay a royalty fee of 20% of the gross profits you derive from
      the use of Project Gutenberg-tm works calculated using the method
      you already use to calculate your applicable taxes.  The fee is
      owed to the owner of the Project Gutenberg-tm trademark, but he
      has agreed to donate royalties under this paragraph to the
      Project Gutenberg Literary Archive Foundation.  Royalty payments
      must be paid within 60 days following each date on which you
      prepare (or are legally required to prepare) your periodic tax
      returns.  Royalty payments should be clearly marked as such and
      sent to the Project Gutenberg Literary Archive Foundation at the
      address specified in Section 4, "Information about donations to
      the Project Gutenberg Literary Archive Foundation."

    - You provide a full refund of any money paid by a user who notifies
      you in writing (or by e-mail) within 30 days of receipt that s/he
      does not agree to the terms of the full Project Gutenberg-tm
      License.  You must require such a user to return or
      destroy all copies of the works possessed in a physical medium
      and discontinue all use of and all access to other copies of
      Project Gutenberg-tm works.

    - You provide, in accordance with paragraph 1.F.3, a full refund of any
      money paid for a work or a replacement copy, if a defect in the
      electronic work is discovered and reported to you within 90 days
      of receipt of the work.

    - You comply with all other terms of this agreement for free
      distribution of Project Gutenberg-tm works.

    1.E.9.  If you wish to charge a fee or distribute a Project Gutenberg-tm
    electronic work or group of works on different terms than are set
    forth in this agreement, you must obtain permission in writing from
    both the Project Gutenberg Literary Archive Foundation and Michael
    Hart, the owner of the Project Gutenberg-tm trademark.  Contact the
    Foundation as set forth in Section 3 below.

    1.F.

    1.F.1.  Project Gutenberg volunteers and employees expend considerable
    effort to identify, do copyright research on, transcribe and proofread
    public domain works in creating the Project Gutenberg-tm
    collection.  Despite these efforts, Project Gutenberg-tm electronic
    works, and the medium on which they may be stored, may contain
    "Defects," such as, but not limited to, incomplete, inaccurate or
    corrupt data, transcription errors, a copyright or other intellectual
    property infringement, a defective or damaged disk or other medium, a
    computer virus, or computer codes that damage or cannot be read by
    your equipment.

    1.F.2.  LIMITED WARRANTY, DISCLAIMER OF DAMAGES - Except for the "Right
    of Replacement or Refund" described in paragraph 1.F.3, the Project
    Gutenberg Literary Archive Foundation, the owner of the Project
    Gutenberg-tm trademark, and any other party distributing a Project
    Gutenberg-tm electronic work under this agreement, disclaim all
    liability to you for damages, costs and expenses, including legal
    fees.  YOU AGREE THAT YOU HAVE NO REMEDIES FOR NEGLIGENCE, STRICT
    LIABILITY, BREACH OF WARRANTY OR BREACH OF CONTRACT EXCEPT THOSE
    PROVIDED IN PARAGRAPH F3.  YOU AGREE THAT THE FOUNDATION, THE
    TRADEMARK OWNER, AND ANY DISTRIBUTOR UNDER THIS AGREEMENT WILL NOT BE
    LIABLE TO YOU FOR ACTUAL, DIRECT, INDIRECT, CONSEQUENTIAL, PUNITIVE OR
    INCIDENTAL DAMAGES EVEN IF YOU GIVE NOTICE OF THE POSSIBILITY OF SUCH
    DAMAGE.

    1.F.3.  LIMITED RIGHT OF REPLACEMENT OR REFUND - If you discover a
    defect in this electronic work within 90 days of receiving it, you can
    receive a refund of the money (if any) you paid for it by sending a
    written explanation to the person you received the work from.  If you
    received the work on a physical medium, you must return the medium with
    your written explanation.  The person or entity that provided you with
    the defective work may elect to provide a replacement copy in lieu of a
    refund.  If you received the work electronically, the person or entity
    providing it to you may choose to give you a second opportunity to
    receive the work electronically in lieu of a refund.  If the second copy
    is also defective, you may demand a refund in writing without further
    opportunities to fix the problem.

    1.F.4.  Except for the limited right of replacement or refund set forth
    in paragraph 1.F.3, this work is provided to you 'AS-IS' WITH NO OTHER
    WARRANTIES OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
    WARRANTIES OF MERCHANTIBILITY OR FITNESS FOR ANY PURPOSE.

    1.F.5.  Some states do not allow disclaimers of certain implied
    warranties or the exclusion or limitation of certain types of damages.
    If any disclaimer or limitation set forth in this agreement violates the
    law of the state applicable to this agreement, the agreement shall be
    interpreted to make the maximum disclaimer or limitation permitted by
    the applicable state law.  The invalidity or unenforceability of any
    provision of this agreement shall not void the remaining provisions.

    1.F.6.  INDEMNITY - You agree to indemnify and hold the Foundation, the
    trademark owner, any agent or employee of the Foundation, anyone
    providing copies of Project Gutenberg-tm electronic works in accordance
    with this agreement, and any volunteers associated with the production,
    promotion and distribution of Project Gutenberg-tm electronic works,
    harmless from all liability, costs and expenses, including legal fees,
    that arise directly or indirectly from any of the following which you do
    or cause to occur: (a) distribution of this or any Project Gutenberg-tm
    work, (b) alteration, modification, or additions or deletions to any
    Project Gutenberg-tm work, and (c) any Defect you cause.


    Section  2.  Information about the Mission of Project Gutenberg-tm

    Project Gutenberg-tm is synonymous with the free distribution of
    electronic works in formats readable by the widest variety of computers
    including obsolete, old, middle-aged and new computers.  It exists
    because of the efforts of hundreds of volunteers and donations from
    people in all walks of life.

    Volunteers and financial support to provide volunteers with the
    assistance they need, are critical to reaching Project Gutenberg-tm's
    goals and ensuring that the Project Gutenberg-tm collection will
    remain freely available for generations to come.  In 2001, the Project
    Gutenberg Literary Archive Foundation was created to provide a secure
    and permanent future for Project Gutenberg-tm and future generations.
    To learn more about the Project Gutenberg Literary Archive Foundation
    and how your efforts and donations can help, see Sections 3 and 4
    and the Foundation web page at http://www.pglaf.org.

    Section 3.  Information about the Project Gutenberg Literary Archive
    Foundation

    The Project Gutenberg Literary Archive Foundation is a non profit
    501(c)(3) educational corporation organized under the laws of the
    state of Mississippi and granted tax exempt status by the Internal
    Revenue Service.  The Foundation's EIN or federal tax identification
    number is 64-6221541.  Its 501(c)(3) letter is posted at
    http://pglaf.org/fundraising.  Contributions to the Project Gutenberg
    Literary Archive Foundation are tax deductible to the full extent
    permitted by U.S. federal laws and your state's laws.

    The Foundation's principal office is located at 4557 Melan Dr. S.
    Fairbanks, AK, 99712., but its volunteers and employees are scattered
    throughout numerous locations.  Its business office is located at
    809 North 1500 West, Salt Lake City, UT 84116, (801) 596-1887, email
    business@pglaf.org.  Email contact links and up to date contact
    information can be found at the Foundation's web site and official
    page at http://pglaf.org

    For additional contact information:
        Dr. Gregory B. Newby
        Chief Executive and Director
        gbnewby@pglaf.org

    Section 4.  Information about Donations to the Project Gutenberg
    Literary Archive Foundation

    Project Gutenberg-tm depends upon and cannot survive without wide
    spread public support and donations to carry out its mission of
    increasing the number of public domain and licensed works that can be
    freely distributed in machine readable form accessible by the widest
    array of equipment including outdated equipment.  Many small donations
    ($1 to $5,000) are particularly important to maintaining tax exempt
    status with the IRS.

    The Foundation is committed to complying with the laws regulating
    charities and charitable donations in all 50 states of the United
    States.  Compliance requirements are not uniform and it takes a
    considerable effort, much paperwork and many fees to meet and keep up
    with these requirements.  We do not solicit donations in locations
    where we have not received written confirmation of compliance.  To
    SEND DONATIONS or determine the status of compliance for any
    particular state visit http://pglaf.org

    While we cannot and do not solicit contributions from states where we
    have not met the solicitation requirements, we know of no prohibition
    against accepting unsolicited donations from donors in such states who
    approach us with offers to donate.

    International donations are gratefully accepted, but we cannot make
    any statements concerning tax treatment of donations received from
    outside the United States.  U.S. laws alone swamp our small staff.

    Please check the Project Gutenberg Web pages for current donation
    methods and addresses.  Donations are accepted in a number of other
    ways including checks, online payments and credit card donations.
    To donate, please visit: http://pglaf.org/donate

    Section 5.  General Information About Project Gutenberg-tm electronic
    works.

    Professor Michael S. Hart is the originator of the Project Gutenberg-tm
    concept of a library of electronic works that could be freely shared
    with anyone.  For thirty years, he produced and distributed Project
    Gutenberg-tm eBooks with only a loose network of volunteer support.

    Project Gutenberg-tm eBooks are often created from several printed
    editions, all of which are confirmed as Public Domain in the U.S.
    unless a copyright notice is included.  Thus, we do not necessarily
    keep eBooks in compliance with any particular paper edition.

    Most people start at our Web site which has the main PG search facility:

         http://www.gutenberg.org

    This Web site includes information about Project Gutenberg-tm,
    including how to make donations to the Project Gutenberg Literary
    Archive Foundation, how to help produce our new eBooks, and how to
    subscribe to our email newsletter to hear about new eBooks.
    */
}
