(function(factory){typeof define==="function"&&define.amd?define(factory):factory()})(function(){"use strict";const Colors={lightblue:{area:"#3366CC",alpha:.45,stroke:"#3366CC"},magenta:{area:"#FF005E"},yellow:{area:"#FF0"},purple:{area:"#732C7B"},steelblue:{area:"#4682B4"},red:{area:"#F00"},lime:{area:"#9CC222",line:"#566B13"}};const SEC=1e3;const MIN=SEC*60;const HOUR=MIN*60;const DAY=HOUR*24;function resolveURL(src,baseUrl){return new URL(src,src.startsWith("../")||src.startsWith("./")?baseUrl:undefined).toString()}function formatTime(t){let d=Math.floor(t/DAY);let h=Math.floor((t-d*DAY)/HOUR);let m=Math.floor((t-d*DAY-h*HOUR)/MIN);let s=Math.round((t-d*DAY-h*HOUR-m*MIN)/SEC);if(s===60){m++;s=0}if(m===60){h++;m=0}if(h===24){d++;h=0}return(d?d+"d ":"")+h.toString().padStart(2,0)+":"+m.toString().padStart(2,0)+"'"+s.toString().padStart(2,0)+'"'}function formatDate(format){if(!format){return time=>new Date(time).toLocaleString().replaceAll("/","-").replaceAll(","," ")}else if(format=="time"){return time=>new Date(time).toLocaleTimeString()}else if(format=="date"){return time=>new Date(time).toLocaleDateString()}return time=>format(time)}function saveFile(dataURI,fileName){let a=create("a","",{href:dataURI,target:"_new",download:fileName||"",style:"display:none;"});let b=document.body;b.appendChild(a);a.click();b.removeChild(a)}function drawCanvas(ctx,path){path.classed("canvas-path",true);ctx.beginPath();ctx.moveTo(0,0);let p=new Path2D(path.attr("d"));ctx.strokeStyle=path.__strokeStyle||path.attr("stroke");ctx.fillStyle=path.__fillStyle||path.attr("fill");ctx.lineWidth=1.25;ctx.globalCompositeOperation="source-over";ctx.globalAlpha=path.attr("stroke-opacity")||.3;ctx.stroke(p);ctx.globalAlpha=path.attr("fill-opacity")||.45;ctx.fill(p);ctx.globalAlpha=1;ctx.closePath()}function coordPropsToMeta(coordProps,name,parser){return coordProps&&(({props,point,id,isMulti})=>{if(props){for(const key of coordProps){if(key in props){point.meta[name]=(parser||parseNumeric).call(this,isMulti?props[key][isMulti]:props[key],id);break}}}})}const parseNumeric=(property,id)=>parseInt(typeof property==="object"?property[id]:property);const parseDate=(property,id)=>new Date(Date.parse(typeof property==="object"?property[id]:property));const addClass=(n,str)=>n&&str.split(" ").every(s=>s&&L.DomUtil.addClass(n,s));const removeClass=(n,str)=>n&&str.split(" ").every(s=>s&&L.DomUtil.removeClass(n,s));const toggleClass=(n,str,cond)=>(cond?addClass:removeClass)(n,str);const replaceClass=(n,rem,add)=>rem&&removeClass(n,rem)||add&&addClass(n,add);const style=(n,k,v)=>typeof v==="undefined"&&L.DomUtil.getStyle(n,k)||n.style.setProperty(k,v);const toggleStyle=(n,k,v,cond)=>style(n,k,cond?v:"");const setAttributes=(n,attrs)=>{for(let k in attrs){n.setAttribute(k,attrs[k])}};const toggleEvent=(el,e,fn,cond)=>el[cond?"on":"off"](e,fn);const create=(tag,str,attrs,n)=>{let elem=L.DomUtil.create(tag,str||"");if(attrs)setAttributes(elem,attrs);if(n)append(n,elem);return elem};const append=(n,c)=>n.appendChild(c);const insert=(n,c,pos)=>n.insertAdjacentElement(pos,c);const select=(str,n)=>(n||document).querySelector(str);const each=(obj,fn)=>{for(let i in obj)fn(obj[i],i)};const randomId=()=>Math.random().toString(36).substr(2,9);const iMax=(iVal,max=-Infinity)=>iVal>max?iVal:max;const iMin=(iVal,min=+Infinity)=>iVal<min?iVal:min;const iAvg=(iVal,avg=0,idx=1)=>(iVal+avg*(idx-1))/idx;const iSum=(iVal,sum=0)=>iVal+sum;const{on,off}=L.DomEvent;const{throttle,wrapNum}=L.Util;const{hasClass}=L.DomUtil;const round=L.Util.formatNum;const clamp=(val,range)=>range?val<range[0]?range[0]:val>range[1]?range[1]:val:val;const wrapDelta=(curr,prev,deltaMax)=>Math.abs(curr-prev)>deltaMax?prev+deltaMax*Math.sign(curr-prev):curr;function cloneDeep(o,skipProps=[],cache=[]){switch(!o||typeof o){case"object":const hit=cache.filter(c=>o===c.original)[0];if(hit)return hit.copy;const copy=Array.isArray(o)?[]:Object.create(Object.getPrototypeOf(o));cache.push({original:o,copy:copy});Object.getOwnPropertyNames(o).forEach(function(prop){const propdesc=Object.getOwnPropertyDescriptor(o,prop);Object.defineProperty(copy,prop,propdesc.get||propdesc.set?propdesc:{writable:propdesc.writable,configurable:propdesc.configurable,enumerable:propdesc.enumerable,value:skipProps.includes(prop)?propdesc.value:cloneDeep(propdesc.value,skipProps,cache)})});return copy;case"function":case"symbol":console.warn("cloneDeep: "+typeof o+"s not fully supported:",o);case true:default:return o}}var _={__proto__:null,Colors:Colors,addClass:addClass,append:append,clamp:clamp,cloneDeep:cloneDeep,coordPropsToMeta:coordPropsToMeta,create:create,drawCanvas:drawCanvas,each:each,formatDate:formatDate,formatTime:formatTime,hasClass:hasClass,iAvg:iAvg,iMax:iMax,iMin:iMin,iSum:iSum,insert:insert,off:off,on:on,parseDate:parseDate,parseNumeric:parseNumeric,randomId:randomId,removeClass:removeClass,replaceClass:replaceClass,resolveURL:resolveURL,round:round,saveFile:saveFile,select:select,setAttributes:setAttributes,style:style,throttle:throttle,toggleClass:toggleClass,toggleEvent:toggleEvent,toggleStyle:toggleStyle,wrapDelta:wrapDelta,wrapNum:wrapNum};var Options={autofitBounds:true,autohide:false,autohideMarker:true,almostover:true,altitude:true,closeBtn:true,collapsed:false,detached:true,distance:true,distanceMarkers:{lazy:true,distance:true,direction:true},dragging:!L.Browser.mobile,downloadLink:"link",elevationDiv:"#elevation-div",edgeScale:{bar:true,icon:false,coords:false},followMarker:true,imperial:false,legend:true,handlers:["Distance","Time","Altitude","Slope","Speed","Acceleration"],hotline:"elevation",marker:"elevation-line",markerIcon:L.divIcon({className:"elevation-position-marker",html:'<i class="elevation-position-icon"></i>',iconSize:[32,32],iconAnchor:[16,16]}),position:"topright",polyline:{className:"elevation-polyline",color:"#000",opacity:.75,weight:5,lineCap:"round"},polylineSegments:{className:"elevation-polyline-segments",color:"#F00",interactive:false},preferCanvas:false,reverseCoords:false,ruler:true,theme:"lightblue-theme",summary:"inline",slope:false,speed:false,time:true,timeFactor:3600,timestamps:false,trkStart:{className:"start-marker",radius:6,weight:2,color:"#fff",fillColor:"#00d800",fillOpacity:1,interactive:false},trkEnd:{className:"end-marker",radius:6,weight:2,color:"#fff",fillColor:"#ff0606",fillOpacity:1,interactive:false},waypoints:true,wptIcons:{"":L.divIcon({className:"elevation-waypoint-marker",html:'<i class="elevation-waypoint-icon default"></i>',iconSize:[30,30],iconAnchor:[8,30]})},wptLabels:true,xAttr:"dist",xLabel:"km",yAttr:"z",yLabel:"m",zFollow:false,zooming:!L.Browser.Mobile,margins:{top:30,right:30,bottom:30,left:40},height:screen.height*.3||200,width:screen.width*.6||600,xTicks:undefined,yTicks:undefined,decimalsX:2,decimalsY:0,forceAxisBounds:false,interpolation:"curveLinear",yAxisMax:undefined,yAxisMin:undefined,srcFolder:(document.currentScript&&document.currentScript.src||{url:typeof document==="undefined"&&typeof location==="undefined"?require("u"+"rl").pathToFileURL(__filename).href:typeof document==="undefined"?location.href:document.currentScript&&document.currentScript.src||new URL("leaflet-elevation.js",document.baseURI).href}&&(typeof document==="undefined"&&typeof location==="undefined"?require("u"+"rl").pathToFileURL(__filename).href:typeof document==="undefined"?location.href:document.currentScript&&document.currentScript.src||new URL("leaflet-elevation.js",document.baseURI).href)).split("/").slice(0,-1).join("/")+"/"};if(!L._||!L.i18n){L._=L.i18n=(string,data)=>string}const Elevation=L.Control.Elevation=L.Control.extend({includes:L.Evented?L.Evented.prototype:L.Mixin.Events,options:Options,__mileFactor:.621371,__footFactor:3.28084,__D3:"https://unpkg.com/d3@7.8.4/dist/d3.min.js",__TOGEOJSON:"https://unpkg.com/@tmcw/togeojson@5.6.2/dist/togeojson.umd.js",__LGEOMUTIL:"https://unpkg.com/leaflet-geometryutil@0.10.1/src/leaflet.geometryutil.js",__LALMOSTOVER:"https://unpkg.com/leaflet-almostover@1.0.1/src/leaflet.almostover.js",__LHOTLINE:"../libs/leaflet-hotline.min.js",__LDISTANCEM:"../libs/leaflet-distance-marker.min.js",__LEDGESCALE:"../libs/leaflet-edgescale.min.js",__LCHART:"../src/components/chart.js",__LMARKER:"../src/components/marker.js",__LSUMMARY:"../src/components/summary.js",__modulesFolder:"../src/handlers/",__btnIcon:"../images/elevation.svg",addData(d,layer){this.import(this.__D3).then(()=>{if(this._modulesLoaded){layer=layer??(d.on&&d);this._addData(d);this._addLayer(layer);this._fireEvt("eledata_added",{data:d,layer:layer,track_info:this.track_info})}else{this.once("modules_loaded",()=>this.addData(d,layer))}})},addTo(map){if(this.options.detached){let parent=select(this.options.elevationDiv);let eleDiv=this.onAdd(map);parent?append(parent,eleDiv):insert(map.getContainer(),eleDiv,"afterend")}else{L.Control.prototype.addTo.call(this,map)}return this},clear(){if(this._marker)this._marker.remove();if(this._chart)this._clearChart();if(this._layers)this._clearLayers(this._layers);if(this._markers)this._clearLayers(this._markers);if(this._circleMarkers)this._circleMarkers.remove();if(this._hotline)this._hotline.eachLayer(l=>l.options.renderer.remove());if(this._hotline)this._clearLayers(this._hotline);this._data=[];this.track_info={};this._fireEvt("eledata_clear");this._updateChart()},_clearChart(){if(this._events&&this._events.elechart_updated){this._events.elechart_updated.forEach(({fn,ctx})=>this.off("elechart_updated",fn,ctx))}if(this._chart&&this._chart._container){this._chart._container.selectAll("g.point .point").remove();this._chart.clear()}},_clearLayers(l){l=l||this._layers;if(l&&l.eachLayer){l.eachLayer(f=>f.remove());l.clearLayers()}},disableBrush(){this._chart._brushEnabled=false;this._resetDrag()},enableBrush(){this._chart._brushEnabled=true},disableZoom(){this._chart._zoomEnabled=false;this._chart._resetZoom()},enableZoom(){this._chart._zoomEnabled=true},fitBounds(bounds){bounds=bounds||this.getBounds();if(this._map&&bounds.isValid())this._map.fitBounds(bounds)},getBounds(data){return L.latLngBounds((data||this._data).map(d=>d.latlng))},getZFollow(){return this.options.zFollow},hide(){style(this._container,"display","none")},initialize(opts){opts=L.setOptions(this,L.extend({},cloneDeep(Options),opts));this._data=[];this._layers=L.featureGroup();this._markers=L.featureGroup();this._hotline=L.featureGroup();this._circleMarkers=L.featureGroup();this._markedSegments=L.polyline([]);this._start=L.circleMarker([0,0],opts.trkStart||Options.trkStart);this._end=L.circleMarker([0,0],opts.trkEnd||Options.trkEnd);this._chartEnabled=true;this._yCoordMax=-Infinity;this.track_info={};if(opts.followMarker)this._setMapView=throttle(this._setMapView,300,this);if(opts.legend)opts.margins.bottom+=30;if(opts.theme)opts.polylineSegments.className+=" "+opts.theme;if(opts.wptIcons===true)opts.wptIcons=Options.wptIcons;if(opts.distanceMarkers===true)opts.distanceMarkers=Options.distanceMarkers;if(opts.trkStart)this._start.addTo(this._circleMarkers);if(opts.trkEnd)this._end.addTo(this._circleMarkers);this._markedSegments.setStyle(opts.polylineSegments);L.extend(Colors,opts.colors||{});this._fixCanvasPaths();this._fixTooltipSize()},import(src,condition){if(Array.isArray(src)){return Promise.all(src.map(m=>this.import(m)))}switch(src){case this.__D3:condition=typeof d3!=="object";break;case this.__TOGEOJSON:condition=typeof toGeoJSON!=="object";break;case this.__LGEOMUTIL:condition=typeof L.GeometryUtil!=="object";break;case this.__LALMOSTOVER:condition=typeof L.Handler.AlmostOver!=="function";break;case this.__LDISTANCEM:condition=typeof L.DistanceMarkers!=="function";break;case this.__LEDGESCALE:condition=typeof L.Control.EdgeScale!=="function";break;case this.__LHOTLINE:condition=typeof L.Hotline!=="function";break}return condition!==false?import(resolveURL(src,this.options.srcFolder)):Promise.resolve()},load(data){this._parseFromString(data).then(geojson=>geojson?this._loadLayer(geojson):this._loadFile(data))},onAdd(map){this._map=map;let container=this._container=create("div","elevation-control "+this.options.theme+" "+(this.options.detached?"elevation-detached":"leaflet-control"),this.options.detached?{id:"elevation-"+randomId()}:{});if(!this.eleDiv)this.eleDiv=container;this._loadModules(this.options.handlers).then(()=>{this._initChart(container);this._initButton(container);this._initSummary(container);this._initMarker(map);this._initLayer(map);this._modulesLoaded=true;this.fire("modules_loaded")});this.fire("add");return container},onRemove(map){this._container=null;map.off("zoom viewreset zoomanim",this._hideMarker,this).off("resize",this._resetView,this).off("resize",this._resizeChart,this).off("mousedown",this._resetDrag,this);off(map.getContainer(),"mousewheel",this._resetDrag,this);off(map.getContainer(),"touchstart",this._resetDrag,this);off(document,"keydown",this._onKeyDown,this);this.off("eledata_added eledata_loaded",this._updateChart,this).off("eledata_added eledata_loaded",this._updateSummary,this);this.fire("remove")},redraw(){this._resizeChart()},setZFollow(zoom){this.options.zFollow=zoom},show(){style(this._container,"display","block")},_addData(d){if(!d){return}if(d.type==="FeatureCollection"){return each(d.features,feature=>this._addData(feature))}else if(d.type==="Feature"){let geom=d.geometry;if(geom){switch(geom.type){case"LineString":return this._addGeoJSONData(geom.coordinates,d.properties);case"MultiLineString":return each(geom.coordinates,(coords,i)=>this._addGeoJSONData(coords,d.properties,i));case"Point":default:return console.warn("Unsopperted GeoJSON feature geometry type:"+geom.type)}}}if(d._latlngs){return this._addGeoJSONData(d._latlngs,d.feature&&d.feature.properties)}},_addGeoJSONData(coords,properties,nestingLevel){let props=properties&&properties.coordinateProperties||properties;coords.forEach((point,i)=>{point.meta=point.meta??{time:null,ele:null};point.prev=attr=>attr?this._data[i>0?i-1:0][attr]:this._data[i>0?i-1:0];this.fire("elepoint_init",{point:point,props:props,id:i,isMulti:nestingLevel});this._addPoint(point.lat??point[1],point.lng??point[0],point.alt??point.meta.ele??point[2]);this.fire("elepoint_added",{point:point,index:this._data.length-1});if(this._yCoordMax<this._data[this._data.length-1][this.options.yAttr])this._yCoordMax=this._data[this._data.length-1][this.options.yAttr]});this.fire("eletrack_added",{coords:coords,index:this._data.length-1})},_addPoint(x,y,z){if(this.options.reverseCoords){[x,y]=[y,x]}this._data.push({x:x,y:y,z:z,latlng:L.latLng(x,y,z)});this.fire("eledata_updated",{index:this._data.length-1})},_addLayer(layer){if(layer)this._layers.addLayer(layer);if(layer&&this.options.distanceMarkers&&this.options.distanceMarkers.lazy){layer.on("add remove",({target,type})=>L.DistanceMarkers&&target instanceof L.Polyline&&target[type+"DistanceMarkers"]())}return layer},_addMarker(marker){if(marker)this._markers.addLayer(marker);return marker},_initAlmostOverHandler(map,layer){return map&&this.options.almostOver&&!L.Browser.mobile?this.import([this.__LGEOMUTIL,this.__LALMOSTOVER]).then(()=>{map.addHandler("almostOver",L.Handler.AlmostOver);if(L.GeometryUtil&&map.almostOver&&map.almostOver.enabled()){map.almostOver.addLayer(layer);map.on("almost:move",this._onMouseMoveLayer,this).on("almost:out",this._onMouseOut,this);this.once("eledata_clear",()=>{map.almostOver.removeLayer(layer);map.off("almost:move",this._onMouseMoveLayer,this).off("almost:out",this._onMouseOut,this)})}}):Promise.resolve()},_initDistanceMarkers(){return this.options.distanceMarkers?this.import([this.__LGEOMUTIL,this.__LDISTANCEM]):Promise.resolve()},_initEdgeScale(map){return this.options.edgeScale?this.import(this.__LEDGESCALE).then(()=>{map.edgeScaleControl=map.edgeScaleControl||L.control.edgeScale("boolean"!==typeof this.options.edgeScale?this.options.edgeScale:{}).addTo(map)}):Promise.resolve()},_initHotLine(layer){let prop=typeof this.options.hotline=="string"?this.options.hotline:"elevation";return this.options.hotline?this.import(this.__LHOTLINE).then(()=>{layer.eachLayer(trkseg=>{if(trkseg.feature.geometry.type!="Point"){let geo=L.geoJson(trkseg.toGeoJSON(),{coordsToLatLng:coords=>L.latLng(coords[0],coords[1],coords[2]*(this.options.altitudeFactor||1))});let line=L.hotline(geo.toGeoJSON().features[0].geometry.coordinates,{renderer:L.Hotline.renderer(),min:isFinite(this.track_info[prop+"_min"])?this.track_info[prop+"_min"]:0,max:isFinite(this.track_info[prop+"_max"])?this.track_info[prop+"_max"]:1,palette:{0:"#008800",.5:"#ffff00",1:"#ff0000"},weight:5,outlineColor:"#000000",outlineWidth:1}).addTo(this._hotline);let alpha=trkseg.options.style&&trkseg.options.style.opacity||1;trkseg.on("add remove",({type})=>{trkseg.setStyle({opacity:type=="add"?0:alpha});line[type=="add"?"addTo":"removeFrom"](trkseg._map);if(line._renderer)line._renderer._container.parentElement.insertBefore(line._renderer._container,line._renderer._container.parentElement.firstChild)})}})}):Promise.resolve()},_initMapIntegrations(layer){let map=this._map;if(map){if(this._data.length){this._start.setLatLng(this._data[0].latlng);this._end.setLatLng(this._data[this._data.length-1].latlng)}Promise.all([this._initHotLine(layer),this._initAlmostOverHandler(map,layer),this._initDistanceMarkers(),this._initEdgeScale(map)]).then(()=>{if(this.options.polyline){this._layers.addLayer(layer.addTo(map));this._circleMarkers.addTo(map)}if(this.options.autofitBounds){this.fitBounds(layer.getBounds())}map.invalidateSize()})}else{this.once("add",()=>this._initMapIntegrations(layer))}},_collapse(){replaceClass(this._container,"elevation-expanded","elevation-collapsed");if(this._map)this._map.invalidateSize()},_expand(){replaceClass(this._container,"elevation-collapsed","elevation-expanded");if(this._map)this._map.invalidateSize()},_fixCanvasPaths(){let oldProto=L.Canvas.prototype._fillStroke;let control=this;let theme=this.options.theme.split(" ")[0].replace("-theme","");let color=Colors[theme]||{};L.Canvas.include({_fillStroke(ctx,layer){if(control._layers.hasLayer(layer)){let options=layer.options;options.color=color.line||color.area||theme;options.stroke=!!options.color;oldProto.call(this,ctx,layer);if(options.stroke&&options.weight!==0){let oldVal=ctx.globalCompositeOperation||"source-over";ctx.globalCompositeOperation="destination-over";ctx.strokeStyle=color.outline||"#FFF";ctx.lineWidth=options.weight*1.75;ctx.stroke();ctx.globalCompositeOperation=oldVal}}else{oldProto.call(this,ctx,layer)}}})},_fixTooltipSize(){this.on("elechart_init",()=>this.once("elechart_change elechart_hover",({data,xCoord})=>{if(this._chartEnabled){this._chart._showDiagramIndicator(data,xCoord);this._chart._showDiagramIndicator(data,xCoord)}this._updateMarker(data)}))},_findItemForLatLng(latlng){return this._data[this._chart._findIndexForLatLng(latlng)]},_findItemForX(x){return this._data[this._chart._findIndexForXCoord(x)]},_fireEvt(type,data,propagate){if(this.fire)this.fire(type,data,propagate);if(this._map)this._map.fire(type,data,propagate)},_hideMarker(){if(this.options.autohideMarker){this._marker.remove()}},_initChart(container){let opts=this.options;let map=this._map;if(opts.detached){let{offsetWidth,offsetHeight}=this.eleDiv;if(offsetWidth>0)opts.width=offsetWidth;if(offsetHeight>20)opts.height=offsetHeight-20}else{let{clientWidth}=map.getContainer();opts._maxWidth=opts._maxWidth>opts.width?opts._maxWidth:opts.width;this._container.style.maxWidth=opts._maxWidth+"px";if(opts._maxWidth>clientWidth)opts.width=clientWidth-30}this.import([this.__D3,this.__LCHART]).then(m=>{let chart=this._chart=new(m[1]||Elevation).Chart(opts,this);this._x=this._chart._x;this._y=this._chart._y;d3.select(container).call(chart.render());chart.on("reset_drag",this._hideMarker,this).on("mouse_enter",this._onMouseEnter,this).on("dragged",this._onDragEnd,this).on("mouse_move",this._onMouseMove,this).on("mouse_out",this._onMouseOut,this).on("ruler_filter",this._onRulerFilter,this).on("zoom",this._updateChart,this).on("elepath_toggle",this._onToggleChart,this).on("margins_updated",this._resizeChart,this);this.fire("elechart_init");map.on("zoom viewreset zoomanim",this._hideMarker,this).on("resize",this._resetView,this).on("resize",this._resizeChart,this).on("rotate",this._rotateMarker,this).on("mousedown",this._resetDrag,this);on(map.getContainer(),"mousewheel",this._resetDrag,this);on(map.getContainer(),"touchstart",this._resetDrag,this);on(document,"keydown",this._onKeyDown,this);this.on("eledata_added eledata_loaded",this._updateChart,this).on("eledata_added eledata_loaded",this._updateSummary,this);this._updateChart();this._updateSummary()})},_initLayer(){this._layers.on("layeradd layerremove",({layer,type})=>{let node=layer.getElement&&layer.getElement();toggleClass(node,this.options.polyline.className+" "+this.options.theme,type=="layeradd");toggleEvent(layer,"mousemove",this._onMouseMoveLayer.bind(this),type=="layeradd");toggleEvent(layer,"mouseout",this._onMouseOut.bind(this),type=="layeradd")})},_initMarker(map){let pane=map.getPane("elevationPane");if(!pane){pane=this._pane=map.createPane("elevationPane",map.getPane("norotatePane")||map.getPane("mapPane"));pane.style.zIndex=625;pane.style.pointerEvents="none"}if(this._renderer)this._renderer.remove();this._renderer=L.svg({pane:"elevationPane"}).addTo(this._map);this.import([this.__D3,this.__LMARKER]).then(m=>{this._marker=new(m[1]||Elevation).Marker(this.options,this);this.fire("elechart_marker")})},_initButton(container){L.DomEvent.disableClickPropagation(container).disableScrollPropagation(container);this.options.collapsed?this._collapse():this._expand();if(this.options.autohide){on(container,"mouseover",this._expand,this);on(container,"mouseout",this._collapse,this);this._map.on("click",this._collapse,this)}if(this.options.closeBtn){let link=this._button=create("a","elevation-toggle-icon",{href:"#",title:L._("Elevation")},container);on(link,"click",L.DomEvent.stop);on(link,"click",this._toggle,this);on(link,"focus",this._toggle,this);fetch(resolveURL(this.__btnIcon,this.options.srcFolder)).then(r=>r.ok&&r.text().then(img=>link.innerHTML=img))}},_initSummary(container){this.import(this.__LSUMMARY).then(m=>{this._summary=new(m||Elevation).Summary({summary:this.options.summary},this);this.on("elechart_init",()=>{d3.select(container).call(this._summary.render())})})},_loadFile(url){fetch(url).then(response=>response.text()).then(data=>{this._downloadURL=url;this._parseFromString(data).then(geojson=>geojson&&this._loadLayer(geojson))}).catch(err=>console.warn(err))},_loadModules(handlers){handlers=handlers.map(h=>typeof h==="string"&&typeof Elevation[h]!=="undefined"?Elevation[h]:h);let modules=handlers.map(file=>typeof file==="string"&&this.import(this.__modulesFolder+file.toLowerCase()+".js")||file instanceof Promise&&file||Promise.resolve());return Promise.all(modules).then(m=>{each(m,(exported,i)=>{let fn=exported&&Object.keys(exported)[0];if(fn){handlers[i]=Elevation[fn]=Elevation[fn]??exported[fn]}});each(handlers,h=>["function","object"].includes(typeof h)&&this._registerHandler(h))})},_loadLayer(geojson){let{polyline,theme,waypoints,wptIcons,wptLabels,distanceMarkers}=this.options;let style=L.extend({},polyline);if(theme){style.className+=" "+theme}if(geojson.name){this.track_info.name=geojson.name}let layer=L.geoJson(geojson,{distanceMarkers:distanceMarkers,style:style,pointToLayer:(feature,latlng)=>{if(waypoints){let{desc,name,sym}=feature.properties;desc=desc||"";name=name||"";if([true,"dots"].includes(waypoints)){this._registerCheckPoint({latlng:latlng,label:[true,"dots"].includes(wptLabels)?name:""})}if([true,"markers"].includes(waypoints)&&wptIcons!=false){return this._registerMarker({latlng:latlng,sym:(sym??name).replace(" ","-").replace('"',"").replace("'","").toLowerCase(),content:[true,"markers"].includes(wptLabels)&&(name||desc)&&decodeURI("<b>"+name+"</b>"+(desc.length>0?"<br>"+desc:""))})}}},onEachFeature:(feature,layer)=>feature.geometry&&feature.geometry.type!="Point"&&this.addData(feature,layer)});this.import(this.__D3).then(()=>{this._initMapIntegrations(layer);const event_data={data:geojson,layer:layer,name:this.track_info.name,track_info:this.track_info};if(this._modulesLoaded){this._fireEvt("eledata_loaded",event_data)}else{this.once("modules_loaded",()=>this._fireEvt("eledata_loaded",event_data))}});return layer},_onDragEnd({dragstart,dragend}){this._hideMarker();this.fitBounds(L.latLngBounds([dragstart.latlng,dragend.latlng]));this.fire("elechart_dragged")},_onKeyDown({key}){if(!this.options.detached&&key==="Escape"){this._collapse()}},_onMouseEnter(){this.fire("elechart_enter")},_onMouseMove({xCoord}){if(this._chartEnabled&&this._data.length){let item=this._findItemForX(xCoord);if(item){if(this._chartEnabled)this._chart._showDiagramIndicator(item,xCoord);this._updateMarker(item);this._setMapView(item);if(this._map){addClass(this._map.getContainer(),"elechart-hover")}this.fire("elechart_change",{data:item,xCoord:xCoord});this.fire("elechart_hover",{data:item,xCoord:xCoord})}}},_onMouseMoveLayer({latlng}){if(this._data.length){let item=this._findItemForLatLng(latlng);if(item){let xCoord=item.xDiagCoord;if(this._chartEnabled)this._chart._showDiagramIndicator(item,xCoord);this._updateMarker(item);this.fire("elechart_change",{data:item,xCoord:xCoord})}}},_onMouseOut(){if(!this.options.detached){this._hideMarker();this._chart._hideDiagramIndicator()}if(this._map){removeClass(this._map.getContainer(),"elechart-hover")}this.fire("elechart_leave")},_onRulerFilter({coords}){this._updateMapSegments(coords)},_onToggleChart({name,enabled}){this._chartEnabled=this._chart._hasActiveLayers();this._layers.eachLayer(layer=>layer.getElement&&this._chartEnabled&&this.options.polyline.className&&_.toggleClass(layer.getElement&&layer.getElement(),this.options.polyline.className+" "+this.options.theme,this._chartEnabled));this.options[name]=!enabled&&this.options[name]=="disabled"?"enabled":"disabled";if(!this._chartEnabled){this._chart._hideDiagramIndicator();this._marker.remove()}},_parseFromGeoJSONString(data){try{return JSON.parse(data)}catch(e){}},_parseFromString(data){return new Promise(resolve=>this.import(this.__TOGEOJSON).then(()=>{let geojson;try{geojson=this._parseFromXMLString(data.trim())}catch(e){geojson=this._parseFromGeoJSONString(data.toString())}if(geojson){geojson.name=geojson.name||(this._downloadURL||"").split("/").pop().split("#")[0].split("?")[0]}resolve(geojson)}))},_parseFromXMLString(data){if(data.indexOf("<")!=0){throw"Invalid XML"}let xml=(new DOMParser).parseFromString(data,"text/xml");let type=xml.documentElement.tagName.toLowerCase();let name=xml.getElementsByTagName("name");if(xml.getElementsByTagName("parsererror").length){throw"Invalid XML"}if(!(type in toGeoJSON)){type=xml.documentElement.tagName=="TrainingCenterDatabase"?"tcx":"gpx"}let geojson=toGeoJSON[type](xml);geojson.name=name.length>0?(Array.from(name).find(tag=>tag.parentElement.tagName=="trk")??name[0]).textContent:"";return geojson},_registerAreaPath(props){this.on("elechart_init",()=>this._chart._registerAreaPath(props))},_registerAxisGrid(props){this.on("elechart_axis",()=>this._chart._registerAxisGrid(props))},_registerAxisScale(props){this.on("elechart_axis",()=>this._chart._registerAxisScale(props))},_registerCheckPoint(props){const cb=()=>this._chart._registerCheckPoint(props);this.on("elechart_updated",cb).once("eledata_clear",()=>this.off("elechart_updated",cb))},_registerDataAttribute(props){if(props.coordPropsToMeta){this.on("elepoint_init",e=>props.coordPropsToMeta.call(this,e))}let i,curr,prev,attr=props.attr||props.name;let lastValid={};this.on("elepoint_added",({index,point})=>{i=index;prev=curr??this._data[i];curr=this._data[i];curr[attr]=props.pointToAttr.call(this,point,i);if(i>0&&isNaN(prev[attr])){if(!isNaN(lastValid[attr])&&!isNaN(curr[attr])){prev[attr]=(lastValid[attr]+curr[attr])/2}else if(!isNaN(lastValid[attr])){prev[attr]=lastValid[attr]}else if(!isNaN(curr[attr])){prev[attr]=curr[attr]}if(props.meta){prev[props.meta]=prev[attr]}}if(isNaN(curr[attr])){return}lastValid[attr]=curr[attr];if(props.deltaMax){curr[attr]=wrapDelta(curr[attr],prev[attr],props.deltaMax)}if(props.clampRange){curr[attr]=clamp(curr[attr],props.clampRange)}if(!isNaN(props.decimals)){curr[attr]=round(curr[attr],props.decimals)}if(props.stats){for(const key in props.stats){let sname=(props.statsName||attr)+(key!=""?"_":"");this.track_info[sname+key]=props.stats[key].call(this,curr[attr],this.track_info[sname+key],this._data.length)}}if(props.onPointAdded)props.onPointAdded.call(this,curr[attr],i,point)})},_registerHandler(props){if(typeof props==="function"){return this._registerHandler(props.call(this))}let{name,attr,required,deltaMax,clampRange,decimals,meta,unit,coordinateProperties,coordPropsToMeta:coordPropsToMeta$1,pointToAttr,onPointAdded,stats,statsName,grid,scale,path,tooltip,summary}=props;if(this.options[name]||required){this._registerDataAttribute({name:name,attr:attr,meta:meta,deltaMax:deltaMax,clampRange:clampRange,decimals:decimals,coordPropsToMeta:coordPropsToMeta(coordinateProperties,meta||name,coordPropsToMeta$1),pointToAttr:pointToAttr,onPointAdded:onPointAdded,stats:stats,statsName:statsName});if(grid){this._registerAxisGrid(L.extend({name:name},grid))}if(this.options[name]!=="summary"){if(scale)this._registerAxisScale(L.extend({name:name,label:unit},scale));if(path)this._registerAreaPath(L.extend({name:name},path))}if(tooltip||props.tooltips){each([tooltip,...props.tooltips||[]],t=>t&&this._registerTooltip(L.extend({name:name},t)))}if(summary){each(summary,(s,k)=>summary[k]=L.extend({unit:unit},s));this._registerSummary(summary)}}},_registerMarker({latlng,sym,content}){let{wptIcons}=this.options;if(!wptIcons.hasOwnProperty(sym)){wptIcons[sym]=L.divIcon(L.extend({},wptIcons[""].options,{html:'<i class="elevation-waypoint-icon '+sym+'"></i>'}))}let marker=L.marker(latlng,{icon:wptIcons[sym]});if(content){marker.bindPopup(content,{className:"elevation-popup",keepInView:true}).openPopup();marker.bindTooltip(content,{className:"elevation-tooltip",direction:"auto",sticky:true,opacity:1}).openTooltip()}return this._addMarker(marker)},_registerTooltip(props){props.chart&&this.on("elechart_init",()=>this._chart._registerTooltip(L.extend({},props,{value:props.chart})));props.marker&&this.on("elechart_marker",()=>this._marker._registerTooltip(L.extend({},props,{value:props.marker})))},_registerSummary(props){this.on("elechart_summary",()=>this._summary._registerSummary(props))},_resetDrag(){this._chart._resetDrag();this._hideMarker()},_resetView(){if(this._map&&this._map._isFullscreen)return;this._resetDrag();this._hideMarker();if(this.options.autofitBounds){this.fitBounds()}},_resizeChart(){if(this._container&&style(this._container,"display")!="none"){let opts=this.options;let newWidth=opts.detached?(this.eleDiv||this._container).offsetWidth:clamp(opts._maxWidth,[0,this._map.getContainer().clientWidth-30]);if(newWidth){opts.width=newWidth;if(this._chart&&this._chart._chart){this._chart._chart._resize(opts);this._updateChart()}}this._updateMapSegments()}},_toggle(){hasClass(this._container,"elevation-expanded")?this._collapse():this._expand()},_setMapView(item){if(this._map&&this.options.followMarker){let zoom=this._map.getZoom();let z=this.options.zFollow;if(typeof z==="number"){this._map.setView(item.latlng,zoom<z?z:zoom,{animate:true,duration:.25})}else if(!this._map.getBounds().contains(item.latlng)){this._map.setView(item.latlng,zoom,{animate:true,duration:.25})}}},_updateChart(){if(this._chart&&this._container){this.fire("elechart_axis");this._chart.update({data:this._data,options:this.options});this._x=this._chart._x;this._y=this._chart._y;this.fire("elechart_updated")}},_updateMarker(item){if(this._marker){this._marker.update({map:this._map,item:item,yCoordMax:this._yCoordMax||0,options:this.options})}},_rotateMarker(){if(this._marker){this._marker.update()}},_updateMapSegments(coords){this._markedSegments.setLatLngs(coords||[]);if(coords&&this._map&&!this._map.hasLayer(this._markedSegments)){this._markedSegments.addTo(this._map)}},_updateSummary(){if(this._summary){this._summary.reset();if(this.options.summary){this.fire("elechart_summary");this._summary.update()}if(this.options.downloadLink&&this._downloadURL){this._summary._container.innerHTML+='<span class="download"><a href="#">'+L._("Download")+"</a></span>";select(".download a",this._summary._container).onclick=e=>{e.preventDefault();let event={downloadLink:this.options.downloadLink,confirm:saveFile.bind(this,this._downloadURL)};if(this.options.downloadLink=="modal"&&typeof CustomEvent==="function"){document.dispatchEvent(new CustomEvent("eletrack_download",{detail:event}))}else if(this.options.downloadLink=="link"||this.options.downloadLink===true){event.confirm()}this.fire("eletrack_download",event)}}}},_width(){if(this._chart)return this._chart._width();const{width,margins}=this.options;return width-margins.left-margins.right},_height(){if(this._chart)return this._chart._height();const{height,margins}=this.options;return height-margins.top-margins.bottom}});Elevation.Utils=_;L.control.elevation=options=>new Elevation(options)});
