<?php
/**
 * Admin functions for an overview map from pages / posts
 *
 * @package Extensions for Leaflet Map
 */

// Direktzugriff auf diese Datei verhindern.
defined( 'ABSPATH' ) || die();

// init settings fuer overviewmap
function leafext_overviewmap_init() {
	add_settings_section( 'overviewmap_settings', '', 'leafext_overviewmap_help', 'leafext_settings_overviewmap' );
	$fields = leafext_overviewmap_admin_params();
	foreach ( $fields as $field ) {
		add_settings_field( 'leafext_overviewmap[' . $field['param'] . ']', $field['shortdesc'], 'leafext_form_overviewmap', 'leafext_settings_overviewmap', 'overviewmap_settings', $field['param'] );
	}
	register_setting( 'leafext_settings_overviewmap', 'leafext_overviewmap', 'leafext_validate_overviewmap' );
}
add_action( 'admin_init', 'leafext_overviewmap_init' );

// Baue Abfrage der Params
function leafext_form_overviewmap( $field ) {
	$options  = leafext_overviewmap_admin_params();
	$option   = leafext_array_find2( $field, $options );
	$settings = overviewmap_admin_settings();
	$setting  = $settings[ $field ];
	if ( $option['desc'] !== '' ) {
		echo '<p>' . wp_kses_post( $option['desc'] ) . '</p>';
	}
	// echo __("You can change it for each map with", "extensions-leaflet-map").' <code>'.$option['param']. '</code><br>';

	if ( ! current_user_can( 'manage_options' ) ) {
		$disabled = ' disabled ';
	} else {
		$disabled = '';
	}

	if ( ! is_array( $option['values'] ) ) {
		if ( $setting !== $option['default'] ) {
			// var_dump($setting,$option['default']);
			echo esc_html__( 'Plugins Default', 'extensions-leaflet-map' ) . ': ';
			echo $option['default'] ? 'true' : 'false';
			echo '<br>';
		}
		echo '<input ' . esc_attr( $disabled ) . ' type="radio" name="leafext_overviewmap[' . esc_attr( $option['param'] ) . ']" value="1" ';
		echo $setting ? 'checked' : '';
		echo '> true &nbsp;&nbsp; ';
		echo '<input ' . esc_attr( $disabled ) . ' type="radio" name="leafext_overviewmap[' . esc_attr( $option['param'] ) . ']" value="0" ';
		echo ( ! $setting ) ? 'checked' : '';
		echo '> false ';
		// } else {
		// others
	}
}

// Sanitize and validate input. Accepts an array, return a sanitized array.
function leafext_validate_overviewmap( $input ) {
	// var_dump($_REQUEST,$_POST,$input); wp_die();
	if ( ! empty( $_POST ) && check_admin_referer( 'leafext_overviewmap', 'leafext_overviewmap_nonce' ) ) {
		if ( isset( $_POST['submit'] ) ) {
			$input['transients'] = (bool) ( $input['transients'] );
		}
		return $input;
	}
}

function leafext_overviewmap_help() {
	if ( is_singular() || is_archive() ) {
		$codestyle = '';
		$text      = '';
	} else {
		leafext_enqueue_admin();
		$codestyle = ' class="language-coffeescript"';
		$text      = '<h2>' . __( 'Overview Map', 'extensions-leaflet-map' ) . '</h2>';
	}

	$text = $text . '<p>' . __( 'Generates an overview map with geo positions provided in the pages and posts.', 'extensions-leaflet-map' ) . '</p>';
	$text = $text . '<h3>' . __( 'Preparation', 'extensions-leaflet-map' ) . '</h3>';

	$text = $text . '<ul><li>' . __( 'Create for every desired page or post the below mentioned customs fields.', 'extensions-leaflet-map' ) . '</li>';
	$text = $text . '<li>' . __( 'Optional: Create a featured image for page or post.', 'extensions-leaflet-map' ) . '</li>';
	$text = $text . '<li>' . __( 'Optional: Place the page or post in one or more categories or tag it. The word "category" in this documentation means category or tag.', 'extensions-leaflet-map' ) . '</li></ul>';

	$text = $text . '<h3>' . __( 'Custom fields', 'extensions-leaflet-map' ) . '</h3>';

	$text = $text . '<p>' . __( 'The custom fields names are as you like. You can these specify in overviewmap options.', 'extensions-leaflet-map' ) . '</p>';

	$options = leafext_overviewmap_settings();
	$new     = array();
	$new[]   = array(
		'desc'    => '<strong>' . __( 'Custom field', 'extensions-leaflet-map' ) . '</strong>',
		'content' => '<strong>' . __( 'Content', 'extensions-leaflet-map' ) . '</strong>',
		'default' => '<strong>' . __( 'Default name', 'extensions-leaflet-map' ) . '</strong>',
		'param'   => '<strong>' . __( 'Option to change', 'extensions-leaflet-map' ) . '</strong>',
	);

	foreach ( $options as $option ) {
		$new[] = array(
			'desc'    => $option['desc'],
			'content' => $option['content'],
			'default' => $option['default'],
			'param'   => $option['param'],
		);
	}
	$text = $text . leafext_html_table( $new );

	$text = $text . '<h3>Popup</h3>';

	$text = $text . '<ul>' .
	'<li>' . __( 'Default popup content is taken from the overviewmap shortcode and is a set of title, permalink, categories, featured image.', 'extensions-leaflet-map' ) . '</li>'
	. '<li>   ' . wp_sprintf(
		/* translators: %1$s is "leaflet-marker" */
		__( 'The content of the popup custom field is like the popup in %1$s.', 'extensions-leaflet-map' ),
		' <code>leaflet-marker</code>'
	) . '</li>' .
	'<li>' . wp_sprintf(
		/* translators: %1$s a link to ACF plugin. */
		__( 'You can use an %1$s also.', 'extensions-leaflet-map' ),
		'<a href="https://wordpress.org/plugins/advanced-custom-fields/">ACF</a>'
	) . '</li>' .
	'<li>' . __( 'You can use strings in curly brackets to substitute the values:', 'extensions-leaflet-map' ) .
	'<p><ul>
<li>{permalink} - ' . __( 'the url to the page / post', 'extensions-leaflet-map' ) . '</li>
<li>{title} - ' . __( 'the title', 'extensions-leaflet-map' ) . '</li>
<li>{thumbnail} - ' . __( 'the featured image', 'extensions-leaflet-map' ) . '</li>
<li>{categories} - ' . __( 'categories', 'extensions-leaflet-map' ) . '</li>
<li>{link} - <code>&lt;a href="{permalink}">{title}&lt;/a></code></li>
</ul></p></li>' .
	'</ul>';

	$text = $text . '<h3>Shortcode</h3>
  <pre' . $codestyle . '><code' . $codestyle . '>&#091;leaflet-map fitbounds]
&#091;overviewmap latlngs=... icons=... options= ...]
// optional
&#091;hover class=leafext-overview-tooltip]
</code></pre>';

	$text = $text . '<h3>' . __( 'Options for overviewmap', 'extensions-leaflet-map' ) . '</h3>';

	$options = leafext_overviewmap_params();
	$new     = array();
	$new[]   = array(
		'param'   => '<strong>Option</strong>',
		'desc'    => '<strong>' . __( 'Description', 'extensions-leaflet-map' ) . '</strong>',
		// 'content' => "<strong>".__('Content','extensions-leaflet-map').'</strong>',
		'default' => '<strong>' . __( 'Default', 'extensions-leaflet-map' ) . '</strong>',
		'values'  => '<strong>' . __( 'Possible values', 'extensions-leaflet-map' ) . '</strong>',
	);

	foreach ( $options as $option ) {
		$new[] = array(
			'param'   => $option['param'],
			'desc'    => $option['desc'],
			// 'content' => $option['content'],
			'default' => is_string( $option['default'] ) ? $option['default'] : ( ( $option['default'] === false ) ? 'false' : 'true' ),
			'values'  => $option['values'],
		);
	}
	$text = $text . leafext_html_table( $new );

	$text = $text . '<p>' . __( 'If it does not work as expected, see the developer console of your browser.', 'extensions-leaflet-map' ) . '</p>';

	$text = $text . '<h3>' . __( 'Options for marker', 'extensions-leaflet-map' ) . '</h3>';
	$text = $text . '<p>' . wp_sprintf(
		/* translators: %s is a shortcode. */
		__( 'You can use these in the custom field for the icon and in shortcode %s.', 'extensions-leaflet-map' ),
		'<code>overviewmap</code>'
	) . '</p>';

	$text = $text . '<h4>leaflet-marker</h4>';
	$text = $text . '<p>' . implode( ', ', leafext_marker_options() ) . '</p>';
	$text = $text . '<p>' . wp_sprintf(
		/* translators: %s are options. */
		__( '%1$s is for icon filename required. The icons directory must be the same as from %2$s.', 'extensions-leaflet-map' ),
		'<b>iconUrl</b>',
		'<b>iconUrl</b>'
	) . '</p>';

	$text = $text . '<h4>leaflet-extramarker</h4>';
	$text = $text . '<p>' . implode( ', ', leafext_extramarker_options() ) . '</p>';

	/* translators: %s is an href. */
	$text = $text . '<p>' . wp_sprintf( __( 'See %1$sexamples%2$s.', 'extensions-leaflet-map' ), '<a href="https://leafext.de/extra/category/overviewmap/">', '</a>' ) . '</p>';

	if ( is_singular() || is_archive() ) {
		return $text;
	} else {
		echo wp_kses_post( $text );
	}
}
