<?php


namespace ExportHtmlAdmin\EWPPTH_AjaxRequests\getFtpDirFileList;


class initAjax extends \ExportHtmlAdmin\Export_Wp_Page_To_Static_Html_Admin
{

    public function __construct()
    {
        /*Initialize Ajax get_ftp_dir_file_list*/
        add_action('wp_ajax_get_ftp_dir_file_list', array( $this, 'get_ftp_dir_file_list' ));


    }


    /**
     * Ajax action name: get_ftp_dir_file_list
     * @since    1.0.0
     * @access   public
     * @return json
     */

    public function get_ftp_dir_file_list(){
        //$post = $_POST['post'];

        \rcCheckNonce();
        $path = isset( $_POST['path'] ) ? wp_unslash( $_POST['path'] ) : '';
        $path = sanitize_text_field( $path );


        $dirs = $this->get_ftp_path_directory($path);
        $lists = '<span><span style="font-weight: bold;">Current path: </span><span class="ftp_current_path">/' . $this->get_absolute_path($dirs['path']).'</span></span><ul class="list-group">';
        if(isset($dirs['lists'])&&!empty($dirs['lists'])){
            foreach ($dirs['lists'] as $dir) {
                if (strpos($dir, '..')!==false) {
                    $lists .= '<li class="list-group-item" dir_path="'.$dirs['path'].'/'.$dir.'">'.$dir.'</li>';
                }
                else{
                    $lists .= '<li class="list-group-item" dir_path="'.$dirs['path'].'/'.$dir.'"><span class="dir_png"></span>'.$dir.'</li>';
                }

            }
        }

        $lists .= '</ul>';

        echo json_encode(array('success' => 'true', 'status' => 'success', 'response' => $lists));

        die();
    }

    public function get_ftp_path_directory($p_path='')
    {
        $status = get_option('rc_export_html_ftp_connection_status');
        $ftp_data = get_option('rc_export_html_ftp_data');

        if ($status == 'connected') {
            $host = $user = $pass = $path = "";
            if (isset($ftp_data->host)) {
                $host = $ftp_data->host;
            }
            if (isset($ftp_data->user)) {
                $user = $ftp_data->user;
            }
            if (isset($ftp_data->pass)) {
                $pass = $ftp_data->pass;
            }
            if (isset($ftp_data->path)) {
                $path = $ftp_data->path;
            }

            if (!empty($p_path)) {
                $path = $p_path;
            }

            if (function_exists('ftp_connect') && function_exists('ftp_login')) {

                if (!empty($host) && !empty($user) && !empty($pass)) {
                    $ftpConn = ftp_connect($host);
                    $login = ftp_login($ftpConn,$user,$pass);

                    if ($ftpConn && $login) {
                        //@ftp_chdir($ftpConn, $path);
                        $u['path'] = $this->normalizePath($path);//ftp_pwd($ftpConn);

                        $lists = ftp_mlsd($ftpConn, $path);
                        $list = array();
                        $list_d = array();
                        if (!empty($lists)) {
                            foreach ($lists as $value) {
                                if ($value['type'] == 'dir') {
                                    $list[] = $value['name'];
                                }
                                if ($value['type'] == 'pdir') {
                                    $list_d[] = $value['name'];
                                }
                            }
                        }

                        $all_lists = array_merge($list_d, $list);
                        $u['lists'] = $all_lists;
                        return $u;
                    }
                    else{
                        $this->setSettings('ftp_status', 'failed');
                    }
                }
                else{
                    $this->setSettings('ftp_status', 'failed');
                }
            }
            else{
                $this->setSettings('ftp_status', 'failed');
            }
        }
    }

}
