declare module "intl-tel-input/data" {
    export const rawCountryData: readonly [readonly ["af", "93", 0, any, "0"], readonly ["ax", "358", 1, readonly ["18", "4"], "0"], readonly ["al", "355", 0, any, "0"], readonly ["dz", "213", 0, any, "0"], readonly ["as", "1", 5, readonly ["684"], "1"], readonly ["ad", "376"], readonly ["ao", "244"], readonly ["ai", "1", 6, readonly ["264"], "1"], readonly ["ag", "1", 7, readonly ["268"], "1"], readonly ["ar", "54", 0, any, "0"], readonly ["am", "374", 0, any, "0"], readonly ["aw", "297"], readonly ["ac", "247"], readonly ["au", "61", 0, readonly ["4"], "0"], readonly ["at", "43", 0, any, "0"], readonly ["az", "994", 0, any, "0"], readonly ["bs", "1", 8, readonly ["242"], "1"], readonly ["bh", "973"], readonly ["bd", "880", 0, any, "0"], readonly ["bb", "1", 9, readonly ["246"], "1"], readonly ["by", "375", 0, any, "8"], readonly ["be", "32", 0, any, "0"], readonly ["bz", "501"], readonly ["bj", "229"], readonly ["bm", "1", 10, readonly ["441"], "1"], readonly ["bt", "975"], readonly ["bo", "591", 0, any, "0"], readonly ["ba", "387", 0, any, "0"], readonly ["bw", "267"], readonly ["br", "55", 0, any, "0"], readonly ["io", "246"], readonly ["vg", "1", 11, readonly ["284"], "1"], readonly ["bn", "673"], readonly ["bg", "359", 0, any, "0"], readonly ["bf", "226"], readonly ["bi", "257"], readonly ["kh", "855", 0, any, "0"], readonly ["cm", "237"], readonly ["ca", "1", 1, readonly ["204", "226", "236", "249", "250", "257", "263", "289", "306", "343", "354", "365", "367", "368", "382", "403", "416", "418", "428", "431", "437", "438", "450", "468", "474", "506", "514", "519", "548", "579", "581", "584", "587", "604", "613", "639", "647", "672", "683", "705", "709", "742", "753", "778", "780", "782", "807", "819", "825", "867", "873", "879", "902", "905", "942"], "1"], readonly ["cv", "238"], readonly ["bq", "599", 1, readonly ["3", "4", "7"]], readonly ["ky", "1", 12, readonly ["345"], "1"], readonly ["cf", "236"], readonly ["td", "235"], readonly ["cl", "56"], readonly ["cn", "86", 0, any, "0"], readonly ["cx", "61", 2, readonly ["4", "89164"], "0"], readonly ["cc", "61", 1, readonly ["4", "89162"], "0"], readonly ["co", "57", 0, any, "0"], readonly ["km", "269"], readonly ["cg", "242"], readonly ["cd", "243", 0, any, "0"], readonly ["ck", "682"], readonly ["cr", "506"], readonly ["ci", "225"], readonly ["hr", "385", 0, any, "0"], readonly ["cu", "53", 0, any, "0"], readonly ["cw", "599", 0], readonly ["cy", "357"], readonly ["cz", "420"], readonly ["dk", "45"], readonly ["dj", "253"], readonly ["dm", "1", 13, readonly ["767"], "1"], readonly ["do", "1", 2, readonly ["809", "829", "849"], "1"], readonly ["ec", "593", 0, any, "0"], readonly ["eg", "20", 0, any, "0"], readonly ["sv", "503"], readonly ["gq", "240"], readonly ["er", "291", 0, any, "0"], readonly ["ee", "372"], readonly ["sz", "268"], readonly ["et", "251", 0, any, "0"], readonly ["fk", "500"], readonly ["fo", "298"], readonly ["fj", "679"], readonly ["fi", "358", 0, readonly ["4"], "0"], readonly ["fr", "33", 0, any, "0"], readonly ["gf", "594", 0, any, "0"], readonly ["pf", "689"], readonly ["ga", "241"], readonly ["gm", "220"], readonly ["ge", "995", 0, any, "0"], readonly ["de", "49", 0, any, "0"], readonly ["gh", "233", 0, any, "0"], readonly ["gi", "350"], readonly ["gr", "30"], readonly ["gl", "299"], readonly ["gd", "1", 14, readonly ["473"], "1"], readonly ["gp", "590", 0, any, "0"], readonly ["gu", "1", 15, readonly ["671"], "1"], readonly ["gt", "502"], readonly ["gg", "44", 1, readonly ["1481", "7781", "7839", "7911"], "0"], readonly ["gn", "224"], readonly ["gw", "245"], readonly ["gy", "592"], readonly ["ht", "509"], readonly ["hn", "504"], readonly ["hk", "852"], readonly ["hu", "36", 0, any, "06"], readonly ["is", "354"], readonly ["in", "91", 0, any, "0"], readonly ["id", "62", 0, any, "0"], readonly ["ir", "98", 0, any, "0"], readonly ["iq", "964", 0, any, "0"], readonly ["ie", "353", 0, any, "0"], readonly ["im", "44", 2, readonly ["1624", "74576", "7524", "7624", "7924"], "0"], readonly ["il", "972", 0, any, "0"], readonly ["it", "39", 0, readonly ["3"]], readonly ["jm", "1", 4, readonly ["658", "876"], "1"], readonly ["jp", "81", 0, any, "0"], readonly ["je", "44", 3, readonly ["1534", "7509", "7700", "7797", "7829", "7937"], "0"], readonly ["jo", "962", 0, any, "0"], readonly ["kz", "7", 1, readonly ["33", "7"], "8"], readonly ["ke", "254", 0, any, "0"], readonly ["ki", "686", 0, any, "0"], readonly ["xk", "383", 0, any, "0"], readonly ["kw", "965"], readonly ["kg", "996", 0, any, "0"], readonly ["la", "856", 0, any, "0"], readonly ["lv", "371"], readonly ["lb", "961", 0, any, "0"], readonly ["ls", "266"], readonly ["lr", "231", 0, any, "0"], readonly ["ly", "218", 0, any, "0"], readonly ["li", "423", 0, any, "0"], readonly ["lt", "370", 0, any, "0"], readonly ["lu", "352"], readonly ["mo", "853"], readonly ["mg", "261", 0, any, "0"], readonly ["mw", "265", 0, any, "0"], readonly ["my", "60", 0, any, "0"], readonly ["mv", "960"], readonly ["ml", "223"], readonly ["mt", "356"], readonly ["mh", "692", 0, any, "1"], readonly ["mq", "596", 0, any, "0"], readonly ["mr", "222"], readonly ["mu", "230"], readonly ["yt", "262", 1, readonly ["269", "639"], "0"], readonly ["mx", "52"], readonly ["fm", "691"], readonly ["md", "373", 0, any, "0"], readonly ["mc", "377", 0, any, "0"], readonly ["mn", "976", 0, any, "0"], readonly ["me", "382", 0, any, "0"], readonly ["ms", "1", 16, readonly ["664"], "1"], readonly ["ma", "212", 0, readonly ["6", "7"], "0"], readonly ["mz", "258"], readonly ["mm", "95", 0, any, "0"], readonly ["na", "264", 0, any, "0"], readonly ["nr", "674"], readonly ["np", "977", 0, any, "0"], readonly ["nl", "31", 0, any, "0"], readonly ["nc", "687"], readonly ["nz", "64", 0, any, "0"], readonly ["ni", "505"], readonly ["ne", "227"], readonly ["ng", "234", 0, any, "0"], readonly ["nu", "683"], readonly ["nf", "672"], readonly ["kp", "850", 0, any, "0"], readonly ["mk", "389", 0, any, "0"], readonly ["mp", "1", 17, readonly ["670"], "1"], readonly ["no", "47", 0, readonly ["4", "9"]], readonly ["om", "968"], readonly ["pk", "92", 0, any, "0"], readonly ["pw", "680"], readonly ["ps", "970", 0, any, "0"], readonly ["pa", "507"], readonly ["pg", "675"], readonly ["py", "595", 0, any, "0"], readonly ["pe", "51", 0, any, "0"], readonly ["ph", "63", 0, any, "0"], readonly ["pl", "48"], readonly ["pt", "351"], readonly ["pr", "1", 3, readonly ["787", "939"], "1"], readonly ["qa", "974"], readonly ["re", "262", 0, any, "0"], readonly ["ro", "40", 0, any, "0"], readonly ["ru", "7", 0, readonly ["33"], "8"], readonly ["rw", "250", 0, any, "0"], readonly ["ws", "685"], readonly ["sm", "378"], readonly ["st", "239"], readonly ["sa", "966", 0, any, "0"], readonly ["sn", "221"], readonly ["rs", "381", 0, any, "0"], readonly ["sc", "248"], readonly ["sl", "232", 0, any, "0"], readonly ["sg", "65"], readonly ["sx", "1", 21, readonly ["721"], "1"], readonly ["sk", "421", 0, any, "0"], readonly ["si", "386", 0, any, "0"], readonly ["sb", "677"], readonly ["so", "252", 0, any, "0"], readonly ["za", "27", 0, any, "0"], readonly ["kr", "82", 0, any, "0"], readonly ["ss", "211", 0, any, "0"], readonly ["es", "34"], readonly ["lk", "94", 0, any, "0"], readonly ["bl", "590", 1, any, "0"], readonly ["sh", "290"], readonly ["kn", "1", 18, readonly ["869"], "1"], readonly ["lc", "1", 19, readonly ["758"], "1"], readonly ["mf", "590", 2, any, "0"], readonly ["pm", "508", 0, any, "0"], readonly ["vc", "1", 20, readonly ["784"], "1"], readonly ["sd", "249", 0, any, "0"], readonly ["sr", "597"], readonly ["sj", "47", 1, readonly ["4", "79", "9"]], readonly ["se", "46", 0, any, "0"], readonly ["ch", "41", 0, any, "0"], readonly ["sy", "963", 0, any, "0"], readonly ["tw", "886", 0, any, "0"], readonly ["tj", "992"], readonly ["tz", "255", 0, any, "0"], readonly ["th", "66", 0, any, "0"], readonly ["tl", "670"], readonly ["tg", "228"], readonly ["tk", "690"], readonly ["to", "676"], readonly ["tt", "1", 22, readonly ["868"], "1"], readonly ["tn", "216"], readonly ["tr", "90", 0, any, "0"], readonly ["tm", "993", 0, any, "8"], readonly ["tc", "1", 23, readonly ["649"], "1"], readonly ["tv", "688"], readonly ["vi", "1", 24, readonly ["340"], "1"], readonly ["ug", "256", 0, any, "0"], readonly ["ua", "380", 0, any, "0"], readonly ["ae", "971", 0, any, "0"], readonly ["gb", "44", 0, any, "0"], readonly ["us", "1", 0, any, "1"], readonly ["uy", "598", 0, any, "0"], readonly ["uz", "998"], readonly ["vu", "678"], readonly ["va", "39", 1, readonly ["06698", "3"]], readonly ["ve", "58", 0, any, "0"], readonly ["vn", "84", 0, any, "0"], readonly ["wf", "681"], readonly ["eh", "212", 1, readonly ["5288", "5289", "6", "7"], "0"], readonly ["ye", "967", 0, any, "0"], readonly ["zm", "260", 0, any, "0"], readonly ["zw", "263", 0, any, "0"]];
    export type Iso2 = typeof rawCountryData[number][0];
    export type Country = {
        iso2: Iso2;
        dialCode: string;
        priority: number;
        areaCodes: string[] | null;
        nationalPrefix: string | null;
        name: string;
        nodeById: {
            [instanceId: number]: HTMLElement;
        };
        normalisedName: string;
        initials: string;
        dialCodePlus: string;
    };
    const allCountries: Country[];
    export default allCountries;
}
declare module "intl-tel-input/i18n/types" {
    import type { Iso2 } from "intl-tel-input/data";
    export type I18n = Partial<Record<Iso2, string>> & {
        selectedCountryAriaLabel?: string;
        searchPlaceholder?: string;
        clearSearchAriaLabel?: string;
        countryListAriaLabel?: string;
        oneSearchResult?: string;
        multipleSearchResults?: string;
        noCountrySelected?: string;
        zeroSearchResults?: string;
        searchResultsText?: (count: number) => string;
    };
}
declare module "intl-tel-input/i18n/en/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/en/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/en" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/en/countries";
    import interfaceTranslations from "intl-tel-input/i18n/en/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "modules/constants" {
    import { Iso2 } from "intl-tel-input/data";
    export const EVENTS: {
        readonly OPEN_COUNTRY_DROPDOWN: "open:countrydropdown";
        readonly CLOSE_COUNTRY_DROPDOWN: "close:countrydropdown";
        readonly COUNTRY_CHANGE: "countrychange";
        readonly INPUT: "input";
    };
    export const CLASSES: {
        readonly HIDE: "iti__hide";
        readonly V_HIDE: "iti__v-hide";
        readonly ARROW_UP: "iti__arrow--up";
        readonly GLOBE: "iti__globe";
        readonly FLAG: "iti__flag";
        readonly COUNTRY_ITEM: "iti__country";
        readonly HIGHLIGHT: "iti__highlight";
    };
    export const KEYS: {
        readonly ARROW_UP: "ArrowUp";
        readonly ARROW_DOWN: "ArrowDown";
        readonly SPACE: " ";
        readonly ENTER: "Enter";
        readonly ESC: "Escape";
        readonly TAB: "Tab";
    };
    export const INPUT_TYPES: {
        readonly PASTE: "insertFromPaste";
        readonly DELETE_FWD: "deleteContentForward";
    };
    export const REGEX: {
        readonly ALPHA_UNICODE: RegExp;
        readonly NON_PLUS_NUMERIC: RegExp;
        readonly NON_PLUS_NUMERIC_GLOBAL: RegExp;
        readonly HIDDEN_SEARCH_CHAR: RegExp;
    };
    export const TIMINGS: {
        readonly SEARCH_DEBOUNCE_MS: 100;
        readonly HIDDEN_SEARCH_RESET_MS: 1000;
        readonly NEXT_TICK: 0;
    };
    export const SENTINELS: {
        readonly UNKNOWN_NUMBER_TYPE: -99;
        readonly UNKNOWN_VALIDATION_ERROR: -99;
    };
    export const LAYOUT: {
        readonly SANE_SELECTED_WITH_DIAL_WIDTH: 78;
        readonly SANE_SELECTED_NO_DIAL_WIDTH: 42;
        readonly INPUT_PADDING_EXTRA_LEFT: 6;
    };
    export const DIAL: {
        readonly PLUS: "+";
        readonly NANP: "1";
    };
    export const UK: {
        readonly ISO2: Iso2;
        readonly DIAL_CODE: "44";
        readonly MOBILE_PREFIX: "7";
        readonly MOBILE_CORE_LENGTH: 10;
    };
    export const US: {
        ISO2: Iso2;
        DIAL_CODE: string;
    };
    export const PLACEHOLDER_MODES: {
        readonly AGGRESSIVE: "aggressive";
        readonly POLITE: "polite";
        readonly OFF: "off";
    };
    export const INITIAL_COUNTRY: {
        readonly AUTO: "auto";
    };
    export const DATA_KEYS: {
        readonly COUNTRY_CODE: "countryCode";
        readonly DIAL_CODE: "dialCode";
    };
    export const ARIA: {
        readonly EXPANDED: "aria-expanded";
        readonly LABEL: "aria-label";
        readonly SELECTED: "aria-selected";
        readonly ACTIVE_DESCENDANT: "aria-activedescendant";
        readonly HASPOPUP: "aria-haspopup";
        readonly CONTROLS: "aria-controls";
        readonly HIDDEN: "aria-hidden";
        readonly AUTOCOMPLETE: "aria-autocomplete";
        readonly MODAL: "aria-modal";
    };
}
declare module "modules/types/public-api" {
    import type { Country, Iso2 } from "intl-tel-input/data";
    import type { I18n } from "intl-tel-input/i18n/types";
    import type { Iti } from "intl-tel-input";
    import type { PLACEHOLDER_MODES } from "modules/constants";
    export type UtilsLoader = () => Promise<{
        default: ItiUtils;
    }>;
    export type ItiUtils = {
        formatNumber(number: string, iso2: string | undefined, format?: number): string;
        formatNumberAsYouType(number: string, iso2: string | undefined): string;
        getCoreNumber(number: string, iso2: string | undefined): string;
        getExampleNumber(iso2: string | undefined, nationalMode: boolean, numberType: number, useE164?: boolean): string;
        getExtension(number: string, iso2: string | undefined): string;
        getNumberType(number: string, iso2: string | undefined): number;
        getValidationError(number: string, iso2: string | undefined): number;
        isPossibleNumber(number: string, iso2: string | undefined, numberType?: NumberType[] | null): boolean;
        isValidNumber(number: string, iso2: string | undefined, numberType?: NumberType[] | null): boolean;
        numberFormat: {
            NATIONAL: number;
            INTERNATIONAL: number;
            E164: number;
            RFC3966: number;
        };
        numberType: Record<string, number>;
    };
    export type NumberType = "FIXED_LINE_OR_MOBILE" | "FIXED_LINE" | "MOBILE" | "PAGER" | "PERSONAL_NUMBER" | "PREMIUM_RATE" | "SHARED_COST" | "TOLL_FREE" | "UAN" | "UNKNOWN" | "VOICEMAIL" | "VOIP";
    type ValueOf<T> = T[keyof T];
    export interface AllOptions {
        allowDropdown: boolean;
        allowPhonewords: boolean;
        autoPlaceholder: ValueOf<typeof PLACEHOLDER_MODES>;
        containerClass: string;
        countryOrder: Iso2[] | null;
        countrySearch: boolean;
        customPlaceholder: ((selectedCountryPlaceholder: string, selectedCountryData: SelectedCountryData) => string) | null;
        dropdownContainer: HTMLElement | null;
        excludeCountries: Iso2[];
        fixDropdownWidth: boolean;
        formatAsYouType: boolean;
        formatOnDisplay: boolean;
        geoIpLookup: ((success: (iso2: Iso2) => void, failure: () => void) => void) | null;
        hiddenInput: ((telInputName: string) => {
            phone: string;
            country?: string;
        }) | null;
        i18n: I18n;
        initialCountry: Iso2 | "auto" | "";
        loadUtils: UtilsLoader | null;
        nationalMode: boolean;
        onlyCountries: Iso2[];
        placeholderNumberType: NumberType;
        showFlags: boolean;
        separateDialCode: boolean;
        strictMode: boolean;
        useFullscreenPopup: boolean;
        validationNumberTypes: NumberType[] | null;
    }
    export type SomeOptions = Partial<AllOptions>;
    export interface IntlTelInputInterface {
        (input: HTMLInputElement, options?: SomeOptions): Iti;
        autoCountry?: Iso2;
        defaults: AllOptions;
        documentReady: () => boolean;
        getCountryData: () => Country[];
        getInstance: (input: HTMLInputElement) => Iti | null;
        instances: {
            [key: string]: Iti;
        };
        attachUtils: (source: UtilsLoader) => Promise<unknown> | null;
        startedLoadingAutoCountry: boolean;
        startedLoadingUtilsScript: boolean;
        version: string | undefined;
        utils?: ItiUtils;
    }
    type EmptyObject = Record<string, never>;
    export type SelectedCountryData = Country | EmptyObject;
}
declare module "modules/core/options" {
    import { I18n } from "intl-tel-input/i18n/types";
    import type { AllOptions } from "modules/types/public-api";
    export const defaults: AllOptions;
    export const applyOptionSideEffects: (o: AllOptions, defaultEnglishStrings: I18n) => void;
}
declare module "modules/utils/string" {
    export const getNumeric: (s: string) => string;
    export const normaliseString: (s?: string) => string;
}
declare module "modules/core/countrySearch" {
    import type { Country } from "intl-tel-input/data";
    /**
     * Country search: Given raw query, return ordered list of countries by priority buckets.
     * Buckets (in order):
     *  1. exact ISO2 matches
     *  2. name starts with
     *  3. name contains
     *  4. dial code exact match (bare or with plus)
     *  5. dial code contains (with plus form)
     *  6. initials match
     * Each bucket preserves country.priority ordering.
     */
    export const getMatchedCountries: (countries: Country[], query: string) => Country[];
    /**
     * Hidden search (when countrySearch disabled): find first whose name starts with query (case-insensitive).
     */
    export const findFirstCountryStartingWith: (countries: Country[], query: string) => Country | null;
}
declare module "modules/utils/dom" {
    /**
     * Build a space-delimited class string from an object map of className -> truthy/falsey.
     * Only keys with truthy values are included.
     */
    export const buildClassNames: (flags: Record<string, unknown>) => string;
    export const createEl: (tagName: string, attrs?: object | null, container?: HTMLElement) => HTMLElement;
}
declare module "modules/core/icons" {
    /** Magnifying glass search icon */
    export const buildSearchIcon: () => string;
    /**
     * Clear (circle with X) icon
     * @param id Instance id used to create a unique mask id.
     */
    export const buildClearIcon: (id: number) => string;
}
declare module "modules/core/ui" {
    import { Country } from "intl-tel-input/data";
    import { AllOptions } from "modules/types/public-api";
    export default class UI {
        private readonly options;
        private readonly id;
        private readonly isRTL;
        private readonly originalPaddingLeft;
        private countries;
        telInput: HTMLInputElement;
        countryContainer: HTMLElement;
        selectedCountry: HTMLElement;
        selectedCountryInner: HTMLElement;
        selectedDialCode: HTMLElement;
        dropdownArrow: HTMLElement;
        dropdownContent: HTMLElement;
        searchInput: HTMLInputElement;
        searchIcon: HTMLElement;
        searchClearButton: HTMLButtonElement;
        searchNoResults: HTMLElement;
        searchResultsA11yText: HTMLElement;
        countryList: HTMLElement;
        dropdown: HTMLElement;
        hiddenInput: HTMLInputElement;
        hiddenInputCountry: HTMLInputElement;
        highlightedItem: HTMLElement | null;
        readonly hadInitialPlaceholder: boolean;
        constructor(input: HTMLInputElement, options: AllOptions, id: number);
        generateMarkup(countries: Country[]): void;
        private _prepareTelInput;
        private _createWrapperAndInsert;
        private _maybeBuildCountryContainer;
        private _buildDropdownContent;
        private _buildSearchUI;
        private _maybeUpdateInputPaddingAndReveal;
        private _maybeBuildHiddenInputs;
        private _appendListItems;
        updateInputPadding(): void;
        private _getHiddenSelectedCountryWidth;
        updateSearchResultsA11yText(): void;
        scrollTo(element: HTMLElement): void;
        highlightListItem(listItem: HTMLElement | null, shouldFocus: boolean): void;
        filterCountries(matchedCountries: Country[]): void;
        destroy(): void;
    }
}
declare module "modules/data/country-data" {
    import { Country, Iso2 } from "intl-tel-input/data";
    import type { AllOptions } from "modules/types/public-api";
    export interface DialCodeProcessingResult {
        dialCodes: Set<string>;
        dialCodeMaxLen: number;
        dialCodeToIso2Map: Record<string, Iso2[]>;
    }
    export const processAllCountries: (options: AllOptions) => Country[];
    export const translateCountryNames: (countries: Country[], options: AllOptions) => void;
    export const processDialCodes: (countries: Country[], options: AllOptions) => DialCodeProcessingResult;
    export const sortCountries: (countries: Country[], options: AllOptions) => void;
    export const cacheSearchTokens: (countries: Country[]) => void;
}
declare module "modules/format/formatting" {
    import { SelectedCountryData } from "modules/types/public-api";
    export const beforeSetNumber: (fullNumber: string, dialCode: string, separateDialCode: boolean, selectedCountryData: SelectedCountryData) => string;
    export const formatNumberAsYouType: (fullNumber: string, telInputValue: string, utils: any, selectedCountryData: SelectedCountryData, separateDialCode: boolean) => string;
}
declare module "modules/format/caret" {
    export const translateCursorPosition: (relevantChars: number, formattedValue: string, prevCaretPos: number, isDeleteForwards: boolean) => number;
}
declare module "modules/data/nanp-regionless" {
    export const regionlessNanpNumbers: string[];
    export const isRegionlessNanp: (number: string) => boolean;
}
declare module "modules/types/events" {
    import { EVENTS } from "modules/constants";
    export type ItiEventMap = {
        [EVENTS.COUNTRY_CHANGE]: Record<string, never>;
        [EVENTS.OPEN_COUNTRY_DROPDOWN]: Record<string, never>;
        [EVENTS.CLOSE_COUNTRY_DROPDOWN]: Record<string, never>;
        [EVENTS.INPUT]: {
            isSetNumber?: boolean;
        };
    };
}
declare module "intl-tel-input" {
    import { Iso2 } from "intl-tel-input/data";
    import type { NumberType, SomeOptions, IntlTelInputInterface, SelectedCountryData } from "modules/types/public-api";
    global {
        interface HTMLInputElement {
            iti?: Iti;
        }
    }
    export class Iti {
        readonly id: number;
        readonly promise: Promise<[unknown, unknown]>;
        private readonly ui;
        private readonly options;
        private readonly isAndroid;
        private readonly countries;
        private readonly dialCodeMaxLen;
        private readonly dialCodeToIso2Map;
        private readonly dialCodes;
        private readonly countryByIso2;
        private selectedCountryData;
        private maxCoreNumberLength;
        private defaultCountry;
        private abortController;
        private dropdownAbortController;
        private resolveAutoCountryPromise;
        private rejectAutoCountryPromise;
        private resolveUtilsScriptPromise;
        private rejectUtilsScriptPromise;
        constructor(input: HTMLInputElement, customOptions?: SomeOptions);
        private static _getIsAndroid;
        private _createInitPromises;
        _init(): void;
        private _processCountryData;
        private _setInitialState;
        private _initListeners;
        private _initHiddenInputListener;
        private _initDropdownListeners;
        private _initRequests;
        private _loadAutoCountry;
        private _openDropdownWithPlus;
        private _initTelInputListeners;
        private _bindInputListener;
        private _maybeBindKeydownListener;
        private _maybeBindPasteListener;
        private _cap;
        private _trigger;
        private _openDropdown;
        private _setDropdownPosition;
        private _bindDropdownListeners;
        private _bindDropdownMouseoverListener;
        private _bindDropdownCountryClickListener;
        private _bindDropdownClickOffListener;
        private _bindDropdownKeydownListener;
        private _bindDropdownSearchListeners;
        private _searchForCountry;
        private _filterCountriesByQuery;
        private _handleUpDownKey;
        private _handleEnterKey;
        private _updateValFromNumber;
        private _updateCountryFromNumber;
        private _ensureHasDialCode;
        private _getNewCountryFromNumber;
        private _setCountry;
        private _updateMaxLength;
        private _updatePlaceholder;
        private _selectListItem;
        private _closeDropdown;
        private _updateDialCode;
        private _getDialCode;
        private _getFullNumber;
        private _beforeSetNumber;
        private _triggerCountryChange;
        handleAutoCountry(): void;
        handleUtils(): void;
        destroy(): void;
        getExtension(): string;
        getNumber(format?: number): string;
        getNumberType(): number;
        getSelectedCountryData(): SelectedCountryData;
        getValidationError(): number;
        isValidNumber(): boolean | null;
        isValidNumberPrecise(): boolean | null;
        private _utilsIsPossibleNumber;
        private _validateNumber;
        private _utilsIsValidNumber;
        setCountry(iso2: Iso2): void;
        setNumber(number: string): void;
        setPlaceholderNumberType(type: NumberType): void;
        setDisabled(disabled: boolean): void;
    }
    const intlTelInput: IntlTelInputInterface;
    export default intlTelInput;
}
declare module "intl-tel-input/utils" {
    export default utils;
    const utils: any;
}
declare module "intl-tel-input/intlTelInputWithUtils" {
    import intlTelInput from "intl-tel-input";
    export default intlTelInput;
}
declare module "intl-tel-input/i18n/ar/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/ar/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/ar" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/ar/countries";
    import interfaceTranslations from "intl-tel-input/i18n/ar/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/bg/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/bg/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/bg" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/bg/countries";
    import interfaceTranslations from "intl-tel-input/i18n/bg/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/bn/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/bn/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/bn" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/bn/countries";
    import interfaceTranslations from "intl-tel-input/i18n/bn/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/bs/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/bs/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/bs" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/bs/countries";
    import interfaceTranslations from "intl-tel-input/i18n/bs/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/ca/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/ca/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/ca" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/ca/countries";
    import interfaceTranslations from "intl-tel-input/i18n/ca/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/cs/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/cs/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/cs" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/cs/countries";
    import interfaceTranslations from "intl-tel-input/i18n/cs/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/da/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/da/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/da" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/da/countries";
    import interfaceTranslations from "intl-tel-input/i18n/da/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/de/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/de/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/de" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/de/countries";
    import interfaceTranslations from "intl-tel-input/i18n/de/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/ee/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/ee/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/ee" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/ee/countries";
    import interfaceTranslations from "intl-tel-input/i18n/ee/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/el/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/el/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/el" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/el/countries";
    import interfaceTranslations from "intl-tel-input/i18n/el/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/es/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/es/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/es" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/es/countries";
    import interfaceTranslations from "intl-tel-input/i18n/es/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/fa/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/fa/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/fa" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/fa/countries";
    import interfaceTranslations from "intl-tel-input/i18n/fa/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/fi/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/fi/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/fi" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/fi/countries";
    import interfaceTranslations from "intl-tel-input/i18n/fi/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/fr/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/fr/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/fr" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/fr/countries";
    import interfaceTranslations from "intl-tel-input/i18n/fr/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/hi/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/hi/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/hi" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/hi/countries";
    import interfaceTranslations from "intl-tel-input/i18n/hi/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/hr/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/hr/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/hr" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/hr/countries";
    import interfaceTranslations from "intl-tel-input/i18n/hr/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/hu/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/hu/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/hu" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/hu/countries";
    import interfaceTranslations from "intl-tel-input/i18n/hu/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/id/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/id/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/id" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/id/countries";
    import interfaceTranslations from "intl-tel-input/i18n/id/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/it/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/it/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/it" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/it/countries";
    import interfaceTranslations from "intl-tel-input/i18n/it/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/ja/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/ja/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/ja" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/ja/countries";
    import interfaceTranslations from "intl-tel-input/i18n/ja/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/ko/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/ko/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/ko" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/ko/countries";
    import interfaceTranslations from "intl-tel-input/i18n/ko/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/lt/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/lt/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/lt" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/lt/countries";
    import interfaceTranslations from "intl-tel-input/i18n/lt/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/mr/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/mr/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/mr" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/mr/countries";
    import interfaceTranslations from "intl-tel-input/i18n/mr/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/nl/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/nl/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/nl" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/nl/countries";
    import interfaceTranslations from "intl-tel-input/i18n/nl/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/no/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/no/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/no" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/no/countries";
    import interfaceTranslations from "intl-tel-input/i18n/no/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/pl/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/pl/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/pl" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/pl/countries";
    import interfaceTranslations from "intl-tel-input/i18n/pl/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/pt/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/pt/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/pt" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/pt/countries";
    import interfaceTranslations from "intl-tel-input/i18n/pt/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/ro/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/ro/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/ro" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/ro/countries";
    import interfaceTranslations from "intl-tel-input/i18n/ro/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/ru/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/ru/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/ru" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/ru/countries";
    import interfaceTranslations from "intl-tel-input/i18n/ru/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/sk/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/sk/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/sk" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/sk/countries";
    import interfaceTranslations from "intl-tel-input/i18n/sk/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/sl/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/sl/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/sl" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/sl/countries";
    import interfaceTranslations from "intl-tel-input/i18n/sl/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/sq/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/sq/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/sq" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/sq/countries";
    import interfaceTranslations from "intl-tel-input/i18n/sq/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/sr/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/sr/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/sr" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/sr/countries";
    import interfaceTranslations from "intl-tel-input/i18n/sr/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/sv/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/sv/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/sv" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/sv/countries";
    import interfaceTranslations from "intl-tel-input/i18n/sv/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/te/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/te/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/te" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/te/countries";
    import interfaceTranslations from "intl-tel-input/i18n/te/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/th/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/th/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/th" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/th/countries";
    import interfaceTranslations from "intl-tel-input/i18n/th/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/tr/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/tr/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/tr" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/tr/countries";
    import interfaceTranslations from "intl-tel-input/i18n/tr/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/uk/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/uk/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/uk" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/uk/countries";
    import interfaceTranslations from "intl-tel-input/i18n/uk/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/ur/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/ur/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/ur" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/ur/countries";
    import interfaceTranslations from "intl-tel-input/i18n/ur/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/uz/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/uz/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/uz" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/uz/countries";
    import interfaceTranslations from "intl-tel-input/i18n/uz/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/vi/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/vi/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/vi" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/vi/countries";
    import interfaceTranslations from "intl-tel-input/i18n/vi/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n/zh/countries" {
    import { I18n } from "intl-tel-input/i18n/types";
    const countryTranslations: I18n;
    export default countryTranslations;
}
declare module "intl-tel-input/i18n/zh/interface" {
    import { I18n } from "intl-tel-input/i18n/types";
    const interfaceTranslations: I18n;
    export default interfaceTranslations;
}
declare module "intl-tel-input/i18n/zh" {
    import { I18n } from "intl-tel-input/i18n/types";
    import countryTranslations from "intl-tel-input/i18n/zh/countries";
    import interfaceTranslations from "intl-tel-input/i18n/zh/interface";
    export { countryTranslations, interfaceTranslations };
    const allTranslations: I18n;
    export default allTranslations;
}
declare module "intl-tel-input/i18n" {
    export { default as ar, countryTranslations as arCountryTranslations, interfaceTranslations as arInterfaceTranslations } from "intl-tel-input/i18n/ar";
    export { default as bg, countryTranslations as bgCountryTranslations, interfaceTranslations as bgInterfaceTranslations } from "intl-tel-input/i18n/bg";
    export { default as bn, countryTranslations as bnCountryTranslations, interfaceTranslations as bnInterfaceTranslations } from "intl-tel-input/i18n/bn";
    export { default as bs, countryTranslations as bsCountryTranslations, interfaceTranslations as bsInterfaceTranslations } from "intl-tel-input/i18n/bs";
    export { default as ca, countryTranslations as caCountryTranslations, interfaceTranslations as caInterfaceTranslations } from "intl-tel-input/i18n/ca";
    export { default as cs, countryTranslations as csCountryTranslations, interfaceTranslations as csInterfaceTranslations } from "intl-tel-input/i18n/cs";
    export { default as da, countryTranslations as daCountryTranslations, interfaceTranslations as daInterfaceTranslations } from "intl-tel-input/i18n/da";
    export { default as de, countryTranslations as deCountryTranslations, interfaceTranslations as deInterfaceTranslations } from "intl-tel-input/i18n/de";
    export { default as ee, countryTranslations as eeCountryTranslations, interfaceTranslations as eeInterfaceTranslations } from "intl-tel-input/i18n/ee";
    export { default as el, countryTranslations as elCountryTranslations, interfaceTranslations as elInterfaceTranslations } from "intl-tel-input/i18n/el";
    export { default as en, countryTranslations as enCountryTranslations, interfaceTranslations as enInterfaceTranslations } from "intl-tel-input/i18n/en";
    export { default as es, countryTranslations as esCountryTranslations, interfaceTranslations as esInterfaceTranslations } from "intl-tel-input/i18n/es";
    export { default as fa, countryTranslations as faCountryTranslations, interfaceTranslations as faInterfaceTranslations } from "intl-tel-input/i18n/fa";
    export { default as fi, countryTranslations as fiCountryTranslations, interfaceTranslations as fiInterfaceTranslations } from "intl-tel-input/i18n/fi";
    export { default as fr, countryTranslations as frCountryTranslations, interfaceTranslations as frInterfaceTranslations } from "intl-tel-input/i18n/fr";
    export { default as hi, countryTranslations as hiCountryTranslations, interfaceTranslations as hiInterfaceTranslations } from "intl-tel-input/i18n/hi";
    export { default as hr, countryTranslations as hrCountryTranslations, interfaceTranslations as hrInterfaceTranslations } from "intl-tel-input/i18n/hr";
    export { default as hu, countryTranslations as huCountryTranslations, interfaceTranslations as huInterfaceTranslations } from "intl-tel-input/i18n/hu";
    export { default as id, countryTranslations as idCountryTranslations, interfaceTranslations as idInterfaceTranslations } from "intl-tel-input/i18n/id";
    export { default as it, countryTranslations as itCountryTranslations, interfaceTranslations as itInterfaceTranslations } from "intl-tel-input/i18n/it";
    export { default as ja, countryTranslations as jaCountryTranslations, interfaceTranslations as jaInterfaceTranslations } from "intl-tel-input/i18n/ja";
    export { default as ko, countryTranslations as koCountryTranslations, interfaceTranslations as koInterfaceTranslations } from "intl-tel-input/i18n/ko";
    export { default as lt, countryTranslations as ltCountryTranslations, interfaceTranslations as ltInterfaceTranslations } from "intl-tel-input/i18n/lt";
    export { default as mr, countryTranslations as mrCountryTranslations, interfaceTranslations as mrInterfaceTranslations } from "intl-tel-input/i18n/mr";
    export { default as nl, countryTranslations as nlCountryTranslations, interfaceTranslations as nlInterfaceTranslations } from "intl-tel-input/i18n/nl";
    export { default as no, countryTranslations as noCountryTranslations, interfaceTranslations as noInterfaceTranslations } from "intl-tel-input/i18n/no";
    export { default as pl, countryTranslations as plCountryTranslations, interfaceTranslations as plInterfaceTranslations } from "intl-tel-input/i18n/pl";
    export { default as pt, countryTranslations as ptCountryTranslations, interfaceTranslations as ptInterfaceTranslations } from "intl-tel-input/i18n/pt";
    export { default as ro, countryTranslations as roCountryTranslations, interfaceTranslations as roInterfaceTranslations } from "intl-tel-input/i18n/ro";
    export { default as ru, countryTranslations as ruCountryTranslations, interfaceTranslations as ruInterfaceTranslations } from "intl-tel-input/i18n/ru";
    export { default as sk, countryTranslations as skCountryTranslations, interfaceTranslations as skInterfaceTranslations } from "intl-tel-input/i18n/sk";
    export { default as sl, countryTranslations as slCountryTranslations, interfaceTranslations as slInterfaceTranslations } from "intl-tel-input/i18n/sl";
    export { default as sq, countryTranslations as sqCountryTranslations, interfaceTranslations as sqInterfaceTranslations } from "intl-tel-input/i18n/sq";
    export { default as sr, countryTranslations as srCountryTranslations, interfaceTranslations as srInterfaceTranslations } from "intl-tel-input/i18n/sr";
    export { default as sv, countryTranslations as svCountryTranslations, interfaceTranslations as svInterfaceTranslations } from "intl-tel-input/i18n/sv";
    export { default as te, countryTranslations as teCountryTranslations, interfaceTranslations as teInterfaceTranslations } from "intl-tel-input/i18n/te";
    export { default as th, countryTranslations as thCountryTranslations, interfaceTranslations as thInterfaceTranslations } from "intl-tel-input/i18n/th";
    export { default as tr, countryTranslations as trCountryTranslations, interfaceTranslations as trInterfaceTranslations } from "intl-tel-input/i18n/tr";
    export { default as uk, countryTranslations as ukCountryTranslations, interfaceTranslations as ukInterfaceTranslations } from "intl-tel-input/i18n/uk";
    export { default as ur, countryTranslations as urCountryTranslations, interfaceTranslations as urInterfaceTranslations } from "intl-tel-input/i18n/ur";
    export { default as uz, countryTranslations as uzCountryTranslations, interfaceTranslations as uzInterfaceTranslations } from "intl-tel-input/i18n/uz";
    export { default as vi, countryTranslations as viCountryTranslations, interfaceTranslations as viInterfaceTranslations } from "intl-tel-input/i18n/vi";
    export { default as zh, countryTranslations as zhCountryTranslations, interfaceTranslations as zhInterfaceTranslations } from "intl-tel-input/i18n/zh";
}
