<?php
$ep_functions = new Eventprime_Basic_Functions;
$ep_requests = new EP_Requests;
$is_recaptcha_enabled = 0;
if ( $ep_functions->ep_get_global_settings('checkout_reg_google_recaptcha') == 1 && ! empty( $ep_functions->ep_get_global_settings('google_recaptcha_site_key') ) ) {
    $is_recaptcha_enabled = 1; ?>
    <script src='https://www.google.com/recaptcha/api.js'></script><?php
}
?>

<?php if ( ! empty( $args->tickets ) && ! empty( $args->event ) && ! empty( $args->event->em_id ) ) { ?>
    <?php
    // ===== Determine if we should SKIP Attendee step (Step 1) =====
    $em_event_checkout_attendee_fields = ! empty( $args->event->em_event_checkout_attendee_fields ) ? $args->event->em_event_checkout_attendee_fields : array();
    $em_event_checkout_booking_fields  = ! empty( $args->event->em_event_checkout_booking_fields )  ? $args->event->em_event_checkout_booking_fields  : array();
    $em_event_checkout_fixed_fields    = ! empty( $args->event->em_event_checkout_fixed_fields )    ? $args->event->em_event_checkout_fixed_fields    : array();

    $has_attendee_name_parts = ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name'] ) && (
        ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_first_name'] ) ||
        ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_middle_name'] ) ||
        ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_last_name'] )
    );
    
   // var_dump($has_attendee_name_parts);
//    if($has_attendee_name_parts==false && !empty($em_event_checkout_attendee_fields) && isset($em_event_checkout_attendee_fields['em_event_checkout_fields_data']) )
//    {
//        
//            $has_attendee_name_parts = true;
//        
//        
//        
//    }
    // var_dump($em_event_checkout_attendee_fields);
    //  var_dump($has_attendee_name_parts);

    $has_attendee_custom = ! empty( $em_event_checkout_attendee_fields['em_event_checkout_fields_data'] );
    $has_booking_fields  = ! empty( $em_event_checkout_booking_fields['em_event_booking_fields_data'] );
    $has_fixed_terms     = ! empty( $em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_enabled'] );

    // Skip Step 1 (attendees/booking extra fields/terms) when no fields or terms exist
    $ep_skip_attendee_step = $ep_skip_attendee_step1 = !empty($args->event->em_hide_attendee_fields)?1:0;
    //var_dump($ep_skip_attendee_step);
    $guest_booking_enabled = ! empty( $ep_functions->ep_enabled_guest_booking() );
    $must_auth             = ( ! is_user_logged_in() && ! $guest_booking_enabled );
//var_dump($ep_skip_attendee_step);
    $checkout_text = $ep_functions->ep_global_settings_button_title('Checkout');
    ?>

    <div class="emagic ep-position-relative" id="ep_event_checkout_page">
        <?php do_action( 'ep_add_loader_section' ); ?>
        <div class="ep-box-wrap">
            <div class="ep-box-row ep-text-center ep-text-small">
                <?php if ( ! $ep_skip_attendee_step ) : ?>
                    <div class="ep-box-col-2 ep-checkout-steps-section">
                        <div class="ep-flex-column">
                            <div class="">
                                <span class="material-icons-round ep-bg-warning ep-rounded-circle ep-p-2" id="ep_booking_step1">view_list</span>
                            </div>
                            <div class="ep-fw-bold">
                                <?php esc_html_e( 'Step 1', 'eventprime-event-calendar-management' );?>
                            </div>
                            <div class="ep-text-small ep-text-muted">
                                <?php esc_html_e( 'Attendee Details', 'eventprime-event-calendar-management' );?>
                            </div>
                        </div>
                    </div>

                    <div class="ep-box-col-8 small text-danger">
                        <div id="ep_checkout_timer_section">
                            <span class="ep-text-dark">
                                <?php esc_html_e( 'You have', 'eventprime-event-calendar-management' );?>
                            </span>
                            <?php
                            $checkout_timer_sec = 260;
                            $checkout_timer_min = $ep_functions->ep_get_global_settings( 'checkout_page_timer' );
                            if ( $checkout_timer_min > 0 ) {
                                $checkout_timer_sec = $checkout_timer_min * 60;
                            }
                            ?>
                            <span class="ep-checkout-time ep-fw-bold"><?php echo absint( $checkout_timer_sec );?></span> <?php esc_html_e( 'seconds', 'eventprime-event-calendar-management' );?>
                            <span class="ep-text-dark">
                                <?php echo esc_html__( 'left to', 'eventprime-event-calendar-management' ) . ' ' . esc_html( $checkout_text );?>
                            </span>
                        </div>
                        <div class="ep-progress ep-bg-success ep-bg-opacity-10" style="height: 3px;">
                            <div class="ep-progress-bar ep-bg-danger" role="progressbar" style="width: 100%;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>

                    <div class="ep-box-col-2 ep-checkout-cart-section">
                        <div class="ep-flex-column">
                            <div class="ep-text-muted" id="ep-booking-step-2">
                                <span class="material-icons-round ep-bg-light ep-rounded-circle ep-p-2" id="ep_booking_step2">shopping_cart</span>
                            </div>
                            <div class="ep-fw-bold ep-text-muted">
                                <?php esc_html_e( 'Step 2', 'eventprime-event-calendar-management' );?>
                            </div>
                            <div class="ep-text-small ep-text-muted">
                                <?php echo esc_html( $checkout_text ) . ' ' . esc_html__( '& Payment', 'eventprime-event-calendar-management' );?>
                            </div>
                        </div>
                    </div>
                <?php else : ?>
                    <!-- Skipping attendee step: single step header (Checkout & Payment as Step 1) -->
                    <div class="ep-box-col-2 ep-checkout-steps-section">
                        <div class="ep-flex-column">
                            <div class="">
                                <!-- keep the id ep_booking_step2 for compatibility -->
                                <span class="material-icons-round ep-bg-warning ep-rounded-circle ep-p-2" id="ep_booking_step2">shopping_cart</span>
                            </div>
                            <div class="ep-fw-bold">
                                <?php esc_html_e( 'Step 1', 'eventprime-event-calendar-management' );?>
                            </div>
                            <div class="ep-text-small ep-text-muted">
                                <?php echo esc_html( $checkout_text ) . ' ' . esc_html__( '& Payment', 'eventprime-event-calendar-management' );?>
                            </div>
                        </div>
                    </div>

                    <div class="ep-box-col-8 small text-danger">
                        <div id="ep_checkout_timer_section">
                            <span class="ep-text-dark">
                                <?php esc_html_e( 'You have', 'eventprime-event-calendar-management' );?>
                            </span>
                            <?php
                            $checkout_timer_sec = 260;
                            $checkout_timer_min = $ep_functions->ep_get_global_settings( 'checkout_page_timer' );
                            if ( $checkout_timer_min > 0 ) {
                                $checkout_timer_sec = $checkout_timer_min * 60;
                            }
                            ?>
                            <span class="ep-checkout-time ep-fw-bold"><?php echo absint( $checkout_timer_sec );?></span> <?php esc_html_e( 'seconds', 'eventprime-event-calendar-management' );?>
                            <span class="ep-text-dark">
                                <?php echo esc_html__( 'left to', 'eventprime-event-calendar-management' ) . ' ' . esc_html( $checkout_text );?>
                            </span>
                        </div>
                        <div class="ep-progress ep-bg-success ep-bg-opacity-10" style="height: 3px;">
                            <div class="ep-progress-bar ep-bg-danger" role="progressbar" style="width: 100%;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="ep-box-row ep-mt-5 ep-mb-3">
                <?php if ( ! empty( $args->event->image_url ) ) { ?>
                    <div class="ep-box-col-2 ep-pr-2 ep-border-right ep-border-warning ep-border-3 ep-lh-0 ep-box-col-sm-2 ep-box-col-xsm-2">
                        <img class="ep-checkout-img-icon ep-rounded-1" src="<?php echo esc_url( $args->event->image_url );?>" alt="<?php echo esc_html( $args->event->name );?>" style="max-width:100%;">
                    </div>
                <?php } ?>
                <div class="ep-box-col-10 ep-text-start ep-lh-1 ep-box-col-sm-10 ep-box-col-xsm-10">
                    <div class="ep-fs-3 ep-fw-bold ep-mb-2"><?php echo esc_html( $args->event->name );?></div>
                    <div class="ep-fs-6">
                        <div class="ep-d-inline-flex ep-align-items-center">
                            <?php echo esc_html( $args->event->fstart_date );?>, <?php echo esc_html( $ep_functions->ep_convert_time_with_format( $args->event->em_start_time ) );?>
                            <?php if ( ! empty( $args->event->venue_details ) ) { ?>
                                <span class="material-icons-round ep-text-warning">arrow_right</span>
                            <?php } ?>
                        </div>
                        <div class="ep-d-inline-flex ep-text-muted">
                            <?php
                            if ( ! empty( $args->event->venue_details ) ) {
                                echo esc_html( $args->event->venue_details->name );
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="ep-box-row ep-mb-3">
                <form name="checkout_form" class="needs-validation ep-box-col-12" novalidate="" id="ep_event_checkout_form">
                    <input type="hidden" name="ep_event_booking_ticket_data" value="<?php echo esc_attr( json_encode( $args->tickets ) );?>" />
                    <input type="hidden" name="ep_event_booking_event_id" value="<?php echo esc_attr( $args->event->em_id );?>" />
                    <input type="hidden" name="ep_event_booking_user_id" value="<?php echo esc_attr( get_current_user_id() );?>" />

                    <div class="ep-box-row ep-g-5 ep-flex-row-reverse-md">
                        <!-- Right side Tickets info box -->
                        <div class="ep-box-col-4 ep-col-order-2 ep-checkout-total-price-section">
                            <ul class="ep-list-group ep-text-small ep-mx-0 ep-px-0 ep-m-0">

                                <?php do_action( 'ep_event_booking_before_ticket_info', $args ); ?>

                                <?php
                                $total_price   = 0;
                                $total_tickets = 0;
                                if ( ! empty( $args->tickets ) && count( $args->tickets ) > 0 ) {
                                    foreach ( $args->tickets as $tickets ) {
                                        $tic_sub_total = $tickets->price * $tickets->qty;
                                        $total_price  += $tic_sub_total;
                                        $total_tickets += $tickets->qty; ?>
                                        <li class="ep-list-group-item" aria-current="true">
                                            <span class="ep-fw-bold ep-mr-2">
                                                <?php echo esc_html( $tickets->name );?>
                                            </span>
                                            <span class="ep-text-small">x <?php echo absint( $tickets->qty );?></span>
                                            <div class="ep-box-row ep-text-small">
                                                <div class="ep-box-col-6">
                                                    <?php esc_html_e( 'Base Price', 'eventprime-event-calendar-management' );?>
                                                </div>
                                                <div class="ep-box-col-6 ep-text-end">
                                                    <?php echo esc_html( $ep_functions->ep_price_with_position( $tic_sub_total ) );?>
                                                </div>

                                                <?php if ( ! empty( $tickets->additional_fee ) && count( $tickets->additional_fee ) > 0 ) {
                                                    foreach ( $tickets->additional_fee as $fee ) {
                                                        $add_price   = $fee['price'];
                                                        $total_price += $add_price; ?>
                                                        <div class="ep-box-col-6 ep-text-muted">
                                                            <?php echo esc_html( $fee['label'] );?>
                                                        </div>
                                                        <div class="ep-box-col-6 ep-text-end ep-text-muted">
                                                            <?php echo esc_html( $ep_functions->ep_price_with_position( $add_price ) );?>
                                                        </div>
                                                    <?php }
                                                } ?>

                                                <!-- Offers -->
                                                <?php if ( isset( $tickets->offer ) && ! empty( $tickets->offer ) ) {
                                                    $total_price -= $tickets->offer; ?>
                                                    <div class="ep-box-col-6 ep-text-muted">
                                                        <?php esc_html_e( 'Offers', 'eventprime-event-calendar-management' );?>
                                                    </div>
                                                    <div class="ep-box-col-6 ep-text-end ep-text-muted"><?php echo esc_html( '-' . $ep_functions->ep_price_with_position( $tickets->offer ) );?></div>
                                                <?php } ?>

                                                <?php do_action( 'ep_event_booking_after_single_ticket_info', $tickets ); ?>
                                            </div>
                                        </li>
                                    <?php }
                                } ?>

                                <?php do_action( 'ep_event_booking_after_ticket_info', $args ); ?>

                                <!-- Event Fixed Price -->
                                <?php if ( $args->event->em_fixed_event_price && $args->event->em_fixed_event_price > 0 ) {
                                    $total_price += $args->event->em_fixed_event_price; ?>
                                    <li class="ep-list-group-item" aria-current="true">
                                        <div class="ep-box-row ep-py-2">
                                            <div class="ep-box-col-6 ep-fw-bold ep-popover-wrap">
                                                <span><?php esc_html_e( 'Event Fee', 'eventprime-event-calendar-management' );?></span>
                                                <span class="ep-align-middle ep-cursor ep-popover-icon ep-position-relative">
                                                    <span class="material-icons-round ep-fs-6 ep-text-muted ep-align-middle ep-ml-1">help_outline</span>
                                                    <span class="ep-popover-info" style="display: none"><?php esc_html_e( 'One-Time Event Booking Fee', 'eventprime-event-calendar-management' );?><span class="ep-popover-nub"></span>
                                                </span>
                                            </div>
                                            <div class="ep-box-col-6 ep-text-end">
                                                <?php echo esc_html( $ep_functions->ep_price_with_position( $args->event->em_fixed_event_price ) );?>
                                                <input type="hidden" name="ep_event_booking_event_fixed_price" value="<?php echo esc_attr( $args->event->em_fixed_event_price );?>" />
                                            </div>
                                        </div>
                                    </li>
                                <?php } ?>

                                <?php
                                do_action( 'ep_event_booking_before_ticket_total', $args );
                                do_action( 'ep_event_booking_before_ticket_total_new', $total_price, $total_tickets, $args, [] );
                                ?>

                                <!-- Total Price -->
                                <li class="ep-list-group-item ep-bg-light" id="ep-booking-total" aria-current="true">
                                    <input type="hidden" name="ep_event_booking_sub_total_price" value="<?php echo esc_attr( round( $total_price, 2 ) );?>" />
                                    <div class="ep-box-row ep-py-2 ep-fs-5">
                                        <div class="ep-box-col-6 ep-fw-bold ep-ticket-total-section">
                                            <?php esc_html_e( 'Total', 'eventprime-event-calendar-management' );?>
                                        </div>
                                        <div class="ep-box-col-6 ep-text-end ep-fw-bold ep-ticket-total-price-section">
                                            <?php
                                            $total_price = apply_filters( 'ep_event_booking_total_price', $total_price, $args->event->id );
                                            do_action( 'ep_event_booking_event_total', $total_price, $total_tickets, $args->event->id, array() );
                                            ?>
                                        </div>
                                    </div>
                                </li>

                                <?php do_action( 'ep_event_booking_after_ticket_total', $args ); ?>
                            </ul>

                            <?php do_action( 'ep_event_booking_after_ticket_info_box', $args ); ?>

                            <?php
                            // Show/hide primary button based on availability (as in your original)
                            $show_button = true;
                            if ( isset( $is_able_to_purchase ) && ( $is_able_to_purchase[0] === false || $total_tickets > $is_able_to_purchase[0] ) ) {
                                $show_button = false; ?>
                                <div class="ep-btn-light ep-text-danger ep-box-w-100 ep-mb-2 ep-py-2">
                                    <?php echo isset( $is_able_to_purchase[1] ) ? esc_html( $is_able_to_purchase[1] ) : ''; ?>
                                </div>
                            <?php }

                            $args->show_checkout_button = $show_button;
                            if ( ! class_exists('Eventprime_Woocommerce_Checkout_Integration') ) {
                                $args->event->enable_event_wc_checkout = null;
                            }

                            do_action( 'ep_event_booking_before_checkout_button', $args );
                            wp_nonce_field( 'ep_save_event_booking', 'ep_save_event_booking_nonce' );

              
                            // NEW: consider free checkouts (0 or "0")
                            $is_free_checkout = empty( $total_price );

                            // NEW: offline processor toggle (treat any non-empty / non-falsey as enabled)
                            $offline_setting  = $ep_functions->ep_get_global_settings( 'offline_processor' );
                            $offline_enabled  = ! empty( $offline_setting ) && $offline_setting !== '0' && $offline_setting !== 'off' && $offline_setting !== 'no' && $offline_setting !== false;

                            // (optional) remove your var_dumps once done debugging
                            // var_dump($ep_skip_attendee_step, $is_free_checkout, $show_button, $offline_setting);

                            // Should we render the button at all?
                            $button_should_render = ( !$ep_skip_attendee_step || $is_free_checkout || $offline_enabled)
                                && isset( $args->event )
                                && $show_button
                                && ( ! isset( $args->event->enable_event_wc_checkout ) || empty( $args->event->enable_event_wc_checkout ) );
                            //var_dump($button_should_render);
                            $step        = 'step1';
                            $active_step = 1;
                            $button_text = $checkout_text; // original "Checkout" text
                            // Button behavior
                            if(!$must_auth && (!$guest_booking_enabled || is_user_logged_in()))
                            {
                                if ( $is_free_checkout || ($offline_enabled && $ep_skip_attendee_step)) {
                                    $step        = 'step2';
                                    $active_step = 2;
                                    $button_text = esc_html__( 'Confirm', 'eventprime-event-calendar-management' );
                                } 
                            }

                            // If offline is enabled (and it isn't a free checkout), show the button but hide it visually.
                            // Using `visibility:hidden` keeps layout space and element in DOM for JS hooks.
                            $inline_style = ( $offline_enabled && ! $is_free_checkout && $ep_skip_attendee_step && !$must_auth && (!$guest_booking_enabled || is_user_logged_in()) ) ? 'visibility:hidden;' : '';
                            ?>

                            <div class="ep-my-3">
                                <?php if ( $button_should_render ) : ?>
                                    <button
                                        type="button"
                                        class="ep-btn ep-btn-warning ep-box-w-100 ep-mb-2 <?php echo esc_attr( $step ); ?>"
                                        id="ep_event_booking_checkout_btn"
                                        data-active_step="<?php echo esc_attr( $active_step ); ?>"
                                        style="<?php echo esc_attr( $inline_style ); ?>"
                                    >
                                        <?php echo esc_html( $button_text ); ?>
                                    </button>
                                <?php endif; ?>

                                <a href="<?php echo esc_url( $args->event->event_url );?>">
                                    <button type="button" class="ep-btn ep-btn-dark ep-box-w-100">
                                        <?php esc_html_e( 'Cancel', 'eventprime-event-calendar-management' );?>
                                    </button>
                                </a>
                            </div>

                        </div>
                        <!-- Tickets info Box end -->

                        <!-- Left side box -->
                        <div class="ep-box-col-8 ep-text-small ep-col-order-1 ep-checkout-attendee-form-section">

                            <!-- Attendees Info Section -->
                            <?php if ( ! $ep_skip_attendee_step && ! empty( $args->tickets ) && count( $args->tickets ) > 0 ) { ?>
                                <div id="ep_event_booking_attendee_section">
                                    <div class="ep-mb-3">
                                        <?php esc_html_e('Please enter details of the attendees below:', 'eventprime-event-calendar-management'); ?>
                                    </div>
                                    <?php
                                    $ticket_num = 1;
                                    $num = 1;
                                    $em_event_checkout_attendee_fields = ( ! empty( $args->event->em_event_checkout_attendee_fields ) ? $args->event->em_event_checkout_attendee_fields : array() );
                                    $em_event_checkout_fixed_fields    = ( ! empty( $args->event->em_event_checkout_fixed_fields ) ? $args->event->em_event_checkout_fixed_fields : array() );
                                    if(isset($em_event_checkout_attendee_fields) && count($em_event_checkout_attendee_fields) >1 ):
                                        foreach ( $args->tickets as $tickets ) {
                                            if ( $tickets->qty && $tickets->qty > 0 ) {
                                                $num = 1;
                                                for ( $q = 0; $q < $tickets->qty; $q++ ) { ?>
                                                    <div class="ep-event-booking-attendee ep-mb-3">
                                                        <div class="ep-event-booking-attendee-head ep-box-row ep-overflow-hidden ep-border ep-rounded-top ep-mb-0">
                                                            <div class="ep-box-col-12 ep-py-3 ep-d-flex ep-justify-content-between ep-bg-white">
                                                                <span class="ep-fs-6 ep-fw-bold">
                                                                    <?php
                                                                    $ticket = $ep_functions->ep_global_settings_button_title( 'Ticket' );
                                                                    if ( empty( $ticket ) ) {
                                                                        $ticket = esc_html__( 'Ticket', 'eventprime-event-calendar-management' );
                                                                    }
                                                                    echo $ticket; echo ' ' . esc_html( $ticket_num );
                                                                    ?>
                                                                </span>
                                                                <span class="material-icons-round ep-align-bottom ep-bg-light ep-cursor ep-rounded-circle ep-ml-5 ep-event-attendee-handler">expand_more</span>
                                                            </div>
                                                        </div>
                                                        <div class="ep-event-booking-attendee-section ep-box-row ep-border ep-border-top-0 ep-rounded-bottom ep-bg-white">
                                                            <div class="ep-box-col-3 ep-text-small ep-ps-4 ep-d-flex ep-align-items-center">
                                                                <div class="ep-p-2">
                                                                    <div>
                                                                        <?php esc_html_e( 'Type:', 'eventprime-event-calendar-management' );?>&nbsp;
                                                                        <strong><?php echo esc_html( $tickets->name );?></strong>
                                                                    </div>
                                                                    <?php if ( $tickets->category_id && $tickets->category_id > 0 ) { ?>
                                                                        <div>
                                                                            <?php esc_html_e( 'Category:', 'eventprime-event-calendar-management' );?>&nbsp;
                                                                            <strong><?php echo esc_html( $ep_functions->get_ticket_category_name( $tickets->category_id, $args->event ) );?></strong>
                                                                        </div>
                                                                    <?php } ?>
                                                                    <div>
                                                                        <?php esc_html_e( 'Attendee:', 'eventprime-event-calendar-management' );?>&nbsp;
                                                                        <strong><?php echo esc_html( $num );?></strong>&nbsp;
                                                                        <?php echo '(' . esc_html__( 'of', 'eventprime-event-calendar-management' ) . ' ' . esc_html( $tickets->qty ) . ')';?>
                                                                    </div>

                                                                    <?php do_action( 'ep_event_booking_attendee_box_left_info', $tickets, $num );?>
                                                                </div>
                                                            </div>
                                                            <div class="ep-box-col-9 ep-p-3">
                                                                <?php
                                                                if ( ! empty( $em_event_checkout_attendee_fields ) ) {
                                                                    if (
                                                                        ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name'] ) &&
                                                                        ( isset( $em_event_checkout_attendee_fields['em_event_checkout_name_first_name'] ) ||
                                                                          isset( $em_event_checkout_attendee_fields['em_event_checkout_name_middle_name'] ) ||
                                                                          isset( $em_event_checkout_attendee_fields['em_event_checkout_name_last_name'] ) )
                                                                    ) {
                                                                        // checkout fields for name
                                                                        if ( ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_first_name'] ) ) { ?>
                                                                            <div class="ep-mb-3">
                                                                                <label for="name" class="form-label ep-text-small">
                                                                                    <?php esc_html_e( 'First Name', 'eventprime-event-calendar-management' );
                                                                                    if ( ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_first_name_required'] ) ) { ?>
                                                                                        <span class="ep-checkout-fields-required"><?php echo esc_html( '*' ); ?></span>
                                                                                    <?php } ?>
                                                                                </label>
                                                                                <input name="ep_booking_attendee_fields[<?php echo esc_attr( $tickets->id );?>][<?php echo esc_attr( $num );?>][name][first_name]" type="text" class="ep-form-control"
                                                                                    id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_name_first_name"
                                                                                    placeholder="<?php esc_html_e( 'First Name', 'eventprime-event-calendar-management' );?>"
                                                                                    <?php if ( ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_first_name_required'] ) ) { echo 'required="required"'; } ?>
                                                                                >
                                                                                <div class="ep-error-message" id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_name_first_name_error"></div>
                                                                            </div>
                                                                        <?php }
                                                                        if ( ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_middle_name'] ) ) { ?>
                                                                            <div class="ep-mb-3">
                                                                                <label for="name" class="form-label ep-text-small">
                                                                                    <?php esc_html_e( 'Middle Name', 'eventprime-event-calendar-management' );
                                                                                    if ( ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_middle_name_required'] ) ) { ?>
                                                                                        <span class="ep-checkout-fields-required"><?php echo esc_html( '*' ); ?></span>
                                                                                    <?php } ?>
                                                                                </label>
                                                                                <input name="ep_booking_attendee_fields[<?php echo esc_attr( $tickets->id );?>][<?php echo esc_attr( $num );?>][name][middle_name]" type="text" class="ep-form-control"
                                                                                    id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_name_middle_name"
                                                                                    placeholder="<?php esc_html_e( 'Middle Name', 'eventprime-event-calendar-management' );?>"
                                                                                    <?php if ( ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_middle_name_required'] ) ) { echo 'required="required"'; } ?>
                                                                                >
                                                                                <div class="ep-error-message" id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_name_middle_name_error"></div>
                                                                            </div>
                                                                        <?php }
                                                                        if ( ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_last_name'] ) ) { ?>
                                                                            <div class="ep-mb-3">
                                                                                <label for="name" class="form-label ep-text-small">
                                                                                    <?php esc_html_e( 'Last Name', 'eventprime-event-calendar-management' );
                                                                                    if ( ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_last_name_required'] ) ) { ?>
                                                                                        <span class="ep-checkout-fields-required"><?php echo esc_html( '*' ); ?></span>
                                                                                    <?php } ?>
                                                                                </label>
                                                                                <input name="ep_booking_attendee_fields[<?php echo esc_attr( $tickets->id );?>][<?php echo esc_attr( $num );?>][name][last_name]" type="text" class="ep-form-control"
                                                                                    id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_name_last_name"
                                                                                    placeholder="<?php esc_html_e( 'Last Name', 'eventprime-event-calendar-management' );?>"
                                                                                    <?php if ( ! empty( $em_event_checkout_attendee_fields['em_event_checkout_name_last_name_required'] ) ) { echo 'required="required"'; } ?>
                                                                                >
                                                                                <div class="ep-error-message" id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_name_last_name_error"></div>
                                                                            </div>
                                                                        <?php }
                                                                    }

                                                                    // other checkout fields
                                                                    if ( ! empty( $em_event_checkout_attendee_fields['em_event_checkout_fields_data'] ) && count( $em_event_checkout_attendee_fields['em_event_checkout_fields_data'] ) > 0 ) {
                                                                        $checkout_require_fields = array();
                                                                        $core_field_types       = array_keys( $ep_functions->ep_get_core_checkout_fields() );
                                                                        if ( isset( $em_event_checkout_attendee_fields['em_event_checkout_fields_data_required'] ) && ! empty( $em_event_checkout_attendee_fields['em_event_checkout_fields_data_required'] ) ) {
                                                                            $checkout_require_fields = $em_event_checkout_attendee_fields['em_event_checkout_fields_data_required'];
                                                                        }
                                                                        foreach ( $em_event_checkout_attendee_fields['em_event_checkout_fields_data'] as $fields ) {
                                                                            if ( in_array( $fields->type, $core_field_types ) ) {
                                                                                $input_name = $ep_functions->ep_get_slug_from_string( $fields->label ); ?>
                                                                                <div class="ep-mb-3">
                                                                                    <label for="name" class="form-label ep-text-small">
                                                                                        <?php echo esc_html( $fields->label );
                                                                                        if ( in_array( $fields->id, $checkout_require_fields ) ) { ?>
                                                                                            <span class="ep-checkout-fields-required"><?php echo esc_html( '*' ); ?></span>
                                                                                        <?php } ?>
                                                                                    </label>
                                                                                    <input name="ep_booking_attendee_fields[<?php echo esc_attr( $tickets->id );?>][<?php echo esc_attr( $num );?>][<?php echo esc_attr( $fields->id );?>][label]" type="hidden" value="<?php echo esc_attr( $fields->label );?>">
                                                                                    <input name="ep_booking_attendee_fields[<?php echo esc_attr( $tickets->id );?>][<?php echo esc_attr( $num );?>][<?php echo esc_attr( $fields->id );?>][<?php echo esc_attr( $input_name );?>]"
                                                                                        type="<?php echo esc_attr( $fields->type );?>"
                                                                                        class="ep-form-control"
                                                                                        id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_<?php echo esc_attr( $fields->id );?>_<?php echo esc_attr( $input_name );?>"
                                                                                        placeholder="<?php echo esc_attr( $fields->label );?>"
                                                                                        <?php if ( in_array( $fields->id, $checkout_require_fields ) ) { echo 'required="required"'; } ?>
                                                                                    >
                                                                                    <div class="ep-error-message" id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_<?php echo esc_attr( $fields->id );?>_<?php echo esc_attr( $input_name );?>_error"></div>
                                                                                </div>
                                                                            <?php } else {
                                                                                $checkout_field_data = array(
                                                                                    'fields'                 => $fields,
                                                                                    'tickets'                => $tickets,
                                                                                    'checkout_require_fields'=> $checkout_require_fields,
                                                                                    'num'                    => $num,
                                                                                );
                                                                                do_action( 'ep_event_advanced_checkout_fields_section', $checkout_field_data );
                                                                            }
                                                                        }
                                                                    }
                                                                } else {
                                                                    // fallback First/Last name (won't render if $ep_skip_attendee_step)
                                                                    ?>
                                                                    <div class="ep-mb-3">
                                                                        <label for="name" class="form-label ep-text-small">
                                                                            <?php esc_html_e( 'First Name', 'eventprime-event-calendar-management' );
                                                                            if ( ! empty( $ep_functions->ep_get_global_settings( 'required_booking_attendee_name' ) ) ) { ?>
                                                                                <span class="ep-checkout-fields-required"><?php echo esc_html( '*' ); ?></span>
                                                                            <?php } ?>
                                                                        </label>
                                                                        <input name="ep_booking_attendee_fields[<?php echo esc_attr( $tickets->id );?>][<?php echo esc_attr( $num );?>][name][first_name]" type="text" class="ep-form-control"
                                                                            id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_name_first_name"
                                                                            placeholder="<?php esc_html_e( 'First Name', 'eventprime-event-calendar-management' );?>"
                                                                            <?php if ( ! empty( $ep_functions->ep_get_global_settings( 'required_booking_attendee_name' ) ) ) { echo 'required="required"'; } ?>
                                                                        >
                                                                        <div class="ep-error-message" id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_name_first_name_error"></div>
                                                                    </div>
                                                                    <div class="ep-mb-3">
                                                                        <label for="name" class="form-label ep-text-small">
                                                                            <?php esc_html_e( 'Last Name', 'eventprime-event-calendar-management' );?>
                                                                        </label>
                                                                        <input name="ep_booking_attendee_fields[<?php echo esc_attr( $tickets->id );?>][<?php echo esc_attr( $num );?>][name][last_name]" type="text" class="ep-form-control"
                                                                            id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_name_last_name"
                                                                            placeholder="<?php esc_html_e( 'Last Name', 'eventprime-event-calendar-management' );?>"
                                                                        >
                                                                        <div class="ep-error-message" id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_name_last_name_error"></div>
                                                                    </div>
                                                                <?php } ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                    $num++;
                                                    $ticket_num++;
                                                }
                                            }
                                        }
                                    endif;
                                    
                                       // other checkout fields
                                    if( ! empty( $em_event_checkout_attendee_fields['em_event_checkout_fields_data'] ) && count( $em_event_checkout_attendee_fields['em_event_checkout_fields_data'] ) > 0 ) {
                                        $checkout_require_fields = array();
                                        $core_field_types = array_keys( $ep_functions->ep_get_core_checkout_fields() );
                                        if( isset( $em_event_checkout_attendee_fields['em_event_checkout_fields_data_required'] ) && ! empty( $em_event_checkout_attendee_fields['em_event_checkout_fields_data_required'] ) ) {
                                            $checkout_require_fields = $em_event_checkout_attendee_fields['em_event_checkout_fields_data_required'];
                                        }
                                        foreach( $em_event_checkout_attendee_fields['em_event_checkout_fields_data'] as $fields ) {
                                            if( in_array( $fields->type, $core_field_types ) ) {
                                                $input_name = $ep_functions->ep_get_slug_from_string( $fields->label );?>
                                                <div class="ep-mb-3">
                                                    <label for="name" class="form-label ep-text-small">
                                                        <?php echo esc_html( $fields->label );
                                                        if( in_array( $fields->id, $checkout_require_fields ) ) {?>
                                                            <span class="ep-checkout-fields-required"><?php echo esc_html( '*' ); ?></span><?php
                                                        }?>
                                                    </label>
                                                    <input name="ep_booking_attendee_fields[<?php echo esc_attr( $tickets->id );?>][<?php echo esc_attr( $num );?>][<?php echo esc_attr( $fields->id );?>][label]" type="hidden" value="<?php echo esc_attr( $fields->label );?>">
                                                    <input name="ep_booking_attendee_fields[<?php echo esc_attr( $tickets->id );?>][<?php echo esc_attr( $num );?>][<?php echo esc_attr( $fields->id );?>][<?php echo esc_attr( $input_name );?>]" 
                                                        type="<?php echo esc_attr( $fields->type );?>" 
                                                        class="ep-form-control" 
                                                        id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_<?php echo esc_attr( $fields->id );?>_<?php echo esc_attr( $input_name );?>" 
                                                        placeholder="<?php echo esc_attr( $fields->label );?>"
                                                        <?php if( in_array( $fields->id, $checkout_require_fields ) ) { echo 'required="required"'; } ?>
                                                    >
                                                    <div class="ep-error-message" id="ep_booking_attendee_fields_<?php echo esc_attr( $tickets->id );?>_<?php echo esc_attr( $num );?>_<?php echo esc_attr( $fields->id );?>_<?php echo esc_attr( $input_name );?>_error"></div>
                                                </div><?php
                                            } else{
                                                $checkout_field_data = array( 'fields' => $fields, 'tickets' => $tickets, 'checkout_require_fields' => $checkout_require_fields, 'num' => $num );
                                                do_action( 'ep_event_advanced_checkout_fields_section', $checkout_field_data );
                                            }
                                        }
                                    }
                                    
                                    // checkout fixed fields (terms)
                                    if ( ! empty( $em_event_checkout_fixed_fields ) ) {
                                        if ( ! empty( $em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_enabled'] ) ) {
                                            $term_option  = $em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_option'];
                                            $term_content = $em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_content']; ?>
                                            <div class="ep-event-booking-attendee-section ep-box-row ep-border ep-rounded ep-mb-4 ep-bg-white">
                                                <div class="ep-box-col-12 ep-p-3">
                                                    <input name="ep_booking_attendee_fixed_term_field" type="checkbox" id="ep_booking_attendee_fixed_term_field" required="required" value="">
                                                    <label for="ep_booking_attendee_fixed_term_field" class="form-label ep-text-small ep-text-break">
                                                        <?php echo esc_html( $em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_label'] );?>
                                                    </label>
                                                    <span>
                                                        <?php if ( $term_option == 'content' ) { ?>
                                                            <a href="javascript:void(0);" ep-modal-open="ep_checkout_attendee_terms_modal">
                                                                <?php esc_html_e( 'Terms & Condition', 'eventprime-event-calendar-management' );?>
                                                            </a>
                                                            <div class="ep-modal ep-modal-view" id="ep-booking-attendee-terms-modal" ep-modal="ep_checkout_attendee_terms_modal" style="display: none;">
                                                                <div class="ep-modal-overlay" ep-modal-close="ep_checkout_attendee_terms_modal"></div>
                                                                <div class="ep-modal-wrap ep-modal-xl">
                                                                    <div class="ep-modal-content">
                                                                        <div class="ep-modal-body">
                                                                            <div class="ep-modal-titlebar ep-d-flex ep-items-center">
                                                                                <h6 class="ep-modal-title"><?php esc_html_e('Terms & Condition', 'eventprime-event-calendar-management'); ?></h6>
                                                                                <a href="#" class="ep-modal-close close-popup ep-pr-0"
                                                                                    ep-modal-close="ep_checkout_attendee_terms_modal"
                                                                                    data-id="ep-checkout-attendee-terms-modal">×</a>
                                                                            </div>
                                                                            <div class="ep-box-row">
                                                                                <div class="ep-box-col-12 ep-px-4 ep-py-1">
                                                                                    <div class="ep_checkout_attendee-term-content ep-text-break">
                                                                                        <?php echo wp_kses_post( $term_content ); ?>
                                                                                        <div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php } else {
                                                            $term_page_url = ( $term_option == 'page' ) ? get_permalink( $term_content ) : $term_content ; ?>
                                                            <a href="<?php echo esc_url( $term_page_url );?>" target="_blank">
                                                                <?php esc_html_e( 'Terms & Condition', 'eventprime-event-calendar-management' );?>
                                                            </a>
                                                        <?php } ?>
                                                    </span>
                                                    <div class="ep-error-message" id="ep_booking_attendee_fixed_term_field_error"></div>
                                                </div>
                                            </div>
                                        <?php }
                                    }

                                    // booking-level fields
                                    $em_event_checkout_booking_fields = ( ! empty( $args->event->em_event_checkout_booking_fields ) ? $args->event->em_event_checkout_booking_fields : array() );
                                    if ( ! empty( $em_event_checkout_booking_fields['em_event_booking_fields_data'] ) ) {
                                        $booking_require_fields = array();
                                        $core_field_types       = array_keys( $ep_functions->ep_get_core_checkout_fields() );
                                        if ( isset( $em_event_checkout_booking_fields['em_event_booking_fields_data_required'] ) && ! empty( $em_event_checkout_booking_fields['em_event_booking_fields_data_required'] ) ) {
                                            $booking_require_fields = $em_event_checkout_booking_fields['em_event_booking_fields_data_required'];
                                        }
                                        foreach ( $em_event_checkout_booking_fields['em_event_booking_fields_data'] as $fields ) { ?>
                                            <div class="ep-event-booking-booking-section ep-box-row ep-border ep-rounded ep-mb-4">
                                                <?php if ( in_array( $fields->type, $core_field_types ) ) {
                                                    $input_name = $ep_functions->ep_get_slug_from_string( $fields->label ); ?>
                                                    <div class="ep-p-3">
                                                        <label for="name" class="form-label ep-text-small">
                                                            <?php echo esc_html( $fields->label );
                                                            if ( in_array( $fields->id, $booking_require_fields ) ) { ?>
                                                                <span class="ep-checkout-fields-required"><?php echo esc_html( '*' ); ?></span>
                                                            <?php } ?>
                                                        </label>
                                                        <input name="ep_booking_booking_fields[<?php echo esc_attr( $fields->id );?>][label]" type="hidden" value="<?php echo esc_attr( $fields->label );?>">
                                                        <input name="ep_booking_booking_fields[<?php echo esc_attr( $fields->id );?>][<?php echo esc_attr( $input_name );?>]"
                                                            type="<?php echo esc_attr( $fields->type );?>"
                                                            class="ep-form-control"
                                                            id="ep_booking_booking_fields_<?php echo esc_attr( $fields->id );?>_<?php echo esc_attr( $input_name );?>"
                                                            placeholder="<?php echo esc_attr( $fields->label );?>"
                                                            <?php if ( in_array( $fields->id, $booking_require_fields ) ) { echo 'required="required"'; } ?>
                                                        >
                                                        <div class="ep-error-message" id="ep_booking_booking_fields_<?php echo esc_attr( $fields->id );?>_<?php echo esc_attr( $input_name );?>_error"></div>
                                                    </div>
                                                <?php } else {
                                                    $checkout_field_data = array(
                                                        'fields'                  => $fields,
                                                        'tickets'                 => '',
                                                        'checkout_require_fields' => $booking_require_fields,
                                                        'num'                     => '',
                                                        'section'                 => 'booking',
                                                    );
                                                    do_action( 'ep_event_advanced_checkout_fields_section', $checkout_field_data );
                                                } ?>
                                            </div>
                                        <?php }
                                    }

                                    do_action( 'ep_front_checkout_addresses_separation_view', $args );
                                    ?>
                                </div>
                            <?php } ?>
                            <!-- Attendees info section End -->

                            <!-- Checkout Form -->
                            <div id="ep_event_booking_checkout_user_section" style="<?php echo $ep_skip_attendee_step ? '' : 'display: none;'; ?>">
                                <?php if ( ! is_user_logged_in() ) {
                                    if ( ! empty( $ep_functions->ep_enabled_guest_booking() ) ) {
                                        do_action( 'ep_checkout_guest_booking_form', $args );
                                    } else { ?>
                                        <h4 class="mb-3">
                                            <?php esc_html_e( 'Create Account', 'eventprime-event-calendar-management' );?>
                                        </h4>
                                        <div class="ep-text-dark ep-mb-3 ep-bg-success ep-bg-opacity-10 ep-p-3 ep-border-start ep-border-success ep-border-3 ep-text-small">
                                            <span class="material-icons-round ep-fs-4 ep-align-middle ep-text-success ep-mr-2">account_circle</span>
                                            <span class="ep-fw-bold">
                                                <?php esc_html_e( 'Already have an account?', 'eventprime-event-calendar-management' );?>
                                            </span>
                                            <span class="ep-text-success ep-cursor" id="ep_checkout_login_modal_id" ep-modal-open="ep_checkout_login_modal">
                                                <?php esc_html_e( 'Click here to login', 'eventprime-event-calendar-management' );?>
                                            </span>
                                        </div>
                                        <!-- Checkout registration form -->
                                        <div class="ep-box-row ep-g-3" id="ep_event_checkout_registration_form">
                                            <div class="ep-box-col-6">
                                                <label for="ep_event_checkout_rg_form_first_name" class="ep-form-label">
                                                    <?php echo esc_html( $args->account_form->fname_label );?>
                                                    <span class="text-muted">
                                                        <?php esc_html_e( '(Optional)', 'eventprime-event-calendar-management' );?>
                                                    </span>
                                                </label>
                                                <input type="text" name="ep_rg_field_first_name" class="ep-form-control" id="ep_event_checkout_rg_form_first_name" placeholder="<?php echo esc_attr( $args->account_form->fname_label );?>" value="">
                                                <div class="ep-error-message" id="ep_event_checkout_rg_form_first_name_error"></div>
                                            </div>

                                            <div class="ep-box-col-6">
                                                <label for="ep_event_checkout_rg_form_last_name" class="ep-form-label">
                                                    <?php echo esc_html( $args->account_form->lname_label );?>
                                                    <span class="text-muted">
                                                        <?php esc_html_e( '(Optional)', 'eventprime-event-calendar-management' );?>
                                                    </span>
                                                </label>
                                                <input type="text" name="ep_rg_field_last_name" class="ep-form-control" id="ep_event_checkout_rg_form_last_name" placeholder="<?php echo esc_attr( $args->account_form->lname_label );?>" value="">
                                                <div class="ep-error-message" id="ep_event_checkout_rg_form_last_name_error"></div>
                                            </div>

                                            <div class="ep-box-col-12">
                                                <label for="ep_event_checkout_rg_form_user_name" class="ep-form-label">
                                                    <?php echo esc_html( $args->account_form->username_label );?>
                                                </label>
                                                <div class="ep-input-group ep-has-validation">
                                                    <span class="ep-input-group-text">@</span>
                                                    <input type="text" name="ep_rg_field_user_name" class="ep-form-control" id="ep_event_checkout_rg_form_user_name" placeholder="<?php echo esc_attr( $args->account_form->username_label );?>" required="">
                                                    <div class="ep-error-message" id="ep_event_checkout_rg_form_user_name_error"></div>
                                                </div>
                                            </div>

                                            <div class="ep-box-col-12">
                                                <label for="ep_event_checkout_rg_form_email" class="ep-form-label">
                                                    <?php echo esc_html( $args->account_form->email_label );?></label>
                                                <input type="email" name="ep_rg_field_email" class="ep-form-control" id="ep_event_checkout_rg_form_email" placeholder="<?php echo esc_attr( $args->account_form->email_label );?>">
                                                <div class="ep-error-message" id="ep_event_checkout_rg_form_email_error"></div>
                                            </div>

                                            <div class="ep-box-col-12">
                                                <label for="ep_event_checkout_rg_form_password" class="ep-form-label">
                                                    <?php echo esc_html( $args->account_form->password_label );?>
                                                </label>
                                                <input type="password" name="ep_rg_field_password" class="ep-form-control" id="ep_event_checkout_rg_form_password" placeholder="<?php echo esc_attr( $args->account_form->password_label );?>">
                                                <div class="ep-error-message" id="ep_event_checkout_rg_form_password_error"></div>
                                            </div>

                                            <?php
                                            if ( $ep_functions->ep_get_global_settings('checkout_reg_google_recaptcha') == 1 && ! empty( $ep_functions->ep_get_global_settings('google_recaptcha_site_key') ) ) {
                                                echo '<div class="ep-box-col-12">
                                                        <div class="g-recaptcha"  data-sitekey="' . $ep_functions->ep_get_global_settings('google_recaptcha_site_key') . '"></div>
                                                        <div class="ep-error-message" id="ep_event_checkout_rg_form_captcha_error"></div>
                                                </div>';
                                            }
                                            ?>
                                        </div>
                                    <?php }
                                } else {
                                    $current_user = wp_get_current_user();
                                    if ( ! empty( $current_user->ID ) ) { ?>
                                        <div class="ep-logged-user ep-py-3 ep-border ep-rounded ep-bg-white" style="">
                                            <div class="ep-box-row">
                                                <div class="ep-box-col-12 ep-d-flex ep-align-items-center ">
                                                    <div class="ep-d-inline-flex ep-mx-3">
                                                        <img class="ep-rounded-circle" src="<?php echo esc_url( get_avatar_url( $current_user->ID ) ); ?>" style="height: 32px;">
                                                    </div>
                                                    <div class="ep-d-inline-flex ">
                                                        <span class="ep-mr-1"><?php esc_html_e( 'Logged in as', 'eventprime-event-calendar-management' ); ?></span>
                                                        <span class="ep-fw-bold"><?php echo esc_html( $ep_functions->ep_get_current_user_profile_name() ); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php }
                                } ?>

                                <?php do_action( 'ep_front_checkout_data_view', $args ); ?>
                            </div>

                            <div id="ep_event_booking_payment_section" style="<?php echo (!$ep_skip_attendee_step || $is_free_checkout) ? 'display: none;': ''; ?>">
                                <?php if ( is_user_logged_in() ) { ?>
                                    <div class="ep-my-4 ep-border-bottom"></div>
                                <?php } ?>

                                <div class="ep-my-3 ep-fs-4">
                                    <?php esc_html_e( 'Select Payment Method', 'eventprime-event-calendar-management' );?>
                                </div>
                                <div class="ep-my-3">
                                    <?php if ( empty( $ep_functions->em_is_payment_gateway_enabled() ) ) {
                                        esc_html_e( 'Payments are not enabled. Please contact website administrator for support.', 'eventprime-event-calendar-management' );
                                    } else {
                                        ?>
                                            <div class="ep-booking-payment-option-container ep-book-payment-gateways-radio-buttons ep-border-bottom ep-pb-2 ep-mb-4">
                                                <div class="ep-box-row"><?php do_action( 'ep_front_checkout_payment_processors', $args ); ?></div>
                                            </div>
                                            <div class="ep-booking-payment-option-button-container ep-d-flex ep-justify-content-end">
                                                <?php do_action( 'ep_front_checkout_payment_processors_button', $args ); ?>
                                            </div>
                                        <?php 
                                    } ?>
                                </div>
                            </div>
                            <!-- Checkout Form End -->
                        </div>
                    </div>
                </form>
            </div>

            <!-- Hook after checkout form ( paypal form ) -->
            <?php do_action( 'ep_front_checkout_form_after', $args ); ?>
        </div>
    </div>

<?php } else { ?>
    <div class="ep-alert ep-alert-warning ep-mt-3 ep-fs-6">
        <?php esc_html_e( 'No event found for booking!', 'eventprime-event-calendar-management' );?>
    </div>
<?php } ?>

<div class="ep-modal ep-modal-view" id="ep-event-booking-login-modal" ep-modal="ep_checkout_login_modal" style="display: none;">
    <div class="ep-modal-overlay" ep-modal-close="ep_checkout_login_modal"></div>
    <div class="ep-modal-wrap ep-modal-lg">
        <div class="ep-modal-content">
            <div class="ep-modal-body">
                <?php echo do_shortcode( '[em_login show_login_form=1]' );?>
            </div>
        </div>
    </div>
</div>