<?php
class ITC_SVG_Upload_Ico {

    public function upload_ico_files( $types, $file, $filename, $mimes ) {

        if ( $this->has_valid_ico_extension( $filename ) ) {

            if ( $this->is_valid_ico( $file, $filename ) ) {
                $types['ext'] = 'ico';
                $types['type'] = 'image/x-icon';
            } else {

                $types['ext'] = false;
                $types['type'] = false;
            }
        }


        return $types;
    }

    public function ico_files( $mimes ) {
        $mimes['ico'] = 'image/x-icon';
        return $mimes;
    }

    private function is_valid_ico( $file, $filename ) {
        // First check if the file extension is allowed by WordPress
        $validate = wp_check_filetype( $filename, $mimes = null );
        if ( $validate['type'] == false ) {
            return false;
        }

        $pathinfo = pathinfo( $filename );
        if ( isset( $pathinfo['extension'] ) ) {
            $extension_lower = strtolower( $pathinfo['extension'] );
            if ( $extension_lower !== 'ico' ) {
                return false; 
            }
        } else {
            return false; 
        }
        
        $handle = @fopen( $file, 'rb' );
        if ( $handle === false ) {
            return false;
        }
        $header = fread( $handle, 4 );
        fclose( $handle );
        return $header === "\x00\x00\x01\x00";
    }
    
    private function has_valid_ico_extension( $filename ) {

        $filename_lower = strtolower( $filename );
        $pathinfo = pathinfo( $filename_lower );
        

        if ( ! isset( $pathinfo['extension'] ) ) {
            return false;
        }
        
        return $pathinfo['extension'] === 'ico';
    }

    public function sanitize_upload_filename_prefilter( $file ) {
        $filename = $file['name'];
        $pathinfo = pathinfo( $filename );
        

        $is_possible_ico = false;
        if ( isset( $pathinfo['extension'] ) ) {
            $extension_lower = strtolower( $pathinfo['extension'] );
            $is_possible_ico = ( $extension_lower === 'ico' );
        }
        

        if ( $is_possible_ico && isset( $pathinfo['filename'] ) ) {

            if ( strpos( $pathinfo['filename'], '.' ) !== false ) {

                $sanitized_filename = str_replace( '.', '', $pathinfo['filename'] );
                $file['name'] = $sanitized_filename . '.' . $pathinfo['extension'];
            }
        }
        
        return $file;
    }

    public function generate_htaccess_protection() {
        $htaccess_content = "# Protect ICO files from execution - Generated by Enable SVG, WebP, and ICO Upload plugin\n";
        $htaccess_content .= "<FilesMatch \"\\.ico$\">\n";
        $htaccess_content .= "    SetHandler default-handler\n";
        $htaccess_content .= "    ForceType application/octet-stream\n";
        $htaccess_content .= "    Header set Content-Disposition attachment\n";
        $htaccess_content .= "</FilesMatch>\n";
        
        return $htaccess_content;
    }

    public static function activate_plugin() {
        $instance = new self();
        

        if ( function_exists( 'apache_get_modules' ) ) {
            $uploads_dir = wp_upload_dir();
            $htaccess_path = $uploads_dir['basedir'] . '/.htaccess';
            

            if ( file_exists( $htaccess_path ) ) {
                $current_content = file_get_contents( $htaccess_path );
                $new_rules = $instance->generate_htaccess_protection();
                
  
                if ( strpos( $current_content, 'Protect ICO files from execution' ) === false ) {
                    file_put_contents( $htaccess_path, $new_rules . "\n" . $current_content, LOCK_EX );
                }
            } else {

                file_put_contents( $htaccess_path, $instance->generate_htaccess_protection(), LOCK_EX );
            }
        }
    }
}