<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function element_ready_eicon_sets(){
	$icons = array(
		'eicon-editor-link',
		'eicon-editor-unlink',
		'eicon-editor-external-link',
		'eicon-editor-close',
		'eicon-editor-list-ol',
		'eicon-editor-list-ul',
		'eicon-editor-bold',
		'eicon-editor-italic',
		'eicon-editor-underline',
		'eicon-editor-paragraph',
		'eicon-editor-h1',
		'eicon-editor-h2',
		'eicon-editor-h3',
		'eicon-editor-h4',
		'eicon-editor-h5',
		'eicon-editor-h6',
		'eicon-editor-quote',
		'eicon-editor-code',
		'eicon-elementor',
		'eicon-elementor-circle',
		'eicon-pojome',
		'eicon-plus',
		'eicon-menu-bar',
		'eicon-apps',
		'eicon-accordion',
		'eicon-alert',
		'eicon-animation-text',
		'eicon-animation',
		'eicon-banner',
		'eicon-blockquote',
		'eicon-button',
		'eicon-call-to-action',
		'eicon-captcha',
		'eicon-carousel',
		'eicon-checkbox',
		'eicon-columns',
		'eicon-countdown',
		'eicon-counter',
		'eicon-date',
		'eicon-divider-shape',
		'eicon-divider',
		'eicon-download-button',
		'eicon-dual-button',
		'eicon-email-field',
		'eicon-facebook-comments',
		'eicon-facebook-like-box',
		'eicon-form-horizontal',
		'eicon-form-vertical',
		'eicon-gallery-grid',
		'eicon-gallery-group',
		'eicon-gallery-justified',
		'eicon-gallery-masonry',
		'eicon-icon-box',
		'eicon-image-before-after',
		'eicon-image-box',
		'eicon-image-hotspot',
		'eicon-image-rollover',
		'eicon-info-box',
		'eicon-inner-section',
		'eicon-mailchimp',
		'eicon-menu-card',
		'eicon-navigation-horizontal',
		'eicon-nav-menu',
		'eicon-navigation-vertical',
		'eicon-number-field',
		'eicon-parallax',
		'eicon-php7',
		'eicon-post-list',
		'eicon-post-slider',
		'eicon-post',
		'eicon-posts-carousel',
		'eicon-posts-grid',
		'eicon-posts-group',
		'eicon-posts-justified',
		'eicon-posts-masonry',
		'eicon-posts-ticker',
		'eicon-price-list',
		'eicon-price-table',
		'eicon-radio',
		'eicon-rtl',
		'eicon-scroll',
		'eicon-search',
		'eicon-select',
		'eicon-share',
		'eicon-sidebar',
		'eicon-skill-bar',
		'eicon-slider-3d',
		'eicon-slider-album',
		'eicon-slider-device',
		'eicon-slider-full-screen',
		'eicon-slider-push',
		'eicon-slider-vertical',
		'eicon-slider-video',
		'eicon-slides',
		'eicon-social-icons',
		'eicon-spacer',
		'eicon-table',
		'eicon-tabs',
		'eicon-tel-field',
		'eicon-text-area',
		'eicon-text-field',
		'eicon-thumbnails-down',
		'eicon-thumbnails-half',
		'eicon-thumbnails-right',
		'eicon-time-line',
		'eicon-toggle',
		'eicon-url',
		'eicon-t-letter',
		'eicon-wordpress',
		'eicon-text',
		'eicon-anchor',
		'eicon-bullet-list',
		'eicon-code',
		'eicon-favorite',
		'eicon-google-maps',
		'eicon-image',
		'eicon-photo-library',
		'eicon-woocommerce',
		'eicon-youtube',
		'eicon-flip-box',
		'eicon-settings',
		'eicon-headphones',
		'eicon-testimonial',
		'eicon-counter-circle',
		'eicon-person',
		'eicon-chevron-right',
		'eicon-chevron-left',
		'eicon-close',
		'eicon-file-download',
		'eicon-save',
		'eicon-zoom-in',
		'eicon-shortcode',
		'eicon-nerd',
		'eicon-device-desktop',
		'eicon-device-tablet',
		'eicon-device-mobile',
		'eicon-document-file',
		'eicon-folder-o',
		'eicon-hypster',
		'eicon-h-align-left',
		'eicon-h-align-right',
		'eicon-h-align-center',
		'eicon-h-align-stretch',
		'eicon-v-align-top',
		'eicon-v-align-bottom',
		'eicon-v-align-middle',
		'eicon-v-align-stretch',
		'eicon-pro-icon',
		'eicon-mail',
		'eicon-lock-user',
		'eicon-testimonial-carousel',
		'eicon-media-carousel',
		'eicon-section',
		'eicon-column',
		'eicon-edit',
		'eicon-clone',
		'eicon-trash',
		'eicon-play',
		'eicon-angle-right',
		'eicon-angle-left',
		'eicon-animated-headline',
		'eicon-menu-toggle',
		'eicon-fb-embed',
		'eicon-fb-feed',
		'eicon-twitter-embed',
		'eicon-twitter-feed',
		'eicon-sync',
		'eicon-import-export',
		'eicon-check-circle',
		'eicon-library-save',
		'eicon-library-download',
		'eicon-insert',
		'eicon-preview-medium',
		'eicon-sort-down',
		'eicon-sort-up',
		'eicon-heading',
		'eicon-logo',
		'eicon-meta-data',
		'eicon-post-content',
		'eicon-post-excerpt',
		'eicon-post-navigation',
		'eicon-yoast',
		'eicon-nerd-chuckle',
		'eicon-nerd-wink',
		'eicon-comments',
		'eicon-download-circle-o',
		'eicon-library-upload',
		'eicon-save-o',
		'eicon-upload-circle-o',
		'eicon-ellipsis-h',
		'eicon-ellipsis-v',
		'eicon-arrow-left',
		'eicon-arrow-right',
		'eicon-arrow-up',
		'eicon-arrow-down',
		'eicon-play-o',
		'eicon-archive-posts',
		'eicon-archive-title',
		'eicon-featured-image',
		'eicon-post-info',
		'eicon-post-title',
		'eicon-site-logo',
		'eicon-site-search',
		'eicon-site-title',
		'eicon-plus-square',
		'eicon-minus-square',
		'eicon-cloud-check',
		'eicon-drag-n-drop',
		'eicon-welcome',
		'eicon-handle',
		'eicon-cart',
		'eicon-product-add-to-cart',
		'eicon-product-breadcrumbs',
		'eicon-product-categories',
		'eicon-product-description',
		'eicon-product-images',
		'eicon-product-info',
		'eicon-product-meta',
		'eicon-product-pages',
		'eicon-product-price',
		'eicon-product-rating',
		'eicon-product-related',
		'eicon-product-stock',
		'eicon-product-tabs',
		'eicon-product-title',
		'eicon-product-upsell',
		'eicon-products',
		'eicon-bag-light',
		'eicon-bag-medium',
		'eicon-bag-solid',
		'eicon-basket-light',
		'eicon-basket-medium',
		'eicon-basket-solid',
		'eicon-cart-light',
		'eicon-cart-medium',
		'eicon-cart-solid',
		'eicon-exchange',
		'eicon-preview-thin',
		'eicon-device-laptop',
		'eicon-collapse',
		'eicon-expand',
		'eicon-navigator',
		'eicon-plug',
		'eicon-dashboard',
		'eicon-typography',
		'eicon-info-circle-o',
		'eicon-integration',
		'eicon-plus-circle-o',
		'eicon-rating',
		'eicon-review',
		'eicon-tools',
		'eicon-loading',
		'eicon-sitemap',
		'eicon-click',
		'eicon-clock',
		'eicon-library-open',
		'eicon-warning',
		'eicon-flow',
		'eicon-cursor-move',
		'eicon-arrow-circle-left',
		'eicon-flash',
		'eicon-redo',
		'eicon-ban',
		'eicon-barcode',
		'eicon-calendar',
		'eicon-caret-left',
		'eicon-caret-right',
		'eicon-caret-up',
		'eicon-chain-broken',
		'eicon-check-circle-o',
		'eicon-check',
		'eicon-chevron-double-left',
		'eicon-chevron-double-right',
		'eicon-undo',
		'eicon-filter',
		'eicon-circle-o',
		'eicon-circle',
		'eicon-clock-o',
		'eicon-cog',
		'eicon-cogs',
		'eicon-commenting-o',
		'eicon-copy',
		'eicon-database',
		'eicon-dot-circle-o',
		'eicon-envelope',
		'eicon-external-link-square',
		'eicon-eyedropper',
		'eicon-folder',
		'eicon-font',
		'eicon-adjust',
		'eicon-lightbox',
		'eicon-heart-o',
		'eicon-history',
		'eicon-image-bold',
		'eicon-info-circle',
		'eicon-link',
		'eicon-long-arrow-left',
		'eicon-long-arrow-right',
		'eicon-caret-down',
		'eicon-paint-brush',
		'eicon-pencil',
		'eicon-plus-circle',
		'eicon-zoom-in-bold',
		'eicon-sort-amount-desc',
		'eicon-sign-out',
		'eicon-spinner',
		'eicon-square',
		'eicon-star-o',
		'eicon-star',
		'eicon-text-align-justify',
		'eicon-text-align-center',
		'eicon-tags',
		'eicon-text-align-left',
		'eicon-text-align-right',
		'eicon-close-circle',
		'eicon-trash-o',
		'eicon-font-awesome',
		'eicon-user-circle-o',
		'eicon-video-camera',
		'eicon-heart',
		'eicon-wrench',
		'eicon-help',
		'eicon-help-o',
		'eicon-zoom-out-bold',
		'eicon-plus-square-o',
		'eicon-minus-square-o',
		'eicon-minus-circle',
		'eicon-minus-circle-o',
		'eicon-code-bold',
		'eicon-cloud-upload',
		'eicon-search-bold',
		'eicon-map-pin',
		'eicon-meetup',
		'eicon-slideshow',
		'eicon-t-letter-bold',
		'eicon-preferences',
		'eicon-table-of-contents',
		'eicon-tv',
		'eicon-upload',
		'eicon-instagram-comments',
		'eicon-instagram-nested-gallery',
		'eicon-instagram-post',
		'eicon-instagram-video',
		'eicon-instagram-gallery',
		'eicon-instagram-likes',
		'eicon-facebook',
		'eicon-twitter',
		'eicon-pinterest',
		'eicon-frame-expand',
		'eicon-frame-minimize',
		'eicon-archive',
		'eicon-colors-typography',
		'eicon-custom',
		'eicon-footer',
		'eicon-header',
		'eicon-layout-settings',
		'eicon-lightbox-expand',
		'eicon-error-404',
		'eicon-theme-style',
		'eicon-search-results',
		'eicon-single-post',
		'eicon-site-identity',
		'eicon-theme-builder',
		'eicon-download-bold',
		'eicon-share-arrow',
		'eicon-global-settings',
		'eicon-user-preferences',
		'eicon-lock',
		'eicon-export-kit',
		'eicon-import-kit',
		'eicon-lottie',
		'eicon-products-archive',
		'eicon-single-product',
		'eicon-disable-trash-o',
		'eicon-single-page',
		'eicon-wordpress-light',
		'eicon-cogs-check',
		'eicon-custom-css',
		'eicon-global-colors',
		'eicon-globe',
		'eicon-typography-1',
		'eicon-background',
		'eicon-device-responsive',
		'eicon-device-wide',
		'eicon-code-highlight',
		'eicon-video-playlist',
		'eicon-download-kit',
		'eicon-kit-details',
		'eicon-kit-parts',
		'eicon-kit-upload',
		'eicon-kit-plugins',
		'eicon-kit-upload-alt',
		'eicon-eye',
		'eicon-elementor-square',
	);
	return $icons;
}

class Element_Ready_Add_Eicon_Icons {
    
    public function __construct() { 
		add_filter( 'elementor/icons_manager/additional_tabs', [ $this, 'element_ready_elementor_eicon_setup' ] );
	}
    
    public function element_ready_enqueue_eicon(){
        wp_enqueue_style( 'eicons', ELEMENT_READY_ROOT_ICON . 'eicons/eicons.css', array(), '1.0.0' );
    }

	public function element_ready_elementor_eicon_setup( $tabs = array()){

		$new_icons = element_ready_eicon_sets();

		$tabs['eicon'] = array(
			'name'          => 'eicon',
			'label'         => esc_html__( 'Elementor Icons', 'element-ready-lite' ),
			'labelIcon'     => 'eicon-elementor',
			'prefix'        => '',
			'displayPrefix' => 'eicon',
			'url'           => esc_url(ELEMENT_READY_ROOT_ICON . 'eicons/eicons.css'),
			'icons'         => $new_icons,
			'ver'           => '1.0.0',
		);
		return $tabs;
	}

}
new Element_Ready_Add_Eicon_Icons();