(function(){"use strict";if(!window.EPKBChatUtils){console.error("ChatAPIClient: EPKBChatUtils not loaded");return}const{isInvalidNonceError:e,parseErrorResponse:s,generateIdempotencyKey:t,prepareMessage:r,createHeaders:n,createFetchOptions:o,safeParseJSON:i}=window.EPKBChatUtils;class a{constructor(e){this.config=e||{};this.baseUrl=this.config.rest_url||"/wp-json";this.restNonce=this.config.rest_nonce||"";this.isAdmin=this.config.isAdmin||false;this.debugMode=this.config.debugMode||false;this.showTechnicalLogs=this.isAdmin||this.debugMode;this.retryTimeoutRef=null;if(this.showTechnicalLogs){if(!e){console.warn("ChatAPIClient: No configuration provided, using defaults")}if(!this.restNonce){console.warn("ChatAPIClient: No REST nonce provided, authentication may fail")}}}setNonce(e){this.restNonce=e}getNonce(){return this.restNonce}async refreshNonce(e=false){if(!e&&this.restNonce){return this.restNonce}const s=await this.startSession();if(s.success&&s.data.rest_nonce){return s.data.rest_nonce}return this.restNonce}async startSession(){try{const e=await fetch(`${this.baseUrl}epkb-public/v1/ai-chat/start-session`,o("POST",{},1e4,this.restNonce));const t=await i(e);if(!e.ok){throw s(new Error("Failed to start session"),{status:e.status,data:t},this.isAdmin)}if(t.rest_nonce){this.restNonce=t.rest_nonce}return{success:true,data:t}}catch(e){const t=e.type?e:s(e,null,this.isAdmin);if(this.showTechnicalLogs){console.error("Failed to start session:",t)}if(e.name==="AbortError"||t.type==="timeout"){return{success:false,errorInfo:t,canceled:true}}return{success:false,errorInfo:t}}}async sendMessageWithRetry(e,r=null,n=null,o="1",i=null,a=0,c=false,u=false,l={}){try{const s=6e4;if(!r){r=t()}const h=await this.sendMessage(e,r,n,o,i,s,u);if(!h.success){if(h.invalidNonce&&!c&&l.onInvalidNonce){if(this.showTechnicalLogs){console.log("Invalid nonce detected, refreshing and retrying...")}await l.onInvalidNonce();return this.sendMessageWithRetry(e,r,n,o,i,a,true,u,l)}if(h.invalidNonce&&c&&h.errorInfo){if(l.onFinalError){l.onFinalError(new Error("Session expired"),h.errorInfo)}return{success:false,errorInfo:h.errorInfo}}const s=new Error(h.errorInfo?h.errorInfo.finalMessage:"Failed to get response");if(h.errorInfo){s.errorInfo=h.errorInfo;s.code=h.errorInfo.code}throw s}const f=h.data;if(f.new_token&&l.onNewToken){l.onNewToken(f)}if(f.chat_id&&l.onSessionUpdate){l.onSessionUpdate({chatId:f.chat_id,hasSession:true})}if(l.onSuccess){l.onSuccess(f)}return{success:true,data:f}}catch(t){const h=t.errorInfo||s(t,null,this.isAdmin);if(this.showTechnicalLogs){console.error("Chat error:",h)}if(this.showTechnicalLogs&&h.code){console.log(`Chat error code: ${h.code}, will retry: ${h.isRetryable}`)}const f=0;if(a<f&&h.isRetryable&&!c){const s=Math.pow(2,a)*1e3;if(l.onRetry){l.onRetry(a+1,s)}if(this.retryTimeoutRef){clearTimeout(this.retryTimeoutRef)}return new Promise((t=>{this.retryTimeoutRef=setTimeout((()=>{t(this.sendMessageWithRetry(e,r,n,o,i,a+1,false,u,l))}),s)}))}else{if(h.type==="timeout"&&!this.isAdmin&&l.onTimeoutError){l.onTimeoutError(t,h)}if(l.onFinalError){l.onFinalError(t,h)}return{success:false,errorInfo:h}}}}async sendMessage(t,r,n=null,a="1",c=null,u=3e4,l=false){const h={message:t,idempotency_key:r,widget_id:a};if(n){h.chat_id=n}if(c){h.collection_id=c}if(l){h.force_new_conversation=true}try{const t=await fetch(`${this.baseUrl}epkb-public/v1/ai-chat/send-message`,o("POST",h,u,this.restNonce));const r=await i(t);if(r.new_token){this.restNonce=r.new_token}if(!t.ok){const n=s(new Error(r.message||"Failed to get response"),{status:t.status,data:r},this.isAdmin);return{success:false,invalidNonce:e(t,r),errorInfo:n}}return{success:true,data:r}}catch(e){const t=s(e,null,this.isAdmin);return{success:false,errorInfo:t}}}async getConversation(t=null){try{const r=new URL(`${this.baseUrl}epkb-public/v1/ai-chat/conversation`);if(t){r.searchParams.append("chat_id",t)}const n=await fetch(r.toString(),o("GET",null,1e4,this.restNonce));const a=await i(n);if(a.new_token){this.restNonce=a.new_token}if(!n.ok){const t=s(new Error(a.message||"Failed to get active conversation"),{status:n.status,data:a},this.isAdmin);const r={success:false,errorInfo:t,action:"continue",userMessage:null,shouldRetry:false,needsNonceRefresh:false};if(e(n,a)||t.code==="invalid_nonce"){r.needsNonceRefresh=true;r.shouldRetry=true;r.action="refresh_nonce";return r}if(t.code==="invalid_session"||t.code==="session_expired"){r.action="create_new_session";r.userMessage=null;return r}if(t.code==="user_state_changed"||t.code==="user_mismatch"){r.action="clear_and_continue";r.userMessage=null;return r}if(t.code==="conversation_expired"||t.code==="invalid_chat_id"||t.code==="chat_not_found"||t.code==="not_found"||t.statusCode===404){r.action="expired";r.userMessage="Your previous conversation has expired. Starting a new conversation...";return r}if(t.type==="rate_limit"){const e=t.context&&t.context.retryAfter?t.context.retryAfter:60;r.action="show_error";r.userMessage=`Too many requests. Please try again in ${e} seconds.`;return r}if(t.statusCode>=500){r.action="show_error";r.userMessage="Service temporarily unavailable. Please try again later.";return r}if(t.type==="timeout"||t.type==="network"){r.action="continue";if(this.showTechnicalLogs){console.warn("Network issue when checking active conversation")}return r}return r}return{success:true,data:a,action:"success"}}catch(e){const t=s(e,null,this.isAdmin);if(t.type==="network"||t.type==="timeout"){return{success:false,errorInfo:t,action:"continue",userMessage:null}}return{success:false,errorInfo:t,action:"continue",userMessage:null}}}async clearConversation(){try{const t=await fetch(`${this.baseUrl}epkb-public/v1/ai-chat/clear`,o("POST",{},1e4,this.restNonce));const r=await i(t);if(r.new_token){this.restNonce=r.new_token}if(!t.ok){const n=s(new Error(r.message||"Failed to clear conversation"),{status:t.status,data:r},this.isAdmin);const o={success:false,errorInfo:n,action:"show_error",userMessage:"Failed to start new conversation. Please try again.",shouldRetry:false,needsNonceRefresh:false};if(e(t,r)||n.code==="invalid_nonce"){o.needsNonceRefresh=true;o.shouldRetry=true;o.action="refresh_nonce";return o}if(n.code==="invalid_session"||n.code==="session_expired"){o.action="create_new_session";o.userMessage=null;return o}if(n.statusCode>=500){o.userMessage="Service temporarily unavailable. Please try again later.";return o}return o}return{success:true,data:r,action:"success"}}catch(e){const t=s(e,null,this.isAdmin);return{success:false,errorInfo:t,action:"show_error",userMessage:"Failed to start new conversation. Please try again."}}}clearRetries(){if(this.retryTimeoutRef){clearTimeout(this.retryTimeoutRef);this.retryTimeoutRef=null}}}window.EPKBChatAPI={ChatAPIClient:a}})();