<?php

/**
 * Wordpress CTA design template
 * @since 1.4.5
 */
function wordpress_cta_get_design_templates() {

	$styles = array(
		'fitness1' => [
			'name' => 'Fitness',
			'preview_image_url' => EASY_STICKY_SIDEBAR_PLUGIN_URL . '/assets/img/fitness.jpg',
			'preview_image_path' => EASY_STICKY_SIDEBAR_PLUGIN_DIR . '/assets/img/fitness.jpg',
			'SSuprydp_button_option_text' => 'Promotion',
			'SSuprydp_button_option_backg_color' => '#e8896d',
			'SSuprydp_button_option_font' => 'Oswald:400',
			'SSuprydp_button_option_size' => '22',
			'SSuprydp_button_option_align' => 'center',
			'SSuprydp_button_option_color' => '#fff',
			'SSuprydp_content_option_text' => 'Check out our weekly deals!',
			'SSuprydp_content_option_font' => 'Oswald:500',
			'SSuprydp_content_option_weight' => '800',
			'SSuprydp_content_option_size' => '22',
			'SSuprydp_content_option_color' => '#3d5a42',
			'SSuprydp_divider_option_color' => '#1b7ccc',
			'SSuprydp_action_option_text' => 'Click Here to View',
			'SSuprydp_action_option_font' => 'Oswald:700',
			'SSuprydp_action_option_weight' => '500',
			'SSuprydp_action_option_size' => '21',
			'SSuprydp_action_option_color' => '#3d5a42',
			'SSuprydp_action_option_url' => 'https://wpctapro.com',
			'SSuprydp_target_blank' => 'No',
			'SSuprydp_nofollow' => 'No',
			'SSuprydp_cta_position' => 'right',
			'sidebar_template' => 'sticky-cta',
			'line_separator_show' => 'no',
			'line_separator_color' => '#fff',
			'cta_position_horizontal' => 'right',
			'cta_width' => '420',
			'cta_image_height' => '150',
			'button_round' => '2',
			'button2_text' => 'Decline',
			'horizontal_vertical_position' => 'center',
			'content_background_color' => '#ffffff',
			'link_text_background' => '#e0f0d0',
			'enable_cta_width' => 'yes',
			'location_type' => 'post:template',
			'hide_cta_image' => 'no',
			'letter_spacing' => '3',
			'hide_call_to_action' => 'no',
			'show_close_button' => 'yes',
			'close_button_position' => 'start',
			'close_button_color' => '#ffffff',
			'button2_show' => 'no',
			'button2_target' => 'no',
			'close_button_edge' => 'no',
			'cta_height_unit' => 'px',
			'cta_tablet_height_unit' => 'px',
			'cta_mobile_height_unit' => 'px',
			'cta_width_unit' => 'px',
			'cta_tablet_width_unit' => 'px',
			'cta_mobile_width_unit' => 'px',
			'gdpr_accept_type' => 'url',
			'gdpr_accept_target' => 'no',
			'gdpr_decline_type' => 'url',
			'gdpr_decline_target' => 'no',
			'call_to_action_button' => 'no',
			'sticky_cta_disable_collapse' => 'No',
			'keep_html_cta_open' => 'No',
			'html_cta_disable_collapse' => 'No',
			'enable_cta_height' => 'No',
		],

		'wp_cta_pro' => array(
			'name' => 'WP CTA PRO',
			'preview_image_url' => EASY_STICKY_SIDEBAR_PLUGIN_URL . '/assets/img/wp-cta-pro.png',
			'preview_image_path' => EASY_STICKY_SIDEBAR_PLUGIN_DIR . '/assets/img/wp-cta-pro.png',
			'SSuprydp_button_option_text' => '50% Off Sale',
			'SSuprydp_button_option_backg_color' => '#feee00',
			'SSuprydp_button_option_font' => 'Open+Sans:800',
			'SSuprydp_button_option_weight' => '400',
			'SSuprydp_button_option_size' => '26',
			'SSuprydp_button_option_align' => 'center',
			'SSuprydp_button_option_color' => '#000000',
			'SSuprydp_content_option_text' => 'Get WP CTA PRO for 50% Off! 
			Limited time offer.',
			'SSuprydp_content_option_font' => 'Open+Sans:800',
			'SSuprydp_content_option_weight' => '800',
			'SSuprydp_content_option_size' => '23',
			'SSuprydp_content_option_color' => '#1c80ff',
			'SSuprydp_divider_option_color' => '#1b7ccc',
			'SSuprydp_action_option_text' => 'Get It Here',
			'SSuprydp_action_option_font' => 'Open+Sans:700italic',
			'SSuprydp_action_option_weight' => '500',
			'SSuprydp_action_option_size' => '22',
			'SSuprydp_action_option_color' => '#ffffff',
			'SSuprydp_target_blank' => 'Yes',
			'SSuprydp_nofollow' => 'No',
			'SSuprydp_cta_position' => 'right',
			'SSuprydp_action_option_url' => 'https://wpctapro.com/',
			'sidebar_template' => 'sticky-cta',
			'line_separator_show' => 'yes',
			'line_separator_color' => '#fff',
			'collapse_on_page_load' => 'no',
			'cta_position_horizontal' => 'right',
			'cta_width' => '525',
			'cta_image_height' => '250',
			'button_round' => '5',
			'button2_text' => 'Decline',
			'exclude_locations' => 'Array',
			'html_cta_disable_collapse' => 'No',
			'keep_html_cta_open' => 'No',
			'sticky_cta_disable_collapse' => 'No',
			'custom_css' => '',
			'close_button_edge' => 'no',
			'close_button_position' => 'start',
			'close_button_color' => '',
			'show_close_button' => 'no',
			'floating_button_font_size' => '',
			'floating_button_icon_width' => '',
			'call_to_action_padding' => 'Array',
			'link_text_background' => '#1c80ff',
			'call_to_action_button' => 'no',
			'call_to_action_letter_spacing' => '',
			'hide_call_to_action' => 'no',
			'line_separator_thickness' => '',
			'content_background_color' => '#ffffff',
			'button2_radius' => '',
			'content_letter_spacing' => '',
			'enable_cta_width' => 'No',
			'enable_cta_height' => 'No',
			'button_decline_background_hover' => '',
			'button2_background_color' => '',
			'button_decline_text_hover' => '',
			'button2_text_color' => '',
			'button2_letter_spacing' => '',
			'button2_font_size' => '',
			'button2_font_family' => '',
			'button1_background_hover' => '',
			'letter_spacing' => '3',
			'button1_text_hover' => '',
			'hide_cta_image' => 'no',
			'cta_mobile_width_unit' => 'px',
			'content_padding' => 'Array',
			'cta_mobile_width' => '',
			'cta_tablet_width_unit' => 'px',
			'cta_width_unit' => 'px',
			'cta_tablet_width' => '',
			'cta_mobile_height_unit' => 'px',
			'cta_tablet_height' => '',
			'cta_tablet_height_unit' => 'px',
			'cta_mobile_height' => '',
			'button2_show' => 'no',
			'gdpr_decline_type' => 'url',
			'gdpr_decline_url' => '',
			'gdpr_decline_target' => 'no',
			'gdpr_cookie_days' => '',
			'tab_cta_url' => '',
			'cta_height' => '',
			'cta_height_unit' => 'px',
			'gdpr_accept_cookie_days' => '',
			'gdpr_accept_target' => 'no',
			'cta_editor_current_tab' => 'sticky-sidebar-content',
			'horizontal_vertical_position' => 'center',
			'gdpr_accept_type' => 'url',
			'gdpr_accept_url' => '',
		),

		'bakery1' => array(
		'name' => 'Bakery',
			'preview_image_url' => EASY_STICKY_SIDEBAR_PLUGIN_URL . '/assets/img/bakery.jpg',
			'preview_image_path' => EASY_STICKY_SIDEBAR_PLUGIN_URL . '/assets/img/bakery.jpg',
			'SSuprydp_button_option_text' => 'Bake Sale',
			'SSuprydp_button_option_backg_color' => '#fbc86d',
			'SSuprydp_button_option_font' => 'Montserrat:900italic',
			'SSuprydp_button_option_weight' => '900',
			'SSuprydp_button_option_size' => '24',
			'SSuprydp_button_option_align' => 'center',
			'SSuprydp_button_option_color' => '#fff',
			'SSuprydp_content_option_text' => 'Lots of treats and snacks for sale!',
			'SSuprydp_content_option_font' => 'Montserrat:900',
			'SSuprydp_content_option_weight' => '900',
			'SSuprydp_content_option_size' => '18',
			'SSuprydp_content_option_color' => '#fb816d',
			'SSuprydp_divider_option_color' => '#1b7ccc',
			'SSuprydp_action_option_text' => 'Click Here to Try',
			'SSuprydp_action_option_font' => 'Montserrat:900',
			'SSuprydp_action_option_weight' => '900',
			'SSuprydp_action_option_size' => '22',
			'SSuprydp_action_option_color' => '#fff',
			'SSuprydp_target_blank' => 'No',
			'SSuprydp_nofollow' => 'No',
			'SSuprydp_cta_position' => 'right',
			'sidebar_template' => 'sticky-cta',
			'line_separator_show' => 'yes',
			'line_separator_color' => '#ffffff',
			'cta_position_horizontal' => 'left',
			'cta_width' => '450',
			'cta_image_height' => '180',
			'button_round' => '5',
			'button2_text' => 'Decline',
			'content_background_color' => '#e7fb6d',
			'link_text_background' => '#fb816d',
			'sidebar_name' => 'Bakery',
			'line_separator_hide' => 'no',
			'location_type' => 'post:template',
			'hide_cta_image' => 'no',
			'letter_spacing' => '3',
			'enable_cta_width' => 'yes',
			'hide_call_to_action' => 'no',
			'show_close_button' => 'yes',
			'horizontal_vertical_position' => 'center',
			'close_button_color' => '#ffffff',
			'close_button_position' => 'end',
			'close_button_edge' => 'no',
			'button2_target' => 'no',
			'button2_show' => 'no',
			'cta_height_unit' => 'px',
			'cta_tablet_height_unit' => 'px',
			'cta_mobile_height_unit' => 'px',
			'cta_width_unit' => 'px',
			'cta_tablet_width_unit' => 'px',
			'cta_mobile_width_unit' => 'px',
			'gdpr_accept_type' => 'url',
			'gdpr_accept_target' => 'no',
			'gdpr_decline_type' => 'url',
			'gdpr_decline_target' => 'no',
			'line_separator_thickness' => '3',
			'call_to_action_button' => 'no',
			'sticky_cta_disable_collapse' => 'yes',
			'keep_html_cta_open' => 'No',
			'html_cta_disable_collapse' => 'No',
			'enable_cta_height' => 'No',
		),


		'healthcare1' => array(
		'name' => 'Healthcare',
			'preview_image_url' => EASY_STICKY_SIDEBAR_PLUGIN_URL . '/assets/img/healthcare.png',
			'preview_image_path' => EASY_STICKY_SIDEBAR_PLUGIN_URL . '/assets/img/healthcare.png',
			'SSuprydp_button_option_text' => 'Free Consultation',
			'SSuprydp_button_option_backg_color' => '#b1d4e0',
			'SSuprydp_button_option_font' => 'Open Sans',
			'SSuprydp_button_option_weight' => '400',
			'SSuprydp_button_option_size' => '25',
			'SSuprydp_button_option_align' => 'left',
			'SSuprydp_button_option_color' => '#fff',
			'SSuprydp_content_option_text' => 'Speak to a doctor today',
			'SSuprydp_content_option_font' => 'Open+Sans:600',
			'SSuprydp_content_option_weight' => '400',
			'SSuprydp_content_option_size' => '22',
			'SSuprydp_content_option_color' => '#fff',
			'SSuprydp_divider_option_color' => '#1b7ccc',
			'SSuprydp_action_option_text' => 'Contact Us',
			'SSuprydp_action_option_font' => 'Open+Sans:700italic',
			'SSuprydp_action_option_weight' => '500',
			'SSuprydp_action_option_size' => '22',
			'SSuprydp_action_option_color' => '#fff',
			'SSuprydp_target_blank' => 'No',
			'SSuprydp_nofollow' => 'No',
			'SSuprydp_cta_position' => 'right',
			'sidebar_template' => 'sticky-cta',
			'line_separator_show' => 'yes',
			'line_separator_color' => '#fff',
			'cta_position_horizontal' => 'right',
			'cta_width' => '440',
			'cta_image_height' => '180',
			'button_round' => '5',
			'button2_text' => 'Decline',
			'sidebar_name' => 'Doctor',
			'horizontal_vertical_position' => 'center',
			'content_background_color' => '#2e8bc0',
			'link_text_background' => '#145da0',
			'enable_cta_width' => 'yes',
			'location_type' => 'post:template',
			'exclude_location_type' => '',
			'exclude_locations' => 'Array',
			'hide_cta_image' => 'no',
			'letter_spacing' => '2',
			'hide_call_to_action' => 'no',
			'show_close_button' => 'yes',
			'custom_css' => '',
			'cta_width_unit' => 'px',
			'cta_tablet_width' => '',
			'cta_tablet_width_unit' => 'px',
			'cta_mobile_width' => '',
			'cta_mobile_width_unit' => 'px',
			'button1_text_hover' => '',
			'button1_background_hover' => '',
			'gdpr_accept_type' => 'url',
			'gdpr_accept_url' => '',
			'gdpr_accept_target' => 'no',
			'gdpr_accept_cookie_days' => '',
			'tab_cta_url' => '',
			'button2_show' => 'no',
			'button2_font_family' => '',
			'button2_font_size' => '',
			'button2_letter_spacing' => '',
			'button2_text_color' => '',
			'button_decline_text_hover' => '',
			'button2_background_color' => '',
			'button_decline_background_hover' => '',
			'button2_radius' => '',
			'gdpr_decline_type' => 'url',
			'gdpr_decline_url' => '',
			'gdpr_decline_target' => 'no',
			'gdpr_cookie_days' => '',
			'content_letter_spacing' => '',
			'line_separator_thickness' => '2',
			'call_to_action_letter_spacing' => '',
			'call_to_action_button' => 'no',
			'close_button_color' => '#1e73be',
			'close_button_position' => 'end',
			'close_button_edge' => 'yes',
			'sticky_cta_disable_collapse' => 'yes',
			'cta_height' => '',
			'cta_height_unit' => 'px',
			'cta_tablet_height' => '',
			'cta_tablet_height_unit' => 'px',
			'cta_mobile_height' => '',
			'cta_mobile_height_unit' => 'px',
			'keep_html_cta_open' => 'No',
			'html_cta_disable_collapse' => 'No',
			'enable_cta_height' => 'No',
		),

		'web-design-agency1' => array(
		'name' => 'Web Design Agency',
			'preview_image_url' => EASY_STICKY_SIDEBAR_PLUGIN_URL . '/assets/img/web-design-agency.jpg',
			'preview_image_path' => EASY_STICKY_SIDEBAR_PLUGIN_URL . '/assets/img/web-design-agency.jpg',
			'SSuprydp_button_option_text' => 'Quote',
			'SSuprydp_button_option_backg_color' => '#0eb8b3',
			'SSuprydp_button_option_font' => 'Raleway:900',
			'SSuprydp_button_option_weight' => '900',
			'SSuprydp_button_option_size' => '23',
			'SSuprydp_button_option_align' => 'center',
			'SSuprydp_button_option_color' => '#ffffff',
			'SSuprydp_content_option_text' => 'Get an instant quote. Click on the button below to get a quick quote and to speak to an expert.',
			'SSuprydp_content_option_font' => 'Raleway:600',
			'SSuprydp_content_option_weight' => '600',
			'SSuprydp_content_option_size' => '19',
			'SSuprydp_content_option_color' => '#000000',
			'SSuprydp_divider_option_color' => '#1b7ccc',
			'SSuprydp_action_option_text' => 'Get A Quote Now!',
			'SSuprydp_action_option_font' => 'Raleway:800',
			'SSuprydp_action_option_weight' => '900',
			'SSuprydp_action_option_size' => '22',
			'SSuprydp_action_option_color' => '#000000',
			'SSuprydp_target_blank' => 'No',
			'SSuprydp_nofollow' => 'No',
			'SSuprydp_cta_position' => 'right',
			'sidebar_template' => 'sticky-cta',
			'line_separator_show' => 'no',
			'line_separator_color' => '#ab8c66',
			'cta_position_horizontal' => 'left',
			'cta_width' => '450',
			'cta_image_height' => '150',
			'button2_text' => 'Decline',
			'content_background_color' => '#f0f1f3',
			'link_text_background' => '#dadbdd',
			'sidebar_name' => 'Web Design Agency',
			'line_separator_hide' => 'no',
			'location_type' => 'post:page',
			'hide_cta_image' => 'no',
			'letter_spacing' => '5',
			'enable_cta_width' => 'yes',
			'hide_call_to_action' => 'no',
			'show_close_button' => 'yes',
			'horizontal_vertical_position' => 'center',
			'exclude_location_type' => 'post:page',
			'close_button_color' => '#ffffff',
			'close_button_position' => 'start',
			'button2_show' => 'no',
			'button2_target' => 'no',
			'close_button_edge' => 'yes',
			'cta_height_unit' => 'px',
			'cta_tablet_height_unit' => 'px',
			'cta_mobile_height_unit' => 'px',
			'cta_width_unit' => 'px',
			'cta_tablet_width_unit' => 'px',
			'cta_mobile_width_unit' => 'px',
			'gdpr_accept_type' => 'url',
			'gdpr_accept_target' => 'no',
			'gdpr_decline_type' => 'url',
			'gdpr_decline_target' => 'no',
			'line_separator_thickness' => '2',
			'call_to_action_button' => 'no',
			'sticky_cta_disable_collapse' => 'No',
			'keep_html_cta_open' => 'No',
			'html_cta_disable_collapse' => 'No',
			'enable_cta_height' => 'No',
		),

'seo-agency1' => array(
		'name' => 'SEO Agency',
			'preview_image_url' => EASY_STICKY_SIDEBAR_PLUGIN_URL . '/assets/img/seo-agency1.jpg',
			'preview_image_path' => EASY_STICKY_SIDEBAR_PLUGIN_URL . '/assets/img/seo-agency1.jpg',
			'SSuprydp_button_option_text' => 'FREE SEO AUDIT',
			'SSuprydp_button_option_backg_color' => '#f5ca1c',
			'SSuprydp_button_option_font' => 'Roboto Mono',
			'SSuprydp_button_option_weight' => '800',
			'SSuprydp_button_option_size' => '21px',
			'SSuprydp_button_option_align' => 'left',
			'SSuprydp_button_option_color' => '#227eb4',
			'SSuprydp_content_option_text' => 'Find Out How Your Website Is Ranking With A Free SEO Audit',
			'SSuprydp_content_option_font' => 'Roboto Mono',
			'SSuprydp_content_option_weight' => '500',
			'SSuprydp_content_option_size' => '19px',
			'SSuprydp_content_option_color' => '#ffffff',
			'SSuprydp_divider_option_color' => '#1b7ccc',
			'SSuprydp_action_option_text' => 'Get It Now! Click Here',
			'SSuprydp_action_option_font' => 'Roboto Mono',
			'SSuprydp_action_option_weight' => '500',
			'SSuprydp_action_option_size' => '17px',
			'SSuprydp_action_option_color' => '#ffffff',
			'SSuprydp_target_blank' => 'No',
			'SSuprydp_nofollow' => 'No',
			'SSuprydp_cta_position' => 'right',
			'sidebar_template' => 'sticky-cta',
			'line_separator_show' => 'yes',
			'line_separator_color' => '#060a0b',
			'cta_position_horizontal' => 'right',
			'cta_width' => '430',
			'cta_image_height' => '180',
			'button_round' => '3',
			'button2_text' => 'Decline',
			'sidebar_name' => 'SEO Agency',
			'horizontal_vertical_position' => 'center',
			'hide_cta_image' => 'no',
			'letter_spacing' => '4',
			'button2_show' => 'no',
			'button2_url' => '',
			'button2_target' => 'no',
			'button2_font_family' => '',
			'button2_font_weight' => '',
			'button2_font_size' => '',
			'button2_letter_spacing' => '',
			'button2_text_color' => '',
			'button2_background_color' => '',
			'button2_radius' => '',
			'content_background_color' => '#1e73be',
			'link_text_background' => '#e90d7b',
			'show_close_button' => 'no',
			'close_button_color' => '',
			'close_button_position' => 'start',
			'close_button_edge' => 'no',
			'custom_css' => '',
			'exclude_locations' => 'Array',
		),

		// 'bakery1' => ['name' => 'Bakery', 'is_pro' => true],
		'lawyer1' => ['name' => 'Lawyer', 'is_pro' => true],
		'restaurant1' => ['name' => 'Restaurant', 'is_pro' => true],
		// 'healthcare1' => ['name' => 'Healthcare', 'is_pro' => true],
		// 'web-design-agency1' => ['name' => 'Web Design Agency', 'is_pro' => true],
		// 'seo-agency1' => ['name' => 'SEO Agency', 'is_pro' => true],
		'consulting1' => ['name' => 'Consulting', 'is_pro' => true],
		'roofing1' => ['name' => 'Roofing', 'is_pro' => true],
		'real-estate1' => ['name' => 'Real Estate', 'is_pro' => true]
	);

	$styles = apply_filters('wordpress_cta_free/design_templates', $styles);

	foreach ($styles as $key => &$style_template) {
		$key = sanitize_title($key);

		$style_template['image_attachment_id'] = $key;
		if (isset($style_template['preview_image_url'])) {
			$style_template['sticky_s_media'] = $style_template['preview_image_url'];
		}
	}

	return $styles;
}
