<?php
/**
 * Author Card used in Widget
 *
 * @package     EPL
 * @subpackage  Templates/WidgetContentAuthorTall
 * @copyright   Copyright (c) 2019, Merv Barrett
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<!-- Author Box Tall Container -->
<div class="epl-widget epl-author-card epl-author author-card author">
	<div class="entry-content">
		<?php do_action( 'epl_author_widget_before_image' ); ?>
		<div class="epl-author-box-tall epl-author-image author-box-tall author-image epl-clearfix">
			<?php
			if ( 'on' === $d_image ) {
					do_action( 'epl_author_thumbnail', $epl_author );
			}
			?>
		</div>
		<?php do_action( 'epl_author_widget_after_image' ); ?>

		<?php do_action( 'epl_author_widget_before_content' ); ?>
		<div class="epl-author-box-tall epl-author-details author-box-tall author-details epl-clearfix">
		<?php
			$permalink    = apply_filters( 'epl_author_profile_link', get_author_posts_url( $epl_author->author_id ), $epl_author );
			$author_title = apply_filters( 'epl_author_profile_title', get_the_author_meta( 'display_name', $epl_author->author_id ), $epl_author );
		?>

			<?php do_action( 'epl_author_widget_before_title' ); ?>
			<h5 class="epl-author-title author-title"><a href="<?php echo esc_url( $permalink ); ?>"><?php echo esc_attr( $author_title ); ?></a></h5>
			<?php do_action( 'epl_author_widget_after_title' ); ?>

			<div class="epl-author-position author-position"><?php echo esc_attr( $epl_author->get_author_position() ); ?></div>

			<?php do_action( 'epl_author_widget_before_contact' ); ?>
			<div class="epl-author-contact author-contact">
				<?php if ( ! empty( $epl_author->get_author_mobile() ) ) { ?>
					<span class="label-mobile">
						<?php
							$label_mobile = apply_filters( 'epl_author_widget_label_mobile', __( 'Mobile', 'easy-property-listings' ) );
							echo esc_attr( $label_mobile );
						?>
					</span>
					<span class="mobile"><?php echo esc_attr( $epl_author->get_author_mobile() ); ?></span>
				<?php } ?>
			</div>

			<div class="epl-author-contact author-contact author-contact-office-phone">
				<?php if ( ! empty( $epl_author->get_author_office_phone() ) ) { ?>
					<span class="label-office-phone">
						<?php
						$label_office = apply_filters( 'epl_author_widget_label_office', esc_html__( 'Office', 'easy-property-listings' ) );
							echo esc_attr( $label_office );
						?>
					</span>
					<span class="office-phone"><?php echo esc_attr( $epl_author->get_author_office_phone() ); ?></span>
				<?php } ?>
			</div>

			<?php do_action( 'epl_author_widget_after_contact' ); ?>

			<?php do_action( 'epl_author_widget_before_icons' ); ?>
			<?php if ( 'on' === $d_icons ) { ?>
				<div class="epl-author-social-buttons author-social-buttons">
					<?php
						$social_icons = apply_filters( 'epl_display_author_social_icons', array( 'email', 'facebook', 'twitter', 'instagram', 'pinterest', 'linkedin', 'skype', 'youtube' ) );
					foreach ( $social_icons as $social_icon ) {
						$html_output = call_user_func( array( $epl_author, 'get_' . $social_icon . '_html' ) );

						echo $html_output; //phpcs:ignore
					}
					?>
				</div>
			<?php } ?>
			<?php do_action( 'epl_author_widget_after_icons' ); ?>

			<?php do_action( 'epl_author_widget_before_bio' ); ?>
			<?php
			if ( 'on' === $d_bio ) {
				echo wp_kses_post( $epl_author->get_description_html() );
			}
			?>
			<?php do_action( 'epl_author_widget_after_bio' ); ?>
		</div>
		<?php do_action( 'epl_author_widget_after_content' ); ?>
	</div>
</div>
