<?php
/**
 * States
 *
 * Returns an array of country states. This deprecates and replaces the /states/ directory found in older versions.
 *
 * States should be defined in English and translated native through localisation files.
 *
 * Country codes and states (or province) names should follow the Unicode CLDR recommendation (https://cldr.unicode.org/translation/displaynames/countryregion-territory-names).
 *
 * Countries defined with empty arrays have no states. These should also be defined in class-wc-countries.php to mark the state field as not required and hidden.
 *
 * @package WooCommerce\i18n
 * @version 3.8.0
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AF' => array(),
	'AL' => array( // Albanian states.
		'AL-01' => 'Berat',
		'AL-09' => 'Dibër',
		'AL-02' => 'Durrës',
		'AL-03' => 'Elbasan',
		'AL-04' => 'Fier',
		'AL-05' => 'Gjirokastër',
		'AL-06' => 'Korçë',
		'AL-07' => 'Kukës',
		'AL-08' => 'Lezhë',
		'AL-10' => 'Shkodër',
		'AL-11' => 'Tirana',
		'AL-12' => 'Vlorë',
	),
	'AO' => array( // Angolan states.
		'BGO' => 'Bengo',
		'BLU' => 'Benguela',
		'BIE' => 'Bié',
		'CAB' => 'Cabinda',
		'CNN' => 'Cunene',
		'HUA' => 'Huambo',
		'HUI' => 'Huíla',
		'CCU' => 'Kuando Kubango',
		'CNO' => 'Kwanza-Norte',
		'CUS' => 'Kwanza-Sul',
		'LUA' => 'Luanda',
		'LNO' => 'Lunda-Norte',
		'LSU' => 'Lunda-Sul',
		'MAL' => 'Malanje',
		'MOX' => 'Moxico',
		'NAM' => 'Namibe',
		'UIG' => 'Uíge',
		'ZAI' => 'Zaire',
	),
	'AR' => array( // Argentinian provinces.
		'C' => 'Ciudad Autónoma de Buenos Aires',
		'B' => 'Buenos Aires',
		'K' => 'Catamarca',
		'H' => 'Chaco',
		'U' => 'Chubut',
		'X' => 'Córdoba',
		'W' => 'Corrientes',
		'E' => 'Entre Ríos',
		'P' => 'Formosa',
		'Y' => 'Jujuy',
		'L' => 'La Pampa',
		'F' => 'La Rioja',
		'M' => 'Mendoza',
		'N' => 'Misiones',
		'Q' => 'Neuquén',
		'R' => 'Río Negro',
		'A' => 'Salta',
		'J' => 'San Juan',
		'D' => 'San Luis',
		'Z' => 'Santa Cruz',
		'S' => 'Santa Fe',
		'G' => 'Santiago del Estero',
		'V' => 'Tierra del Fuego',
		'T' => 'Tucumán',
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => 'Australian Capital Territory',
		'NSW' => 'New South Wales',
		'NT'  => 'Northern Territory',
		'QLD' => 'Queensland',
		'SA'  => 'South Australia',
		'TAS' => 'Tasmania',
		'VIC' => 'Victoria',
		'WA'  => 'Western Australia',
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi districts.
		'BD-05' => 'Bagerhat',
		'BD-01' => 'Bandarban',
		'BD-02' => 'Barguna',
		'BD-06' => 'Barishal',
		'BD-07' => 'Bhola',
		'BD-03' => 'Bogura',
		'BD-04' => 'Brahmanbaria',
		'BD-09' => 'Chandpur',
		'BD-10' => 'Chattogram',
		'BD-12' => 'Chuadanga',
		'BD-11' => "Cox's Bazar",
		'BD-08' => 'Cumilla',
		'BD-13' => 'Dhaka',
		'BD-14' => 'Dinajpur',
		'BD-15' => 'Faridpur ',
		'BD-16' => 'Feni',
		'BD-19' => 'Gaibandha',
		'BD-18' => 'Gazipur',
		'BD-17' => 'Gopalganj',
		'BD-20' => 'Habiganj',
		'BD-21' => 'Jamalpur',
		'BD-22' => 'Jashore',
		'BD-25' => 'Jhalokati',
		'BD-23' => 'Jhenaidah',
		'BD-24' => 'Joypurhat',
		'BD-29' => 'Khagrachhari',
		'BD-27' => 'Khulna',
		'BD-26' => 'Kishoreganj',
		'BD-28' => 'Kurigram',
		'BD-30' => 'Kushtia',
		'BD-31' => 'Lakshmipur',
		'BD-32' => 'Lalmonirhat',
		'BD-36' => 'Madaripur',
		'BD-37' => 'Magura',
		'BD-33' => 'Manikganj ',
		'BD-39' => 'Meherpur',
		'BD-38' => 'Moulvibazar',
		'BD-35' => 'Munshiganj',
		'BD-34' => 'Mymensingh',
		'BD-48' => 'Naogaon',
		'BD-43' => 'Narail',
		'BD-40' => 'Narayanganj',
		'BD-42' => 'Narsingdi',
		'BD-44' => 'Natore',
		'BD-45' => 'Nawabganj',
		'BD-41' => 'Netrakona',
		'BD-46' => 'Nilphamari',
		'BD-47' => 'Noakhali',
		'BD-49' => 'Pabna',
		'BD-52' => 'Panchagarh',
		'BD-51' => 'Patuakhali',
		'BD-50' => 'Pirojpur',
		'BD-53' => 'Rajbari',
		'BD-54' => 'Rajshahi',
		'BD-56' => 'Rangamati',
		'BD-55' => 'Rangpur',
		'BD-58' => 'Satkhira',
		'BD-62' => 'Shariatpur',
		'BD-57' => 'Sherpur',
		'BD-59' => 'Sirajganj',
		'BD-61' => 'Sunamganj',
		'BD-60' => 'Sylhet',
		'BD-63' => 'Tangail',
		'BD-64' => 'Thakurgaon',
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => 'Blagoevgrad',
		'BG-02' => 'Burgas',
		'BG-08' => 'Dobrich',
		'BG-07' => 'Gabrovo',
		'BG-26' => 'Haskovo',
		'BG-09' => 'Kardzhali',
		'BG-10' => 'Kyustendil',
		'BG-11' => 'Lovech',
		'BG-12' => 'Montana',
		'BG-13' => 'Pazardzhik',
		'BG-14' => 'Pernik',
		'BG-15' => 'Pleven',
		'BG-16' => 'Plovdiv',
		'BG-17' => 'Razgrad',
		'BG-18' => 'Ruse',
		'BG-27' => 'Shumen',
		'BG-19' => 'Silistra',
		'BG-20' => 'Sliven',
		'BG-21' => 'Smolyan',
		'BG-23' => 'Sofia District',
		'BG-22' => 'Sofia',
		'BG-24' => 'Stara Zagora',
		'BG-25' => 'Targovishte',
		'BG-03' => 'Varna',
		'BG-04' => 'Veliko Tarnovo',
		'BG-05' => 'Vidin',
		'BG-06' => 'Vratsa',
		'BG-28' => 'Yambol',
	),
	'BH' => array(),
	'BI' => array(),
	'BJ' => array( // Beninese states.
		'AL' => 'Alibori',
		'AK' => 'Atakora',
		'AQ' => 'Atlantique',
		'BO' => 'Borgou',
		'CO' => 'Collines',
		'KO' => 'Kouffo',
		'DO' => 'Donga',
		'LI' => 'Littoral',
		'MO' => 'Mono',
		'OU' => 'Ouémé',
		'PL' => 'Plateau',
		'ZO' => 'Zou',
	),
	'BO' => array( // Bolivian states.
		'BO-B' => 'Beni',
		'BO-H' => 'Chuquisaca',
		'BO-C' => 'Cochabamba',
		'BO-L' => 'La Paz',
		'BO-O' => 'Oruro',
		'BO-N' => 'Pando',
		'BO-P' => 'Potosí',
		'BO-S' => 'Santa Cruz',
		'BO-T' => 'Tarija',
	),
	'BR' => array( // Brazilian states.
		'AC' => 'Acre',
		'AL' => 'Alagoas',
		'AP' => 'Amapá',
		'AM' => 'Amazonas',
		'BA' => 'Bahia',
		'CE' => 'Ceará',
		'DF' => 'Distrito Federal',
		'ES' => 'Espírito Santo',
		'GO' => 'Goiás',
		'MA' => 'Maranhão',
		'MT' => 'Mato Grosso',
		'MS' => 'Mato Grosso do Sul',
		'MG' => 'Minas Gerais',
		'PA' => 'Pará',
		'PB' => 'Paraíba',
		'PR' => 'Paraná',
		'PE' => 'Pernambuco',
		'PI' => 'Piauí',
		'RJ' => 'Rio de Janeiro',
		'RN' => 'Rio Grande do Norte',
		'RS' => 'Rio Grande do Sul',
		'RO' => 'Rondônia',
		'RR' => 'Roraima',
		'SC' => 'Santa Catarina',
		'SP' => 'São Paulo',
		'SE' => 'Sergipe',
		'TO' => 'Tocantins',
	),
	'CA' => array( // Canadian states.
		'AB' => 'Alberta',
		'BC' => 'British Columbia',
		'MB' => 'Manitoba',
		'NB' => 'New Brunswick',
		'NL' => 'Newfoundland and Labrador',
		'NT' => 'Northwest Territories',
		'NS' => 'Nova Scotia',
		'NU' => 'Nunavut',
		'ON' => 'Ontario',
		'PE' => 'Prince Edward Island',
		'QC' => 'Quebec',
		'SK' => 'Saskatchewan',
		'YT' => 'Yukon Territory',
	),
	'CH' => array( // Swiss cantons.
		'AG' => 'Aargau',
		'AR' => 'Appenzell Ausserrhoden',
		'AI' => 'Appenzell Innerrhoden',
		'BL' => 'Basel-Landschaft',
		'BS' => 'Basel-Stadt',
		'BE' => 'Bern',
		'FR' => 'Fribourg',
		'GE' => 'Geneva',
		'GL' => 'Glarus',
		'GR' => 'Graubünden',
		'JU' => 'Jura',
		'LU' => 'Luzern',
		'NE' => 'Neuchâtel',
		'NW' => 'Nidwalden',
		'OW' => 'Obwalden',
		'SH' => 'Schaffhausen',
		'SZ' => 'Schwyz',
		'SO' => 'Solothurn',
		'SG' => 'St. Gallen',
		'TG' => 'Thurgau',
		'TI' => 'Ticino',
		'UR' => 'Uri',
		'VS' => 'Valais',
		'VD' => 'Vaud',
		'ZG' => 'Zug',
		'ZH' => 'Zürich',
	),
	'CL' => array( // Chilean states.
		'CL-AI' => 'Aisén del General Carlos Ibañez del Campo',
		'CL-AN' => 'Antofagasta',
		'CL-AP' => 'Arica y Parinacota',
		'CL-AR' => 'La Araucanía',
		'CL-AT' => 'Atacama',
		'CL-BI' => 'Biobío',
		'CL-CO' => 'Coquimbo',
		'CL-LI' => 'Libertador General Bernardo O\'Higgins',
		'CL-LL' => 'Los Lagos',
		'CL-LR' => 'Los Ríos',
		'CL-MA' => 'Magallanes',
		'CL-ML' => 'Maule',
		'CL-NB' => 'Ñuble',
		'CL-RM' => 'Región Metropolitana de Santiago',
		'CL-TA' => 'Tarapacá',
		'CL-VS' => 'Valparaíso',
	),
	'CN' => array( // Chinese states.
		'CN1'  => 'Yunnan / 云南',
		'CN2'  => 'Beijing / 北京',
		'CN3'  => 'Tianjin / 天津',
		'CN4'  => 'Hebei / 河北',
		'CN5'  => 'Shanxi / 山西',
		'CN6'  => 'Inner Mongolia / 內蒙古',
		'CN7'  => 'Liaoning / 辽宁',
		'CN8'  => 'Jilin / 吉林',
		'CN9'  => 'Heilongjiang / 黑龙江',
		'CN10' => 'Shanghai / 上海',
		'CN11' => 'Jiangsu / 江苏',
		'CN12' => 'Zhejiang / 浙江',
		'CN13' => 'Anhui / 安徽',
		'CN14' => 'Fujian / 福建',
		'CN15' => 'Jiangxi / 江西',
		'CN16' => 'Shandong / 山东',
		'CN17' => 'Henan / 河南',
		'CN18' => 'Hubei / 湖北',
		'CN19' => 'Hunan / 湖南',
		'CN20' => 'Guangdong / 广东',
		'CN21' => 'Guangxi Zhuang / 广西壮族',
		'CN22' => 'Hainan / 海南',
		'CN23' => 'Chongqing / 重庆',
		'CN24' => 'Sichuan / 四川',
		'CN25' => 'Guizhou / 贵州',
		'CN26' => 'Shaanxi / 陕西',
		'CN27' => 'Gansu / 甘肃',
		'CN28' => 'Qinghai / 青海',
		'CN29' => 'Ningxia Hui / 宁夏',
		'CN30' => 'Macao / 澳门',
		'CN31' => 'Tibet / 西藏',
		'CN32' => 'Xinjiang / 新疆',
	),
	'CO' => array( // Colombian states.
		'CO-AMA' => 'Amazonas',
		'CO-ANT' => 'Antioquia',
		'CO-ARA' => 'Arauca',
		'CO-ATL' => 'Atlántico',
		'CO-BOL' => 'Bolívar',
		'CO-BOY' => 'Boyacá',
		'CO-CAL' => 'Caldas',
		'CO-CAQ' => 'Caquetá',
		'CO-CAS' => 'Casanare',
		'CO-CAU' => 'Cauca',
		'CO-CES' => 'Cesar',
		'CO-CHO' => 'Chocó',
		'CO-COR' => 'Córdoba',
		'CO-CUN' => 'Cundinamarca',
		'CO-DC' => 'Capital District',
		'CO-GUA' => 'Guainía',
		'CO-GUV' => 'Guaviare',
		'CO-HUI' => 'Huila',
		'CO-LAG' => 'La Guajira',
		'CO-MAG' => 'Magdalena',
		'CO-MET' => 'Meta',
		'CO-NAR' => 'Nariño',
		'CO-NSA' => 'Norte de Santander',
		'CO-PUT' => 'Putumayo',
		'CO-QUI' => 'Quindío',
		'CO-RIS' => 'Risaralda',
		'CO-SAN' => 'Santander',
		'CO-SAP' => 'San Andrés & Providencia',
		'CO-SUC' => 'Sucre',
		'CO-TOL' => 'Tolima',
		'CO-VAC' => 'Valle del Cauca',
		'CO-VAU' => 'Vaupés',
		'CO-VID' => 'Vichada',
	),
	'CR' => array( // Costa Rican states.
		'CR-A' => 'Alajuela',
		'CR-C' => 'Cartago',
		'CR-G' => 'Guanacaste',
		'CR-H' => 'Heredia',
		'CR-L' => 'Limón',
		'CR-P' => 'Puntarenas',
		'CR-SJ' => 'San José',
	),
	'CZ' => array(),
	'DE' => array( // German states.
		'DE-BW' => 'Baden-Württemberg',
		'DE-BY' => 'Bavaria',
		'DE-BE' => 'Berlin',
		'DE-BB' => 'Brandenburg',
		'DE-HB' => 'Bremen',
		'DE-HH' => 'Hamburg',
		'DE-HE' => 'Hesse',
		'DE-MV' => 'Mecklenburg-Vorpommern',
		'DE-NI' => 'Lower Saxony',
		'DE-NW' => 'North Rhine-Westphalia',
		'DE-RP' => 'Rhineland-Palatinate',
		'DE-SL' => 'Saarland',
		'DE-SN' => 'Saxony',
		'DE-ST' => 'Saxony-Anhalt',
		'DE-SH' => 'Schleswig-Holstein',
		'DE-TH' => 'Thuringia',
	),
	'DK' => array(),
	'DO' => array( // Dominican states.
		'DO-01' => 'Distrito Nacional',
		'DO-02' => 'Azua',
		'DO-03' => 'Baoruco',
		'DO-04' => 'Barahona',
		'DO-33' => 'Cibao Nordeste',
		'DO-34' => 'Cibao Noroeste',
		'DO-35' => 'Cibao Norte',
		'DO-36' => 'Cibao Sur',
		'DO-05' => 'Dajabón',
		'DO-06' => 'Duarte',
		'DO-08' => 'El Seibo',
		'DO-37' => 'El Valle',
		'DO-07' => 'Elías Piña',
		'DO-38' => 'Enriquillo',
		'DO-09' => 'Espaillat',
		'DO-30' => 'Hato Mayor',
		'DO-19' => 'Hermanas Mirabal',
		'DO-39' => 'Higüamo',
		'DO-10' => 'Independencia',
		'DO-11' => 'La Altagracia',
		'DO-12' => 'La Romana',
		'DO-13' => 'La Vega',
		'DO-14' => 'María Trinidad Sánchez',
		'DO-28' => 'Monseñor Nouel',
		'DO-15' => 'Monte Cristi',
		'DO-29' => 'Monte Plata',
		'DO-40' => 'Ozama',
		'DO-16' => 'Pedernales',
		'DO-17' => 'Peravia',
		'DO-18' => 'Puerto Plata',
		'DO-20' => 'Samaná',
		'DO-21' => 'San Cristóbal',
		'DO-31' => 'San José de Ocoa',
		'DO-22' => 'San Juan',
		'DO-23' => 'San Pedro de Macorís',
		'DO-24' => 'Sánchez Ramírez',
		'DO-25' => 'Santiago',
		'DO-26' => 'Santiago Rodríguez',
		'DO-32' => 'Santo Domingo',
		'DO-41' => 'Valdesia',
		'DO-27' => 'Valverde',
		'DO-42' => 'Yuma',
	),
	'DZ' => array( // Algerian states.
		'DZ-01' => 'Adrar',
		'DZ-02' => 'Chlef',
		'DZ-03' => 'Laghouat',
		'DZ-04' => 'Oum El Bouaghi',
		'DZ-05' => 'Batna',
		'DZ-06' => 'Béjaïa',
		'DZ-07' => 'Biskra',
		'DZ-08' => 'Béchar',
		'DZ-09' => 'Blida',
		'DZ-10' => 'Bouira',
		'DZ-11' => 'Tamanghasset',
		'DZ-12' => 'Tébessa',
		'DZ-13' => 'Tlemcen',
		'DZ-14' => 'Tiaret',
		'DZ-15' => 'Tizi Ouzou',
		'DZ-16' => 'Algiers',
		'DZ-17' => 'Djelfa',
		'DZ-18' => 'Jijel',
		'DZ-19' => 'Sétif',
		'DZ-20' => 'Saïda',
		'DZ-21' => 'Skikda',
		'DZ-22' => 'Sidi Bel Abbès',
		'DZ-23' => 'Annaba',
		'DZ-24' => 'Guelma',
		'DZ-25' => 'Constantine',
		'DZ-26' => 'Médéa',
		'DZ-27' => 'Mostaganem',
		'DZ-28' => 'M’Sila',
		'DZ-29' => 'Mascara',
		'DZ-30' => 'Ouargla',
		'DZ-31' => 'Oran',
		'DZ-32' => 'El Bayadh',
		'DZ-33' => 'Illizi',
		'DZ-34' => 'Bordj Bou Arréridj',
		'DZ-35' => 'Boumerdès',
		'DZ-36' => 'El Tarf',
		'DZ-37' => 'Tindouf',
		'DZ-38' => 'Tissemsilt',
		'DZ-39' => 'El Oued',
		'DZ-40' => 'Khenchela',
		'DZ-41' => 'Souk Ahras',
		'DZ-42' => 'Tipasa',
		'DZ-43' => 'Mila',
		'DZ-44' => 'Aïn Defla',
		'DZ-45' => 'Naama',
		'DZ-46' => 'Aïn Témouchent',
		'DZ-47' => 'Ghardaïa',
		'DZ-48' => 'Relizane',
	),
	'EE' => array(),
	'EC' => array( // Ecuadorian states.
		'EC-A' => 'Azuay',
		'EC-B' => 'Bolívar',
		'EC-F' => 'Cañar',
		'EC-C' => 'Carchi',
		'EC-H' => 'Chimborazo',
		'EC-X' => 'Cotopaxi',
		'EC-O' => 'El Oro',
		'EC-E' => 'Esmeraldas',
		'EC-W' => 'Galápagos',
		'EC-G' => 'Guayas',
		'EC-I' => 'Imbabura',
		'EC-L' => 'Loja',
		'EC-R' => 'Los Ríos',
		'EC-M' => 'Manabí',
		'EC-S' => 'Morona-Santiago',
		'EC-N' => 'Napo',
		'EC-D' => 'Orellana',
		'EC-Y' => 'Pastaza',
		'EC-P' => 'Pichincha',
		'EC-SE' => 'Santa Elena',
		'EC-SD' => 'Santo Domingo de los Tsáchilas',
		'EC-U' => 'Sucumbíos',
		'EC-T' => 'Tungurahua',
		'EC-Z' => 'Zamora-Chinchipe',
	),
	'EG' => array( // Egyptian states.
		'EGALX' => 'Alexandria',
		'EGASN' => 'Aswan',
		'EGAST' => 'Asyut',
		'EGBA'  => 'Red Sea',
		'EGBH'  => 'Beheira',
		'EGBNS' => 'Beni Suef',
		'EGC'   => 'Cairo',
		'EGDK'  => 'Dakahlia',
		'EGDT'  => 'Damietta',
		'EGFYM' => 'Faiyum',
		'EGGH'  => 'Gharbia',
		'EGGZ'  => 'Giza',
		'EGIS'  => 'Ismailia',
		'EGJS'  => 'South Sinai',
		'EGKB'  => 'Qalyubia',
		'EGKFS' => 'Kafr el-Sheikh',
		'EGKN'  => 'Qena',
		'EGLX'  => 'Luxor',
		'EGMN'  => 'Minya',
		'EGMNF' => 'Monufia',
		'EGMT'  => 'Matrouh',
		'EGPTS' => 'Port Said',
		'EGSHG' => 'Sohag',
		'EGSHR' => 'Al Sharqia',
		'EGSIN' => 'North Sinai',
		'EGSUZ' => 'Suez',
		'EGWAD' => 'New Valley',
	),
	'ES' => array( // Spanish states.
		'C'  => 'A Coruña',
		'VI' => 'Araba/Álava',
		'AB' => 'Albacete',
		'A'  => 'Alicante',
		'AL' => 'Almería',
		'O'  => 'Asturias',
		'AV' => 'Ávila',
		'BA' => 'Badajoz',
		'PM' => 'Baleares',
		'B'  => 'Barcelona',
		'BU' => 'Burgos',
		'CC' => 'Cáceres',
		'CA' => 'Cádiz',
		'S'  => 'Cantabria',
		'CS' => 'Castellón',
		'CE' => 'Ceuta',
		'CR' => 'Ciudad Real',
		'CO' => 'Córdoba',
		'CU' => 'Cuenca',
		'GI' => 'Girona',
		'GR' => 'Granada',
		'GU' => 'Guadalajara',
		'SS' => 'Gipuzkoa',
		'H'  => 'Huelva',
		'HU' => 'Huesca',
		'J'  => 'Jaén',
		'LO' => 'La Rioja',
		'GC' => 'Las Palmas',
		'LE' => 'León',
		'L'  => 'Lleida',
		'LU' => 'Lugo',
		'M'  => 'Madrid',
		'MA' => 'Málaga',
		'ML' => 'Melilla',
		'MU' => 'Murcia',
		'NA' => 'Navarra',
		'OR' => 'Ourense',
		'P'  => 'Palencia',
		'PO' => 'Pontevedra',
		'SA' => 'Salamanca',
		'TF' => 'Santa Cruz de Tenerife',
		'SG' => 'Segovia',
		'SE' => 'Sevilla',
		'SO' => 'Soria',
		'T'  => 'Tarragona',
		'TE' => 'Teruel',
		'TO' => 'Toledo',
		'V'  => 'Valencia',
		'VA' => 'Valladolid',
		'BI' => 'Biscay',
		'ZA' => 'Zamora',
		'Z'  => 'Zaragoza',
	),
	'ET' => array(),
	'FI' => array(),
	'FR' => array(),
	'GF' => array(),
	'GH' => array( // Ghanaian regions.
		'AF' => 'Ahafo',
		'AH' => 'Ashanti',
		'BA' => 'Brong-Ahafo',
		'BO' => 'Bono',
		'BE' => 'Bono East',
		'CP' => 'Central',
		'EP' => 'Eastern',
		'AA' => 'Greater Accra',
		'NE' => 'North East',
		'NP' => 'Northern',
		'OT' => 'Oti',
		'SV' => 'Savannah',
		'UE' => 'Upper East',
		'UW' => 'Upper West',
		'TV' => 'Volta',
		'WP' => 'Western',
		'WN' => 'Western North',
	),
	'GP' => array(),
	'GR' => array( // Greek regions.
		'I' => 'Attica',
		'A' => 'East Macedonia and Thrace',
		'B' => 'Central Macedonia',
		'C' => 'West Macedonia',
		'D' => 'Epirus',
		'E' => 'Thessaly',
		'F' => 'Ionian Islands',
		'G' => 'West Greece',
		'H' => 'Central Greece',
		'J' => 'Peloponnese',
		'K' => 'North Aegean',
		'L' => 'South Aegean',
		'M' => 'Crete',
	),
	'GT' => array( // Guatemalan states.
		'GT-AV' => 'Alta Verapaz',
		'GT-BV' => 'Baja Verapaz',
		'GT-CM' => 'Chimaltenango',
		'GT-CQ' => 'Chiquimula',
		'GT-PR' => 'El Progreso',
		'GT-ES' => 'Escuintla',
		'GT-GU' => 'Guatemala',
		'GT-HU' => 'Huehuetenango',
		'GT-IZ' => 'Izabal',
		'GT-JA' => 'Jalapa',
		'GT-JU' => 'Jutiapa',
		'GT-PE' => 'Petén',
		'GT-QZ' => 'Quetzaltenango',
		'GT-QC' => 'Quiché',
		'GT-RE' => 'Retalhuleu',
		'GT-SA' => 'Sacatepéquez',
		'GT-SM' => 'San Marcos',
		'GT-SR' => 'Santa Rosa',
		'GT-SO' => 'Sololá',
		'GT-SU' => 'Suchitepéquez',
		'GT-TO' => 'Totonicapán',
		'GT-ZA' => 'Zacapa',
	),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => 'Hong Kong Island',
		'KOWLOON'         => 'Kowloon',
		'NEW TERRITORIES' => 'New Territories',
	),
	'HN' => array( // Honduran states.
		'HN-AT' => 'Atlántida',
		'HN-IB' => 'Bay Islands',
		'HN-CH' => 'Choluteca',
		'HN-CL' => 'Colón',
		'HN-CM' => 'Comayagua',
		'HN-CP' => 'Copán',
		'HN-CR' => 'Cortés',
		'HN-EP' => 'El Paraíso',
		'HN-FM' => 'Francisco Morazán',
		'HN-GD' => 'Gracias a Dios',
		'HN-IN' => 'Intibucá',
		'HN-LE' => 'Lempira',
		'HN-LP' => 'La Paz',
		'HN-OC' => 'Ocotepeque',
		'HN-OL' => 'Olancho',
		'HN-SB' => 'Santa Bárbara',
		'HN-VA' => 'Valle',
		'HN-YO' => 'Yoro',
	),
	'HR' => array( // Croatian counties.
		'HR-01' => 'Zagreb County',
		'HR-02' => 'Krapina-Zagorje County',
		'HR-03' => 'Sisak-Moslavina County',
		'HR-04' => 'Karlovac County',
		'HR-05' => 'Varaždin County',
		'HR-06' => 'Koprivnica-Križevci County',
		'HR-07' => 'Bjelovar-Bilogora County',
		'HR-08' => 'Primorje-Gorski Kotar County',
		'HR-09' => 'Lika-Senj County',
		'HR-10' => 'Virovitica-Podravina County',
		'HR-11' => 'Požega-Slavonia County',
		'HR-12' => 'Brod-Posavina County',
		'HR-13' => 'Zadar County',
		'HR-14' => 'Osijek-Baranja County',
		'HR-15' => 'Šibenik-Knin County',
		'HR-16' => 'Vukovar-Srijem County',
		'HR-17' => 'Split-Dalmatia County',
		'HR-18' => 'Istria County',
		'HR-19' => 'Dubrovnik-Neretva County',
		'HR-20' => 'Međimurje County',
		'HR-21' => 'Zagreb City',
	),
	'HU' => array( // Hungarian states.
		'BK' => 'Bács-Kiskun',
		'BE' => 'Békés',
		'BA' => 'Baranya',
		'BZ' => 'Borsod-Abaúj-Zemplén',
		'BU' => 'Budapest',
		'CS' => 'Csongrád-Csanád',
		'FE' => 'Fejér',
		'GS' => 'Győr-Moson-Sopron',
		'HB' => 'Hajdú-Bihar',
		'HE' => 'Heves',
		'JN' => 'Jász-Nagykun-Szolnok',
		'KE' => 'Komárom-Esztergom',
		'NO' => 'Nógrád',
		'PE' => 'Pest',
		'SO' => 'Somogy',
		'SZ' => 'Szabolcs-Szatmár-Bereg',
		'TO' => 'Tolna',
		'VA' => 'Vas',
		'VE' => 'Veszprém',
		'ZA' => 'Zala',
	),
	'ID' => array( // Indonesian provinces.
		'AC' => 'Daerah Istimewa Aceh',
		'SU' => 'Sumatera Utara',
		'SB' => 'Sumatera Barat',
		'RI' => 'Riau',
		'KR' => 'Kepulauan Riau',
		'JA' => 'Jambi',
		'SS' => 'Sumatera Selatan',
		'BB' => 'Bangka Belitung',
		'BE' => 'Bengkulu',
		'LA' => 'Lampung',
		'JK' => 'DKI Jakarta',
		'JB' => 'Jawa Barat',
		'BT' => 'Banten',
		'JT' => 'Jawa Tengah',
		'JI' => 'Jawa Timur',
		'YO' => 'Daerah Istimewa Yogyakarta',
		'BA' => 'Bali',
		'NB' => 'Nusa Tenggara Barat',
		'NT' => 'Nusa Tenggara Timur',
		'KB' => 'Kalimantan Barat',
		'KT' => 'Kalimantan Tengah',
		'KI' => 'Kalimantan Timur',
		'KS' => 'Kalimantan Selatan',
		'KU' => 'Kalimantan Utara',
		'SA' => 'Sulawesi Utara',
		'ST' => 'Sulawesi Tengah',
		'SG' => 'Sulawesi Tenggara',
		'SR' => 'Sulawesi Barat',
		'SN' => 'Sulawesi Selatan',
		'GO' => 'Gorontalo',
		'MA' => 'Maluku',
		'MU' => 'Maluku Utara',
		'PA' => 'Papua',
		'PB' => 'Papua Barat',
	),
	'IE' => array( // Irish states.
		'CW' => 'Carlow',
		'CN' => 'Cavan',
		'CE' => 'Clare',
		'CO' => 'Cork',
		'DL' => 'Donegal',
		'D'  => 'Dublin',
		'G'  => 'Galway',
		'KY' => 'Kerry',
		'KE' => 'Kildare',
		'KK' => 'Kilkenny',
		'LS' => 'Laois',
		'LM' => 'Leitrim',
		'LK' => 'Limerick',
		'LD' => 'Longford',
		'LH' => 'Louth',
		'MO' => 'Mayo',
		'MH' => 'Meath',
		'MN' => 'Monaghan',
		'OY' => 'Offaly',
		'RN' => 'Roscommon',
		'SO' => 'Sligo',
		'TA' => 'Tipperary',
		'WD' => 'Waterford',
		'WH' => 'Westmeath',
		'WX' => 'Wexford',
		'WW' => 'Wicklow',
	),
	'IN' => array( // Indian states.
		'AP' => 'Andhra Pradesh',
		'AR' => 'Arunachal Pradesh',
		'AS' => 'Assam',
		'BR' => 'Bihar',
		'CT' => 'Chhattisgarh',
		'GA' => 'Goa',
		'GJ' => 'Gujarat',
		'HR' => 'Haryana',
		'HP' => 'Himachal Pradesh',
		'JK' => 'Jammu and Kashmir',
		'JH' => 'Jharkhand',
		'KA' => 'Karnataka',
		'KL' => 'Kerala',
		'LA' => 'Ladakh',
		'MP' => 'Madhya Pradesh',
		'MH' => 'Maharashtra',
		'MN' => 'Manipur',
		'ML' => 'Meghalaya',
		'MZ' => 'Mizoram',
		'NL' => 'Nagaland',
		'OD' => 'Odisha',
		'PB' => 'Punjab',
		'RJ' => 'Rajasthan',
		'SK' => 'Sikkim',
		'TN' => 'Tamil Nadu',
		'TS' => 'Telangana',
		'TR' => 'Tripura',
		'UK' => 'Uttarakhand',
		'UP' => 'Uttar Pradesh',
		'WB' => 'West Bengal',
		'AN' => 'Andaman and Nicobar Islands',
		'CH' => 'Chandigarh',
		'DN' => 'Dadra and Nagar Haveli',
		'DD' => 'Daman and Diu',
		'DL' => 'Delhi',
		'LD' => 'Lakshadeep',
		'PY' => 'Pondicherry (Puducherry)',
	),
	'IR' => array( // Iranian states.
		'KHZ' => 'Khuzestan (خوزستان)',
		'THR' => 'Tehran (تهران)',
		'ILM' => 'Ilaam (ایلام)',
		'BHR' => 'Bushehr (بوشهر)',
		'ADL' => 'Ardabil (اردبیل)',
		'ESF' => 'Isfahan (اصفهان)',
		'YZD' => 'Yazd (یزد)',
		'KRH' => 'Kermanshah (کرمانشاه)',
		'KRN' => 'Kerman (کرمان)',
		'HDN' => 'Hamadan (همدان)',
		'GZN' => 'Ghazvin (قزوین)',
		'ZJN' => 'Zanjan (زنجان)',
		'LRS' => 'Luristan (لرستان)',
		'ABZ' => 'Alborz (البرز)',
		'EAZ' => 'East Azarbaijan (آذربایجان شرقی)',
		'WAZ' => 'West Azarbaijan (آذربایجان غربی)',
		'CHB' => 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)',
		'SKH' => 'South Khorasan (خراسان جنوبی)',
		'RKH' => 'Razavi Khorasan (خراسان رضوی)',
		'NKH' => 'North Khorasan (خراسان شمالی)',
		'SMN' => 'Semnan (سمنان)',
		'FRS' => 'Fars (فارس)',
		'QHM' => 'Qom (قم)',
		'KRD' => 'Kurdistan / کردستان)',
		'KBD' => 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)',
		'GLS' => 'Golestan (گلستان)',
		'GIL' => 'Gilan (گیلان)',
		'MZN' => 'Mazandaran (مازندران)',
		'MKZ' => 'Markazi (مرکزی)',
		'HRZ' => 'Hormozgan (هرمزگان)',
		'SBN' => 'Sistan and Baluchestan (سیستان و بلوچستان)',
	),
	'IS' => array(),
	'IT' => array( // Italian provinces.
		'AG' => 'Agrigento',
		'AL' => 'Alessandria',
		'AN' => 'Ancona',
		'AO' => 'Aosta',
		'AR' => 'Arezzo',
		'AP' => 'Ascoli Piceno',
		'AT' => 'Asti',
		'AV' => 'Avellino',
		'BA' => 'Bari',
		'BT' => 'Barletta-Andria-Trani',
		'BL' => 'Belluno',
		'BN' => 'Benevento',
		'BG' => 'Bergamo',
		'BI' => 'Biella',
		'BO' => 'Bologna',
		'BZ' => 'Bolzano',
		'BS' => 'Brescia',
		'BR' => 'Brindisi',
		'CA' => 'Cagliari',
		'CL' => 'Caltanissetta',
		'CB' => 'Campobasso',
		'CE' => 'Caserta',
		'CT' => 'Catania',
		'CZ' => 'Catanzaro',
		'CH' => 'Chieti',
		'CO' => 'Como',
		'CS' => 'Cosenza',
		'CR' => 'Cremona',
		'KR' => 'Crotone',
		'CN' => 'Cuneo',
		'EN' => 'Enna',
		'FM' => 'Fermo',
		'FE' => 'Ferrara',
		'FI' => 'Firenze',
		'FG' => 'Foggia',
		'FC' => 'Forlì-Cesena',
		'FR' => 'Frosinone',
		'GE' => 'Genova',
		'GO' => 'Gorizia',
		'GR' => 'Grosseto',
		'IM' => 'Imperia',
		'IS' => 'Isernia',
		'SP' => 'La Spezia',
		'AQ' => "L'Aquila",
		'LT' => 'Latina',
		'LE' => 'Lecce',
		'LC' => 'Lecco',
		'LI' => 'Livorno',
		'LO' => 'Lodi',
		'LU' => 'Lucca',
		'MC' => 'Macerata',
		'MN' => 'Mantova',
		'MS' => 'Massa-Carrara',
		'MT' => 'Matera',
		'ME' => 'Messina',
		'MI' => 'Milano',
		'MO' => 'Modena',
		'MB' => 'Monza e della Brianza',
		'NA' => 'Napoli',
		'NO' => 'Novara',
		'NU' => 'Nuoro',
		'OR' => 'Oristano',
		'PD' => 'Padova',
		'PA' => 'Palermo',
		'PR' => 'Parma',
		'PV' => 'Pavia',
		'PG' => 'Perugia',
		'PU' => 'Pesaro e Urbino',
		'PE' => 'Pescara',
		'PC' => 'Piacenza',
		'PI' => 'Pisa',
		'PT' => 'Pistoia',
		'PN' => 'Pordenone',
		'PZ' => 'Potenza',
		'PO' => 'Prato',
		'RG' => 'Ragusa',
		'RA' => 'Ravenna',
		'RC' => 'Reggio Calabria',
		'RE' => 'Reggio Emilia',
		'RI' => 'Rieti',
		'RN' => 'Rimini',
		'RM' => 'Roma',
		'RO' => 'Rovigo',
		'SA' => 'Salerno',
		'SS' => 'Sassari',
		'SV' => 'Savona',
		'SI' => 'Siena',
		'SR' => 'Siracusa',
		'SO' => 'Sondrio',
		'SU' => 'Sud Sardegna',
		'TA' => 'Taranto',
		'TE' => 'Teramo',
		'TR' => 'Terni',
		'TO' => 'Torino',
		'TP' => 'Trapani',
		'TN' => 'Trento',
		'TV' => 'Treviso',
		'TS' => 'Trieste',
		'UD' => 'Udine',
		'VA' => 'Varese',
		'VE' => 'Venezia',
		'VB' => 'Verbano-Cusio-Ossola',
		'VC' => 'Vercelli',
		'VR' => 'Verona',
		'VV' => 'Vibo Valentia',
		'VI' => 'Vicenza',
		'VT' => 'Viterbo',
	),
	'IL' => array(),
	'IM' => array(),
	'JM' => array( // Jamaican parishes.
		'JM-01' => 'Kingston',
		'JM-02' => 'Saint Andrew',
		'JM-03' => 'Saint Thomas',
		'JM-04' => 'Portland',
		'JM-05' => 'Saint Mary',
		'JM-06' => 'Saint Ann',
		'JM-07' => 'Trelawny',
		'JM-08' => 'Saint James',
		'JM-09' => 'Hanover',
		'JM-10' => 'Westmoreland',
		'JM-11' => 'Saint Elizabeth',
		'JM-12' => 'Manchester',
		'JM-13' => 'Clarendon',
		'JM-14' => 'Saint Catherine',
	),

	/**
	 * Japanese states.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => 'Hokkaido',
		'JP02' => 'Aomori',
		'JP03' => 'Iwate',
		'JP04' => 'Miyagi',
		'JP05' => 'Akita',
		'JP06' => 'Yamagata',
		'JP07' => 'Fukushima',
		'JP08' => 'Ibaraki',
		'JP09' => 'Tochigi',
		'JP10' => 'Gunma',
		'JP11' => 'Saitama',
		'JP12' => 'Chiba',
		'JP13' => 'Tokyo',
		'JP14' => 'Kanagawa',
		'JP15' => 'Niigata',
		'JP16' => 'Toyama',
		'JP17' => 'Ishikawa',
		'JP18' => 'Fukui',
		'JP19' => 'Yamanashi',
		'JP20' => 'Nagano',
		'JP21' => 'Gifu',
		'JP22' => 'Shizuoka',
		'JP23' => 'Aichi',
		'JP24' => 'Mie',
		'JP25' => 'Shiga',
		'JP26' => 'Kyoto',
		'JP27' => 'Osaka',
		'JP28' => 'Hyogo',
		'JP29' => 'Nara',
		'JP30' => 'Wakayama',
		'JP31' => 'Tottori',
		'JP32' => 'Shimane',
		'JP33' => 'Okayama',
		'JP34' => 'Hiroshima',
		'JP35' => 'Yamaguchi',
		'JP36' => 'Tokushima',
		'JP37' => 'Kagawa',
		'JP38' => 'Ehime',
		'JP39' => 'Kochi',
		'JP40' => 'Fukuoka',
		'JP41' => 'Saga',
		'JP42' => 'Nagasaki',
		'JP43' => 'Kumamoto',
		'JP44' => 'Oita',
		'JP45' => 'Miyazaki',
		'JP46' => 'Kagoshima',
		'JP47' => 'Okinawa',
	),
	'KE' => array( // Kenyan counties.
		'KE01' => 'Baringo',
		'KE02' => 'Bomet',
		'KE03' => 'Bungoma',
		'KE04' => 'Busia',
		'KE05' => 'Elgeyo-Marakwet',
		'KE06' => 'Embu',
		'KE07' => 'Garissa',
		'KE08' => 'Homa Bay',
		'KE09' => 'Isiolo',
		'KE10' => 'Kajiado',
		'KE11' => 'Kakamega',
		'KE12' => 'Kericho',
		'KE13' => 'Kiambu',
		'KE14' => 'Kilifi',
		'KE15' => 'Kirinyaga',
		'KE16' => 'Kisii',
		'KE17' => 'Kisumu',
		'KE18' => 'Kitui',
		'KE19' => 'Kwale',
		'KE20' => 'Laikipia',
		'KE21' => 'Lamu',
		'KE22' => 'Machakos',
		'KE23' => 'Makueni',
		'KE24' => 'Mandera',
		'KE25' => 'Marsabit',
		'KE26' => 'Meru',
		'KE27' => 'Migori',
		'KE28' => 'Mombasa',
		'KE29' => 'Murang’a',
		'KE30' => 'Nairobi County',
		'KE31' => 'Nakuru',
		'KE32' => 'Nandi',
		'KE33' => 'Narok',
		'KE34' => 'Nyamira',
		'KE35' => 'Nyandarua',
		'KE36' => 'Nyeri',
		'KE37' => 'Samburu',
		'KE38' => 'Siaya',
		'KE39' => 'Taita-Taveta',
		'KE40' => 'Tana River',
		'KE41' => 'Tharaka-Nithi',
		'KE42' => 'Trans Nzoia',
		'KE43' => 'Turkana',
		'KE44' => 'Uasin Gishu',
		'KE45' => 'Vihiga',
		'KE46' => 'Wajir',
		'KE47' => 'West Pokot',
	),
	'KN' => array( // Saint Kitts and Nevis parishes.
		'KNK'  => 'Saint Kitts',
		'KNN'  => 'Nevis',
		'KN01' => 'Christ Church Nichola Town',
		'KN02' => 'Saint Anne Sandy Point',
		'KN03' => 'Saint George Basseterre',
		'KN04' => 'Saint George Gingerland',
		'KN05' => 'Saint James Windward',
		'KN06' => 'Saint John Capisterre',
		'KN07' => 'Saint John Figtree',
		'KN08' => 'Saint Mary Cayon',
		'KN09' => 'Saint Paul Capisterre',
		'KN10' => 'Saint Paul Charlestown',
		'KN11' => 'Saint Peter Basseterre',
		'KN12' => 'Saint Thomas Lowland',
		'KN13' => 'Saint Thomas Middle Island',
		'KN15' => 'Trinity Palmetto Point',
	),
	'KR' => array(),
	'KW' => array(),
	'LA' => array( // Laotian provinces.
		'AT' => 'Attapeu',
		'BK' => 'Bokeo',
		'BL' => 'Bolikhamsai',
		'CH' => 'Champasak',
		'HO' => 'Houaphanh',
		'KH' => 'Khammouane',
		'LM' => 'Luang Namtha',
		'LP' => 'Luang Prabang',
		'OU' => 'Oudomxay',
		'PH' => 'Phongsaly',
		'SL' => 'Salavan',
		'SV' => 'Savannakhet',
		'VI' => 'Vientiane Province',
		'VT' => 'Vientiane',
		'XA' => 'Sainyabuli',
		'XE' => 'Sekong',
		'XI' => 'Xiangkhouang',
		'XS' => 'Xaisomboun',
	),
	'LB' => array(),
	'LI' => array(),
	'LR' => array( // Liberian provinces.
		'BM' => 'Bomi',
		'BN' => 'Bong',
		'GA' => 'Gbarpolu',
		'GB' => 'Grand Bassa',
		'GC' => 'Grand Cape Mount',
		'GG' => 'Grand Gedeh',
		'GK' => 'Grand Kru',
		'LO' => 'Lofa',
		'MA' => 'Margibi',
		'MY' => 'Maryland',
		'MO' => 'Montserrado',
		'NM' => 'Nimba',
		'RV' => 'Rivercess',
		'RG' => 'River Gee',
		'SN' => 'Sinoe',
	),
	'LU' => array(),
	'MA' => array( // Moroccan regions.
		'maagd' => 'Agadir-Ida Ou Tanane',
		'maazi' => 'Azilal',
		'mabem' => 'Béni-Mellal',
		'maber' => 'Berkane',
		'mabes' => 'Ben Slimane',
		'mabod' => 'Boujdour',
		'mabom' => 'Boulemane',
		'mabrr' => 'Berrechid',
		'macas' => 'Casablanca',
		'mache' => 'Chefchaouen',
		'machi' => 'Chichaoua',
		'macht' => 'Chtouka Aït Baha',
		'madri' => 'Driouch',
		'maedi' => 'Essaouira',
		'maerr' => 'Errachidia',
		'mafah' => 'Fahs-Beni Makada',
		'mafes' => 'Fès-Dar-Dbibegh',
		'mafig' => 'Figuig',
		'mafqh' => 'Fquih Ben Salah',
		'mafes' => 'Fès-Dar-Dbibegh',
		'mague' => 'Guelmim',
		'maguf' => 'Guercif',
		'mahaj' => 'El Hajeb',
		'mahao' => 'Al Haouz',
		'mahoc' => 'Al Hoceïma',
		'maifr' => 'Ifrane',
		'maine' => 'Inezgane-Aït Melloul',
		'majdi' => 'El Jadida',
		'majra' => 'Jerada',
		'maken' => 'Kénitra',
		'makes' => 'Kelaat Sraghna',
		'makhe' => 'Khemisset',
		'makhn' => 'Khénifra',
		'makho' => 'Khouribga',
		'malaa' => 'Laâyoune',
		'malar' => 'Larache',
		'mamar' => 'Marrakech',
		'mamdf' => 'M’diq-Fnideq',
		'mamed' => 'Médiouna',
		'mamek' => 'Meknès',
		'mamid' => 'Midelt',
		'mammd' => 'Marrakech-Medina',
		'mammn' => 'Marrakech-Menara',
		'mamoh' => 'Mohammedia',
		'mamou' => 'Moulay Yacoub',
		'manad' => 'Nador',
		'manou' => 'Nouaceur',
		'maoua' => 'Ouarzazate',
		'maoud' => 'Oued Ed-Dahab',
		'maouj' => 'Oujda-Angad',
		'maouz' => 'Ouezzane',
		'marab' => 'Rabat',
		'mareh' => 'Rehamna',
		'masaf' => 'Safi',
		'masal' => 'Salé',
		'masef' => 'Sefrou',
		'maset' => 'Settat',
		'masib' => 'Sidi Bennour',
		'masif' => 'Sidi Ifni',
		'masik' => 'Sidi Kacem',
		'masil' => 'Sidi Slimane',
		'maskh' => 'Skhirat-Témara',
		'masyb' => 'Sidi Youssef Ben Ali',
		'mataf' => 'Tarfaya (EH-partial)',
		'matai' => 'Taourirt',
		'matao' => 'Taounate',
		'matar' => 'Taroudant',
		'matat' => 'Tata',
		'mataz' => 'Taza',
		'matet' => 'Tétouan',
		'matin' => 'Tinghir',
		'matiz' => 'Tiznit',
		'matng' => 'Tangier-Assilah',
		'matnt' => 'Tan-Tan',
		'mayus' => 'Youssoufia',
		'mazag' => 'Zagora'
	),
	'MD' => array( // Moldovan states.
		'C'  => 'Chișinău',
		'BL' => 'Bălți',
		'AN' => 'Anenii Noi',
		'BS' => 'Basarabeasca',
		'BR' => 'Briceni',
		'CH' => 'Cahul',
		'CT' => 'Cantemir',
		'CL' => 'Călărași',
		'CS' => 'Căușeni',
		'CM' => 'Cimișlia',
		'CR' => 'Criuleni',
		'DN' => 'Dondușeni',
		'DR' => 'Drochia',
		'DB' => 'Dubăsari',
		'ED' => 'Edineț',
		'FL' => 'Fălești',
		'FR' => 'Florești',
		'GE' => 'UTA Găgăuzia',
		'GL' => 'Glodeni',
		'HN' => 'Hîncești',
		'IL' => 'Ialoveni',
		'LV' => 'Leova',
		'NS' => 'Nisporeni',
		'OC' => 'Ocnița',
		'OR' => 'Orhei',
		'RZ' => 'Rezina',
		'RS' => 'Rîșcani',
		'SG' => 'Sîngerei',
		'SR' => 'Soroca',
		'ST' => 'Strășeni',
		'SD' => 'Șoldănești',
		'SV' => 'Ștefan Vodă',
		'TR' => 'Taraclia',
		'TL' => 'Telenești',
		'UN' => 'Ungheni',
	),
	'MF' => array(),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexican states.
		'DF' => 'Ciudad de México',
		'JA' => 'Jalisco',
		'NL' => 'Nuevo León',
		'AG' => 'Aguascalientes',
		'BC' => 'Baja California',
		'BS' => 'Baja California Sur',
		'CM' => 'Campeche',
		'CS' => 'Chiapas',
		'CH' => 'Chihuahua',
		'CO' => 'Coahuila',
		'CL' => 'Colima',
		'DG' => 'Durango',
		'GT' => 'Guanajuato',
		'GR' => 'Guerrero',
		'HG' => 'Hidalgo',
		'MX' => 'Estado de México',
		'MI' => 'Michoacán',
		'MO' => 'Morelos',
		'NA' => 'Nayarit',
		'OA' => 'Oaxaca',
		'PU' => 'Puebla',
		'QT' => 'Querétaro',
		'QR' => 'Quintana Roo',
		'SL' => 'San Luis Potosí',
		'SI' => 'Sinaloa',
		'SO' => 'Sonora',
		'TB' => 'Tabasco',
		'TM' => 'Tamaulipas',
		'TL' => 'Tlaxcala',
		'VE' => 'Veracruz',
		'YU' => 'Yucatán',
		'ZA' => 'Zacatecas',
	),
	'MY' => array( // Malaysian states.
		'JHR' => 'Johor',
		'KDH' => 'Kedah',
		'KTN' => 'Kelantan',
		'LBN' => 'Labuan',
		'MLK' => 'Malacca (Melaka)',
		'NSN' => 'Negeri Sembilan',
		'PHG' => 'Pahang',
		'PNG' => 'Penang (Pulau Pinang)',
		'PRK' => 'Perak',
		'PLS' => 'Perlis',
		'SBH' => 'Sabah',
		'SWK' => 'Sarawak',
		'SGR' => 'Selangor',
		'TRG' => 'Terengganu',
		'PJY' => 'Putrajaya',
		'KUL' => 'Kuala Lumpur',
	),
	'MZ' => array( // Mozambican provinces.
		'MZP'   => 'Cabo Delgado',
		'MZG'   => 'Gaza',
		'MZI'   => 'Inhambane',
		'MZB'   => 'Manica',
		'MZL'   => 'Maputo Province',
		'MZMPM' => 'Maputo',
		'MZN'   => 'Nampula',
		'MZA'   => 'Niassa',
		'MZS'   => 'Sofala',
		'MZT'   => 'Tete',
		'MZQ'   => 'Zambézia',
	),
	'NA' => array( // Namibian regions.
		'ER' => 'Erongo',
		'HA' => 'Hardap',
		'KA' => 'Karas',
		'KE' => 'Kavango East',
		'KW' => 'Kavango West',
		'KH' => 'Khomas',
		'KU' => 'Kunene',
		'OW' => 'Ohangwena',
		'OH' => 'Omaheke',
		'OS' => 'Omusati',
		'ON' => 'Oshana',
		'OT' => 'Oshikoto',
		'OD' => 'Otjozondjupa',
		'CA' => 'Zambezi',
	),
	'NG' => array( // Nigerian provinces.
		'AB' => 'Abia',
		'FC' => 'Abuja',
		'AD' => 'Adamawa',
		'AK' => 'Akwa Ibom',
		'AN' => 'Anambra',
		'BA' => 'Bauchi',
		'BY' => 'Bayelsa',
		'BE' => 'Benue',
		'BO' => 'Borno',
		'CR' => 'Cross River',
		'DE' => 'Delta',
		'EB' => 'Ebonyi',
		'ED' => 'Edo',
		'EK' => 'Ekiti',
		'EN' => 'Enugu',
		'GO' => 'Gombe',
		'IM' => 'Imo',
		'JI' => 'Jigawa',
		'KD' => 'Kaduna',
		'KN' => 'Kano',
		'KT' => 'Katsina',
		'KE' => 'Kebbi',
		'KO' => 'Kogi',
		'KW' => 'Kwara',
		'LA' => 'Lagos',
		'NA' => 'Nasarawa',
		'NI' => 'Niger',
		'OG' => 'Ogun',
		'ON' => 'Ondo',
		'OS' => 'Osun',
		'OY' => 'Oyo',
		'PL' => 'Plateau',
		'RI' => 'Rivers',
		'SO' => 'Sokoto',
		'TA' => 'Taraba',
		'YO' => 'Yobe',
		'ZA' => 'Zamfara',
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepalese zones.
		'BAG' => 'Bagmati',
		'BHE' => 'Bheri',
		'DHA' => 'Dhaulagiri',
		'GAN' => 'Gandaki',
		'JAN' => 'Janakpur',
		'KAR' => 'Karnali',
		'KOS' => 'Koshi',
		'LUM' => 'Lumbini',
		'MAH' => 'Mahakali',
		'MEC' => 'Mechi',
		'NAR' => 'Narayani',
		'RAP' => 'Rapti',
		'SAG' => 'Sagarmatha',
		'SET' => 'Seti',
	),
	'NI' => array( // Nicaraguan states.
		'NI-AN' => 'Atlántico Norte',
		'NI-AS' => 'Atlántico Sur',
		'NI-BO' => 'Boaco',
		'NI-CA' => 'Carazo',
		'NI-CI' => 'Chinandega',
		'NI-CO' => 'Chontales',
		'NI-ES' => 'Estelí',
		'NI-GR' => 'Granada',
		'NI-JI' => 'Jinotega',
		'NI-LE' => 'León',
		'NI-MD' => 'Madriz',
		'NI-MN' => 'Managua',
		'NI-MS' => 'Masaya',
		'NI-MT' => 'Matagalpa',
		'NI-NS' => 'Nueva Segovia',
		'NI-RI' => 'Rivas',
		'NI-SJ' => 'Río San Juan',
	),
	'NZ' => array( // New Zealand states.
		'NTL' => 'Northland',
		'AUK' => 'Auckland',
		'WKO' => 'Waikato',
		'BOP' => 'Bay of Plenty',
		'TKI' => 'Taranaki',
		'GIS' => 'Gisborne',
		'HKB' => 'Hawke’s Bay',
		'MWT' => 'Manawatu-Wanganui',
		'WGN' => 'Wellington',
		'NSN' => 'Nelson',
		'MBH' => 'Marlborough',
		'TAS' => 'Tasman',
		'WTC' => 'West Coast',
		'CAN' => 'Canterbury',
		'OTA' => 'Otago',
		'STL' => 'Southland',
	),
	'PA' => array( // Panamanian states.
		'PA-1' => 'Bocas del Toro',
		'PA-2' => 'Coclé',
		'PA-3' => 'Colón',
		'PA-4' => 'Chiriquí',
		'PA-5' => 'Darién',
		'PA-6' => 'Herrera',
		'PA-7' => 'Los Santos',
		'PA-8' => 'Panamá',
		'PA-9' => 'Veraguas',
		'PA-10' => 'West Panamá',
		'PA-EM' => 'Emberá',
		'PA-KY' => 'Guna Yala',
		'PA-NB' => 'Ngöbe-Buglé',
	),
	'PE' => array( // Peruvian states.
		'CAL' => 'El Callao',
		'LMA' => 'Municipalidad Metropolitana de Lima',
		'AMA' => 'Amazonas',
		'ANC' => 'Ancash',
		'APU' => 'Apurímac',
		'ARE' => 'Arequipa',
		'AYA' => 'Ayacucho',
		'CAJ' => 'Cajamarca',
		'CUS' => 'Cusco',
		'HUV' => 'Huancavelica',
		'HUC' => 'Huánuco',
		'ICA' => 'Ica',
		'JUN' => 'Junín',
		'LAL' => 'La Libertad',
		'LAM' => 'Lambayeque',
		'LIM' => 'Lima',
		'LOR' => 'Loreto',
		'MDD' => 'Madre de Dios',
		'MOQ' => 'Moquegua',
		'PAS' => 'Pasco',
		'PIU' => 'Piura',
		'PUN' => 'Puno',
		'SAM' => 'San Martín',
		'TAC' => 'Tacna',
		'TUM' => 'Tumbes',
		'UCA' => 'Ucayali',
	),
	'PH' => array( // Philippine provinces.
		'ABR' => 'Abra',
		'AGN' => 'Agusan del Norte',
		'AGS' => 'Agusan del Sur',
		'AKL' => 'Aklan',
		'ALB' => 'Albay',
		'ANT' => 'Antique',
		'APA' => 'Apayao',
		'AUR' => 'Aurora',
		'BAS' => 'Basilan',
		'BAN' => 'Bataan',
		'BTN' => 'Batanes',
		'BTG' => 'Batangas',
		'BEN' => 'Benguet',
		'BIL' => 'Biliran',
		'BOH' => 'Bohol',
		'BUK' => 'Bukidnon',
		'BUL' => 'Bulacan',
		'CAG' => 'Cagayan',
		'CAN' => 'Camarines Norte',
		'CAS' => 'Camarines Sur',
		'CAM' => 'Camiguin',
		'CAP' => 'Capiz',
		'CAT' => 'Catanduanes',
		'CAV' => 'Cavite',
		'CEB' => 'Cebu',
		'COM' => 'Compostela Valley',
		'NCO' => 'Cotabato',
		'DAV' => 'Davao del Norte',
		'DAS' => 'Davao del Sur',
		'DAC' => 'Davao Occidental',
		'DAO' => 'Davao Oriental',
		'DIN' => 'Dinagat Islands',
		'EAS' => 'Eastern Samar',
		'GUI' => 'Guimaras',
		'IFU' => 'Ifugao',
		'ILN' => 'Ilocos Norte',
		'ILS' => 'Ilocos Sur',
		'ILI' => 'Iloilo',
		'ISA' => 'Isabela',
		'KAL' => 'Kalinga',
		'LUN' => 'La Union',
		'LAG' => 'Laguna',
		'LAN' => 'Lanao del Norte',
		'LAS' => 'Lanao del Sur',
		'LEY' => 'Leyte',
		'MAG' => 'Maguindanao',
		'MAD' => 'Marinduque',
		'MAS' => 'Masbate',
		'MSC' => 'Misamis Occidental',
		'MSR' => 'Misamis Oriental',
		'MOU' => 'Mountain Province',
		'NEC' => 'Negros Occidental',
		'NER' => 'Negros Oriental',
		'NSA' => 'Northern Samar',
		'NUE' => 'Nueva Ecija',
		'NUV' => 'Nueva Vizcaya',
		'MDC' => 'Occidental Mindoro',
		'MDR' => 'Oriental Mindoro',
		'PLW' => 'Palawan',
		'PAM' => 'Pampanga',
		'PAN' => 'Pangasinan',
		'QUE' => 'Quezon',
		'QUI' => 'Quirino',
		'RIZ' => 'Rizal',
		'ROM' => 'Romblon',
		'WSA' => 'Samar',
		'SAR' => 'Sarangani',
		'SIQ' => 'Siquijor',
		'SOR' => 'Sorsogon',
		'SCO' => 'South Cotabato',
		'SLE' => 'Southern Leyte',
		'SUK' => 'Sultan Kudarat',
		'SLU' => 'Sulu',
		'SUN' => 'Surigao del Norte',
		'SUR' => 'Surigao del Sur',
		'TAR' => 'Tarlac',
		'TAW' => 'Tawi-Tawi',
		'ZMB' => 'Zambales',
		'ZAN' => 'Zamboanga del Norte',
		'ZAS' => 'Zamboanga del Sur',
		'ZSI' => 'Zamboanga Sibugay',
		'00'  => 'Metro Manila',
	),
	'PK' => array( // Pakistani states.
		'JK' => 'Azad Kashmir',
		'BA' => 'Balochistan',
		'TA' => 'FATA',
		'GB' => 'Gilgit Baltistan',
		'IS' => 'Islamabad Capital Territory',
		'KP' => 'Khyber Pakhtunkhwa',
		'PB' => 'Punjab',
		'SD' => 'Sindh',
	),
	'PL' => array(),
	'PR' => array(),
	'PT' => array(),
	'PY' => array( // Paraguayan states.
		'PY-ASU' => 'Asunción',
		'PY-1'   => 'Concepción',
		'PY-2'   => 'San Pedro',
		'PY-3'   => 'Cordillera',
		'PY-4'   => 'Guairá',
		'PY-5'   => 'Caaguazú',
		'PY-6'   => 'Caazapá',
		'PY-7'   => 'Itapúa',
		'PY-8'   => 'Misiones',
		'PY-9'   => 'Paraguarí',
		'PY-10'  => 'Alto Paraná',
		'PY-11'  => 'Central',
		'PY-12'  => 'Ñeembucú',
		'PY-13'  => 'Amambay',
		'PY-14'  => 'Canindeyú',
		'PY-15'  => 'Presidente Hayes',
		'PY-16'  => 'Alto Paraguay',
		'PY-17'  => 'Boquerón',
	),
	'RE' => array(),
	'RO' => array( // Romanian states.
		'AB' => 'Alba',
		'AR' => 'Arad',
		'AG' => 'Argeș',
		'BC' => 'Bacău',
		'BH' => 'Bihor',
		'BN' => 'Bistrița-Năsăud',
		'BT' => 'Botoșani',
		'BR' => 'Brăila',
		'BV' => 'Brașov',
		'B'  => 'București',
		'BZ' => 'Buzău',
		'CL' => 'Călărași',
		'CS' => 'Caraș-Severin',
		'CJ' => 'Cluj',
		'CT' => 'Constanța',
		'CV' => 'Covasna',
		'DB' => 'Dâmbovița',
		'DJ' => 'Dolj',
		'GL' => 'Galați',
		'GR' => 'Giurgiu',
		'GJ' => 'Gorj',
		'HR' => 'Harghita',
		'HD' => 'Hunedoara',
		'IL' => 'Ialomița',
		'IS' => 'Iași',
		'IF' => 'Ilfov',
		'MM' => 'Maramureș',
		'MH' => 'Mehedinți',
		'MS' => 'Mureș',
		'NT' => 'Neamț',
		'OT' => 'Olt',
		'PH' => 'Prahova',
		'SJ' => 'Sălaj',
		'SM' => 'Satu Mare',
		'SB' => 'Sibiu',
		'SV' => 'Suceava',
		'TR' => 'Teleorman',
		'TM' => 'Timiș',
		'TL' => 'Tulcea',
		'VL' => 'Vâlcea',
		'VS' => 'Vaslui',
		'VN' => 'Vrancea',
	),
	'SN' => array( // Regions of Senegal. Ref: https://github.com/unicode-org/cldr/blob/release-42/common/subdivisions/en.xml#L4801.
		'SNDB' => 'Diourbel',
		'SNDK' => 'Dakar',
		'SNFK' => 'Fatick',
		'SNKA' => 'Kaffrine',
		'SNKD' => 'Kolda',
		'SNKE' => 'Kédougou',
		'SNKL' => 'Kaolack',
		'SNLG' => 'Louga',
		'SNMT' => 'Matam',
		'SNSE' => 'Sédhiou',
		'SNSL' => 'Saint-Louis',
		'SNTC' => 'Tambacounda',
		'SNTH' => 'Thiès',
		'SNZG' => 'Ziguinchor',
	),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'SV' => array( // Salvadoran states.
		'SV-AH' => 'Ahuachapán',
		'SV-CA' => 'Cabañas',
		'SV-CH' => 'Chalatenango',
		'SV-CU' => 'Cuscatlán',
		'SV-LI' => 'La Libertad',
		'SV-MO' => 'Morazán',
		'SV-PA' => 'La Paz',
		'SV-SA' => 'Santa Ana',
		'SV-SM' => 'San Miguel',
		'SV-SO' => 'Sonsonate',
		'SV-SS' => 'San Salvador',
		'SV-SV' => 'San Vicente',
		'SV-UN' => 'La Unión',
		'SV-US' => 'Usulután',
	),
	'TH' => array( // Thai states.
		'TH-37' => 'Amnat Charoen',
		'TH-15' => 'Ang Thong',
		'TH-14' => 'Ayutthaya',
		'TH-10' => 'Bangkok',
		'TH-38' => 'Bueng Kan',
		'TH-31' => 'Buri Ram',
		'TH-24' => 'Chachoengsao',
		'TH-18' => 'Chai Nat',
		'TH-36' => 'Chaiyaphum',
		'TH-22' => 'Chanthaburi',
		'TH-50' => 'Chiang Mai',
		'TH-57' => 'Chiang Rai',
		'TH-20' => 'Chonburi',
		'TH-86' => 'Chumphon',
		'TH-46' => 'Kalasin',
		'TH-62' => 'Kamphaeng Phet',
		'TH-71' => 'Kanchanaburi',
		'TH-40' => 'Khon Kaen',
		'TH-81' => 'Krabi',
		'TH-52' => 'Lampang',
		'TH-51' => 'Lamphun',
		'TH-42' => 'Loei',
		'TH-16' => 'Lopburi',
		'TH-58' => 'Mae Hong Son',
		'TH-44' => 'Maha Sarakham',
		'TH-49' => 'Mukdahan',
		'TH-26' => 'Nakhon Nayok',
		'TH-73' => 'Nakhon Pathom',
		'TH-48' => 'Nakhon Phanom',
		'TH-30' => 'Nakhon Ratchasima',
		'TH-60' => 'Nakhon Sawan',
		'TH-80' => 'Nakhon Si Thammarat',
		'TH-55' => 'Nan',
		'TH-96' => 'Narathiwat',
		'TH-39' => 'Nong Bua Lam Phu',
		'TH-43' => 'Nong Khai',
		'TH-12' => 'Nonthaburi',
		'TH-13' => 'Pathum Thani',
		'TH-94' => 'Pattani',
		'TH-82' => 'Phang Nga',
		'TH-93' => 'Phatthalung',
		'TH-56' => 'Phayao',
		'TH-67' => 'Phetchabun',
		'TH-76' => 'Phetchaburi',
		'TH-66' => 'Phichit',
		'TH-65' => 'Phitsanulok',
		'TH-54' => 'Phrae',
		'TH-83' => 'Phuket',
		'TH-25' => 'Prachin Buri',
		'TH-77' => 'Prachuap Khiri Khan',
		'TH-85' => 'Ranong',
		'TH-70' => 'Ratchaburi',
		'TH-21' => 'Rayong',
		'TH-45' => 'Roi Et',
		'TH-27' => 'Sa Kaeo',
		'TH-47' => 'Sakon Nakhon',
		'TH-11' => 'Samut Prakan',
		'TH-74' => 'Samut Sakhon',
		'TH-75' => 'Samut Songkhram',
		'TH-19' => 'Saraburi',
		'TH-91' => 'Satun',
		'TH-17' => 'Sing Buri',
		'TH-33' => 'Sisaket',
		'TH-90' => 'Songkhla',
		'TH-64' => 'Sukhothai',
		'TH-72' => 'Suphan Buri',
		'TH-84' => 'Surat Thani',
		'TH-32' => 'Surin',
		'TH-63' => 'Tak',
		'TH-92' => 'Trang',
		'TH-23' => 'Trat',
		'TH-34' => 'Ubon Ratchathani',
		'TH-41' => 'Udon Thani',
		'TH-61' => 'Uthai Thani',
		'TH-53' => 'Uttaradit',
		'TH-95' => 'Yala',
		'TH-35' => 'Yasothon',
	),
	'TR' => array( // Turkish states.
		'TR01' => 'Adana',
		'TR02' => 'Adıyaman',
		'TR03' => 'Afyon',
		'TR04' => 'Ağrı',
		'TR05' => 'Amasya',
		'TR06' => 'Ankara',
		'TR07' => 'Antalya',
		'TR08' => 'Artvin',
		'TR09' => 'Aydın',
		'TR10' => 'Balıkesir',
		'TR11' => 'Bilecik',
		'TR12' => 'Bingöl',
		'TR13' => 'Bitlis',
		'TR14' => 'Bolu',
		'TR15' => 'Burdur',
		'TR16' => 'Bursa',
		'TR17' => 'Çanakkale',
		'TR18' => 'Çankırı',
		'TR19' => 'Çorum',
		'TR20' => 'Denizli',
		'TR21' => 'Diyarbakır',
		'TR22' => 'Edirne',
		'TR23' => 'Elazığ',
		'TR24' => 'Erzincan',
		'TR25' => 'Erzurum',
		'TR26' => 'Eskişehir',
		'TR27' => 'Gaziantep',
		'TR28' => 'Giresun',
		'TR29' => 'Gümüşhane',
		'TR30' => 'Hakkari',
		'TR31' => 'Hatay',
		'TR32' => 'Isparta',
		'TR33' => 'İçel',
		'TR34' => 'İstanbul',
		'TR35' => 'İzmir',
		'TR36' => 'Kars',
		'TR37' => 'Kastamonu',
		'TR38' => 'Kayseri',
		'TR39' => 'Kırklareli',
		'TR40' => 'Kırşehir',
		'TR41' => 'Kocaeli',
		'TR42' => 'Konya',
		'TR43' => 'Kütahya',
		'TR44' => 'Malatya',
		'TR45' => 'Manisa',
		'TR46' => 'Kahramanmaraş',
		'TR47' => 'Mardin',
		'TR48' => 'Muğla',
		'TR49' => 'Muş',
		'TR50' => 'Nevşehir',
		'TR51' => 'Niğde',
		'TR52' => 'Ordu',
		'TR53' => 'Rize',
		'TR54' => 'Sakarya',
		'TR55' => 'Samsun',
		'TR56' => 'Siirt',
		'TR57' => 'Sinop',
		'TR58' => 'Sivas',
		'TR59' => 'Tekirdağ',
		'TR60' => 'Tokat',
		'TR61' => 'Trabzon',
		'TR62' => 'Tunceli',
		'TR63' => 'Şanlıurfa',
		'TR64' => 'Uşak',
		'TR65' => 'Van',
		'TR66' => 'Yozgat',
		'TR67' => 'Zonguldak',
		'TR68' => 'Aksaray',
		'TR69' => 'Bayburt',
		'TR70' => 'Karaman',
		'TR71' => 'Kırıkkale',
		'TR72' => 'Batman',
		'TR73' => 'Şırnak',
		'TR74' => 'Bartın',
		'TR75' => 'Ardahan',
		'TR76' => 'Iğdır',
		'TR77' => 'Yalova',
		'TR78' => 'Karabük',
		'TR79' => 'Kilis',
		'TR80' => 'Osmaniye',
		'TR81' => 'Düzce',
	),
	'TZ' => array( // Tanzanian states.
		'TZ01' => 'Arusha',
		'TZ02' => 'Dar es Salaam',
		'TZ03' => 'Dodoma',
		'TZ04' => 'Iringa',
		'TZ05' => 'Kagera',
		'TZ06' => 'Pemba North',
		'TZ07' => 'Zanzibar North',
		'TZ08' => 'Kigoma',
		'TZ09' => 'Kilimanjaro',
		'TZ10' => 'Pemba South',
		'TZ11' => 'Zanzibar South',
		'TZ12' => 'Lindi',
		'TZ13' => 'Mara',
		'TZ14' => 'Mbeya',
		'TZ15' => 'Zanzibar West',
		'TZ16' => 'Morogoro',
		'TZ17' => 'Mtwara',
		'TZ18' => 'Mwanza',
		'TZ19' => 'Coast',
		'TZ20' => 'Rukwa',
		'TZ21' => 'Ruvuma',
		'TZ22' => 'Shinyanga',
		'TZ23' => 'Singida',
		'TZ24' => 'Tabora',
		'TZ25' => 'Tanga',
		'TZ26' => 'Manyara',
		'TZ27' => 'Geita',
		'TZ28' => 'Katavi',
		'TZ29' => 'Njombe',
		'TZ30' => 'Simiyu',
	),
	'LK' => array(),
	'RS' => array( // Serbian districts.
		'RS00' => 'Belgrade', 'district',
		'RS14' => 'Bor', 'district',
		'RS11' => 'Braničevo', 'district',
		'RS02' => 'Central Banat', 'district',
		'RS10' => 'Danube', 'district',
		'RS23' => 'Jablanica', 'district',
		'RS09' => 'Kolubara', 'district',
		'RS08' => 'Mačva', 'district',
		'RS17' => 'Morava', 'district',
		'RS20' => 'Nišava', 'district',
		'RS01' => 'North Bačka', 'district',
		'RS03' => 'North Banat', 'district',
		'RS24' => 'Pčinja', 'district',
		'RS22' => 'Pirot', 'district',
		'RS13' => 'Pomoravlje', 'district',
		'RS19' => 'Rasina', 'district',
		'RS18' => 'Raška', 'district',
		'RS06' => 'South Bačka', 'district',
		'RS04' => 'South Banat', 'district',
		'RS07' => 'Srem', 'district',
		'RS12' => 'Šumadija', 'district',
		'RS21' => 'Toplica', 'district',
		'RS05' => 'West Bačka', 'district',
		'RS15' => 'Zaječar', 'district',
		'RS16' => 'Zlatibor', 'district',
		'RS25' => 'Kosovo', 'district',
		'RS26' => 'Peć', 'district',
		'RS27' => 'Prizren', 'district',
		'RS28' => 'Kosovska Mitrovica', 'district',
		'RS29' => 'Kosovo-Pomoravlje', 'district',
		'RSKM' => 'Kosovo-Metohija', 'district',
		'RSVO' => 'Vojvodina', 'district',
	),
	'RW' => array(),
	'SE' => array(),
	'UA' => array( // Ukrainian oblasts. https://github.com/unicode-org/cldr/blob/release-42/common/subdivisions/en.xml#L5243.
		'UA05' => 'Vinnychchyna',
		'UA07' => 'Volyn',
		'UA09' => 'Luhanshchyna',
		'UA12' => 'Dnipropetrovshchyna',
		'UA14' => 'Donechchyna',
		'UA18' => 'Zhytomyrshchyna',
		'UA21' => 'Zakarpattia',
		'UA23' => 'Zaporizhzhya',
		'UA26' => 'Prykarpattia',
		'UA30' => 'Kyiv',
		'UA32' => 'Kyivshchyna',
		'UA35' => 'Kirovohradschyna',
		'UA40' => 'Sevastopol',
		'UA43' => 'Crimea',
		'UA46' => 'Lvivshchyna',
		'UA48' => 'Mykolayivschyna',
		'UA51' => 'Odeshchyna',
		'UA53' => 'Poltavshchyna',
		'UA56' => 'Rivnenshchyna',
		'UA59' => 'Sumshchyna',
		'UA61' => 'Ternopilshchyna',
		'UA63' => 'Kharkivshchyna',
		'UA65' => 'Khersonshchyna',
		'UA68' => 'Khmelnychchyna',
		'UA71' => 'Cherkashchyna',
		'UA74' => 'Chernihivshchyna',
		'UA77' => 'Chernivtsi Oblast',
	),
	'UG' => array( // Ugandan districts.
		'UG314' => 'Abim',
		'UG301' => 'Adjumani',
		'UG322' => 'Agago',
		'UG323' => 'Alebtong',
		'UG315' => 'Amolatar',
		'UG324' => 'Amudat',
		'UG216' => 'Amuria',
		'UG316' => 'Amuru',
		'UG302' => 'Apac',
		'UG303' => 'Arua',
		'UG217' => 'Budaka',
		'UG218' => 'Bududa',
		'UG201' => 'Bugiri',
		'UG235' => 'Bugweri',
		'UG420' => 'Buhweju',
		'UG117' => 'Buikwe',
		'UG219' => 'Bukedea',
		'UG118' => 'Bukomansimbi',
		'UG220' => 'Bukwa',
		'UG225' => 'Bulambuli',
		'UG416' => 'Buliisa',
		'UG401' => 'Bundibugyo',
		'UG430' => 'Bunyangabu',
		'UG402' => 'Bushenyi',
		'UG202' => 'Busia',
		'UG221' => 'Butaleja',
		'UG119' => 'Butambala',
		'UG233' => 'Butebo',
		'UG120' => 'Buvuma',
		'UG226' => 'Buyende',
		'UG317' => 'Dokolo',
		'UG121' => 'Gomba',
		'UG304' => 'Gulu',
		'UG403' => 'Hoima',
		'UG417' => 'Ibanda',
		'UG203' => 'Iganga',
		'UG418' => 'Isingiro',
		'UG204' => 'Jinja',
		'UG318' => 'Kaabong',
		'UG404' => 'Kabale',
		'UG405' => 'Kabarole',
		'UG213' => 'Kaberamaido',
		'UG427' => 'Kagadi',
		'UG428' => 'Kakumiro',
		'UG101' => 'Kalangala',
		'UG222' => 'Kaliro',
		'UG122' => 'Kalungu',
		'UG102' => 'Kampala',
		'UG205' => 'Kamuli',
		'UG413' => 'Kamwenge',
		'UG414' => 'Kanungu',
		'UG206' => 'Kapchorwa',
		'UG236' => 'Kapelebyong',
		'UG126' => 'Kasanda',
		'UG406' => 'Kasese',
		'UG207' => 'Katakwi',
		'UG112' => 'Kayunga',
		'UG407' => 'Kibaale',
		'UG103' => 'Kiboga',
		'UG227' => 'Kibuku',
		'UG432' => 'Kikuube',
		'UG419' => 'Kiruhura',
		'UG421' => 'Kiryandongo',
		'UG408' => 'Kisoro',
		'UG305' => 'Kitgum',
		'UG319' => 'Koboko',
		'UG325' => 'Kole',
		'UG306' => 'Kotido',
		'UG208' => 'Kumi',
		'UG333' => 'Kwania',
		'UG228' => 'Kween',
		'UG123' => 'Kyankwanzi',
		'UG422' => 'Kyegegwa',
		'UG415' => 'Kyenjojo',
		'UG125' => 'Kyotera',
		'UG326' => 'Lamwo',
		'UG307' => 'Lira',
		'UG229' => 'Luuka',
		'UG104' => 'Luwero',
		'UG124' => 'Lwengo',
		'UG114' => 'Lyantonde',
		'UG223' => 'Manafwa',
		'UG320' => 'Maracha',
		'UG105' => 'Masaka',
		'UG409' => 'Masindi',
		'UG214' => 'Mayuge',
		'UG209' => 'Mbale',
		'UG410' => 'Mbarara',
		'UG423' => 'Mitooma',
		'UG115' => 'Mityana',
		'UG308' => 'Moroto',
		'UG309' => 'Moyo',
		'UG106' => 'Mpigi',
		'UG107' => 'Mubende',
		'UG108' => 'Mukono',
		'UG334' => 'Nabilatuk',
		'UG311' => 'Nakapiripirit',
		'UG116' => 'Nakaseke',
		'UG109' => 'Nakasongola',
		'UG230' => 'Namayingo',
		'UG234' => 'Namisindwa',
		'UG224' => 'Namutumba',
		'UG327' => 'Napak',
		'UG310' => 'Nebbi',
		'UG231' => 'Ngora',
		'UG424' => 'Ntoroko',
		'UG411' => 'Ntungamo',
		'UG328' => 'Nwoya',
		'UG331' => 'Omoro',
		'UG329' => 'Otuke',
		'UG321' => 'Oyam',
		'UG312' => 'Pader',
		'UG332' => 'Pakwach',
		'UG210' => 'Pallisa',
		'UG110' => 'Rakai',
		'UG429' => 'Rubanda',
		'UG425' => 'Rubirizi',
		'UG431' => 'Rukiga',
		'UG412' => 'Rukungiri',
		'UG111' => 'Sembabule',
		'UG232' => 'Serere',
		'UG426' => 'Sheema',
		'UG215' => 'Sironko',
		'UG211' => 'Soroti',
		'UG212' => 'Tororo',
		'UG113' => 'Wakiso',
		'UG313' => 'Yumbe',
		'UG330' => 'Zombo',
	),
	'UM' => array(
		'81' => 'Baker Island',
		'84' => 'Howland Island',
		'86' => 'Jarvis Island',
		'67' => 'Johnston Atoll',
		'89' => 'Kingman Reef',
		'71' => 'Midway Atoll',
		'76' => 'Navassa Island',
		'95' => 'Palmyra Atoll',
		'79' => 'Wake Island',
	),
	'US' => array( // U.S. states.
		'AL' => 'Alabama',
		'AK' => 'Alaska',
		'AZ' => 'Arizona',
		'AR' => 'Arkansas',
		'CA' => 'California',
		'CO' => 'Colorado',
		'CT' => 'Connecticut',
		'DE' => 'Delaware',
		'DC' => 'District of Columbia',
		'FL' => 'Florida',
		'GA' => 'Georgia', 'US state of Georgia',
		'HI' => 'Hawaii',
		'ID' => 'Idaho',
		'IL' => 'Illinois',
		'IN' => 'Indiana',
		'IA' => 'Iowa',
		'KS' => 'Kansas',
		'KY' => 'Kentucky',
		'LA' => 'Louisiana',
		'ME' => 'Maine',
		'MD' => 'Maryland',
		'MA' => 'Massachusetts',
		'MI' => 'Michigan',
		'MN' => 'Minnesota',
		'MS' => 'Mississippi',
		'MO' => 'Missouri',
		'MT' => 'Montana',
		'NE' => 'Nebraska',
		'NV' => 'Nevada',
		'NH' => 'New Hampshire',
		'NJ' => 'New Jersey',
		'NM' => 'New Mexico',
		'NY' => 'New York',
		'NC' => 'North Carolina',
		'ND' => 'North Dakota',
		'OH' => 'Ohio',
		'OK' => 'Oklahoma',
		'OR' => 'Oregon',
		'PA' => 'Pennsylvania',
		'RI' => 'Rhode Island',
		'SC' => 'South Carolina',
		'SD' => 'South Dakota',
		'TN' => 'Tennessee',
		'TX' => 'Texas',
		'UT' => 'Utah',
		'VT' => 'Vermont',
		'VA' => 'Virginia',
		'WA' => 'Washington',
		'WV' => 'West Virginia',
		'WI' => 'Wisconsin',
		'WY' => 'Wyoming',
		'AA' => 'Armed Forces (AA)',
		'AE' => 'Armed Forces (AE)',
		'AP' => 'Armed Forces (AP)',
	),
	'UY' => array( // Uruguayan states.
		'UY-AR' => 'Artigas',
		'UY-CA' => 'Canelones',
		'UY-CL' => 'Cerro Largo',
		'UY-CO' => 'Colonia',
		'UY-DU' => 'Durazno',
		'UY-FS' => 'Flores',
		'UY-FD' => 'Florida',
		'UY-LA' => 'Lavalleja',
		'UY-MA' => 'Maldonado',
		'UY-MO' => 'Montevideo',
		'UY-PA' => 'Paysandú',
		'UY-RN' => 'Río Negro',
		'UY-RV' => 'Rivera',
		'UY-RO' => 'Rocha',
		'UY-SA' => 'Salto',
		'UY-SJ' => 'San José',
		'UY-SO' => 'Soriano',
		'UY-TA' => 'Tacuarembó',
		'UY-TT' => 'Treinta y Tres',
	),
	'VE' => array( // Venezuelan states.
		'VE-A' => 'Capital',
		'VE-B' => 'Anzoátegui',
		'VE-C' => 'Apure',
		'VE-D' => 'Aragua',
		'VE-E' => 'Barinas',
		'VE-F' => 'Bolívar',
		'VE-G' => 'Carabobo',
		'VE-H' => 'Cojedes',
		'VE-I' => 'Falcón',
		'VE-J' => 'Guárico',
		'VE-K' => 'Lara',
		'VE-L' => 'Mérida',
		'VE-M' => 'Miranda',
		'VE-N' => 'Monagas',
		'VE-O' => 'Nueva Esparta',
		'VE-P' => 'Portuguesa',
		'VE-R' => 'Sucre',
		'VE-S' => 'Táchira',
		'VE-T' => 'Trujillo',
		'VE-U' => 'Yaracuy',
		'VE-V' => 'Zulia',
		'VE-W' => 'Federal Dependencies',
		'VE-X' => 'La Guaira (Vargas)',
		'VE-Y' => 'Delta Amacuro',
		'VE-Z' => 'Amazonas',
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => 'Eastern Cape',
		'FS'  => 'Free State',
		'GP'  => 'Gauteng',
		'KZN' => 'KwaZulu-Natal',
		'LP'  => 'Limpopo',
		'MP'  => 'Mpumalanga',
		'NC'  => 'Northern Cape',
		'NW'  => 'North West',
		'WC'  => 'Western Cape',
	),
	'ZM' => array( // Zambian provinces.
		'ZM-01' => 'Western',
		'ZM-02' => 'Central',
		'ZM-03' => 'Eastern',
		'ZM-04' => 'Luapula',
		'ZM-05' => 'Northern',
		'ZM-06' => 'North-Western',
		'ZM-07' => 'Southern',
		'ZM-08' => 'Copperbelt',
		'ZM-09' => 'Lusaka',
		'ZM-10' => 'Muchinga',
	),
);
