<?php
/**
 * File Downloads Order Tile
 *
 * @package     EDD\Reports\Endpoints\Tiles
 * @copyright   Copyright (c) 2025, Easy Digital Downloads, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.5.1
 */

namespace EDD\Reports\Endpoints\Tiles;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * File Downloads Order Tile class.
 *
 * Displays the average number of file downloads per order for the selected date range.
 *
 * @since 3.5.1
 */
class FileDownloadsOrder extends Tile {

	/**
	 * Gets the tile endpoint ID.
	 *
	 * @since 3.5.1
	 * @return string
	 */
	protected function get_id(): string {
		return 'average_file_downloads_per_order';
	}

	/**
	 * Gets the tile label for display.
	 *
	 * @since 3.5.1
	 * @return string
	 */
	protected function get_label(): string {
		return __( 'Average per Order', 'easy-digital-downloads' );
	}

	/**
	 * Gets the file downloads data.
	 *
	 * @since 3.5.1
	 * @return string
	 */
	protected function get_data(): string {
		$stats = $this->get_stats();

		return $stats->get_average_file_download_count(
			array(
				'column' => 'order_id',
			)
		);
	}
}
