Changelog
===================

#### 1.3.9 - Oct 16, 2024

- Address PHP warning introduced by version 1.3.8.


#### 1.3.8 - Oct 11, 2024

- Escape shortcode arguments before outputting to prevent stored XSS from users with `edit_post` capability. Thanks to [Peter Thaleikis](https://peterthaleikis.com/) for the responsible disclosure.


#### 1.3.7 - Oct 1, 2024

- Remove Google Plus as an option, since it has long been shut down.
- Add `defer` attribute to pop-up script tag.
- Improved sanitization of settings.
- Disallow the use of `<a>` elements in the `before_text` setting if user lacks `unfiltered_html` capability.
- Get rid of ES6 code in JavaScript files, to support older browsers.


#### 1.3.4 - Dec 23, 2022

- Rewrite admin JavaScript to no longer require jQuery.
- Minor PHP improvements.
- Improved minification of all CSS and JS assets.


#### 1.3.3 - Dec 31, 2019

- Remove unused LinkedIn parameters.
- Switch to WordPress.org managed translations.


#### 1.3.2 - March 23, 2018

- Minor code optimisations
- Added `linkedin_text` shortcode argument to FAQ.


#### 1.3.1 - October 26, 2017

Misc. textual improvements.


#### 1.3 - October 4, 2017

**Additions**

- Added LinkedIn.


#### 1.2.7 - January 6, 2017

**Improvements**

- Use `https://` protocol for sharing links.
- Use SVG icons.

**Additions**

- Add "large" icon size option.
- Choose social network options from settings page.
- Added Italian translations, thanks to Alessandro Guidi.


#### 1.2.6 - March 29, 2016

**Fixes**

- Apostrophes in titles not properly escaped in sharing URL's. Thanks Robin Aldenhoven!

#### 1.2.5 - January 26, 2015

**Improvements**

- Minor improvements to pop-up script

**Additions**

- Added Finnish (fi_FI) translations, thanks to [Ari-Pekka Koponen](http://versi.fi/)


#### 1.2.4 - November 17, 2014

**Improvements**

- Wrapped link text in element so it can be hidden using CSS
- Improvements to pop-up JavaScript

#### 1.2.3 - September 4, 2014

**Improvements**

- Added minified scripts and option to load minified version
- Some textual improvements

#### 1.2.2 - April 30, 2014

**Fixes**

- Fixed not being able to save all "auto add to .." checkboxes unchecked

#### 1.2.1 - April 29, 2014
**Additions**

- Added German translations, thanks Andreas Kuhl!

**Improvements**

- Wrapped non-translatable strings in translation calls.
- Updated Dutch translations

#### 1.2 - March 19, 2014
**Additions**

- Added option to automatically add sharing options to all registered post types
- Added Spanish translations, props to [Luciano A. Ferrer](http://cbasites.net/).

**Improvements**

- Disabled Pop-up JS by default until we figure out a cross-browser compatibility fix.

#### 1.1 - February 19, 2014
- Added: Slovenian translations, thanks to [Domen Hrabar, Viking Marketing](http://www.vikingmarketing.si/)
- Improved: direct file access security


#### 1.0.9 - December 30, 2013
- Added: Danish translation, thanks to [Finn Hoelgaard](http://fhn.dk/)!
- Added: Russian translation, thanks to Nikita!
- Improved: Pop-up script now waits for full page load.

#### 1.0.6 - December 20, 2013
- Improved: Pop-up JS now used addEventListener to enable multiple event listeners (like a Google Analytics plugin) attaching to the sharing links.

#### 1.0.5 - December 9, 2013
- Added: French translations, thanks to [Said](http://www.ninapeople.com/)
- Improved: All backend strings are now translatable
- Improved: Prevented direct access or search engine indexing of plugin files
- Improved: Facebook URL sharing parameters

#### 1.0.4 - December 2, 2013
- Improved: Minified pop-up script to 480 bytes.
- Improved: Removed image attribute from Facebook Share URL. FB will now pick up `og:image` meta tags.

#### 1.0.3 - November 25, 2013
- Fixed: undefined index notice when saving options.

#### 1.0.2 - November 20, 2013

- Added: Dutch translation
- Added: Option to change the text that shows before the sharing links.

#### 1.0.1 - November 20, 2013

- Fixed: Added settings link to plugins overview page
- Fixed: "tweet about" option in admin now tweets about the correct plugin.

#### 1.0 - November 17, 2013

- Initial release.
