<?php

$policy_demo_text = '
<h2>Datenschutzerklärung</h2>

<p>Stand: [dsgvo_save_date]</p>

<p>Wir freuen uns sehr über Ihr Interesse an unserem Unternehmen. Eine Nutzung der Internetseiten ist grundsätzlich ohne jede Angabe personenbezogener Daten möglich. Sofern eine betroffene Person besondere Services unseres Unternehmens über unsere Internetseite in Anspruch nehmen möchte, könnte jedoch eine Verarbeitung personenbezogener Daten erforderlich werden. Ist die Verarbeitung personenbezogener Daten erforderlich und besteht für eine solche Verarbeitung keine gesetzliche Grundlage, holen wir generell eine Einwilligung der betroffenen Person ein.</p>

<p>Die Verarbeitung personenbezogener Daten, beispielsweise des Namens, der Anschrift, E-Mail-Adresse oder Telefonnummer einer betroffenen Person, erfolgt stets im Einklang mit der Datenschutz-Grundverordnung und in Übereinstimmung mit den für uns geltenden landesspezifischen Datenschutzbestimmungen. Mittels dieser Datenschutzerklärung möchte unser Unternehmen die Öffentlichkeit über Art, Umfang und Zweck der von uns erhobenen, genutzten und verarbeiteten personenbezogenen Daten informieren. Ferner werden betroffene Personen mittels dieser Datenschutzerklärung über die ihnen zustehenden Rechte aufgeklärt.</p>

<p>Wir haben als für die Verarbeitung Verantwortlicher zahlreiche technische und organisatorische Maßnahmen umgesetzt, um einen möglichst lückenlosen Schutz der über diese Internetseite verarbeiteten personenbezogenen Daten sicherzustellen. Dennoch können Internetbasierte Datenübertragungen grundsätzlich Sicherheitslücken aufweisen, sodass ein absoluter Schutz nicht gewährleistet werden kann. Aus diesem Grund steht es jeder betroffenen Person frei, personenbezogene Daten auch auf alternativen Wegen, beispielsweise telefonisch, an uns zu übermitteln.</p>

<h4>Begriffsbestimmungen</h4>
<p>Die Datenschutzerklärung beruht auf den Begrifflichkeiten, die durch den Europäischen Richtlinien- und Verordnungsgeber beim Erlass der Datenschutz-Grundverordnung (DS-GVO) verwendet wurden. Unsere Datenschutzerklärung soll sowohl für die Öffentlichkeit als auch für unsere Kunden und Geschäftspartner einfach lesbar und verständlich sein. Um dies zu gewährleisten, möchten wir vorab die verwendeten Begrifflichkeiten erläutern.</p>

<p>Wir verwenden in dieser Datenschutzerklärung unter anderem die folgenden Begriffe:</p>

<ul>
<li><h4>a)    personenbezogene Daten</h4>
<p>Personenbezogene Daten sind alle Informationen, die sich auf eine identifizierte oder identifizierbare natürliche Person (im Folgenden „betroffene Person") beziehen. Als identifizierbar wird eine natürliche Person angesehen, die direkt oder indirekt, insbesondere mittels Zuordnung zu einer Kennung wie einem Namen, zu einer Kennnummer, zu Standortdaten, zu einer Online-Kennung oder zu einem oder mehreren besonderen Merkmalen, die Ausdruck der physischen, physiologischen, genetischen, psychischen, wirtschaftlichen, kulturellen oder sozialen Identität dieser natürlichen Person sind, identifiziert werden kann.</p>
</li>
<li><h4>b)    betroffene Person</h4>
<p>Betroffene Person ist jede identifizierte oder identifizierbare natürliche Person, deren personenbezogene Daten von dem für die Verarbeitung Verantwortlichen verarbeitet werden.</p>
</li>
<li><h4>c)    Verarbeitung</h4>
<p>Verarbeitung ist jeder mit oder ohne Hilfe automatisierter Verfahren ausgeführte Vorgang oder jede solche Vorgangsreihe im Zusammenhang mit personenbezogenen Daten wie das Erheben, das Erfassen, die Organisation, das Ordnen, die Speicherung, die Anpassung oder Veränderung, das Auslesen, das Abfragen, die Verwendung, die Offenlegung durch Übermittlung, Verbreitung oder eine andere Form der Bereitstellung, den Abgleich oder die Verknüpfung, die Einschränkung, das Löschen oder die Vernichtung.</p>
</li>
<li><h4>d)    Einschränkung der Verarbeitung</h4>
<p>Einschränkung der Verarbeitung ist die Markierung gespeicherter personenbezogener Daten mit dem Ziel, ihre künftige Verarbeitung einzuschränken.</p>
</li>
<li><h4>e)    Profiling</h4>
<p>Profiling ist jede Art der automatisierten Verarbeitung personenbezogener Daten, die darin besteht, dass diese personenbezogenen Daten verwendet werden, um bestimmte persönliche Aspekte, die sich auf eine natürliche Person beziehen, zu bewerten, insbesondere, um Aspekte bezüglich Arbeitsleistung, wirtschaftlicher Lage, Gesundheit, persönlicher Vorlieben, Interessen, Zuverlässigkeit, Verhalten, Aufenthaltsort oder Ortswechsel dieser natürlichen Person zu analysieren oder vorherzusagen.</p>
</li>
<li><h4>f)     Pseudonymisierung</h4>
<p>Pseudonymisierung ist die Verarbeitung personenbezogener Daten in einer Weise, auf welche die personenbezogenen Daten ohne Hinzuziehung zusätzlicher Informationen nicht mehr einer spezifischen betroffenen Person zugeordnet werden können, sofern diese zusätzlichen Informationen gesondert aufbewahrt werden und technischen und organisatorischen Maßnahmen unterliegen, die gewährleisten, dass die personenbezogenen Daten nicht einer identifizierten oder identifizierbaren natürlichen Person zugewiesen werden.</p>
</li>
<li><h4>g)    Verantwortlicher oder für die Verarbeitung Verantwortlicher</h4>
<p>Verantwortlicher oder für die Verarbeitung Verantwortlicher ist die natürliche oder juristische Person, Behörde, Einrichtung oder andere Stelle, die allein oder gemeinsam mit anderen über die Zwecke und Mittel der Verarbeitung von personenbezogenen Daten entscheidet. Sind die Zwecke und Mittel dieser Verarbeitung durch das Unionsrecht oder das Recht der Mitgliedstaaten vorgegeben, so kann der Verantwortliche beziehungsweise können die bestimmten Kriterien seiner Benennung nach dem Unionsrecht oder dem Recht der Mitgliedstaaten vorgesehen werden.</p>
</li>
<li><h4>h)    Auftragsverarbeiter</h4>
<p>Auftragsverarbeiter ist eine natürliche oder juristische Person, Behörde, Einrichtung oder andere Stelle, die personenbezogene Daten im Auftrag des Verantwortlichen verarbeitet.</p>
</li>
<li><h4>i)      Empfänger</h4>
<p>Empfänger ist eine natürliche oder juristische Person, Behörde, Einrichtung oder andere Stelle, der personenbezogene Daten offengelegt werden, unabhängig davon, ob es sich bei ihr um einen Dritten handelt oder nicht. Behörden, die im Rahmen eines bestimmten Untersuchungsauftrags nach dem Unionsrecht oder dem Recht der Mitgliedstaaten möglicherweise personenbezogene Daten erhalten, gelten jedoch nicht als Empfänger.</p>
</li>
<li><h4>j)      Dritter</h4>
<p>Dritter ist eine natürliche oder juristische Person, Behörde, Einrichtung oder andere Stelle außer der betroffenen Person, dem Verantwortlichen, dem Auftragsverarbeiter und den Personen, die unter der unmittelbaren Verantwortung des Verantwortlichen oder des Auftragsverarbeiters befugt sind, die personenbezogenen Daten zu verarbeiten.</p>
</li>
<li><h4>k)    Einwilligung</h4>
<p>Einwilligung ist jede von der betroffenen Person freiwillig für den bestimmten Fall in informierter Weise und unmissverständlich abgegebene Willensbekundung in Form einer Erklärung oder einer sonstigen eindeutigen bestätigenden Handlung, mit der die betroffene Person zu verstehen gibt, dass sie mit der Verarbeitung der sie betreffenden personenbezogenen Daten einverstanden ist.</p>
</li>
</ul>

<h4>Name und Anschrift des für die Verarbeitung Verantwortlichen</h4>
<p>Verantwortlicher im Sinne der Datenschutz-Grundverordnung, sonstiger in den Mitgliedstaaten der Europäischen Union geltenden Datenschutzgesetze und anderer Bestimmungen mit datenschutzrechtlichem Charakter ist die:</p>

<p>[company]</p>
<p>[owner]</p>
<p>[adress]</p>
<p>[zip] [city]</p>
<p>[country]</p>
<p>[phone]</p>
<p>[mail]</p>
<p>[ust]</p>

<h4>Cookies / SessionStorage / LocalStorage</h4>
<p>Die Internetseiten verwenden teilweise so genannte Cookies, LocalStorage und SessionStorage. Dies dient dazu, unser Angebot nutzerfreundlicher, effektiver und sicherer zu machen. Local Storage und SessionStorage ist eine Technologie, mit welcher ihr Browser Daten auf Ihrem Computer oder mobilen Gerät abspeichert. Cookies sind Textdateien, welche über einen Internetbrowser auf einem Computersystem abgelegt und gespeichert werden. Sie können die Verwendung von Cookies, LocalStorage und SessionStorage durch entsprechende Einstellung in Ihrem Browser verhindern.</p>

<p>Zahlreiche Internetseiten und Server verwenden Cookies. Viele Cookies enthalten eine sogenannte Cookie-ID. Eine Cookie-ID ist eine eindeutige Kennung des Cookies. Sie besteht aus einer Zeichenfolge, durch welche Internetseiten und Server dem konkreten Internetbrowser zugeordnet werden können, in dem das Cookie gespeichert wurde. Dies ermöglicht es den besuchten Internetseiten und Servern, den individuellen Browser der betroffenen Person von anderen Internetbrowsern, die andere Cookies enthalten, zu unterscheiden. Ein bestimmter Internetbrowser kann über die eindeutige Cookie-ID wiedererkannt und identifiziert werden.</p>

<p>Durch den Einsatz von Cookies kann den Nutzern dieser Internetseite nutzerfreundlichere Services bereitstellen, die ohne die Cookie-Setzung nicht möglich wären.</p>

<p>Mittels eines Cookies können die Informationen und Angebote auf unserer Internetseite im Sinne des Benutzers optimiert werden. Cookies ermöglichen uns, wie bereits erwähnt, die Benutzer unserer Internetseite wiederzuerkennen. Zweck dieser Wiedererkennung ist es, den Nutzern die Verwendung unserer Internetseite zu erleichtern. Der Benutzer einer Internetseite, die Cookies verwendet, muss beispielsweise nicht bei jedem Besuch der Internetseite erneut seine Zugangsdaten eingeben, weil dies von der Internetseite und dem auf dem Computersystem des Benutzers abgelegten Cookie übernommen wird. Ein weiteres Beispiel ist das Cookie eines Warenkorbes im Online-Shop. Der Online-Shop merkt sich die Artikel, die ein Kunde in den virtuellen Warenkorb gelegt hat, über ein Cookie.</p>

<p>Die betroffene Person kann die Setzung von Cookies durch unsere Internetseite jederzeit mittels einer entsprechenden Einstellung des genutzten Internetbrowsers verhindern und damit der Setzung von Cookies dauerhaft widersprechen. Ferner können bereits gesetzte Cookies jederzeit über einen Internetbrowser oder andere Softwareprogramme gelöscht werden. Dies ist in allen gängigen Internetbrowsern möglich. Deaktiviert die betroffene Person die Setzung von Cookies in dem genutzten Internetbrowser, sind unter Umständen nicht alle Funktionen unserer Internetseite vollumfänglich nutzbar.</p>

<h4>Erfassung von allgemeinen Daten und Informationen</h4>
<p>Die Internetseite erfasst mit jedem Aufruf der Internetseite durch eine betroffene Person oder ein automatisiertes System eine Reihe von allgemeinen Daten und Informationen. Diese allgemeinen Daten und Informationen werden in den Logfiles des Servers gespeichert. Erfasst werden können die (1) verwendeten Browsertypen und Versionen, (2) das vom zugreifenden System verwendete Betriebssystem, (3) die Internetseite, von welcher ein zugreifendes System auf unsere Internetseite gelangt (sogenannte Referrer), (4) die Unterwebseiten, welche über ein zugreifendes System auf unserer Internetseite angesteuert werden, (5) das Datum und die Uhrzeit eines Zugriffs auf die Internetseite, (6) eine Internet-Protokoll-Adresse (IP-Adresse), (7) der Internet-Service-Provider des zugreifenden Systems und (8) sonstige ähnliche Daten und Informationen, die der Gefahrenabwehr im Falle von Angriffen auf unsere informationstechnologischen Systeme dienen.</p>

<p>Bei der Nutzung dieser allgemeinen Daten und Informationen ziehen wird keine Rückschlüsse auf die betroffene Person. Diese Informationen werden vielmehr benötigt, um (1) die Inhalte unserer Internetseite korrekt auszuliefern, (2) die Inhalte unserer Internetseite sowie die Werbung für diese zu optimieren, (3) die dauerhafte Funktionsfähigkeit unserer informationstechnologischen Systeme und der Technik unserer Internetseite zu gewährleisten sowie (4) um Strafverfolgungsbehörden im Falle eines Cyberangriffes die zur Strafverfolgung notwendigen Informationen bereitzustellen. Diese anonym erhobenen Daten und Informationen werden durch uns daher einerseits statistisch und ferner mit dem Ziel ausgewertet, den Datenschutz und die Datensicherheit in unserem Unternehmen zu erhöhen, um letztlich ein optimales Schutzniveau für die von uns verarbeiteten personenbezogenen Daten sicherzustellen. Die anonymen Daten der Server-Logfiles werden getrennt von allen durch eine betroffene Person angegebenen personenbezogenen Daten gespeichert.</p>

<h4>Registrierung auf unserer Internetseite</h4>
<p>Die betroffene Person hat die Möglichkeit, sich auf der Internetseite des für die Verarbeitung Verantwortlichen unter Angabe von personenbezogenen Daten zu registrieren. Welche personenbezogenen Daten dabei an den für die Verarbeitung Verantwortlichen übermittelt werden, ergibt sich aus der jeweiligen Eingabemaske, die für die Registrierung verwendet wird. Die von der betroffenen Person eingegebenen personenbezogenen Daten werden ausschließlich für die interne Verwendung bei dem für die Verarbeitung Verantwortlichen und für eigene Zwecke erhoben und gespeichert. Der für die Verarbeitung Verantwortliche kann die Weitergabe an einen oder mehrere Auftragsverarbeiter, beispielsweise einen Paketdienstleister, veranlassen, der die personenbezogenen Daten ebenfalls ausschließlich für eine interne Verwendung, die dem für die Verarbeitung Verantwortlichen zuzurechnen ist, nutzt.</p>

<p>Durch eine Registrierung auf der Internetseite des für die Verarbeitung Verantwortlichen wird ferner die vom Internet-Service-Provider (ISP) der betroffenen Person vergebene IP-Adresse, das Datum sowie die Uhrzeit der Registrierung gespeichert. Die Speicherung dieser Daten erfolgt vor dem Hintergrund, dass nur so der Missbrauch unserer Dienste verhindert werden kann, und diese Daten im Bedarfsfall ermöglichen, begangene Straftaten aufzuklären. Insofern ist die Speicherung dieser Daten zur Absicherung des für die Verarbeitung Verantwortlichen erforderlich. Eine Weitergabe dieser Daten an Dritte erfolgt grundsätzlich nicht, sofern keine gesetzliche Pflicht zur Weitergabe besteht oder die Weitergabe der Strafverfolgung dient.</p>

<p>Die Registrierung der betroffenen Person unter freiwilliger Angabe personenbezogener Daten dient dem für die Verarbeitung Verantwortlichen dazu, der betroffenen Person Inhalte oder Leistungen anzubieten, die aufgrund der Natur der Sache nur registrierten Benutzern angeboten werden können. Registrierten Personen steht die Möglichkeit frei, die bei der Registrierung angegebenen personenbezogenen Daten jederzeit abzuändern oder vollständig aus dem Datenbestand des für die Verarbeitung Verantwortlichen löschen zu lassen.</p>

<p>Der für die Verarbeitung Verantwortliche erteilt jeder betroffenen Person jederzeit auf Anfrage Auskunft darüber, welche personenbezogenen Daten über die betroffene Person gespeichert sind. Ferner berichtigt oder löscht der für die Verarbeitung Verantwortliche personenbezogene Daten auf Wunsch oder Hinweis der betroffenen Person, soweit dem keine gesetzlichen Aufbewahrungspflichten entgegenstehen. Die Gesamtheit der Mitarbeiter des für die Verarbeitung Verantwortlichen stehen der betroffenen Person in diesem Zusammenhang als Ansprechpartner zur Verfügung.</p>

<h4>Kontaktmöglichkeit über die Internetseite</h4>
<p>Die Internetseite enthält aufgrund von gesetzlichen Vorschriften Angaben, die eine schnelle elektronische Kontaktaufnahme zu unserem Unternehmen sowie eine unmittelbare Kommunikation mit uns ermöglichen, was ebenfalls eine allgemeine Adresse der sogenannten elektronischen Post (E-Mail-Adresse) umfasst. Sofern eine betroffene Person per E-Mail oder über ein Kontaktformular den Kontakt mit dem für die Verarbeitung Verantwortlichen aufnimmt, werden die von der betroffenen Person übermittelten personenbezogenen Daten automatisch gespeichert. Solche auf freiwilliger Basis von einer betroffenen Person an den für die Verarbeitung Verantwortlichen übermittelten personenbezogenen Daten werden für Zwecke der Bearbeitung oder der Kontaktaufnahme zur betroffenen Person gespeichert. Es erfolgt keine Weitergabe dieser personenbezogenen Daten an Dritte.</p>

<h4>Kommentarfunktion im Blog auf der Internetseite</h4>
<p>Wir bieten den Nutzern auf einem Blog, der sich auf der Internetseite des für die Verarbeitung Verantwortlichen befindet, die Möglichkeit, individuelle Kommentare zu einzelnen Blog-Beiträgen zu hinterlassen. Ein Blog ist ein auf einer Internetseite geführtes, in der Regel öffentlich einsehbares Portal, in welchem eine oder mehrere Personen, die Blogger oder Web-Blogger genannt werden, Artikel posten oder Gedanken in sogenannten Blogposts niederschreiben können. Die Blogposts können in der Regel von Dritten kommentiert werden.</p>
<p>Hinterlässt eine betroffene Person einen Kommentar in dem auf dieser Internetseite veröffentlichten Blog, werden neben den von der betroffenen Person hinterlassenen Kommentaren auch Angaben zum Zeitpunkt der Kommentareingabe sowie zu dem von der betroffenen Person gewählten Nutzernamen (Pseudonym) gespeichert und veröffentlicht. Ferner wird die vom Internet-Service-Provider (ISP) der betroffenen Person vergebene IP-Adresse mitprotokolliert. Diese Speicherung der IP-Adresse erfolgt aus Sicherheitsgründen und für den Fall, dass die betroffene Person durch einen abgegebenen Kommentar die Rechte Dritter verletzt oder rechtswidrige Inhalte postet. Die Speicherung dieser personenbezogenen Daten erfolgt daher im eigenen Interesse des für die Verarbeitung Verantwortlichen, damit sich dieser im Falle einer Rechtsverletzung gegebenenfalls exkulpieren könnte. Es erfolgt keine Weitergabe dieser erhobenen personenbezogenen Daten an Dritte, sofern eine solche Weitergabe nicht gesetzlich vorgeschrieben ist oder der Rechtsverteidigung des für die Verarbeitung Verantwortlichen dient.</p>

<h4>Gravatar</h4>
<p>Bei Kommentaren wird auf den Gravatar Service von Auttomatic zurückgegriffen. Gravatar gleicht Ihre Email-Adresse ab und bildet – sofern Sie dort registriert sind – Ihr Avatar-Bild neben dem Kommentar ab. Sollten Sie nicht registriert sein, wird kein Bild angezeigt. Zu beachten ist, dass alle registrierten WordPress-User automatisch auch bei Gravatar registriert sind. Details zu Gravatar: <a href="https://de.gravatar.com" target="blank">https://de.gravatar.com</a></p>

<h4>Routinemäßige Löschung und Sperrung von personenbezogenen Daten</h4>
<p>Der für die Verarbeitung Verantwortliche verarbeitet und speichert personenbezogene Daten der betroffenen Person nur für den Zeitraum, der zur Erreichung des Speicherungszwecks erforderlich ist oder sofern dies durch den Europäischen Richtlinien- und Verordnungsgeber oder einen anderen Gesetzgeber in Gesetzen oder Vorschriften, welchen der für die Verarbeitung Verantwortliche unterliegt, vorgesehen wurde.</p>

<p>Entfällt der Speicherungszweck oder läuft eine vom Europäischen Richtlinien- und Verordnungsgeber oder einem anderen zuständigen Gesetzgeber vorgeschriebene Speicherfrist ab, werden die personenbezogenen Daten routinemäßig und entsprechend den gesetzlichen Vorschriften gesperrt oder gelöscht.</p>

<h4>Rechte der betroffenen Person</h4>
<ul>
<li><h4>a)    Recht auf Bestätigung</h4>
<p>Jede betroffene Person hat das vom Europäischen Richtlinien- und Verordnungsgeber eingeräumte Recht, von dem für die Verarbeitung Verantwortlichen eine Bestätigung darüber zu verlangen, ob sie betreffende personenbezogene Daten verarbeitet werden. Möchte eine betroffene Person dieses Bestätigungsrecht in Anspruch nehmen, kann sie sich hierzu jederzeit an einen Mitarbeiter des für die Verarbeitung Verantwortlichen wenden.</p>
</li>
<li><h4>b)    Recht auf Auskunft</h4>
<p>Jede von der Verarbeitung personenbezogener Daten betroffene Person hat das vom Europäischen Richtlinien- und Verordnungsgeber gewährte Recht, jederzeit von dem für die Verarbeitung Verantwortlichen unentgeltliche Auskunft über die zu seiner Person gespeicherten personenbezogenen Daten und eine Kopie dieser Auskunft zu erhalten. Ferner hat der Europäische Richtlinien- und Verordnungsgeber der betroffenen Person Auskunft über folgende Informationen zugestanden:</p>

<ul>
<li>die Verarbeitungszwecke</li>
<li>die Kategorien personenbezogener Daten, die verarbeitet werden</li>
<li>die Empfänger oder Kategorien von Empfängern, gegenüber denen die personenbezogenen Daten offengelegt worden sind oder noch offengelegt werden, insbesondere bei Empfängern in Drittländern oder bei internationalen Organisationen</li>
<li>falls möglich die geplante Dauer, für die die personenbezogenen Daten gespeichert werden, oder, falls dies nicht möglich ist, die Kriterien für die Festlegung dieser Dauer</li>
<li>das Bestehen eines Rechts auf Berichtigung oder Löschung der sie betreffenden personenbezogenen Daten oder auf Einschränkung der Verarbeitung durch den Verantwortlichen oder eines Widerspruchsrechts gegen diese Verarbeitung</li>
<li>das Bestehen eines Beschwerderechts bei einer Aufsichtsbehörde</li>
<li>wenn die personenbezogenen Daten nicht bei der betroffenen Person erhoben werden: Alle verfügbaren Informationen über die Herkunft der Daten</li>
<li>das Bestehen einer automatisierten Entscheidungsfindung einschließlich Profiling gemäß Artikel 22 Abs.1 und 4 DS-GVO und — zumindest in diesen Fällen — aussagekräftige Informationen über die involvierte Logik sowie die Tragweite und die angestrebten Auswirkungen einer derartigen Verarbeitung für die betroffene Person</li>

</ul>
<p>Ferner steht der betroffenen Person ein Auskunftsrecht darüber zu, ob personenbezogene Daten an ein Drittland oder an eine internationale Organisation übermittelt wurden. Sofern dies der Fall ist, so steht der betroffenen Person im Übrigen das Recht zu, Auskunft über die geeigneten Garantien im Zusammenhang mit der Übermittlung zu erhalten.</p>

<p>Möchte eine betroffene Person dieses Auskunftsrecht in Anspruch nehmen, kann sie sich hierzu jederzeit an einen Mitarbeiter des für die Verarbeitung Verantwortlichen wenden.</p>
</li>
<li><h4>c)    Recht auf Berichtigung</h4>
<p>Jede von der Verarbeitung personenbezogener Daten betroffene Person hat das vom Europäischen Richtlinien- und Verordnungsgeber gewährte Recht, die unverzügliche Berichtigung sie betreffender unrichtiger personenbezogener Daten zu verlangen. Ferner steht der betroffenen Person das Recht zu, unter Berücksichtigung der Zwecke der Verarbeitung, die Vervollständigung unvollständiger personenbezogener Daten — auch mittels einer ergänzenden Erklärung — zu verlangen.</p>

<p>Möchte eine betroffene Person dieses Berichtigungsrecht in Anspruch nehmen, kann sie sich hierzu jederzeit an einen Mitarbeiter des für die Verarbeitung Verantwortlichen wenden.</p></li>
<li>
<h4>d)    Recht auf Löschung (Recht auf Vergessen werden)</h4>
<p>Jede von der Verarbeitung personenbezogener Daten betroffene Person hat das vom Europäischen Richtlinien- und Verordnungsgeber gewährte Recht, von dem Verantwortlichen zu verlangen, dass die sie betreffenden personenbezogenen Daten unverzüglich gelöscht werden, sofern einer der folgenden Gründe zutrifft und soweit die Verarbeitung nicht erforderlich ist:</p>

<ul>
<li>Die personenbezogenen Daten wurden für solche Zwecke erhoben oder auf sonstige Weise verarbeitet, für welche sie nicht mehr notwendig sind.</li>
<li>Die betroffene Person widerruft ihre Einwilligung, auf die sich die Verarbeitung gemäß Art. 6 Abs. 1 Buchstabe a DS-GVO oder Art. 9 Abs. 2 Buchstabe a DS-GVO stützte, und es fehlt an einer anderweitigen Rechtsgrundlage für die Verarbeitung.</li>
<li>Die betroffene Person legt gemäß Art. 21 Abs. 1 DS-GVO Widerspruch gegen die Verarbeitung ein, und esliegen keine vorrangigen berechtigten Gründe für die Verarbeitung vor, oder die betroffene Person legt gemäß Art. 21 Abs. 2 DS-GVO Widerspruch gegen die Verarbeitung ein.</li>
<li>Die personenbezogenen Daten wurden unrechtmäßig verarbeitet.</li>
<li>Die Löschung der personenbezogenen Daten ist zur Erfüllung einer rechtlichen Verpflichtung nach dem Unionsrecht oder dem Recht der Mitgliedstaaten erforderlich, dem der Verantwortliche unterliegt.</li>
<li>Die personenbezogenen Daten wurden in Bezug auf angebotene Dienste der Informationsgesellschaft gemäß Art. 8 Abs. 1 DS-GVO erhoben.</li>

</ul>
<p>Sofern einer der oben genannten Gründe zutrifft und eine betroffene Person die Löschung von personenbezogenen Daten, die gespeichert sind, veranlassen möchte, kann sie sich hierzu jederzeit an einen Mitarbeiter des für die Verarbeitung Verantwortlichen wenden. Der Mitarbeiter wird veranlassen, dass dem Löschverlangen unverzüglich nachgekommen wird.</p>

<p>Wurden die personenbezogenen Daten öffentlich gemacht und ist unser Unternehmen als Verantwortlicher gemäß Art. 17 Abs. 1 DS-GVO zur Löschung der personenbezogenen Daten verpflichtet, so trifft uns unter Berücksichtigung der verfügbaren Technologie und der Implementierungskosten angemessene Maßnahmen, auch technischer Art, um andere für die Datenverarbeitung Verantwortliche, welche die veröffentlichten personenbezogenen Daten verarbeiten, darüber in Kenntnis zu setzen, dass die betroffene Person von diesen anderen für die Datenverarbeitung Verantwortlichen die Löschung sämtlicherlinks zu diesen personenbezogenen Daten oder von Kopien oder Replikationen dieser personenbezogenen Daten verlangt hat, soweit die Verarbeitung nicht erforderlich ist. Der Mitarbeiter wird im Einzelfall das Notwendige veranlassen.</p>
</li>
<li><h4>e)    Recht auf Einschränkung der Verarbeitung</h4>
<p>Jede von der Verarbeitung personenbezogener Daten betroffene Person hat das vom Europäischen Richtlinien- und Verordnungsgeber gewährte Recht, von dem Verantwortlichen die Einschränkung der Verarbeitung zu verlangen, wenn eine der folgenden Voraussetzungen gegeben ist:</p>

<ul>
<li>Die Richtigkeit der personenbezogenen Daten wird von der betroffenen Person bestritten, und zwar für eine Dauer, die es dem Verantwortlichen ermöglicht, die Richtigkeit der personenbezogenen Daten zu überprüfen.</li>
<li>Die Verarbeitung ist unrechtmäßig, die betroffene Person lehnt die Löschung der personenbezogenen Daten ab und verlangt stattdessen die Einschränkung der Nutzung der personenbezogenen Daten.</li>
<li>Der Verantwortliche benötigt die personenbezogenen Daten für die Zwecke der Verarbeitung nicht länger, die betroffene Person benötigt sie jedoch zur Geltendmachung, Ausübung oder Verteidigung von Rechtsansprüchen.</li>
<li>Die betroffene Person hat Widerspruch gegen die Verarbeitung gem. Art. 21 Abs. 1 DS-GVO eingelegt und es steht noch nicht fest, ob die berechtigten Gründe des Verantwortlichen gegenüber denen der betroffenen Person überwiegen.</li>

</ul>
<p>Sofern eine der oben genannten Voraussetzungen gegeben ist und eine betroffene Person die Einschränkung von personenbezogenen Daten, die gespeichert sind, verlangen möchte, kann sie sich hierzu jederzeit an einen Mitarbeiter des für die Verarbeitung Verantwortlichen wenden. Der Mitarbeiter wird die Einschränkung der Verarbeitung veranlassen.</p>
</li>
<li><h4>f)     Recht auf Datenübertragbarkeit</h4>
<p>Jede von der Verarbeitung personenbezogener Daten betroffene Person hat das vom Europäischen Richtlinien- und Verordnungsgeber gewährte Recht, die sie betreffenden personenbezogenen Daten, welche durch die betroffene Person einem Verantwortlichen bereitgestellt wurden, in einem strukturierten, gängigen und maschinenlesbaren Format zu erhalten. Sie hat außerdem das Recht, diese Daten einem anderen Verantwortlichen ohne Behinderung durch den Verantwortlichen, dem die personenbezogenen Daten bereitgestellt wurden, zu übermitteln, sofern die Verarbeitung auf der Einwilligung gemäß Art. 6 Abs. 1 Buchstabe a DS-GVO oder Art. 9 Abs. 2 Buchstabe a DS-GVO oder auf einem Vertrag gemäß Art. 6 Abs. 1 Buchstabe b DS-GVO beruht und die Verarbeitung mithilfe automatisierter Verfahren erfolgt, sofern die Verarbeitung nicht für die Wahrnehmung einer Aufgabe erforderlich ist, die im öffentlichen Interesseliegt oder in Ausübung öffentlicher Gewalt erfolgt, welche dem Verantwortlichen übertragen wurde.</p>

<p>Ferner hat die betroffene Person bei der Ausübung ihres Rechts auf Datenübertragbarkeit gemäß Art. 20 Abs. 1 DS-GVO das Recht, zu erwirken, dass die personenbezogenen Daten direkt von einem Verantwortlichen an einen anderen Verantwortlichen übermittelt werden, soweit dies technisch machbar ist und sofern hiervon nicht die Rechte und Freiheiten anderer Personen beeinträchtigt werden.</p>

<p>Zur Geltendmachung des Rechts auf Datenübertragbarkeit kann sich die betroffene Person jederzeit an uns wenden.</p>

</li>
<li>
<h4>g)    Recht auf Widerspruch</h4>
<p>Jede von der Verarbeitung personenbezogener Daten betroffene Person hat das vom Europäischen Richtlinien- und Verordnungsgeber gewährte Recht, aus Gründen, die sich aus ihrer besonderen Situation ergeben, jederzeit gegen die Verarbeitung sie betreffender personenbezogener Daten, die aufgrund von Art. 6 Abs. 1 Buchstaben e oder f DS-GVO erfolgt, Widerspruch einzulegen. Dies gilt auch für ein auf diese Bestimmungen gestütztes Profiling.</p>

<p>Wir verarbeiten die personenbezogenen Daten im Falle des Widerspruchs nicht mehr, es sei denn, wir können zwingende schutzwürdige Gründe für die Verarbeitung nachweisen, die den Interessen, Rechten und Freiheiten der betroffenen Person überwiegen, oder die Verarbeitung dient der Geltendmachung, Ausübung oder Verteidigung von Rechtsansprüchen.</p>

<p>Verarbeiten wir personenbezogene Daten, um Direktwerbung zu betreiben, so hat die betroffene Person das Recht, jederzeit Widerspruch gegen die Verarbeitung der personenbezogenen Daten zum Zwecke derartiger Werbung einzulegen. Dies gilt auch für das Profiling, soweit es mit solcher Direktwerbung in Verbindung steht. Widerspricht die betroffene Person gegenüber der Verarbeitung für Zwecke der Direktwerbung, so werden wir die personenbezogenen Daten nicht mehr für diese Zwecke verarbeiten.</p>

<p>Zudem hat die betroffene Person das Recht, aus Gründen, die sich aus ihrer besonderen Situation ergeben, gegen die sie betreffende Verarbeitung personenbezogener Daten, die zu wissenschaftlichen oder historischen Forschungszwecken oder zu statistischen Zwecken gemäß Art. 89 Abs. 1 DS-GVO erfolgen, Widerspruch einzulegen, es sei denn, eine solche Verarbeitung ist zur Erfüllung einer im öffentlichen Interesseliegenden Aufgabe erforderlich.</p>

<p>Zur Ausübung des Rechts auf Widerspruch kann sich die betroffene Person direkt an jeden Mitarbeiter wenden. Der betroffenen Person steht es ferner frei, im Zusammenhang mit der Nutzung von Diensten der Informationsgesellschaft, ungeachtet der Richtlinie 2002/58/EG, ihr Widerspruchsrecht mittels automatisierter Verfahren auszuüben, bei denen technische Spezifikationen verwendet werden.</p>
</li>
<li><h4>h)    Automatisierte Entscheidungen im Einzelfall einschließlich Profiling</h4>
<p>Jede von der Verarbeitung personenbezogener Daten betroffene Person hat das vom Europäischen Richtlinien- und Verordnungsgeber gewährte Recht, nicht einer ausschließlich auf einer automatisierten Verarbeitung — einschließlich Profiling — beruhenden Entscheidung unterworfen zu werden, die ihr gegenüber rechtliche Wirkung entfaltet oder sie in ähnlicher Weise erheblich beeinträchtigt, sofern die Entscheidung (1) nicht für den Abschluss oder die Erfüllung eines Vertrags zwischen der betroffenen Person und dem Verantwortlichen erforderlich ist, oder (2) aufgrund von Rechtsvorschriften der Union oder der Mitgliedstaaten, denen der Verantwortliche unterliegt, zulässig ist und diese Rechtsvorschriften angemessene Maßnahmen zur Wahrung der Rechte und Freiheiten sowie der berechtigten Interessen der betroffenen Person enthalten oder (3) mit ausdrücklicher Einwilligung der betroffenen Person erfolgt.</p>

<p>Ist die Entscheidung (1) für den Abschluss oder die Erfüllung eines Vertrags zwischen der betroffenen Person und dem Verantwortlichen erforderlich oder (2) erfolgt sie mit ausdrücklicher Einwilligung der betroffenen Person, triffen wir die angemessene Maßnahmen, um die Rechte und Freiheiten sowie die berechtigten Interessen der betroffenen Person zu wahren, wozu mindestens das Recht auf Erwirkung des Eingreifens einer Person seitens des Verantwortlichen, auf Darlegung des eigenen Standpunkts und auf Anfechtung der Entscheidung gehört.</p>

<p>Möchte die betroffene Person Rechte mit Bezug auf automatisierte Entscheidungen geltend machen, kann sie sich hierzu jederzeit an einen Mitarbeiter des für die Verarbeitung Verantwortlichen wenden.</p>

</li>
<li><h4>i)      Recht auf Widerruf einer datenschutzrechtlichen Einwilligung</h4>
<p>Jede von der Verarbeitung personenbezogener Daten betroffene Person hat das vom Europäischen Richtlinien- und Verordnungsgeber gewährte Recht, eine Einwilligung zur Verarbeitung personenbezogener Daten jederzeit zu widerrufen.</p>

<p>Möchte die betroffene Person ihr Recht auf Widerruf einer Einwilligung geltend machen, kann sie sich hierzu jederzeit an einen Mitarbeiter des für die Verarbeitung Verantwortlichen wenden.</p>

</li>
</ul>
<h4>Rechtsgrundlage der Verarbeitung</h4>
<p>Art. 6 Ilit. a DS-GVO dient unserem Unternehmen als Rechtsgrundlage für Verarbeitungsvorgänge, bei denen wir eine Einwilligung für einen bestimmten Verarbeitungszweck einholen. Ist die Verarbeitung personenbezogener Daten zur Erfüllung eines Vertrags, dessen Vertragspartei die betroffene Person ist, erforderlich, wie dies beispielsweise bei Verarbeitungsvorgängen der Fall ist, die für einelieferung von Waren oder die Erbringung einer sonstigen Leistung oder Gegenleistung notwendig sind, so beruht die Verarbeitung auf Art. 6 Ilit. b DS-GVO. Gleiches gilt für solche Verarbeitungsvorgänge die zur Durchführung vorvertraglicher Maßnahmen erforderlich sind, etwa in Fällen von Anfragen zur unseren Produkten oder Leistungen. Unterliegt unser Unternehmen einer rechtlichen Verpflichtung durch welche eine Verarbeitung von personenbezogenen Daten erforderlich wird, wie beispielsweise zur Erfüllung steuerlicher Pflichten, so basiert die Verarbeitung auf Art. 6 Ilit. c DS-GVO. In seltenen Fällen könnte die Verarbeitung von personenbezogenen Daten erforderlich werden, um lebenswichtige Interessen der betroffenen Person oder einer anderen natürlichen Person zu schützen. Dies wäre beispielsweise der Fall, wenn ein Besucher in unserem Betrieb verletzt werden würde und daraufhin sein Name, sein Alter, seine Krankenkassendaten oder sonstige lebenswichtige Informationen an einen Arzt, ein Krankenhaus oder sonstige Dritte weitergegeben werden müssten. Dann würde die Verarbeitung auf Art. 6 Ilit. d DS-GVO beruhen.
Letztlich könnten Verarbeitungsvorgänge auf Art. 6 Ilit. f DS-GVO beruhen. Auf dieser Rechtsgrundlage basieren Verarbeitungsvorgänge, die von keiner der vorgenannten Rechtsgrundlagen erfasst werden, wenn die Verarbeitung zur Wahrung eines berechtigten Interesses unseres Unternehmens oder eines Dritten erforderlich ist, sofern die Interessen, Grundrechte und Grundfreiheiten des Betroffenen nicht überwiegen. Solche Verarbeitungsvorgänge sind uns insbesondere deshalb gestattet, weil sie durch den Europäischen Gesetzgeber besonders erwähnt wurden. Er vertrat insoweit die Auffassung, dass ein berechtigtes Interesse anzunehmen sein könnte, wenn die betroffene Person ein Kunde des Verantwortlichen ist (Erwägungsgrund 47 Satz 2 DS-GVO).
</p>

<h4>Berechtigte Interessen an der Verarbeitung, die von dem Verantwortlichen oder einem Dritten verfolgt werden</h4>
<p>Basiert die Verarbeitung personenbezogener Daten auf Artikel 6 Ilit. f DS-GVO ist unser berechtigtes Interesse die Durchführung unserer Geschäftstätigkeit zugunsten des Wohlergehens all unserer Mitarbeiter und unserer Anteilseigner.</p>

<h4>Dauer, für die die personenbezogenen Daten gespeichert werden</h4>
<p>Das Kriterium für die Dauer der Speicherung von personenbezogenen Daten ist die jeweilige gesetzliche Aufbewahrungsfrist. Nach Ablauf der Frist werden die entsprechenden Daten routinemäßig gelöscht, sofern sie nicht mehr zur Vertragserfüllung oder Vertragsanbahnung erforderlich sind.</p>

<h4>Gesetzliche oder vertragliche Vorschriften zur Bereitstellung der personenbezogenen Daten; Erforderlichkeit für den Vertragsabschluss; Verpflichtung der betroffenen Person, die personenbezogenen Daten bereitzustellen; mögliche Folgen der Nichtbereitstellung</h4>
<p>Wir klären Sie darüber auf, dass die Bereitstellung personenbezogener Daten zum Teil gesetzlich vorgeschrieben ist (z.B. Steuervorschriften) oder sich auch aus vertraglichen Regelungen (z.B. Angaben zum Vertragspartner) ergeben kann.
Mitunter kann es zu einem Vertragsschluss erforderlich sein, dass eine betroffene Person uns personenbezogene Daten zur Verfügung stellt, die in der Folge durch uns verarbeitet werden müssen. Die betroffene Person ist beispielsweise verpflichtet uns personenbezogene Daten bereitzustellen, wenn unser Unternehmen mit ihr einen Vertrag abschließt. Eine Nichtbereitstellung der personenbezogenen Daten hätte zur Folge, dass der Vertrag mit dem Betroffenen nicht geschlossen werden könnte.
Vor einer Bereitstellung personenbezogener Daten durch den Betroffenen muss sich der Betroffene an einen unserer Mitarbeiter wenden. Unser Mitarbeiter klärt den Betroffenen einzelfallbezogen darüber auf, ob die Bereitstellung der personenbezogenen Daten gesetzlich oder vertraglich vorgeschrieben oder für den Vertragsabschluss erforderlich ist, ob eine Verpflichtung besteht, die personenbezogenen Daten bereitzustellen, und welche Folgen die Nichtbereitstellung der personenbezogenen Daten hätte.
</p>

<h4>Bestehen einer automatisierten Entscheidungsfindung</h4>
<p>Als verantwortungsbewusstes Unternehmen verzichten wir auf eine automatische Entscheidungsfindung oder ein Profiling.</p>


';


$gtagmanager_policy_sample = '
<h3 >Google Tag Manager</h3>
<p>Diese Webseite verwendet den Google Tag Manager (Google LLC. 1600 Amphitheatre Parkway, Mountain View, CA 94043, USA). Durch diesen Dienst können Website-Tags über eine Oberfläche verwaltet werden. Der Google Tool Manager implementiert lediglich Tags. Das bedeutet: Es werden keine Cookies eingesetzt und es werden keine personenbezogenen Daten erfasst.</p>
<p>Der Google Tool Manager löst andere Tags aus, die wiederum ggf. Daten erfassen. Jedoch greift der Google Tag Manager nicht auf diese Daten zu. Wurde auf Domain- oder Cookie-Ebene eine Deaktivierung vorgenommen, so bleibt sie für alle Tracking-Tags bestehen, insofern diese mit dem Google Tag Manager implementiert werden.</p>
';

$ga_policy_sample = '
<h3 >Google Analytics</h3>
<p>Diese Website nutzt verschiedene Dienste des Anbieters Google Ireland Limited, Gordon House, Barrow Street, Dublin 4, Irland. Die einzelnen Dienste werden im nachfolgenden Abschnitt näher dargstellt.</p>
<p>Grundsätzlich verfolgen wir mit dem Einsatz der nachstehenden Dienste und damit verbunden der Erhebung personenbezogener Daten (insbes. der IP-Adresse) ein berechtigtes Interesse, das Angebot auf unserer Website ansprechend darzustellen, zu analysieren, zu verbessern und mögliche Werbung auf Ihre Bedürfnisse anzupassen (Art.6 Abs. 1 lit. f DSGVO). </p>
<p>Google Analytics verwendet sogenannte "Cookies" (s. auch 3.1 „Cookies"). Sie werden auf Ihrem Computer gespeichert und ermöglichen eine Analyse der Benutzung der Website durch Sie. Die durch das Cookie erzeugten Informationen über Ihre Benutzung dieser Website werden in der Regel an einen Server von Google in den USA übertragen und dort gespeichert.</p>
<p><strong>IP Anonymisierung</strong></p>
<p>Wir haben auf dieser Website die Funktion IP-Anonymisierung aktiviert. Dadurch wird Ihre IP-Adresse von Google innerhalb von Mitgliedstaaten der Europäischen Union oder in anderen Vertragsstaaten des Abkommens über den Europäischen Wirtschaftsraum vor der Übermittlung in die USA gekürzt. Im Auftrag des Betreibers dieser Website wird Google diese Informationen benutzen, um Ihre Nutzung der Website auszuwerten, um Reports über die Websiteaktivitäten zusammenzustellen und um weitere mit der Websitenutzung und der Internetnutzung verbundene Dienstleistungen gegenüber dem Websitebetreiber zu erbringen. Die im Rahmen von Google Analytics von Ihrem Browser übermittelte IP-Adresse wird nicht mit anderen Daten von Google zusammengeführt.</p>
<p> <strong>Widerspruch gegen Datenerfassung</strong> </p>
<p>Sie können die Speicherung der Cookies durch eine entsprechende Einstellung Ihrer Browser-Software verhindern; wir weisen Sie jedoch darauf hin, dass Sie in diesem Fall gegebenenfalls nicht alle Funktionen dieser Website vollumfänglich nutzen können. Sie können darüber hinaus die Erfassung der durch den Cookie erzeugten und auf Ihre Nutzung der Website bezogenen Daten (inkl. Ihrer IP-Adresse) an Google sowie die Verarbeitung dieser Daten durch Google verhindern, indem Sie das unter dem folgenden Link verfügbare Browser-Plugin herunterladen und installieren:&nbsp; <a href="https://tools.google.com/dlpage/gaoptout?hl=de" target="_blank" rel="nofollow noopener">https://tools.google.com/dlpage/gaoptout?hl=de</a>.</p>
<p>Mehr Informationen zum Umgang mit Nutzerdaten bei Google Analytics finden Sie in der Datenschutzerklärung von Google:&nbsp; <a href="https://support.google.com/analytics/answer/6004245?hl=de" target="_blank" rel="nofollow noopener">https://support.google.com/analytics/answer/6004245?hl=de</a>.</p>
<p><strong>Auftragsverarbeitung</strong></p>
<p>Wir haben zur Nutzung von Google Analytics einen Vertrag zur Auftragsverarbeitung abgeschlossen und setzen die strengen Vorgaben der deutschen Datenschutzbehörden bei der Nutzung der Dienste vollständig um.</p>
<p> <strong>Demografische Merkmale bei Google Analytics</strong> </p>
<p>Diese Website nutzt die Funktion "demografische Merkmale" von Google Analytics. Dadurch können Berichte erstellt werden, die Aussagen zu Alter, Geschlecht und Interessen der Seitenbesucher enthalten. Diese Daten stammen aus interessenbezogener Werbung von Google sowie aus Besucherdaten von Drittanbietern. Diese Daten können keiner bestimmten Person zugeordnet werden. Sie können diese Funktion jederzeit über die Anzeigeneinstellungen in Ihrem Google-Konto deaktivieren oder die Erfassung Ihrer Daten durch Google Analytics wie im vorherigen Absatz dargestellt generell untersagen.</p>

<b>Cookies von Google Analytics</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>_ga</td>
    <td>Unterscheidung der Webseitenbesucher.</td>
    <td>2 Jahre</td>
  </tr>
  <tr>
    <td>_gid</td>
    <td>Unterscheidung der Webseitenbesucher.</td>
    <td>24 Stunden</td>
  </tr>
  <tr>
    <td>_gat_gtag_UA_<property-id></td>
    <td>Wird zum Drosseln der Anforderungsrate verwendet. Wenn Google Analytics über den Google Tag Manager bereitgestellt wird, erhält dieser Cookie den Namen _dc_gtm_ <property-id>.</td>
    <td>1 Minute</td>  
  </tr>
  <tr>
    <td>_dc_gtm_</td>
    <td>Wird verwendet, um die Anzahl der Google Analytics-Serveranfragen zu überwachen.</td>
    <td>1 Minute</td>
  </tr>
   <tr>
    <td>AMP_TOKEN</td>
    <td>Enthält einen Token-Code, der zum Auslesen einer Client-ID aus dem AMP-Client-ID-Service verwendet wird. Durch den Abgleich dieser ID mit der von Google Analytics können Nutzer beim Wechsel zwischen AMP-Content und Nicht-AMP-Content abgeglichen werden.</td>
    <td>30 Sekunden bis 1 Jahr</td>
  </tr>
   <tr>
    <td>_gat</td>
    <td>Wird zur Überwachung der Anzahl der Google Analytics-Serveranfragen bei der Verwendung von Google Tag Manager verwendet.</td>
    <td>1 Minute</td>
  </tr>   
   <tr>
    <td>_gac_</td>
    <td>Enthält Informationen zu Marketingkampagnen des Benutzers. Diese werden mit Google AdWords / Google Ads gemeinsam genutzt, wenn die Google Ads- und Google Analytics-Konten miteinander verknüpft werden.</td>
    <td>90 Tage</td>
  </tr>     
   <tr>
    <td>__utma</td>
    <td>ID, die zur Identifizierung von Benutzern und Sitzungen verwendet wird.</td>
    <td>2 Jahre</td>
  </tr>  
   <tr>
    <td>__utmt</td>
    <td>Wird verwendet, um die Anzahl der Google Analytics-Serveranfragen zu überwachen.</td>
    <td>10 Minuten</td>
  </tr>   
   <tr>
    <td>__utmb</td>
    <td>Wird zur Unterscheidung zwischen neuen Sitzungen und Besuchen verwendet. Dieses Cookie wird gesetzt, wenn die GA.js Javascript-Bibliothek geladen wird und kein __utmb Cookie vorhanden ist. Das Cookie wird jedes Mal aktualisiert, wenn Daten an den Google Analytics-Server gesendet werden.</td>
    <td>30 Minuten</td>
  </tr>   
   <tr>
    <td>__utmc</td>
    <td>Wird nur mit alten Urchin-Versionen von Google Analytics und nicht mit GA.js verwendet. Wurde verwendet, um zwischen neuen Sitzungen und Besuchen am Ende einer Sitzung zu unterscheiden.</td>
    <td>Session</td>
  </tr>   
   <tr>
    <td>__utmz</td>
    <td>Enthält Informationen über die Verkehrsquelle oder Kampagne, die den Benutzer auf die Website geleitet hat. Das Cookie wird gesetzt, wenn das GA.js-Javascript geladen wird, und aktualisiert, wenn Daten an den Google Anaytics-Server gesendet werden.</td>
    <td>6 Monate</td>
  </tr>   
   <tr>
    <td>__utmv</td>
    <td>Enthält benutzerdefinierte Informationen, die vom Webentwickler mit der _setCustomVar-Methode in Google Analytics festgelegt wurden. Dieses Cookie wird jedes Mal aktualisiert, wenn neue Daten an den Google Analytics-Server gesendet werden.</td>
    <td>2 Jahre</td>
  </tr>   
    <tr>
    <td>__utmx</td>
    <td>Wird verwendet, um zu bestimmen, ob ein Benutzer in einen A / B- oder multivariaten Test einbezogen wird.</td>
    <td>18 Monate</td>
  </tr>   
    <tr>
    <td>__utmxx</td>
    <td>Wird verwendet, um zu bestimmen, wann der A / B- oder multivariate Test, an dem der Benutzer teilnimmt endet.</td>
    <td>18 Monate</td>
  </tr>     
</table>
';


$twitter_policy_sample = '
<h3>Twitter</h3>
<p>Auf dieser Webseite sind Komponenten von Twitter integriert. Twitter ist ein multilingualer öffentlich zugänglicher Mikroblogging-Dienst, auf welchem die Nutzer sogenannte Tweets, also Kurznachrichten, die auf 280 Zeichen begrenzt sind, veröffentlichen und verbreiten können. Diese Kurznachrichten sind für jedermann, also auch für nicht bei Twitter angemeldete Personen abrufbar. Die Tweets werden aber auch den sogenannten Followern des jeweiligen Nutzers angezeigt. Follower sind andere Twitter-Nutzer, die den Tweets eines Nutzers folgen. Ferner ermöglicht Twitter über Hashtags, Verlinkungen oder Retweets die Ansprache eines breiten Publikums.</p>

<p>Betreibergesellschaft von Twitter International Company, One Cumberland Place, Fenian Street Dublin 2, D02 AX07, Ireland.</p>

<p>Durch jeden Aufruf einer der Einzelseiten dieser Internetseite, die durch den für die Verarbeitung Verantwortlichen betrieben wird und auf welcher eine Twitter-Komponente (Twitter-Button) integriert wurde, wird der Internetbrowser auf dem informationstechnologischen System der betroffenen Person automatisch durch die jeweilige Twitter-Komponente veranlasst, eine Darstellung der entsprechenden Twitter-Komponente von Twitter herunterzuladen. Weitere Informationen zu den Twitter-Buttons sind unter <a href="https://about.twitter.com/de/resources/buttons" target="blank">https://about.twitter.com/de/resources/buttons</a> abrufbar. Im Rahmen dieses technischen Verfahrens erhält Twitter Kenntnis darüber, welche konkrete Unterseite unserer Internetseite durch die betroffene Person besucht wird. Zweck der Integration der Twitter-Komponente ist es, unseren Nutzern eine Weiterverbreitung der Inhalte diese Internetseite zu ermöglichen, diese Internetseite in der digitalen Welt bekannt zu machen und unsere Besucherzahlen zu erhöhen.</p>

<p>Sofern die betroffene Person gleichzeitig bei Twitter eingeloggt ist, erkennt Twitter mit jedem Aufruf unserer Internetseite durch die betroffene Person und während der gesamten Dauer des jeweiligen Aufenthaltes auf unserer Internetseite, welche konkrete Unterseite unserer Internetseite die betroffene Person besucht. Diese Informationen werden durch die Twitter-Komponente gesammelt und durch Twitter dem jeweiligen Twitter-Account der betroffenen Person zugeordnet. Betätigt die betroffene Person einen der auf unserer Internetseite integrierten Twitter-Buttons, werden die damit übertragenen Daten und Informationen dem persönlichen Twitter-Benutzerkonto der betroffenen Person zugeordnet und von Twitter gespeichert und verarbeitet.</p>

<p>Twitter erhält über die Twitter-Komponente immer dann eine Information darüber, dass die betroffene Person unsere Internetseite besucht hat, wenn die betroffene Person zum Zeitpunkt des Aufrufs unserer Internetseite gleichzeitig bei Twitter eingeloggt ist; dies findet unabhängig davon statt, ob die betroffene Person die Twitter-Komponente anklickt oder nicht. Ist eine derartige Übermittlung dieser Informationen an Twitter von der betroffenen Person nicht gewollt, kann diese die Übermittlung dadurch verhindern, dass sie sich vor einem Aufruf unserer Internetseite aus ihrem Twitter-Account ausloggt.</p>

<p>Die geltenden Datenschutzbestimmungen von Twitter sind unter <a href="https://twitter.com/privacy?lang=de" target="blank">https://twitter.com/privacy?lang=de</a> abrufbar.</p>
<b>Cookies von Twitter</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>external_referer</td>
    <td>Sammelt anonymisierte Daten wie Anzahl der Besuche, durchschnittlich verbrachte Zeit auf der Website und welche Seiten aufgerufen wurden. Zweck der Personalisierung und Verbesserung des Twitter-Dienstes.</td>
    <td>6 Tage</td>
  </tr>
  <tr>
    <td>_twitter_sess</td>
    <td>Session ID für die Identifizierung falls der Nutzer bei Twitter eingeloggt ist.</td>
    <td>Session</td>
  </tr>
   <tr>
    <td>guest_id</td>
    <td>Session ID für die Identifizierung fall der Nutzer nicht bei Twitter eingeloggt ist.</td>
    <td>2 Jahre</td>
  </tr> 
  <tr>
    <td>personalization_id</td>
    <td>Dient zum Zwecke der Anzeigenpersonalisierung.</td>
    <td>2 Jahre</td>
  </tr> 
  <tr>
    <td>ct0</td>
    <td>Diese Cookies ermöglichen es uns, die Besucheraktivitäten unserer Twitter-Werbung auf unserer Website zu verfolgen und den Nutzern die Möglichkeit zu geben, Inhalte von unseren Websites zu teilen. Diese Cookies liefern uns keine vertraulichen Informationen über Ihr Konto.</td>
    <td>2 Jahre</td>
  </tr>   
</table>
';

$fbpixel_policy_sample = '
<h3>Facebook-Pixel</h3>
<p>Unsere Website nutzt zur Konversionsmessung das Besucheraktions-Pixel von Facebook, Facebook Inc., 1601 S. California Ave, Palo Alto, CA 94304, USA ("Facebook").</p>
<p>Mit Hilfe des Facebook-Pixel kann das Verhalten der Seitenbesucher nachverfolgt werden, nachdem diese durch Klick auf eine Facebook-Werbeanzeige auf unsere Website weitergeleitet wurden. Dadurch können die Wirksamkeit der Facebook-Werbeanzeigen für statistische und Marktforschungszwecke ausgewertet und zukünftige Werbemaßnahmen optimiert werden.</p>	
<p>Die erhobenen Daten sind für uns als Betreiber dieser Website anonym, wir können keine Rückschlüsse auf die Identität der Nutzer ziehen. Die Daten werden aber von Facebook gespeichert und verarbeitet, sodass eine Verbindung zum jeweiligen Nutzerprofil möglich ist und Facebook die Daten für eigene Werbezwecke, entsprechend der Facebook-Datenverwendungsrichtlinie verwenden kann. Dadurch kann Facebook das Schalten von Werbeanzeigen auf Seiten von Facebook sowie außerhalb von Facebook ermöglichen. Diese Verwendung der Daten kann von uns als Seitenbetreiber nicht beeinflusst werden.</p>
<p>In den Datenschutzhinweisen von Facebook finden Sie weitere Hinweise zum Schutz Ihrer Privatsphäre: <a href="https://www.facebook.com/about/privacy/" target="_blank" rel="nofollow noopener">https://www.facebook.com/about/privacy/</a>.</p>
<p>Sie können außerdem die Remarketing-Funktion "Custom Audiences" im Bereich Einstellungen für Werbeanzeigen unter <a href="https://www.facebook.com/ads/preferences/?entry_product=ad_settings_screen" target="_blank" rel="nofollow noopener">https://www.facebook.com/ads/preferences/?entry_product=ad_settings_screen</a> deaktivieren. Dazu müssen Sie bei Facebook angemeldet sein.</p>
<p>Wenn Sie kein Facebook Konto besitzen, können Sie nutzungsbasierte Werbung von Facebook auf der Website der European Interactive Digital Advertising Alliance deaktivieren: <a href="http://www.youronlinechoices.com/de/praferenzmanagement/" target="_blank" rel="nofollow noopener">http://www.youronlinechoices.com/de/praferenzmanagement/</a>.</p>
<b>Cookies von Facebook Pixel</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>act, c_user, datr, fr, pl, presence, sd, wd, xs</td>
    <td>Facebook setzt verschiedene Cookies zur Identifizierungssitzung und Analyse. Diese werden verwendet um zu erkennen ob Sie als Nutzer bei Facebook eingeloggt sind, zu Trackingzwecken und von welcher URL die Share/ Like Funktion verwendet wird.</td>
    <td>variabel</td>
  </tr>   
 </table>
';

$facebook_policy_sample = '
<h3>Facebook Like/Kommentare</h3>
<p>Auf dieser Webseite sind Komponenten des Unternehmens Facebook integriert. Facebook ist ein soziales Netzwerk.</p>
<p>Ein soziales Netzwerk ist ein im Internet betriebener sozialer Treffpunkt, eine Online-Gemeinschaft, die es den Nutzern in der Regel ermöglicht, untereinander zu kommunizieren und im virtuellen Raum zu interagieren. Ein soziales Netzwerk kann als Plattform zum Austausch von Meinungen und Erfahrungen dienen oder ermöglicht es der Internetgemeinschaft, persönliche oder unternehmensbezogene Informationen bereitzustellen. Facebook ermöglicht den Nutzern des sozialen Netzwerkes unter anderem die Erstellung von privaten Profilen, den Upload von Fotos und eine Vernetzung über Freundschaftsanfragen.</p>
<p>Betreibergesellschaft von Facebook ist die Facebook, Inc., 1 Hacker Way, Menlo Park, CA 94025, USA. Für die Verarbeitung personenbezogener Daten Verantwortlicher ist, wenn eine betroffene Person außerhalb der USA oder Kanada lebt, die Facebook Ireland Ltd., 4 Grand Canal Square, Grand Canal Harbour, Dublin 2, Ireland.</p>
<p>Durch jeden Aufruf einer der Einzelseiten dieser Internetseite, die durch den für die Verarbeitung Verantwortlichen betrieben wird und auf welcher eine Facebook-Komponente (Facebook-Plug-In) integriert wurde, wird der Internetbrowser auf dem informationstechnologischen System der betroffenen Person automatisch durch die jeweilige Facebook-Komponente veranlasst, eine Darstellung der entsprechenden Facebook-Komponente von Facebook herunterzuladen. Eine Gesamtübersicht über alle Facebook-Plug-Ins kann unter <a href="https://developers.facebook.com/docs/plugins/?locale=de_DE" target="blank">https://developers.facebook.com/docs/plugins/?locale=de_DE</a> abgerufen werden. Im Rahmen dieses technischen Verfahrens erhält Facebook Kenntnis darüber, welche konkrete Unterseite unserer Internetseite durch die betroffene Person besucht wird.</p>
<p>Sofern die betroffene Person gleichzeitig bei Facebook eingeloggt ist, erkennt Facebook mit jedem Aufruf unserer Internetseite durch die betroffene Person und während der gesamten Dauer des jeweiligen Aufenthaltes auf unserer Internetseite, welche konkrete Unterseite unserer Internetseite die betroffene Person besucht. Diese Informationen werden durch die Facebook-Komponente gesammelt und durch Facebook dem jeweiligen Facebook-Account der betroffenen Person zugeordnet. Betätigt die betroffene Person einen der auf unserer Internetseite integrierten Facebook-Buttons, beispielsweise den „Gefällt mir"-Button, oder gibt die betroffene Person einen Kommentar ab, ordnet Facebook diese Information dem persönlichen Facebook-Benutzerkonto der betroffenen Person zu und speichert diese personenbezogenen Daten.</p>
<p>Facebook erhält über die Facebook-Komponente immer dann eine Information darüber, dass die betroffene Person unsere Internetseite besucht hat, wenn die betroffene Person zum Zeitpunkt des Aufrufs unserer Internetseite gleichzeitig bei Facebook eingeloggt ist; dies findet unabhängig davon statt, ob die betroffene Person die Facebook-Komponente anklickt oder nicht. Ist eine derartige Übermittlung dieser Informationen an Facebook von der betroffenen Person nicht gewollt, kann diese die Übermittlung dadurch verhindern, dass sie sich vor einem Aufruf unserer Internetseite aus ihrem Facebook-Account ausloggt.</p>
<p>Die von Facebook veröffentlichte Datenrichtlinie, die unter <a href="https://de-de.facebook.com/about/privacy/" target="blank">https://de-de.facebook.com/about/privacy/</a> abrufbar ist, gibt Aufschluss über die Erhebung, Verarbeitung und Nutzung personenbezogener Daten durch Facebook. Ferner wird dort erläutert, welche Einstellungsmöglichkeiten Facebook zum Schutz der Privatsphäre der betroffenen Person bietet. Zudem sind unterschiedliche Applikationen erhältlich, die es ermöglichen, eine Datenübermittlung an Facebook zu unterdrücken. Solche Applikationen können durch die betroffene Person genutzt werden, um eine Datenübermittlung an Facebook zu unterdrücken.</p>

<b>Cookies von Facebook</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>_fbp</td>
    <td>Dieser Cookie wird von Facebook verwendet, um eine Reihe von Werbeprodukten wie Echtzeitgebote von Drittanbietern zu liefern.</td>
    <td>3 Monate</td>
  </tr>   
 </table>
';

$dsgvoaio_policy = '
<b>Cookies von DSGVO AIO for WordPress</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>dsgvoaio</td>
    <td>Dieser LocalStorage Key / Wert speichert welchen Diensten der Nutzer zugestimmt hat oder nicht.</td>
    <td>variabel</td>
  </tr>
  <tr>
    <td>_uniqueuid</td>
    <td>Dieser LocalStorage Key / Wert speichert eine generierte ID sodass die Opt-in / Opt-out Aktionen des Nutzers dokumentiert werden können. Die ID wird anonymisiert gespeichert.</td>
    <td>variabel</td>
  </tr>  
   <tr>
    <td>dsgvoaio_create</td>
    <td>Dieser LocalStorage Key / Wert speichert den Zeitpunkt an dem _uniqueuid generiert wurde.</td>
    <td>variabel</td>
  </tr>  
   <tr>
    <td>dsgvoaio_vgwort_disable</td>
    <td>Dieser LocalStorage Key / Wert speichert ob der Dienst VG Wort Standard zugelassen wird oder nicht (Einstellung des Seitenbetreibers).</td>
    <td>variabel</td>
  </tr>   
   <tr>
    <td>dsgvoaio_ga_disable</td>
    <td>Dieser LocalStorage Key / Wert speichert ob der Dienst Google Analytics Standard zugelassen wird oder nicht (Einstellung des Seitenbetreibers).</td>
    <td>variabel</td>
  </tr>    
 </table>
';

$wordpress_policy_sample = '
<h3>Allgemeine Cookies</h3>
<p>Die nachfolgenden Cookies zählen zu den technisch notwendigen Cookies.</p>
<b>Cookies von WordPress</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>wordpress_test_cookie</td>
    <td>Dieses Cookie ermittelt, ob die Verwendung von Cookies im Browser deaktiviert wurde. Speicherdauer: Bis zum Ende der Browsersitzung (wird beim Schließen Ihres Internet-Browsers gelöscht).</td>
    <td>Session</td>
  </tr>
   <tr>
    <td>PHPSESSID</td>
    <td>Dieses Cookie speichert Ihre aktuelle Sitzung mit Bezug auf PHP-Anwendungen und gewährleistet so, dass alle Funktionen dieser Website, die auf der PHP-Programmiersprache basieren, vollständig angezeigt werden können. Speicherdauer: Bis zum Ende der Browsersitzung (wird beim Schließen Ihres Internet-Browsers gelöscht).</td>
    <td>Session</td>
  </tr> 
   <tr>
    <td>wordpress_akm_mobile</td>
    <td>Diese Cookies werden nur für den Verwaltungsbereich von WordPress verwendet.</td>
    <td>1 Jahr</td>
  </tr>   
   <tr>
    <td>wordpress_logged_in_akm_mobile</td>
    <td>Diese Cookies werden nur für den Verwaltungsbereich von WordPress verwendet und gelten für andere Seitenbesucher nicht.</td>
    <td>Session</td>
  </tr>   
   <tr>
    <td>wp-settings-akm_mobile</td>
    <td>Diese Cookies werden nur für den Verwaltungsbereich von WordPress verwendet und gelten für andere Seitenbesucher nicht.</td>
    <td>Session</td>
  </tr>   
   <tr>
    <td>wp-settings-time-akm_mobile</td>
    <td>Diese Cookies werden nur für den Verwaltungsbereich von WordPress verwendet und gelten für andere Seitenbesucher nicht.</td>
    <td>Session</td>
  </tr>     
   <tr>
    <td>ab</td>
    <td>wird für A/B-Tests von neuen Funktionen verwendet.</td>
    <td>Session</td>
  </tr>      
   <tr>
    <td>akm_mobile</td>
    <td>speichert, ob der Besucher die Mobilversion einer Website angezeigt bekommen möchte.</td>
    <td>1 Tag</td>
  </tr>     
</table>
[dsgvoaio_plugins]
';


$wpml_policy_text = '
<b>Cookies von WPML</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>_icl_current_language</td>
    <td>Speichert die vom Benutzer gewählte Sprache.</td>
    <td>1 Jahr</td>
  </tr>
  <tr>
    <td>_icl_visitor_lang_js</td>
    <td>Speichert die umgeleitete Sprache beim wechseln der Sprache.</td>
    <td>1 Jahr</td>
  </tr>
  <tr>
    <td>wpml_browser_redirect_test</td>
    <td>Dieser Cookie ermittelt, ob die Verwendung von Cookies im Browser deaktiviert wurde. Speicherdauer: Bis zum Ende der Browsersitzung (wird beim Schließen Ihres Internet-Browsers gelöscht).</td>
    <td>1 Jahr</td>
  </tr>  
   <tr>
    <td>wpml_referer_url</td>
    <td>Speichert die zuletzt angeforderte URL im Frontend.</td>
    <td>1 Jahr</td>
  </tr>    
 </table>
';

$polylang_policy_text = '
<b>Cookies von Polylang</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>pll_language</td>
    <td>Dieser Cookie speichert die Sprachwahl und die geographische Herkunft des Nutzers.</td>
    <td>1 Jahr</td>
  </tr>
 </table>
';

$woocommerce_policy_text = '
<b>Cookies von WooCommerce</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>woocommerce_cart_hash</td>
    <td>Dieser Cookie ist erforderlich, um die Artikel in Ihrem Einkaufswagen für den Verlauf der Bestellung zu speichern.</td>
    <td>Session</td>
  </tr>
   <tr>
    <td>woocommerce_items_in_cart</td>
    <td>Hilft WooCommerce festzustellen, wann sich der Inhalt des Warenkorbs/Daten ändern.</td>
    <td>Session</td>
  </tr> 
   <tr>
    <td>tk_ai</td>
    <td>Speichert eine zufällig generierte anonyme ID. Dies wird nur innerhalb des Dashboard-Bereichs (/wp-admin) verwendet und dient, falls aktiviert, der Nutzungskontrolle.</td>
    <td>Session</td>
  </tr> 
	<tr>
    <td>wp_woocommerce_session_<uniqeid></td>
    <td>Enthält einen eindeutigen Code für jeden Kunden, so dass er weiß, wo er die Warenkorb-Daten in der Datenbank für jeden Kunden finden kann.</td>
    <td>2 Tage</td>
  </tr>  
   <tr>
    <td>wc_fragments_<uniqeid></td>
    <td>Speichert eine zufällig generierte anonyme ID. Dies wird nur innerhalb des Dashboard-Bereichs (/wp-admin) verwendet und dient, falls aktiviert, der Nutzungskontrolle.</td>
    <td>Session</td>
  </tr>   
   <tr>
    <td>wc_cart_hash<uniqeid></td>
    <td>Speichert eine zufällig generierte anonyme ID. Dies wird nur innerhalb des Dashboard-Bereichs (/wp-admin) verwendet und dient, falls aktiviert, der Nutzungskontrolle.</td>
    <td>Session</td>
  </tr>      
</table>
';


$vgwort_policy_sample = '
<h3>VG Wort</h3>
<p>Wir setzen "Session-Cookies" der VG Wort, München, zur Messung von Zugriffen auf Texten ein, um die Kopierwahrscheinlichkeit zu erfassen. Session-Cookies sind kleine Informationseinheiten, die ein Anbieter im Arbeitsspeicher des Computers des Besuchers speichert. In einem Session-Cookie wird eine zufällig erzeugte eindeutige Identifikationsnummer abgelegt, eine sogenannte Session-ID. Außerdem enthält ein Cookie die Angabe über seine Herkunft und die Speicherfrist. Session-Cookies können keine anderen Daten speichern. Diese Messungen werden von der Kantar Deutschland GmbH nach dem Skalierbaren Zentralen Messverfahren (SZM) durchgeführt. Sie helfen dabei, die Kopierwahrscheinlichkeit einzelner Texte zur Vergütung von gesetzlichen Ansprüchen von Autoren und Verlagen zu ermitteln. Wir erfassen keine personenbezogenen Daten über Cookies.</p>
<p>Viele unserer Seiten sind mit JavaScript-Aufrufen versehen, über die wir die Zugriffe an die Verwertungsgesellschaft Wort (VG Wort) melden. [BITTE ÜBERPRÜFEN, ob dies bei Ihrem Verlag der Fall ist!] Wir ermöglichen damit, dass unsere Autoren an den Ausschüttungen der VG Wort partizipieren, die die gesetzliche Vergütung für die Nutzungen urheberrechtlich geschützter Werke gem. § 53 UrhG sicherstellen.</p>
<p>Eine Nutzung unserer Angebote ist auch ohne Cookies möglich. Die meisten Browser sind so eingestellt, dass sie Cookies automatisch akzeptieren. Sie können das Speichern von Cookies jedoch deaktivieren oder Ihren Browser so einstellen, dass er Sie benachrichtigt, sobald Cookies gesendet werden. Datenschutzerklärung zur Nutzung des Skalierbaren Zentralen Messverfahrens.</p>
<b>Webangebote</b>
<p>Unsere Website und unser mobiles Webangebot nutzen das „Skalierbare Zentrale Messverfahren" (SZM) der Kantar Deutschland GmbH für die Ermittlung statistischer Kennwerte zur Ermittlung der Kopierwahrscheinlichkeit von Texten.</p>
<p>Dabei werden anonyme Messwerte erhoben. Die Zugriffszahlenmessung verwendet zur Wiedererkennung von Computersystemen alternativ ein Session-Cookie oder eine Signatur, die aus verschiedenen automatisch übertragenen Informationen Ihres Browsers erstellt wird. IP-Adressen werden nur in anonymisierter Form verarbeitet. Das Verfahren wurde unter der Beachtung des Datenschutzes entwickelt. Einziges Ziel des Verfahrens ist es, die Kopierwahrscheinlichkeit einzelner Texte zu ermitteln.</p>
<p>Zu keinem Zeitpunkt werden einzelne Nutzer identifiziert. Ihre Identität bleibt immer geschützt. Sie erhalten über das System keine Werbung.</p>
<b>Cookies von VG Wort</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>srp</td>
    <td>Das Cookie der VG Wort hilft die Kopierwahrscheinlichkeit unserer Texte zu ermitteln und stellt die Vergütung von gesetzlichen Ansprüchen von Autoren und Verlagen sicher. IP-Adressen werden nur in anonymisierter Form verarbeitet.</td>
    <td>Session</td>
  </tr>
</table>
';

$koko_policy_sample = '
<h3>Koko Analyics</h3>
<p>Wir setzen auf unserer Webseite zum Zählen der Besucher und Seitenaufrufe ein Plug-In ein – Koko-Analytics.<br>
Beim Aufruf der Seite werden ausschließlich Seitenaufrufe gezählt.<br>
Rechtsgrundlage ist das berechtigte Interesse nach Art. 6. Abs. 1 lit f DSGVO. Unsere berechtigtes Interesse besteht darin, dass wir unbeding wissen müssen, ob unser Seite besucht wird und ob das Plug-In richtig funktioniert.</p>
<b>Cookies von Koko Analyics</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>_koko_analytics_pages_viewed</td>
    <td>Dient dazu um die Seitenzahl der angesehenen Seiten zu ermitteln.</td>
    <td>6 Stunden</td>
  </tr>
</table>
';

$shareaholic_policy_sample = '
<h3>Shareaholic</h3>
<p>Dieser Internetauftritt enthält Shareaholic-Plugins, die Ihnen das Setzen von Bookmarks bzw. das gemeinsame Nutzen interessanter Website-Inhalte ermöglichen.</p>
<p>Bei der Verwendung von Shareaholic kommt es zum Einsatz von Cookies. Die dabei erzeugten Daten (wie z. B. Nutzungszeitpunkt, Browser-Sprache und IP-Adresse) werden an die Shareaholic Inc., Dogpatch Labs 1, Cambridge Center, Suite 600, Cambridge, MA 02142 übertragen und auf Servern in den USA und anderen Ländern verarbeitet.</p>
<p>Nähere Informationen zur Datenverarbeitung durch Shareaholic und dem von der Shareaholic Inc. gepflegten Datenschutz finden Sie unter <a href="http://shareaholic.com/privacy" target="blank">http://www.shareaholic.com/privacy/</a>.</p>
<p>Diese Website enthält insbesondere Angaben zur Art der verarbeiteten Daten sowie deren Verwendungszweck. Eine Verarbeitung der betroffenen Daten durch den Betreiber dieser Seite findet nicht statt.</p>
<p>Mit Nutzung des Shareaholic-Buttons erklären Sie sich mit der Datenverarbeitung durch Shareaholic Inc. einverstanden, und zwar in dem aus der Website <a href="http://www.shareaholic.com/privacy" target="blank">http://www.shareaholic.com/privacy/</a> ersichtlichen Umfang.</p>
<p>Sie können der Nutzung der Daten jederzeit durch Einsatz eines Opt-out Cookies unter <a href="http://www.shareaholic.com/privacy" target="blank">http://www.shareaholic.com/privacy/choices</a> widersprechen. Näheres hierzu ergibt sich ebenfalls aus der vorgenannten Website der Shareaholic Inc.</p>
<b>Cookies von Shareaholic</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>XSRF-TOKEN</td>
    <td>CSRF-Token - dient der Cross-Site-Request-Forgery Sicherheit.</td>
    <td>Session</td>
  </tr>
  <tr>  
    <td>DFTT_END_USER_PREV_BOOTSTRAPPED</td>
    <td>Boolescher Wert, der angibt, dass der Benutzer die Begrüßungsnachricht verworfen hat.</td>
    <td>2 Jahre</td>
  </tr>
  <tr>
    <td>__hssc</td>
    <td>Dieser Cookie wir auf Webseiten verwendet die auf der HubSpot-Plattform erstellt wurden. Er wird für Website-Analyse verwendet.</td>
    <td>30 Minuten</td>
  </tr>
  <tr>
    <td>__hssrc</td>
    <td>Dieser Cookie wir auf Webseiten verwendet die auf der HubSpot-Plattform erstellt wurden. Er wird für Website-Analyse verwendet.</td>
    <td>Session</td>
  </tr>  
  <tr>
    <td>__hstc</td>
    <td>Dieser Cookie wir auf Webseiten verwendet die auf der HubSpot-Plattform erstellt wurden. Er wird für Website-Analyse verwendet.</td>
    <td>2 Jahre</td>
  </tr>    
  <tr>
    <td>__qca</td>
    <td>Shareaholic.com verwendet diesen Cookie auf allen Seiten.</td>
    <td>2,5 Jahre</td>
  </tr>    
  <tr>  
    <td>__d_hsutk</td>
    <td>Integrations-Boolescher Wert, der angibt, dass die HubSpot-UTK überprüft wurde (wenn die Integration aktiviert ist).</td>
    <td>30 Minuten</td>
  </tr>      
  <tr>
    <td>__cfduid</td>
    <td>Wird verwendet, um einzelne Clients hinter einer gemeinsam genutzten IP-Adresse zu identifizieren und Sicherheitseinstellungen für jeden Client einzeln anzuwenden.</td>
    <td>Session</td>
  </tr>      
  <tr>
    <td>hsfirstvisit</td>
    <td>Shareaholic.com verwendet diesen Cookie auf allen Seiten. Er wird verwendet um den Zeitpunkt des ersten Aufrufes zu speichern.</td>
    <td>10 Jahre</td>
  </tr>      
  <tr>
    <td>hubspotutk</td>
    <td>Integrations-Boolescher Wert, der angibt, dass die HubSpot-UTK überprüft wurde (wenn die Integration aktiviert ist).</td>
    <td>10 Jahre</td>
  </tr>      
  <tr>  
    <td>SnapABugVisit</td>
    <td>Dieser Cookie ist mit der Live-Chat-Software von SnapEngage verknüpft. Er identifiziert eine neue Benutzersitzung.</td>
    <td>Session</td>
  </tr> 
  <tr>
    <td>SnapABugHistory</td>
    <td>Dieser Cookie ist mit der Live-Chat-Software von SnapEngage verknüpft. Er identifiziert einen Besucher, um die Aufzeichnung einer Historie zu ermöglichen.</td>
    <td>1 Jahr</td>
  </tr> 
  <tr>
    <td>SnapABugRef</td>
    <td>Dieser Cookie ist mit der Live-Chat-Software von SnapEngage verknüpft. Er zeichnet die Landing Page und Herkunft eines Besuchers auf.</td>
    <td>1 Jahr</td>
  </tr> 
  <tr>
    <td>_ga</td>
    <td>Diesen Cookie setzt	LinkedIn, der Plattform für Unternehmensnetzwerke. Dieser Cookie dient Google Analytics.</td>
    <td>1 Tag</td>
  </tr>   
  <tr>
  <tr>
    <td>_gid</td>
    <td>Diesen Cookie setzt	LinkedIn, der Plattform für Unternehmensnetzwerke. Dieser Cookie dient Google Analytics.</td>
    <td>1 Tag</td>
  </tr>   
  <tr>
    <td>__utma</td>
    <td>Diesen Cookie setzt	LinkedIn, der Plattform für Unternehmensnetzwerke. Dieser Cookie dient Google Analytics.</td>
    <td>2 Jahre</td>
  </tr>   
  <tr>
    <td>__utmb</td>
    <td>Diesen Cookie setzt	LinkedIn, der Plattform für Unternehmensnetzwerke. Dieser Cookie dient Google Analytics.</td>
    <td>1 Stunde und 8 Minuten</td>
  </tr> 
  <tr>
    <td>__utmc</td>
    <td>Diesen Cookie setzt	LinkedIn, der Plattform für Unternehmensnetzwerke. Dieser Cookie dient Google Analytics.</td>
    <td>Session</td>
  </tr>   
  <tr>
    <td>__utmz</td>
    <td>Diesen Cookie setzt	LinkedIn, der Plattform für Unternehmensnetzwerke. Dieser Cookie dient Google Analytics.</td>
    <td>6 Monate und 11 Stunden</td>
  </tr>     
  <tr>
    <td>_shareaholic_session</td>
    <td>Shareaholic.com verwendet diesen Cookie auf allen Seiten. Es haldelt sich um eine eindeutige Sitzungs-ID.</td>
    <td>1 Monat</td>
  </tr> 
  <tr>
    <td>c_id</td>
    <td>Shareaholic.com verwendet diesen Cookie auf allen Seiten.</td>
    <td>1 Jahr</td>
  </tr>
</table>
';

$linkedin_policy_sample = '
<h3>LinkedIn</h3>
<p>Innerhalb unseres Onlineangebotes können Funktionen und Inhalte des Dienstes LinkedIn eingebunden, angeboten durch die LinkedIn AG, Dammtorstraße 29-32, 20354 Hamburg, Deutschland. Hierzu können z.B. Inhalte wie Bilder, Videos oder Texte und Schaltflächen gehören, mit denen Nutzer Ihr Gefallen betreffend die Inhalte kundtun, den Verfassern der Inhalte oder unsere Beiträge abonnieren können.</p>
<p>Sofern die Nutzer Mitglieder der Plattform LinkedIn sind, kann LinkedIn den Aufruf der o.g. Inhalte und Funktionen den dortigen Profilen der Nutzer zuordnen. Datenschutzerklärung von LinkedIn: <a href="https://www.linkedin.com/legal/privacy-policy">https://www.linkedin.com/legal/privacy-policy.</a>.</p>
<p>LinkedIn ist unter dem Privacy-Shield-Abkommen zertifiziert und bietet hierdurch eine Garantie, das europäische Datenschutzrecht einzuhalten (<a href="https://www.privacyshield.gov/participant?id=a2zt0000000L0UZAA0&amp;status=Active">https://www.privacyshield.gov/participant?id=a2zt0000000L0UZAA0&amp;status=Active</a>).<br /> Datenschutzerklärung: <a href="https://twitter.com/privacy">https://twitter.com/de/privacy</a>, Opt-Out: <a href="https://www.linkedin.com/psettings/guest-controls/retargeting-opt-out">https://www.linkedin.com/psettings/guest-controls/retargeting-opt-out</a>.</p>
<b>Cookies von LinkedIn</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>lidc</td>
    <td>Verwendet vom Social Networking Dienst LinkedIn für die Verfolgung der Verwendung von eingebetteten Dienstleistungen.</td>
    <td>Session</td>
  </tr>
  <tr>
    <td>bcookie</td>
    <td>Verwendet vom Social Networking Dienst LinkedIn für die Verfolgung der Verwendung von eingebetteten Dienstleistungen.</td>
    <td>2 Jahre</td>
  </tr>  
  <tr>
    <td>bscookie</td>
    <td>Verwendet vom Social Networking Dienst LinkedIn für die Verfolgung der Verwendung von eingebetteten Dienstleistungen.</td>
    <td>2 Jahre</td>
  </tr>
  <tr>
    <td>BizoID</td>
    <td>LinkedIn Anzeigenanalysen.</td>
    <td>179 Tage</td>
  </tr>
  <tr>
    <td>UserMatchHistory</td>
    <td>LinkedIn Anzeigenanalysen.</td>
    <td>179 Tage</td>
  </tr>  
  <tr>
    <td>trkCode</td>
    <td>Dieses Cookie wird von LinkedIn verwendet, um die Funktionalität des Hinzufügens einer Panel-Einladung mit der Bezeichnung \'Follow Us\' zu unterstützen.</td>
    <td>1 Jahr</td>
  </tr>    
  <tr>
    <td>trkInfo</td>
    <td>Dieses Cookie wird von LinkedIn verwendet, um die Funktionalität des Hinzufügens einer Panel-Einladung mit der Bezeichnung \'Follow Us\' zu unterstützen.</td>
    <td>1 Jahr</td>
  </tr>   
  <tr>
    <td>li_oatml</td>
    <td>Sammelt Informationen darüber, wie Besucher unsere Website nutzen.</td>
    <td>30 Tage</td>
  </tr>  
  <tr>
    <td>liap</td>
    <td>Cookie, das für die Anmeldung mit Linkedin und/oder zur Ermöglichung der Linkedin-Folgefunktion verwendet wird.</td>
    <td>90 Tage</td>
  </tr>   
  <tr>
    <td>lissc</td>
    <td>Cookie, das für die Anmeldung mit Linkedin und/oder zur Ermöglichung der Linkedin-Folgefunktion verwendet wird.</td>
    <td>1 Jahr</td>
  </tr>    
  <tr>
    <td>spectroscopyId</td>
    <td>Diese Cookies werden von LinkedIn zu Werbezwecken gesetzt, u.a. um Besucher zu verfolgen, so dass mehr relevante Anzeigen präsentiert werden können, um den Benutzern zu ermöglichen, die Funktionen \'Bewerben mit LinkedIn\' oder \'Anmelden mit LinkedIn\' zu nutzen, um Informationen darüber zu sammeln, wie Besucher die Website nutzen usw.</td>
    <td>Session</td>
  </tr>     
</table>
';


$matomo_policy_sample = '
<h3>Matomo (ehemals Piwik)</h3>
<p>Diese Website nutzt den Webanalysedienst Matomo (ehemals Piwik), um die Nutzung unserer Website analysieren und regelmäßig verbessern zu können. Der Dienst kommt unserer Login-Seite für das Kunden Portal "AGURS Portal" zum Einsatz. Über die gewonnenen Statistiken können wir unser Angebot verbessern und für Sie als Nutzer interessanter ausgestalten. Rechtsgrundlage für die Nutzung von Matomo ist Art. 6 Abs. 1 f DSGVO.</p>
<p>Für diese Auswertung werden Cookies auf Ihrem Computer gespeichert. Die Auswertung können Sie einstellen durch Löschung vorhandener Cookies und die Verhinderung der Speicherung von Cookies. Wenn Sie die Speicherung der Cookies verhindern, weisen wir darauf hin, dass Sie gegebenenfalls diese Website nicht vollumfänglich nutzen können. Die Verhinderung der Speicherung von Cookies ist durch die Einstellung in ihrem Browser möglich.</p>
<p>Diese Website verwendet Matomo mit der Erweiterung "AnonymizeIP". Dadurch werden IP-Adressen gekürzt weiterverarbeitet, eine direkte Personenbeziehbarkeit kann damit ausgeschlossen werden. Die mittels Matomo von Ihrem Browser übermittelte IP-Adresse wird nicht mit anderen von uns erhobenen Daten zusammengeführt.</p>
<p>Das Programm Matomo ist ein Open-Source-Projekt. Informationen des Drittanbieters zum Datenschutz erhalten Sie unter <a href="https://matomo.org/privacy/">https://matomo.org/privacy/</a></p>
<b>Cookies von Matomo</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>_pk_id</td>
    <td>Besucher-ID, die von Matomo verwendet wird, um wiederkehrende Besucher zu erkennen.</td>
    <td>13 Monate</td>
  </tr>
  <tr>
    <td>_pk_ref</td>
    <td>Enthält Informationen über Referrers des Besuchers.</td>
    <td>6 Monate</td>
  </tr>
  <tr>
    <td>_pk_ses, _pk_cvar, _pk_hsr</td>
    <td>De Session-Cookies halten den "aktiv"-Status für 30 Minuten nach der zuletzt getrackten Aktion des Benutzers. Nach 30 Minuten wird der Besuch als abgeschlossen gewertet.</td>
    <td>30  Minuten</td>
  </tr>
  <tr>
    <td>piwik_ignore</td>
    <td>Der Cookie wird gesetzt, wenn ein Benutzer die Verwendung von Matomo zum Tracking verbietet. Sobald das Cookie gesetzt wird, werden keine Daten über den Benutzer an den Matomo-Server gesendet.</td>
    <td>2 Jahre</td>
  </tr>  
   <tr>
    <td>_pk_testcookie</td>
    <td>Der Cookie wird erstellt und dann direkt gelöscht (dient zur Überprüfung, ob der Browser des Besuchers Cookies unterstützt)</td>
    <td>Session</td>
  </tr>  
   <tr>
    <td>mtm_consent</td>
    <td>Der Cookie wird ohne Ablaufdatum erstellt, um sich für immer daran zu erinnern, dass die Zustimmung des Benutzers gegeben wurde.</td>
    <td>Unendlich</td>
  </tr>   
</table>
';
/************E'N'G'L'I'S'H*************/


$policy_demo_text_en = '
<h2>Privacy Policy</h2>

<p>As of: [dsgvo_save_date]</p>

<p>We are very delighted that you have shown interest in our enterprise. Data protection is of a particularly high priority for the management of us. The use of the Internet pages of us is possible without any indication of personal data; however, if a data subject wants to use special enterprise services via our website, processing of personal data could become necessary. If the processing of personal data is necessary and there is no statutory basis for such processing, we generally obtain consent from the data subject.</p>

<p>The processing of personal data, such as the name, address, e-mail address, or telephone number of a data subject shall always be inline with the General Data Protection Regulation (GDPR), and in accordance with the country-specific data protection regulations applicable to us. By means of this data protection declaration, our enterprise wouldlike to inform the general public of the nature, scope, and purpose of the personal data we collect, use and process. Furthermore, data subjects are informed, by means of this data protection declaration, of the rights to which they are entitled.</p>

<p>As the controller, we has implemented numerous technical and organizational measures to ensure the most complete protection of personal data processed through this website. However, Internet-based data transmissions may in principle have security gaps, so absolute protection may not be guaranteed. For this reason, every data subject is free to transfer personal data to us via alternative means, e.g. by telephone. </p>

<h4>Definitions</h4>
<p>The data protection declaration us is based on the terms used by the European legislator for the adoption of the General Data Protection Regulation (GDPR). Our data protection declaration should be legible and understandable for the general public, as well as our customers and business partners. To ensure this, we wouldlike to first explain the terminology used.</p>

<p>In this data protection declaration, we use, inter alia, the following terms:</p>

<ul>
<li><h4>a)    Personal data</h4>
<p>Personal data means any information relating to an identified or identifiable natural person ("data subject"). An identifiable natural person is one who can be identified, directly or indirectly, in particular by reference to an identifier such as a name, an identification number, location data, an online identifier or to one or more factors specific to the physical, physiological, genetic, mental, economic, cultural or social identity of that natural person.</p>
</li>
<li><h4>b) Data subject</h4>
<p>Data subject is any identified or identifiable natural person, whose personal data is processed by the controller responsible for the processing.</p>
</li>
<li><h4>c)    Processing</h4>
<p>Processing is any operation or set of operations which is performed on personal data or on sets of personal data, whether or not by automated means, such as collection, recording, organisation, structuring, storage, adaptation or alteration, retrieval, consultation, use, disclosure by transmission, dissemination or otherwise making available, alignment or combination, restriction, erasure or destruction. </p>
</li>
<li><h4>d)    Restriction of processing</h4>
<p>Restriction of processing is the marking of stored personal data with the aim oflimiting their processing in the future. </p>
</li>
<li><h4>e)    Profiling</h4>
<p>Profiling means any form of automated processing of personal data consisting of the use of personal data to evaluate certain personal aspects relating to a natural person, in particular to analyse or predict aspects concerning that natural person\'s performance at work, economic situation, health, personal preferences, interests, reliability, behaviour, location or movements. </p>
</li>
<li><h4>f)     Pseudonymisation</h4>
<p>Pseudonymisation is the processing of personal data in such a manner that the personal data can no longer be attributed to a specific data subject without the use of additional information, provided that such additional information is kept separately and is subject to technical and organisational measures to ensure that the personal data are not attributed to an identified or identifiable natural person. </p>
</li>
<li><h4>g)    Controller or controller responsible for the processing</h4>
<p>Controller or controller responsible for the processing is the natural or legal person, public authority, agency or other body which, alone or jointly with others, determines the purposes and means of the processing of personal data; where the purposes and means of such processing are determined by Union or Member State law, the controller or the specific criteria for its nomination may be provided for by Union or Member State law. </p>
</li>
<li><h4>h)    Processor</h4>
<p>Processor is a natural or legal person, public authority, agency or other body which processes personal data on behalf of the controller. </p>
</li>
<li><h4>i)      Recipient</h4>
<p>Recipient is a natural or legal person, public authority, agency or another body, to which the personal data are disclosed, whether a third party or not. However, public authorities which may receive personal data in the framework of a particular inquiry in accordance with Union or Member State law shall not be regarded as recipients; the processing of those data by those public authorities shall be in compliance with the applicable data protection rules according to the purposes of the processing. </p>
</li>
<li><h4>j)      Third party</h4>
<p>Third party is a natural or legal person, public authority, agency or body other than the data subject, controller, processor and persons who, under the direct authority of the controller or processor, are authorised to process personal data.</p>
</li>
<li><h4>k)    Consent</h4>
<p>Consent of the data subject is any freely given, specific, informed and unambiguous indication of the data subject\'s wishes by which he or she, by a statement or by a clear affirmative action, signifies agreement to the processing of personal data relating to him or her. </p>
</li>
</ul>

<h4>Name and Address of the controller</h4>
<p>Controller for the purposes of the General Data Protection Regulation (GDPR), other data protection laws applicable in Member states of the European Union and other provisions related to data protection is:

</p>

<p>[company]</p>
<p>[owner]</p>
<p>[adress]</p>
<p>[zip] [city]</p>
<p>[country]</p>
<p>[phone]</p>
<p>[mail]</p>
<p>[ust]</p>

<h4>Cookies / SessionStorage / LocalStorage</h4>
<p>The Internet pages of us use cookies, localstorage and sessionstorage. This is to make our offer more user-friendly, effective and secure. Local storage and session storage is a technology used by your browser to store data on your computer or mobile device. Cookies are text files that are stored in a computer system via an Internet browser. You can prevent the use of cookies, localstorage and sessionstorage by setting them in your browser.</p>

<p>Many Internet sites and servers use cookies. Many cookies contain a so-called cookie ID. A cookie ID is a unique identifier of the cookie. It consists of a character string through which Internet pages and servers can be assigned to the specific Internet browser in which the cookie was stored. This allows visited Internet sites and servers to differentiate the individual browser of the dats subject from other Internet browsers that contain other cookies. A specific Internet browser can be recognized and identified using the unique cookie ID.</p>

<p>Through the use of cookies, we can provide the users of this website with more user-friendly services that would not be possible without the cookie setting.</p>

<p>By means of a cookie, the information and offers on our website can be optimized with the user in mind. Cookies allow us, as previously mentioned, to recognize our website users. The purpose of this recognition is to make it easier for users to utilize our website. The website user that uses cookies, e.g. does not have to enter access data each time the website is accessed, because this is taken over by the website, and the cookie is thus stored on the user\'s computer system. Another example is the cookie of a shopping cart in an online shop. The online store remembers the articles that a customer has placed in the virtual shopping cart via a cookie.</p>

<p>The data subject may, at any time, prevent the setting of cookies through our website by means of a corresponding setting of the Internet browser used, and may thus permanently deny the setting of cookies. Furthermore, already set cookies may be deleted at any time via an Internet browser or other software programs. This is possible in all popular Internet browsers. If the data subject deactivates the setting of cookies in the Internet browser used, not all functions of our website may be entirely usable.</p>

<h4>Collection of general data and information</h4>
<p>The website of us collects a series of general data and information when a data subject or automated system calls up the website. This general data and information are stored in the server log files. Collected may be (1) the browser types and versions used, (2) the operating system used by the accessing system, (3) the website from which an accessing system reaches our website (so-called referrers), (4) the sub-websites, (5) the date and time of access to the Internet site, (6) an Internet protocol address (IP address), (7) the Internet service provider of the accessing system, and (8) any other similar data and information that may be used in the event of attacks on our information technology systems.</p>

<p>When using these general data and information, we does not draw any conclusions about the data subject. Rather, this information is needed to (1) deliver the content of our website correctly, (2) optimize the content of our website as well as its advertisement, (3) ensure the long-term viability of our information technology systems and website technology, and (4) provide law enforcement authorities with the information necessary for criminal prosecution in case of a cyber-attack. Therefore, we analyzes anonymously collected data and information statistically, with the aim of increasing the data protection and data security of our enterprise, and to ensure an optimal level of protection for the personal data we process. The anonymous data of the server log files are stored separately from all personal data provided by a data subject.</p>

<h4>Registration on our website</h4>
<p>The data subject has the possibility to register on the website of the controller with the indication of personal data. Which personal data are transmitted to the controller is determined by the respective input mask used for the registration. The personal data entered by the data subject are collected and stored exclusively for internal use by the controller, and for his own purposes. The controller may request transfer to one or more processors (e.g. a parcel service) that also uses personal data for an internal purpose which is attributable to the controller.</p>

<p>By registering on the website of the controller, the IP address—assigned by the Internet service provider (ISP) and used by the data subject—date, and time of the registration are also stored. The storage of this data takes place against the background that this is the only way to prevent the misuse of our services, and, if necessary, to make it possible to investigate committed offenses. Insofar, the storage of this data is necessary to secure the controller. This data is not passed on to third parties unless there is a statutory obligation to pass on the data, or if the transfer serves the aim of criminal prosecution.

</p>

<p>The registration of the data subject, with the voluntary indication of personal data, is intended to enable the controller to offer the data subject contents or services that may only be offered to registered users due to the nature of the matter in question. Registered persons are free to change the personal data specified during the registration at any time, or to have them completely deleted from the data stock of the controller.</p>

<p>The data controller shall, at any time, provide information upon request to each data subject as to what personal data are stored about the data subject. In addition, the data controller shall correct or erase personal data at the request or indication of the data subject, insofar as there are no statutory storage obligations. The entirety of the controller’s employees are available to the data subject in this respect as contact persons.</p>

<h4>Contact possibility via the website </h4>
<p>The website contains information that enables a quick electronic contact to our enterprise, as well as direct communication with us, which also includes a general address of the so-called electronic mail (e-mail address). If a data subject contacts the controller by e-mail or via a contact form, the personal data transmitted by the data subject are automatically stored. Such personal data transmitted on a voluntary basis by a data subject to the data controller are stored for the purpose of processing or contacting the data subject. There is no transfer of this personal data to third parties.</p>

<h4>Comments function in the blog on the website</h4>
<p>We offers users the possibility to leave individual comments on individual blog contributions on a blog, which is on the website of the controller. A blog is a web-based, publicly-accessible portal, through which one or more people called bloggers or web-bloggers may post articles or write down thoughts in so-called blogposts. Blogposts may usually be commented by third parties.</p>

<p>If a data subject leaves a comment on the blog published on this website, the comments made by the data subject are also stored and published, as well as information on the date of the commentary and on the user\'s (pseudonym) chosen by the data subject. In addition, the IP address assigned by the Internet service provider (ISP) to the data subject is also logged. This storage of the IP address takes place for security reasons, and in case the data subject violates the rights of third parties, or posts illegal content through a given comment. The storage of these personal data is, therefore, in the own interest of the data controller, so that he can exculpate in the event of an infringement. This collected personal data will not be passed to third parties, unless such a transfer is required by law or serves the aim of the defense of the data controller.</p>

<h4>Gravatar</h4>
<p>For comments, the Gravatar service from Auttomatic is used. Gravatar matches your email address and maps - if you are registered - your avatar image next to the comment. If you are not registered, no image will be displayed. It should be noted that all registered WordPress users are automatically registered with Gravatar. Details of Gravatar: <a href="https://de.gravatar.com" target="blank">https://en.gravatar.com</a></p>


<h4>Routine erasure and blocking of personal data</h4>
<p>The data controller shall process and store the personal data of the data subject only for the period necessary to achieve the purpose of storage, or as far as this is granted by the European legislator or other legislators in laws or regulations to which the controller is subject to.</p>

<p>If the storage purpose is not applicable, or if a storage period prescribed by the European legislator or another competent legislator expires, the personal data are routinely blocked or erased in accordance with legal requirements.</p>

<h4>Rights of the data subject</h4>
<ul>
<li><h4>a) Right of confirmation</h4>
<p>Each data subject shall have the right granted by the European legislator to obtain from the controller the confirmation as to whether or not personal data concerning him or her are being processed. If a data subject wishes to avail himself of this right of confirmation, he or she may, at any time, contact any employee of the controller.</p>
</li>
<li><h4>b) Right of access</h4>
<p>Each data subject shall have the right granted by the European legislator to obtain from the controller free information about his or her personal data stored at any time and a copy of this information. Furthermore, the European directives and regulations grant the data subject access to the following information:</p>

<ul>
<li>the purposes of the processing;</li>
<li>the categories of personal data concerned;</li>
<li>the recipients or categories of recipients to whom the personal data have been or will be disclosed, in particular recipients in third countries or international organisations;</li>
<li>where possible, the envisaged period for which the personal data will be stored, or, if not possible, the criteria used to determine that period;</li>
<li>the existence of the right to request from the controller rectification or erasure of personal data, or restriction of processing of personal data concerning the data subject, or to object to such processing;</li>
<li>the existence of the right to lodge a complaint with a supervisory authority;</li>
<li>where the personal data are not collected from the data subject, any available information as to their source;</li>
<li>the existence of automated decision-making, including profiling, referred to in Article 22(1) and (4) of the GDPR and, at least in those cases, meaningful information about the logic involved, as well as the significance and envisaged consequences of such processing for the data subject.</li>

</ul>
<p>Furthermore, the data subject shall have a right to obtain information as to whether personal data are transferred to a third country or to an international organisation. Where this is the case, the data subject shall have the right to be informed of the appropriate safeguards relating to the transfer.</p>

<p>If a data subject wishes to avail himself of this right of access, he or she may, at any time, contact any employee of the controller.</p>
</li>
<li><h4>c) Right to rectification </h4>
<p>Each data subject shall have the right granted by the European legislator to obtain from the controller without undue delay the rectification of inaccurate personal data concerning him or her. Taking into account the purposes of the processing, the data subject shall have the right to have incomplete personal data completed, including by means of providing a supplementary statement.</p>

<p>If a data subject wishes to exercise this right to rectification, he or she may, at any time, contact any employee of the controller.</p></li>
<li>
<h4>d) Right to erasure (Right to be forgotten) </h4>
<p>Each data subject shall have the right granted by the European legislator to obtain from the controller the erasure of personal data concerning him or her without undue delay, and the controller shall have the obligation to erase personal data without undue delay where one of the following grounds applies, as long as the processing is not necessary: </p>

<ul>
<li>The personal data are no longer necessary in relation to the purposes for which they were collected or otherwise processed.</li>
<li>The data subject withdraws consent to which the processing is based according to point (a) of Article 6(1) of the GDPR, or point (a) of Article 9(2) of the GDPR, and where there is no other legal ground for the processing.</li>
<li>The data subject objects to the processing pursuant to Article 21(1) of the GDPR and there are no overriding legitimate grounds for the processing, or the data subject objects to the processing pursuant to Article 21(2) of the GDPR. </li>
<li>The personal data have been unlawfully processed.</li>
<li>The personal data must be erased for compliance with a legal obligation in Union or Member State law to which the controller is subject.</li>
<li>The personal data have been collected in relation to the offer of information society services referred to in Article 8(1) of the GDPR.</li>

</ul>
<p>If one of the aforementioned reasons applies, and a data subject wishes to request the erasure of personal data stored by us, he or she may, at any time, contact any employee of the controller. An employee us shall promptly ensure that the erasure request is complied with immediately.</p>

<p>Where the controller has made personal data public and is obliged pursuant to Article 17(1) to erase the personal data, the controller, taking account of available technology and the cost of implementation, shall take reasonable steps, including technical measures, to inform other controllers processing the personal data that the data subject has requested erasure by such controllers of anylinks to, or copy or replication of, those personal data, as far as processing is not required. An employees of us will arrange the necessary measures in individual cases.</p>
</li>
<li><h4>e) Right of restriction of processing</h4>
<p>Each data subject shall have the right granted by the European legislator to obtain from the controller restriction of processing where one of the following applies:</p>

<ul>
<li>The accuracy of the personal data is contested by the data subject, for a period enabling the controller to verify the accuracy of the personal data. </li>
<li>The processing is unlawful and the data subject opposes the erasure of the personal data and requests instead the restriction of their use instead.</li>
<li>The controller no longer needs the personal data for the purposes of the processing, but they are required by the data subject for the establishment, exercise or defence of legal claims.</li>
<li>The data subject has objected to processing pursuant to Article 21(1) of the GDPR pending the verification whether the legitimate grounds of the controller override those of the data subject.</li>

</ul>
<p>If one of the aforementioned conditions is met, and a data subject wishes to request the restriction of the processing of personal data stored by us, he or she may at any time contact any employee of the controller. The employee of us will arrange the restriction of the processing. </p>
</li>
<li><h4>f) Right to data portability</h4>
<p>Each data subject shall have the right granted by the European legislator, to receive the personal data concerning him or her, which was provided to a controller, in a structured, commonly used and machine-readable format. He or she shall have the right to transmit those data to another controller without hindrance from the controller to which the personal data have been provided, as long as the processing is based on consent pursuant to point (a) of Article 6(1) of the GDPR or point (a) of Article 9(2) of the GDPR, or on a contract pursuant to point (b) of Article 6(1) of the GDPR, and the processing is carried out by automated means, as long as the processing is not necessary for the performance of a task carried out in the public interest or in the exercise of official authority vested in the controller.</p>

<p>Furthermore, in exercising his or her right to data portability pursuant to Article 20(1) of the GDPR, the data subject shall have the right to have personal data transmitted directly from one controller to another, where technically feasible and when doing so does not adversely affect the rights and freedoms of others.</p>

<p>In order to assert the right to data portability, the data subject may at any time contact any employee of us.</p>

</li>
<li>
<h4>g) Right to object</h4>
<p>Each data subject shall have the right granted by the European legislator to object, on grounds relating to his or her particular situation, at any time, to processing of personal data concerning him or her, which is based on point (e) or (f) of Article 6(1) of the GDPR. This also applies to profiling based on these provisions.</p>

<p>We shall no longer process the personal data in the event of the objection, unless we can demonstrate compelling legitimate grounds for the processing which override the interests, rights and freedoms of the data subject, or for the establishment, exercise or defence of legal claims.</p>

<p>If we processes personal data for direct marketing purposes, the data subject shall have the right to object at any time to processing of personal data concerning him or her for such marketing. This applies to profiling to the extent that it is related to such direct marketing. If the data subject objects to us to the processing for direct marketing purposes, we will no longer process the personal data for these purposes.</p>

<p>In addition, the data subject has the right, on grounds relating to his or her particular situation, to object to processing of personal data concerning him or her by us for scientific or historical research purposes, or for statistical purposes pursuant to Article 89(1) of the GDPR, unless the processing is necessary for the performance of a task carried out for reasons of public interest.</p>

<p>In order to exercise the right to object, the data subject may contact any employee of us. In addition, the data subject is free in the context of the use of information society services, and notwithstanding Directive 2002/58/EC, to use his or her right to object by automated means using technical specifications.</p>
</li>
<li><h4>h) Automated individual decision-making, including profiling</h4>
<p>Each data subject shall have the right granted by the European legislator not to be subject to a decision based solely on automated processing, including profiling, which produces legal effects concerning him or her, or similarly significantly affects him or her, as long as the decision (1) is not is necessary for entering into, or the performance of, a contract between the data subject and a data controller, or (2) is not authorised by Union or Member State law to which the controller is subject and which also lays down suitable measures to safeguard the data subject\'s rights and freedoms and legitimate interests, or (3) is not based on the data subject\'s explicit consent.</p>

<p>If the decision (1) is necessary for entering into, or the performance of, a contract between the data subject and a data controller, or (2) it is based on the data subject\'s explicit consent, we shall implement suitable measures to safeguard the data subject\'s rights and freedoms and legitimate interests, at least the right to obtain human intervention on the part of the controller, to express his or her point of view and contest the decision.</p>

<p>If the data subject wishes to exercise the rights concerning automated individual decision-making, he or she may, at any time, contact any employee of us.</p>

</li>
<li><h4>i) Right to withdraw data protection consent </h4>
<p>Each data subject shall have the right granted by the European legislator to withdraw his or her consent to processing of his or her personal data at any time. </p>

<p>If the data subject wishes to exercise the right to withdraw the consent, he or she may, at any time, contact any employee of us.</p>

</li>
</ul>
<h4>Legal basis for the processing </h4>
<p>Art. 6(1)lit. a GDPR serves as the legal basis for processing operations for which we obtain consent for a specific processing purpose. If the processing of personal data is necessary for the performance of a contract to which the data subject is party, as is the case, for example, when processing operations are necessary for the supply of goods or to provide any other service, the processing is based on Article 6(1)lit. b GDPR. The same applies to such processing operations which are necessary for carrying out pre-contractual measures, for example in the case of inquiries concerning our products or services. Is our company subject to a legal obligation by which processing of personal data is required, such as for the fulfillment of tax obligations, the processing is based on Art. 6(1)lit. c GDPR.
In rare cases, the processing of personal data may be necessary to protect the vital interests of the data subject or of another natural person. This would be the case, for example, if a visitor were injured in our company and his name, age, health insurance data or other vital information would have to be passed on to a doctor, hospital or other third party. Then the processing would be based on Art. 6(1)lit. d GDPR.
Finally, processing operations could be based on Article 6(1)lit. f GDPR. This legal basis is used for processing operations which are not covered by any of the abovementioned legal grounds, if processing is necessary for the purposes of the legitimate interests pursued by our company or by a third party, except where such interests are overridden by the interests or fundamental rights and freedoms of the data subject which require protection of personal data. Such processing operations are particularly permissible because they have been specifically mentioned by the European legislator. He considered that a legitimate interest could be assumed if the data subject is a client of the controller (Recital 47 Sentence 2 GDPR).
</p>

<h4>The legitimate interests pursued by the controller or by a third party</h4>
<p>Where the processing of personal data is based on Article 6(1)lit. f GDPR our legitimate interest is to carry out our business in favor of the well-being of all our employees and the shareholders.</p>

<h4>Period for which the personal data will be stored</h4>
<p>The criteria used to determine the period of storage of personal data is the respective statutory retention period. After expiration of that period, the corresponding data is routinely deleted, as long as it is no longer necessary for the fulfillment of the contract or the initiation of a contract.</p>

<h4>Provision of personal data as statutory or contractual requirement; Requirement necessary to enter into a contract; Obligation of the data subject to provide the personal data; possible consequences of failure to provide such data </h4>
<p>We clarify that the provision of personal data is partly required by law (e.g. tax regulations) or can also result from contractual provisions (e.g. information on the contractual partner).

Sometimes it may be necessary to conclude a contract that the data subject provides us with personal data, which must subsequently be processed by us. The data subject is, for example, obliged to provide us with personal data when our company signs a contract with him or her. The non-provision of the personal data would have the consequence that the contract with the data subject could not be concluded.

Before personal data is provided by the data subject, the data subject must contact any employee. The employee clarifies to the data subject whether the provision of the personal data is required by law or contract or is necessary for the conclusion of the contract, whether there is an obligation to provide the personal data and the consequences of non-provision of the personal data.
</p>

<h4>Existence of automated decision-making</h4>
<p>As a responsible company, we do not use automatic decision-making or profiling.</p>
';


$matomo_policy_sample_en = '
<h3>Matomo (formaly Piwik)</h3>
<p> This website uses the web analytics service Matomo (formerly Piwik) to analyze and regularly improve the use of our website. The service is used for our login page for the customer portal "AGURS Portal". With the statistics we can improve our offer and make it more interesting for you as a user. The legal basis for the use of Matomo is Art. 6 para. 1 f DSGVO. </p>
<p> Cookies are stored on your computer for this evaluation. You can adjust the evaluation by deleting existing cookies and preventing the storage of cookies. If you prevent the storage of cookies, we point out that you may not be able to use this website to the full extent. Preventing the storage of cookies is possible by setting in your browser. </p>
<p> This website uses Matomo with the extension "AnonymizeIP". As a result, IP addresses are processed shortened, a direct person-relatedness can thus be excluded. The IP address transmitted by Matomo from your browser will not be merged with any other information we collect. </p>
<p> The Matomo program is an open source project. Third-party privacy information is available at <a href="https://matomo.org/privacy/"> https://matomo.org/privacy/ </a> </p>
<b>Cookies from Matomo</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>_pk_id</td>
    <td>Visitor ID used by Matomo to recognize returning visitors.</td>
    <td>13 Months</td>
  </tr>
  <tr>
    <td>_pk_ref</td>
    <td>Contains information about the visitor\'s referrers.</td>
    <td>6 Months</td>
  </tr>
  <tr>
    <td>_pk_ses, _pk_cvar, _pk_hsr</td>
    <td>The session cookie holds the \"active\" status for 30 minutes after the user\'s last tracked action. After 30 minutes, the visit is considered completed.</td>
    <td>30  Minutes</td>
  </tr>
  <tr>
    <td>piwik_ignore</td>
    <td>Cookie is set when a user prohibits the use of Matomo for tracking. Once the cookie is set, no data about the user is sent to the Matomo server.</td>
    <td>2 Years</td>
  </tr>  
   <tr>
    <td>_pk_testcookie</td>
    <td>Cookie is created and should be then directly deleted (used to check whether the visitor’s browser supports cookies).</td>
    <td>Session</td>
  </tr>  
   <tr>
    <td>mtm_consent</td>
    <td>Cookie is created with no expiry date to forever remember that consent was given by the user.</td>
    <td>Forever</td>
  </tr>   
</table>
';


$gtagmanager_policy_sample_en = '
<h3 >Google Tag Manager</h3>
<p>This website uses Google Tag Manager (Google LLC. 1600 Amphitheatre Parkway, Mountain View, CA 94043, USA) Google Tag Manager allows marketed website tags to be managed using an interface. The Tag Manager tool itself (which implements the tags) is a cookie-less domain and does not register personal data. The tool causes other tags to be activated which may, for their part, register data under certain circumstances. Google Tag Manager does not access this information. If recording has been deactivated on domain or cookie level, this setting will remain in place for all tracking tags implemented with Google Tag Manager.</p>
';


$ga_policy_sample_en = '
<h3>Google Analytics</h3>
<p>This website uses various services provided by Google Ireland Limited, Gordon House, Barrow Street, Dublin 4, Ireland. The use of these individual services is described in more detail below.</p>
<p>Our use of the following services and the associated collection of personal data (in particular IP addresses) is generally based on our legitimate interest in analyzing, improving and making our website content appear attractive as well as on our legitimate interest in tailoring any advertising to your needs (Article 6 (1) f GDPR).</p>
<p>Google Analytics uses cookies (see also 3.1 “Cookies”). Cookies are stored on your computer and enable Google to analyze how you use this website. The information generated by the cookie about your use of this website is generally transmitted to and stored on a Google server in the USA.</p>
<p> <strong>IP anonymization</strong> </p>
<p>We have activated IP anonymization on our website. This means that Google will shorten your IP address before transmitting it to the USA, provided the IP address originates from a member state of the European Union or a state that is party to the Agreement on the European Economic Area. The operator of this website contracts Google to use this information to evaluate how you use the website, to create reports about the website activity, and to provide other services relating to the use of the website and the internet. The IP address transmitted from your browser during the Google Analytics process is not linked to other data held by Google.</p>
<p> <strong>Your right to object to the collection of your data</strong> </p>
<p>You can block the storage of cookies by adjusting your browser settings accordingly; please note, however, that in such cases you may not be able to make full use of all the features available on this website. You can also prevent Google from collecting and processing the data generated by the cookie about your use of the website (including your IP address) by downloading and installing the browser plugin available at the following link:&nbsp; <a href="https://tools.google.com/dlpage/gaoptout?hl=en" target="_blank" rel="nofollow noopener">https://tools.google.com/dlpage/gaoptout?hl=en</a>.</p>
<p>Further information about how Google Analytics handles your data can be found in Google’s Privacy Policy:&nbsp; <a href="https://support.google.com/analytics/answer/6004245?hl=en" target="_blank" rel="nofollow noopener">https://support.google.com/analytics/answer/6004245?hl=en</a>.</p>
<p> <strong>The processing of data on our behalf</strong> </p>
<p>We have concluded a data processing agreement for our use of Google Analytics and fully comply with the strict provisions of German data protection authorities when using this service.</p>
<p> <strong>Collection of demographic data by Google Analytics</strong> </p>
<p>This website uses the Demographics feature provided by Google Analytics. This feature enables reports to be created that contain statements about the age, gender, and interests of visitors to this site. This data is gathered from Google’s personalized advertising as well as visitor data from third-party providers. This data cannot be attributed to any specific individuals. You can disable this feature at any time by adjusting the ads settings in your Google account, or you can prohibit the general collection of your data by Google Analytics by following the steps outlined above.</p>
<b>Cookies from Google Analytics</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>_ga</td>
    <td>Differentiation of website visitors.</td>
    <td>2 Hours</td>
  </tr>
  <tr>
    <td>_gid</td>
    <td>Differentiation of website visitors.</td>
    <td>24 Hours</td>
  </tr>
  <tr>
    <td>_gat_gtag_UA_<property-id></td>
    <td>Used to throttle the request rate. If Google Analytics is provided through Google Tag Manager, this cookie will be named _dc_gtm_ <property-id>.</td>
    <td>1 Minutes</td>
  </tr>
  <tr>
    <td>_dc_gtm_</td>
    <td>Used to monitor number of Google Analytics server requests.</td>
    <td>1 Minutes</td>
  </tr>
   <tr>
    <td>AMP_TOKEN</td>
    <td>Contains a token code that is used to read out a Client ID from the AMP Client ID Service. By matching this ID with that of Google Analytics, users can be matched when switching between AMP content and non-AMP content.</td>
    <td>30 Seconds up to 1 Year</td>
  </tr>
   <tr>
    <td>_gat</td>
    <td>Used to monitor number of Google Analytics server requests when using Google Tag Manager.</td>
    <td>1 Minute</td>
  </tr>   
   <tr>
    <td>_gac_</td>
    <td>Contains information related to marketing campaigns of the user. These are shared with Google AdWords / Google Ads when the Google Ads and Google Analytics accounts are linked together.</td>
    <td>90 Days</td>
  </tr>     
   <tr>
    <td>__utma</td>
    <td>ID used to identify users and sessions.</td>
    <td>2 Years</td>
  </tr>  
   <tr>
    <td>__utmt</td>
    <td>Used to monitor number of Google Analytics server requests.</td>
    <td>10 Minutes</td>
  </tr>   
   <tr>
    <td>__utmb</td>
    <td>Used to distinguish new sessions and visits. This cookie is set when the GA.js javascript library is loaded and there is no existing __utmb cookie. The cookie is updated every time data is sent to the Google Analytics server.</td>
    <td>30 Minutes</td>
  </tr>   
   <tr>
    <td>__utmc</td>
    <td>Used only with old Urchin versions of Google Analytics and not with GA.js. Was used to distinguish between new sessions and visits at the end of a session.</td>
    <td>Session</td>
  </tr>   
   <tr>
    <td>__utmz</td>
    <td>Contains information about the traffic source or campaign that directed user to the website. The cookie is set when the GA.js javascript is loaded and updated when data is sent to the Google Anaytics server.</td>
    <td>6 Months</td>
  </tr>   
   <tr>
    <td>__utmv</td>
    <td>Contains custom information set by the webdeveloper using the _setCustomVar method in Google Analytics. This cookie is updated each time new data is sent to the Google Analytics server.</td>
    <td>2 Years</td>
  </tr>   
    <tr>
    <td>__utmx</td>
    <td>Used to determine whether a user is included in an A / B or Multivariate test.</td>
    <td>18 Months</td>
  </tr>   
    <tr>
    <td>__utmxx</td>
    <td>Used to determine when the A / B or Multivariate test in which the user participates ends.</td>
    <td>18 Months</td>
  </tr>    
</table>
';

$facebook_policy_sample_en = '
<h3>Facebook Like/Comments</h3>
<p>On this website, the controller has integrated components of the enterprise Facebook. Facebook is a social network.</p>
<p>A social network is a place for social meetings on the Internet, an online community, which usually allows users to communicate with each other and interact in a virtual space. A social network may serve as a platform for the exchange of opinions and experiences, or enable the Internet community to provide personal or business-related information. Facebook allows social network users to include the creation of private profiles, upload photos, and network through friend requests.</p>
<p>The operating company of Facebook is Facebook, Inc., 1 Hacker Way, Menlo Park, CA 94025, United States. If a person lives outside of the United States or Canada, the controller is the Facebook Ireland Ltd., 4 Grand Canal Square, Grand Canal Harbour, Dublin 2, Ireland.</p>
<p>With each call-up to one of the individual pages of this Internet website, which is operated by the controller and into which a Facebook component (Facebook plug-ins) was integrated, the web browser on the information technology system of the data subject is automatically prompted to download display of the corresponding Facebook component from Facebook through the Facebook component. An overview of all the Facebook Plug-ins may be accessed under <a href="https://facebook.com/about/privacy/" target="blank">https://developers.facebook.com/docs/plugins/</a>. During the course of this technical procedure, Facebook is made aware of what specific sub-site of our website was visited by the data subject.</p>
<p>If the data subject is logged in at the same time on Facebook, Facebook detects with every call-up to our website by the data subject—and for the entire duration of their stay on our Internet site—which specific sub-site of our Internet page was visited by the data subject. This information is collected through the Facebook component and associated with the respective Facebook account of the data subject. If the data subject clicks on one of the Facebook buttons integrated into our website, e.g. the "Like" button, or if the data subject submits a comment, then Facebook matches this information with the personal Facebook user account of the data subject and stores the personal data.</p>
<p>Facebook always receives, through the Facebook component, information about a visit to our website by the data subject, whenever the data subject is logged in at the same time on Facebook during the time of the call-up to our website. This occurs regardless of whether the data subject clicks on the Facebook component or not. If such a transmission of information to Facebook is not desirable for the data subject, then he or she may prevent this by logging off from their Facebook account before a call-up to our website is made.</p>
<p>The data protection guideline published by Facebook, which is available at <a href="https://facebook.com/about/privacy/" target="blank">https://facebook.com/about/privacy/</a>, provides information about the collection, processing and use of personal data by Facebook. In addition, it is explained there what setting options Facebook offers to protect the privacy of the data subject. In addition, different configuration options are made available to allow the elimination of data transmission to Facebook. These applications may be used by the data subject to eliminate a data transmission to Facebook.</p>
<b>Cookies from Facebook</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>_fbp</td>
    <td>This cookie is used by Facebook to deliver a range of promotional products such as third-party real-time bidding.</td>
    <td>3 Months</td>
  </tr>   
 </table>
';

$twitter_policy_sample_en = '
<h3>Twitter</h3>
<p>On this website, the controller has integrated components of Twitter. Twitter is a multilingual, publicly-accessible microblogging service on which users may publish and spread so-called ‘tweets,’ e.g. short messages, which are limited to 280 characters. These short messages are available for everyone, including those who are not logged on to Twitter. The tweets are also displayed to so-called followers of the respective user. Followers are other Twitter users who follow a user\'s tweets. Furthermore, Twitter allows you to address a wide audience via hashtags, links or retweets.</p>
<p>The operating company of Twitter is Twitter International Company, One Cumberland Place, Fenian Street Dublin 2, D02 AX07, Ireland.</p>
<p>With each call-up to one of the individual pages of this Internet site, which is operated by the controller and on which a Twitter component (Twitter button) was integrated, the Internet browser on the information technology system of the data subject is automatically prompted to download a display of the corresponding Twitter component of Twitter. Further information about the Twitter buttons is available under <a href="https://about.twitter.com/en/resources/buttons" target="blank">https://about.twitter.com/en/resources/buttons</a>. During the course of this technical procedure, Twitter gains knowledge of what specific sub-page of our website was visited by the data subject. The purpose of the integration of the Twitter component is a retransmission of the contents of this website to allow our users to introduce this web page to the digital world and increase our visitor numbers.</p>
<p>If the data subject is logged in at the same time on Twitter, Twitter detects with every call-up to our website by the data subject and for the entire duration of their stay on our Internet site which specific sub-page of our Internet page was visited by the data subject. This information is collected through the Twitter component and associated with the respective Twitter account of the data subject. If the data subject clicks on one of the Twitter buttons integrated on our website, then Twitter assigns this information to the personal Twitter user account of the data subject and stores the personal data.</p>
<p>Twitter receives information via the Twitter component that the data subject has visited our website, provided that the data subject is logged in on Twitter at the time of the call-up to our website. This occurs regardless of whether the person clicks on the Twitter component or not. If such a transmission of information to Twitter is not desirable for the data subject, then he or she may prevent this by logging off from their Twitter account before a call-up to our website is made.</p>
<p>The applicable data protection provisions of Twitter may be accessed under <a href="https://twitter.com/privacy?lang=en" target="blank">https://twitter.com/privacy?lang=en</a>.</p>
<b>Cookies from Twitter</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>external_referer</td>
    <td>Collects anonymized data such as number of visits, average time spent on the site, and which pages were viewed. Purpose of personalization and improvement of the Twitter service.</td>
    <td>6 Days</td>
  </tr>
  <tr>
    <td>_twitter_sess</td>
    <tdSession ID for identification if the user is logged in to Twitter.</td>
    <td>Session</td>
  </tr>
   <tr>
    <td>guest_id</td>
    <td>Session ID for identification if the user is not logged in to Twitter.</td>
    <td>2 Years</td>
  </tr> 
  <tr>
    <td>personalization_id</td>
    <td>Serves for the purpose of ad personalization.</td>
    <td>2 Years</td>
  </tr> 
  <tr>
    <td>ct0</td>
    <td>These cookies enable us to track visitor activity from our Twitter ads on our website, and also to allow users to share content from our websites. They cookies do not provide us with any confidential information relating to your account.</td>
    <td>2 Years</td>
  </tr>    
</table>
';

$fbpixel_policy_sample_en = '
<h3>Facebook-Pixel</h3>
<p>Our website measures conversions using visitor action pixels from Facebook, Facebook Inc., 1601 S. California Ave, Palo Alto, CA 94304, USA ("Facebook").</p>
<p>These allow the behavior of site visitors to be tracked after they click on a Facebook ad to reach the provider\'s website. This allows an analysis of the effectiveness of Facebook advertisements for statistical and market research purposes and their future optimization.</p>
<p>The data collected is anonymous to us as operators of this website and we cannot use it to draw any conclusions about our users\' identities. However, the data are stored and processed by Facebook, which may make a connection to your Facebook profile and which may use the data for its own advertising purposes, as stipulated in the <a href="https://www.facebook.com/about/privacy/" target="_blank">Facebook privacy policy</a>. This will allow Facebook to display ads both on Facebook and on third-party sites. We have no control over how this data is used.</p>
<p>Check out Facebook\'s privacy policy to learn more about protecting your privacy: <a href="https://www.facebook.com/about/privacy/" target="_blank">https://www.facebook.com/about/privacy/</a>.</p>
<p>You can also deactivate the custom audiences remarketing feature in the Ads Settings section at <a href="https://www.facebook.com/ads/preferences/?entry_product=ad_settings_screen" target="_blank">https://www.facebook.com/ads/preferences/?entry_product=ad_settings_screen</a>. You will first need to log into Facebook.</p>
<b>Cookies from Facebook Pixel</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>act, c_user, datr, fr, pl, presence, sd, wd, xs</td>
    <td>Facebook uses different cookies for the identification session and analysis. These are used to detect whether you are logged in as a user on Facebook, for tracking purposes and from which URL the Share / Like feature is used.</td>
    <td>variable</td>
  </tr>   
 </table>
';

$vgwort_policy_sample_en = '
<h3>VG Wort</h3>
<p>We use "Session Cookies" from VG Wort, Munich, to measure access to texts in order to record the copy probability. Session cookies are small pieces of information that store a provider in the memory of the visitor\'s computer. In a session cookie a randomly generated unique identification number is stored, a so-called session ID. In addition, a cookie contains information about its origin and the retention period. Session cookies can not save other data. These measurements are carried out by Kantar Deutschland GmbH according to the Scalable Central Measurement Method (SZM). They help to determine the copy probability of individual texts. We do not collect personal information about cookies. </p>
<p> Many of our sites are provided with JavaScript that we use to report traffic and the collecting society Wort (VG Wort). [PLEASE CHECK if this is the case with your publisher!] § 53 UrhG warrants</p>
<p> Using our offers is also possible without cookies. Most browsers are set to automatically accept cookies. However, you can disable the storage of cookies or set your browser to be needed when cookies are sent. Privacy policy for the use of the Scalable Central Measurement System. </p>
<b> Web offers </b>
<p> Our website and our mobile website use the "Scalable Central Measurement Method" (SZM) of Kantar Deutschland GmbH for the determination of statistical parameters for determining the copy probability of texts. </p>
Anonymous measurements are taken. The access metering is performed to recognize computer systems alternatively with a session cookie or a signature that is created from various automatically transmitted information from your browser. IP addresses are only processed in anonymous form. The procedure was developed in compliance with data protection. The only goal of the procedure is to determine the copying probability of individual texts. </p>
<p> At no time will individual users be identified. Your identity always remains protected. You will not receive advertising through the system. </p>
<b>Cookies from VG Wort Pixel</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>srp</td>
    <td>The cookie of VG Wort helps to determine the copying probability of our texts and ensures the remuneration of legal claims of authors and publishers. IP addresses are only processed in anonymous form.</td>
    <td>Session</td>
  </tr>
</table>
';

$woocommerce_policy_text_en = '
<b>Cookies from WooCommerce</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>woocommerce_cart_hash</td>
    <td>This cookie is required to store the items in your cart for the order process.</td>
    <td>Session</td>
  </tr>
   <tr>
    <td>woocommerce_items_in_cart</td>
    <td>Helps WooCommerce determine when the contents of the cart / data change.</td>
    <td>Session</td>
  </tr> 
   <tr>
    <td>tk_ai</td>
    <td>Saves a randomly generated anonymous ID. This is only used within the dashboard area (/ wp-admin) and, if enabled, is used for the usage control.</td>
    <td>Session</td>
  </tr> 
	<tr>
    <td>wp_woocommerce_session_<uniqeid></td>
    <td>Contains a unique code for each customer, so he knows where to find the shopping cart data in the database for each customer.</td>
    <td>2 Days</td>
  </tr>  
   <tr>
    <td>wc_fragments_<uniqeid></td>
    <td>Saves a randomly generated anonymous ID. This is only used within the dashboard area (/ wp-admin) and, if enabled, is used for the usage control.</td>
    <td>Session</td>
  </tr>   
   <tr>
    <td>wc_cart_hash<uniqeid></td>
    <td>Saves a randomly generated anonymous ID. This is only used within the dashboard area (/ wp-admin) and, if enabled, is used for the usage control.</td>
    <td>Session</td>
  </tr>      
</table>
';

$wpml_policy_text_en = '
<b>Cookies from WPML</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>_icl_current_language</td>
    <td>Saves the language selected by the user.</td>
    <td>1 Year</td>
  </tr>
  <tr>
    <td>_icl_visitor_lang_js</td>
    <td>Saves the redirected language when changing the language.</td>
    <td>1 Year</td>
  </tr>
  <tr>
    <td>wpml_browser_redirect_test</td>
    <td>This cookie determines whether the use of cookies has been disabled in the browser.</td>
    <td>1 Year</td>
  </tr>  
   <tr>
    <td>wpml_referer_url</td>
    <td>Saves the last requested URL in the frontend.</td>
    <td>1 Year</td>
  </tr>    
 </table>
';


$dsgvoaio_policy_en = '
<b>Cookies from DSGVO AIO for WordPress</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>dsgvoaio</td>
    <td>This LocalStorage key / value stores which services the user has agreed to or not.</td>
    <td>variable</td>
  </tr>
  <tr>
    <td>_uniqueuid</td>
    <td>This LocalStorage key / value stores a generated ID so that the user\'s opt-in / opt-out actions can be documented. The ID is stored anonymously.</td>
    <td>variable</td>
  </tr>  
   <tr>
    <td>dsgvoaio_create</td>
    <td>This LocalStorage key / value stores the time when _uniqueuid was generated.</td>
    <td>variable</td>
  </tr>  
   <tr>
    <td>dsgvoaio_vgwort_disable</td>
    <td>This LocalStorage key / value stores whether the service VG word standard is allowed or not (setting of the page operator).</td>
    <td>variable</td>
  </tr>   
   <tr>
    <td>dsgvoaio_ga_disable</td>
    <td>This LocalStorage key / value stores whether the service Google Analytics Standard is allowed or not (Hiring the site operator).</td>
    <td>variable</td>
  </tr>    
 </table>
';


$wordpress_policy_sample_en = '
<h3>General Cookies</h3>
<b>Cookies from WordPress</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>wordpress_test_cookie</td>
    <td>This cookie determines whether the use of cookies has been disabled in the browser. Duration of storage: Until the end of the browser session (will be deleted when closing your internet browser).</td>
    <td>Session</td>
  </tr>
   <tr>
    <td>PHPSESSID</td>
    <td>This cookie stores your current session with respect to PHP applications, ensuring that all features of this website based on the PHP programming language are fully displayed. Duration of storage: Until the end of the browser session (will be deleted when closing your internet browser).</td>
    <td>Session</td>
  </tr> 
   <tr>
    <td>wordpress_akm_mobile</td>
    <td>These cookies are only used for the administration area of ​​WordPress.</td>
    <td>1 Year</td>
  </tr>   
   <tr>
    <td>wordpress_logged_in_akm_mobile</td>
    <td>These cookies are only used for the administration area of ​​WordPress and do not apply to other site visitors.</td>
    <td>Session</td>
  </tr>   
   <tr>
    <td>wp-settings-akm_mobile</td>
    <td>These cookies are only used for the administration area of ​​WordPress and do not apply to other site visitors.</td>
    <td>Session</td>
  </tr>   
   <tr>
    <td>wp-settings-time-akm_mobile</td>
    <td>These cookies are only used for the administration area of ​​WordPress and do not apply to other site visitors.</td>
    <td>Session</td>
  </tr>     
   <tr>
    <td>ab</td>
    <td>Is used for A / B testing of new features.</td>
    <td>Session</td>
  </tr>      
   <tr>
    <td>akm_mobile</td>
    <td>saves if the visitor wants to see the mobile version of a website.</td>
    <td>1 Day</td>
  </tr>     
</table>
[dsgvoaio_plugins]
';

$polylang_policy_text_en = '
<b>Cookies from Polylang</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>pll_language</td>
    <td>This cookie stores the language choice and the geographical origin of the user.</td>
    <td>1 Jahr</td>
  </tr>
 </table>
';

/**$woocommerce_policy_sample_en = '
<h3>WooCommerce</h3>
<p>Unsere Webseite nutzt als Grundbaustein das CMS (Content Managment System) WordPress.</p>
<p>WordPress vewendet Cookies die für den Betrieb der Webseite technisch notwendig sind.</p>
<p>Es handelt sich hier um eine lokale Installation sodass alle Cookies über unsere Domain gesetzt werden.</p>
<p>Hier finden Sie alle Information bezüglich Cookies von Wordpress: <a href="https://de.support.wordpress.com/cookies/" target="blank">https://de.support.wordpress.com/cookies/</a></p>
<b>Cookies von WordPress</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>wordpress_test_cookie</td>
    <td>Speichert eine zufällig generierte anonyme ID. Dies wird nur im Admin-Bereich verwendet und dient zur allgemeinen Analyseverfolgung.</td>
    <td>Session</td>
  </tr>
   <tr>
    <td>PHPSESSID</td>
    <td>Um Ihre individuelle Sitzung auf der Website zu identifizieren.</td>
    <td>Session</td>
  </tr> 
</table>
';**/

$shareaholic_policy_sample_en = '
<h3>Shareaholic</h3>
<p> This website contains shareaholic plugins that allow you to set bookmarks or share interesting website content. Shareaholic uses cookies. The generated data (such as time of use, browser language, and IP address) will be transmitted to Shareaholic Inc., Dogpatch Labs 1, Cambridge Center, Suite 600, Cambridge, MA 02142, and servers in the United States and others Processed countries. Please see <a href="http://www.shareaholic.com/privacy" target="blank">http://www.shareaholic.com/privacy/</a> for more information about Shareaholic\'s data processing and privacy practices maintained by Shareaholic Inc. In particular, this website contains information on the type of data processed and its purpose. Processing of the affected data by the operator of this site does not take place. By using the Shareaholic button, you agree to the data processing provided by Shareaholic Inc., at the level shown on the website <a href="http://www.shareaholic.com/privacy" target="blank">http://www.shareaholic.com/privacy/</a>. You may object to the use of the data at any time by using an opt-out cookie at <a href="http://www.shareaholic.com/privacy/choices" target="blank">http://www.shareaholic.com/privacy/choices</a>. Further details can be found on the aforementioned website of Shareaholic Inc. </p>
<b>Cookies from Shareaholic</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>XSRF-TOKEN</td>
    <td>CSRF Token - Serves Cross-Site Request Forgery Security.</td>
    <td>Session</td>
  </tr>
  <tr>  
    <td>DFTT_END_USER_PREV_BOOTSTRAPPED</td>
    <td>Boolean value indicating that the user discarded the welcome message.</td>
    <td>2 Years</td>
  </tr>
  <tr>
    <td>__hssc</td>
    <td>This cookie is used on websites created on the HubSpot platform. It is used for website analysis.</td>
    <td>30 Minutes</td>
  </tr>
  <tr>
    <td>__hssrc</td>
    <td>This cookie is used on websites created on the HubSpot platform. It is used for website analysis.</td>
    <td>Session</td>
  </tr>  
  <tr>
    <td>__hstc</td>
    <td>This cookie is used on websites created on the HubSpot platform. It is used for website analysis.</td>
    <td>2 Years</td>
  </tr>    
  <tr>
    <td>__qca</td>
    <td>Shareaholic.com uses this cookie on all pages.</td>
    <td>2,5 Years</td>
  </tr>    
  <tr>  
    <td>__d_hsutk</td>
    <td>Integration Boolean value indicating that the HubSpot UTK has been validated (if integration is enabled).</td>
    <td>30 Minutes</td>
  </tr>      
  <tr>
    <td>__cfduid</td>
    <td>Used to identify individual clients behind a shared IP address and to individually apply security settings for each client.</td>
    <td>Session</td>
  </tr>      
  <tr>
    <td>hsfirstvisit</td>
    <td>Shareaholic.com uses this cookie on all pages. It is used to save the time of the first call.</td>
    <td>10 Years</td>
  </tr>      
  <tr>
    <td>hubspotutk</td>
    <td>Integration Boolean value indicating that the HubSpot UTK has been validated (if integration is enabled).</td>
    <td>10 Years</td>
  </tr>      
  <tr>  
    <td>SnapABugVisit</td>
    <td>This cookie is linked to the SnapEngage live chat software. He identifies a new user session.</td>
    <td>Session</td>
  </tr> 
  <tr>
    <td>SnapABugHistory</td>
    <td>This cookie is linked to the SnapEngage live chat software. He identifies a visitor to allow the recording of a history.</td>
    <td>1 Year</td>
  </tr> 
  <tr>
    <td>SnapABugRef</td>
    <td>This cookie is linked to the SnapEngage live chat software. He records the landing page and origin of a visitor.</td>
    <td>1 Year</td>
  </tr> 
  <tr>
    <td>_ga</td>
    <td>This cookie uses LinkedIn, the platform for enterprise networks. This cookie is for Google Analytics.</td>
    <td>1 Day</td>
  </tr>   
  <tr>
    <td>_gid</td>
    <td>This cookie uses LinkedIn, the platform for enterprise networks. This cookie is for Google Analytics.</td>
    <td>1 Day</td>
  </tr>   
  <tr>  
  <tr>
    <td>__utma</td>
    <td>This cookie uses LinkedIn, the platform for enterprise networks. This cookie is for Google Analytics.</td>
    <td>2 Years</td>
  </tr>   
  <tr>
    <td>__utmb</td>
    <td>This cookie uses LinkedIn, the platform for enterprise networks. This cookie is for Google Analytics.</td>
    <td>1 Hour und 8 Minutes</td>
  </tr> 
  <tr>
    <td>__utmc</td>
    <td>This cookie uses LinkedIn, the platform for enterprise networks. This cookie is for Google Analytics.</td>
    <td>Session</td>
  </tr>   
  <tr>
    <td>__utmz</td>
    <td>This cookie uses LinkedIn, the platform for enterprise networks. This cookie is for Google Analytics.</td>
    <td>6 Month and 11 Hours</td>
  </tr>     
  <tr>
    <td>_shareaholic_session</td>
    <td>Shareaholic.com uses this cookie on all pages. There is a unique session ID.</td>
    <td>1 Month</td>
  </tr> 
  <tr>
    <td>c_id</td>
    <td>Shareaholic.com uses this cookie on all pages.</td>
    <td>1 Year</td>
  </tr>
</table>
';

$koko_policy_sample_en = '
<h3>Koko Analyics</h3>
<p>We use a plug-in on our website to count visitors and page views - Koko-Analytics.<br>
When the page is called, only page calls are counted.<br>
The legal basis is the legitimate interest under Art. 6(1)(f) DSGVO. Our legitimate interest is that we must know without fail whether our site is being visited and whether the plug-in is working properly.</p>
<b>Cookies from Koko Analyics</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>_koko_analytics_pages_viewed</td>
    <td>Used to determine the number of pages viewed.</td>
    <td>6 Hours</td>
  </tr>
</table>
';

$linkedin_policy_sample_en = '
<h3>LinkedIn</h3>
<p>Functions and contents of LinkedIn can be integrated within our online offer, offered by LinkedIn AG, Dammtorstraße 29-32, 20354 Hamburg, Germany. This may include content such as images, videos, or text and buttons that users use to voice their favors about the content, or the content or our posts subscribe. If the users are members of the platform LinkedIn, LinkedIn can call the o.g. Assign contents and functions to the user profiles there. LinkedIn privacy statement: <a href="https://www.linkedin.com/legal/privacy-policy"> https://www.linkedin.com/legal/privacy-policy. </a>. LinkedIn is certified under the Privacy Shield Agreement and has a guarantee to comply with European privacy legislation (<a href="https://www.privacyshield.gov/participant?id=a2zt0000000L0UZAA0&amp;status=Active">https://www.privacyshield.gov/participant?id=a2zt0000000L0UZAA0&amp;status=Active</a>).<br /> Privacy Policy: <a href="https://twitter.com/privacy">https://twitter.com/privacy</a>, opt-out: <a href="https://www.linkedin.com/psettings/guest-controls/retargeting-opt-out"> https://www.linkedin.com/psettings/guest-controls/retargeting-opt-out </a>. </p>
<b>Cookies from LinkedIn</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>lidc</td>
    <td>Used by the social networking service LinkedIn for tracking the use of embedded services.</td>
    <td>Session</td>
  </tr>
  <tr>
    <td>bcookie</td>
    <td>Used by the social networking service LinkedIn for tracking the use of embedded services.</td>
    <td>2 Years</td>
  </tr>  
  <tr>
    <td>bscookie</td>
    <td>Used by the social networking service LinkedIn for tracking the use of embedded services.</td>
    <td>2 Years</td>
  </tr>
  <tr>
    <td>BizoID</td>
    <td>LinkedIn ad analytics.</td>
    <td>179 Days</td>
  </tr>
  <tr>
    <td>UserMatchHistory</td>
    <td>LinkedIn ad analytics.</td>
    <td>179 Days</td>
  </tr>  
  <tr>
    <td>trkCode</td>
    <td>This cookie is used by LinkedIn to support the functionality of adding a panel invite labeled \'Follow Us\'.</td>
    <td>1 Year</td>
  </tr>    
  <tr>
    <td>trkInfo</td>
    <td>This cookie is used by LinkedIn to support the functionality of adding a panel invite labeled \'Follow Us\'.</td>
    <td>1 Year</td>
  </tr>   
  <tr>
    <td>li_oatml</td>
    <td>Collects information about how visitors use our site.</td>
    <td>30 Days</td>
  </tr>  
  <tr>
    <td>liap</td>
    <td>Cookie used for Sign-in with Linkedin and/or to allow for the Linkedin follow feature.</td>
    <td>90 Days</td>
  </tr>   
  <tr>
    <td>lissc</td>
    <td>Cookie used for Sign-in with Linkedin and/or to allow for the Linkedin follow feature.</td>
    <td>1 Year</td>
  </tr>    
  <tr>
    <td>spectroscopyId</td>
    <td>These cookies are set by LinkedIn for advertising purposes, including: tracking visitors so that more relevant ads can be presented, allowing users to use the \'Apply with LinkedIn\' or the \'Sign-in with LinkedIn\' functions, collecting information about how visitors use the site, etc.</td>
    <td>Session</td>
  </tr>     
</table>
';



$policy_demo_text_it = '
<h2>Dichiarazione di protezione dei dati</h2>

<p>Tempo: [dsgvo_save_date]</p>

<p>Siamo molto soddisfatti del vostro interesse per la nostra azienda. L\'utilizzo delle pagine internet è fondamentalmente possibile senza indicazione di dati personali. Tuttavia, se una persona interessata desidera usufruire di servizi speciali della nostra azienda attraverso il nostro sito web, potrebbe essere necessario trattare i dati personali. Se il trattamento dei dati personali è necessario e non esiste una base legale per tale trattamento, in genere otteniamo il consenso dell\'interessato.</p>

<p>Il trattamento dei dati personali, come ad esempio il nome, l\'indirizzo, l\'indirizzo e-mail o il numero di telefono di una persona interessata, viene sempre effettuato in conformità alla normativa di base sulla protezione dei dati e nel rispetto delle norme di protezione dei dati specifiche del paese in questione. Con la presente dichiarazione sulla protezione dei dati, la nostra azienda desidera informare il pubblico sul tipo, la portata e lo scopo dei dati personali da noi raccolti, utilizzati ed elaborati. Inoltre, la presente dichiarazione sulla protezione dei dati informa le persone interessate sui diritti di cui godono.</p>

<p>In qualità di responsabili del trattamento dei dati, abbiamo implementato numerose misure tecniche e organizzative per garantire la più completa protezione possibile dei dati personali trattati attraverso questo sito web. Ciononostante, le trasmissioni di dati su Internet possono in genere presentare lacune di sicurezza, per cui non è possibile garantire una protezione assoluta. Per questo motivo, ogni persona interessata è libera di trasmetterci i suoi dati personali con mezzi alternativi, ad esempio per telefono.</p>

<h4>Definizioni dei termini</h4>
<p>La dichiarazione sulla privacy si basa sui termini utilizzati dal legislatore europeo per le direttive e i regolamenti al momento dell\'adozione del regolamento di base sulla protezione dei dati (DS-GVO). La nostra dichiarazione sulla protezione dei dati dovrebbe essere di facile lettura e comprensione sia per il pubblico che per i nostri clienti e partner commerciali. Per garantire ciò, vorremmo spiegare in anticipo i termini utilizzati.</p>

<p>Nella presente informativa sulla privacy utilizziamo i seguenti termini, tra gli altri:</p>

<ul>
<li><h4>a) Dati personali</h4>
<p>Dati personali: qualsiasi informazione relativa ad una persona fisica identificata o identificabile (di seguito "interessato"). Per persona fisica identificabile si intende una persona fisica che può essere identificata, direttamente o indirettamente, in particolare mediante riferimento ad un identificatore quale il nome, un numero di identificazione, un dato identificativo, un dato relativo all\'ubicazione, un identificatore online o uno o più elementi specifici caratteristici dell\'identità fisica, fisiologica, genetica, psichica, economica, culturale o sociale della persona fisica.</p>I dati personali sono qualsiasi informazione concernente una persona fisica identificata o identificabile, di seguito denominata "persona interessata".</p>
</li>
<li><h4>b) Persona interessata</h4>
<p>Persona interessata è qualsiasi persona fisica identificata o identificabile i cui dati personali sono trattati dal titolare del trattamento.</p>
</li>
<li><h4>c) Elaborazione</h4>
<p>Il trattamento è qualsiasi operazione o insieme di operazioni, compiute con o senza l\'ausilio di mezzi automatizzati, concernenti dati personali, come la raccolta, la registrazione, l\'organizzazione, l\'organizzazione, l\'archiviazione, la conservazione, l\'adattamento o la modifica, l\'estrazione, la consultazione, l\'uso, la diffusione, la trasmissione, la diffusione o la messa a disposizione in altro modo, l\'allineamento o l\'interconnessione, la restrizione, la cancellazione o la distruzione.</p>
</li>
<li><h4>d) Restrizione dell\'elaborazione</h4>
<p>Restrizione del trattamento è la marcatura dei dati personali memorizzati al fine di limitarne il trattamento in futuro.</p>
</li>
<li><h4>e) Profilatura</h4>
<p>Profiling è qualsiasi trattamento automatizzato di dati personali che consiste nell\'utilizzare tali dati personali per valutare determinati aspetti personali relativi a una persona fisica, in particolare per analizzare o prevedere aspetti relativi all\'esecuzione del lavoro, alla situazione economica, allo stato di salute, alle preferenze personali, agli interessi, all\'affidabilità, al comportamento, al luogo o ai movimenti di tale persona fisica.</p>
</li>
<li><h4>f) Pseudonimizzazione</h4>
<p>Pseudonimizzazione è il trattamento dei dati personali in modo tale che i dati personali non possano più essere attribuiti a un determinato soggetto senza la necessità di informazioni supplementari, a condizione che tali informazioni supplementari siano conservate separatamente e siano soggette a misure tecniche e organizzative che garantiscano che i dati personali siano trattati in conformità agli scopi per i quali sono stati raccolti.</p>
</li>
<li><h4>d) Restrizione dell\'elaborazione</h4>
<p>Restrizione del trattamento è la marcatura dei dati personali memorizzati al fine di limitarne il trattamento in futuro.</p>
</li>
<li><h4>e) Profilatura</h4>
<p>Profiling è qualsiasi trattamento automatizzato di dati personali che consiste nell\'utilizzare tali dati personali per valutare determinati aspetti personali relativi a una persona fisica, in particolare per analizzare o prevedere aspetti relativi all\'esecuzione del lavoro, alla situazione economica, allo stato di salute, alle preferenze personali, agli interessi, all\'affidabilità, al comportamento, al luogo o ai movimenti di tale persona fisica.</p>
</li>
<li><h4>f) Pseudonimizzazione</h4>
<p>Pseudonimizzazione è il trattamento dei dati personali in modo tale che i dati personali non possano più essere attribuiti a un determinato soggetto senza la necessità di informazioni supplementari, a condizione che tali informazioni supplementari siano conservate separatamente e siano soggette a misure tecniche e organizzative che garantiscano che i dati personali non siano attribuiti a una persona fisica identificata o identificabile.</p>
</li>
<li><h4>g) Controllore o responsabile del controllore</h4>
<p>responsabile o responsabile del trattamento è la persona fisica o giuridica, l\'autorità pubblica, l\'ente o qualsiasi altro organismo che da solo o insieme ad altri determina le finalità e le modalità del trattamento dei dati personali Qualora le finalità e i mezzi di tale trattamento siano determinati dal diritto dell\'Unione o dalla legislazione degli Stati membri, il responsabile del trattamento o i criteri specifici per la sua designazione possono essere stabiliti dal diritto dell\'Unione o dalla legislazione degli Stati membri.</p>
</li>
<li><h4>h) Lavoratori a contratto</h4>
<p>Il responsabile del trattamento è una persona fisica o giuridica, un\'autorità pubblica, un ente o un altro organismo che tratta dati personali per conto del responsabile del trattamento.</p>
</li>
<li><h4>i) Ricevitore</h4>
<p>Il destinatario è una persona fisica o giuridica, un\'autorità pubblica, un ente o un altro organismo al quale vengono comunicati dati personali, indipendentemente dal fatto che si tratti o meno di terzi. Tuttavia, le autorità che possono ricevere dati personali nell\'ambito di un mandato d\'indagine specifico ai sensi del diritto dell\'Unione o nazionale non sono considerate come destinatari.</p>
</li>
<li><h4>j) Terzo</h4>
<p>Terzo: qualsiasi persona fisica o giuridica, autorità pubblica, ente o organismo diverso dall\'interessato, dal responsabile del trattamento, dall\'incaricato del trattamento e dalle persone che, sotto la diretta autorità del responsabile del trattamento o dell\'incaricato del trattamento, sono autorizzate a trattare i dati personali.</p>
</li>
<li><h4>k) Consenso</h4>
<p>Consenso significa qualsiasi espressione libera, specifica e consapevole della volontà dell\'interessato in modo informato e inequivocabile, sotto forma di dichiarazione o di qualsiasi altro atto positivo inequivocabile con il quale l\'interessato esprime il proprio consenso al trattamento dei dati personali che lo riguardano.</p>
</li>
</ul>


<h4>Nome e indirizzo del controllore</h4>
<p>La persona responsabile ai sensi del regolamento di base sulla protezione dei dati, di altre leggi sulla protezione dei dati applicabili negli Stati membri dell\'Unione europea e di altre disposizioni in materia di protezione dei dati è:</p>

<p>[company]</p>
<p>[owner]</p>
<p>[adress]</p>
<p>[zip] [city]</p>
<p>[country]</p>
<p>[phone]</p>
<p>[mail]</p>
<p>[ust]</p>


<h4>Cookies / SessionStorage / LocalStorage</h4>
<p>Le pagine internet utilizzano in parte i cosiddetti cookie, LocalStorage e SessionStorage. Questo serve a rendere la nostra offerta più facile da usare, efficace e sicura. Local Storage and SessionStorage è una tecnologia con la quale il vostro browser memorizza i dati sul vostro computer o dispositivo mobile. I cookie sono file di testo che vengono memorizzati e salvati su un sistema informatico tramite un browser internet. È possibile impedire l\'uso di cookie, LocalStorage e SessionStorage effettuando l\'impostazione appropriata nel proprio browser.</p>

<p>Numerosi siti web e server utilizzano i cookie. Molti cookie contengono un cosiddetto cookie ID. L\'ID del cookie è un identificatore univoco del cookie. Si tratta di una stringa di caratteri che può essere utilizzata per assegnare le pagine Internet e i server al browser Internet specifico in cui è stato memorizzato il cookie. Ciò consente alle pagine Internet e ai server visitati di distinguere il singolo browser dell\'interessato da altri browser Internet che contengono altri cookie. Un determinato browser Internet può essere riconosciuto e identificato dal cookie ID.</p>

<p>L\'uso dei cookies può fornire agli utenti di questo sito web servizi di più facile utilizzo, che non sarebbero possibili senza l\'impostazione dei cookies.</p>

<p>Con un cookie, le informazioni e le offerte sul nostro sito web possono essere ottimizzate nell\'interesse dell\'utente. Come già detto, i cookies ci permettono di riconoscere gli utenti del nostro sito web. Lo scopo di questo riconoscimento è quello di facilitare l\'utilizzo del nostro sito web da parte degli utenti. Ad esempio, l\'utente di un sito web che utilizza i cookie non deve inserire i propri dati di accesso ogni volta che visita il sito web, perché ciò viene fatto dal sito web e dal cookie memorizzato nel sistema informatico dell\'utente. Un altro esempio è il cookie di un carrello della spesa nel negozio online. Il negozio online ricorda gli articoli che un cliente ha messo nel carrello virtuale tramite un cookie.</p>

<p>L\'interessato può impedire in qualsiasi momento l\'impostazione dei cookie da parte del nostro sito web mediante una corrispondente impostazione del browser Internet utilizzato e quindi opporsi in modo permanente all\'impostazione dei cookie. Inoltre, i cookie già impostati possono essere cancellati in qualsiasi momento tramite un browser Internet o altri programmi software. Questo è possibile in tutti i comuni browser Internet. Se l\'interessato disattiva l\'impostazione dei cookie nel browser Internet utilizzato, è possibile che non tutte le funzioni del nostro sito web possano essere utilizzate appieno.</p>

<h4>Registrazione di dati e informazioni generali</h4>
<p>Il sito web raccoglie una serie di dati e informazioni generali ogni volta che un soggetto interessato o un sistema automatizzato accede al sito web. Questi dati e informazioni generali sono memorizzati nei file di log del server. I (1) tipi di browser e le versioni utilizzate, (2) il sistema operativo utilizzato dal sistema di accesso, (3) il sito web dal quale un sistema di accesso accede al nostro sito web (il cosiddetto referrer), (4) i sotto-siti web a cui si accede tramite un sistema di accesso sul nostro sito web, (5) la data e l\'ora di un accesso al sito Internet, (6) un indirizzo di protocollo Internet (indirizzo IP), (7) il fornitore di servizi Internet del sistema di accesso e (8) altri dati e informazioni simili che servono a prevenire pericoli in caso di attacchi ai nostri sistemi informatici. </p>

<p>Quando si utilizzano questi dati e informazioni generali non si traggono conclusioni sulla persona interessata. Queste informazioni sono piuttosto necessarie per (1) fornire correttamente i contenuti del nostro sito web, (2) ottimizzare i contenuti del nostro sito web e la relativa pubblicità, (3) garantire la funzionalità permanente dei nostri sistemi informatici e della tecnologia del nostro sito web, nonché (4) fornire alle forze dell\'ordine in caso di attacco informatico le informazioni necessarie per il perseguimento penale. Questi dati e informazioni raccolte in forma anonima vengono quindi da noi valutati da un lato statisticamente e dall\'altro con l\'obiettivo di aumentare la protezione e la sicurezza dei dati nella nostra azienda per garantire, in ultima analisi, un livello di protezione ottimale dei dati personali da noi trattati. I dati anonimi dei file di log del server sono memorizzati separatamente da tutti i dati personali forniti dall\'interessato.</p>

<h4>Registrazione sul nostro sito web</h4>
<p>L\'interessato ha la possibilità di registrarsi sul sito web della società responsabile del trattamento.</p>


<h4>Registrazione sul nostro sito web</h4>
<p>L\'interessato ha la possibilità di registrarsi sul sito internet del titolare del trattamento fornendo i propri dati personali. I dati personali trasmessi al titolare del trattamento sono specificati nel modulo di registrazione. I dati personali inseriti dall\'interessato sono raccolti e conservati esclusivamente per uso interno del titolare del trattamento e per le proprie finalità. Il titolare del trattamento può provvedere al trasferimento ad uno o più incaricati del trattamento, come ad esempio un fornitore di servizi di inoltro pacchi, che utilizzerà i dati personali esclusivamente per uso interno imputabile al titolare.</p>

<p>Con la registrazione sul sito web del titolare del trattamento, l\'indirizzo IP assegnato all\'interessato dall\'Internet Service Provider (ISP), vengono salvati anche la data e l\'ora della registrazione. La conservazione di questi dati viene effettuata in considerazione del fatto che questo è l\'unico modo per prevenire l\'uso improprio dei nostri servizi e, se necessario, per consentire il chiarimento dei reati commessi. In questo senso, la memorizzazione di questi dati è necessaria per proteggere il responsabile del trattamento. In linea di principio, questi dati non saranno trasmessi a terzi, a meno che non vi sia un obbligo legale in tal senso o che la trasmissione di tali dati non serva ai fini di un\'azione penale.</p>

<p>La registrazione dell\'interessato in caso di comunicazione volontaria di dati personali ha lo scopo, da parte del titolare del trattamento, di offrire all\'interessato contenuti o servizi che, per loro stessa natura, possono essere offerti solo agli utenti registrati. Le persone registrate sono libere di modificare in qualsiasi momento i dati personali forniti in fase di registrazione o di farli cancellare completamente dal database del titolare del trattamento.</p>

<p>Il responsabile del trattamento fornisce all\'interessato, su richiesta, informazioni sui dati personali che lo riguardano, in qualsiasi momento. Inoltre, il titolare del trattamento è tenuto a correggere o cancellare i dati personali su richiesta o comunicazione dell\'interessato, salvo diversa disposizione di legge. In questo contesto, l\'intero personale del titolare del trattamento è a disposizione dell\'interessato in qualità di referente.</p>

<h4>Possibilità di contatto tramite il sito Internet</h4>
<p>A causa delle disposizioni di legge, il sito Internet contiene informazioni che consentono un rapido contatto elettronico con la nostra azienda e una comunicazione diretta con noi, che include anche un indirizzo generale per la cosiddetta posta elettronica (indirizzo e-mail). Se un interessato contatta il titolare del trattamento per e-mail o tramite un modulo di contatto, i dati personali trasmessi dall\'interessato vengono automaticamente memorizzati. Tali dati personali trasmessi volontariamente dall\'interessato al titolare del trattamento sono conservati ai fini dell\'elaborazione o del contatto con l\'interessato. Questi dati personali non vengono comunicati a terzi.</p>

<h4>Funzione di commento nel blog sul sito web</h4>
<p>Offriamo agli utenti la possibilità di lasciare commenti individuali sui singoli post del blog su un blog che si trova sul sito web del titolare del trattamento. Un blog è un portale gestito su un sito Internet, di solito aperto al pubblico, dove una o più persone, chiamate blogger o web-blogger, possono pubblicare articoli o scrivere pensieri nei cosiddetti blog post. I blogposts possono essere commentati da terzi.</p>
<p>Se una persona interessata lascia un commento nel blog pubblicato su questo sito web, le informazioni sull\'ora del commento e sul nome utente (pseudonimo) scelto dalla persona interessata saranno memorizzate e pubblicate in aggiunta ai commenti lasciati dalla persona interessata. Inoltre, viene registrato anche l\'indirizzo IP assegnato alla persona interessata dall\'Internet Service Provider (ISP). Questa memorizzazione dell\'indirizzo IP viene effettuata per motivi di sicurezza e nel caso in cui l\'interessato violi i diritti di terzi o pubblichi contenuti illegali inviando un commento. La conservazione di questi dati personali viene effettuata da.</p>

<h4>Gravatar</h4>
<p>Per i commenti viene utilizzato il servizio Gravatar di Auttomatic. Gravatar corrisponde al tuo indirizzo e-mail e - se sei registrato lì - visualizza la tua immagine dell\'avatar accanto al commento. Se non si è registrati, non verrà visualizzata alcuna immagine. Si prega di notare che tutti gli utenti WordPress registrati sono automaticamente registrati con Gravatar. Dettagli su Gravatar: <a href="https://de.gravatar.com" target="blank">https://de.gravatar.com</a></p>

<h4>Routine di cancellazione e blocco dei dati personali</h4>
<p>Il responsabile del trattamento tratta e memorizza i dati personali relativi all\'interessato solo per il tempo necessario a conseguire lo scopo per il quale i dati sono memorizzati o se previsto dalle direttive e dai regolamenti europei o da qualsiasi altra legge o regolamento cui è soggetto il responsabile del trattamento.</p> Il responsabile del trattamento tratta e memorizza i dati personali relativi all\'interessato solo per il tempo necessario a conseguire lo scopo per il quale i dati sono memorizzati o se previsto dalle direttive e dai regolamenti europei o da qualsiasi altra legge o regolamento cui è soggetto il responsabile del trattamento.</p> Il responsabile del trattamento tratta e memorizza i dati personali relativi all\'interessato solo per il tempo necessario a conseguire lo scopo per il quale i dati sono memorizzati o se previsto dalle direttive e dai regolamenti europei o da qualsiasi altra legge o regolamento cui sono soggetti i dati.</p> Il responsabile del trattamento tratta e memorizza i dati personali relativi all\'interessato solo per il tempo necessario.</p>

<p>Se lo scopo della conservazione cessa di essere valido o se scade un periodo di conservazione prescritto dalla Direttiva Europea e dal Regolamento Giver o da qualsiasi altro legislatore competente, i dati personali saranno bloccati o cancellati in modo sistematico e in conformità con le disposizioni di legge.</p>

<h4>Diritti della persona interessata</h4>
<ul>
<li><h4>a) Diritto di conferma</h4>
<p>Ogni interessato ha il diritto di ottenere dal titolare del trattamento la conferma dell\'esistenza o meno di dati personali che lo riguardano. L\'interessato che desideri esercitare tale diritto di conferma può rivolgersi in qualsiasi momento a un dipendente del titolare del trattamento.</p>
</li>
<li><h4>b) Diritto all\'informazione</h4>
<p>Ogni persona interessata dal trattamento dei dati personali ha il diritto, concesso dalle Direttive e dai Regolamenti Europei, di ottenere in qualsiasi momento e gratuitamente dal titolare del trattamento informazioni sui dati personali memorizzati in relazione ad essa e una copia degli stessi. Inoltre, la direttiva europea e il regolamento Giver ha concesso all\'interessato l\'accesso alle seguenti informazioni:</p>
<p>Se l\'interessato desidera esercitare tale diritto di accesso, può rivolgersi in qualsiasi momento a un dipendente del titolare del trattamento.</p>
</li>

<li><h4>c) Diritto di rettifica</h4>
<p>Ogni persona interessata dal trattamento dei dati personali ha il diritto, concesso dal legislatore europeo, di chiedere l\'immediata rettifica dei dati personali errati che la riguardano. Inoltre, l\'interessato ha il diritto di richiedere la compilazione di dati personali incompleti, anche mediante una dichiarazione complementare, in considerazione delle finalità del trattamento.</p>
<p>Se l\'interessato desidera esercitare tale diritto di rettifica, può rivolgersi in qualsiasi momento a un membro del personale del titolare del trattamento.</p>
</li>
<li>
<h4>d) Diritto di recesso (diritto all\'oblio)</h4>
<p>Ogni persona interessata dal trattamento dei dati personali ha il diritto, concesso dalle Direttive e dai Regolamenti europei, di ottenere dal titolare del trattamento l\'immediata cancellazione dei dati personali che la riguardano, qualora si verifichi una delle seguenti cause e il trattamento non sia necessario:</p>
<p>Se l\'interessato desidera esercitare tale diritto di accesso, può rivolgersi in qualsiasi momento a un dipendente del titolare del trattamento.</p>
</li>

<li><h4>c) Diritto di rettifica</h4>
<p>Ogni persona interessata dal trattamento dei dati personali ha il diritto, concesso dal legislatore europeo, di chiedere l\'immediata rettifica dei dati personali errati che la riguardano. Inoltre, l\'interessato ha il diritto di richiedere la compilazione di dati personali incompleti, anche mediante una dichiarazione complementare, in considerazione delle finalità del trattamento.</p>
<p>Se l\'interessato desidera esercitare tale diritto di rettifica, può rivolgersi in qualsiasi momento a un membro del personale del titolare del trattamento.</p>
</li>
<li>
<h4>d) Diritto di recesso (diritto all\'oblio)</h4>
<p>Ogni persona interessata dal trattamento dei dati personali ha il diritto, concesso dalle Direttive e dai Regolamenti europei, di ottenere dal titolare del trattamento l\'immediata cancellazione dei dati personali che la riguardano, qualora si verifichi una delle seguenti cause e il trattamento non sia necessario:</p>
<p>Se l\'interessato desidera esercitare tale diritto di accesso, può rivolgersi in qualsiasi momento a un dipendente del titolare del trattamento.</p>
</li>
<li><h4>c) Diritto di rettifica</h4>
<p>Ogni persona interessata dal trattamento dei dati personali ha il diritto, concesso dal legislatore europeo, di chiedere l\'immediata rettifica dei dati personali errati che la riguardano. Inoltre, l\'interessato ha il diritto di richiedere la compilazione di dati personali incompleti, anche mediante una dichiarazione complementare, in considerazione delle finalità del trattamento.</p>
<p>Se l\'interessato desidera esercitare tale diritto di rettifica, può rivolgersi in qualsiasi momento a un membro del personale del titolare del trattamento.</p>
</li>
<li>
<h4>d) Diritto di recesso (diritto all\'oblio)</h4>
<p>Ogni persona interessata dal trattamento dei dati personali ha il diritto, concesso dalle Direttive e dai Regolamenti europei, di ottenere dal titolare del trattamento l\'immediata cancellazione dei dati personali che la riguardano, qualora si verifichi una delle seguenti cause e il trattamento non sia necessario:</p>
<ul>
<li>I dati personali sono stati raccolti o comunque trattati per scopi per i quali non sono più necessari.</li>
<li>L\'interessato revoca il consenso su cui si basava il trattamento ai sensi dell\'articolo 6, paragrafo 1, lettera a), dell\'LPD o dell\'articolo 9, paragrafo 2, lettera a), dell\'LPD e non esiste un\'altra base giuridica per il trattamento.</li>
<li>L\'interessato solleva un\'obiezione al trattamento ai sensi dell\'articolo 21, paragrafo 1, del regolamento di esenzione per categoria e non vi sono motivi imperativi legittimi per il trattamento, oppure l\'interessato solleva un\'obiezione al trattamento ai sensi dell\'articolo 21, paragrafo 2, del regolamento di esenzione per categoria.</li>
<li>I dati personali sono stati trattati in modo illecito.</li>
<li>La cancellazione dei dati personali è necessaria per adempiere a un obbligo legale ai sensi del diritto dell\'Unione o della legislazione degli Stati membri a cui il responsabile del trattamento è soggetto.</li>
<li>I dati personali sono stati raccolti in relazione ai servizi della società dell\'informazione offerti ai sensi dell\'art. 8 comma 1 del DS-GVO.</li>
</ul>
<p>Se si applica uno dei motivi di cui sopra e l\'interessato desidera che i dati personali memorizzati vengano cancellati, può rivolgersi in qualsiasi momento a un dipendente del titolare del trattamento. Il dipendente si assicurerà che la richiesta di cancellazione sia soddisfatta immediatamente.</p>
<p>Se i dati personali sono stati resi pubblici e se la nostra società, in qualità di titolare del trattamento, è obbligata a cancellare i dati personali ai sensi dell\'art. 17 cpv. 1 DS-GVO, adotteremo misure ragionevoli, anche tecniche, tenendo conto della tecnologia disponibile e dei costi di implementazione, per informare gli altri titolari che trattano i dati personali pubblicati che l\'interessato ha richiesto a questi altri titolari di cancellare tutti i link a questi dati personali o copie o repliche di questi dati personali, a meno che il trattamento non sia necessario. In singoli casi, il dipendente prenderà le misure necessarie.</p>
</li>

<li><h4>e) Diritto di limitare l\'elaborazione</h4>
<p>Ogni persona interessata al trattamento dei dati personali ha il diritto, concesso dal legislatore europeo, di ottenere dal responsabile del trattamento la limitazione del trattamento se è soddisfatta una delle seguenti condizioni:</p>

<ul>
<li>L\'esattezza dei dati personali è contestata dall\'interessato, per un periodo di tempo che consente al responsabile del trattamento di verificare l\'esattezza dei dati personali.</li>
<li>Il trattamento è illecito, l\'interessato si rifiuta di far cancellare i suoi dati personali e chiede invece che l\'uso dei suoi dati personali sia limitato.</li>
<li>Il titolare del trattamento non necessita più dei dati personali per le finalità del trattamento, ma l\'interessato ne ha bisogno per esercitare o difendere i propri diritti.</li>
<li>L\'interessato ha presentato un\'obiezione al trattamento ai sensi dell\'articolo 21, paragrafo 1, della LPD e non è ancora chiaro se le ragioni legittime del responsabile del trattamento siano superiori a quelle dell\'interessato.</li>

</ul>
<p>Se una delle condizioni di cui sopra è soddisfatta e l\'interessato desidera richiedere la limitazione dei dati personali memorizzati, può contattare in qualsiasi momento un dipendente del responsabile del trattamento. Il dipendente inizierà la restrizione dell\'elaborazione.</p>
</li>
<li><h4>f) Diritto alla trasferibilità dei dati</h4>
<p>Ogni interessato al trattamento dei dati personali ha il diritto, riconosciuto dalle direttive e dai regolamenti europei, di ricevere i dati personali che lo riguardano e che sono stati messi a disposizione di un responsabile del trattamento dall\'interessato in un formato strutturato, comune e leggibile a macchina. Ha inoltre il diritto di ottenere che tali dati siano comunicati ad un altro responsabile del trattamento senza che vi siano ostacoli da parte del responsabile del trattamento al quale i dati personali sono stati messi a disposizione, a condizione che il trattamento sia basato sul consenso ai sensi dell\'art. 6 comma 1 lett. a LPD o dell\'art. 9 comma 2 lett. a LPD o su un contratto ai sensi dell\'art. 6 comma 1 lett. b LPD, e che il trattamento sia effettuato con l\'ausilio di procedure automatizzate, a meno che il trattamento sia necessario per l\'esecuzione di un compito di interesse pubblico o per l\'esercizio di pubblici poteri attribuiti al responsabile del trattamento.</p>
<p>Inoltre, nell\'esercizio del diritto alla trasmissione dei dati ai sensi dell\'art. 20 cpv. 1 della DS-GVO, l\'interessato ha il diritto di ottenere che i dati personali siano trasferiti direttamente da un responsabile ad un altro, nella misura in cui ciò sia tecnicamente possibile e a condizione che ciò non leda i diritti e le libertà di altre persone.</p>
<p>Per far valere il diritto alla trasferibilità dei dati, l\'interessato può contattarci in qualsiasi momento.</p>
</li>


<li>
<h4>(g) Diritto di ricorso</h4>
<p>Ogni persona interessata dal trattamento dei dati personali ha il diritto, riconosciuto dal legislatore europeo, di opporsi in qualsiasi momento, per motivi derivanti dalla sua particolare situazione, al trattamento dei dati personali che la riguardano effettuato ai sensi dell\'articolo 6, paragrafo 1, lettere e) o f), dell\'LPD. Ciò vale anche per la profilazione basata su queste disposizioni.</p>
<p>In caso di contestazione, non tratteremo più i dati personali a meno che non possiamo dimostrare motivi legittimi e convincenti per un trattamento che superi gli interessi, i diritti e le libertà della persona interessata, o a meno che il trattamento non serva a far valere, esercitare o difendere rivendicazioni legali.</p>
<p>Nel caso in cui trattiamo i dati personali a scopo di marketing diretto, l\'interessato ha il diritto di opporsi in qualsiasi momento al trattamento dei dati personali ai fini di tale marketing. Ciò vale anche per la profilazione, nella misura in cui è collegata a tale marketing diretto. Se l\'interessato si oppone al trattamento per finalità di marketing diretto, non tratteremo più i dati personali per tali finalità.</p>
<p>Inoltre, l\'interessato ha il diritto di opporsi, per motivi connessi alla sua particolare situazione, al trattamento di dati personali che lo riguardano effettuato a fini di ricerca scientifica o storica o a fini statistici, ai sensi dell\'articolo 89, paragrafo 1, dell\'LPD, salvo che tale trattamento sia necessario per l\'esecuzione di un compito di interesse pubblico.</p>
<p>Per esercitare il diritto di opposizione, l\'interessato può rivolgersi direttamente a qualsiasi dipendente. L\'interessato è inoltre libero di esercitare il proprio diritto di opposizione in relazione all\'utilizzo dei servizi della società dell\'informazione, nonostante la direttiva 2002/58/CE, mediante procedure automatizzate che comportano specifiche tecniche.</p>
</li>
<li><h4>h) Decisioni automatizzate in singoli casi, compresa la profilazione</h4>
<p>Ogni persona interessata dal trattamento dei dati personali ha il diritto, come concesso dalle direttive e dai regolamenti europei, di non essere soggetta a una decisione basata esclusivamente su un trattamento automatizzato, inclusa la profilazione, che produce effetti giuridici che la riguardano o che la riguardano in modo significativo in modo analogo, a condizione che la decisione (1) non sia necessaria per la conclusione o l\'esecuzione di un contratto tra l\'interessato e il responsabile del trattamento, o (2) sia autorizzata dalla legislazione dell\'Unione o nazionale cui è soggetto il responsabile del trattamento e che tale legislazione preveda adeguate garanzie dei diritti e delle libertà e dei legittimi interessi dell\'interessato, o (3) sia adottata con il consenso esplicito dell\'interessato. </p>
<p>Se la decisione è (1) necessaria per la conclusione o l\'esecuzione di un contratto tra l\'interessato e il responsabile del trattamento o (2) con il consenso esplicito dell\'interessato, adotteremo misure ragionevoli per salvaguardare i diritti e le libertà e gli interessi legittimi dell\'interessato, compreso almeno il diritto di ottenere l\'intervento del responsabile del trattamento, di esprimere il suo punto di vista e di impugnare la decisione.</p>
<p>Se l\'interessato desidera esercitare i diritti relativi alle decisioni automatizzate, può rivolgersi in qualsiasi momento a un dipendente del titolare del trattamento.</p>
</li>
<li><h4>i) Diritto di revoca del consenso alla protezione dei dati personali</h4>
<p>Ogni persona interessata dal trattamento dei dati personali ha il diritto di revocare il proprio consenso al trattamento dei dati personali in qualsiasi momento, come concesso dalla direttiva europea e dal regolamento Giver.</p>
<p>Se l\'interessato desidera esercitare il diritto di revocare il proprio consenso, può rivolgersi in qualsiasi momento a un dipendente del titolare del trattamento.</p>
</li>

</ul>
<h4>Base legale di elaborazione</h4>
<p>Art. 6 Ilit. a DS-GVO serve alla nostra azienda come base legale per le operazioni di elaborazione per le quali otteniamo il consenso per uno specifico scopo di elaborazione. Se il trattamento dei dati personali è necessario per l\'esecuzione di un contratto di cui l\'interessato è parte, come ad esempio nel caso di operazioni di trattamento necessarie per la consegna della merce o per la fornitura di un altro servizio o corrispettivo, il trattamento si basa sull\'art. 6 Ilit. b DS-GVO. Lo stesso vale per le operazioni di elaborazione necessarie per l\'attuazione di misure precontrattuali, ad esempio in caso di richieste di informazioni sui nostri prodotti o servizi. Se la nostra azienda è soggetta ad un obbligo legale che rende necessario il trattamento dei dati personali, ad esempio per adempiere ad obblighi fiscali, il trattamento si basa sull\'art. 6 Ilit. c DS-GVO. In rari casi, il trattamento dei dati personali può essere necessario per tutelare gli interessi vitali della persona interessata o di un\'altra persona fisica. Questo accadrebbe, ad esempio, se un visitatore della nostra azienda fosse ferito e il suo nome, l\'età, i dati dell\'assicurazione sanitaria o altre informazioni vitali dovessero essere trasmessi a un medico, a un ospedale o a terzi. In questo caso, il trattamento si baserebbe sull\'art. 6 Ilit. d DS-GVO.
Infine, le operazioni di elaborazione potrebbero essere basate sull\'art. 6 lett. f DS-GVO. Le operazioni di trattamento che non rientrano in nessuna delle suddette basi legali si basano su questa base legale se il trattamento è necessario per salvaguardare un interesse legittimo della nostra società o di terzi, a condizione che non prevalgano gli interessi, i diritti e le libertà fondamentali dell\'interessato. Siamo autorizzati ad effettuare tali operazioni di trattamento, in particolare perché sono state specificamente menzionate dal legislatore europeo. A tale riguardo, ha ritenuto che si possa presumere un interesse legittimo se la persona interessata è un cliente del responsabile del trattamento (considerando 47 frase 2 DS-GVO).
</p>

<p>interessi legittimi nel trattamento perseguito dal titolare o da un terzo.
Se il trattamento dei dati personali si basa sull\'articolo 6 Ilit. f DS-GVO, il nostro legittimo interesse è quello di svolgere le nostre attività commerciali a beneficio del benessere di tutti i nostri dipendenti e dei nostri azionisti.
</p>
<h4> Durata di conservazione dei dati personali</h4>
<p>Il criterio per la durata della conservazione dei dati personali è il rispettivo periodo di conservazione legale. Alla scadenza di questo periodo, i dati corrispondenti vengono regolarmente cancellati, a condizione che non siano più necessari per l\'adempimento del contratto o per l\'avvio di un contratto.</p>

<p>Prescrizioni legali o contrattuali sul conferimento dei dati personali; necessità per la conclusione del contratto; obbligo dell\'interessato di fornire i dati personali; possibili conseguenze del mancato conferimento dei dati.
Vi informiamo che il conferimento dei dati personali è in parte obbligatorio per legge (ad es. norme fiscali) o può anche derivare da norme contrattuali (ad es. informazioni sul partner contrattuale).
A volte può essere necessario per la conclusione di un contratto che un interessato ci fornisca dati personali, che devono essere successivamente trattati da noi. Ad esempio, l\'interessato è obbligato a fornirci i dati personali se la nostra società stipula un contratto con lui/lei. Il mancato conferimento dei dati personali comporterebbe l\'impossibilità di concludere il contratto con l\'interessato.
Prima che l\'interessato renda disponibili i dati personali, deve contattare uno dei nostri dipendenti. Il nostro collaboratore informerà di volta in volta l\'interessato se il conferimento dei dati personali è obbligatorio per legge o per contratto o è necessario per la conclusione del contratto, se vi è un obbligo di fornire i dati personali e quali sarebbero le conseguenze in caso di mancato conferimento dei dati personali.
</p>

<h4>Esistenza di un processo decisionale automatizzato</h4>
<p>In qualità di azienda responsabile non utilizziamo il processo decisionale automatico o la profilazione.</p>
';
/**
$policy_demo_text_it = '





</ul>
<h4>Base legale di elaborazione</h4
<p>Art. 6 Ilit. a DS-GVO serve alla nostra azienda come base legale per le operazioni di elaborazione per le quali otteniamo il consenso per uno specifico scopo di elaborazione. Se il trattamento dei dati personali è necessario per l\'esecuzione di un contratto di cui l\'interessato è parte, come ad esempio nel caso di operazioni di trattamento necessarie per la consegna della merce o per la fornitura di un altro servizio o corrispettivo, il trattamento si basa sull\'art. 6 Ilit. b DS-GVO. Lo stesso vale per le operazioni di elaborazione necessarie per l\'attuazione di misure precontrattuali, ad esempio in caso di richieste di informazioni sui nostri prodotti o servizi. Se la nostra azienda è soggetta ad un obbligo legale che rende necessario il trattamento dei dati personali, ad esempio per adempiere ad obblighi fiscali, il trattamento si basa sull\'art. 6 Ilit. c DS-GVO. In rari casi, il trattamento dei dati personali può essere necessario per tutelare gli interessi vitali della persona interessata o di un\'altra persona fisica. Questo accadrebbe, ad esempio, se un visitatore della nostra azienda fosse ferito e il suo nome, l\'età, i dati dell\'assicurazione sanitaria o altre informazioni vitali dovessero essere trasmessi a un medico, a un ospedale o a terzi. In questo caso, il trattamento si baserebbe sull\'art. 6 Ilit. d DS-GVO.
Infine, le operazioni di elaborazione potrebbero essere basate sull\'art. 6 lett. f DS-GVO. Le operazioni di trattamento che non rientrano in nessuna delle suddette basi legali si basano su questa base legale se il trattamento è necessario per salvaguardare un interesse legittimo della nostra società o di terzi, a condizione che non prevalgano gli interessi, i diritti e le libertà fondamentali dell\'interessato. Siamo autorizzati ad effettuare tali operazioni di trattamento, in particolare perché sono state specificamente menzionate dal legislatore europeo. A tale riguardo, ha ritenuto che si possa presumere un interesse legittimo se la persona interessata è un cliente del responsabile del trattamento (considerando 47 frase 2 DS-GVO).
</p>

<p>interessi legittimi nel trattamento perseguito dal titolare o da un terzo.
Se il trattamento dei dati personali si basa sull\'articolo 6 Ilit. f DS-GVO, il nostro legittimo interesse è quello di svolgere le nostre attività commerciali a beneficio del benessere di tutti i nostri dipendenti e dei nostri azionisti.</p>

<h4> Durata di conservazione dei dati personali</h4
<p>Il criterio per la durata della conservazione dei dati personali è il rispettivo periodo di conservazione legale. Alla scadenza di questo periodo, i dati corrispondenti vengono regolarmente cancellati, a condizione che non siano più necessari per l\'adempimento del contratto o per l\'avvio di un contratto.</p>.

<p>Prescrizioni legali o contrattuali sul conferimento dei dati personali; necessità per la conclusione del contratto; obbligo dell\'interessato di fornire i dati personali; possibili conseguenze del mancato conferimento dei dati
Vi informiamo che il conferimento dei dati personali è in parte obbligatorio per legge (ad es. norme fiscali) o può anche derivare da norme contrattuali (ad es. informazioni sul partner contrattuale).
A volte può essere necessario per la conclusione di un contratto che un interessato ci fornisca dati personali, che devono essere successivamente trattati da noi. Ad esempio, l\'interessato è obbligato a fornirci i dati personali se la nostra società stipula un contratto con lui/lei. Il mancato conferimento dei dati personali comporterebbe l\'impossibilità di concludere il contratto con l\'interessato.
Prima che l\'interessato renda disponibili i dati personali, deve contattare uno dei nostri dipendenti. Il nostro collaboratore informerà di volta in volta l\'interessato se il conferimento dei dati personali è obbligatorio per legge o per contratto o è necessario per la conclusione del contratto, se vi è un obbligo di fornire i dati personali e quali sarebbero le conseguenze in caso di mancato conferimento dei dati personali.
</p>

<h4>Esistenza di un processo decisionale automatizzato</h4>
<p>In qualità di azienda responsabile non utilizziamo il processo decisionale automatico o la profilazione.</p>


';

**/


$wordpress_policy_sample_it = '
<h3>Cookies generici</h3>
<b>Cookies da WordPress</b>
<table style="width:100%">
  <tr>
    <th>Nome</th>
    <th>Scopo</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>wordpress_test_cookie</td>
    <td>Questo cookie determina se l\'uso dei cookie è stato disabilitato nel browser. Durata della memorizzazione: Fino alla fine della sessione del browser (verrà cancellato alla chiusura del browser).</td>
    <td>Sessione</td>
  </tr>
   <tr>
    <td>PHPSESSID</td>
    <td>Questo cookie memorizza la vostra sessione corrente rispetto alle applicazioni PHP, assicurando che tutte le funzionalità di questo sito web basate sul linguaggio di programmazione PHP siano completamente visualizzate. Durata della memorizzazione: Fino alla fine della sessione del browser (verrà cancellato alla chiusura del browser).</td>
    <td>Sessione</td>
  </tr> 
   <tr>
    <td>wordpress_akm_mobile</td>
    <td>Questi cookie vengono utilizzati solo per l\'area di amministrazione di WordPress.</td>
    <td>1 Year</td>
  </tr>   
   <tr>
    <td>wordpress_logged_in_akm_mobile</td>
    <td>These cookies are only used for the administration area of ​​WordPress and do not apply to other site visitors.</td>
    <td>Sessione</td>
  </tr>   
   <tr>
    <td>wp-settings-akm_mobile</td>
    <td>Questi cookie vengono utilizzati solo per l\'area di amministrazione di WordPress e non si applicano agli altri visitatori del sito.</td>
    <td>Sessione</td>
  </tr>   
   <tr>
    <td>wp-settings-time-akm_mobile</td>
    <td>Questi cookie vengono utilizzati solo per l\'area di amministrazione di WordPress e non si applicano agli altri visitatori del sito.</td>
    <td>Sessione</td>
  </tr>     
   <tr>
    <td>ab</td>
    <td>Viene utilizzato per il test A/B delle nuove caratteristiche.</td>
    <td>Sessione</td>
  </tr>      
   <tr>
    <td>akm_mobile</td>
    <td>salva se il visitatore vuole vedere la versione mobile di un sito web.</td>
    <td>1 giorno</td>
  </tr>     
</table>
[dsgvoaio_plugins]
';

$gtagmanager_policy_sample_it = '
<h3 >Google Tag Manager</h3>
<p>Questo sito web utilizza Google Tag Manager (Google LLC. 1600 Amphitheatre Parkway, Mountain View, CA 94043, USA). Google Tag Manager consente di gestire i tag dei siti web commercializzati tramite un\'interfaccia. Lo stesso strumento Tag Manager (che implementa i tag) è un dominio senza cookie e non registra dati personali. Lo strumento fa sì che vengano attivati altri tag che possono, dal canto loro, registrare dati in determinate circostanze. Google Tag Manager non accede a queste informazioni. Se la registrazione è stata disattivata a livello di dominio o di cookie, questa impostazione rimane valida per tutti i tag di tracciamento implementati con Google Tag Manager.</p>
';

$ga_policy_sample_it = '
<h3>Google Analytics</h3>
<p>Questo sito web utilizza vari servizi forniti da Google Ireland Limited, Gordon House, Barrow Street, Dublino 4, Irlanda. L\'utilizzo di questi singoli servizi è descritto più dettagliatamente qui di seguito.</p>
<p>Il nostro utilizzo dei seguenti servizi e la relativa raccolta di dati personali (in particolare gli indirizzi IP) si basa generalmente sul nostro legittimo interesse ad analizzare, migliorare e far apparire attraente il contenuto del nostro sito web, nonché sul nostro legittimo interesse ad adattare qualsiasi pubblicità alle vostre esigenze (articolo 6 (1) f GDPR).</p>
<p>Google Analytics utilizza i cookie (vedi anche 3.1 "Cookies"). I cookie vengono memorizzati sul vostro computer e consentono a Google di analizzare il modo in cui utilizzate questo sito web. Le informazioni generate dal cookie sull\'utilizzo di questo sito web vengono generalmente trasmesse e memorizzate su un server di Google negli USA.</p>
<p> <strong>Anonimizzazione IP</strong> </p>
<p>Abbiamo attivato l\'anonimizzazione IP sul nostro sito web. Ciò significa che Google accorcerà il vostro indirizzo IP prima di trasmetterlo agli Stati Uniti, a condizione che l\'indirizzo IP provenga da uno Stato membro dell\'Unione Europea o da uno Stato che è parte dell\'Accordo sullo Spazio Economico Europeo. Il gestore di questo sito web commissiona a Google l\'utilizzo di queste informazioni per valutare il vostro utilizzo del sito web, per creare report sulle attività del sito web e per fornire altri servizi relativi all\'utilizzo del sito web e di internet. L\'indirizzo IP trasmesso dal vostro browser durante il processo di Google Analytics non è collegato ad altri dati posseduti da Google.</p>
<p> <strong>Il vostro diritto di opporvi alla raccolta dei vostri dati</strong> </p>
<p>È possibile bloccare la memorizzazione dei cookie modificando di conseguenza le impostazioni del browser; si prega di notare, tuttavia, che in questi casi potrebbe non essere possibile utilizzare tutte le funzioni disponibili su questo sito web. Potete anche impedire a Google di raccogliere ed elaborare i dati generati dal cookie sull\'utilizzo del sito web (compreso il vostro indirizzo IP) scaricando e installando il plugin del browser disponibile al seguente link:&nbsp; <a href="https://tools.google.com/dlpage/gaoptout?hl=en" target="_blank" rel="nofollow noopener">https://tools.google.com/dlpage/gaoptout?hl=en</a>.</p>
<p>Per ulteriori informazioni sul trattamento dei dati da parte di Google Analytics consultare l\'informativa sulla privacy di Google:&nbsp; <a href="https://support.google.com/analytics/answer/6004245?hl=en" target="_blank" rel="nofollow noopener">https://support.google.com/analytics/answer/6004245?hl=en</a>.</p>
<p> <strong>Il trattamento dei dati per nostro conto</strong> </p>
<p>Abbiamo stipulato un contratto di elaborazione dei dati per il nostro utilizzo di Google Analytics e rispettiamo pienamente le severe disposizioni delle autorità tedesche per la protezione dei dati nell\'utilizzo di questo servizio.</p>
<p> <strong>Raccolta di dati demografici da Google Analytics</strong> </p>
<p>Questo sito web utilizza la funzione Demographics di Google Analytics. Questa funzione consente di creare report che contengono dichiarazioni sull\'età, il sesso e gli interessi dei visitatori di questo sito. Questi dati vengono raccolti dalla pubblicità personalizzata di Google e dai dati dei visitatori di fornitori terzi. Questi dati non possono essere attribuiti ad individui specifici. È possibile disattivare questa funzione in qualsiasi momento modificando le impostazioni degli annunci nel proprio account Google, oppure è possibile vietare la raccolta generale dei propri dati da parte di Google Analytics seguendo la procedura descritta sopra.</p>
<b>Cookies di Google Analytics</b>
<table style="width:100%">
  <tr>
    <th>Nome</th>
    <th>Scopo</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>_ga</td>
    <td>Differenziazione dei visitatori del sito web.</td>
    <td>2 Ore</td>
  </tr>
  <tr>
    <td>_gid</td>
    <td>Differenziazione dei visitatori del sito web.</td>
    <td>24 ore</td>
  </tr>
  <tr>
    <td>_gat_gat_gtag_UA_<property-id></td></td>
    <td>Usato per strozzare il tasso di richiesta. Se Google Analytics viene fornito tramite Google Tag Manager, questo cookie sarà denominato _dc_gtm_ <property-id>.</td>
    <td>1 Verbale</td>
  </tr>
  <tr>
    <td>_dc_gtm_gtm_</td>
    <td>Utilizzato per monitorare il numero di richieste del server di Google Analytics.</td>
    <td>1 Verbale</td>
  </tr>
   <tr>
    <td>AMP_TOKEN</td>
    <td>Contiene un codice token che viene utilizzato per leggere l\'ID cliente dal servizio AMP Client ID Service. Abbinando questo ID con quello di Google Analytics, gli utenti possono essere abbinati quando si passa da contenuti AMP a contenuti non AMP.</td>
    <td>30 secondi fino a 1 anno</td>
  </tr>
   <tr>
    <td>_gat</td>
    <td>Utilizzato per monitorare il numero di richieste del server di Google Analytics quando si utilizza Google Tag Manager.</td>
    <td>1 minuto</td>
  </tr>   
   <tr>
    <td>_gac_</td>
    <td>Contiene informazioni relative alle campagne di marketing dell\'utente. Queste sono condivise con Google AdWords / Google Ads quando gli account Google Ads e Google Analytics sono collegati tra loro.</td>
    <td>90 giorni</td>
  </tr>     
   <tr>
    <td>__utma</td>
    <td>ID utilizzato per identificare gli utenti e le sessioni.</td>
    <td>2 anni</td>
  </tr>  
   <tr>
    <td>__utmt</td>
    <td>Utilizzato per monitorare il numero di richieste del server di Google Analytics.</td>
    <td>10 Minuti</td>
  </tr>   
   <tr>
    <td>__utmb</td>
    <td>Usato per distinguere le nuove sessioni e le nuove visite. Questo cookie viene impostato quando la libreria javascript GA.js viene caricata e non esiste un cookie __utmb esistente. Il cookie viene aggiornato ogni volta che i dati vengono inviati al server di Google Analytics.</td>
    <td>30 Minuti</td>
  </tr>   
   <tr>
    <td>__utmc</td>
    <td>Utilizzato solo con le vecchie versioni Urchin di Google Analytics e non con GA.js. È stato utilizzato per distinguere tra le nuove sessioni e le visite alla fine di una sessione.</td>
    <td>Sessione</td>
  </tr>   
   <tr>
    <td>__utmz</td>
    <td>Contiene informazioni sulla fonte di traffico o sulla campagna che ha indirizzato l\'utente verso il sito web. Il cookie viene impostato quando il GA.js javascript viene caricato e aggiornato quando i dati vengono inviati al server di Google Anaytics.</td>
    <td>6 mesi</td>
  </tr>   
   <tr>
    <td>__utmv</td>
    <td>Contiene informazioni personalizzate impostate dallo sviluppatore web con il metodo _setCustomVar in Google Analytics. Questo cookie viene aggiornato ogni volta che nuovi dati vengono inviati al server di Google Analytics.</td>
    <td>2 anni</td>
  </tr>   
    <tr>
    <td>__utmx</td>
    <td>Utilizzato per determinare se un utente è incluso in un test A / B o Multivariata.</td>
    <td>18 Mesi</td>
  </tr>   
    <tr>
    <td>__utmxx</td>
    <td>Utilizzato per determinare quando termina il test A / B o Multivariata a cui l\'utente partecipa.</td>
    <td>18 Mesi</td>
  </tr>    
</table>
';


$twitter_policy_sample_it = '
<h3>Twitter</h3>
<p>Su questo sito web, il controllore ha integrato componenti di Twitter. Twitter è un servizio di microblogging multilingue e accessibile al pubblico, sul quale gli utenti possono pubblicare e diffondere i cosiddetti "tweet", ad es. messaggi brevi, limitati a 280 caratteri. Questi brevi messaggi sono disponibili per tutti, anche per coloro che non sono collegati a Twitter. I tweet vengono visualizzati anche ai cosiddetti follower del rispettivo utente. I follower sono altri utenti di Twitter che seguono i tweet di un utente. Inoltre, Twitter consente di rivolgersi a un vasto pubblico tramite hashtag, link o retweet.</p>
<p>La società operativa di Twitter è Twitter International Company, One Cumberland Place, Fenian Street Dublin 2, D02 AX07, Irlanda.</p>
<p>Con ogni richiamo a una delle singole pagine di questo sito Internet, che è gestito dal controller e sul quale è stato integrato un componente Twitter (pulsante Twitter), il browser Internet del sistema informatico dell\'interessato viene automaticamente invitato a scaricare una visualizzazione del corrispondente componente Twitter di Twitter. Ulteriori informazioni sui pulsanti di Twitter sono disponibili sotto <a href="https://about.twitter.com/en/resources/buttons" target="blank">https://about.twitter.com/en/resources/buttons</a>. Nel corso di questa procedura tecnica, Twitter viene a conoscenza di quale sotto-pagina specifica del nostro sito web è stata visitata dall\'interessato. Lo scopo dell\'integrazione della componente Twitter è una ritrasmissione dei contenuti di questo sito web per consentire ai nostri utenti di introdurre questa pagina web nel mondo digitale e aumentare il numero di visitatori.</p>
<p>Se l\'interessato viene registrato contemporaneamente su Twitter, Twitter rileva ad ogni chiamata al nostro sito web da parte dell\'interessato e per tutta la durata della sua permanenza sul nostro sito internet quale sotto-pagina specifica della nostra pagina internet è stata visitata dall\'interessato. Queste informazioni vengono raccolte attraverso la componente Twitter e associate al rispettivo account Twitter dell\'interessato. Se l\'interessato clicca su uno dei pulsanti di Twitter integrati nel nostro sito Internet, Twitter assegna queste informazioni all\'account utente Twitter personale dell\'interessato e memorizza i dati personali.</p>
<p>Twitter riceve tramite la componente Twitter l\'informazione che l\'interessato ha visitato il nostro sito web, a condizione che l\'interessato abbia effettuato il login su Twitter al momento della chiamata al nostro sito web. Ciò avviene indipendentemente dal fatto che la persona clicchi o meno sul componente Twitter. Se una tale trasmissione di informazioni a Twitter non è auspicabile per l\'interessato, questi può impedirlo disconnettendosi dal proprio account Twitter prima di effettuare una chiamata al nostro sito web.</p>
<p>Le disposizioni vigenti in materia di protezione dei dati di Twitter sono accessibili sotto <a href="https://twitter.com/privacy?lang=en" target="blank">https://twitter.com/privacy?lang=en</a>.</p>
<b>Cookies da Twitter</b>
<table style="width:100%"> 
<tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>external_referer</td>
    <td>Raccoglie dati anonimi come il numero di visite, il tempo medio trascorso sul sito e quali pagine sono state visualizzate. Scopo della personalizzazione e del miglioramento del servizio Twitter.</td>
    <td>6 giorni</td>
  </tr>
  <tr>
    <td>_twitter_sess</td>
    <tdSession ID per l\'identificazione se l\'utente è connesso a Twitter.</td>
    <td>Sessione</td>
  </tr>
   <tr>
    <td>guest_id</td>
    <td>ID di sessione per l\'identificazione se l\'utente non è connesso a Twitter.</td>
    <td>2 anni</td>
  </tr> 
  <tr>
    <td>personalization_id</td>
    <td>Serve a scopo di personalizzazione degli annunci.</td>
    <td>2 anni</td>
  </tr> 
  <tr>
    <td>ct0</td>
    <td>Questi cookie ci permettono di tracciare l\'attività dei visitatori dai nostri annunci Twitter sul nostro sito web, e anche di permettere agli utenti di condividere i contenuti dei nostri siti web. I cookie non ci forniscono informazioni riservate relative al vostro account.</td>
    <td>2 anni</td>
  </tr>    
</table>
';

$facebook_policy_sample_it = '
<h3>Facebook Like/Commenti</h3>
<p>Su questo sito web, il controllore ha integrato i componenti dell\'impresa Facebook. Facebook è un social network.</p>
<p>Un social network è un luogo di incontri sociali su Internet, una comunità online, che di solito permette agli utenti di comunicare tra loro e di interagire in uno spazio virtuale. Un social network può fungere da piattaforma per lo scambio di opinioni ed esperienze o consentire alla comunità di Internet di fornire informazioni personali o commerciali. Facebook consente agli utenti dei social network di includere la creazione di profili privati, l\'upload di foto e la creazione di una rete attraverso richieste di amicizia.</p>
<p>La società operativa di Facebook è Facebook, Inc., 1 Hacker Way, Menlo Park, CA 94025, Stati Uniti. Se una persona vive al di fuori degli Stati Uniti o del Canada, il controller è Facebook Ireland Ltd., 4 Grand Canal Square, Grand Canal Harbour, Dublino 2, Irlanda.</p>
<p>Ad ogni richiamo di una delle singole pagine di questo sito Internet, gestito dal controller e nel quale è stato integrato un componente Facebook (plug-in Facebook), il browser web del sistema informatico dell\'interessato viene automaticamente invitato a scaricare la visualizzazione del corrispondente componente Facebook da Facebook attraverso il componente Facebook. Una panoramica di tutti i plug-in di Facebook è accessibile sotto <a href="https://facebook.com/about/privacy/" target="blank">https://developers.facebook.com/docs/plugins/</a>. Nel corso di questa procedura tecnica, Facebook viene messo a conoscenza di quale sotto-sito specifico del nostro sito web è stato visitato dall\'interessato.</p>
<p>Se l\'interessato viene registrato contemporaneamente su Facebook, Facebook riconosce ad ogni chiamata al nostro sito web da parte dell\'interessato - e per tutta la durata della sua permanenza sul nostro sito Internet - quale sotto-sito specifico della nostra pagina Internet è stato visitato dall\'interessato. Queste informazioni vengono raccolte attraverso il componente Facebook e associate al rispettivo account Facebook dell\'interessato. Se l\'interessato clicca su uno dei pulsanti di Facebook integrati nel nostro sito web, ad esempio il pulsante "Mi piace", o se l\'interessato invia un commento, allora Facebook abbina queste informazioni con l\'account utente personale di Facebook dell\'interessato e memorizza i dati personali.</p>
<p>Facebook riceve sempre, attraverso il componente Facebook, informazioni sulla visita al nostro sito web da parte dell\'interessato, ogni volta che l\'interessato viene registrato contemporaneamente su Facebook durante la chiamata al nostro sito web. Ciò avviene indipendentemente dal fatto che l\'interessato clicchi o meno sul componente Facebook. Se una tale trasmissione di informazioni a Facebook non è auspicabile per l\'interessato, questi può impedirlo disconnettendosi dal proprio account Facebook prima di effettuare una chiamata al nostro sito web.</p>
<p>La direttiva sulla protezione dei dati pubblicata da Facebook, disponibile all\'indirizzo <a href="https://facebook.com/about/privacy/" target="blank">https://facebook.com/about/privacy/</a>, fornisce informazioni sulla raccolta, l\'elaborazione e l\'utilizzo dei dati personali da parte di Facebook. Inoltre, viene spiegato quali sono le possibilità di impostazione offerte da Facebook per proteggere la privacy della persona interessata. Inoltre, sono disponibili diverse opzioni di configurazione per consentire l\'eliminazione della trasmissione dei dati a Facebook. Queste applicazioni possono essere utilizzate dall\'interessato per eliminare una trasmissione di dati a Facebook.
<b>Cookies da Facebook</b>
<table style="width:100%">
  <tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>_fbp</td>
    <td>Questo cookie è utilizzato da Facebook per fornire una serie di prodotti promozionali come le offerte di terzi in tempo reale.</td>
    <td>3 mesi</td>
  </tr>   
 </table>
';

$fbpixel_policy_sample_it = '
<h3>Facebook-Pixel</h3>
<p>Il nostro sito web misura le conversioni utilizzando i pixel di azione dei visitatori di Facebook, Facebook Inc., 1601 S. California Ave, Palo Alto, CA 94304, USA ("Facebook").
<p>Questi permettono di tracciare il comportamento dei visitatori del sito dopo aver cliccato su un annuncio su Facebook per raggiungere il sito web del provider. Questo permette un\'analisi dell\'efficacia degli annunci di Facebook a fini statistici e di ricerca di mercato e la loro futura ottimizzazione.</p>
<p>I dati raccolti sono anonimi per noi in qualità di operatori di questo sito web e non possiamo utilizzarli per trarre conclusioni sull\'identità dei nostri utenti. Tuttavia, i dati vengono memorizzati ed elaborati da Facebook, che può stabilire un collegamento con il vostro profilo Facebook e che può utilizzare i dati per i propri scopi pubblicitari, come stabilito nella <a href="https://www.facebook.com/about/privacy/" target="_blank">Privacy policy di Facebook</a>. Ciò consentirà a Facebook di visualizzare annunci pubblicitari sia su Facebook che su siti di terze parti. Non abbiamo alcun controllo sull\'utilizzo di questi dati.</p>
<p>Verifica l\'informativa sulla privacy di Facebook per saperne di più sulla tutela della tua privacy: <a href="https://www.facebook.com/about/privacy/" target="_blank">https://www.facebook.com/about/privacy/</a>.</p>
<p>P>Puoi anche disattivare la funzione di remarketing personalizzato del pubblico nella sezione Ads Settings a <a href="https://www.facebook.com/ads/preferences/?entry_product=ad_settings_screen" target="_blank">https://www.facebook.com/ads/preferences/?entry_product=ad_settings_screen</a>. Dovrete prima effettuare il login su Facebook.</p>
<b>Cookies da Facebook Pixel</b>
<table style="width:100%">
<tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>act, c_user, datr, fr, pl, presence, sd, wd, xs</td>
    <td>Facebook utilizza diversi cookie per la sessione di identificazione e analisi. Questi sono utilizzati per rilevare se si è connessi come utente su Facebook, per scopi di tracciamento e da quale URL viene utilizzata la funzione Condividi / Mi piace.</td>
    <td>variabile</td>
  </tr>   
 </table>
';


$linkedin_policy_sample_it = '
<h3>LinkedIn</h3>
<p>Funzioni e contenuti di LinkedIn possono essere integrati nella nostra offerta online, offerta da LinkedIn AG, Dammtorstraße 29-32, 20354 Amburgo, Germania. Questo può includere contenuti come immagini, video o testi e pulsanti che gli utenti utilizzano per esprimere i loro favori sul contenuto, o il contenuto o i nostri post sottoscrivono. Se gli utenti sono membri della piattaforma LinkedIn, LinkedIn può ad es. assegnare contenuti e funzioni ai profili degli utenti. Dichiarazione sulla privacy di LinkedIn: <a href="https://www.linkedin.com/legal/privacy-policy"> https://www.linkedin.com/legal/privacy-policy. </a>. LinkedIn è certificato ai sensi del Privacy Shield Agreement e ha la garanzia di rispettare la legislazione europea sulla privacy (<a href="https://www.privacyshield.gov/participant?id=a2zt0000000L0UZAA0&amp;status=Attivo">https://www.privacyshield.gov/participant?id=a2zt0000000L0UZAA0&amp;status=Attivo</a>).<br /> Informativa sulla privacy: <a href="https://twitter.com/privacy">https://twitter.com/privacy</a>, opt-out: <a href="https://www.linkedin.com/psettings/guest-controls/retargeting-opt-out"> https://www.linkedin.com/psettings/guest-controls/retargeting-opt-out </a>. </p>
<b>Cookies da LinkedIn</b>
<table style="width:100%">
 <tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>lidc</td>
    <td>Utilizzato dal servizio di social network LinkedIn per il tracciamento dell\'utilizzo dei servizi embedded.</td>
    <td>Sessione</td>
  </tr>
  <tr>
    <td>bcookie</td>
    <td>Utilizzato dal servizio di social network LinkedIn per il tracciamento dell\'utilizzo dei servizi embedded.</td>
    <td>2 anni</td>
  </tr>  
  <tr>
    <td>bscookie</td>
    <td>Utilizzato dal servizio di social network LinkedIn per il tracciamento dell\'utilizzo dei servizi embedded.</td>
    <td>2 anni</td>
  </tr>
  <tr>
    <td>BizoID</td>
    <td>LinkedIn ad analytics.</td>
    <td>179 giorni</td>
  </tr>
  <tr>
    <td>UserMatchHistory</td>
    <td>LinkedIn ad analytics.</td>
    <td>179 giorni</td>
  </tr>  
  <tr>
    <td>trkCode</td>
    <td>Questo cookie è utilizzato da LinkedIn per supportare la funzionalità di aggiunta di un pannello di invito con l\'etichetta \'Follow Us\'</td>
    <td>1 anno</td>
  </tr>    
  <tr>
    <td>trkInfo</td>
    <td>Questo cookie è utilizzato da LinkedIn per supportare la funzionalità di aggiunta di un pannello di invito con l\'etichetta \'Follow Us\'</td>
    <td>1 anno</td>
  </tr>   
  <tr>
    <td>li_oatml</td>
    <td>Raccoglie informazioni sull\'utilizzo del nostro sito da parte dei visitatori.</td>
    <td>30 giorni</td>
  </tr>  
  <tr>
    <td>liap</td>
    <td>Cookie utilizzato per l\'accesso con Linkedin e/o per consentire la funzione Linkedin follow.</td>
    <td>90 giorni</td>
  </tr>   
  <tr>
    <td>lissc</td>
    <td>Cookie utilizzato per l\'accesso con Linkedin e/o per consentire la funzione Linkedin follow.</td>
    <td>1 anno</td>
  </tr>    
  <tr>
    <td>spectroscopyId</td>
    <td>Questi cookie sono impostati da LinkedIn per scopi pubblicitari, tra cui: tracciare i visitatori in modo che possano essere presentati annunci più rilevanti, consentendo agli utenti di utilizzare le funzioni \'Applica con LinkedIn\' o \'Accedi con LinkedIn\', raccogliendo informazioni su come i visitatori utilizzano il sito, ecc.</td>
    <td>Sessione</td>
  </tr>     
</table>
';


$shareaholic_policy_sample_it = '
<h3>Shareaholic</h3>
<p>Questo sito web contiene plugin shareaholic che consentono di impostare i segnalibri o di condividere contenuti interessanti del sito web. Shareaholic utilizza i cookie. I dati generati (come il tempo di utilizzo, la lingua del browser e l\'indirizzo IP) saranno trasmessi a Shareaholic Inc., Dogpatch Labs 1, Cambridge Center, Suite 600, Cambridge, MA 02142, e ai server negli Stati Uniti e in altri paesi elaborati. Si prega di consultare <a href="http://www.shareaholic.com/privacy" target="blank">http://www.shareaholic.com/privacy/</a> per ulteriori informazioni sul trattamento dei dati e sulle pratiche sulla privacy di Shareaholic Inc. In particolare, questo sito web contiene informazioni sul tipo di dati trattati e sul loro scopo. Il trattamento dei dati interessati da parte del gestore di questo sito non ha luogo. Utilizzando il pulsante Shareaholic, l\'utente accetta il trattamento dei dati forniti da Shareaholic Inc., al livello indicato sul sito web <a href="http://www.shareaholic.com/privacy" target="blank">http://www.shareaholic.com/privacy/</a>. L\'utente può opporsi all\'utilizzo dei dati in qualsiasi momento utilizzando un cookie opt-out all\'indirizzo <a href="http://www.shareaholic.com/privacy/choices" target="blank">http://www.shareaholic.com/privacy/choices</a>. Ulteriori dettagli sono disponibili sul sito web di Shareaholic Inc. </p>
<b>Cookies da Shareaholic</b>
<table style="width:100%">
<tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>XSRF-TOKEN</td>
    <td>Gettone CSRF - Serve la sicurezza della richiesta di falsificazione in un sito web.</td>
    <td>Sessione</td>
  </tr>
  <tr>  
    <td>DFTT_END_END_USER_PREV_BOOTSTRAPPED</td>
    <td>Valore booleano che indica che l\'utente ha scartato il messaggio di benvenuto.</td>
    <td>2 anni</td>
  </tr>
  <tr>
    <td>__hssc</td>
    <td>Questo cookie viene utilizzato su siti web creati sulla piattaforma HubSpot. Viene utilizzato per l\'analisi del sito web.</td>
    <td>30 Minuti</td>
  </tr>
  <tr>
    <td>__hssrc</td>
    <td>Questo cookie viene utilizzato su siti web creati sulla piattaforma HubSpot. Viene utilizzato per l\'analisi del sito web.</td>
    <td>Sessione</td>
  </tr>  
  <tr>
    <td>__hstc</td>
    <td>Questo cookie viene utilizzato su siti web creati sulla piattaforma HubSpot. Viene utilizzato per l\'analisi del sito web.</td>
    <td>2 anni</td>
  </tr>    
  <tr>
    <td>__qca</td>
    <td>Shareaholic.com utilizza questo cookie su tutte le pagine.</td>
    <td>2,5 anni</td>
  </tr>    
  <tr>  
    <td>__d_hsutk</td>
    <td>Valore booleano di integrazione che indica che l\'HubSpot UTK è stato validato (se l\'integrazione è abilitata).</td>
    <td>30 Minuti</td>
  </tr>      
  <tr>
    <td>__cfduid</td>
    <td>Utilizzato per identificare i singoli client dietro un indirizzo IP condiviso e per applicare individualmente le impostazioni di sicurezza per ogni client.</td
    <td>Sessione</td>
  </tr>      
  <tr>
    <td>hsfirstvisit</td>
    <td>Shareaholic.com utilizza questo cookie su tutte le pagine. Viene utilizzato per salvare il tempo della prima chiamata.</td>
    <td>10 anni</td>
  </tr>      
  <tr>
    <td>hubspotutk</td>
    <td>Valore booleano di integrazione che indica che l\'HubSpot UTK è stato validato (se l\'integrazione è abilitata).</td>
    <td>10 anni</td>
  </tr>      
  <tr>  
    <td>SnapABugVisit</td>
    <td>Questo cookie è collegato al software di live chat SnapEngage. Identifica una nuova sessione utente.</td>
    <td>Sessione</td>
  </tr> 
  <tr>
    <td>SnapABugHistory</td>
    <td>Questo cookie è collegato al software di live chat SnapEngage. Identifica un visitatore per consentire la registrazione di una cronologia.</td>
    <td>1 anno</td>
  </tr> 
  <tr>
    <td>SnapABugRef</td>
    <td>Questo cookie è collegato al software di live chat SnapEngage. Registra la pagina di destinazione e l\'origine di un visitatore.</td>
    <td>1 anno</td>
  </tr> 
  <tr>
    <td>_ga</td>
    <td>Questo cookie utilizza LinkedIn, la piattaforma per le reti aziendali. Questo cookie è per Google Analytics.</td>
    <td>1 Giorno</td>
  </tr>   
  <tr>
    <td>_gid</td>
    <td>Questo cookie utilizza LinkedIn, la piattaforma per le reti aziendali. Questo cookie è per Google Analytics.</td>
    <td>1 Giorno</td>
  </tr>   
  <tr>  
  <tr>
    <td>__utma</td>
    <td>Questo cookie utilizza LinkedIn, la piattaforma per le reti aziendali. Questo cookie è per Google Analytics.</td>
    <td>2 anni</td>
  </tr>   
  <tr>
    <td>__utmb</td>
    <td>Questo cookie utilizza LinkedIn, la piattaforma per le reti aziendali. Questo cookie è per Google Analytics.</td>
    <td>1 Ora e 8 minuti</td>
  </tr> 
  <tr>
    <td>__utmc</td>
    <td>Questo cookie utilizza LinkedIn, la piattaforma per le reti aziendali. Questo cookie è per Google Analytics.</td>
    <td>Sessione</td>
  </tr>   
  <tr>
    <td>__utmz</td>
    <td>Questo cookie utilizza LinkedIn, la piattaforma per le reti aziendali. Questo cookie è per Google Analytics.</td>
    <td>6 Mese e 11 Ore</td>
  </tr>     
  <tr>
    <td>_shareaholic_session</td>
    <td>Shareaholic.com utilizza questo cookie su tutte le pagine. C\'è una sessione unica ID.</td> di sessione
    <td>1 mese</td>
  </tr> 
  <tr>
    <td>c_id</td>
    <td>Shareaholic.com utilizza questo cookie su tutte le pagine.</td>
    <td>1 anno</td>
  </tr>
</table>
';

$koko_policy_sample_it = '
<h3>Koko Analyics</h3>
<p>Utilizziamo un plug-in sul nostro sito web per contare i visitatori e le pagine viste - Koko-Analytics.<br>
Quando la pagina viene chiamata, vengono contate solo le chiamate alla pagina.<br>
La base giuridica è l\'interesse legittimo ai sensi dell\'Art. 6 cpv. 1 lett. f) DSGVO. Il nostro interesse legittimo è quello di sapere senza dubbio se il nostro sito viene visitato e se il plug-in funziona correttamente.</p>
<b>Cookies di Koko Analyics</b>
<table style="width:100%">
<tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>_koko_analytics_pages_viewed</td>
    <td>Utilizzato per determinare il numero di pagine visualizzate.</td
    <td>6 Ore</td>
  </tr>
</table>
';

$vgwort_policy_sample_it = '
<h3>VG Wort</h3>
<p>Usiamo i "Session Cookies" di VG Wort, Monaco di Baviera, per misurare l\'accesso ai testi al fine di registrare la probabilità di copia. I "Session Cookies" sono piccoli pezzi di informazione che memorizzano un provider nella memoria del computer del visitatore. In un cookie di sessione viene memorizzato un numero identificativo univoco generato in modo casuale, il cosiddetto ID di sessione. Inoltre, un cookie contiene informazioni sulla sua origine e sul periodo di conservazione. I cookie di sessione non possono salvare altri dati. Queste misurazioni vengono effettuate da Kantar Deutschland GmbH secondo il metodo di misurazione centrale scalabile (SZM). Esse aiutano a determinare la probabilità di copia dei singoli testi. Non raccogliamo informazioni personali sui cookie. </p>
<p> Molti dei nostri siti sono dotati di JavaScript che utilizziamo per segnalare il traffico e la società di gestione collettiva Wort (VG Wort). [CONTROLLARE se questo è il caso con il vostro editore!] § 53 UrhG warrant</p>
<p> L\'utilizzo delle nostre offerte è possibile anche senza cookie. La maggior parte dei browser è impostata per accettare automaticamente i cookie. Tuttavia, è possibile disattivare la memorizzazione dei cookie o impostare il browser in modo che sia necessario quando i cookie vengono inviati. Informativa sulla privacy per l\'utilizzo del sistema di misurazione centrale scalabile. </p>
<b> Offerte web </b>
<p> Il nostro sito web e il nostro sito web mobile utilizzano il "Metodo di misura centrale scalabile" (SZM) della Kantar Deutschland GmbH per la determinazione dei parametri statistici per la determinazione della probabilità di copia dei testi. </p>
Vengono effettuate misurazioni anonime. La misurazione dell\'accesso viene eseguita per riconoscere i sistemi informatici in alternativa con un cookie di sessione o una firma che viene creata a partire da varie informazioni trasmesse automaticamente dal vostro browser. Gli indirizzi IP vengono elaborati solo in forma anonima. La procedura è stata sviluppata nel rispetto della protezione dei dati. L\'unico obiettivo della procedura è quello di determinare la probabilità di copia di singoli testi. </p>
<p> In nessun momento i singoli utenti saranno identificati. La vostra identità rimane sempre protetta. Non riceverete pubblicità attraverso il sistema. </p>
<b>Cookies da VG Wort Pixel</b>
<table style="width:100%">
<tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>srp</td>
    <td>Il cookie di VG Wort aiuta a determinare la probabilità di copia dei nostri testi e garantisce la remunerazione delle rivendicazioni legali degli autori e degli editori. Gli indirizzi IP sono trattati solo in forma anonima.</td>
    <td>Sessione</td>
  </tr>
</table>
';

$matomo_policy_sample_it = '
<h3>Matomo (formale Piwik)</h3>
<p> Questo sito web utilizza il servizio di analisi web Matomo (ex Piwik) per analizzare e migliorare regolarmente l\'uso del nostro sito web. Il servizio viene utilizzato per la nostra pagina di login per il portale clienti "Portale AGURS". Con le statistiche possiamo migliorare la nostra offerta e renderla più interessante per voi come utente. La base legale per l\'utilizzo di Matomo è l\'Art. 6 comma 1 f DSGVO. </p>
<p> I cookie sono memorizzati sul vostro computer per questa valutazione. È possibile regolare la valutazione eliminando i cookie esistenti e impedendo la memorizzazione dei cookie. Se impedite la memorizzazione dei cookie, vi segnaliamo che potreste non essere in grado di utilizzare questo sito web nella sua interezza. Impedire la memorizzazione dei cookie è possibile impostando il vostro browser. </p>
<p> Questo sito web utilizza Matomo con l\'estensione "AnonymizeIP". In questo modo gli indirizzi IP vengono elaborati abbreviati e si può quindi escludere una relazione diretta con la persona. L\'indirizzo IP trasmesso da Matomo dal vostro browser non verrà unito ad altre informazioni da noi raccolte. </p>
<p> Il programma Matomo è un progetto open source. Le informazioni sulla privacy di terzi sono disponibili all\'indirizzo <a href="https://matomo.org/privacy/"> https://matomo.org/privacy/ </a> </p>
<b>Cookies da Matomo</b>
<table style="width:100%">
<tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>_pk_id</td>
    <td> ID visitatore usato da Matomo per riconoscere i visitatori che ritornano.</td>
    <td>13 Mesi</td>
  </tr>
  <tr>
    <td>_pk_ref</td>
    <td>Contiene informazioni sui referenti del visitatore.
    <td>6 mesi</td>
  </tr>
  <tr>
    <td>_pk_ses, _pk_cvar, _pk_hsr</td>
    <td>Il cookie di sessione mantiene lo stato \"attivo\" per 30 minuti dopo l\'ultima azione tracciata dall\'utente. Dopo 30 minuti, la visita è considerata completata.</td>
    <td>30 Minuti</td>
  </tr>
  <tr>
    <td>piwik_ignore</td>
    <td>Cookie è impostato quando un utente vieta l\'uso di Matomo per il tracciamento. Una volta impostato il cookie, nessun dato dell\'utente viene inviato al server Matomo.</td>
    <td>2 anni</td>
  </tr>  
   <tr>
    <td>_pk_testcookie</td>
    <td>Cookie viene creato e deve essere poi direttamente cancellato (utilizzato per verificare se il browser del visitatore supporta i cookie).
    <td>Sessione</td>
  </tr>  
   <tr>
    <td>mtm_consent</td>
    <td>Cookie viene creato senza data di scadenza per ricordare per sempre che il consenso è stato dato dall\'utente.
    <td>Per sempre</td>
  </tr>   
</table>
';


$woocommerce_policy_text_it = '
<b>Cookies di WooCommerce</b>
<table style="width:100%">
  <tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>woocommerce_cart_hash</td>
    <td>Questo cookie è necessario per memorizzare gli articoli nel carrello per il processo di ordinazione.</td>
    <td>Sessione</td>
  </tr>
   <tr>
    <td>woocommerce_items_items_in_cart</td>
    <td>Aiuta WooCommerce a determinare quando il contenuto del carrello / dati cambia.</td>
    <td>Sessione</td>
  </tr> 
   <tr>
    <td>tk_ai</td>
    <td>Salva un ID anonimo generato in modo casuale. Questo viene utilizzato solo all\'interno dell\'area del cruscotto (/ wp-admin) e, se abilitato, viene utilizzato per il controllo dell\'utilizzo.</td>
    <td>Sessione</td>
  </tr> 
	<tr>
    <td>wp_woocommerce_session_<uniqeid></td></td>
    <td>Contiene un codice univoco per ogni cliente, in modo che sappia dove trovare i dati del carrello nel database per ogni cliente.</td>
    <td>2 giorni</td>
  </tr>  
   <tr>
    <td>wc_fragments_<uniqeid></td></td>
    <td>Salva un ID anonimo generato in modo casuale. Questo viene utilizzato solo all\'interno dell\'area del cruscotto (/ wp-admin) e, se abilitato, viene utilizzato per il controllo dell\'utilizzo.</td>
    <td>Sessione</td>
  </tr>   
   <tr>
    <td>wc_cart_hash<uniqeid></td></td>
    <td>Salva un ID anonimo generato in modo casuale. Questo viene utilizzato solo all\'interno dell\'area del cruscotto (/ wp-admin) e, se abilitato, viene utilizzato per il controllo dell\'utilizzo.</td>
    <td>Sessione</td>
  </tr>      
</table>
';


$wpml_policy_text_it = '
<b>Cookies da WPML</b>
<table style="width:100%">
  <tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>_icl_current_language</td>
    <td>Salva la lingua selezionata dall\'utente.</td>
    <td>1 anno</td>
  </tr>
  <tr>
    <td>_icl_visitor_lang_js</td>
    <td>Salva la lingua reindirizzata quando si cambia la lingua.</td>
    <td>1 anno</td>
  </tr>
  <tr>
    <td>wpml_browser_redirect_test</td>
    <td>Questo cookie determina se l\'uso dei cookie è stato disabilitato nel browser.</td>
    <td>1 anno</td>
  </tr>  
   <tr>
    <td>wpml_referer_url</td>
    <td>Salva l\'ultimo URL richiesto nel frontend.</td>
    <td>1 anno</td>
  </tr>    
 </table>
';



$dsgvoaio_policy_it = '
<b>Cookies di DSGVO AIO per WordPress</b>
<table style="width:100%">
  <tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>dsgvoaio</td>
    <td>Questa chiave LocalStorage / valore memorizza i servizi che l\'utente ha accettato o meno.</td>
    <td>variabile</td>
  </tr>
  <tr>
    <td>_uniqueuid</td>
    <td>Questa chiave / valore di LocalStorage memorizza un ID generato in modo che le azioni di opt-in / opt-out dell\'utente possano essere documentate. L\'ID è memorizzato in forma anonima.</td>
    <td>variabile</td>
  </tr>  
   <tr>
    <td>dsgvoaio_create</td>
    <td>Questa chiave / valore di LocalStorage memorizza il tempo in cui _uniqueuid è stato generato.</td>
    <td>variabile</td>
  </tr>  
   <tr>
    <td>dsgvoaio_vgwort_disable</td></td>
    <td>Questa chiave / valore di LocalStorage memorizza se il servizio VG word standard è consentito o meno (impostazione dell\'operatore della pagina).</td>
    <td>variabile</td>
  </tr>   
   <tr>
    <td>dsgvoaio_ga_disable</td>
    <td>Questa chiave / valore LocalStorage memorizza se il servizio Google Analytics Standard è consentito o meno (Assumere il gestore del sito).
    <td>variabile</td>
  </tr>    
 </table>
';


$wordpress_policy_sample_it = '
<h3>Biscotti generali</h3>
<b>Cookies da WordPress</b>
<table style="width:100%">
  <tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>wordpress_test_cookie</td>
    <td>Questo cookie determina se l\'uso dei cookie è stato disabilitato nel browser. Durata della memorizzazione: Fino alla fine della sessione del browser (verrà cancellato alla chiusura del browser).</td>
    <td>Sessione</td>
  </tr>
   <tr>
    <td>PHPSESSID</td>
    <td>Questo cookie memorizza la vostra attuale sessione rispetto alle applicazioni PHP, assicurando che tutte le funzionalità di questo sito web basate sul linguaggio di programmazione PHP siano completamente visualizzate. Durata della memorizzazione: Fino alla fine della sessione del browser (verrà cancellato alla chiusura del browser internet).</td>
    <td>Sessione</td>
  </tr> 
   <tr>
    <td>wordpress_akm_mobile</td>
    <td>Questi cookie vengono utilizzati solo per l\'area di amministrazione di WordPress.</td>
    <td>1 anno</td>
  </tr>   
   <tr>
    <td>wordpress_logged_in_akm_mobile</td>
    <td>Questi cookie sono utilizzati solo per l\'area di amministrazione di WordPress e non si applicano agli altri visitatori del sito.</td>
    <td>Sessione</td>
  </tr>   
   <tr>
    <td>wp-settings-akm_mobile</td>
    <td>Questi cookie sono utilizzati solo per l\'area di amministrazione di WordPress e non si applicano agli altri visitatori del sito.</td>
    <td>Sessione</td>
  </tr>   
   <tr>
    <td>wp-settings-time-akm_mobile</td>
    <td>Questi cookie sono utilizzati solo per l\'area di amministrazione di WordPress e non si applicano agli altri visitatori del sito.</td>
    <td>Sessione</td>
  </tr>     
   <tr>
    <td>ab</td>
    <td>È utilizzato per il test A / B delle nuove funzionalità.</td>
    <td>Sessione</td>
  </tr>      
   <tr>
    <td>akm_mobile</td>
    <td>salva se il visitatore vuole vedere la versione mobile di un sito web.</td>
    <td>1 Giorno</td>
  </tr>     
</table>
[dsgvoaio_plugins]
';



$polylang_policy_text_it = '
<b>Cookies da Polylang</b>
<table style="width:100%">
  <tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>pll_language</td>
    <td>Questo cookie memorizza la scelta della lingua e la provenienza geografica dell\'utente.</td>
    <td>1 Jahr</td>
  </tr>
 </table>
';


$youtube_policy_sample = '
<h3>YouTube</h3>
<p>Wir verwenden auf dieser Seite des Videodienstes YouTube, der Firma YouTube, LLC, 901 Cherry Ave., San Bruno, CA 94066, USA.</p>
<p>Durch das Aufrufen von Seiten unserer Webseite, die YouTube Videos integriert haben, werden Daten an YouTube übertragen, gespeichert und ausgewertet.<br />
Sollten Sie ein YouTube-Konto haben und angemeldet sein, werden diese Daten Ihrem persönlichen Konto und den darin gespeicherten Daten zugeordnet.</p>
<p>Welche Daten von Google erfasst werden und wofür diese Daten verwendet werden, können Sie auf <a href="https://www.google.com/intl/de/policies/privacy/" class="external" rel="nofollow">https://www.google.com/intl/de/policies/privacy/</a> nachlesen.</p>
<b>Cookies von Youtube</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>SID</td>
    <td>Google verwendet Cookies wie das NID- und das SID-Cookie, um Werbung in Google-Produkten wie der Google-Suche individuell anzupassen. Mithilfe solcher Cookies erfasst Google zum Beispiel Ihre neuesten Suchanfragen, Ihre bisherigen Interaktionen mit den Anzeigen eines Werbetreibenden oder den Suchergebnissen und Ihre Besuche auf der Website eines Werbetreibenden. Auf diese Weise kann Google individuell zugeschnittene Werbung auf Google anzeigen. Andere Google-Produkte wie YouTube oder Doubleclick nutzen diese Cookies ebenfalls zur Auswahl relevanterer Werbung.</td>
    <td>1 Jahr</td>
  </tr>
  <tr>
    <td>VISITOR_INFO1_LIVE</td>
    <td>Hierbei handelt es sich um ein Cookie, das YouTube setzt, um die Bandbreite des Nutzers zu berechnen. Anhand dieser Information wird bestimmt, ob der Nutzer die neue oder alte Benutzeroberfläche des Players verwenden sollte.</td>
    <td>bis zu 365 Tage</td>
  </tr>
  <tr>
    <td>PREF</td>
    <td>Mit diesem Cookie werden die Präferenzen und sonstige Informationen des Nutzers gespeichert. Dazu zählen insbesondere die bevorzugte Sprache, die Anzahl der auf der Seite anzuzeigenden Suchergebnisse sowie die Entscheidung, ob der Filter SafeSearch von Google aktiviert werden soll oder nicht.</td>
    <td>5 Jahre</td>
  </tr>  
  <tr>
    <td>APISID</td>
    <td>YouTube ist eine Plattform zur Bereitstellung und Veröffentlichung von Videos und gehört zu Google. YouTube sammelt Benutzerdaten über in Websites eingebettete Videos, die mit Profildaten aus anderen Google-Diensten zusammengeführt werden. So kann Website-Besuchern gezielte Werbung über eine breite Palette eigener und fremder Websites angezeigt werden.</td>
    <td>10 Jahre</td>
  </tr>   
  <tr>
    <td>YSC</td>
    <td>Dieses Cookie wird vom Videodienst YouTube auf Webseiten mit eingebetteten YouTube-Videos gesetzt.</td>
    <td>1 Jahr</td>
  </tr>  
  <tr>
    <td>GPS</td>
    <td>YouTube ist eine Plattform zur Bereitstellung und Veröffentlichung von Videos und gehört zu Google. YouTube sammelt Benutzerdaten über in Websites eingebettete Videos, die mit Profildaten aus anderen Google-Diensten zusammengeführt werden. So kann Website-Besuchern gezielte Werbung über eine breite Palette eigener und fremder Websites angezeigt werden.</td>
    <td>1 Tag</td>
  </tr>    
    <tr>
    <td>SSID</td>
    <td>Quelle: OneTrust. YouTube ist eine Plattform zur Bereitstellung und Veröffentlichung von Videos und gehört zu Google. YouTube sammelt Benutzerdaten über in Websites eingebettete Videos, die mit Profildaten aus anderen Google-Diensten zusammengeführt werden. So kann Website-Besuchern gezielte Werbung über eine breite Palette eigener und fremder Websites angezeigt werden.</td>
    <td>1 Jahr</td>
  </tr>    
    <tr>
    <td>LOGIN_INFO</td>
    <td>YouTube ist eine Plattform zur Bereitstellung und Veröffentlichung von Videos und gehört zu Google. YouTube sammelt Benutzerdaten über in Websites eingebettete Videos, die mit Profildaten aus anderen Google-Diensten zusammengeführt werden. So kann Website-Besuchern gezielte Werbung über eine breite Palette eigener und fremder Websites angezeigt werden.</td>
    <td>2 Jahre</td>
  </tr>    
    <tr>
    <td>SAPISID</td>
    <td>Diese Domain ist Eigentum der Google Inc. Google ist zwar in erster Linie als Suchmaschine bekannt, allerdings bietet das Unternehmen eine breite Palette von Produkten und Dienstleistungen an. Haupteinnahmequelle ist jedoch die Werbung. Google verfolgt die Bewegungen der Nutzer umfassend – sowohl über eigene Produkte und Websites als auch mit Hilfe der weltweit in Millionen von Websites integrierten vielfältigen Technologien.</td>
    <td>1 Jahr</td>
  </tr>   
     <tr>
    <td>HSID</td>
    <td>Wird von Google in Verbindung mit SID verwendet, um das Google-Benutzerkonto und die letzte Anmeldezeit zu überprüfen https://policies.google.com/technologies/types?hl=de</td>
    <td>1 Jahr</td>
  </tr>    
</table>
';

$youtube_policy_sample_it = '
<h3>YouTube</h3>
<p>In questa pagina di servizio video, utilizziamo YouTube, la società YouTube, LLC, 901 Cherry Ave., San Bruno, CA 94066, USA. </p>
<p>Accedendo alle pagine del nostro sito web che hanno integrato i video di YouTube, i dati saranno trasmessi a YouTube, memorizzati e valutati. <br />
Se hai un account YouTube e hai effettuato l\'accesso, queste informazioni saranno associate al tuo account personale e ai dati in esso memorizzati. </p>
<p>Quali dati raccoglie Google e a cosa servono questi dati si possono trovare su <a href="https://www.google.com/intl/en/policies/privacy/" leggere class="external" rel="nofollow"> https://www.google.com/intl/en/policies/privacy/ </a>. </p>
<b>Cookies da Youtube</b>
<table style="width:100%">
  <tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>SID</td>
    <td>Google utilizza cookie come i cookie NID e SID per personalizzare la pubblicità nei prodotti Google, come ad esempio la ricerca Google. Utilizzando tali cookie, Google registra, ad esempio, le vostre ultime ricerche, le vostre precedenti interazioni con gli annunci o i risultati di ricerca di un inserzionista e le vostre visite al sito web di un inserzionista. In questo modo, Google può visualizzare la pubblicità personalizzata su Google. Anche altri prodotti Google, come YouTube o Doubleclick, utilizzano questi cookie per selezionare pubblicità più rilevanti.</td>
    <td>1 anno</td>
  </tr>
  <tr>
    <td>VISITOR_INFO1_LIVE</td>
    <td>Si tratta di un cookie che YouTube imposta per calcolare la larghezza di banda dell\'utente. Questa informazione viene utilizzata per determinare se l\'utente deve utilizzare la nuova o la vecchia interfaccia utente del lettore.</td>
    <td>0-365 giorni</td>
  </tr>
  <tr>
    <td>PREF</td>
    <td>Questo cookie memorizza le preferenze dell\'utente e altre informazioni. Ciò include in particolare la lingua preferita, il numero di risultati di ricerca da visualizzare sulla pagina e la decisione se il filtro SafeSearch debba essere attivato o meno da Google.</td>
    <td>5 anni</td>
  </tr>  
  <tr>
    <td>APISID</td>
    <td>YouTube è una piattaforma per la fornitura e la pubblicazione di video e fa parte di Google. YouTube raccoglie i dati degli utenti attraverso i video incorporati nei siti web, che vengono uniti ai dati del profilo di altri servizi di Google. In questo modo è possibile mostrare ai visitatori del sito web pubblicità mirata attraverso una vasta gamma di siti web propri e di terzi.</td>
    <td>10 anni</td>
  </tr>   
  <tr>
    <td>YSC</td>
    <td>Questo cookie è impostato dal servizio video YouTube su siti web con video YouTube integrati.</td>
    <td>1 anno</td>
  </tr>  
  <tr>
    <td>GPS</td>
    <td>YouTube è una piattaforma per la fornitura e la pubblicazione di video e fa parte di Google. YouTube raccoglie i dati degli utenti attraverso i video incorporati nei siti web, che vengono uniti ai dati del profilo di altri servizi di Google. In questo modo è possibile mostrare ai visitatori del sito web pubblicità mirata attraverso una vasta gamma di siti web propri e di terzi.</td>
    <td>1 Giorno</td>
  </tr>    
    <tr>
    <td>SSID</td>
    <td>YouTube è una piattaforma per la fornitura e la pubblicazione di video e fa parte di Google. YouTube raccoglie i dati degli utenti attraverso i video incorporati nei siti web, che vengono uniti ai dati del profilo di altri servizi di Google. In questo modo è possibile mostrare ai visitatori del sito web pubblicità mirata attraverso una vasta gamma di siti web propri e di terzi.</td>
    <td>1 anno</td>
  </tr>    
    <tr>
    <td>LOGIN_INFO</td>
    <td>YouTube è una piattaforma per la fornitura e la pubblicazione di video e fa parte di Google. YouTube raccoglie i dati degli utenti attraverso i video incorporati nei siti web, che vengono uniti ai dati del profilo di altri servizi di Google. In questo modo è possibile mostrare ai visitatori del sito web pubblicità mirata attraverso una vasta gamma di siti web propri e di terzi.</td>
    <td>2 anni</td>
  </tr>    
    <tr>
    <td>SAPISID</td>
    <td>Questo dominio è di proprietà di Google Inc. Google è conosciuto principalmente come motore di ricerca, ma l\'azienda offre una vasta gamma di prodotti e servizi. La principale fonte di reddito è la pubblicità. Google segue ampiamente i movimenti degli utenti - sia attraverso i propri prodotti e siti web, sia con l\'aiuto delle diverse tecnologie integrate in milioni di siti web in tutto il mondo.</td>
    <td>1 anno</td>
  </tr>   
     <tr>
    <td>HSID</td>
    <td>Usato da Google in connessione con SID per controllare l\'account utente di Google e l\'ultima volta che ha effettuato il login https://policies.google.com/technologies/types?hl=de</td>
    <td>1 anno</td>
  </tr>    
</table>
';


$youtube_policy_sample_en = '
<h3>YouTube</h3>
<p> On this video service page, we use YouTube, the company YouTube, LLC, 901 Cherry Ave., San Bruno, CA 94066, USA. </p>
<p> By accessing pages on our website that have integrated YouTube videos, data will be transmitted to YouTube, stored and evaluated. <br />
If you have a YouTube account and you\'re signed in, that information will be associated with your personal account and the data stored in it. </p>
<p> What data Google collects and what this data is used for can be found on <a href="https://www.google.com/intl/en/policies/privacy/" read class="external" rel="nofollow"> https://www.google.com/intl/en/policies/privacy/ </a>. </p>
<b>Cookies from Youtube</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>SID</td>
    <td>Google uses cookies such as the NID and SID cookies to customize advertising in Google products such as Google search. Using such cookies, Google records, for example, your latest searches, your previous interactions with an advertiser\'s ads or search results, and your visits to an advertiser\'s website. In this way, Google can display customized advertising on Google. Other Google products such as YouTube or Doubleclick also use these cookies to select more relevant advertising.</td>
    <td>1 Year</td>
  </tr>
  <tr>
    <td>VISITOR_INFO1_LIVE</td>
    <td>This is a cookie that YouTube sets to calculate the bandwidth of the user. This information is used to determine whether the user should use the player\'s new or old user interface.</td>
    <td>0-365 Days</td>
  </tr>
  <tr>
    <td>PREF</td>
    <td>This cookie stores the user\'s preferences and other information. This includes in particular the preferred language, the number of search results to be displayed on the page and the decision whether the SafeSearch filter should be activated by Google or not.</td>
    <td>5 Years</td>
  </tr>  
  <tr>
    <td>APISID</td>
    <td>YouTube is a platform for the provision and publication of videos and is part of Google. YouTube collects user data via videos embedded in websites, which are merged with profile data from other Google services. In this way, website visitors can be shown targeted advertising via a wide range of their own and third-party websites.</td>
    <td>10 Years</td>
  </tr>   
  <tr>
    <td>YSC</td>
    <td>This cookie is set by the video service YouTube on websites with embedded YouTube videos.</td>
    <td>1 Year</td>
  </tr>  
  <tr>
    <td>GPS</td>
    <td>YouTube is a platform for the provision and publication of videos and is part of Google. YouTube collects user data via videos embedded in websites, which are merged with profile data from other Google services. In this way, website visitors can be shown targeted advertising via a wide range of their own and third-party websites.</td>
    <td>1 Day</td>
  </tr>    
    <tr>
    <td>SSID</td>
    <td>YouTube is a platform for the provision and publication of videos and is part of Google. YouTube collects user data via videos embedded in websites, which are merged with profile data from other Google services. In this way, website visitors can be shown targeted advertising via a wide range of their own and third-party websites.</td>
    <td>1 Year</td>
  </tr>    
    <tr>
    <td>LOGIN_INFO</td>
    <td>YouTube is a platform for the provision and publication of videos and is part of Google. YouTube collects user data via videos embedded in websites, which are merged with profile data from other Google services. In this way, website visitors can be shown targeted advertising via a wide range of their own and third-party websites.</td>
    <td>2 Years</td>
  </tr>    
    <tr>
    <td>SAPISID</td>
    <td>This domain is owned by Google Inc. Google is primarily known as a search engine, but the company offers a wide range of products and services. The main source of income is advertising. Google tracks user movements extensively - both through its own products and websites and with the help of the diverse technologies integrated into millions of websites worldwide.</td>
    <td>1 Year</td>
  </tr>   
     <tr>
    <td>HSID</td>
    <td>Used by Google in connection with SID to check the Google user account and the last login time https://policies.google.com/technologies/types?hl=de</td>
    <td>1 Year</td>
  </tr>    
</table>
';

$vimeo_policy_sample = '
<h3>Vimeo</h3>
<p>Auf unserer Website sind Plugins des Videoportals Vimeo der Vimeo, LLC, 555 West 18th Street, New York, New York 10011, USA eingebunden. Bei jedem Aufruf einer Seite, die ein oder mehrere Vimeo-Videoclips anbietet, wird eine direkte Verbindung zwischen Ihrem Browser und einem Server von Vimeo in den USA hergestellt. Dabei werden Informationen über Ihren Besuch und Ihre IP-Adresse dort gespeichert. Durch Interaktionen mit den Vimeo Plugins (z.B. Klicken des Start-Buttons) werden diese Informationen ebenfalls an Vimeo übermittelt und dort gespeichert. Die Datenschutzerklärung für Vimeo mit näheren Informationen zur Erhebung und Nutzung Ihrer Daten durch Vimeo finden Sie in der <a href="http://vimeo.com/privacy">Datenschutzerklärung von Vimeo</a>.</p>
<p>Wenn Sie ein Vimeo-Benutzerkonto haben und nicht möchten, dass Vimeo über diese Website Daten über Sie sammelt und mit Ihren bei Vimeo gespeicherten Mitgliedsdaten verknüpft, müssen Sie sich vor Ihrem Besuch dieser Website bei Vimeo ausloggen.</p>
<p>Außerdem ruft Vimeo über einen iFrame, in dem das Video aufgerufen wird, den Tracker Google Analytics auf. Dabei handelt es sich um ein eigenes Tracking von Vimeo, auf das wir keinen Zugriff haben. Sie können das Tracking durch Google Analytics unterbinden, indem Sie die Deaktivierungs-Tools einsetzen, die Google für einige Internet-Browser anbietet. Sie können darüber hinaus die Erfassung der durch Google Analytics erzeugten und auf ihre Nutzung der Website bezogenen Daten (inkl. Ihrer IP-Adresse) an Google sowie die Verarbeitung dieser Daten durch Google verhindern, indem Sie das unter dem folgendenlink verfügbare Browser-Plugin herunterladen und installieren:</p>
<p><a href="http://tools.google.com/dlpage/gaoptout?hl=de">http://tools.google.com/dlpage/gaoptout?hl=de</a></p>
<b>Cookies von Vimeo</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Zweck</th>
    <th>Gültigkeit</th>
  </tr>
  <tr>
    <td>vimeo</td>
    <td>Video Hosting: Authentication Token.</td>
    <td>Session</td>
  </tr>
  <tr>
    <td>uid</td>
    <td>Traffic Analyse: Analytics Tracking ID.</td>
    <td>Session</td>
  </tr>
  <tr>
    <td>vuid</td>
    <td>Traffic Analyse: Analytics Unique ID.</td>
    <td>2 Jahre</td>
  </tr>
  <tr>
    <td>player</td>
    <td>Traffic Analyse.</td>
    <td>1 Jahr</td>
  </tr>  
  <tr>
    <td>_uetsid</td>
    <td>Traffic Analyse.</td>
    <td>30 Minuten</td>
  </tr>    
</table>
';

$vimeo_policy_sample_it = '
<h3>Vimeo</h3>
<p>Il nostro sito web include i plugin del Vimeo Video Portal di Vimeo, LLC, 555 West 18th Street, NY, New York 10011, USA. Ogni volta che visitate una pagina che offre uno o più video clip Vimeo, viene stabilita una connessione diretta tra il vostro browser e un server Vimeo negli Stati Uniti. Queste informazioni sulla vostra visita e il vostro indirizzo IP sono memorizzati lì. Attraverso le interazioni con i plugin Vimeo (ad esempio, cliccando sul pulsante Start), anche queste informazioni vengono trasmesse a Vimeo e lì memorizzate. Per ulteriori informazioni sulla raccolta e l\'utilizzo dei dati sulla privacy da parte di Vimeo, consultare la Vimeo <a href="http://vimeo.com/privacy"> Privacy Policy </a>.</p>
<p>Se hai un account utente Vimeo e non vuoi che Vimeo raccolga informazioni su di te da questo sito web e le colleghi ai tuoi dati utente memorizzati con Vimeo, devi effettuare il logout da Vimeo prima di visitare questo sito web.</p>
<p>Inoltre, Vimeo chiama il tracker di Google Analytics tramite un iframe che chiama il video. Si tratta di un tracking separato di Vimeo, al quale non abbiamo accesso. È possibile interrompere il tracciamento di Google Analytics utilizzando gli strumenti di opt-out che Google offre per alcuni browser Internet. Potete anche impedire il rilevamento da parte di Google dei dati generati da Google Analytics e relativi al vostro utilizzo del sito web (compreso il vostro indirizzo IP) e l\'elaborazione di questi dati da parte di Google scaricando i dati disponibili al seguente link plugin del browser e installandoli:</p>
<p><a href="http://tools.google.com/dlpage/gaoptout?hl=en"> http://tools.google.com/dlpage/gaoptout?hl=en </a></p>
<b>Cookies da Vimeo</b>
<table style="width:100%">
  <tr>
    <th>Nome</th>
    <th>Purpose</th>
    <th>Validità</th>
  </tr>
  <tr>
    <td>vimeo</td>
    <td>Video Hosting: Gettone di autenticazione.</td>
    <td>Sessione</td>
  </tr>
  <tr>
    <td>uid</td>
    <td>Analisi del traffico: Analytics Tracking ID.</td>
    <td>Sessione</td>
  </tr>
  <tr>
    <td>vuid</td>
    <td>Analisi del traffico: Analitica ID.</td>
    <td>2 anni</td>
  </tr>
  <tr>
    <td>player</td>
    <td>Analisi del traffico.</td>
    <td>1 anno</td>
  </tr>  
  <tr>
    <td>_uetsid</td>
    <td>Analisi del traffico.</td>
    <td>30 Minuti</td>
  </tr>    
</table>
';

$vimeo_policy_sample_en = '
<h3>Vimeo</h3>
<p>Our website includes plugins from Vimeo Video Portal of Vimeo, LLC, 555 West 18th Street, NY, New York 10011, USA. Each time you visit a page that offers one or more Vimeo video clips, a direct connection is established between your browser and a Vimeo server in the United States. This information about your visit and your IP address are stored there. Through interactions with the Vimeo plugins (for example, clicking the Start button), this information is also transmitted to Vimeo and stored there. For more information about Vimeo\'s collection and use of your privacy data, see the Vimeo <a href="http://vimeo.com/privacy"> Privacy Policy </a>.</p>
<p>If you have a Vimeo user account and do not want Vimeo to collect information about you from this website and link it to your member data stored with Vimeo, you must log out of Vimeo before visiting this website.</p>
<p>In addition, Vimeo calls the Google Analytics tracker via an iframe calling the video. This is a separate tracking of Vimeo, to which we have no access. You can stop Google Analytics tracking by using the opt-out tools that Google offers for some Internet browsers. You may also prevent the collection by Google of the data generated by Google Analytics and related to your use of the website (including your IP address) and the processing of this data by Google by downloading the available under the following link browser plugin and install:</p>
<p><a href="http://tools.google.com/dlpage/gaoptout?hl=en"> http://tools.google.com/dlpage/gaoptout?hl=en </a></p>
<b>Cookies from Vimeo</b>
<table style="width:100%">
  <tr>
    <th>Name</th>
    <th>Purpose</th>
    <th>Validity</th>
  </tr>
  <tr>
    <td>vimeo</td>
    <td>Video Hosting: Authentication Token.</td>
    <td>Session</td>
  </tr>
  <tr>
    <td>uid</td>
    <td>Traffic Analytics: Analytics Tracking ID.</td>
    <td>Session</td>
  </tr>
  <tr>
    <td>vuid</td>
    <td>Traffic Analytics: Analytics Unique ID.</td>
    <td>2 Years</td>
  </tr>
  <tr>
    <td>player</td>
    <td>Traffic Analytics.</td>
    <td>1 Year</td>
  </tr>  
  <tr>
    <td>_uetsid</td>
    <td>Traffic Analytics.</td>
    <td>30 Minutes</td>
  </tr>    
</table>
';


$shareaholic_layer_sample = "
<p>Für die Nutzung von Shareaholic (Shareaholic Inc., Dogpatch Labs 1, Cambridge Center, Suite 600, Cambridge, MA 02142) benötigen wir laut DSGVO Ihre Zustimmung.</p>
<p>Es werden seitens Shareaholic personenbezogene Daten erhoben, verarbeitet und gespeichert. Welche Daten genau entnehmen Sie bitte den Datenschutzbedingungen.</p>
";

$shareaholic_layer_sample_en = "
<p>For the use of Shareaholic (Shareaholic Inc., Dogpatch Labs 1, Cambridge Center, Suite 600, Cambridge, MA 02142) we need your consent according to DSGVO.</p>
<p>Shareaholic collects, processes and stores personal data. Which data exactly you take from the data protection conditions.
";

$shareaholic_layer_sample_it = "
<p>Per l'utilizzo di Shareaholic (Shareaholic Inc., Dogpatch Labs 1, Cambridge Center, Suite 600, Cambridge, MA 02142) abbiamo bisogno del vostro consenso secondo DSGVO.</p>
<p>Shareaholic raccoglie, elabora e memorizza i dati personali. Quali dati esattamente si prendono dalle condizioni di protezione dei dati per favore.</p>
";


$vgwort_layer_sample = "
<p>Für die Nutzung von VG Wort (VG WORT, Untere Weidenstraße 5, 81543 München) benötigen wir laut DSGVO Ihre Zustimmung.</p>
<p>Es werden seitens VG Wort personenbezogene Daten erhoben, verarbeitet und gespeichert. Welche Daten genau entnehmen Sie bitte den Datenschutzbedingungen.</p>
";

$vgwort_layer_sample_en = "
<p>For the use of VG Wort (VG WORT, Untere Weidenstraße 5, 81543 München) we need your consent according to DSGVO.</p>
<p>VG Wort collects, processes and stores personal data. Which data exactly you take from the data protection conditions.
";

$vgwort_layer_sample_it = "
<p>Per l'utilizzo di VG Wort (VG WORT, Untere Weidenstraße 5, 81543 München) abbiamo bisogno del vostro consenso secondo DSGVO.</p>
<p>VG Wort raccoglie, elabora e memorizza i dati personali. Quali dati esattamente si prendono dalle condizioni di protezione dei dati per favore.</p>
";


$youtube_layer_sample = "
<p>Für die Nutzung von YouTube (YouTube, LLC, 901 Cherry Ave., San Bruno, CA 94066, USA) benötigen wir laut DSGVO Ihre Zustimmung.</p>
<p>Es werden seitens YouTube personenbezogene Daten erhoben, verarbeitet und gespeichert. Welche Daten genau entnehmen Sie bitte den Datenschutzbedingungen.</p>
";

$youtube_layer_sample_en = "
<p>For the use of YouTube (YouTube, LLC, 901 Cherry Ave., San Bruno, CA 94066, USA) we need your consent according to DSGVO.</p>
<p>YouTube collects, processes and stores personal data. Which data exactly you take from the data protection conditions.
";

$youtube_layer_sample_it = "
<p>Per l'utilizzo di YouTube (YouTube, LLC, 901 Cherry Ave., San Bruno, CA 94066, USA) abbiamo bisogno del vostro consenso secondo DSGVO.</p>
<p>YouTube raccoglie, elabora e memorizza i dati personali. Quali dati esattamente si prendono dalle condizioni di protezione dei dati per favore.</p>
";

$vimeo_layer_sample = "
<p>Für die Nutzung von Vimeo (Vimeo, LLC, 555 West 18th Street, NY, New York 10011, USA) benötigen wir laut DSGVO Ihre Zustimmung.</p>
<p>Es werden seitens Vimeo personenbezogene Daten erhoben, verarbeitet und gespeichert. Welche Daten genau entnehmen Sie bitte den Datenschutzbedingungen.</p>
";

$vimeo_layer_sample_en = "
<p>For the use of Vimeo (Vimeo, LLC, 555 West 18th Street, NY, New York 10011, USA) we need your consent according to DSGVO.</p>
<p>Vimeo collects, processes and stores personal data. Which data exactly you take from the data protection conditions.
";

$vimeo_layer_sample_it = "
<p>Per l'utilizzo di Vimeo (Vimeo, LLC, 555 West 18th Street, NY, New York 10011, USA) abbiamo bisogno del vostro consenso secondo DSGVO.</p>
<p>Vimeo raccoglie, elabora e memorizza i dati personali. Quali dati esattamente si prendono dalle condizioni di protezione dei dati per favore.</p>
";

$linkedin_layer_sample = "
<p>Für die Nutzung von LinkedIn (LinkedIn AG, Dammtorstraße 29-32, 20354 Hamburg, Germany) benötigen wir laut DSGVO Ihre Zustimmung.</p>
<p>Es werden seitens LinkedIn personenbezogene Daten erhoben, verarbeitet und gespeichert. Welche Daten genau entnehmen Sie bitte den Datenschutzbedingungen.</p>
";

$linkedin_layer_sample_en = "
<p>For the use of LinkedIn (LinkedIn AG, Dammtorstraße 29-32, 20354 Hamburg, Germany) we need your consent according to DSGVO.</p>
<p>LinkedIn collects, processes and stores personal data. Which data exactly you take from the data protection conditions.
";

$linkedin_layer_sample_it = "
<p>Per l'utilizzo di LinkedIn (LinkedIn AG, Dammtorstraße 29-32, 20354 Hamburg, Germany) abbiamo bisogno del vostro consenso secondo DSGVO.</p>
<p>LinkedIn raccoglie, elabora e memorizza i dati personali. Quali dati esattamente si prendono dalle condizioni di protezione dei dati per favore.</p>
";

$twitter_layer_sample = "
<p>Für die Nutzung von Twitter (Twitter International Company, One Cumberland Place, Fenian Street Dublin 2, D02 AX07, Ireland) benötigen wir laut DSGVO Ihre Zustimmung.</p>
<p>Es werden seitens Twitter personenbezogene Daten erhoben, verarbeitet und gespeichert. Welche Daten genau entnehmen Sie bitte den Datenschutzbedingungen.</p>
";

$twitter_layer_sample_en = "
<p>For the use of Twitter (Twitter International Company, One Cumberland Place, Fenian Street Dublin 2, D02 AX07, Ireland) we need your consent according to DSGVO.</p>
<p>Twitter collects, processes and stores personal data. Which data exactly you take from the data protection conditions.
";

$twitter_layer_sample_it = "
<p>Per l'utilizzo di Twitter (Twitter International Company, One Cumberland Place, Fenian Street Dublin 2, D02 AX07, Ireland) abbiamo bisogno del vostro consenso secondo DSGVO.</p>
<p>Twitter raccoglie, elabora e memorizza i dati personali. Quali dati esattamente si prendono dalle condizioni di protezione dei dati per favore.</p>
";