import {Tooltip} from "react-tooltip";

const {ColorPicker,} = wp.components || {};

export default function ColorPickerWrapper({value, onChange, allowReset = false, resetValue = ''}) {
    const uniqueId = 'color-picker-' + Math.random().toString(36).substring(7);

    return (
        <div className="dracula-color-picker-wrapper">

            <div className="color-holder-wrap">
                <div
                    data-tooltip-id={uniqueId}
                    className="color-holder"
                    style={{background: value}}
                ></div>

                <input
                    type="text"
                    className="color-input"
                    value={value}
                    onChange={(e) => onChange(e.target.value)}
                />

                <i
                    data-tooltip-id={uniqueId}
                    className={`dracula-popup-edit color-edit dashicons dashicons-edit`}></i>

                {allowReset && !!value &&
                    <i className={`popup-settings-reset dashicons dashicons-image-rotate`}
                       onClick={() => onChange(null)}
                       title={wp.i18n.__('Reset', 'cf7-extended')}
                    ></i>
                }

                <Tooltip id={uniqueId}
                         effect="solid"
                         place="top"
                         variant="light"
                         openOnClick={true}
                         clickable={true}
                         delayHide={100}
                         className="dracula-tooltip color-picker-tooltip"
                         positionStrategy="absolute"
                         border={'1px solid #ccc'}
                >
                    <ColorPicker
                        color={value}
                        onChange={onChange}
                        enableAlpha={true}
                    />
                </Tooltip>


            </div>


        </div>
    )
}