import {
    getConfig,
    handleAttentionEffect,
    handleDraculaHides,
    handleDraggableToggle,
    initToggles
} from "./includes/functions";

;(function ($) {

    const {
        isPro,
        settings = {},
    } = dracula;

    const {
        frontendDarkMode = true,
        keyboardShortcuts = false,
        toggleTriggers = [],
        delayToggle,
        delayToggleTime = 5,
    } = settings;

    const config = getConfig();

    const app = {

        init: function () {

            // Init Toggle Switches
            if (delayToggle === true) {
                setTimeout(() => {
                    initToggles();
                }, delayToggleTime * 1000);
            } else {
                initToggles();
            }

            // Exclude buttons
            app.excludeButtons();

            // Elementor
            $(window).on('elementor/frontend/init', function () {

                // Render Frontend Switch
                window.elementorFrontend.hooks.addAction('frontend/element_ready/dracula_switch.default', () => {
                    initToggles();
                });
            });

        },

        ready: function () {

            // Handle keyboard shortcuts
            if (!!keyboardShortcuts) {
                $(document).on('keydown', app.handleKeydown);
            }

            // Custom trigger toggle
            if (!!isPro && toggleTriggers.length > 0) {
                toggleTriggers.forEach((toggleTrigger) => {
                    const {selector, type} = toggleTrigger;

                    if (selector.length > 0) {
                        if (type === 'switch-toggle-mode') {
                            $(selector).on('click', () => draculaDarkMode.toggle(config));
                        } else if (type === 'switch-dark-mode') {
                            $(selector).on('click', () => draculaDarkMode.enable(config));
                        } else if (type === 'switch-light-mode') {
                            $(selector).on('click', () => draculaDarkMode.disable());
                        } else {
                            $(selector).on('click', () => draculaDarkMode.toggle(config));
                        }
                    }

                })
            }

            // Reading Mode button click
            $('.reading-mode-button').on('click', app.handleReadingMode);

            // handle attention effect
            handleAttentionEffect();

            // handle draggable floating toggle
            handleDraggableToggle();

            // hide elements
            handleDraculaHides();
        },

        handleKeydown: function (e) {

            //Ctrl + Alt + D (windows) or Cmd + Alt + D (mac)
            if (e.ctrlKey && e.altKey && e.keyCode === 68 || e.metaKey && e.altKey && e.keyCode === 68) {
                e.preventDefault();

                if (draculaDarkMode.isEnabled()) {
                    draculaDarkMode.disable();
                } else {
                    draculaDarkMode.enable(config);
                }
            }
        },

        handleReadingMode: function (e) {
            e.preventDefault();

            const postID = $(this).data('post-id');

            if (!postID) return;

            const body = $('body');

            const iframe = $(`#reading-mode-iframe-${postID}`);
            if (iframe.length) {
                body.addClass('reading-mode-enabled');
                iframe.addClass('active');
            } else {
                body.addClass('reading-mode-enabled');
                const html = `<iframe src="${dracula.homeUrl}/?reading-mode=${postID}" class="reading-mode-iframe active" id="reading-mode-iframe-${postID}"></iframe>`;
                body.append(html);
            }

            // focus on iframe
            iframe.focus();

        },

        excludeButtons: () => {
            const excludeSelectors = 'nav, #comments';

            $('.reading-mode-buttons').each(function () {
                if ($(this).parents(excludeSelectors).length) {
                    $(this).remove();
                }
            });
        },


    }

    if (frontendDarkMode) {
        app.init();
    }

    $(document).ready(app.ready);

})(jQuery);