import Toggles from "./components/Settings/Toggles";
import LiveEdit from "./components/LiveEdit";

const $ = jQuery;

const app = {

    ready: () => {

        // Render Toggle Selection
        elementor.hooks.addAction('panel/open_editor/widget', function (panel, model, view) {
            const style = $('[data-setting="style"]').val();

            const togglesElement = document.getElementById('dracula-elementor-toggles');

            if (togglesElement) {
                ReactDOM.render(
                    <Toggles
                        value={style}
                        onChange={(value, data) => {
                            $('[data-setting="style"]').val(value).trigger('input');
                        }}
                    />,
                    togglesElement
                );


            }

        });

        // Render Settings
        $(document).on('mousedown', '.elementor-control-_dracula_settings_section', function (e) {
            setTimeout(function () {
                const settingsElement = document.getElementById('dracula-elementor-settings');

                if (settingsElement) {
                    ReactDOM.render(<LiveEdit isEditor={'elementor'}/>, settingsElement);
                }

            }, 300);
        });

    },


}

$(document).ready(app.ready);