import ToggleBuilderContext from "../../contexts/ToggleBuilderContext";
import ColorPickerWrapper from "../../includes/ColorPickerWrapper";

const {
    __experimentalRadioGroup: RadioGroup,
    __experimentalRadio: Radio,
    RangeControl,
    GradientPicker,
} = wp.components;

const {useContext} = React;

export default function Style() {

    const context = useContext(ToggleBuilderContext);

    const {data, setData, state} = context;

    const {
        layout,
        width,
        padding,
        textSize,
        lightTextColor,
        darkTextColor,
        backgroundColorType,
        lightBackgroundColor,
        darkBackgroundColor,
        lightBorderColor,
        darkBorderColor,
        borderWidth,
        borderRadius,
        iconSpacing,
    } = data;

    const isDark = 'dark' === state;

    return (
        <div className="settings-style">
            <h4 className={`settings-header`}>{wp.i18n.__('Style Settings','dracula-dark-mode')}</h4>

            {/* Width */}
            {!isDark &&
                <div className="settings-field">
                    <span className="settings-field-label">{wp.i18n.__('Width','dracula-dark-mode')}</span>

                    <div className="settings-field-content">
                        <RangeControl
                            value={parseInt(width)}
                            step={5}
                            onChange={width => setData({...data, width: parseInt(width)})}
                            min={20}
                            max={400}
                            allowReset
                            resetFallbackValue={100}
                            className={'dracula-range-control'}
                        />

                        <p className="description">{wp.i18n.__('Set the button width.','dracula-dark-mode')}</p>
                    </div>
                </div>
            }

            {/* Padding */}
            {!isDark &&
                <div className="settings-field">
                    <span className="settings-field-label">{wp.i18n.__('Padding','dracula-dark-mode')}</span>

                    <div className="settings-field-content">
                        <RangeControl
                            value={parseInt(padding)}
                            step={1}
                            onChange={padding => setData({...data, padding: parseInt(padding)})}
                            min={0}
                            max={30}
                            allowReset
                            resetFallbackValue={10}
                            className={'dracula-range-control'}
                        />
                        <p className="description">{wp.i18n.__('Set the button padding spacing.','dracula-dark-mode')}</p>
                    </div>
                </div>
            }

            {/* Text & Icon Size */}
            {!isDark && 1 != layout &&
                <div className="settings-field">
                    <span className="settings-field-label">{wp.i18n.__('Text & Icon Size','dracula-dark-mode')}</span>

                    <div className="settings-field-content">
                        <RangeControl
                            value={parseInt(textSize)}
                            step={1}
                            onChange={textSize => setData({...data, textSize: parseInt(textSize)})}
                            min={10}
                            max={50}
                            allowReset
                            resetFallbackValue={15}
                            className={'dracula-range-control'}
                        />

                        <p className="description">{wp.i18n.__('Set the text and icon size.','dracula-dark-mode')}</p>
                    </div>
                </div>
            }

            {/* Icon Spacing */}
            {!isDark && 1 != layout &&
                <div className="settings-field">
                    <span className="settings-field-label">{wp.i18n.__('Text & Icon Spacing','dracula-dark-mode')}</span>

                    <div className="settings-field-content">
                        <RangeControl
                            value={parseInt(iconSpacing)}
                            step={1}
                            onChange={iconSpacing => setData({...data, iconSpacing: parseInt(iconSpacing)})}
                            min={0}
                            max={100}
                            allowReset
                            resetFallbackValue={10}
                            className={'dracula-range-control'}
                        />
                        <p className="description">{wp.i18n.__('Set the spacing between the text and icon.','dracula-dark-mode')}</p>
                    </div>
                </div>
            }

            {/* Text & Icon Color */}
            <div className="settings-field">
                <span className="settings-field-label">{wp.i18n.__('Text & Icon Color','dracula-dark-mode')}</span>

                <div className="settings-field-content">
                    <ColorPickerWrapper
                        value={isDark ? darkTextColor : lightTextColor}
                        onChange={color => {
                            if (isDark) {
                                setData({...data, darkTextColor: color});
                            } else {
                                setData({...data, lightTextColor: color});
                            }
                        }}
                    />

                    <p className="description">{wp.i18n.__('Set the button text and icon color.','dracula-dark-mode')}</p>
                </div>
            </div>

            {/* Background Color */}
            <div className="settings-field">
                <span className="settings-field-label">{wp.i18n.__('Background Color','dracula-dark-mode')}</span>

                <div className="settings-field-content">
                    <RadioGroup label="Background Color Type" checked={backgroundColorType}
                                onChange={backgroundColorType => setData({...data, backgroundColorType})}
                                className={'dracula-radio-group'}>
                        <Radio value="solid">{wp.i18n.__('Solid', 'dracula-dark-mode')}</Radio>
                        <Radio value="gradient">{wp.i18n.__('Gradient', 'dracula-dark-mode')}</Radio>
                    </RadioGroup>

                    <p className="description">{wp.i18n.__('Choose the button background color type.','dracula-dark-mode')}</p>

                    <div className="sub_group">
                        {'solid' === backgroundColorType &&
                            <ColorPickerWrapper
                                value={isDark ? darkBackgroundColor : lightBackgroundColor}
                                onChange={backgroundColor => {
                                    if (isDark) {
                                        setData({...data, darkBackgroundColor: backgroundColor});
                                    } else {
                                        setData({...data, lightBackgroundColor: backgroundColor});
                                    }
                                }}
                            />
                        }

                        {'gradient' === backgroundColorType &&
                            <div className={'dracula-gradient-picker'}>
                                <GradientPicker
                                    value={isDark ? darkBackgroundColor : lightBackgroundColor}
                                    onChange={backgroundColor => {
                                        if (isDark) {
                                            setData({...data, darkBackgroundColor: backgroundColor});
                                        } else {
                                            setData({...data, lightBackgroundColor: backgroundColor});
                                        }
                                    }}
                                    gradients={[
                                        {
                                            name: 'Gradient 1',
                                            gradient: 'linear-gradient(-225deg, #E3FDF5 0%, #FFE6FA 100%)',
                                            slug: 'gradient-1',
                                        },
                                        {
                                            name: 'Vivid cyan blue to vivid purple',
                                            gradient:
                                                'linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)',
                                            slug: 'vivid-cyan-blue-to-vivid-purple',
                                        },
                                        {
                                            name: 'Light green cyan to vivid green cyan',
                                            gradient:
                                                'linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%)',
                                            slug: 'light-green-cyan-to-vivid-green-cyan',
                                        },
                                        {
                                            name: 'Luminous vivid amber to luminous vivid orange',
                                            gradient:
                                                'linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%)',
                                            slug: 'luminous-vivid-amber-to-luminous-vivid-orange',
                                        },
                                        {
                                            name: 'Luminous vivid orange to vivid red',
                                            gradient:
                                                'linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%)',
                                            slug: 'luminous-vivid-orange-to-vivid-red',
                                        },
                                        {
                                            name: 'Very light gray to cyan bluish gray',
                                            gradient:
                                                'linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%)',
                                            slug: 'very-light-gray-to-cyan-bluish-gray',
                                        },
                                        {
                                            name: 'Cool to warm spectrum',
                                            gradient:
                                                'linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%)',
                                            slug: 'cool-to-warm-spectrum',
                                        },
                                        {
                                            name: 'Gradient 7',
                                            gradient: 'linear-gradient(230deg, #fc6767 25%, #ec008c 100%)',
                                            slug: 'gradient-7',
                                        },
                                        {
                                            name: 'Gradient 8',
                                            gradient: 'linear-gradient(230deg, #1cb5e0 25%, #000046 100%)',
                                            slug: 'gradient-8',
                                        },
                                        {
                                            name: 'Gradient 9',
                                            gradient: 'linear-gradient(230deg, #f7b733 25%, #fc4a1a 100%)',
                                            slug: 'gradient-9',
                                        },
                                    ]}

                                />
                            </div>
                        }

                        <p className="description">{wp.i18n.__('Set the button background color.','dracula-dark-mode')}</p>

                    </div>

                </div>
            </div>

            {/* Border Width */}
            {!isDark &&
                <div className="settings-field">
                    <span className="settings-field-label">{wp.i18n.__('Border Width', 'dracula-dark-mode')}</span>

                    <div className="settings-field-content">
                        <RangeControl
                            value={parseInt(borderWidth)}
                            step={1}
                            onChange={borderWidth => setData({...data, borderWidth: parseInt(borderWidth)})}
                            min={0}
                            max={30}
                            allowReset
                            resetFallbackValue={0}
                            className={'dracula-range-control'}
                        />

                        <p className="description">{wp.i18n.__('Set the border button width.','dracula-dark-mode')}</p>
                    </div>
                </div>
            }

            {/* Border Color */}
            <div className="settings-field">
                <span className="settings-field-label">{wp.i18n.__('Border Color','dracula-dark-mode')}</span>

                <div className="settings-field-content">
                    <ColorPickerWrapper
                        value={isDark ? darkBorderColor : lightBorderColor}
                        onChange={borderColor => {
                            if (isDark) {
                                setData({...data, darkBorderColor: borderColor});
                            } else {
                                setData({...data, lightBorderColor: borderColor});
                            }
                        }}
                    />

                    <p className="description">{wp.i18n.__('Set the border color.','dracula-dark-mode')}</p>
                </div>
            </div>

            {/* Border Radius */}
            {!isDark &&
                <div className="settings-field">
                    <span className="settings-field-label">{wp.i18n.__('Border Radius','dracula-dark-mode')}</span>

                    <div className="settings-field-content">
                        <RangeControl
                            value={parseInt(borderRadius)}
                            step={1}
                            onChange={borderRadius => setData({
                                ...data,
                                borderRadius: parseInt(borderRadius)
                            })}
                            min={0}
                            max={100}
                            allowReset
                            resetFallbackValue={5}
                            className={'dracula-range-control'}
                        />
                        <p className="description">{wp.i18n.__('Set the border radius of the button.','dracula-dark-mode')}</p>
                    </div>
                </div>
            }

        </div>
    )
}