import ToggleBuilderContext from "../../contexts/ToggleBuilderContext";
import Toggle from "../Toggle";
import {Tooltip} from "react-tooltip";
import {copyShortcode} from "../../includes/functions";

const {useContext} = React;

export default function Preview() {

    const context = useContext(ToggleBuilderContext);
    const {data, state} = context;

    const {id} = data;

    return (
        <div className={`form-builder-preview`}>

            <div className={`form-preview state-${state}`}>
                <div className="preview-header">

                    <div className="preview-header-title">
                        <i className="dashicons dashicons-visibility"></i>
                        <span>{wp.i18n.__("Preview", "dracula-dark-mode")}</span>
                    </div>

                    {/* Shortcode */}
                    {id > 0 &&
                        <div className="shortcode-wrap">
                            <i
                                data-tooltip-content={wp.i18n.__('Copy Shortcode', 'dracula-dark-mode')}
                                className="dashicons dashicons-admin-page"
                                onClick={copyShortcode}></i>
                            <Tooltip place="left" effect="solid" className="dracula-tooltip"/>
                            <code onClick={copyShortcode}>{`[dracula_toggle id="${id}"]`}</code>
                        </div>
                    }

                </div>

                <div className="preview-content">
                    <div className="dracula-toggle-wrap custom-toggle">
                        <Toggle data={data} previewMode={state} isPreview/>
                    </div>
                </div>
            </div>

        </div>

    )
}