import ToggleBuilderContext from "../../contexts/ToggleBuilderContext";

const {useContext} = React;

export default function Layout() {

    const context = useContext(ToggleBuilderContext);
    const {data, setData, state, setState} = context;

    const {layout} = data;

    const isDark = 'dark' === state;

    const layouts = [
        {
            id: 1,
            config: {
                lightIcon: 1,
                darkIcon: 11,
                lightBackgroundColor: '#EEE',
                darkBackgroundColor: '#00288F',
                lightTextColor: '#4B5D8A',
                darkTextColor: '#FFFFFF',
                width: 50,
                padding: 10,

                borderWidth: 0,
                borderRadius: 10,
            }
        },
        {
            id: 2,
            config: {
                width: 'auto',
                lightIcon: 1,
                darkIcon: 11,
                lightLabel: wp.i18n.__('Light Mode', 'dracula-dark-mode'),
                darkLabel: wp.i18n.__('Dark Mode', 'dracula-dark-mode'),
                showIcon: true,
                iconPosition: 'after',
                textSize: 15,
                iconSpacing: 7,
                padding: 10,

                lightBackgroundColor: '#61CE70',
                darkBackgroundColor: '#484D60',
                lightTextColor: '#FFFFFF',
                darkTextColor: '#FFFFFF',

                borderRadius: 5,
                borderWidth: 0,

            },
        },
        {
            id: 3,
            config: {
                width: 165,
                lightIcon: 27,
                darkIcon: 11,
                lightLabel: wp.i18n.__('Light', 'dracula-dark-mode'),
                darkLabel: wp.i18n.__('Dark', 'dracula-dark-mode'),
                textSize: 15,
                iconSpacing: 10,
                padding: 7,

                lightBackgroundColor: '#859EF7',
                darkBackgroundColor: '#484D60',
                lightTextColor: '#555555',
                darkTextColor: '#FFFFFF',

                borderRadius: 100,
                borderWidth: 0,

            },
        },
        {
            id: 4,
            config: {
                width: 'auto',
                lightIcon: 1,
                darkIcon: 11,
                lightLabel: wp.i18n.__('Light', 'dracula-dark-mode'),
                darkLabel: wp.i18n.__('Dark', 'dracula-dark-mode'),
                lightTextColor: '#484D60',
                darkTextColor: '#FFFFFF',
                lightBackgroundColor: '#EEE',
                darkBackgroundColor: '#484D60',
                iconSpacing: 15,
                padding: 10,

                borderWidth: 0,
                borderRadius: 30,
            },
        },
        {
            id: 5,
            config: {
                width: 80,
                lightIcon: 27,
                darkIcon: 11,
                lightLabel: wp.i18n.__('Light Mode', 'dracula-dark-mode'),
                darkLabel: wp.i18n.__('Dark Mode', 'dracula-dark-mode'),
                lightTextColor: '#484D60',
                darkTextColor: '#FFFFFF',
                lightBackgroundColor: '#EEE',
                darkBackgroundColor: '#484D60',
                iconSpacing: 15,
                padding: 5,
                textSize: 15,

                borderWidth: 0,
                borderRadius: 30,
            },
        },
    ];

    return (
        <div className="settings-layout">
            <h4 className={`settings-header`}>{wp.i18n.__('Choose button layout', 'dracula-dark-mode')}</h4>
            <div className={`toggle-layouts state-${state}`}>
                {
                    layouts.map(item => {
                        const {id, config} = item;

                        const isActive = id == layout;
                        const src = dracula.pluginUrl + `/assets/images/layouts/layout${id}-${isDark ? 'dark' : 'light'}.svg`;

                        return (
                            <div key={id} className={`layout-wrap layout-${id} ${isActive ? 'active' : ''} `} onClick={() => setData({...data, ...config, layout: id})}>
                                <span className="layout-index">{id}</span>
                                <img src={src} className="layout-icon"/>

                                {isActive && <i className="active-badge dashicons dashicons-saved"></i>}

                            </div>
                        )
                    })
                }
            </div>
        </div>
    )
}