import ToggleBuilderContext from "../../contexts/ToggleBuilderContext";
import Content from "./Content";
import Style from "./Style";
import Layout from "./Layout";

const {
    __experimentalRadioGroup: RadioGroup,
    __experimentalRadio: Radio,
} = wp.components;

const {useState, useContext} = React;

export default function FormBuilder() {
    const context = useContext(ToggleBuilderContext);

    const [tab, setTab] = useState('layout');

    const {data, setData, state, setState} = context;

    function copyShortcode(e) {
        const element = e.target.parentNode.querySelector('code');

        window.getSelection().selectAllChildren(element);
        const copyText = element.innerHTML;
        navigator.clipboard.writeText(copyText);

        Swal.fire({
            title: wp.i18n.__('Copied', "dracula-dark-mode"),
            text: wp.i18n.__('Shortcode copied to clipboard', "dracula-dark-mode"),
            icon: 'success',
            showConfirmButton: false,
            timer: 2000,
            timerProgressBar: true,
            toast: true,
            customClass: {
                container: 'dracula-swal',
            },
        });
    }

    const {id, title} = data;

    return (
        <div className="form-builder">

            <div className="form-builder-body">

                <div className="form-builder-tabs">
                    <RadioGroup label="Tabs" checked={tab} onChange={tab => setTab(tab)}
                                className="dracula-button-group">
                        <Radio value="layout">
                            <span className="dracula-btn-icon icon-layout"></span>
                            <span>{wp.i18n.__('Layout', "dracula-dark-mode")}</span>
                        </Radio>
                        <Radio value="edit">
                            <span className="dracula-btn-icon icon-content"></span>
                            <span>{wp.i18n.__('Content', "dracula-dark-mode")}</span>
                        </Radio>
                        <Radio value="style">
                            <span className="dracula-btn-icon icon-style"></span>
                            <span>{wp.i18n.__('Style', "dracula-dark-mode")}</span>
                        </Radio>
                    </RadioGroup>

                    <RadioGroup checked={state} onChange={state => setState(state)}  className="dracula-button-group">
                        <Radio value="light">
                            <span className="dracula-btn-icon icon-light"></span>
                            <span>{wp.i18n.__('Light Mode', "dracula-dark-mode")}</span>
                        </Radio>
                        <Radio value="dark">
                            <span className="dracula-btn-icon icon-dark"></span>
                            <span>{wp.i18n.__('Dark Mode', "dracula-dark-mode")}</span>
                        </Radio>
                    </RadioGroup>
                </div>

                <div className="form-builder-settings">

                    {tab === 'layout' && <Layout/>}
                    {tab === 'edit' && <Content/>}
                    {tab === 'style' && <Style/>}

                </div>
            </div>
        </div>
    )
}
