import ToggleBuilderContext from "../../contexts/ToggleBuilderContext";

const {
    __experimentalRadioGroup: RadioGroup,
    __experimentalRadio: Radio,
    TextControl,
    FormToggle,
} = wp.components;

const {useContext, useRef} = React;

export default function Content() {

    const context = useContext(ToggleBuilderContext);

    const {data, setData, state} = context;

    const {
        layout,
        lightLabel,
        darkLabel,
        showIcon,
        lightIcon,
        darkIcon,
        iconPosition,
        alignment,
        className,
        customDarkIcon,
        customLightIcon,
        showTooltip,
        tooltipText = 'Toggle Dark Mode',
        darkTooltipText = 'Toggle Light Mode',
    } = data;

    const isDark = 'dark' === state;

    const frameRef = useRef();

    const selectSVG = () => {

        if (frameRef.current) {
            frameRef.current.off('select');

            frameRef.current.on('select', () => {
                const attachment = frameRef.current.state().get('selection').first().toJSON();

                if (isDark) {
                    setData({
                        ...data,
                        customDarkIcon: attachment.url,
                        darkIcon: 0,
                    });
                } else {
                    setData({
                        ...data,
                        customLightIcon: attachment.url,
                        lightIcon: 0,
                    });
                }

            }).open();
            return;
        }

        frameRef.current = wp.media({
            title: 'Select SVG Image',
            button: {text: 'Use this Image'},
            multiple: false,
            library: {type: 'image/svg+xml'},
        });

        frameRef.current.on('select', () => {

            const attachment = frameRef.current.state().get('selection').first().toJSON();
            if (isDark) {
                setData({
                    ...data,
                    customDarkIcon: attachment.url,
                    darkIcon: 0,
                });
            } else {
                setData({
                    ...data,
                    customLightIcon: attachment.url,
                    lightIcon: 0,
                });
            }
        }).open();
    }

    return (
        <div className="settings-content">
            <h4 className={`settings-header`}>{wp.i18n.__('Content Settings', 'dracula-dark-mode')}</h4>

            {/* Button Text */}
            {[2, 3, 4, 5, 6].includes(layout) &&
                <div className="settings-field">
                    <span className="settings-field-label">
                        {wp.i18n.__(`Button Text`, 'dracula-dark-mode')}
                    </span>

                    <div className="settings-field-content">
                        <TextControl
                            value={isDark ? darkLabel : lightLabel}
                            onChange={label => {
                                if (isDark) {
                                    setData({...data, darkLabel: label});
                                } else {
                                    setData({...data, lightLabel: label});
                                }
                            }}
                        />

                        <p className="description">{wp.i18n.__(`Enter the text for the button.`, 'dracula-dark-mode')}</p>
                    </div>
                </div>
            }

            {/* Show Icon */}
            {!isDark && [2].includes(layout) &&
                <div className="settings-field">
                    <span className="settings-field-label">{wp.i18n.__('Show Icon', 'dracula-dark-mode')}</span>

                    <div className="settings-field-content">
                        <FormToggle
                            checked={showIcon}
                            onChange={() => setData({...data, showIcon: !showIcon})}
                        />

                        <p className="description">{wp.i18n.__('Show/ hide the button icon.', 'dracula-dark-mode')}</p>
                    </div>
                </div>
            }

            {/* Choose Icon */}
            {(([2].includes(layout) && showIcon) || ![2].includes(layout)) &&
                <div className="settings-field choose-icon">
                    <span className="settings-field-label">{wp.i18n.__('Choose Icon', 'dracula-dark-mode')}</span>
                    <p className="description">{wp.i18n.__('Choose the button icon. You can also upload your own SVG icon.', 'dracula-dark-mode')}</p>

                    <div className="settings-field-content">

                        <div className="toggle-icons">
                            {
                                [...Array(27).keys()].map(i => {
                                        const index = i + 1;
                                        const isActive = index === (isDark ? darkIcon : lightIcon);

                                        const src = dracula.pluginUrl + `/assets/images/icons/${index}.svg`;

                                        return (
                                            <div key={i} className={`icon-wrap ${isActive ? 'active' : ''} `}
                                                 onClick={() => {
                                                     if (isDark) {
                                                         setData({...data, darkIcon: index});
                                                     } else {
                                                         setData({...data, lightIcon: index});
                                                     }
                                                 }}>
                                                <span className="icon-index">{index}</span>
                                                <img src={src} className="toggle-icon"/>
                                            </div>
                                        )
                                    }
                                )
                            }
                        </div>

                        <div className="svg-upload-btns">
                            <button type={`button`} className={`dracula-btn btn-primary upload-svg-btn`}
                                    onClick={selectSVG}>
                                <span className="dracula-btn-icon icon-upload"></span>
                                <span>{wp.i18n.__('Upload SVG', 'dracula-dark-mode')}</span>
                            </button>

                            {
                                ((!isDark && customLightIcon) || (isDark && customDarkIcon)) &&
                                <button type={`button`} className={`dracula-btn btn-danger`}
                                        onClick={() => {
                                            if (isDark) {
                                                setData({...data, customDarkIcon: null});
                                            } else {
                                                setData({...data, customLightIcon: null});
                                            }
                                        }}
                                >
                                    <i className="dashicons dashicons-trash"></i>
                                    <span>{wp.i18n.__('Remove', 'dracula-dark-mode')}</span>
                                </button>
                            }

                        </div>

                        {
                            ((!isDark && customLightIcon) || (isDark && customDarkIcon)) &&
                            <div className={`svg-preview ${customLightIcon || customDarkIcon ? 'active' : ''}`}>
                                <img src={isDark ? customDarkIcon : customLightIcon}/>
                            </div>
                        }

                    </div>

                </div>
            }

            {/* Icon Position */}
            {!isDark && [2, 5].includes(layout) && (([2].includes(layout) && showIcon) || ![2].includes(layout)) &&
                <div className="settings-field">
                    <span className="settings-field-label">{wp.i18n.__('Icon Position', 'dracula-dark-mode')}</span>

                    <div className="settings-field-content">
                        <RadioGroup
                            label="Icon Position" checked={iconPosition}
                            onChange={iconPosition => setData(data => ({...data, iconPosition}))}
                            className="dracula-radio-group"
                        >
                            <Radio value="before">{wp.i18n.__('Before', 'dracula-dark-mode')}</Radio>
                            <Radio value="after">{wp.i18n.__('After', 'dracula-dark-mode')}</Radio>
                        </RadioGroup>

                        <p className="description">{wp.i18n.__('Set the icon position.', 'dracula-dark-mode')}</p>
                    </div>
                </div>
            }

            {/* Show Tooltip */}
            <div className="settings-field field-show-tooltip">
                <span className="settings-field-label">{wp.i18n.__('Show Tooltip', 'dracula-dark-mode')}</span>
                <div className="settings-field-content">
                    <FormToggle
                        checked={showTooltip}
                        onChange={() => setData({...data, showTooltip: !showTooltip})}
                    />

                    <p className="description">{wp.i18n.__('Show/ hide the toggle button tooltip text.', 'dracula-dark-mode')}</p>

                    {showTooltip &&
                        <div className="settings-field-sub">
                            {/* Tooltip Text */}
                            <div className="settings-field">
                                    <span
                                        className="settings-field-label">{wp.i18n.__('Tooltip Text', 'dracula-dark-mode')}</span>
                                <div className="settings-field-content">
                                    <TextControl
                                        value={isDark ? data.darkTooltipText : data.tooltipText}
                                        onChange={(value) => {
                                            if (isDark) {
                                                setData({
                                                    ...data,
                                                    darkTooltipText: value
                                                });
                                            } else {
                                                setData({
                                                    ...data,
                                                    tooltipText: value
                                                });
                                            }
                                        }}
                                        className={`dracula-text-control`}
                                    />

                                    <p className="description">{wp.i18n.__('Enter the toggle switch button tooltip text.', 'dracula-dark-mode')}</p>
                                </div>
                            </div>

                        </div>
                    }

                </div>

            </div>

            {/* Class */}
            <div className="settings-field">
                <span className="settings-field-label">
                    {wp.i18n.__('Button Classes', 'dracula-dark-mode')}
                </span>

                <div className="settings-field-content">
                    <TextControl
                        value={className}
                        onChange={className => setData(data => ({...data, className}))}
                    />

                    <p className="description">{wp.i18n.__('Add custom classes to the button.', 'dracula-dark-mode')}</p>
                </div>
            </div>

        </div>
    )
}