import {showProModal} from "../ProModal";
import {initToggles} from "../../includes/functions";

const {useState, useEffect} = React;

export default function Toggles({value, onChange, attentionEffect}) {

    const $ = window.jQuery;

    const {isPro, customToggles = []} = dracula;

    const [active, setActive] = useState(value);
    const [hoverItem, setHoverItem] = useState(null);

    // Render toggles
    useEffect(() => {
        initToggles();
    }, []);

    // Handle toggle selection hover effect
    useEffect(() => {
        $(`.toggles .dracula-toggle`).removeClass('mode-dark');

        if (!hoverItem) return;

        $(`.toggles .toggle-wrap[data-style="${hoverItem}"] .dracula-toggle`).addClass('mode-dark');

    }, [hoverItem]);

    return (
        <div className="toggles">
            {
                [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18].map((style, index) => {
                    const isActive = active == style;

                    return (
                        <div
                            className={`toggle-wrap dracula-ignore ${isActive ? 'active' : ''} ${!isPro && style > 2 ? 'disabled' : ''}`}
                            key={index}
                            onMouseEnter={() => {
                                setHoverItem(style);
                            }}
                            onMouseLeave={() => {
                                setHoverItem(null);
                            }}
                            onClick={() => {

                                if (!isPro && style > 2) {
                                    showProModal(wp.i18n.__('This style is only available in the Pro version.', "dracula-dark-mode"));
                                    return;
                                }

                                setActive(style);
                                onChange(style);
                            }}
                            data-style={style}
                        >
                            <span className="index-label">{style}</span>

                            <div className="dracula-toggle-wrap" data-style={style}></div>

                            {!isPro && style > 2 &&
                                <div className="pro-label">
                                    <i className={`dracula-icon icon-pro`}/>
                                    <span>{wp.i18n.__('PRO', 'dracula-dark-mode')}</span>
                                </div>
                            }

                            {isActive && <i className="active-badge dashicons dashicons-saved"></i>}

                        </div>
                    )
                })
            }

            {/* Custom Toggles */}
            {isPro && !!customToggles.length &&
                <>
                    <h3 className={`custom-toggle-heading`}>{wp.i18n.__("Custom Toggles", "dracula-dark-mode")}</h3>

                    {
                        customToggles.map(item => {
                            const {id, title, config} = item;

                            const data = btoa(JSON.stringify(config));

                            const isActive = active == 'custom-' + id;

                            return (
                                <div
                                    key={id}
                                    className={`toggle-wrap dracula-ignore ${isActive ? 'active' : ''}`}
                                    onClick={() => {
                                        onChange('custom-' + id, config);
                                        setActive('custom-' + id);
                                    }}
                                    onMouseEnter={() => {
                                        setHoverItem(id);
                                    }}
                                    onMouseLeave={() => {
                                        setHoverItem(null);
                                    }}
                                    data-id={id}
                                >
                                    <span className="index-label">{title}</span>

                                    <div className="dracula-toggle-wrap custom-toggle" data-id={id}
                                         data-data={data}></div>

                                    {isActive && <i className="active-badge dashicons dashicons-saved"></i>}

                                </div>
                            )
                        })
                    }
                </>
            }

        </div>
    )
}