import {Tooltip} from "react-tooltip";
import SettingsContext from "../../contexts/SettingsContext";
import {showProModal} from "../ProModal";
import Select from "react-select";
const {FormToggle, CheckboxControl } = wp.components;

const { useContext, useState, useEffect, useRef } = React;

export default function ReadingModeExcludeSettings() {
    const {isPro} = dracula;
    
    const context = useContext(SettingsContext);

    const excludeList = [];

    if (!isLiveEdit) {
        Object.keys(dracula.excludeReadingList).forEach(key => {
            const options = dracula.excludeReadingList[key].options;
            excludeList.push({
                label: dracula.excludeReadingList[key].label,
                options: Object.keys(options).map(key => {
                    return {
                        label: options[key],
                        value: key,
                    };
                })
            });
        });
    }

    const excludeTaxList = [];

    if (!isLiveEdit) {
        Object.keys(dracula.excludeTaxList).forEach(key => {
            const options = dracula.excludeTaxList[key].options;
            excludeTaxList.push({
                label: dracula.excludeTaxList[key].label,
                options: Object.keys(options).map(key => {
                    return {
                        label: options[key],
                        value: key,
                    };
                })
            });
        });
    }

    const { data, setData, isLiveEdit } = context;
    
    const {
        excludeReadingModePages = [],
        excludeReadingModeAll = false,
        excludeReadingModeExceptPages = [],
        excludeReadingModeTaxs = [],
        excludeReadingModeAllTaxs = false,
        excludeReadingModeExceptTaxs = [],
    } = data;

    const allOptions = excludeList.reduce((acc, cur) => {
        return acc.concat(cur.options);
    }, []);

    const allTaxOptions = excludeTaxList.reduce((acc, cur) => {
        return acc.concat(cur.options);
    }, []);

    return (
        <>
            {/* Reading Mode excludes */}
            <div className={`settings-field reading-mode-exclude ${!dracula.isPro ? 'pro-feature' : ''}`}>
                <h4 className={`settings-field-label`}>
                    {wp.i18n.__('Exclude Posts/ Pages', 'dracula-dark-mode')}
                    {!isPro && <span className="dracula-pro-icon"><i className={`dracula-icon icon-pro`}/></span>}
                </h4>
                <div className="settings-field-content">

                    <div className="settings-wrap"
                        data-tooltip-id={`exclude-reading-mode`}
                        data-tooltip-content={!dracula.isPro ? wp.i18n.__('PRO Feature', 'dracula-dark-mode') : ''}
                        onClick={() => !dracula.isPro && showProModal(wp.i18n.__('Exclude Pages is a PRO feature. Please upgrade to PRO version to use this feature.', 'dracula-dark-mode'))}>
                        <Select
                            isDisabled={!dracula.isPro || excludeReadingModeAll}
                            isMulti={true}
                            options={excludeList}
                            className={'dracula-select'}
                            classNamePrefix={'dracula-select'}
                            onChange={selected => {
                                if (!dracula.isPro) {
                                    showProModal();
                                    return;
                                }
                                setData({ ...data, excludeReadingModePages: selected.map(item => item.value) })
                            }}
                            value={
                                !!allOptions.length &&
                                excludeReadingModePages.map(item => ({
                                    value: item,
                                    label: allOptions.find(option => option.value === item).label,
                                }))
                            }
                            placeholder={'Search & select posts/ pages'}
                        />
                    </div>

                    {!dracula.isPro && <Tooltip id={`exclude-reading-mode`} variant="warning" effect="solid" place="right" backgroundColor="#ff9966" />}

                    <p className="description">{wp.i18n.__('Search and select the posts/ pages that you want to exclude from the reading mode.', 'dracula-dark-mode')}</p>

                    <div className="excludes-except">
                        <span className="exclude-all-label">{wp.i18n.__('Exclude All : ', 'dracula-dark-mode')}</span>

                        <FormToggle
                            data-tooltip-id={`exclude-reading-mode-all`}
                            data-tooltip-content={!dracula.isPro ? wp.i18n.__('PRO Feature', 'dracula-dark-mode') : ''}
                            checked={excludeReadingModeAll}
                            onChange={() => {
                                if (!dracula.isPro) {
                                    showProModal(wp.i18n.__('Exclude Pages is a PRO feature. Please upgrade to PRO version to use this feature.', 'dracula-dark-mode'));
                                    return;
                                }

                                setData({ ...data, excludeReadingModeAll: !excludeReadingModeAll })
                            }}
                        />

                        {!dracula.isPro && <Tooltip id={`exclude-reading-mode-all`} variant="warning" effect="solid" place="right" backgroundColor="#ff9966" />}

                        <span className="exclude-except-label"> {wp.i18n.__('Except : ', 'dracula-dark-mode')}</span>

                        <div className="settings-wrap"
                            data-tooltip-id={`exclude-reading-mode-except`}
                            data-tooltip-content={!dracula.isPro ? wp.i18n.__('PRO Feature', 'dracula-dark-mode') : ''}
                            onClick={() => !dracula.isPro && showProModal(wp.i18n.__('Exclude Pages is a PRO feature. Please upgrade to PRO version to use this feature.', 'dracula-dark-mode'))}>
                            <Select
                                isMulti={true}
                                options={excludeList}
                                className={'dracula-select'}
                                classNamePrefix={'dracula-select'}
                                onChange={selected => {
                                    setData({ ...data, excludeReadingModeExceptPages: selected.map(item => item.value) })
                                }}
                                value={
                                    !!allOptions.length &&
                                    excludeReadingModeExceptPages.map(item => ({
                                        value: item,
                                        label: allOptions.find(option => option.value === item).label,
                                    }))
                                }
                                placeholder={wp.i18n.__('Search and select posts/pages', 'dracula-dark-mode')}
                                isDisabled={!dracula.isPro || !excludeReadingModeAll}
                            />
                        </div>

                        {!dracula.isPro && <Tooltip id={`exclude-reading-mode-except`} variant="warning" effect="solid" place="right" backgroundColor="#ff9966" />}
                    </div>

                </div>
            </div>
            
            {/* Reading Mode taxonomies excludes */}
            <div className={`settings-field reading-mode-exclude ${!dracula.isPro ? 'pro-feature' : ''}`}>
                <h4 className={`settings-field-label`}>
                    {wp.i18n.__('Exclude Taxonomies', 'dracula-dark-mode')}
                    {!isPro && <span className="dracula-pro-icon"><i className={`dracula-icon icon-pro`}/></span>}
                </h4>
                <div className="settings-field-content">

                    <div className="settings-wrap"
                        data-tooltip-id={`exclude-reading-mode-taxs`}
                        data-tooltip-content={!dracula.isPro ? wp.i18n.__('PRO Feature', 'dracula-dark-mode') : ''}
                        onClick={() => !dracula.isPro && showProModal(wp.i18n.__('Exclude Taxonomies is a PRO feature. Please upgrade to PRO version to use this feature.', 'dracula-dark-mode'))}>
                        <Select
                            isDisabled={!dracula.isPro || excludeReadingModeAllTaxs}
                            isMulti={true}
                            options={excludeTaxList}
                            className={'dracula-select'}
                            classNamePrefix={'dracula-select'}
                            onChange={selected => {
                                if (!dracula.isPro) {
                                    showProModal();
                                    return;
                                }
                                setData({ ...data, excludeReadingModeTaxs: selected.map(item => item.value) })
                            }}
                            value={
                                !!allTaxOptions.length &&
                                excludeReadingModeTaxs.map(item => ({
                                    value: item,
                                    label: allTaxOptions.find(option => option.value === item).label,
                                }))
                            }
                            placeholder={wp.i18n.__('Search & select categories/ tags', 'dracula-dark-mode')}
                        />
                    </div>

                    {!dracula.isPro && <Tooltip id={`exclude-reading-mode-taxs`} variant="warning" effect="solid" place="right" backgroundColor="#ff9966" />}

                    <p className="description">{wp.i18n.__('Search and select the posts/ pages that you want to exclude from the reading mode.', 'dracula-dark-mode')}</p>

                    <div className="excludes-except">
                        <span className="exclude-all-label">{wp.i18n.__('Exclude All : ', 'dracula-dark-mode')}</span>

                        <FormToggle
                            disabled={!dracula.isPro}
                            data-tooltip-id={`exclude-reading-mode-all-taxs`}
                            data-tooltip-content={!dracula.isPro ? wp.i18n.__('PRO Feature', 'dracula-dark-mode') : ''}
                            checked={excludeReadingModeAllTaxs}
                            onChange={() => {
                                if (!dracula.isPro) {
                                    showProModal(wp.i18n.__('Exclude Pages is a PRO feature. Please upgrade to PRO version to use this feature.', 'dracula-dark-mode'));
                                    return;
                                }

                                setData({ ...data, excludeReadingModeAllTaxs: !excludeReadingModeAllTaxs })
                            }}
                        />

                        {!dracula.isPro && <Tooltip id={`exclude-reading-mode-all-taxs`} variant="warning" effect="solid" place="right" backgroundColor="#ff9966" />}

                        <span className="exclude-except-label"> {wp.i18n.__('Except : ', 'dracula-dark-mode')}</span>

                        <div className="settings-wrap"
                            data-tooltip-id={`exclude-reading-mode-except-taxs`}
                            data-tooltip-content={!dracula.isPro ? wp.i18n.__('PRO Feature', 'dracula-dark-mode') : ''}
                            onClick={() => !dracula.isPro && showProModal(wp.i18n.__('Exclude Pages is a PRO feature. Please upgrade to PRO version to use this feature.', 'dracula-dark-mode'))}>
                            <Select
                                isMulti={true}
                                options={excludeTaxList}
                                className={'dracula-select'}
                                classNamePrefix={'dracula-select'}
                                onChange={selected => {
                                    setData({ ...data, excludeReadingModeExceptTaxs: selected.map(item => item.value) })
                                }}
                                value={
                                    !!allTaxOptions.length &&
                                    excludeReadingModeExceptTaxs.map(item => ({
                                        value: item,
                                        label: allTaxOptions.find(option => option.value === item).label,
                                    }))
                                }
                                placeholder={wp.i18n.__('Search & select categories/ tags', 'dracula-dark-mode')}
                                isDisabled={!dracula.isPro || !excludeReadingModeAllTaxs}
                            />
                        </div>

                        {!dracula.isPro && <Tooltip id={`exclude-reading-mode-except-taxs`} variant="warning" effect="solid" place="right" backgroundColor="#ff9966" />}
                    </div>

                </div>
            </div>
        </>
    );
}