import Header from "./Header"
import GeneralReadingSettings from "./GeneralReadingSettings";
import ReadingModeButtonSettings from "./ReadingModeButtonSettings";
import ReadingModeLayoutSettings from "./ReadingModeLayoutSettings";
import ReadingModeExcludeSettings from "./ReadingModeExcludeSettings";
import SettingsContext from "../../contexts/SettingsContext";

const { useContext, useState } = React;

const{Button} = wp.components;

export default function Reading(){
    
    const context = useContext(SettingsContext);
    
    const { data, setData } = context;

    const [innerTab, setInnerTab] = useState('general');

    let docUrl = 'https://softlabbd.com/docs/how-to-enable-reading-mode/';

    return (
        <div className="dracula-settings-content">

            <Header title={wp.i18n.__('Reading Mode Settings', 'dracula-dark-mode')}/>

            <div className="inner-tabs">
                <Button
                    type="button"
                    className={`tab-item dracula-btn ${innerTab === 'general' ? 'active' : ''}`}
                    onClick={() => setInnerTab('general')}
                    icon={<span className="dracula-btn-icon icon-reading-mode"></span>}
                    text={wp.i18n.__('General', 'dracula-dark-mode')}
                />

                <Button
                    type="button"
                    className={`tab-item dracula-btn ${innerTab === 'reading' ? 'active' : ''}`}
                    onClick={() => setInnerTab('reading')}
                    icon={<span className="dracula-btn-icon icon-reading-button"></span>}
                    text={wp.i18n.__('Reading Mode Button', 'dracula-dark-mode')}
                />

                <Button
                    type="button"
                    className={`tab-item dracula-btn ${innerTab === 'layout' ? 'active' : ''}`}
                    onClick={() => setInnerTab('layout')}
                    icon={<span className="dracula-btn-icon icon-reading-layout"></span>}
                    text={wp.i18n.__('Reading Mode Layout', 'dracula-dark-mode')}
                />

                <Button
                    type="button"
                    className={`tab-item dracula-btn ${innerTab === 'exclude' ? 'active' : ''}`}
                    onClick={() => setInnerTab('exclude')}
                    icon={<span className="dracula-btn-icon icon-reading-exclude"></span>}
                    text={wp.i18n.__('Excludes', 'dracula-dark-mode')}
                />

                <Button
                    className="dracula-btn btn-info doc-btn"
                    href={docUrl}
                    icon={<i className="dashicons dashicons-info"></i>}
                    text={wp.i18n.__('Documentation', 'dracula-dark-mode')}
                    label={wp.i18n.__('View Documentation', 'dracula-dark-mode')}
                />

            </div>

            {/* Show general */}
            { 'general' === innerTab && <GeneralReadingSettings data={data} setData={setData} /> }
            
            {/* Show button */}
            {'reading' === innerTab && <ReadingModeButtonSettings data={data} setData={setData} />}

            {/* Layout */}
            {'layout' === innerTab && <ReadingModeLayoutSettings data={data} setData={setData}/> }
            
            {/* Excludes */}
            {'exclude' === innerTab && <ReadingModeExcludeSettings data={data} setData={setData}/> }

        </div>
    )
}