function VideoPreview({ url, isDark = false }) {
    const dark = isDark ? 'dark' : '';
    
    const generateVideoTag = (url) => {
        const youtubeRegex = /(?:https?:\/\/)?(?:www\.)?(?:youtube\.com\/(?:[^\/\n\s]+\/\S+\/|(?:v|e(?:mbed)?)\/|\S*?[?&]v=)|youtu\.be\/)([a-zA-Z0-9_-]{11})/;
        const dailymotionRegex = /(?:https?:\/\/)?(?:www\.)?dailymotion\.com\/(?:video\/|embed\/)([a-zA-Z0-9]+)/;
        const vimeoRegex = /(?:https?:\/\/)?(?:www\.)?vimeo\.com\/(?:channels\/[A-Za-z0-9]+\/)?([0-9]+)/;
        const videoRegex = /\.(mp4|m4v|webm|ogv|wmv|flv)$/i;

        if (youtubeRegex.test(url)) {
            const videoId = url.match(youtubeRegex)[1];
            return `<iframe src="https://www.youtube.com/embed/${videoId}" frameborder="0" allowfullscreen></iframe>`;
        } else if (dailymotionRegex.test(url)) {
            const videoId = url.match(dailymotionRegex)[1];
            return `<iframe src="https://www.dailymotion.com/embed/video/${videoId}" frameborder="0" allowfullscreen></iframe>`;
        } else if (vimeoRegex.test(url)) {
            const videoId = url.match(vimeoRegex)[1];
            return `<iframe src="https://player.vimeo.com/video/${videoId}" frameborder="0" allow="autoplay; fullscreen" allowfullscreen></iframe>`;
        } else if(videoRegex.test(url)){
            return `<video src=${url} controls preload="auto" ></video>`;
        } else{
            return `<img src="${dracula.pluginUrl}/assets/images/settings/video-placeholder.svg" alt="default icon" />`
        }
    }

    return (
        <div className={`img-preview ${dark}`} dangerouslySetInnerHTML={{ __html: generateVideoTag(url) }}></div>
    );
}
export default VideoPreview;