export default function ReadingModeButtonPreview({data}) {

    const {
        readingModeStyle = 1,
        readingModeLabel = true,
        readingModeText = 'Reading Mode',
        readingModeBGColor = '',
        readingModeTextColor = '',
        readingModeIcon = 1,
        customReadingModeIcon = '',
        buttonSize = 'medium',
        buttonAlignment = 'left',
    } = data;

    let icon = '';
    if (readingModeIcon) {
        icon = `url("../images/icons/reading-mode/${readingModeIcon}.svg") no-repeat center / contain`;
    }

    return (
        <p className={`align-${buttonAlignment}`} style={{
            '--reading-mode-button-alignment': buttonAlignment,
        }}>
            <div
                className={`reading-mode-button style-${readingModeStyle} size-${buttonSize} ${!readingModeLabel ? 'reading-mode-icon-only' : '' }`}
                style={{
                    '--reading-mode-bg-color': readingModeBGColor,
                    '--reading-mode-text-color': readingModeTextColor,
                }}
            >

                {(!!customReadingModeIcon || !!icon) &&
                    <div className={`reading-mode-icon-wrap ${!readingModeLabel ? 'reading-mode-icon-only' : '' }`}>
                        {!!customReadingModeIcon ?
                            <img className="reading-mode-button__icon custom-icon" src={customReadingModeIcon}/>
                            : !!icon ? <span className="reading-mode-button__icon" style={{'--reading-mode-icon': icon}}></span> : ''}
                    </div>
                }
                {
                    !! readingModeLabel &&
                        <span className="reading-mode-button__text">{readingModeText}</span>
                }
            </div>
        </p>
    )
}