import SettingsContext from "../../contexts/SettingsContext";

const {useContext} = React;

export default function Menu({setMenu}) {

    const {isPro} = dracula;

    const items = [
        {
            key: 'general',
            label: wp.i18n.__('General', 'dracula-dark-mode'),
        },

        {
            key: 'advanced',
            label: wp.i18n.__('Advanced', 'dracula-dark-mode'),
        },
        {
            key: 'colors',
            label: wp.i18n.__('Colors Settings', 'dracula-dark-mode'),
        },
        {
            key: 'toggle',
            label: wp.i18n.__('Toggle Switch', 'dracula-dark-mode'),
        },

        {
            key: 'reading',
            label: wp.i18n.__('Reading Mode', 'dracula-dark-mode'),
        },

        {
            key: 'admin',
            label: wp.i18n.__('Admin Dark Mode', 'dracula-dark-mode'),
        },

        {
            key: 'animation',
            label: wp.i18n.__('Animation', 'dracula-dark-mode'),
        },
        {
            key: 'typography',
            label: wp.i18n.__('Typography', 'dracula-dark-mode'),
        },

        {
            key: 'excludes',
            label: wp.i18n.__('Excludes', 'dracula-dark-mode'),
        },
        {
            key: 'images',
            label: wp.i18n.__('Image Settings', 'dracula-dark-mode'),
        },
        {
            key: 'videos',
            label: wp.i18n.__('Video Settings', 'dracula-dark-mode'),
        },
        {
            key: 'css',
            label: wp.i18n.__('Custom CSS', 'dracula-dark-mode'),
        },
        {
            key: 'analytics',
            label: wp.i18n.__('Analytics', 'dracula-dark-mode'),
        },
        {
            key: 'tools',
            label: wp.i18n.__('Tools', 'dracula-dark-mode'),
        },
    ];

    const {menu} = useContext(SettingsContext);

    return (
        <div className="dracula-settings-menu">

            <div className="menu-header">
                <div className="menu-title">
                    <img src={dracula.pluginUrl + '/assets/images/dracula-logo.svg'}/>
                    <span className="plugin-name">{wp.i18n.__('Dracula Dark Mode', 'dracula-dark-mode')}</span>
                    <span className="plugin-version"> - v{dracula.version}</span>
                </div>
            </div>

            {items.map(({key, label}) =>
                <div
                    key={key}
                    className={`menu-item ${menu === key ? 'active' : ''}`}
                    onClick={() => setMenu(key)}>
                    <img src={dracula.pluginUrl + '/assets/images/settings/' + key + '.svg'}/>
                    <span>{label}</span>

                    {!isPro && ['excludes', 'css', 'analytics', 'reading', 'typography', 'animation',].includes(key) && (
                        <span className="dracula-pro-icon"><i className="dracula-icon icon-pro"></i></span>
                    )}

                </div>
            )}
        </div>
    )
}